/*
** ###################################################################
**     Processor:           MKW38A512VFT4
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    MKW39A512RM Rev. 4, 12/2019
**     Version:             rev. 1.2, 2019-11-15
**     Build:               b191122
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MKW38A4
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2019 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2018-06-25)
**         Initial version.
**     - rev. 1.1 (2019-08-14)
**         Remove XACC, SACC, FACSN, FACSS related registers in FTFE
**     - rev. 1.2 (2019-11-15)
**         Add register RXDIG_DFT in XCVR_RX_DIG
**
** ###################################################################
*/

/*!
 * @file MKW38A4.h
 * @version 1.2
 * @date 2019-11-15
 * @brief CMSIS Peripheral Access Layer for MKW38A4
 *
 * CMSIS Peripheral Access Layer for MKW38A4
 */

#ifndef _MKW38A4_H_
#define _MKW38A4_H_                              /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0002U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 48                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M0 SV Hard Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M0 SV Call Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M0 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M0 System Tick Interrupt */

  /* Device specific interrupts */
  DMA0_IRQn                    = 0,                /**< DMA channel 0 transfer complete */
  DMA1_IRQn                    = 1,                /**< DMA channel 1 transfer complete */
  DMA2_IRQn                    = 2,                /**< DMA channel 2 transfer complete */
  DMA3_IRQn                    = 3,                /**< DMA channel 3 transfer complete */
  DSB_IRQn                     = 4,                /**< Data stream */
  FTFE_IRQn                    = 5,                /**< Command complete and read collision, Flash ECC Errors */
  LVD_LVW_DCDC_IRQn            = 6,                /**< Low-voltage detect, low-voltage warning, DCDC */
  LLWU_IRQn                    = 7,                /**< Low leakage wakeup Unit */
  I2C0_IRQn                    = 8,                /**< I2C0 interrupt */
  I2C1_IRQn                    = 9,                /**< I2C1 interrupt */
  SPI0_IRQn                    = 10,               /**< SPI0 single interrupt vector for all sources */
  CAN0_IRQn                    = 11,               /**< FlexCAN0 ORed Error, Bus off, Transmit/Receive Warning, Wake up */
  LPUART0_LPUART1_IRQn         = 12,               /**< LPUART0 or LPUART1 status and error */
  TRNG0_IRQn                   = 13,               /**< TRNG0 interrupt */
  CMT_IRQn                     = 14,               /**< CMT interrupt */
  ADC0_IRQn                    = 15,               /**< ADC0 interrupt */
  CMP0_IRQn                    = 16,               /**< CMP0 interrupt */
  TPM0_IRQn                    = 17,               /**< TPM0 single interrupt vector for all sources */
  TPM1_IRQn                    = 18,               /**< TPM1 single interrupt vector for all sources */
  TPM2_IRQn                    = 19,               /**< TPM2 single interrupt vector for all sources */
  RTC_IRQn                     = 20,               /**< RTC alarm */
  RTC_Seconds_IRQn             = 21,               /**< RTC seconds */
  PIT_IRQn                     = 22,               /**< PIT interrupt */
  LTC0_IRQn                    = 23,               /**< LTC0 interrupt */
  Radio_0_IRQn                 = 24,               /**< BTLE, ZIGBEE, ANT, GENFSK interrupt 0 */
  CAN0_MB_IRQn                 = 25,               /**< FlexCAN0 ORed Message Buffer (MB0-31) interrupt */
  Radio_1_IRQn                 = 26,               /**< BTLE, ZIGBEE, ANT, GENFSK interrupt 1 */
  MCG_IRQn                     = 27,               /**< MCG interrupt */
  LPTMR0_IRQn                  = 28,               /**< LPTMR0 interrupt */
  SPI1_IRQn                    = 29,               /**< SPI1 single interrupt vector for all sources */
  PORTA_IRQn                   = 30,               /**< PORTA Pin detect */
  PORTB_PORTC_IRQn             = 31                /**< PORTB and PORTC Pin detect */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M0 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M0 Core Configuration
 * @{
 */

#define __CM0PLUS_REV                  0x0000    /**< Core revision r0p0 */
#define __MPU_PRESENT                  0         /**< Defines if an MPU is present or not */
#define __VTOR_PRESENT                 1         /**< Defines if VTOR is present or not */
#define __NVIC_PRIO_BITS               2         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */

#include "core_cm0plus.h"              /* Core Peripheral Access Layer */
#include "system_MKW38A4.h"            /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup edma_request
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the DMA0 hardware request
 *
 * Defines the enumeration for the DMA0 hardware request collections.
 */
typedef enum _dma_request_source
{
    kDmaRequestMux0Disable          = 0|0x100U,    /**< DMAMUX TriggerDisabled */
    kDmaRequestMux0Reserved1        = 1|0x100U,    /**< Reserved1 */
    kDmaRequestMux0LPUART0Rx        = 2|0x100U,    /**< LPUART0 Receive */
    kDmaRequestMux0LPUART0Tx        = 3|0x100U,    /**< LPUART0 Transmit */
    kDmaRequestMux0LPUART1Rx        = 4|0x100U,    /**< LPUART1 Receive */
    kDmaRequestMux0LPUART1Tx        = 5|0x100U,    /**< LPUART1 Transmit */
    kDmaRequestMux0Reserved6        = 6|0x100U,    /**< Reserved6 */
    kDmaRequestMux0Reserved7        = 7|0x100U,    /**< Reserved7 */
    kDmaRequestMux0CAN0             = 8|0x100U,    /**< FlexCAN0 */
    kDmaRequestMux0Reserved9        = 9|0x100U,    /**< Reserved9 */
    kDmaRequestMux0Reserved10       = 10|0x100U,   /**< Reserved10 */
    kDmaRequestMux0Radio            = 11|0x100U,   /**< 2.4G Radio GFSK DMA or XCVR DMA */
    kDmaRequestMux0Reserved12       = 12|0x100U,   /**< Reserved12 */
    kDmaRequestMux0Reserved13       = 13|0x100U,   /**< Reserved13 */
    kDmaRequestMux0Reserved14       = 14|0x100U,   /**< Reserved14 */
    kDmaRequestMux0Reserved15       = 15|0x100U,   /**< Reserved15 */
    kDmaRequestMux0SPI0Rx           = 16|0x100U,   /**< SPI0 Receive */
    kDmaRequestMux0SPI0Tx           = 17|0x100U,   /**< SPI0 Transmit */
    kDmaRequestMux0SPI1Rx           = 18|0x100U,   /**< SPI1 Receive */
    kDmaRequestMux0SPI1Tx           = 19|0x100U,   /**< SPI1 Transmit */
    kDmaRequestMux0LTC0InputFIFO    = 20|0x100U,   /**< LTC0 Input FIFO */
    kDmaRequestMux0LTC0OutputFIFO   = 21|0x100U,   /**< LTC0 Output FIFO */
    kDmaRequestMux0I2C0             = 22|0x100U,   /**< I2C0 */
    kDmaRequestMux0I2C1             = 23|0x100U,   /**< I2C1 */
    kDmaRequestMux0TPM0Channel0     = 24|0x100U,   /**< TPM0 C0V */
    kDmaRequestMux0TPM0Channel1     = 25|0x100U,   /**< TPM0 C1V */
    kDmaRequestMux0TPM0Channel2     = 26|0x100U,   /**< TPM0 C2V */
    kDmaRequestMux0TPM0Channel3     = 27|0x100U,   /**< TPM0 C3V */
    kDmaRequestMux0Reserved28       = 28|0x100U,   /**< Reserved28 */
    kDmaRequestMux0Reserved29       = 29|0x100U,   /**< Reserved29 */
    kDmaRequestMux0Reserved30       = 30|0x100U,   /**< Reserved30 */
    kDmaRequestMux0Reserved31       = 31|0x100U,   /**< Reserved31 */
    kDmaRequestMux0TPM1Channel0     = 32|0x100U,   /**< TPM1 C0V */
    kDmaRequestMux0TPM1Channel1     = 33|0x100U,   /**< TPM1 C1V */
    kDmaRequestMux0TPM2Channel0     = 34|0x100U,   /**< TPM2 C0V */
    kDmaRequestMux0TPM2Channel1     = 35|0x100U,   /**< TPM2 C1V */
    kDmaRequestMux0Reserved36       = 36|0x100U,   /**< Reserved36 */
    kDmaRequestMux0Reserved37       = 37|0x100U,   /**< Reserved37 */
    kDmaRequestMux0Reserved38       = 38|0x100U,   /**< Reserved38 */
    kDmaRequestMux0Reserved39       = 39|0x100U,   /**< Reserved39 */
    kDmaRequestMux0ADC0             = 40|0x100U,   /**< ADC0 */
    kDmaRequestMux0Reserved41       = 41|0x100U,   /**< Reserved41 */
    kDmaRequestMux0CMP0             = 42|0x100U,   /**< CMP0 */
    kDmaRequestMux0Reserved43       = 43|0x100U,   /**< Reserved43 */
    kDmaRequestMux0Reserved44       = 44|0x100U,   /**< Reserved44 */
    kDmaRequestMux0Reserved45       = 45|0x100U,   /**< Reserved45 */
    kDmaRequestMux0Reserved46       = 46|0x100U,   /**< Reserved46 */
    kDmaRequestMux0CMT              = 47|0x100U,   /**< CMT */
    kDmaRequestMux0Reserved48       = 48|0x100U,   /**< Reserved48 */
    kDmaRequestMux0PortA            = 49|0x100U,   /**< PTA */
    kDmaRequestMux0PortB            = 50|0x100U,   /**< PTB */
    kDmaRequestMux0PortC            = 51|0x100U,   /**< PTC */
    kDmaRequestMux0Reserved52       = 52|0x100U,   /**< Reserved52 */
    kDmaRequestMux0Reserved53       = 53|0x100U,   /**< Reserved53 */
    kDmaRequestMux0TPM0Overflow     = 54|0x100U,   /**< TPM0 */
    kDmaRequestMux0TPM1Overflow     = 55|0x100U,   /**< TPM1 */
    kDmaRequestMux0TPM2Overflow     = 56|0x100U,   /**< TPM2 */
    kDmaRequestMux0Reserved57       = 57|0x100U,   /**< Reserved57 */
    kDmaRequestMux0Reserved58       = 58|0x100U,   /**< Reserved58 */
    kDmaRequestMux0Reserved59       = 59|0x100U,   /**< Reserved59 */
    kDmaRequestMux0AlwaysOn60       = 60|0x100U,   /**< DMAMUX Always Enabled Slot */
    kDmaRequestMux0AlwaysOn61       = 61|0x100U,   /**< DMAMUX Always Enabled Slot */
    kDmaRequestMux0AlwaysOn62       = 62|0x100U,   /**< DMAMUX Always Enabled Slot */
    kDmaRequestMux0AlwaysOn63       = 63|0x100U,   /**< DMAMUX Always Enabled Slot */
} dma_request_source_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC1[2];                            /**< ADC Status and Control Registers 1, array offset: 0x0, array step: 0x4 */
  __IO uint32_t CFG1;                              /**< ADC Configuration Register 1, offset: 0x8 */
  __IO uint32_t CFG2;                              /**< ADC Configuration Register 2, offset: 0xC */
  __I  uint32_t R[2];                              /**< ADC Data Result Register, array offset: 0x10, array step: 0x4 */
  __IO uint32_t CV1;                               /**< Compare Value Registers, offset: 0x18 */
  __IO uint32_t CV2;                               /**< Compare Value Registers, offset: 0x1C */
  __IO uint32_t SC2;                               /**< Status and Control Register 2, offset: 0x20 */
  __IO uint32_t SC3;                               /**< Status and Control Register 3, offset: 0x24 */
  __IO uint32_t OFS;                               /**< ADC Offset Correction Register, offset: 0x28 */
  __IO uint32_t PG;                                /**< ADC Plus-Side Gain Register, offset: 0x2C */
  __IO uint32_t MG;                                /**< ADC Minus-Side Gain Register, offset: 0x30 */
  __IO uint32_t CLPD;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x34 */
  __IO uint32_t CLPS;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x38 */
  __IO uint32_t CLP4;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x3C */
  __IO uint32_t CLP3;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x40 */
  __IO uint32_t CLP2;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x44 */
  __IO uint32_t CLP1;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x48 */
  __IO uint32_t CLP0;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x4C */
       uint8_t RESERVED_0[4];
  __IO uint32_t CLMD;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x54 */
  __IO uint32_t CLMS;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x58 */
  __IO uint32_t CLM4;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x5C */
  __IO uint32_t CLM3;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x60 */
  __IO uint32_t CLM2;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x64 */
  __IO uint32_t CLM1;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x68 */
  __IO uint32_t CLM0;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x6C */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name SC1 - ADC Status and Control Registers 1 */
/*! @{ */
#define ADC_SC1_ADCH_MASK                        (0x1FU)
#define ADC_SC1_ADCH_SHIFT                       (0U)
/*! ADCH - Input channel select
 *  0b00000..When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is selected as input.
 *  0b00001..When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is selected as input.
 *  0b00010..When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is selected as input.
 *  0b00011..When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is selected as input.
 *  0b00100..When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
 *  0b00101..When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
 *  0b00110..When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
 *  0b00111..When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
 *  0b01000..When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
 *  0b01001..When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
 *  0b01010..When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
 *  0b01011..When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
 *  0b01100..When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
 *  0b01101..When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
 *  0b01110..When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
 *  0b01111..When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
 *  0b10000..When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
 *  0b10001..When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
 *  0b10010..When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
 *  0b10011..When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
 *  0b10100..When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
 *  0b10101..When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
 *  0b10110..When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
 *  0b10111..When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
 *  0b11000..Reserved.
 *  0b11001..Reserved.
 *  0b11010..When DIFF=0, Temp Sensor (single-ended) is selected as input; when DIFF=1, Temp Sensor (differential) is selected as input.
 *  0b11011..When DIFF=0, Bandgap (single-ended) is selected as input; when DIFF=1, Bandgap (differential) is selected as input.
 *  0b11100..Reserved.
 *  0b11101..When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH (differential) is selected as input.
 *           Voltage reference selected is determined by SC2[REFSEL].
 *  0b11110..When DIFF=0,VREFSL is selected as input; when DIFF=1, it is reserved. Voltage reference selected is determined by SC2[REFSEL].
 *  0b11111..Module is disabled.
 */
#define ADC_SC1_ADCH(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC1_ADCH_SHIFT)) & ADC_SC1_ADCH_MASK)
#define ADC_SC1_DIFF_MASK                        (0x20U)
#define ADC_SC1_DIFF_SHIFT                       (5U)
/*! DIFF - Differential Mode Enable
 *  0b0..Single-ended conversions and input channels are selected.
 *  0b1..Differential conversions and input channels are selected.
 */
#define ADC_SC1_DIFF(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC1_DIFF_SHIFT)) & ADC_SC1_DIFF_MASK)
#define ADC_SC1_AIEN_MASK                        (0x40U)
#define ADC_SC1_AIEN_SHIFT                       (6U)
/*! AIEN - Interrupt Enable
 *  0b0..Conversion complete interrupt is disabled.
 *  0b1..Conversion complete interrupt is enabled.
 */
#define ADC_SC1_AIEN(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC1_AIEN_SHIFT)) & ADC_SC1_AIEN_MASK)
#define ADC_SC1_COCO_MASK                        (0x80U)
#define ADC_SC1_COCO_SHIFT                       (7U)
/*! COCO - Conversion Complete Flag
 *  0b0..Conversion is not completed.
 *  0b1..Conversion is completed.
 */
#define ADC_SC1_COCO(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC1_COCO_SHIFT)) & ADC_SC1_COCO_MASK)
/*! @} */

/* The count of ADC_SC1 */
#define ADC_SC1_COUNT                            (2U)

/*! @name CFG1 - ADC Configuration Register 1 */
/*! @{ */
#define ADC_CFG1_ADICLK_MASK                     (0x3U)
#define ADC_CFG1_ADICLK_SHIFT                    (0U)
/*! ADICLK - Input Clock Select
 *  0b00..Bus clock
 *  0b01..Bus clock divided by 2(BUSCLK/2)
 *  0b10..Alternate clock (ALTCLK)
 *  0b11..Asynchronous clock (ADACK)
 */
#define ADC_CFG1_ADICLK(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADICLK_SHIFT)) & ADC_CFG1_ADICLK_MASK)
#define ADC_CFG1_MODE_MASK                       (0xCU)
#define ADC_CFG1_MODE_SHIFT                      (2U)
/*! MODE - Conversion mode selection
 *  0b00..When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is differential 9-bit conversion with 2's complement output.
 *  0b01..When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is differential 13-bit conversion with 2's complement output.
 *  0b10..When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is differential 11-bit conversion with 2's complement output
 *  0b11..When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is differential 16-bit conversion with 2's complement output
 */
#define ADC_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_MODE_SHIFT)) & ADC_CFG1_MODE_MASK)
#define ADC_CFG1_ADLSMP_MASK                     (0x10U)
#define ADC_CFG1_ADLSMP_SHIFT                    (4U)
/*! ADLSMP - Sample Time Configuration
 *  0b0..Short sample time.
 *  0b1..Long sample time.
 */
#define ADC_CFG1_ADLSMP(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADLSMP_SHIFT)) & ADC_CFG1_ADLSMP_MASK)
#define ADC_CFG1_ADIV_MASK                       (0x60U)
#define ADC_CFG1_ADIV_SHIFT                      (5U)
/*! ADIV - Clock Divide Select
 *  0b00..The divide ratio is 1 and the clock rate is input clock.
 *  0b01..The divide ratio is 2 and the clock rate is (input clock)/2.
 *  0b10..The divide ratio is 4 and the clock rate is (input clock)/4.
 *  0b11..The divide ratio is 8 and the clock rate is (input clock)/8.
 */
#define ADC_CFG1_ADIV(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADIV_SHIFT)) & ADC_CFG1_ADIV_MASK)
#define ADC_CFG1_ADLPC_MASK                      (0x80U)
#define ADC_CFG1_ADLPC_SHIFT                     (7U)
/*! ADLPC - Low-Power Configuration
 *  0b0..Normal power configuration.
 *  0b1..Low-power configuration. The power is reduced at the expense of maximum clock speed.
 */
#define ADC_CFG1_ADLPC(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADLPC_SHIFT)) & ADC_CFG1_ADLPC_MASK)
/*! @} */

/*! @name CFG2 - ADC Configuration Register 2 */
/*! @{ */
#define ADC_CFG2_ADLSTS_MASK                     (0x3U)
#define ADC_CFG2_ADLSTS_SHIFT                    (0U)
/*! ADLSTS - Long Sample Time Select
 *  0b00..Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles total.
 *  0b01..12 extra ADCK cycles; 16 ADCK cycles total sample time.
 *  0b10..6 extra ADCK cycles; 10 ADCK cycles total sample time.
 *  0b11..2 extra ADCK cycles; 6 ADCK cycles total sample time.
 */
#define ADC_CFG2_ADLSTS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_ADLSTS_SHIFT)) & ADC_CFG2_ADLSTS_MASK)
#define ADC_CFG2_ADHSC_MASK                      (0x4U)
#define ADC_CFG2_ADHSC_SHIFT                     (2U)
/*! ADHSC - High-Speed Configuration
 *  0b0..Normal conversion sequence selected.
 *  0b1..High-speed conversion sequence selected with 2 additional ADCK cycles to total conversion time.
 */
#define ADC_CFG2_ADHSC(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_ADHSC_SHIFT)) & ADC_CFG2_ADHSC_MASK)
#define ADC_CFG2_ADACKEN_MASK                    (0x8U)
#define ADC_CFG2_ADACKEN_SHIFT                   (3U)
/*! ADACKEN - Asynchronous Clock Output Enable
 *  0b0..Asynchronous clock output disabled; Asynchronous clock is enabled only if selected by ADICLK and a conversion is active.
 *  0b1..Asynchronous clock and clock output is enabled regardless of the state of the ADC.
 */
#define ADC_CFG2_ADACKEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_ADACKEN_SHIFT)) & ADC_CFG2_ADACKEN_MASK)
#define ADC_CFG2_MUXSEL_MASK                     (0x10U)
#define ADC_CFG2_MUXSEL_SHIFT                    (4U)
/*! MUXSEL - ADC Mux Select
 *  0b0..ADxxa channels are selected.
 *  0b1..ADxxb channels are selected.
 */
#define ADC_CFG2_MUXSEL(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_MUXSEL_SHIFT)) & ADC_CFG2_MUXSEL_MASK)
/*! @} */

/*! @name R - ADC Data Result Register */
/*! @{ */
#define ADC_R_D_MASK                             (0xFFFFU)
#define ADC_R_D_SHIFT                            (0U)
/*! D - Data result
 */
#define ADC_R_D(x)                               (((uint32_t)(((uint32_t)(x)) << ADC_R_D_SHIFT)) & ADC_R_D_MASK)
/*! @} */

/* The count of ADC_R */
#define ADC_R_COUNT                              (2U)

/*! @name CV1 - Compare Value Registers */
/*! @{ */
#define ADC_CV1_CV_MASK                          (0xFFFFU)
#define ADC_CV1_CV_SHIFT                         (0U)
/*! CV - Compare Value.
 */
#define ADC_CV1_CV(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV1_CV_SHIFT)) & ADC_CV1_CV_MASK)
/*! @} */

/*! @name CV2 - Compare Value Registers */
/*! @{ */
#define ADC_CV2_CV_MASK                          (0xFFFFU)
#define ADC_CV2_CV_SHIFT                         (0U)
/*! CV - Compare Value.
 */
#define ADC_CV2_CV(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV2_CV_SHIFT)) & ADC_CV2_CV_MASK)
/*! @} */

/*! @name SC2 - Status and Control Register 2 */
/*! @{ */
#define ADC_SC2_REFSEL_MASK                      (0x3U)
#define ADC_SC2_REFSEL_SHIFT                     (0U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..Default voltage reference pin pair, that is, external pins VREFH and VREFL
 *  0b01..Alternate reference pair, that is, VALTH and VALTL . This pair may be additional external pins or
 *        internal sources depending on the MCU configuration. See the chip configuration information for details
 *        specific to this MCU
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define ADC_SC2_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_SC2_REFSEL_SHIFT)) & ADC_SC2_REFSEL_MASK)
#define ADC_SC2_DMAEN_MASK                       (0x4U)
#define ADC_SC2_DMAEN_SHIFT                      (2U)
/*! DMAEN - DMA Enable
 *  0b0..DMA is disabled.
 *  0b1..DMA is enabled and will assert the ADC DMA request during an ADC conversion complete event noted when any
 *       of the SC1n[COCO] flags is asserted.
 */
#define ADC_SC2_DMAEN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_SC2_DMAEN_SHIFT)) & ADC_SC2_DMAEN_MASK)
#define ADC_SC2_ACREN_MASK                       (0x8U)
#define ADC_SC2_ACREN_SHIFT                      (3U)
/*! ACREN - Compare Function Range Enable
 *  0b0..Range function disabled. Only CV1 is compared.
 *  0b1..Range function enabled. Both CV1 and CV2 are compared.
 */
#define ADC_SC2_ACREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_SC2_ACREN_SHIFT)) & ADC_SC2_ACREN_MASK)
#define ADC_SC2_ACFGT_MASK                       (0x10U)
#define ADC_SC2_ACFGT_SHIFT                      (4U)
/*! ACFGT - Compare Function Greater Than Enable
 *  0b0..Configures less than threshold, outside range not inclusive and inside range not inclusive; functionality
 *       based on the values placed in CV1 and CV2.
 *  0b1..Configures greater than or equal to threshold, outside and inside ranges inclusive; functionality based on the values placed in CV1 and CV2.
 */
#define ADC_SC2_ACFGT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_SC2_ACFGT_SHIFT)) & ADC_SC2_ACFGT_MASK)
#define ADC_SC2_ACFE_MASK                        (0x20U)
#define ADC_SC2_ACFE_SHIFT                       (5U)
/*! ACFE - Compare Function Enable
 *  0b0..Compare function disabled.
 *  0b1..Compare function enabled.
 */
#define ADC_SC2_ACFE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC2_ACFE_SHIFT)) & ADC_SC2_ACFE_MASK)
#define ADC_SC2_ADTRG_MASK                       (0x40U)
#define ADC_SC2_ADTRG_SHIFT                      (6U)
/*! ADTRG - Conversion Trigger Select
 *  0b0..Software trigger selected.
 *  0b1..Hardware trigger selected.
 */
#define ADC_SC2_ADTRG(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_SC2_ADTRG_SHIFT)) & ADC_SC2_ADTRG_MASK)
#define ADC_SC2_ADACT_MASK                       (0x80U)
#define ADC_SC2_ADACT_SHIFT                      (7U)
/*! ADACT - Conversion Active
 *  0b0..Conversion not in progress.
 *  0b1..Conversion in progress.
 */
#define ADC_SC2_ADACT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_SC2_ADACT_SHIFT)) & ADC_SC2_ADACT_MASK)
/*! @} */

/*! @name SC3 - Status and Control Register 3 */
/*! @{ */
#define ADC_SC3_AVGS_MASK                        (0x3U)
#define ADC_SC3_AVGS_SHIFT                       (0U)
/*! AVGS - Hardware Average Select
 *  0b00..4 samples averaged.
 *  0b01..8 samples averaged.
 *  0b10..16 samples averaged.
 *  0b11..32 samples averaged.
 */
#define ADC_SC3_AVGS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC3_AVGS_SHIFT)) & ADC_SC3_AVGS_MASK)
#define ADC_SC3_AVGE_MASK                        (0x4U)
#define ADC_SC3_AVGE_SHIFT                       (2U)
/*! AVGE - Hardware Average Enable
 *  0b0..Hardware average function disabled.
 *  0b1..Hardware average function enabled.
 */
#define ADC_SC3_AVGE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC3_AVGE_SHIFT)) & ADC_SC3_AVGE_MASK)
#define ADC_SC3_ADCO_MASK                        (0x8U)
#define ADC_SC3_ADCO_SHIFT                       (3U)
/*! ADCO - Continuous Conversion Enable
 *  0b0..One conversion or one set of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
 *  0b1..Continuous conversions or sets of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
 */
#define ADC_SC3_ADCO(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC3_ADCO_SHIFT)) & ADC_SC3_ADCO_MASK)
#define ADC_SC3_CALF_MASK                        (0x40U)
#define ADC_SC3_CALF_SHIFT                       (6U)
/*! CALF - Calibration Failed Flag
 *  0b0..Calibration completed normally.
 *  0b1..Calibration failed. ADC accuracy specifications are not guaranteed.
 */
#define ADC_SC3_CALF(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC3_CALF_SHIFT)) & ADC_SC3_CALF_MASK)
#define ADC_SC3_CAL_MASK                         (0x80U)
#define ADC_SC3_CAL_SHIFT                        (7U)
/*! CAL - Calibration
 */
#define ADC_SC3_CAL(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_SC3_CAL_SHIFT)) & ADC_SC3_CAL_MASK)
/*! @} */

/*! @name OFS - ADC Offset Correction Register */
/*! @{ */
#define ADC_OFS_OFS_MASK                         (0xFFFFU)
#define ADC_OFS_OFS_SHIFT                        (0U)
/*! OFS - Offset Error Correction Value
 */
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_OFS_OFS_SHIFT)) & ADC_OFS_OFS_MASK)
/*! @} */

/*! @name PG - ADC Plus-Side Gain Register */
/*! @{ */
#define ADC_PG_PG_MASK                           (0xFFFFU)
#define ADC_PG_PG_SHIFT                          (0U)
/*! PG - Plus-Side Gain
 */
#define ADC_PG_PG(x)                             (((uint32_t)(((uint32_t)(x)) << ADC_PG_PG_SHIFT)) & ADC_PG_PG_MASK)
/*! @} */

/*! @name MG - ADC Minus-Side Gain Register */
/*! @{ */
#define ADC_MG_MG_MASK                           (0xFFFFU)
#define ADC_MG_MG_SHIFT                          (0U)
/*! MG - Minus-Side Gain
 */
#define ADC_MG_MG(x)                             (((uint32_t)(((uint32_t)(x)) << ADC_MG_MG_SHIFT)) & ADC_MG_MG_MASK)
/*! @} */

/*! @name CLPD - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLPD_CLPD_MASK                       (0x3FU)
#define ADC_CLPD_CLPD_SHIFT                      (0U)
/*! CLPD - Calibration Value
 */
#define ADC_CLPD_CLPD(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLPD_CLPD_SHIFT)) & ADC_CLPD_CLPD_MASK)
/*! @} */

/*! @name CLPS - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLPS_CLPS_MASK                       (0x3FU)
#define ADC_CLPS_CLPS_SHIFT                      (0U)
/*! CLPS - Calibration Value
 */
#define ADC_CLPS_CLPS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLPS_CLPS_SHIFT)) & ADC_CLPS_CLPS_MASK)
/*! @} */

/*! @name CLP4 - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLP4_CLP4_MASK                       (0x3FFU)
#define ADC_CLP4_CLP4_SHIFT                      (0U)
/*! CLP4 - Calibration Value
 */
#define ADC_CLP4_CLP4(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP4_CLP4_SHIFT)) & ADC_CLP4_CLP4_MASK)
/*! @} */

/*! @name CLP3 - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLP3_CLP3_MASK                       (0x1FFU)
#define ADC_CLP3_CLP3_SHIFT                      (0U)
/*! CLP3 - Calibration Value
 */
#define ADC_CLP3_CLP3(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP3_CLP3_SHIFT)) & ADC_CLP3_CLP3_MASK)
/*! @} */

/*! @name CLP2 - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLP2_CLP2_MASK                       (0xFFU)
#define ADC_CLP2_CLP2_SHIFT                      (0U)
/*! CLP2 - Calibration Value
 */
#define ADC_CLP2_CLP2(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP2_CLP2_SHIFT)) & ADC_CLP2_CLP2_MASK)
/*! @} */

/*! @name CLP1 - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLP1_CLP1_MASK                       (0x7FU)
#define ADC_CLP1_CLP1_SHIFT                      (0U)
/*! CLP1 - Calibration Value
 */
#define ADC_CLP1_CLP1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP1_CLP1_SHIFT)) & ADC_CLP1_CLP1_MASK)
/*! @} */

/*! @name CLP0 - ADC Plus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLP0_CLP0_MASK                       (0x3FU)
#define ADC_CLP0_CLP0_SHIFT                      (0U)
/*! CLP0 - Calibration Value
 */
#define ADC_CLP0_CLP0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP0_CLP0_SHIFT)) & ADC_CLP0_CLP0_MASK)
/*! @} */

/*! @name CLMD - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLMD_CLMD_MASK                       (0x3FU)
#define ADC_CLMD_CLMD_SHIFT                      (0U)
/*! CLMD - Calibration Value
 */
#define ADC_CLMD_CLMD(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLMD_CLMD_SHIFT)) & ADC_CLMD_CLMD_MASK)
/*! @} */

/*! @name CLMS - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLMS_CLMS_MASK                       (0x3FU)
#define ADC_CLMS_CLMS_SHIFT                      (0U)
/*! CLMS - Calibration Value
 */
#define ADC_CLMS_CLMS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLMS_CLMS_SHIFT)) & ADC_CLMS_CLMS_MASK)
/*! @} */

/*! @name CLM4 - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLM4_CLM4_MASK                       (0x3FFU)
#define ADC_CLM4_CLM4_SHIFT                      (0U)
/*! CLM4 - Calibration Value
 */
#define ADC_CLM4_CLM4(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM4_CLM4_SHIFT)) & ADC_CLM4_CLM4_MASK)
/*! @} */

/*! @name CLM3 - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLM3_CLM3_MASK                       (0x1FFU)
#define ADC_CLM3_CLM3_SHIFT                      (0U)
/*! CLM3 - Calibration Value
 */
#define ADC_CLM3_CLM3(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM3_CLM3_SHIFT)) & ADC_CLM3_CLM3_MASK)
/*! @} */

/*! @name CLM2 - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLM2_CLM2_MASK                       (0xFFU)
#define ADC_CLM2_CLM2_SHIFT                      (0U)
/*! CLM2 - Calibration Value
 */
#define ADC_CLM2_CLM2(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM2_CLM2_SHIFT)) & ADC_CLM2_CLM2_MASK)
/*! @} */

/*! @name CLM1 - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLM1_CLM1_MASK                       (0x7FU)
#define ADC_CLM1_CLM1_SHIFT                      (0U)
/*! CLM1 - Calibration Value
 */
#define ADC_CLM1_CLM1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM1_CLM1_SHIFT)) & ADC_CLM1_CLM1_MASK)
/*! @} */

/*! @name CLM0 - ADC Minus-Side General Calibration Value Register */
/*! @{ */
#define ADC_CLM0_CLM0_MASK                       (0x3FU)
#define ADC_CLM0_CLM0_SHIFT                      (0U)
/*! CLM0 - Calibration Value
 */
#define ADC_CLM0_CLM0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM0_CLM0_SHIFT)) & ADC_CLM0_CLM0_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x4003B000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BTLE_RF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Peripheral_Access_Layer BTLE_RF Peripheral Access Layer
 * @{
 */

/** BTLE_RF - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1536];
  __I  uint16_t BLE_PART_ID;                       /**< BluetoothLE LOW ENERGY PART ID, offset: 0x600 */
       uint8_t RESERVED_1[2];
  __I  uint16_t DSM_STATUS;                        /**< BluetoothLE DSM STATUS, offset: 0x604 */
       uint8_t RESERVED_2[2];
  __IO uint16_t MISC_CTRL;                         /**< BluetoothLE MISCELLANEOUS CONTROL, offset: 0x608 */
} BTLE_RF_Type;

/* ----------------------------------------------------------------------------
   -- BTLE_RF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Register_Masks BTLE_RF Register Masks
 * @{
 */

/*! @name BLE_PART_ID - BluetoothLE LOW ENERGY PART ID */
/*! @{ */
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID_MASK     (0xFFFFU)
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID_SHIFT    (0U)
/*! BLE_PART_ID - BluetoothLE Part ID
 *  0b0000000000000000..Pre-production
 *  0b0000000000000001..Pre-production
 *  0b0000000000000010..KW40
 *  0b0000000000000011..KW41
 *  0b0000000000000100..K3S
 *  0b0000000000000101..KW35/36
 *  0b0000000000000110..KW37/38, K4
 */
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID(x)       (((uint16_t)(((uint16_t)(x)) << BTLE_RF_BLE_PART_ID_BLE_PART_ID_SHIFT)) & BTLE_RF_BLE_PART_ID_BLE_PART_ID_MASK)
/*! @} */

/*! @name DSM_STATUS - BluetoothLE DSM STATUS */
/*! @{ */
#define BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_MASK   (0x1U)
#define BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_SHIFT  (0U)
/*! ORF_SYSCLK_REQ - RF Oscillator Requested
 */
#define BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ(x)     (((uint16_t)(((uint16_t)(x)) << BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_SHIFT)) & BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_MASK)
#define BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_MASK    (0x2U)
#define BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_SHIFT   (1U)
/*! RIF_LL_ACTIVE - Link Layer Active
 */
#define BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE(x)      (((uint16_t)(((uint16_t)(x)) << BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_SHIFT)) & BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_MASK)
#define BTLE_RF_DSM_STATUS_XCVR_BUSY_MASK        (0x4U)
#define BTLE_RF_DSM_STATUS_XCVR_BUSY_SHIFT       (2U)
/*! XCVR_BUSY - Transceiver Busy Status Bit
 *  0b0..RF Channel in available (TSM is idle)
 *  0b1..RF Channel in use (TSM is busy)
 */
#define BTLE_RF_DSM_STATUS_XCVR_BUSY(x)          (((uint16_t)(((uint16_t)(x)) << BTLE_RF_DSM_STATUS_XCVR_BUSY_SHIFT)) & BTLE_RF_DSM_STATUS_XCVR_BUSY_MASK)
#define BTLE_RF_DSM_STATUS_BTLE_ABORT_MASK       (0x8U)
#define BTLE_RF_DSM_STATUS_BTLE_ABORT_SHIFT      (3U)
/*! BTLE_ABORT - Btle Abort Status Bit
 *  0b0..BluetoothLE protocol engine has access to the RF channel
 *  0b1..BluetoothLE protocol engine has relinquish access to the RF channel
 */
#define BTLE_RF_DSM_STATUS_BTLE_ABORT(x)         (((uint16_t)(((uint16_t)(x)) << BTLE_RF_DSM_STATUS_BTLE_ABORT_SHIFT)) & BTLE_RF_DSM_STATUS_BTLE_ABORT_MASK)
/*! @} */

/*! @name MISC_CTRL - BluetoothLE MISCELLANEOUS CONTROL */
/*! @{ */
#define BTLE_RF_MISC_CTRL_BLE_RELINQUISH_MASK    (0x1U)
#define BTLE_RF_MISC_CTRL_BLE_RELINQUISH_SHIFT   (0U)
/*! BLE_RELINQUISH - BluetoothLE Relinquish Control
 *  0b0..Not force BluetoothLE protocol engine relinquish access to RF channel
 *  0b1..force BluetoothLE protocol engine relinquish access to RF channel
 */
#define BTLE_RF_MISC_CTRL_BLE_RELINQUISH(x)      (((uint16_t)(((uint16_t)(x)) << BTLE_RF_MISC_CTRL_BLE_RELINQUISH_SHIFT)) & BTLE_RF_MISC_CTRL_BLE_RELINQUISH_MASK)
#define BTLE_RF_MISC_CTRL_TSM_INTR_EN_MASK       (0x2U)
#define BTLE_RF_MISC_CTRL_TSM_INTR_EN_SHIFT      (1U)
/*! TSM_INTR_EN - TSM Interrupt Enable
 */
#define BTLE_RF_MISC_CTRL_TSM_INTR_EN(x)         (((uint16_t)(((uint16_t)(x)) << BTLE_RF_MISC_CTRL_TSM_INTR_EN_SHIFT)) & BTLE_RF_MISC_CTRL_TSM_INTR_EN_MASK)
#define BTLE_RF_MISC_CTRL_RX_ABORT_EN_MASK       (0x4U)
#define BTLE_RF_MISC_CTRL_RX_ABORT_EN_SHIFT      (2U)
/*! RX_ABORT_EN - enable pll_abort/ble_relinquish in rx process
 *  0b1..enable pll_abort/ble_relinquish in rx process
 *  0b0..disable pll_abort/ble_relinquish in rx process
 */
#define BTLE_RF_MISC_CTRL_RX_ABORT_EN(x)         (((uint16_t)(((uint16_t)(x)) << BTLE_RF_MISC_CTRL_RX_ABORT_EN_SHIFT)) & BTLE_RF_MISC_CTRL_RX_ABORT_EN_MASK)
#define BTLE_RF_MISC_CTRL_DTM_RX_DISABLE_MASK    (0x8U)
#define BTLE_RF_MISC_CTRL_DTM_RX_DISABLE_SHIFT   (3U)
/*! DTM_RX_DISABLE - DTM_RX gating bit
 *  0b1..Gate off the DTM_RX
 *  0b0..pass through the DTM_RX
 */
#define BTLE_RF_MISC_CTRL_DTM_RX_DISABLE(x)      (((uint16_t)(((uint16_t)(x)) << BTLE_RF_MISC_CTRL_DTM_RX_DISABLE_SHIFT)) & BTLE_RF_MISC_CTRL_DTM_RX_DISABLE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BTLE_RF_Register_Masks */


/* BTLE_RF - Peripheral instance base addresses */
/** Peripheral BTLE_RF base address */
#define BTLE_RF_BASE                             (0x40080000u)
/** Peripheral BTLE_RF base pointer */
#define BTLE_RF                                  ((BTLE_RF_Type *)BTLE_RF_BASE)
/** Array initializer of BTLE_RF peripheral base addresses */
#define BTLE_RF_BASE_ADDRS                       { BTLE_RF_BASE }
/** Array initializer of BTLE_RF peripheral base pointers */
#define BTLE_RF_BASE_PTRS                        { BTLE_RF }

/*!
 * @}
 */ /* end of group BTLE_RF_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1 register, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< Rx Mailboxes Global Mask register, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Rx 14 Mask register, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Rx 15 Mask register, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1 register, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1 register, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1 register, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2 register, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2 register, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< CRC register, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Rx FIFO Global Mask register, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Rx FIFO Information register, offset: 0x4C */
  __IO uint32_t CBT;                               /**< CAN Bit Timing register, offset: 0x50 */
       uint8_t RESERVED_4[44];
  union {                                          /* offset: 0x80 */
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD[2];                           /**< Message Buffer 0 WORD_8B Register..Message Buffer 31 WORD_8B Register, array offset: 0x88, array step: index*0x10, index2*0x4 */
    } MB_8B[32];
    struct {                                         /* offset: 0x80, array step: 0x18 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 20 CS Register, array offset: 0x80, array step: 0x18 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 20 ID Register, array offset: 0x84, array step: 0x18 */
      __IO uint32_t WORD[4];                           /**< Message Buffer 0 WORD_16B Register..Message Buffer 20 WORD_16B Register, array offset: 0x88, array step: index*0x18, index2*0x4 */
    } MB_16B[21];
    struct {                                         /* offset: 0x80, array step: 0x28 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 11 CS Register, array offset: 0x80, array step: 0x28 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 11 ID Register, array offset: 0x84, array step: 0x28 */
      __IO uint32_t WORD[8];                           /**< Message Buffer 0 WORD_32B Register..Message Buffer 11 WORD_32B Register, array offset: 0x88, array step: index*0x28, index2*0x4 */
    } MB_32B[12];
    struct {                                         /* offset: 0x80, array step: 0x48 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 6 CS Register, array offset: 0x80, array step: 0x48 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 6 ID Register, array offset: 0x84, array step: 0x48 */
      __IO uint32_t WORD[16];                          /**< Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register, array offset: 0x88, array step: index*0x48, index2*0x4 */
    } MB_64B[7];
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register, array offset: 0x88, array step: 0x10 */
      __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register, array offset: 0x8C, array step: 0x10 */
    } MB[32];
  };
       uint8_t RESERVED_5[1536];
  __IO uint32_t RXIMR[32];                         /**< Rx Individual Mask registers, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_6[768];
  __IO uint32_t FDCTRL;                            /**< CAN FD Control register, offset: 0xC00 */
  __IO uint32_t FDCBT;                             /**< CAN FD Bit Timing register, offset: 0xC04 */
  __I  uint32_t FDCRC;                             /**< CAN FD CRC register, offset: 0xC08 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration register */
/*! @{ */
#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
/*! MAXMB - Number Of The Last Message Buffer
 */
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)
#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)
#define CAN_MCR_FDEN_MASK                        (0x800U)
#define CAN_MCR_FDEN_SHIFT                       (11U)
/*! FDEN - CAN FD operation enable
 *  0b1..CAN FD is enabled. FlexCAN is able to receive and transmit messages in both CAN FD and CAN 2.0 formats.
 *  0b0..CAN FD is disabled. FlexCAN is able to receive and transmit messages in CAN 2.0 format.
 */
#define CAN_MCR_FDEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)
#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
/*! AEN - Abort Enable
 *  0b0..Abort disabled.
 *  0b1..Abort enabled.
 */
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)
#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Local Priority disabled.
 *  0b1..Local Priority enabled.
 */
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)
#define CAN_MCR_DMA_MASK                         (0x8000U)
#define CAN_MCR_DMA_SHIFT                        (15U)
/*! DMA - DMA Enable
 *  0b0..DMA feature for RX FIFO disabled.
 *  0b1..DMA feature for RX FIFO enabled.
 */
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)
#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
/*! IRMQ - Individual Rx Masking And Queue Enable
 *  0b0..Individual Rx masking and queue feature are disabled. For backward compatibility with legacy
 *       applications, the reading of C/S word locks the MB even if it is EMPTY.
 *  0b1..Individual Rx masking and queue feature are enabled.
 */
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)
#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
/*! SRXDIS - Self Reception Disable
 *  0b0..Self-reception enabled.
 *  0b1..Self-reception disabled.
 */
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)
#define CAN_MCR_DOZE_MASK                        (0x40000U)
#define CAN_MCR_DOZE_SHIFT                       (18U)
/*! DOZE - Doze Mode Enable
 *  0b0..FlexCAN is not enabled to enter low-power mode when Doze mode is requested.
 *  0b1..FlexCAN is enabled to enter low-power mode when Doze mode is requested.
 */
#define CAN_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DOZE_SHIFT)) & CAN_MCR_DOZE_MASK)
#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
/*! WAKSRC - Wake Up Source
 *  0b0..FlexCAN uses the unfiltered Rx input to detect recessive to dominant edges on the CAN bus.
 *  0b1..FlexCAN uses the filtered Rx input to detect recessive to dominant edges on the CAN bus.
 */
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)
#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..FlexCAN is not in a low-power mode.
 *  0b1..FlexCAN is in a low-power mode.
 */
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)
#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..TWRNINT and RWRNINT bits are zero, independent of the values in the error counters.
 *  0b1..TWRNINT and RWRNINT bits are set when the respective error counter transitions from less than 96 to greater than or equal to 96.
 */
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)
#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
/*! SLFWAK - Self Wake Up
 *  0b0..FlexCAN Self Wake Up feature is disabled.
 *  0b1..FlexCAN Self Wake Up feature is enabled.
 */
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)
#define CAN_MCR_SUPV_MASK                        (0x800000U)
#define CAN_MCR_SUPV_SHIFT                       (23U)
/*! SUPV - Supervisor Mode
 *  0b0..FlexCAN is in User mode. Affected registers allow both Supervisor and Unrestricted accesses.
 *  0b1..FlexCAN is in Supervisor mode. Affected registers allow only Supervisor access. Unrestricted access
 *       behaves as though the access was done to an unimplemented register location.
 */
#define CAN_MCR_SUPV(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SUPV_SHIFT)) & CAN_MCR_SUPV_MASK)
#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..FlexCAN not in Freeze mode, prescaler running.
 *  0b1..FlexCAN in Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)
#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset request.
 *  0b1..Resets the registers affected by soft reset.
 */
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)
#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
/*! WAKMSK - Wake Up Interrupt Mask
 *  0b0..Wake Up interrupt is disabled.
 *  0b1..Wake Up interrupt is enabled.
 */
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)
#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN module is either in Normal mode, Listen-Only mode, or Loop-Back mode.
 *  0b1..FlexCAN module is either in Disable mode, Doze mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)
#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No Freeze mode request.
 *  0b1..Enters Freeze mode if the FRZ bit is asserted.
 */
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)
#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
/*! RFEN - Rx FIFO Enable
 *  0b0..Rx FIFO not enabled.
 *  0b1..Rx FIFO enabled.
 */
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)
#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
/*! FRZ - Freeze Enable
 *  0b0..Not enabled to enter Freeze mode.
 *  0b1..Enabled to enter Freeze mode.
 */
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)
#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
/*! MDIS - Module Disable
 *  0b0..Enable the FlexCAN module.
 *  0b1..Disable the FlexCAN module.
 */
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 register */
/*! @{ */
#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
/*! PROPSEG - Propagation Segment
 */
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)
#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)
#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)
#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
/*! TSYN - Timer Sync
 *  0b0..Timer sync feature disabled
 *  0b1..Timer sync feature enabled
 */
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)
#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Automatic recovering from Bus Off state enabled.
 *  0b1..Automatic recovering from Bus Off state disabled.
 */
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)
#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..Just one sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples; a majority rule is used.
 */
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)
#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
/*! RWRNMSK - Rx Warning Interrupt Mask
 *  0b0..Rx Warning interrupt disabled.
 *  0b1..Rx Warning interrupt enabled.
 */
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)
#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
/*! TWRNMSK - Tx Warning Interrupt Mask
 *  0b0..Tx Warning interrupt disabled.
 *  0b1..Tx Warning interrupt enabled.
 */
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)
#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
/*! LPB - Loop Back Mode
 *  0b0..Loop Back disabled.
 *  0b1..Loop Back enabled.
 */
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)
#define CAN_CTRL1_CLKSRC_MASK                    (0x2000U)
#define CAN_CTRL1_CLKSRC_SHIFT                   (13U)
/*! CLKSRC - CAN Engine Clock Source
 *  0b0..The CAN engine clock source is the oscillator clock. Under this condition, the oscillator clock frequency must be lower than the bus clock.
 *  0b1..The CAN engine clock source is the peripheral clock.
 */
#define CAN_CTRL1_CLKSRC(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_CLKSRC_SHIFT)) & CAN_CTRL1_CLKSRC_MASK)
#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Error interrupt disabled.
 *  0b1..Error interrupt enabled.
 */
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)
#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Bus Off interrupt disabled.
 *  0b1..Bus Off interrupt enabled.
 */
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)
#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
/*! PSEG2 - Phase Segment 2
 */
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)
#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
/*! PSEG1 - Phase Segment 1
 */
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)
#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
/*! RJW - Resync Jump Width
 */
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)
#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
/*! PRESDIV - Prescaler Division Factor
 */
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free Running Timer */
/*! @{ */
#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
/*! TIMER - Timer Value
 */
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - Rx Mailboxes Global Mask register */
/*! @{ */
#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
/*! MG - Rx Mailboxes Global Mask Bits
 */
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Rx 14 Mask register */
/*! @{ */
#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
/*! RX14M - Rx Buffer 14 Mask Bits
 */
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Rx 15 Mask register */
/*! @{ */
#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
/*! RX15M - Rx Buffer 15 Mask Bits
 */
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */
#define CAN_ECR_TXERRCNT_MASK                    (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT                   (0U)
/*! TXERRCNT - Transmit Error Counter
 */
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)
#define CAN_ECR_RXERRCNT_MASK                    (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT                   (8U)
/*! RXERRCNT - Receive Error Counter
 */
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)
#define CAN_ECR_TXERRCNT_FAST_MASK               (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT              (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for fast bits
 */
#define CAN_ECR_TXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)
#define CAN_ECR_RXERRCNT_FAST_MASK               (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT              (24U)
/*! RXERRCNT_FAST - Receive Error Counter for fast bits
 */
#define CAN_ECR_RXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 register */
/*! @{ */
#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
/*! WAKINT - Wake-Up Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates a recessive to dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)
#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
/*! ERRINT - Error Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)
#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
/*! BOFFINT - Bus Off Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)
#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
/*! RX - FlexCAN In Reception
 *  0b0..FlexCAN is not receiving a message.
 *  0b1..FlexCAN is receiving a message.
 */
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)
#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)
#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..FlexCAN is not transmitting a message.
 *  0b1..FlexCAN is transmitting a message.
 */
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)
#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
/*! IDLE - IDLE
 *  0b0..No such occurrence.
 *  0b1..CAN bus is now IDLE.
 */
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)
#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
/*! RXWRN - Rx Error Warning
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)
#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
/*! TXWRN - TX Error Warning
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)
#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
/*! STFERR - Stuffing Error
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)
#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
/*! FRMERR - Form Error
 *  0b0..No such occurrence.
 *  0b1..A Form Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)
#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
/*! CRCERR - Cyclic Redundancy Check Error
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)
#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
/*! ACKERR - Acknowledge Error
 *  0b0..No such occurrence.
 *  0b1..An ACK error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)
#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
/*! BIT0ERR - Bit0 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)
#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
/*! BIT1ERR - Bit1 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)
#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
/*! RWRNINT - Rx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Rx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)
#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
/*! TWRNINT - Tx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Tx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)
#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
/*! SYNCH - CAN Synchronization Status
 *  0b0..FlexCAN is not synchronized to the CAN bus.
 *  0b1..FlexCAN is synchronized to the CAN bus.
 */
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)
#define CAN_ESR1_BOFFDONEINT_MASK                (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT               (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)
#define CAN_ESR1_ERRINT_FAST_MASK                (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT               (20U)
/*! ERRINT_FAST - Error interrupt for errors detected in Data Phase of CAN FD frames with BRS bit set
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit detected in the data phase of CAN FD frames with the BRS bit set.
 */
#define CAN_ESR1_ERRINT_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)
#define CAN_ESR1_ERROVR_MASK                     (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT                    (21U)
/*! ERROVR - Error Overrun
 *  0b0..Overrun has not occurred.
 *  0b1..Overrun has occurred.
 */
#define CAN_ESR1_ERROVR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)
#define CAN_ESR1_STFERR_FAST_MASK                (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT               (26U)
/*! STFERR_FAST - Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)
#define CAN_ESR1_FRMERR_FAST_MASK                (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT               (27U)
/*! FRMERR_FAST - Form Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)
#define CAN_ESR1_CRCERR_FAST_MASK                (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT               (28U)
/*! CRCERR_FAST - Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)
#define CAN_ESR1_BIT0ERR_FAST_MASK               (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT              (30U)
/*! BIT0ERR_FAST - Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)
#define CAN_ESR1_BIT1ERR_FAST_MASK               (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT              (31U)
/*! BIT1ERR_FAST - Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 register */
/*! @{ */
#define CAN_IMASK1_BUF31TO0M_MASK                (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT               (0U)
/*! BUF31TO0M - Buffer MB i Mask
 */
#define CAN_IMASK1_BUF31TO0M(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 register */
/*! @{ */
#define CAN_IFLAG1_BUF0I_MASK                    (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT                   (0U)
/*! BUF0I - Buffer MB0 Interrupt Or Clear FIFO bit
 *  0b0..The corresponding buffer has no occurrence of successfully completed transmission or reception when MCR[RFEN]=0.
 *  0b1..The corresponding buffer has successfully completed transmission or reception when MCR[RFEN]=0.
 */
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)
#define CAN_IFLAG1_BUF4TO1I_MASK                 (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT                (1U)
/*! BUF4TO1I - Buffer MB i Interrupt Or Reserved
 */
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)
#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
/*! BUF5I - Buffer MB5 Interrupt Or Frames available in Rx FIFO
 *  0b0..No occurrence of MB5 completing transmission/reception when MCR[RFEN]=0, or of frame(s) available in the FIFO, when MCR[RFEN]=1
 *  0b1..MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s) available in the Rx FIFO when
 *       MCR[RFEN]=1. It generates a DMA request in case of MCR[RFEN] and MCR[DMA] are enabled.
 */
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)
#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
/*! BUF6I - Buffer MB6 Interrupt Or Rx FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO almost full when MCR[RFEN]=1
 *  0b1..MB6 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO almost full when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)
#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
/*! BUF7I - Buffer MB7 Interrupt Or Rx FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO overflow when MCR[RFEN]=1
 *  0b1..MB7 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO overflow when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)
#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
/*! BUF31TO8I - Buffer MBi Interrupt
 */
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 register */
/*! @{ */
#define CAN_CTRL2_EDFLTDIS_MASK                  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT                 (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Edge filter is enabled
 *  0b1..Edge filter is disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)
#define CAN_CTRL2_ISOCANFDEN_MASK                (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT               (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..FlexCAN operates using the non-ISO CAN FD protocol.
 *  0b1..FlexCAN operates using the ISO CAN FD protocol (ISO 11898-1).
 */
#define CAN_CTRL2_ISOCANFDEN(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)
#define CAN_CTRL2_PREXCEN_MASK                   (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT                  (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Protocol exception is disabled.
 *  0b1..Protocol exception is enabled.
 */
#define CAN_CTRL2_PREXCEN(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)
#define CAN_CTRL2_TIMER_SRC_MASK                 (0x8000U)
#define CAN_CTRL2_TIMER_SRC_SHIFT                (15U)
/*! TIMER_SRC - Timer Source
 *  0b0..The free running timer is clocked by the CAN bit clock, which defines the baud rate on the CAN bus.
 *  0b1..The free running timer is clocked by an external time tick. The period can be either adjusted to be equal
 *       to the baud rate on the CAN bus, or a different value as required. See the device-specific section for
 *       details about the external time tick.
 */
#define CAN_CTRL2_TIMER_SRC(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TIMER_SRC_SHIFT)) & CAN_CTRL2_TIMER_SRC_MASK)
#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes
 *  0b0..Rx mailbox filter's IDE bit is always compared and RTR is never compared despite mask bits.
 *  0b1..Enables the comparison of both Rx mailbox filter's IDE and RTR bit with their corresponding bits within
 *       the incoming frame. Mask bits do apply.
 */
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)
#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
/*! RRS - Remote Request Storing
 *  0b0..Remote response frame is generated.
 *  0b1..Remote request frame is stored.
 */
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)
#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
/*! MRP - Mailboxes Reception Priority
 *  0b0..Matching starts from Rx FIFO or Enhanced Rx FIFO and continues on mailboxes.
 *  0b1..Matching starts from mailboxes and continues on Rx FIFO.
 */
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)
#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
/*! TASD - Tx Arbitration Start Delay
 */
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)
#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
/*! RFFN - Number Of Rx FIFO Filters
 */
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)
#define CAN_CTRL2_BOFFDONEMSK_MASK               (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT              (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Bus off done interrupt disabled.
 *  0b1..Bus off done interrupt enabled.
 */
#define CAN_CTRL2_BOFFDONEMSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)
#define CAN_CTRL2_ERRMSK_FAST_MASK               (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT              (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for errors detected in the data phase of fast CAN FD frames
 *  0b0..ERRINT_FAST error interrupt disabled.
 *  0b1..ERRINT_FAST error interrupt enabled.
 */
#define CAN_CTRL2_ERRMSK_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 register */
/*! @{ */
#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
/*! IMB - Inactive Mailbox
 *  0b0..If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive mailbox.
 *  0b1..If ESR2[VPS] is asserted, there is at least one inactive mailbox. LPTM content is the number of the first one.
 */
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)
#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
/*! VPS - Valid Priority Status
 *  0b0..Contents of IMB and LPTM are invalid.
 *  0b1..Contents of IMB and LPTM are valid.
 */
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)
#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
/*! LPTM - Lowest Priority Tx Mailbox
 */
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - CRC register */
/*! @{ */
#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
/*! TXCRC - Transmitted CRC value
 */
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)
#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
/*! MBCRC - CRC Mailbox
 */
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Rx FIFO Global Mask register */
/*! @{ */
#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
/*! FGM - Rx FIFO Global Mask Bits
 */
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Rx FIFO Information register */
/*! @{ */
#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator
 */
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing register */
/*! @{ */
#define CAN_CBT_EPSEG2_MASK                      (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT                     (0U)
/*! EPSEG2 - Extended Phase Segment 2
 */
#define CAN_CBT_EPSEG2(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)
#define CAN_CBT_EPSEG1_MASK                      (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT                     (5U)
/*! EPSEG1 - Extended Phase Segment 1
 */
#define CAN_CBT_EPSEG1(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)
#define CAN_CBT_EPROPSEG_MASK                    (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT                   (10U)
/*! EPROPSEG - Extended Propagation Segment
 */
#define CAN_CBT_EPROPSEG(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)
#define CAN_CBT_ERJW_MASK                        (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT                       (16U)
/*! ERJW - Extended Resync Jump Width
 */
#define CAN_CBT_ERJW(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)
#define CAN_CBT_EPRESDIV_MASK                    (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT                   (21U)
/*! EPRESDIV - Extended Prescaler Division Factor
 */
#define CAN_CBT_EPRESDIV(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)
#define CAN_CBT_BTF_MASK                         (0x80000000U)
#define CAN_CBT_BTF_SHIFT                        (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Extended bit time definitions disabled.
 *  0b1..Extended bit time definitions enabled.
 */
#define CAN_CBT_BTF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB8B                        (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB8B                        (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B                      (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B2                     (2U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB16B                       (21U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB16B                       (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B                     (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B2                    (4U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB32B                       (12U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB32B                       (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B                     (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B2                    (8U)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 6 CS Register */
/*! @{ */
#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)
#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
/*! DLC - Length of the data to be stored/transmitted.
 */
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)
#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame.
 */
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)
#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame.
 */
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)
#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit.
 */
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)
#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)
#define CAN_CS_ESI_MASK                          (0x20000000U)
#define CAN_CS_ESI_SHIFT                         (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive.
 */
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)
#define CAN_CS_BRS_MASK                          (0x40000000U)
#define CAN_CS_BRS_SHIFT                         (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame.
 */
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)
#define CAN_CS_EDL_MASK                          (0x80000000U)
#define CAN_CS_EDL_SHIFT                         (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB64B                       (7U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 6 ID Register */
/*! @{ */
#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer.
 */
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)
#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer.
 */
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)
#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB64B                       (7U)

/*! @name WORD - Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register */
/*! @{ */
#define CAN_WORD_DATA_BYTE_3_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_3_SHIFT               (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_3(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_3_SHIFT)) & CAN_WORD_DATA_BYTE_3_MASK)
#define CAN_WORD_DATA_BYTE_7_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_7_SHIFT               (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_7(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_7_SHIFT)) & CAN_WORD_DATA_BYTE_7_MASK)
#define CAN_WORD_DATA_BYTE_11_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_11_SHIFT              (0U)
/*! DATA_BYTE_11 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_11(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_11_SHIFT)) & CAN_WORD_DATA_BYTE_11_MASK)
#define CAN_WORD_DATA_BYTE_15_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_15_SHIFT              (0U)
/*! DATA_BYTE_15 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_15(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_15_SHIFT)) & CAN_WORD_DATA_BYTE_15_MASK)
#define CAN_WORD_DATA_BYTE_19_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_19_SHIFT              (0U)
/*! DATA_BYTE_19 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_19(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_19_SHIFT)) & CAN_WORD_DATA_BYTE_19_MASK)
#define CAN_WORD_DATA_BYTE_23_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_23_SHIFT              (0U)
/*! DATA_BYTE_23 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_23(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_23_SHIFT)) & CAN_WORD_DATA_BYTE_23_MASK)
#define CAN_WORD_DATA_BYTE_27_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_27_SHIFT              (0U)
/*! DATA_BYTE_27 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_27(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_27_SHIFT)) & CAN_WORD_DATA_BYTE_27_MASK)
#define CAN_WORD_DATA_BYTE_31_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_31_SHIFT              (0U)
/*! DATA_BYTE_31 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_31(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_31_SHIFT)) & CAN_WORD_DATA_BYTE_31_MASK)
#define CAN_WORD_DATA_BYTE_35_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_35_SHIFT              (0U)
/*! DATA_BYTE_35 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_35(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_35_SHIFT)) & CAN_WORD_DATA_BYTE_35_MASK)
#define CAN_WORD_DATA_BYTE_39_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_39_SHIFT              (0U)
/*! DATA_BYTE_39 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_39(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_39_SHIFT)) & CAN_WORD_DATA_BYTE_39_MASK)
#define CAN_WORD_DATA_BYTE_43_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_43_SHIFT              (0U)
/*! DATA_BYTE_43 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_43(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_43_SHIFT)) & CAN_WORD_DATA_BYTE_43_MASK)
#define CAN_WORD_DATA_BYTE_47_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_47_SHIFT              (0U)
/*! DATA_BYTE_47 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_47(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_47_SHIFT)) & CAN_WORD_DATA_BYTE_47_MASK)
#define CAN_WORD_DATA_BYTE_51_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_51_SHIFT              (0U)
/*! DATA_BYTE_51 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_51(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_51_SHIFT)) & CAN_WORD_DATA_BYTE_51_MASK)
#define CAN_WORD_DATA_BYTE_55_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_55_SHIFT              (0U)
/*! DATA_BYTE_55 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_55(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_55_SHIFT)) & CAN_WORD_DATA_BYTE_55_MASK)
#define CAN_WORD_DATA_BYTE_59_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_59_SHIFT              (0U)
/*! DATA_BYTE_59 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_59(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_59_SHIFT)) & CAN_WORD_DATA_BYTE_59_MASK)
#define CAN_WORD_DATA_BYTE_63_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_63_SHIFT              (0U)
/*! DATA_BYTE_63 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_63(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_63_SHIFT)) & CAN_WORD_DATA_BYTE_63_MASK)
#define CAN_WORD_DATA_BYTE_2_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_2_SHIFT               (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_2(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_2_SHIFT)) & CAN_WORD_DATA_BYTE_2_MASK)
#define CAN_WORD_DATA_BYTE_6_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_6_SHIFT               (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_6(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_6_SHIFT)) & CAN_WORD_DATA_BYTE_6_MASK)
#define CAN_WORD_DATA_BYTE_10_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_10_SHIFT              (8U)
/*! DATA_BYTE_10 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_10(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_10_SHIFT)) & CAN_WORD_DATA_BYTE_10_MASK)
#define CAN_WORD_DATA_BYTE_14_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_14_SHIFT              (8U)
/*! DATA_BYTE_14 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_14(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_14_SHIFT)) & CAN_WORD_DATA_BYTE_14_MASK)
#define CAN_WORD_DATA_BYTE_18_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_18_SHIFT              (8U)
/*! DATA_BYTE_18 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_18(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_18_SHIFT)) & CAN_WORD_DATA_BYTE_18_MASK)
#define CAN_WORD_DATA_BYTE_22_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_22_SHIFT              (8U)
/*! DATA_BYTE_22 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_22(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_22_SHIFT)) & CAN_WORD_DATA_BYTE_22_MASK)
#define CAN_WORD_DATA_BYTE_26_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_26_SHIFT              (8U)
/*! DATA_BYTE_26 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_26(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_26_SHIFT)) & CAN_WORD_DATA_BYTE_26_MASK)
#define CAN_WORD_DATA_BYTE_30_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_30_SHIFT              (8U)
/*! DATA_BYTE_30 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_30(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_30_SHIFT)) & CAN_WORD_DATA_BYTE_30_MASK)
#define CAN_WORD_DATA_BYTE_34_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_34_SHIFT              (8U)
/*! DATA_BYTE_34 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_34(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_34_SHIFT)) & CAN_WORD_DATA_BYTE_34_MASK)
#define CAN_WORD_DATA_BYTE_38_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_38_SHIFT              (8U)
/*! DATA_BYTE_38 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_38(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_38_SHIFT)) & CAN_WORD_DATA_BYTE_38_MASK)
#define CAN_WORD_DATA_BYTE_42_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_42_SHIFT              (8U)
/*! DATA_BYTE_42 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_42(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_42_SHIFT)) & CAN_WORD_DATA_BYTE_42_MASK)
#define CAN_WORD_DATA_BYTE_46_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_46_SHIFT              (8U)
/*! DATA_BYTE_46 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_46(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_46_SHIFT)) & CAN_WORD_DATA_BYTE_46_MASK)
#define CAN_WORD_DATA_BYTE_50_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_50_SHIFT              (8U)
/*! DATA_BYTE_50 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_50(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_50_SHIFT)) & CAN_WORD_DATA_BYTE_50_MASK)
#define CAN_WORD_DATA_BYTE_54_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_54_SHIFT              (8U)
/*! DATA_BYTE_54 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_54(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_54_SHIFT)) & CAN_WORD_DATA_BYTE_54_MASK)
#define CAN_WORD_DATA_BYTE_58_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_58_SHIFT              (8U)
/*! DATA_BYTE_58 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_58(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_58_SHIFT)) & CAN_WORD_DATA_BYTE_58_MASK)
#define CAN_WORD_DATA_BYTE_62_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_62_SHIFT              (8U)
/*! DATA_BYTE_62 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_62(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_62_SHIFT)) & CAN_WORD_DATA_BYTE_62_MASK)
#define CAN_WORD_DATA_BYTE_1_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_1_SHIFT               (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_1(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_1_SHIFT)) & CAN_WORD_DATA_BYTE_1_MASK)
#define CAN_WORD_DATA_BYTE_5_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_5_SHIFT               (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_5(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_5_SHIFT)) & CAN_WORD_DATA_BYTE_5_MASK)
#define CAN_WORD_DATA_BYTE_9_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_9_SHIFT               (16U)
/*! DATA_BYTE_9 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_9(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_9_SHIFT)) & CAN_WORD_DATA_BYTE_9_MASK)
#define CAN_WORD_DATA_BYTE_13_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_13_SHIFT              (16U)
/*! DATA_BYTE_13 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_13(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_13_SHIFT)) & CAN_WORD_DATA_BYTE_13_MASK)
#define CAN_WORD_DATA_BYTE_17_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_17_SHIFT              (16U)
/*! DATA_BYTE_17 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_17(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_17_SHIFT)) & CAN_WORD_DATA_BYTE_17_MASK)
#define CAN_WORD_DATA_BYTE_21_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_21_SHIFT              (16U)
/*! DATA_BYTE_21 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_21(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_21_SHIFT)) & CAN_WORD_DATA_BYTE_21_MASK)
#define CAN_WORD_DATA_BYTE_25_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_25_SHIFT              (16U)
/*! DATA_BYTE_25 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_25(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_25_SHIFT)) & CAN_WORD_DATA_BYTE_25_MASK)
#define CAN_WORD_DATA_BYTE_29_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_29_SHIFT              (16U)
/*! DATA_BYTE_29 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_29(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_29_SHIFT)) & CAN_WORD_DATA_BYTE_29_MASK)
#define CAN_WORD_DATA_BYTE_33_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_33_SHIFT              (16U)
/*! DATA_BYTE_33 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_33(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_33_SHIFT)) & CAN_WORD_DATA_BYTE_33_MASK)
#define CAN_WORD_DATA_BYTE_37_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_37_SHIFT              (16U)
/*! DATA_BYTE_37 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_37(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_37_SHIFT)) & CAN_WORD_DATA_BYTE_37_MASK)
#define CAN_WORD_DATA_BYTE_41_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_41_SHIFT              (16U)
/*! DATA_BYTE_41 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_41(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_41_SHIFT)) & CAN_WORD_DATA_BYTE_41_MASK)
#define CAN_WORD_DATA_BYTE_45_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_45_SHIFT              (16U)
/*! DATA_BYTE_45 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_45(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_45_SHIFT)) & CAN_WORD_DATA_BYTE_45_MASK)
#define CAN_WORD_DATA_BYTE_49_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_49_SHIFT              (16U)
/*! DATA_BYTE_49 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_49(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_49_SHIFT)) & CAN_WORD_DATA_BYTE_49_MASK)
#define CAN_WORD_DATA_BYTE_53_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_53_SHIFT              (16U)
/*! DATA_BYTE_53 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_53(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_53_SHIFT)) & CAN_WORD_DATA_BYTE_53_MASK)
#define CAN_WORD_DATA_BYTE_57_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_57_SHIFT              (16U)
/*! DATA_BYTE_57 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_57(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_57_SHIFT)) & CAN_WORD_DATA_BYTE_57_MASK)
#define CAN_WORD_DATA_BYTE_61_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_61_SHIFT              (16U)
/*! DATA_BYTE_61 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_61(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_61_SHIFT)) & CAN_WORD_DATA_BYTE_61_MASK)
#define CAN_WORD_DATA_BYTE_0_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_0_SHIFT               (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_0(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_0_SHIFT)) & CAN_WORD_DATA_BYTE_0_MASK)
#define CAN_WORD_DATA_BYTE_4_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_4_SHIFT               (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_4(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_4_SHIFT)) & CAN_WORD_DATA_BYTE_4_MASK)
#define CAN_WORD_DATA_BYTE_8_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_8_SHIFT               (24U)
/*! DATA_BYTE_8 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_8(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_8_SHIFT)) & CAN_WORD_DATA_BYTE_8_MASK)
#define CAN_WORD_DATA_BYTE_12_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_12_SHIFT              (24U)
/*! DATA_BYTE_12 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_12(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_12_SHIFT)) & CAN_WORD_DATA_BYTE_12_MASK)
#define CAN_WORD_DATA_BYTE_16_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_16_SHIFT              (24U)
/*! DATA_BYTE_16 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_16(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_16_SHIFT)) & CAN_WORD_DATA_BYTE_16_MASK)
#define CAN_WORD_DATA_BYTE_20_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_20_SHIFT              (24U)
/*! DATA_BYTE_20 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_20(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_20_SHIFT)) & CAN_WORD_DATA_BYTE_20_MASK)
#define CAN_WORD_DATA_BYTE_24_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_24_SHIFT              (24U)
/*! DATA_BYTE_24 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_24(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_24_SHIFT)) & CAN_WORD_DATA_BYTE_24_MASK)
#define CAN_WORD_DATA_BYTE_28_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_28_SHIFT              (24U)
/*! DATA_BYTE_28 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_28(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_28_SHIFT)) & CAN_WORD_DATA_BYTE_28_MASK)
#define CAN_WORD_DATA_BYTE_32_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_32_SHIFT              (24U)
/*! DATA_BYTE_32 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_32(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_32_SHIFT)) & CAN_WORD_DATA_BYTE_32_MASK)
#define CAN_WORD_DATA_BYTE_36_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_36_SHIFT              (24U)
/*! DATA_BYTE_36 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_36(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_36_SHIFT)) & CAN_WORD_DATA_BYTE_36_MASK)
#define CAN_WORD_DATA_BYTE_40_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_40_SHIFT              (24U)
/*! DATA_BYTE_40 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_40(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_40_SHIFT)) & CAN_WORD_DATA_BYTE_40_MASK)
#define CAN_WORD_DATA_BYTE_44_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_44_SHIFT              (24U)
/*! DATA_BYTE_44 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_44(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_44_SHIFT)) & CAN_WORD_DATA_BYTE_44_MASK)
#define CAN_WORD_DATA_BYTE_48_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_48_SHIFT              (24U)
/*! DATA_BYTE_48 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_48(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_48_SHIFT)) & CAN_WORD_DATA_BYTE_48_MASK)
#define CAN_WORD_DATA_BYTE_52_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_52_SHIFT              (24U)
/*! DATA_BYTE_52 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_52(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_52_SHIFT)) & CAN_WORD_DATA_BYTE_52_MASK)
#define CAN_WORD_DATA_BYTE_56_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_56_SHIFT              (24U)
/*! DATA_BYTE_56 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_56(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_56_SHIFT)) & CAN_WORD_DATA_BYTE_56_MASK)
#define CAN_WORD_DATA_BYTE_60_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_60_SHIFT              (24U)
/*! DATA_BYTE_60 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_60(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_60_SHIFT)) & CAN_WORD_DATA_BYTE_60_MASK)
/*! @} */

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B                     (7U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B2                    (16U)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (32U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register */
/*! @{ */
#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)
#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)
#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)
#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (32U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register */
/*! @{ */
#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)
#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)
#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)
#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (32U)

/*! @name RXIMR - Rx Individual Mask registers */
/*! @{ */
#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
/*! MI - Individual Mask Bits
 */
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (32U)

/*! @name FDCTRL - CAN FD Control register */
/*! @{ */
#define CAN_FDCTRL_TDCVAL_MASK                   (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT                  (0U)
/*! TDCVAL - Transceiver Delay Compensation Value
 */
#define CAN_FDCTRL_TDCVAL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)
#define CAN_FDCTRL_TDCOFF_MASK                   (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT                  (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset
 */
#define CAN_FDCTRL_TDCOFF(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)
#define CAN_FDCTRL_TDCFAIL_MASK                  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT                 (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..Measured loop delay is in range.
 *  0b1..Measured loop delay is out of range.
 */
#define CAN_FDCTRL_TDCFAIL(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)
#define CAN_FDCTRL_TDCEN_MASK                    (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT                   (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..TDC is disabled
 *  0b1..TDC is enabled
 */
#define CAN_FDCTRL_TDCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)
#define CAN_FDCTRL_MBDSR0_MASK                   (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT                  (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..Selects 8 bytes per message buffer.
 *  0b01..Selects 16 bytes per message buffer.
 *  0b10..Selects 32 bytes per message buffer.
 *  0b11..Selects 64 bytes per message buffer.
 */
#define CAN_FDCTRL_MBDSR0(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)
#define CAN_FDCTRL_FDRATE_MASK                   (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT                  (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Transmit a frame in nominal rate. The BRS bit in the Tx MB has no effect.
 *  0b1..Transmit a frame with bit rate switching if the BRS bit in the Tx MB is recessive.
 */
#define CAN_FDCTRL_FDRATE(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing register */
/*! @{ */
#define CAN_FDCBT_FPSEG2_MASK                    (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT                   (0U)
/*! FPSEG2 - Fast Phase Segment 2
 */
#define CAN_FDCBT_FPSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)
#define CAN_FDCBT_FPSEG1_MASK                    (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT                   (5U)
/*! FPSEG1 - Fast Phase Segment 1
 */
#define CAN_FDCBT_FPSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)
#define CAN_FDCBT_FPROPSEG_MASK                  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT                 (10U)
/*! FPROPSEG - Fast Propagation Segment
 */
#define CAN_FDCBT_FPROPSEG(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)
#define CAN_FDCBT_FRJW_MASK                      (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT                     (16U)
/*! FRJW - Fast Resync Jump Width
 */
#define CAN_FDCBT_FRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)
#define CAN_FDCBT_FPRESDIV_MASK                  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT                 (20U)
/*! FPRESDIV - Fast Prescaler Division Factor
 */
#define CAN_FDCBT_FPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC register */
/*! @{ */
#define CAN_FDCRC_FD_TXCRC_MASK                  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT                 (0U)
/*! FD_TXCRC - Extended Transmitted CRC value
 */
#define CAN_FDCRC_FD_TXCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)
#define CAN_FDCRC_FD_MBCRC_MASK                  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT                 (24U)
/*! FD_MBCRC - CRC Mailbox Number for FD_TXCRC
 */
#define CAN_FDCRC_FD_MBCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN0 base address */
#define CAN0_BASE                                (0x40024000u)
/** Peripheral CAN0 base pointer */
#define CAN0                                     ((CAN_Type *)CAN0_BASE)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                           { CAN0_BASE }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { CAN0 }
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Tx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Wake_Up_IRQS                         { CAN0_IRQn }
#define CAN_Error_IRQS                           { CAN0_IRQn }
#define CAN_Bus_Off_IRQS                         { CAN0_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { CAN0_MB_IRQn }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral_Access_Layer CMP Peripheral Access Layer
 * @{
 */

/** CMP - Register Layout Typedef */
typedef struct {
  __IO uint8_t CR0;                                /**< CMP Control Register 0, offset: 0x0 */
  __IO uint8_t CR1;                                /**< CMP Control Register 1, offset: 0x1 */
  __IO uint8_t FPR;                                /**< CMP Filter Period Register, offset: 0x2 */
  __IO uint8_t SCR;                                /**< CMP Status and Control Register, offset: 0x3 */
  __IO uint8_t DACCR;                              /**< DAC Control Register, offset: 0x4 */
  __IO uint8_t MUXCR;                              /**< MUX Control Register, offset: 0x5 */
} CMP_Type;

/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/*! @name CR0 - CMP Control Register 0 */
/*! @{ */
#define CMP_CR0_HYSTCTR_MASK                     (0x3U)
#define CMP_CR0_HYSTCTR_SHIFT                    (0U)
/*! HYSTCTR - Comparator hard block hysteresis control
 *  0b00..Level 0
 *  0b01..Level 1
 *  0b10..Level 2
 *  0b11..Level 3
 */
#define CMP_CR0_HYSTCTR(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_CR0_HYSTCTR_SHIFT)) & CMP_CR0_HYSTCTR_MASK)
#define CMP_CR0_FILTER_CNT_MASK                  (0x70U)
#define CMP_CR0_FILTER_CNT_SHIFT                 (4U)
/*! FILTER_CNT - Filter Sample Count
 *  0b000..Filter is disabled. SE = 0, COUT = COUTA.
 *  0b001..One sample must agree. The comparator output is simply sampled.
 *  0b010..2 consecutive samples must agree.
 *  0b011..3 consecutive samples must agree.
 *  0b100..4 consecutive samples must agree.
 *  0b101..5 consecutive samples must agree.
 *  0b110..6 consecutive samples must agree.
 *  0b111..7 consecutive samples must agree.
 */
#define CMP_CR0_FILTER_CNT(x)                    (((uint8_t)(((uint8_t)(x)) << CMP_CR0_FILTER_CNT_SHIFT)) & CMP_CR0_FILTER_CNT_MASK)
/*! @} */

/*! @name CR1 - CMP Control Register 1 */
/*! @{ */
#define CMP_CR1_EN_MASK                          (0x1U)
#define CMP_CR1_EN_SHIFT                         (0U)
/*! EN - Comparator Module Enable
 *  0b0..Analog Comparator is disabled.
 *  0b1..Analog Comparator is enabled.
 */
#define CMP_CR1_EN(x)                            (((uint8_t)(((uint8_t)(x)) << CMP_CR1_EN_SHIFT)) & CMP_CR1_EN_MASK)
#define CMP_CR1_OPE_MASK                         (0x2U)
#define CMP_CR1_OPE_SHIFT                        (1U)
/*! OPE - Comparator Output Pin Enable
 *  0b0..CMPO is not available on the associated CMPO output pin. If the comparator does not own the pin, this field has no effect.
 *  0b1..CMPO is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the
 *       associated CMPO output pin if the comparator owns the pin. If the comparator does not own the field, this
 *       bit has no effect.
 */
#define CMP_CR1_OPE(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_CR1_OPE_SHIFT)) & CMP_CR1_OPE_MASK)
#define CMP_CR1_COS_MASK                         (0x4U)
#define CMP_CR1_COS_SHIFT                        (2U)
/*! COS - Comparator Output Select
 *  0b0..Set the filtered comparator output (CMPO) to equal COUT.
 *  0b1..Set the unfiltered comparator output (CMPO) to equal COUTA.
 */
#define CMP_CR1_COS(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_CR1_COS_SHIFT)) & CMP_CR1_COS_MASK)
#define CMP_CR1_INV_MASK                         (0x8U)
#define CMP_CR1_INV_SHIFT                        (3U)
/*! INV - Comparator INVERT
 *  0b0..Does not invert the comparator output.
 *  0b1..Inverts the comparator output.
 */
#define CMP_CR1_INV(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_CR1_INV_SHIFT)) & CMP_CR1_INV_MASK)
#define CMP_CR1_PMODE_MASK                       (0x10U)
#define CMP_CR1_PMODE_SHIFT                      (4U)
/*! PMODE - Power Mode Select
 *  0b0..Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
 *  0b1..High-Speed (HS) Comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.
 */
#define CMP_CR1_PMODE(x)                         (((uint8_t)(((uint8_t)(x)) << CMP_CR1_PMODE_SHIFT)) & CMP_CR1_PMODE_MASK)
#define CMP_CR1_TRIGM_MASK                       (0x20U)
#define CMP_CR1_TRIGM_SHIFT                      (5U)
/*! TRIGM - Trigger Mode Enable
 *  0b0..Trigger mode is disabled.
 *  0b1..Trigger mode is enabled.
 */
#define CMP_CR1_TRIGM(x)                         (((uint8_t)(((uint8_t)(x)) << CMP_CR1_TRIGM_SHIFT)) & CMP_CR1_TRIGM_MASK)
#define CMP_CR1_WE_MASK                          (0x40U)
#define CMP_CR1_WE_SHIFT                         (6U)
/*! WE - Windowing Enable
 *  0b0..Windowing mode is not selected.
 *  0b1..Windowing mode is selected.
 */
#define CMP_CR1_WE(x)                            (((uint8_t)(((uint8_t)(x)) << CMP_CR1_WE_SHIFT)) & CMP_CR1_WE_MASK)
#define CMP_CR1_SE_MASK                          (0x80U)
#define CMP_CR1_SE_SHIFT                         (7U)
/*! SE - Sample Enable
 *  0b0..Sampling mode is not selected.
 *  0b1..Sampling mode is selected.
 */
#define CMP_CR1_SE(x)                            (((uint8_t)(((uint8_t)(x)) << CMP_CR1_SE_SHIFT)) & CMP_CR1_SE_MASK)
/*! @} */

/*! @name FPR - CMP Filter Period Register */
/*! @{ */
#define CMP_FPR_FILT_PER_MASK                    (0xFFU)
#define CMP_FPR_FILT_PER_SHIFT                   (0U)
/*! FILT_PER - Filter Sample Period
 */
#define CMP_FPR_FILT_PER(x)                      (((uint8_t)(((uint8_t)(x)) << CMP_FPR_FILT_PER_SHIFT)) & CMP_FPR_FILT_PER_MASK)
/*! @} */

/*! @name SCR - CMP Status and Control Register */
/*! @{ */
#define CMP_SCR_COUT_MASK                        (0x1U)
#define CMP_SCR_COUT_SHIFT                       (0U)
/*! COUT - Analog Comparator Output
 */
#define CMP_SCR_COUT(x)                          (((uint8_t)(((uint8_t)(x)) << CMP_SCR_COUT_SHIFT)) & CMP_SCR_COUT_MASK)
#define CMP_SCR_CFF_MASK                         (0x2U)
#define CMP_SCR_CFF_SHIFT                        (1U)
/*! CFF - Analog Comparator Flag Falling
 *  0b0..Falling-edge on COUT has not been detected.
 *  0b1..Falling-edge on COUT has occurred.
 */
#define CMP_SCR_CFF(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_SCR_CFF_SHIFT)) & CMP_SCR_CFF_MASK)
#define CMP_SCR_CFR_MASK                         (0x4U)
#define CMP_SCR_CFR_SHIFT                        (2U)
/*! CFR - Analog Comparator Flag Rising
 *  0b0..Rising-edge on COUT has not been detected.
 *  0b1..Rising-edge on COUT has occurred.
 */
#define CMP_SCR_CFR(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_SCR_CFR_SHIFT)) & CMP_SCR_CFR_MASK)
#define CMP_SCR_IEF_MASK                         (0x8U)
#define CMP_SCR_IEF_SHIFT                        (3U)
/*! IEF - Comparator Interrupt Enable Falling
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_SCR_IEF(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_SCR_IEF_SHIFT)) & CMP_SCR_IEF_MASK)
#define CMP_SCR_IER_MASK                         (0x10U)
#define CMP_SCR_IER_SHIFT                        (4U)
/*! IER - Comparator Interrupt Enable Rising
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_SCR_IER(x)                           (((uint8_t)(((uint8_t)(x)) << CMP_SCR_IER_SHIFT)) & CMP_SCR_IER_MASK)
#define CMP_SCR_DMAEN_MASK                       (0x40U)
#define CMP_SCR_DMAEN_SHIFT                      (6U)
/*! DMAEN - DMA Enable Control
 *  0b0..DMA is disabled.
 *  0b1..DMA is enabled.
 */
#define CMP_SCR_DMAEN(x)                         (((uint8_t)(((uint8_t)(x)) << CMP_SCR_DMAEN_SHIFT)) & CMP_SCR_DMAEN_MASK)
/*! @} */

/*! @name DACCR - DAC Control Register */
/*! @{ */
#define CMP_DACCR_VOSEL_MASK                     (0x3FU)
#define CMP_DACCR_VOSEL_SHIFT                    (0U)
/*! VOSEL - DAC Output Voltage Select
 */
#define CMP_DACCR_VOSEL(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_DACCR_VOSEL_SHIFT)) & CMP_DACCR_VOSEL_MASK)
#define CMP_DACCR_VRSEL_MASK                     (0x40U)
#define CMP_DACCR_VRSEL_SHIFT                    (6U)
/*! VRSEL - Supply Voltage Reference Source Select
 *  0b0..Vin1 is selected as resistor ladder network supply reference.
 *  0b1..Vin2 is selected as resistor ladder network supply reference.
 */
#define CMP_DACCR_VRSEL(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_DACCR_VRSEL_SHIFT)) & CMP_DACCR_VRSEL_MASK)
#define CMP_DACCR_DACEN_MASK                     (0x80U)
#define CMP_DACCR_DACEN_SHIFT                    (7U)
/*! DACEN - DAC Enable
 *  0b0..DAC is disabled.
 *  0b1..DAC is enabled.
 */
#define CMP_DACCR_DACEN(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_DACCR_DACEN_SHIFT)) & CMP_DACCR_DACEN_MASK)
/*! @} */

/*! @name MUXCR - MUX Control Register */
/*! @{ */
#define CMP_MUXCR_MSEL_MASK                      (0x7U)
#define CMP_MUXCR_MSEL_SHIFT                     (0U)
/*! MSEL - Minus Input Mux Control
 *  0b000..IN0
 *  0b001..IN1
 *  0b010..IN2
 *  0b011..IN3
 *  0b100..IN4
 *  0b101..IN5
 *  0b110..IN6
 *  0b111..IN7
 */
#define CMP_MUXCR_MSEL(x)                        (((uint8_t)(((uint8_t)(x)) << CMP_MUXCR_MSEL_SHIFT)) & CMP_MUXCR_MSEL_MASK)
#define CMP_MUXCR_PSEL_MASK                      (0x38U)
#define CMP_MUXCR_PSEL_SHIFT                     (3U)
/*! PSEL - Plus Input Mux Control
 *  0b000..IN0
 *  0b001..IN1
 *  0b010..IN2
 *  0b011..IN3
 *  0b100..IN4
 *  0b101..IN5
 *  0b110..IN6
 *  0b111..IN7
 */
#define CMP_MUXCR_PSEL(x)                        (((uint8_t)(((uint8_t)(x)) << CMP_MUXCR_PSEL_SHIFT)) & CMP_MUXCR_PSEL_MASK)
#define CMP_MUXCR_PSTM_MASK                      (0x80U)
#define CMP_MUXCR_PSTM_SHIFT                     (7U)
/*! PSTM - Pass Through Mode Enable
 *  0b0..Pass Through Mode is disabled.
 *  0b1..Pass Through Mode is enabled.
 */
#define CMP_MUXCR_PSTM(x)                        (((uint8_t)(((uint8_t)(x)) << CMP_MUXCR_PSTM_SHIFT)) & CMP_MUXCR_PSTM_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
/** Peripheral CMP0 base address */
#define CMP0_BASE                                (0x40073000u)
/** Peripheral CMP0 base pointer */
#define CMP0                                     ((CMP_Type *)CMP0_BASE)
/** Array initializer of CMP peripheral base addresses */
#define CMP_BASE_ADDRS                           { CMP0_BASE }
/** Array initializer of CMP peripheral base pointers */
#define CMP_BASE_PTRS                            { CMP0 }
/** Interrupt vectors for the CMP peripheral type */
#define CMP_IRQS                                 { CMP0_IRQn }

/*!
 * @}
 */ /* end of group CMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Peripheral_Access_Layer CMT Peripheral Access Layer
 * @{
 */

/** CMT - Register Layout Typedef */
typedef struct {
  __IO uint8_t CGH1;                               /**< CMT Carrier Generator High Data Register 1, offset: 0x0 */
  __IO uint8_t CGL1;                               /**< CMT Carrier Generator Low Data Register 1, offset: 0x1 */
  __IO uint8_t CGH2;                               /**< CMT Carrier Generator High Data Register 2, offset: 0x2 */
  __IO uint8_t CGL2;                               /**< CMT Carrier Generator Low Data Register 2, offset: 0x3 */
  __IO uint8_t OC;                                 /**< CMT Output Control Register, offset: 0x4 */
  __IO uint8_t MSC;                                /**< CMT Modulator Status and Control Register, offset: 0x5 */
  __IO uint8_t CMD1;                               /**< CMT Modulator Data Register Mark High, offset: 0x6 */
  __IO uint8_t CMD2;                               /**< CMT Modulator Data Register Mark Low, offset: 0x7 */
  __IO uint8_t CMD3;                               /**< CMT Modulator Data Register Space High, offset: 0x8 */
  __IO uint8_t CMD4;                               /**< CMT Modulator Data Register Space Low, offset: 0x9 */
  __IO uint8_t PPS;                                /**< CMT Primary Prescaler Register, offset: 0xA */
  __IO uint8_t DMA;                                /**< CMT Direct Memory Access Register, offset: 0xB */
} CMT_Type;

/* ----------------------------------------------------------------------------
   -- CMT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Register_Masks CMT Register Masks
 * @{
 */

/*! @name CGH1 - CMT Carrier Generator High Data Register 1 */
/*! @{ */
#define CMT_CGH1_PH_MASK                         (0xFFU)
#define CMT_CGH1_PH_SHIFT                        (0U)
/*! PH - Primary Carrier High Time Data Value
 */
#define CMT_CGH1_PH(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGH1_PH_SHIFT)) & CMT_CGH1_PH_MASK)
/*! @} */

/*! @name CGL1 - CMT Carrier Generator Low Data Register 1 */
/*! @{ */
#define CMT_CGL1_PL_MASK                         (0xFFU)
#define CMT_CGL1_PL_SHIFT                        (0U)
/*! PL - Primary Carrier Low Time Data Value
 */
#define CMT_CGL1_PL(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGL1_PL_SHIFT)) & CMT_CGL1_PL_MASK)
/*! @} */

/*! @name CGH2 - CMT Carrier Generator High Data Register 2 */
/*! @{ */
#define CMT_CGH2_SH_MASK                         (0xFFU)
#define CMT_CGH2_SH_SHIFT                        (0U)
/*! SH - Secondary Carrier High Time Data Value
 */
#define CMT_CGH2_SH(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGH2_SH_SHIFT)) & CMT_CGH2_SH_MASK)
/*! @} */

/*! @name CGL2 - CMT Carrier Generator Low Data Register 2 */
/*! @{ */
#define CMT_CGL2_SL_MASK                         (0xFFU)
#define CMT_CGL2_SL_SHIFT                        (0U)
/*! SL - Secondary Carrier Low Time Data Value
 */
#define CMT_CGL2_SL(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGL2_SL_SHIFT)) & CMT_CGL2_SL_MASK)
/*! @} */

/*! @name OC - CMT Output Control Register */
/*! @{ */
#define CMT_OC_IROPEN_MASK                       (0x20U)
#define CMT_OC_IROPEN_SHIFT                      (5U)
/*! IROPEN - IRO Pin Enable
 *  0b0..The IRO signal is disabled.
 *  0b1..The IRO signal is enabled as output.
 */
#define CMT_OC_IROPEN(x)                         (((uint8_t)(((uint8_t)(x)) << CMT_OC_IROPEN_SHIFT)) & CMT_OC_IROPEN_MASK)
#define CMT_OC_CMTPOL_MASK                       (0x40U)
#define CMT_OC_CMTPOL_SHIFT                      (6U)
/*! CMTPOL - CMT Output Polarity
 *  0b0..The IRO signal is active-low.
 *  0b1..The IRO signal is active-high.
 */
#define CMT_OC_CMTPOL(x)                         (((uint8_t)(((uint8_t)(x)) << CMT_OC_CMTPOL_SHIFT)) & CMT_OC_CMTPOL_MASK)
#define CMT_OC_IROL_MASK                         (0x80U)
#define CMT_OC_IROL_SHIFT                        (7U)
/*! IROL - IRO Latch Control
 */
#define CMT_OC_IROL(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_OC_IROL_SHIFT)) & CMT_OC_IROL_MASK)
/*! @} */

/*! @name MSC - CMT Modulator Status and Control Register */
/*! @{ */
#define CMT_MSC_MCGEN_MASK                       (0x1U)
#define CMT_MSC_MCGEN_SHIFT                      (0U)
/*! MCGEN - Modulator and Carrier Generator Enable
 *  0b0..Modulator and carrier generator disabled
 *  0b1..Modulator and carrier generator enabled
 */
#define CMT_MSC_MCGEN(x)                         (((uint8_t)(((uint8_t)(x)) << CMT_MSC_MCGEN_SHIFT)) & CMT_MSC_MCGEN_MASK)
#define CMT_MSC_EOCIE_MASK                       (0x2U)
#define CMT_MSC_EOCIE_SHIFT                      (1U)
/*! EOCIE - End of Cycle Interrupt Enable
 *  0b0..CPU interrupt is disabled.
 *  0b1..CPU interrupt is enabled.
 */
#define CMT_MSC_EOCIE(x)                         (((uint8_t)(((uint8_t)(x)) << CMT_MSC_EOCIE_SHIFT)) & CMT_MSC_EOCIE_MASK)
#define CMT_MSC_FSK_MASK                         (0x4U)
#define CMT_MSC_FSK_SHIFT                        (2U)
/*! FSK - FSK Mode Select
 *  0b0..The CMT operates in Time or Baseband mode.
 *  0b1..The CMT operates in FSK mode.
 */
#define CMT_MSC_FSK(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_MSC_FSK_SHIFT)) & CMT_MSC_FSK_MASK)
#define CMT_MSC_BASE_MASK                        (0x8U)
#define CMT_MSC_BASE_SHIFT                       (3U)
/*! BASE - Baseband Enable
 *  0b0..Baseband mode is disabled.
 *  0b1..Baseband mode is enabled.
 */
#define CMT_MSC_BASE(x)                          (((uint8_t)(((uint8_t)(x)) << CMT_MSC_BASE_SHIFT)) & CMT_MSC_BASE_MASK)
#define CMT_MSC_EXSPC_MASK                       (0x10U)
#define CMT_MSC_EXSPC_SHIFT                      (4U)
/*! EXSPC - Extended Space Enable
 *  0b0..Extended space is disabled.
 *  0b1..Extended space is enabled.
 */
#define CMT_MSC_EXSPC(x)                         (((uint8_t)(((uint8_t)(x)) << CMT_MSC_EXSPC_SHIFT)) & CMT_MSC_EXSPC_MASK)
#define CMT_MSC_CMTDIV_MASK                      (0x60U)
#define CMT_MSC_CMTDIV_SHIFT                     (5U)
/*! CMTDIV - CMT Clock Divide Prescaler
 *  0b00..IF / 1
 *  0b01..IF / 2
 *  0b10..IF / 4
 *  0b11..IF / 8
 */
#define CMT_MSC_CMTDIV(x)                        (((uint8_t)(((uint8_t)(x)) << CMT_MSC_CMTDIV_SHIFT)) & CMT_MSC_CMTDIV_MASK)
#define CMT_MSC_EOCF_MASK                        (0x80U)
#define CMT_MSC_EOCF_SHIFT                       (7U)
/*! EOCF - End Of Cycle Status Flag
 *  0b0..End of modulation cycle has not occured since the flag last cleared.
 *  0b1..End of modulator cycle has occurred.
 */
#define CMT_MSC_EOCF(x)                          (((uint8_t)(((uint8_t)(x)) << CMT_MSC_EOCF_SHIFT)) & CMT_MSC_EOCF_MASK)
/*! @} */

/*! @name CMD1 - CMT Modulator Data Register Mark High */
/*! @{ */
#define CMT_CMD1_MB_MASK                         (0xFFU)
#define CMT_CMD1_MB_SHIFT                        (0U)
/*! MB - MB[15:8]
 */
#define CMT_CMD1_MB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD1_MB_SHIFT)) & CMT_CMD1_MB_MASK)
/*! @} */

/*! @name CMD2 - CMT Modulator Data Register Mark Low */
/*! @{ */
#define CMT_CMD2_MB_MASK                         (0xFFU)
#define CMT_CMD2_MB_SHIFT                        (0U)
/*! MB - MB[7:0]
 */
#define CMT_CMD2_MB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD2_MB_SHIFT)) & CMT_CMD2_MB_MASK)
/*! @} */

/*! @name CMD3 - CMT Modulator Data Register Space High */
/*! @{ */
#define CMT_CMD3_SB_MASK                         (0xFFU)
#define CMT_CMD3_SB_SHIFT                        (0U)
/*! SB - SB[15:8]
 */
#define CMT_CMD3_SB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD3_SB_SHIFT)) & CMT_CMD3_SB_MASK)
/*! @} */

/*! @name CMD4 - CMT Modulator Data Register Space Low */
/*! @{ */
#define CMT_CMD4_SB_MASK                         (0xFFU)
#define CMT_CMD4_SB_SHIFT                        (0U)
/*! SB - SB[7:0]
 */
#define CMT_CMD4_SB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD4_SB_SHIFT)) & CMT_CMD4_SB_MASK)
/*! @} */

/*! @name PPS - CMT Primary Prescaler Register */
/*! @{ */
#define CMT_PPS_PPSDIV_MASK                      (0xFU)
#define CMT_PPS_PPSDIV_SHIFT                     (0U)
/*! PPSDIV - Primary Prescaler Divider
 *  0b0000..Bus clock / 1
 *  0b0001..Bus clock / 2
 *  0b0010..Bus clock / 3
 *  0b0011..Bus clock / 4
 *  0b0100..Bus clock / 5
 *  0b0101..Bus clock / 6
 *  0b0110..Bus clock / 7
 *  0b0111..Bus clock / 8
 *  0b1000..Bus clock / 9
 *  0b1001..Bus clock / 10
 *  0b1010..Bus clock / 11
 *  0b1011..Bus clock / 12
 *  0b1100..Bus clock / 13
 *  0b1101..Bus clock / 14
 *  0b1110..Bus clock / 15
 *  0b1111..Bus clock / 16
 */
#define CMT_PPS_PPSDIV(x)                        (((uint8_t)(((uint8_t)(x)) << CMT_PPS_PPSDIV_SHIFT)) & CMT_PPS_PPSDIV_MASK)
/*! @} */

/*! @name DMA - CMT Direct Memory Access Register */
/*! @{ */
#define CMT_DMA_DMA_MASK                         (0x1U)
#define CMT_DMA_DMA_SHIFT                        (0U)
/*! DMA - DMA Enable
 *  0b0..DMA transfer request and done are disabled.
 *  0b1..DMA transfer request and done are enabled.
 */
#define CMT_DMA_DMA(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_DMA_DMA_SHIFT)) & CMT_DMA_DMA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMT_Register_Masks */


/* CMT - Peripheral instance base addresses */
/** Peripheral CMT base address */
#define CMT_BASE                                 (0x40062000u)
/** Peripheral CMT base pointer */
#define CMT                                      ((CMT_Type *)CMT_BASE)
/** Array initializer of CMT peripheral base addresses */
#define CMT_BASE_ADDRS                           { CMT_BASE }
/** Array initializer of CMT peripheral base pointers */
#define CMT_BASE_PTRS                            { CMT }
/** Interrupt vectors for the CMT peripheral type */
#define CMT_IRQS                                 { CMT_IRQn }

/*!
 * @}
 */ /* end of group CMT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DCDC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Peripheral_Access_Layer DCDC Peripheral Access Layer
 * @{
 */

/** DCDC - Register Layout Typedef */
typedef struct {
  __IO uint32_t REG0;                              /**< DCDC REGISTER 0, offset: 0x0 */
  __IO uint32_t REG1;                              /**< DCDC REGISTER 1, offset: 0x4 */
  __IO uint32_t REG2;                              /**< DCDC REGISTER 2, offset: 0x8 */
  __IO uint32_t REG3;                              /**< DCDC REGISTER 3, offset: 0xC */
  __IO uint32_t REG4;                              /**< DCDC REGISTER 4, offset: 0x10 */
       uint8_t RESERVED_0[4];
  __IO uint32_t REG6;                              /**< DCDC REGISTER 6, offset: 0x18 */
  __IO uint32_t REG7;                              /**< DCDC REGISTER 7, offset: 0x1C */
} DCDC_Type;

/* ----------------------------------------------------------------------------
   -- DCDC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Register_Masks DCDC Register Masks
 * @{
 */

/*! @name REG0 - DCDC REGISTER 0 */
/*! @{ */
#define DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_MASK (0x2U)
#define DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_SHIFT (1U)
/*! DCDC_DISABLE_AUTO_CLK_SWITCH
 *  0b0..Automatic clock switch feature is enabled
 *  0b1..Automatic clock switch feature is disabled
 */
#define DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_SHIFT)) & DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_MASK)
#define DCDC_REG0_DCDC_SEL_CLK_MASK              (0x4U)
#define DCDC_REG0_DCDC_SEL_CLK_SHIFT             (2U)
/*! DCDC_SEL_CLK
 *  0b0..Internal oscillator is used as DCDC clock
 *  0b1..External oscillator is used as DCDC clock (debug use only)
 */
#define DCDC_REG0_DCDC_SEL_CLK(x)                (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_SEL_CLK_SHIFT)) & DCDC_REG0_DCDC_SEL_CLK_MASK)
#define DCDC_REG0_DCDC_PWD_OSC_INT_MASK          (0x8U)
#define DCDC_REG0_DCDC_PWD_OSC_INT_SHIFT         (3U)
/*! DCDC_PWD_OSC_INT
 *  0b0..Internal oscillator is powered up
 *  0b1..Internal oscillator is powered down
 */
#define DCDC_REG0_DCDC_PWD_OSC_INT(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_PWD_OSC_INT_SHIFT)) & DCDC_REG0_DCDC_PWD_OSC_INT_MASK)
#define DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_MASK     (0x200U)
#define DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_SHIFT    (9U)
/*! DCDC_LP_DF_CMP_ENABLE
 *  0b1..DCDC compare the lower supply(relative to target value) with DCDC_LP_STATE_HYS_L. When it is lower than
 *       DCDC_LP_STATE_HYS_L, re-charge output. This is the recommended configuration to guarantee optimal operation
 *  0b0..DCDC compare the common mode sense of supply(relative to target value) with DCDC_LP_STATE_HYS_L. When it
 *       is lower than DCDC_LP_STATE_HYS_L, re-charge output.
 */
#define DCDC_REG0_DCDC_LP_DF_CMP_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_SHIFT)) & DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_MASK)
#define DCDC_REG0_DCDC_IN_DIV_CTRL_MASK          (0xC00U)
#define DCDC_REG0_DCDC_IN_DIV_CTRL_SHIFT         (10U)
/*! DCDC_IN_DIV_CTRL
 *  0b00..OFF
 *  0b01..DCDC_IN
 *  0b10..DCDC_IN / 2
 *  0b11..DCDC_IN / 4
 */
#define DCDC_REG0_DCDC_IN_DIV_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_IN_DIV_CTRL_SHIFT)) & DCDC_REG0_DCDC_IN_DIV_CTRL_MASK)
#define DCDC_REG0_DCDC_LP_STATE_HYS_L_MASK       (0x60000U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_L_SHIFT      (17U)
/*! DCDC_LP_STATE_HYS_L
 *  0b00..Target voltage value - 0 mV
 *  0b01..Target voltage value - 25 mV
 *  0b10..Target voltage value - 50 mV
 *  0b11..Target voltage value - 75 mV
 */
#define DCDC_REG0_DCDC_LP_STATE_HYS_L(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LP_STATE_HYS_L_SHIFT)) & DCDC_REG0_DCDC_LP_STATE_HYS_L_MASK)
#define DCDC_REG0_DCDC_LP_STATE_HYS_H_MASK       (0x180000U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_H_SHIFT      (19U)
/*! DCDC_LP_STATE_HYS_H
 *  0b00..Target voltage value + 0 mV
 *  0b01..Target voltage value + 25 mV
 *  0b10..Target voltage value + 50 mV
 *  0b11..Target voltage value + 75 mV
 */
#define DCDC_REG0_DCDC_LP_STATE_HYS_H(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LP_STATE_HYS_H_SHIFT)) & DCDC_REG0_DCDC_LP_STATE_HYS_H_MASK)
#define DCDC_REG0_HYST_LP_COMP_ADJ_MASK          (0x200000U)
#define DCDC_REG0_HYST_LP_COMP_ADJ_SHIFT         (21U)
/*! HYST_LP_COMP_ADJ
 *  0b0..Adjustment feature is disabled
 *  0b1..Adjustment feature is enabled
 */
#define DCDC_REG0_HYST_LP_COMP_ADJ(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_HYST_LP_COMP_ADJ_SHIFT)) & DCDC_REG0_HYST_LP_COMP_ADJ_MASK)
#define DCDC_REG0_HYST_LP_CMP_DISABLE_MASK       (0x400000U)
#define DCDC_REG0_HYST_LP_CMP_DISABLE_SHIFT      (22U)
/*! HYST_LP_CMP_DISABLE
 *  0b0..Hysteresis feature is enabled
 *  0b1..Hysteresis feature is disabled
 */
#define DCDC_REG0_HYST_LP_CMP_DISABLE(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_HYST_LP_CMP_DISABLE_SHIFT)) & DCDC_REG0_HYST_LP_CMP_DISABLE_MASK)
#define DCDC_REG0_OFFSET_RSNS_LP_ADJ_MASK        (0x800000U)
#define DCDC_REG0_OFFSET_RSNS_LP_ADJ_SHIFT       (23U)
/*! OFFSET_RSNS_LP_ADJ
 *  0b0..Adjustment feature is disabled
 *  0b1..Adjustment feature is enabled
 */
#define DCDC_REG0_OFFSET_RSNS_LP_ADJ(x)          (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_OFFSET_RSNS_LP_ADJ_SHIFT)) & DCDC_REG0_OFFSET_RSNS_LP_ADJ_MASK)
#define DCDC_REG0_OFFSET_RSNS_LP_DISABLE_MASK    (0x1000000U)
#define DCDC_REG0_OFFSET_RSNS_LP_DISABLE_SHIFT   (24U)
/*! OFFSET_RSNS_LP_DISABLE
 *  0b0..Hysteresis feature is enabled
 *  0b1..Hysteresis feature is disabled
 */
#define DCDC_REG0_OFFSET_RSNS_LP_DISABLE(x)      (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_OFFSET_RSNS_LP_DISABLE_SHIFT)) & DCDC_REG0_OFFSET_RSNS_LP_DISABLE_MASK)
#define DCDC_REG0_DCDC_LESS_I_MASK               (0x2000000U)
#define DCDC_REG0_DCDC_LESS_I_SHIFT              (25U)
/*! DCDC_LESS_I
 *  0b0..Use normal current for analog references
 *  0b1..Use reduced current for analog references
 */
#define DCDC_REG0_DCDC_LESS_I(x)                 (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LESS_I_SHIFT)) & DCDC_REG0_DCDC_LESS_I_MASK)
#define DCDC_REG0_PWD_CMP_OFFSET_MASK            (0x4000000U)
#define DCDC_REG0_PWD_CMP_OFFSET_SHIFT           (26U)
/*! PWD_CMP_OFFSET
 *  0b0..Output range comparator powered up.
 *  0b1..Output range comparator powered down.
 */
#define DCDC_REG0_PWD_CMP_OFFSET(x)              (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_PWD_CMP_OFFSET_SHIFT)) & DCDC_REG0_PWD_CMP_OFFSET_MASK)
#define DCDC_REG0_DCDC_XTALOK_DISABLE_MASK       (0x8000000U)
#define DCDC_REG0_DCDC_XTALOK_DISABLE_SHIFT      (27U)
#define DCDC_REG0_DCDC_XTALOK_DISABLE(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_XTALOK_DISABLE_SHIFT)) & DCDC_REG0_DCDC_XTALOK_DISABLE_MASK)
#define DCDC_REG0_PSWITCH_STATUS_MASK            (0x10000000U)
#define DCDC_REG0_PSWITCH_STATUS_SHIFT           (28U)
/*! PSWITCH_STATUS
 *  0b0..PSWITCH is low
 *  0b1..PSWITCH is high
 */
#define DCDC_REG0_PSWITCH_STATUS(x)              (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_PSWITCH_STATUS_SHIFT)) & DCDC_REG0_PSWITCH_STATUS_MASK)
#define DCDC_REG0_VLPS_CONFIG_DCDC_HP_MASK       (0x20000000U)
#define DCDC_REG0_VLPS_CONFIG_DCDC_HP_SHIFT      (29U)
/*! VLPS_CONFIG_DCDC_HP
 *  0b0..DCDC works in pulsed mode when SOC is in VLPS modes.
 *  0b1..DCDC works in continuous mode when SOC is in VLPS modes.
 */
#define DCDC_REG0_VLPS_CONFIG_DCDC_HP(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_VLPS_CONFIG_DCDC_HP_SHIFT)) & DCDC_REG0_VLPS_CONFIG_DCDC_HP_MASK)
#define DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_MASK  (0x40000000U)
#define DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_SHIFT (30U)
/*! VLPR_VLPW_CONFIG_DCDC_HP
 *  0b0..DCDC works in pulsed mode when SoC is in VLPR / VLPW modes.
 *  0b1..DCDC works in continuous mode when SoC is in VLPR / VLPW modes.
 */
#define DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_SHIFT)) & DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_MASK)
#define DCDC_REG0_DCDC_STS_DC_OK_MASK            (0x80000000U)
#define DCDC_REG0_DCDC_STS_DC_OK_SHIFT           (31U)
/*! DCDC_STS_DC_OK
 *  0b0..Unstable DCDC output voltage
 *  0b1..Stable DCDC output voltage
 */
#define DCDC_REG0_DCDC_STS_DC_OK(x)              (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_STS_DC_OK_SHIFT)) & DCDC_REG0_DCDC_STS_DC_OK_MASK)
/*! @} */

/*! @name REG1 - DCDC REGISTER 1 */
/*! @{ */
#define DCDC_REG1_POSLIMIT_BUCK_IN_MASK          (0x7FU)
#define DCDC_REG1_POSLIMIT_BUCK_IN_SHIFT         (0U)
#define DCDC_REG1_POSLIMIT_BUCK_IN(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_POSLIMIT_BUCK_IN_SHIFT)) & DCDC_REG1_POSLIMIT_BUCK_IN_MASK)
#define DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_MASK (0x200000U)
#define DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_SHIFT (21U)
#define DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_SHIFT)) & DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_MASK)
#define DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_MASK (0x400000U)
#define DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_SHIFT (22U)
#define DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_SHIFT)) & DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_MASK)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_MASK  (0x800000U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_SHIFT (23U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_SHIFT)) & DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_MASK)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_MASK  (0x1000000U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_SHIFT (24U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_SHIFT)) & DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_MASK)
/*! @} */

/*! @name REG2 - DCDC REGISTER 2 */
/*! @{ */
#define DCDC_REG2_DCDC_LOOPCTRL_EN_RCSCALE_MASK  (0x600U)
#define DCDC_REG2_DCDC_LOOPCTRL_EN_RCSCALE_SHIFT (9U)
/*! DCDC_LOOPCTRL_EN_RCSCALE
 *  0b00..Default response time
 *  0b01..2 times faster than default
 *  0b10..4 times faster than default
 */
#define DCDC_REG2_DCDC_LOOPCTRL_EN_RCSCALE(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG2_DCDC_LOOPCTRL_EN_RCSCALE_SHIFT)) & DCDC_REG2_DCDC_LOOPCTRL_EN_RCSCALE_MASK)
#define DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_MASK   (0x2000U)
#define DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_SHIFT  (13U)
/*! DCDC_LOOPCTRL_HYST_SIGN
 *  0b0..Hysteresis sign not inverted
 *  0b1..Hysteresis sign inverted (proper switching gauranteed)
 */
#define DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN(x)     (((uint32_t)(((uint32_t)(x)) << DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_SHIFT)) & DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_MASK)
#define DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_MASK (0x8000U)
#define DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_SHIFT (15U)
/*! DCDC_BATTMONITOR_EN_BATADJ
 *  0b0..Disable the usage of the DCDC_BATTMONITOR_BATT_VAL value to calculate DCDC loop control
 *  0b1..Enable the usage of DCDC_BATTMONITOR_BATT_VAL value to calculate DCDC loop control
 */
#define DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ(x)  (((uint32_t)(((uint32_t)(x)) << DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_SHIFT)) & DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_MASK)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_MASK (0x3FF0000U)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_SHIFT (16U)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL(x)   (((uint32_t)(((uint32_t)(x)) << DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_SHIFT)) & DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_MASK)
/*! @} */

/*! @name REG3 - DCDC REGISTER 3 */
/*! @{ */
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG_MASK       (0x3FU)
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG_SHIFT      (0U)
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P8CTRL_TRG_SHIFT)) & DCDC_REG3_DCDC_VDD1P8CTRL_TRG_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_MASK  (0x7C0U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_SHIFT (6U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_MASK     (0x1E0000U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_SHIFT    (17U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN(x)       (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_MASK)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_MASK (0x200000U)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_SHIFT (21U)
/*! DCDC_MINPWR_DC_HALFCLK_PULSED
 *  0b0..Pulsed mode uses normal operation for DCDC clock
 *  0b1..Pulsed mode uses half frequency DCDC clock operation
 */
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_SHIFT)) & DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_MASK)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_MASK (0x400000U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_SHIFT (22U)
/*! DCDC_MINPWR_DOUBLE_FETS_PULSED
 *  0b0..Pulsed mode uses normal output configuration
 *  0b1..Pulsed mode uses double FET output configuration
 */
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_SHIFT)) & DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_MASK)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_MASK (0x800000U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_SHIFT (23U)
/*! DCDC_MINPWR_HALF_FETS_PULSED
 *  0b0..Pulsed mode uses normal output configuration
 *  0b1..Pulsed mode uses half FET output configuration
 */
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_SHIFT)) & DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_MASK)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_MASK    (0x1000000U)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_SHIFT   (24U)
/*! DCDC_MINPWR_DC_HALFCLK
 *  0b0..Normal operation for DCDC clock
 *  0b1..DCDC clock operates at half frequency
 */
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK(x)      (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_SHIFT)) & DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_MASK)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_MASK   (0x2000000U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_SHIFT  (25U)
/*! DCDC_MINPWR_DOUBLE_FETS
 *  0b0..Normal operation
 *  0b1..Use Double FET
 */
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS(x)     (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_SHIFT)) & DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_MASK)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_MASK     (0x4000000U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_SHIFT    (26U)
/*! DCDC_MINPWR_HALF_FETS
 *  0b0..Normal operation
 *  0b1..Use Half FET
 */
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS(x)       (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_MINPWR_HALF_FETS_SHIFT)) & DCDC_REG3_DCDC_MINPWR_HALF_FETS_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_MASK (0x20000000U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_SHIFT (29U)
/*! DCDC_VDD1P5CTRL_DISABLE_STEP
 *  0b0..VDD_1P5 stepping enabled
 *  0b1..VDD_1P5 stepping disabled
 */
#define DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_MASK)
#define DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_MASK (0x40000000U)
#define DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_SHIFT (30U)
/*! DCDC_VDD1P8CTRL_DISABLE_STEP
 *  0b0..VDD_1P8 stepping enabled
 *  0b1..VDD_1P8 stepping disabled
 */
#define DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP(x) (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_SHIFT)) & DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_MASK)
/*! @} */

/*! @name REG4 - DCDC REGISTER 4 */
/*! @{ */
#define DCDC_REG4_DCDC_SW_SHUTDOWN_MASK          (0x1U)
#define DCDC_REG4_DCDC_SW_SHUTDOWN_SHIFT         (0U)
/*! DCDC_SW_SHUTDOWN - Shut down DCDC in buck mode. DCDC can be turned on by pulling PSWITCH to high
 *    momentarily (DCDC Turn on time (TDCDC_ON; refer to the data sheet for specific time). This
 *    bit should not be used in buck mode when PSWITCH is tied to DCDC_IN.
 */
#define DCDC_REG4_DCDC_SW_SHUTDOWN(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG4_DCDC_SW_SHUTDOWN_SHIFT)) & DCDC_REG4_DCDC_SW_SHUTDOWN_MASK)
#define DCDC_REG4_UNLOCK_MASK                    (0xFFFF0000U)
#define DCDC_REG4_UNLOCK_SHIFT                   (16U)
#define DCDC_REG4_UNLOCK(x)                      (((uint32_t)(((uint32_t)(x)) << DCDC_REG4_UNLOCK_SHIFT)) & DCDC_REG4_UNLOCK_MASK)
/*! @} */

/*! @name REG6 - DCDC REGISTER 6 */
/*! @{ */
#define DCDC_REG6_PSWITCH_INT_RISE_EN_MASK       (0x1U)
#define DCDC_REG6_PSWITCH_INT_RISE_EN_SHIFT      (0U)
/*! PSWITCH_INT_RISE_EN
 *  0b0..PSWITCH rising edge interrupt disabled
 *  0b1..PSWITCH rising edge interrupt enabled
 */
#define DCDC_REG6_PSWITCH_INT_RISE_EN(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG6_PSWITCH_INT_RISE_EN_SHIFT)) & DCDC_REG6_PSWITCH_INT_RISE_EN_MASK)
#define DCDC_REG6_PSWITCH_INT_FALL_EN_MASK       (0x2U)
#define DCDC_REG6_PSWITCH_INT_FALL_EN_SHIFT      (1U)
/*! PSWITCH_INT_FALL_EN
 *  0b0..PSWITCH falling edge interrupt disabled
 *  0b1..PSWITCH falling edge interrupt enabled
 */
#define DCDC_REG6_PSWITCH_INT_FALL_EN(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG6_PSWITCH_INT_FALL_EN_SHIFT)) & DCDC_REG6_PSWITCH_INT_FALL_EN_MASK)
#define DCDC_REG6_PSWITCH_INT_CLEAR_MASK         (0x4U)
#define DCDC_REG6_PSWITCH_INT_CLEAR_SHIFT        (2U)
/*! PSWITCH_INT_CLEAR
 *  0b0..No effect
 *  0b1..Clear PSWITCH interrupt
 */
#define DCDC_REG6_PSWITCH_INT_CLEAR(x)           (((uint32_t)(((uint32_t)(x)) << DCDC_REG6_PSWITCH_INT_CLEAR_SHIFT)) & DCDC_REG6_PSWITCH_INT_CLEAR_MASK)
#define DCDC_REG6_PSWITCH_INT_MUTE_MASK          (0x8U)
#define DCDC_REG6_PSWITCH_INT_MUTE_SHIFT         (3U)
#define DCDC_REG6_PSWITCH_INT_MUTE(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG6_PSWITCH_INT_MUTE_SHIFT)) & DCDC_REG6_PSWITCH_INT_MUTE_MASK)
#define DCDC_REG6_PSWITCH_INT_STS_MASK           (0x80000000U)
#define DCDC_REG6_PSWITCH_INT_STS_SHIFT          (31U)
/*! PSWITCH_INT_STS
 *  0b0..PSWITCH interrupt has not occurred
 *  0b1..PSWITCH interrupt has occurred
 */
#define DCDC_REG6_PSWITCH_INT_STS(x)             (((uint32_t)(((uint32_t)(x)) << DCDC_REG6_PSWITCH_INT_STS_SHIFT)) & DCDC_REG6_PSWITCH_INT_STS_MASK)
/*! @} */

/*! @name REG7 - DCDC REGISTER 7 */
/*! @{ */
#define DCDC_REG7_INTEGRATOR_VALUE_MASK          (0x7FFFFU)
#define DCDC_REG7_INTEGRATOR_VALUE_SHIFT         (0U)
#define DCDC_REG7_INTEGRATOR_VALUE(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG7_INTEGRATOR_VALUE_SHIFT)) & DCDC_REG7_INTEGRATOR_VALUE_MASK)
#define DCDC_REG7_INTEGRATOR_VALUE_SEL_MASK      (0x80000U)
#define DCDC_REG7_INTEGRATOR_VALUE_SEL_SHIFT     (19U)
/*! INTEGRATOR_VALUE_SEL
 *  0b0..Select the saved value in hardware.
 *  0b1..Select the integrator value in this register.
 */
#define DCDC_REG7_INTEGRATOR_VALUE_SEL(x)        (((uint32_t)(((uint32_t)(x)) << DCDC_REG7_INTEGRATOR_VALUE_SEL_SHIFT)) & DCDC_REG7_INTEGRATOR_VALUE_SEL_MASK)
#define DCDC_REG7_PULSE_RUN_SPEEDUP_MASK         (0x100000U)
#define DCDC_REG7_PULSE_RUN_SPEEDUP_SHIFT        (20U)
/*! PULSE_RUN_SPEEDUP
 *  0b0..Pulse run speedup feature disabled
 *  0b1..Pulse run speedup feature enabled
 */
#define DCDC_REG7_PULSE_RUN_SPEEDUP(x)           (((uint32_t)(((uint32_t)(x)) << DCDC_REG7_PULSE_RUN_SPEEDUP_SHIFT)) & DCDC_REG7_PULSE_RUN_SPEEDUP_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DCDC_Register_Masks */


/* DCDC - Peripheral instance base addresses */
/** Peripheral DCDC base address */
#define DCDC_BASE                                (0x4005A000u)
/** Peripheral DCDC base pointer */
#define DCDC                                     ((DCDC_Type *)DCDC_BASE)
/** Array initializer of DCDC peripheral base addresses */
#define DCDC_BASE_ADDRS                          { DCDC_BASE }
/** Array initializer of DCDC peripheral base pointers */
#define DCDC_BASE_PTRS                           { DCDC }
/* Backward compatibility */
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL_MASK               DCDC_REG0_DCDC_IN_DIV_CTRL_MASK
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL_SHIFT              DCDC_REG0_DCDC_IN_DIV_CTRL_SHIFT
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL(x)                 DCDC_REG0_DCDC_IN_DIV_CTRL(x)


/*!
 * @}
 */ /* end of group DCDC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR;                                /**< Control, offset: 0x0 */
  __I  uint32_t ES;                                /**< Error Status, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ERQ;                               /**< Enable Request, offset: 0xC */
       uint8_t RESERVED_1[4];
  __IO uint32_t EEI;                               /**< Enable Error Interrupt, offset: 0x14 */
  __O  uint8_t CEEI;                               /**< Clear Enable Error Interrupt, offset: 0x18 */
  __O  uint8_t SEEI;                               /**< Set Enable Error Interrupt, offset: 0x19 */
  __O  uint8_t CERQ;                               /**< Clear Enable Request, offset: 0x1A */
  __O  uint8_t SERQ;                               /**< Set Enable Request, offset: 0x1B */
  __O  uint8_t CDNE;                               /**< Clear DONE Status Bit, offset: 0x1C */
  __O  uint8_t SSRT;                               /**< Set START Bit, offset: 0x1D */
  __O  uint8_t CERR;                               /**< Clear Error, offset: 0x1E */
  __O  uint8_t CINT;                               /**< Clear Interrupt Request, offset: 0x1F */
       uint8_t RESERVED_2[4];
  __IO uint32_t INT;                               /**< Interrupt Request, offset: 0x24 */
       uint8_t RESERVED_3[4];
  __IO uint32_t ERR;                               /**< Error, offset: 0x2C */
       uint8_t RESERVED_4[4];
  __I  uint32_t HRS;                               /**< Hardware Request Status, offset: 0x34 */
       uint8_t RESERVED_5[12];
  __IO uint32_t EARS;                              /**< Enable Asynchronous Request in Stop, offset: 0x44 */
       uint8_t RESERVED_6[184];
  __IO uint8_t DCHPRI3;                            /**< Channel Priority, offset: 0x100 */
  __IO uint8_t DCHPRI2;                            /**< Channel Priority, offset: 0x101 */
  __IO uint8_t DCHPRI1;                            /**< Channel Priority, offset: 0x102 */
  __IO uint8_t DCHPRI0;                            /**< Channel Priority, offset: 0x103 */
       uint8_t RESERVED_7[3836];
  struct {                                         /* offset: 0x1000, array step: 0x20 */
    __IO uint32_t SADDR;                             /**< TCD Source Address, array offset: 0x1000, array step: 0x20 */
    __IO uint16_t SOFF;                              /**< TCD Signed Source Address Offset, array offset: 0x1004, array step: 0x20 */
    __IO uint16_t ATTR;                              /**< TCD Transfer Attributes, array offset: 0x1006, array step: 0x20 */
    union {                                          /* offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLNO;                       /**< TCD Minor Byte Count (Minor Loop Mapping Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFNO;                    /**< TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFYES;                   /**< TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled), array offset: 0x1008, array step: 0x20 */
    };
    __IO uint32_t SLAST;                             /**< TCD Last Source Address Adjustment, array offset: 0x100C, array step: 0x20 */
    __IO uint32_t DADDR;                             /**< TCD Destination Address, array offset: 0x1010, array step: 0x20 */
    __IO uint16_t DOFF;                              /**< TCD Signed Destination Address Offset, array offset: 0x1014, array step: 0x20 */
    union {                                          /* offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKNO;                     /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKYES;                    /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x1016, array step: 0x20 */
    };
    __IO uint32_t DLAST_SGA;                         /**< TCD Last Destination Address Adjustment/Scatter Gather Address, array offset: 0x1018, array step: 0x20 */
    __IO uint16_t CSR;                               /**< TCD Control and Status, array offset: 0x101C, array step: 0x20 */
    union {                                          /* offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKNO;                     /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKYES;                    /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x101E, array step: 0x20 */
    };
  } TCD[4];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CR - Control */
/*! @{ */
#define DMA_CR_EDBG_MASK                         (0x2U)
#define DMA_CR_EDBG_SHIFT                        (1U)
/*! EDBG - Enable Debug
 *  0b0... When in debug mode, the DMA continues to operate.
 *  0b1..Assertion of system debug control input is effective
 */
#define DMA_CR_EDBG(x)                           (((uint32_t)(((uint32_t)(x)) << DMA_CR_EDBG_SHIFT)) & DMA_CR_EDBG_MASK)
#define DMA_CR_ERCA_MASK                         (0x4U)
#define DMA_CR_ERCA_SHIFT                        (2U)
/*! ERCA - Enable Round Robin Channel Arbitration
 *  0b0..Fixed priority arbitration
 *  0b1..Round robin arbitration
 */
#define DMA_CR_ERCA(x)                           (((uint32_t)(((uint32_t)(x)) << DMA_CR_ERCA_SHIFT)) & DMA_CR_ERCA_MASK)
#define DMA_CR_HOE_MASK                          (0x10U)
#define DMA_CR_HOE_SHIFT                         (4U)
/*! HOE - Halt On Error
 *  0b0..Normal operation
 *  0b1..Error causes HALT field to be automatically set to 1
 */
#define DMA_CR_HOE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_CR_HOE_SHIFT)) & DMA_CR_HOE_MASK)
#define DMA_CR_HALT_MASK                         (0x20U)
#define DMA_CR_HALT_SHIFT                        (5U)
/*! HALT - Halt DMA Operations
 *  0b0..Normal operation
 *  0b1..DMA operations halted
 */
#define DMA_CR_HALT(x)                           (((uint32_t)(((uint32_t)(x)) << DMA_CR_HALT_SHIFT)) & DMA_CR_HALT_MASK)
#define DMA_CR_CLM_MASK                          (0x40U)
#define DMA_CR_CLM_SHIFT                         (6U)
/*! CLM - Continuous Link Mode
 *  0b0..Continuous link mode is off
 *  0b1..Continuous link mode is on
 */
#define DMA_CR_CLM(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_CR_CLM_SHIFT)) & DMA_CR_CLM_MASK)
#define DMA_CR_EMLM_MASK                         (0x80U)
#define DMA_CR_EMLM_SHIFT                        (7U)
/*! EMLM - Enable Minor Loop Mapping
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DMA_CR_EMLM(x)                           (((uint32_t)(((uint32_t)(x)) << DMA_CR_EMLM_SHIFT)) & DMA_CR_EMLM_MASK)
#define DMA_CR_ECX_MASK                          (0x10000U)
#define DMA_CR_ECX_SHIFT                         (16U)
/*! ECX - Error Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_CR_ECX(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_CR_ECX_SHIFT)) & DMA_CR_ECX_MASK)
#define DMA_CR_CX_MASK                           (0x20000U)
#define DMA_CR_CX_SHIFT                          (17U)
/*! CX - Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_CR_CX(x)                             (((uint32_t)(((uint32_t)(x)) << DMA_CR_CX_SHIFT)) & DMA_CR_CX_MASK)
#define DMA_CR_ACTIVE_MASK                       (0x80000000U)
#define DMA_CR_ACTIVE_SHIFT                      (31U)
/*! ACTIVE - DMA Active Status
 *  0b0..eDMA is idle
 *  0b1..eDMA is executing a channel
 */
#define DMA_CR_ACTIVE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CR_ACTIVE_SHIFT)) & DMA_CR_ACTIVE_MASK)
/*! @} */

/*! @name ES - Error Status */
/*! @{ */
#define DMA_ES_DBE_MASK                          (0x1U)
#define DMA_ES_DBE_SHIFT                         (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error.
 *  0b1..The most-recently recorded error was a bus error on a destination write.
 */
#define DMA_ES_DBE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_DBE_SHIFT)) & DMA_ES_DBE_MASK)
#define DMA_ES_SBE_MASK                          (0x2U)
#define DMA_ES_SBE_SHIFT                         (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error.
 *  0b1..The most-recently recorded error was a bus error on a source read.
 */
#define DMA_ES_SBE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_SBE_SHIFT)) & DMA_ES_SBE_MASK)
#define DMA_ES_SGE_MASK                          (0x4U)
#define DMA_ES_SGE_SHIFT                         (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_DLASTSGA field.
 */
#define DMA_ES_SGE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_SGE_SHIFT)) & DMA_ES_SGE_MASK)
#define DMA_ES_NCE_MASK                          (0x8U)
#define DMA_ES_NCE_SHIFT                         (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER
 *       fields. TCDn_NBYTES is not a multiple of TCDn_ATTR[SSIZE] and TCDn_ATTR[DSIZE], or TCDn_CITER[CITER] is equal
 *       to zero, or TCDn_CITER[ELINK] is not equal to TCDn_BITER[ELINK].
 */
#define DMA_ES_NCE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_NCE_SHIFT)) & DMA_ES_NCE_MASK)
#define DMA_ES_DOE_MASK                          (0x10U)
#define DMA_ES_DOE_SHIFT                         (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].
 */
#define DMA_ES_DOE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_DOE_SHIFT)) & DMA_ES_DOE_MASK)
#define DMA_ES_DAE_MASK                          (0x20U)
#define DMA_ES_DAE_SHIFT                         (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_DADDR field. TCDn_DADDR
 *       is inconsistent with TCDn_ATTR[DSIZE].
 */
#define DMA_ES_DAE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_DAE_SHIFT)) & DMA_ES_DAE_MASK)
#define DMA_ES_SOE_MASK                          (0x40U)
#define DMA_ES_SOE_SHIFT                         (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].
 */
#define DMA_ES_SOE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_SOE_SHIFT)) & DMA_ES_SOE_MASK)
#define DMA_ES_SAE_MASK                          (0x80U)
#define DMA_ES_SAE_SHIFT                         (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error.
 *  0b1..The most-recently recorded error was a configuration error detected in the TCDn_SADDR field. TCDn_SADDR
 *       is inconsistent with TCDn_ATTR[SSIZE].
 */
#define DMA_ES_SAE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_SAE_SHIFT)) & DMA_ES_SAE_MASK)
#define DMA_ES_ERRCHN_MASK                       (0x300U)
#define DMA_ES_ERRCHN_SHIFT                      (8U)
/*! ERRCHN - Error Channel Number or Canceled Channel Number
 */
#define DMA_ES_ERRCHN(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_ES_ERRCHN_SHIFT)) & DMA_ES_ERRCHN_MASK)
#define DMA_ES_CPE_MASK                          (0x4000U)
#define DMA_ES_CPE_SHIFT                         (14U)
/*! CPE - Channel Priority Error
 *  0b0..No channel priority error.
 *  0b1..The most-recently recorded error was a configuration error in the channel priorities. Channel priorities are not unique.
 */
#define DMA_ES_CPE(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_CPE_SHIFT)) & DMA_ES_CPE_MASK)
#define DMA_ES_ECX_MASK                          (0x10000U)
#define DMA_ES_ECX_SHIFT                         (16U)
/*! ECX - Transfer Canceled
 *  0b0..No canceled transfers
 *  0b1..The most-recently recorded entry was a canceled transfer initiated by the error cancel transfer field
 */
#define DMA_ES_ECX(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_ECX_SHIFT)) & DMA_ES_ECX_MASK)
#define DMA_ES_VLD_MASK                          (0x80000000U)
#define DMA_ES_VLD_SHIFT                         (31U)
/*! VLD - Logical OR of all ERR status fields
 *  0b0..No ERR fields are 1
 *  0b1..At least one ERR field is 1, indicating a valid error exists that has not been cleared
 */
#define DMA_ES_VLD(x)                            (((uint32_t)(((uint32_t)(x)) << DMA_ES_VLD_SHIFT)) & DMA_ES_VLD_MASK)
/*! @} */

/*! @name ERQ - Enable Request */
/*! @{ */
#define DMA_ERQ_ERQ0_MASK                        (0x1U)
#define DMA_ERQ_ERQ0_SHIFT                       (0U)
/*! ERQ0 - Enable DMA Request 0
 *  0b0..The DMA request signal for channel 0 is disabled
 *  0b1..The DMA request signal for channel 0 is enabled
 */
#define DMA_ERQ_ERQ0(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERQ_ERQ0_SHIFT)) & DMA_ERQ_ERQ0_MASK)
#define DMA_ERQ_ERQ1_MASK                        (0x2U)
#define DMA_ERQ_ERQ1_SHIFT                       (1U)
/*! ERQ1 - Enable DMA Request 1
 *  0b0..The DMA request signal for channel 1 is disabled
 *  0b1..The DMA request signal for channel 1 is enabled
 */
#define DMA_ERQ_ERQ1(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERQ_ERQ1_SHIFT)) & DMA_ERQ_ERQ1_MASK)
#define DMA_ERQ_ERQ2_MASK                        (0x4U)
#define DMA_ERQ_ERQ2_SHIFT                       (2U)
/*! ERQ2 - Enable DMA Request 2
 *  0b0..The DMA request signal for channel 2 is disabled
 *  0b1..The DMA request signal for channel 2 is enabled
 */
#define DMA_ERQ_ERQ2(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERQ_ERQ2_SHIFT)) & DMA_ERQ_ERQ2_MASK)
#define DMA_ERQ_ERQ3_MASK                        (0x8U)
#define DMA_ERQ_ERQ3_SHIFT                       (3U)
/*! ERQ3 - Enable DMA Request 3
 *  0b0..The DMA request signal for channel 3 is disabled
 *  0b1..The DMA request signal for channel 3 is enabled
 */
#define DMA_ERQ_ERQ3(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERQ_ERQ3_SHIFT)) & DMA_ERQ_ERQ3_MASK)
/*! @} */

/*! @name EEI - Enable Error Interrupt */
/*! @{ */
#define DMA_EEI_EEI0_MASK                        (0x1U)
#define DMA_EEI_EEI0_SHIFT                       (0U)
/*! EEI0 - Enable Error Interrupt 0
 *  0b0..The error signal for channel 0 does not generate an error interrupt
 *  0b1..The assertion of the error signal for channel 0 generates an error interrupt request
 */
#define DMA_EEI_EEI0(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_EEI_EEI0_SHIFT)) & DMA_EEI_EEI0_MASK)
#define DMA_EEI_EEI1_MASK                        (0x2U)
#define DMA_EEI_EEI1_SHIFT                       (1U)
/*! EEI1 - Enable Error Interrupt 1
 *  0b0..The error signal for channel 1 does not generate an error interrupt
 *  0b1..The assertion of the error signal for channel 1 generates an error interrupt request
 */
#define DMA_EEI_EEI1(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_EEI_EEI1_SHIFT)) & DMA_EEI_EEI1_MASK)
#define DMA_EEI_EEI2_MASK                        (0x4U)
#define DMA_EEI_EEI2_SHIFT                       (2U)
/*! EEI2 - Enable Error Interrupt 2
 *  0b0..The error signal for channel 2 does not generate an error interrupt
 *  0b1..The assertion of the error signal for channel 2 generates an error interrupt request
 */
#define DMA_EEI_EEI2(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_EEI_EEI2_SHIFT)) & DMA_EEI_EEI2_MASK)
#define DMA_EEI_EEI3_MASK                        (0x8U)
#define DMA_EEI_EEI3_SHIFT                       (3U)
/*! EEI3 - Enable Error Interrupt 3
 *  0b0..The error signal for channel 3 does not generate an error interrupt
 *  0b1..The assertion of the error signal for channel 3 generates an error interrupt request
 */
#define DMA_EEI_EEI3(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_EEI_EEI3_SHIFT)) & DMA_EEI_EEI3_MASK)
/*! @} */

/*! @name CEEI - Clear Enable Error Interrupt */
/*! @{ */
#define DMA_CEEI_CEEI_MASK                       (0x3U)
#define DMA_CEEI_CEEI_SHIFT                      (0U)
/*! CEEI - Clear Enable Error Interrupt
 */
#define DMA_CEEI_CEEI(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CEEI_CEEI_SHIFT)) & DMA_CEEI_CEEI_MASK)
#define DMA_CEEI_CAEE_MASK                       (0x40U)
#define DMA_CEEI_CAEE_SHIFT                      (6U)
/*! CAEE - Clear All Enable Error Interrupts
 *  0b0..Write 0 only to the EEI field specified in the CEEI field
 *  0b1..Write 0 to all fields in EEI
 */
#define DMA_CEEI_CAEE(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CEEI_CAEE_SHIFT)) & DMA_CEEI_CAEE_MASK)
#define DMA_CEEI_NOP_MASK                        (0x80U)
#define DMA_CEEI_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation, ignore the other fields in this register
 */
#define DMA_CEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_CEEI_NOP_SHIFT)) & DMA_CEEI_NOP_MASK)
/*! @} */

/*! @name SEEI - Set Enable Error Interrupt */
/*! @{ */
#define DMA_SEEI_SEEI_MASK                       (0x3U)
#define DMA_SEEI_SEEI_SHIFT                      (0U)
/*! SEEI - Set Enable Error Interrupt
 */
#define DMA_SEEI_SEEI(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SEEI_SEEI_SHIFT)) & DMA_SEEI_SEEI_MASK)
#define DMA_SEEI_SAEE_MASK                       (0x40U)
#define DMA_SEEI_SAEE_SHIFT                      (6U)
/*! SAEE - Set All Enable Error Interrupts
 *  0b0..Write 1 only to the EEI field specified in the SEEI field
 *  0b1..Writes 1 to all fields in EEI
 */
#define DMA_SEEI_SAEE(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SEEI_SAEE_SHIFT)) & DMA_SEEI_SAEE_MASK)
#define DMA_SEEI_NOP_MASK                        (0x80U)
#define DMA_SEEI_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation, ignore the other fields in this register
 */
#define DMA_SEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_SEEI_NOP_SHIFT)) & DMA_SEEI_NOP_MASK)
/*! @} */

/*! @name CERQ - Clear Enable Request */
/*! @{ */
#define DMA_CERQ_CERQ_MASK                       (0x3U)
#define DMA_CERQ_CERQ_SHIFT                      (0U)
/*! CERQ - Clear Enable Request
 */
#define DMA_CERQ_CERQ(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERQ_CERQ_SHIFT)) & DMA_CERQ_CERQ_MASK)
#define DMA_CERQ_CAER_MASK                       (0x40U)
#define DMA_CERQ_CAER_SHIFT                      (6U)
/*! CAER - Clear All Enable Requests
 *  0b0..Write 0 to only the ERQ field specified in the CERQ field
 *  0b1..Write 0 to all fields in ERQ
 */
#define DMA_CERQ_CAER(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERQ_CAER_SHIFT)) & DMA_CERQ_CAER_MASK)
#define DMA_CERQ_NOP_MASK                        (0x80U)
#define DMA_CERQ_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation, ignore the other fields in this register
 */
#define DMA_CERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_CERQ_NOP_SHIFT)) & DMA_CERQ_NOP_MASK)
/*! @} */

/*! @name SERQ - Set Enable Request */
/*! @{ */
#define DMA_SERQ_SERQ_MASK                       (0x3U)
#define DMA_SERQ_SERQ_SHIFT                      (0U)
/*! SERQ - Set Enable Request
 */
#define DMA_SERQ_SERQ(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SERQ_SERQ_SHIFT)) & DMA_SERQ_SERQ_MASK)
#define DMA_SERQ_SAER_MASK                       (0x40U)
#define DMA_SERQ_SAER_SHIFT                      (6U)
/*! SAER - Set All Enable Requests
 *  0b0..Write 1 to only the ERQ field specified in the SERQ field
 *  0b1..Write 1 to all fields in ERQ
 */
#define DMA_SERQ_SAER(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SERQ_SAER_SHIFT)) & DMA_SERQ_SAER_MASK)
#define DMA_SERQ_NOP_MASK                        (0x80U)
#define DMA_SERQ_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation, ignore the other fields in this register
 */
#define DMA_SERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_SERQ_NOP_SHIFT)) & DMA_SERQ_NOP_MASK)
/*! @} */

/*! @name CDNE - Clear DONE Status Bit */
/*! @{ */
#define DMA_CDNE_CDNE_MASK                       (0x3U)
#define DMA_CDNE_CDNE_SHIFT                      (0U)
/*! CDNE - Clear DONE field
 */
#define DMA_CDNE_CDNE(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CDNE_CDNE_SHIFT)) & DMA_CDNE_CDNE_MASK)
#define DMA_CDNE_CADN_MASK                       (0x40U)
#define DMA_CDNE_CADN_SHIFT                      (6U)
/*! CADN - Clears All DONE fields
 *  0b0..Writes 0 to only the TCDn_CSR[DONE] field specified in the CDNE field
 *  0b1..Writes 0 to all bits in TCDn_CSR[DONE]
 */
#define DMA_CDNE_CADN(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CDNE_CADN_SHIFT)) & DMA_CDNE_CADN_MASK)
#define DMA_CDNE_NOP_MASK                        (0x80U)
#define DMA_CDNE_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation; all other fields in this register are ignored.
 */
#define DMA_CDNE_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_CDNE_NOP_SHIFT)) & DMA_CDNE_NOP_MASK)
/*! @} */

/*! @name SSRT - Set START Bit */
/*! @{ */
#define DMA_SSRT_SSRT_MASK                       (0x3U)
#define DMA_SSRT_SSRT_SHIFT                      (0U)
/*! SSRT - Set START field
 */
#define DMA_SSRT_SSRT(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SSRT_SSRT_SHIFT)) & DMA_SSRT_SSRT_MASK)
#define DMA_SSRT_SAST_MASK                       (0x40U)
#define DMA_SSRT_SAST_SHIFT                      (6U)
/*! SAST - Set All START fields (activates all channels)
 *  0b0..Write 1 to only the TCDn_CSR[START] field specified in the SSRT field
 *  0b1..Write 1 to all bits in TCDn_CSR[START]
 */
#define DMA_SSRT_SAST(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SSRT_SAST_SHIFT)) & DMA_SSRT_SAST_MASK)
#define DMA_SSRT_NOP_MASK                        (0x80U)
#define DMA_SSRT_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation; all other fields in this register are ignored.
 */
#define DMA_SSRT_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_SSRT_NOP_SHIFT)) & DMA_SSRT_NOP_MASK)
/*! @} */

/*! @name CERR - Clear Error */
/*! @{ */
#define DMA_CERR_CERR_MASK                       (0x3U)
#define DMA_CERR_CERR_SHIFT                      (0U)
/*! CERR - Clear Error Indicator
 */
#define DMA_CERR_CERR(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERR_CERR_SHIFT)) & DMA_CERR_CERR_MASK)
#define DMA_CERR_CAEI_MASK                       (0x40U)
#define DMA_CERR_CAEI_SHIFT                      (6U)
/*! CAEI - Clear All Error Indicators
 *  0b0..Write 0 to only the ERR field specified in the CERR field
 *  0b1..Write 0 to all fields in ERR
 */
#define DMA_CERR_CAEI(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERR_CAEI_SHIFT)) & DMA_CERR_CAEI_MASK)
#define DMA_CERR_NOP_MASK                        (0x80U)
#define DMA_CERR_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation; all other fields in this register are ignored.
 */
#define DMA_CERR_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_CERR_NOP_SHIFT)) & DMA_CERR_NOP_MASK)
/*! @} */

/*! @name CINT - Clear Interrupt Request */
/*! @{ */
#define DMA_CINT_CINT_MASK                       (0x3U)
#define DMA_CINT_CINT_SHIFT                      (0U)
/*! CINT - Clear Interrupt Request
 */
#define DMA_CINT_CINT(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CINT_CINT_SHIFT)) & DMA_CINT_CINT_MASK)
#define DMA_CINT_CAIR_MASK                       (0x40U)
#define DMA_CINT_CAIR_SHIFT                      (6U)
/*! CAIR - Clear All Interrupt Requests
 *  0b0..Clear only the INT field specified in the CINT field
 *  0b1..Clear all bits in INT
 */
#define DMA_CINT_CAIR(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CINT_CAIR_SHIFT)) & DMA_CINT_CAIR_MASK)
#define DMA_CINT_NOP_MASK                        (0x80U)
#define DMA_CINT_NOP_SHIFT                       (7U)
/*! NOP - No Op Enable
 *  0b0..Normal operation
 *  0b1..No operation; all other fields in this register are ignored.
 */
#define DMA_CINT_NOP(x)                          (((uint8_t)(((uint8_t)(x)) << DMA_CINT_NOP_SHIFT)) & DMA_CINT_NOP_MASK)
/*! @} */

/*! @name INT - Interrupt Request */
/*! @{ */
#define DMA_INT_INT0_MASK                        (0x1U)
#define DMA_INT_INT0_SHIFT                       (0U)
/*! INT0 - Interrupt Request 0
 *  0b1..The interrupt request for channel 0 is cleared
 *  0b1..The interrupt request for channel 0 is active
 */
#define DMA_INT_INT0(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_INT_INT0_SHIFT)) & DMA_INT_INT0_MASK)
#define DMA_INT_INT1_MASK                        (0x2U)
#define DMA_INT_INT1_SHIFT                       (1U)
/*! INT1 - Interrupt Request 1
 *  0b1..The interrupt request for channel 1 is cleared
 *  0b1..The interrupt request for channel 1 is active
 */
#define DMA_INT_INT1(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_INT_INT1_SHIFT)) & DMA_INT_INT1_MASK)
#define DMA_INT_INT2_MASK                        (0x4U)
#define DMA_INT_INT2_SHIFT                       (2U)
/*! INT2 - Interrupt Request 2
 *  0b1..The interrupt request for channel 2 is cleared
 *  0b1..The interrupt request for channel 2 is active
 */
#define DMA_INT_INT2(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_INT_INT2_SHIFT)) & DMA_INT_INT2_MASK)
#define DMA_INT_INT3_MASK                        (0x8U)
#define DMA_INT_INT3_SHIFT                       (3U)
/*! INT3 - Interrupt Request 3
 *  0b1..The interrupt request for channel 3 is cleared
 *  0b1..The interrupt request for channel 3 is active
 */
#define DMA_INT_INT3(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_INT_INT3_SHIFT)) & DMA_INT_INT3_MASK)
/*! @} */

/*! @name ERR - Error */
/*! @{ */
#define DMA_ERR_ERR0_MASK                        (0x1U)
#define DMA_ERR_ERR0_SHIFT                       (0U)
/*! ERR0 - Error In Channel 0
 *  0b0..No error in this channel has occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_ERR_ERR0(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERR_ERR0_SHIFT)) & DMA_ERR_ERR0_MASK)
#define DMA_ERR_ERR1_MASK                        (0x2U)
#define DMA_ERR_ERR1_SHIFT                       (1U)
/*! ERR1 - Error In Channel 1
 *  0b0..No error in this channel has occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_ERR_ERR1(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERR_ERR1_SHIFT)) & DMA_ERR_ERR1_MASK)
#define DMA_ERR_ERR2_MASK                        (0x4U)
#define DMA_ERR_ERR2_SHIFT                       (2U)
/*! ERR2 - Error In Channel 2
 *  0b0..No error in this channel has occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_ERR_ERR2(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERR_ERR2_SHIFT)) & DMA_ERR_ERR2_MASK)
#define DMA_ERR_ERR3_MASK                        (0x8U)
#define DMA_ERR_ERR3_SHIFT                       (3U)
/*! ERR3 - Error In Channel 3
 *  0b0..No error in this channel has occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_ERR_ERR3(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_ERR_ERR3_SHIFT)) & DMA_ERR_ERR3_MASK)
/*! @} */

/*! @name HRS - Hardware Request Status */
/*! @{ */
#define DMA_HRS_HRS0_MASK                        (0x1U)
#define DMA_HRS_HRS0_SHIFT                       (0U)
/*! HRS0 - Hardware Request Status Channel 0
 *  0b0..A hardware service request for channel 0 is not present
 *  0b1..A hardware service request for channel 0 is present
 */
#define DMA_HRS_HRS0(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_HRS_HRS0_SHIFT)) & DMA_HRS_HRS0_MASK)
#define DMA_HRS_HRS1_MASK                        (0x2U)
#define DMA_HRS_HRS1_SHIFT                       (1U)
/*! HRS1 - Hardware Request Status Channel 1
 *  0b0..A hardware service request for channel 1 is not present
 *  0b1..A hardware service request for channel 1 is present
 */
#define DMA_HRS_HRS1(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_HRS_HRS1_SHIFT)) & DMA_HRS_HRS1_MASK)
#define DMA_HRS_HRS2_MASK                        (0x4U)
#define DMA_HRS_HRS2_SHIFT                       (2U)
/*! HRS2 - Hardware Request Status Channel 2
 *  0b0..A hardware service request for channel 2 is not present
 *  0b1..A hardware service request for channel 2 is present
 */
#define DMA_HRS_HRS2(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_HRS_HRS2_SHIFT)) & DMA_HRS_HRS2_MASK)
#define DMA_HRS_HRS3_MASK                        (0x8U)
#define DMA_HRS_HRS3_SHIFT                       (3U)
/*! HRS3 - Hardware Request Status Channel 3
 *  0b0..A hardware service request for channel 3 is not present
 *  0b1..A hardware service request for channel 3 is present
 */
#define DMA_HRS_HRS3(x)                          (((uint32_t)(((uint32_t)(x)) << DMA_HRS_HRS3_SHIFT)) & DMA_HRS_HRS3_MASK)
/*! @} */

/*! @name EARS - Enable Asynchronous Request in Stop */
/*! @{ */
#define DMA_EARS_EDREQ_0_MASK                    (0x1U)
#define DMA_EARS_EDREQ_0_SHIFT                   (0U)
/*! EDREQ_0 - Enable asynchronous DMA request in stop mode for channel 0.
 *  0b0..Disable asynchronous DMA request for channel 0
 *  0b1..Enable asynchronous DMA request for channel 0
 */
#define DMA_EARS_EDREQ_0(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_EARS_EDREQ_0_SHIFT)) & DMA_EARS_EDREQ_0_MASK)
#define DMA_EARS_EDREQ_1_MASK                    (0x2U)
#define DMA_EARS_EDREQ_1_SHIFT                   (1U)
/*! EDREQ_1 - Enable asynchronous DMA request in stop mode for channel 1.
 *  0b0..Disable asynchronous DMA request for channel 1
 *  0b1..Enable asynchronous DMA request for channel 1
 */
#define DMA_EARS_EDREQ_1(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_EARS_EDREQ_1_SHIFT)) & DMA_EARS_EDREQ_1_MASK)
#define DMA_EARS_EDREQ_2_MASK                    (0x4U)
#define DMA_EARS_EDREQ_2_SHIFT                   (2U)
/*! EDREQ_2 - Enable asynchronous DMA request in stop mode for channel 2.
 *  0b0..Disable asynchronous DMA request for channel 2
 *  0b1..Enable asynchronous DMA request for channel 2
 */
#define DMA_EARS_EDREQ_2(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_EARS_EDREQ_2_SHIFT)) & DMA_EARS_EDREQ_2_MASK)
#define DMA_EARS_EDREQ_3_MASK                    (0x8U)
#define DMA_EARS_EDREQ_3_SHIFT                   (3U)
/*! EDREQ_3 - Enable asynchronous DMA request in stop mode for channel 3.
 *  0b0..Disable asynchronous DMA request for channel 3
 *  0b1..Enable asynchronous DMA request for channel 3
 */
#define DMA_EARS_EDREQ_3(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_EARS_EDREQ_3_SHIFT)) & DMA_EARS_EDREQ_3_MASK)
/*! @} */

/*! @name DCHPRI3 - Channel Priority */
/*! @{ */
#define DMA_DCHPRI3_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI3_CHPRI_SHIFT                  (0U)
/*! CHPRI - Channel n Arbitration Priority
 */
#define DMA_DCHPRI3_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI3_CHPRI_SHIFT)) & DMA_DCHPRI3_CHPRI_MASK)
#define DMA_DCHPRI3_DPA_MASK                     (0x40U)
#define DMA_DCHPRI3_DPA_SHIFT                    (6U)
/*! DPA - Disable Preempt Ability. This field resets to 0.
 *  0b0..Channel n can suspend a lower priority channel
 *  0b1..Channel n cannot suspend any channel, regardless of channel priority
 */
#define DMA_DCHPRI3_DPA(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI3_DPA_SHIFT)) & DMA_DCHPRI3_DPA_MASK)
#define DMA_DCHPRI3_ECP_MASK                     (0x80U)
#define DMA_DCHPRI3_ECP_SHIFT                    (7U)
/*! ECP - Enable Channel Preemption. This field resets to 0.
 *  0b0..Channel n cannot be suspended by a higher priority channel's service request
 *  0b1..Channel n can be temporarily suspended by the service request of a higher priority channel
 */
#define DMA_DCHPRI3_ECP(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI3_ECP_SHIFT)) & DMA_DCHPRI3_ECP_MASK)
/*! @} */

/*! @name DCHPRI2 - Channel Priority */
/*! @{ */
#define DMA_DCHPRI2_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI2_CHPRI_SHIFT                  (0U)
/*! CHPRI - Channel n Arbitration Priority
 */
#define DMA_DCHPRI2_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI2_CHPRI_SHIFT)) & DMA_DCHPRI2_CHPRI_MASK)
#define DMA_DCHPRI2_DPA_MASK                     (0x40U)
#define DMA_DCHPRI2_DPA_SHIFT                    (6U)
/*! DPA - Disable Preempt Ability. This field resets to 0.
 *  0b0..Channel n can suspend a lower priority channel
 *  0b1..Channel n cannot suspend any channel, regardless of channel priority
 */
#define DMA_DCHPRI2_DPA(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI2_DPA_SHIFT)) & DMA_DCHPRI2_DPA_MASK)
#define DMA_DCHPRI2_ECP_MASK                     (0x80U)
#define DMA_DCHPRI2_ECP_SHIFT                    (7U)
/*! ECP - Enable Channel Preemption. This field resets to 0.
 *  0b0..Channel n cannot be suspended by a higher priority channel's service request
 *  0b1..Channel n can be temporarily suspended by the service request of a higher priority channel
 */
#define DMA_DCHPRI2_ECP(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI2_ECP_SHIFT)) & DMA_DCHPRI2_ECP_MASK)
/*! @} */

/*! @name DCHPRI1 - Channel Priority */
/*! @{ */
#define DMA_DCHPRI1_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI1_CHPRI_SHIFT                  (0U)
/*! CHPRI - Channel n Arbitration Priority
 */
#define DMA_DCHPRI1_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI1_CHPRI_SHIFT)) & DMA_DCHPRI1_CHPRI_MASK)
#define DMA_DCHPRI1_DPA_MASK                     (0x40U)
#define DMA_DCHPRI1_DPA_SHIFT                    (6U)
/*! DPA - Disable Preempt Ability. This field resets to 0.
 *  0b0..Channel n can suspend a lower priority channel
 *  0b1..Channel n cannot suspend any channel, regardless of channel priority
 */
#define DMA_DCHPRI1_DPA(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI1_DPA_SHIFT)) & DMA_DCHPRI1_DPA_MASK)
#define DMA_DCHPRI1_ECP_MASK                     (0x80U)
#define DMA_DCHPRI1_ECP_SHIFT                    (7U)
/*! ECP - Enable Channel Preemption. This field resets to 0.
 *  0b0..Channel n cannot be suspended by a higher priority channel's service request
 *  0b1..Channel n can be temporarily suspended by the service request of a higher priority channel
 */
#define DMA_DCHPRI1_ECP(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI1_ECP_SHIFT)) & DMA_DCHPRI1_ECP_MASK)
/*! @} */

/*! @name DCHPRI0 - Channel Priority */
/*! @{ */
#define DMA_DCHPRI0_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI0_CHPRI_SHIFT                  (0U)
/*! CHPRI - Channel n Arbitration Priority
 */
#define DMA_DCHPRI0_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI0_CHPRI_SHIFT)) & DMA_DCHPRI0_CHPRI_MASK)
#define DMA_DCHPRI0_DPA_MASK                     (0x40U)
#define DMA_DCHPRI0_DPA_SHIFT                    (6U)
/*! DPA - Disable Preempt Ability. This field resets to 0.
 *  0b0..Channel n can suspend a lower priority channel
 *  0b1..Channel n cannot suspend any channel, regardless of channel priority
 */
#define DMA_DCHPRI0_DPA(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI0_DPA_SHIFT)) & DMA_DCHPRI0_DPA_MASK)
#define DMA_DCHPRI0_ECP_MASK                     (0x80U)
#define DMA_DCHPRI0_ECP_SHIFT                    (7U)
/*! ECP - Enable Channel Preemption. This field resets to 0.
 *  0b0..Channel n cannot be suspended by a higher priority channel's service request
 *  0b1..Channel n can be temporarily suspended by the service request of a higher priority channel
 */
#define DMA_DCHPRI0_ECP(x)                       (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI0_ECP_SHIFT)) & DMA_DCHPRI0_ECP_MASK)
/*! @} */

/*! @name SADDR - TCD Source Address */
/*! @{ */
#define DMA_SADDR_SADDR_MASK                     (0xFFFFFFFFU)
#define DMA_SADDR_SADDR_SHIFT                    (0U)
/*! SADDR - Source Address
 */
#define DMA_SADDR_SADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_SADDR_SADDR_SHIFT)) & DMA_SADDR_SADDR_MASK)
/*! @} */

/* The count of DMA_SADDR */
#define DMA_SADDR_COUNT                          (4U)

/*! @name SOFF - TCD Signed Source Address Offset */
/*! @{ */
#define DMA_SOFF_SOFF_MASK                       (0xFFFFU)
#define DMA_SOFF_SOFF_SHIFT                      (0U)
/*! SOFF - Source address signed offset
 */
#define DMA_SOFF_SOFF(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_SOFF_SOFF_SHIFT)) & DMA_SOFF_SOFF_MASK)
/*! @} */

/* The count of DMA_SOFF */
#define DMA_SOFF_COUNT                           (4U)

/*! @name ATTR - TCD Transfer Attributes */
/*! @{ */
#define DMA_ATTR_DSIZE_MASK                      (0x7U)
#define DMA_ATTR_DSIZE_SHIFT                     (0U)
/*! DSIZE - Destination data transfer size
 */
#define DMA_ATTR_DSIZE(x)                        (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_DSIZE_SHIFT)) & DMA_ATTR_DSIZE_MASK)
#define DMA_ATTR_DMOD_MASK                       (0xF8U)
#define DMA_ATTR_DMOD_SHIFT                      (3U)
/*! DMOD - Destination Address Modulo
 */
#define DMA_ATTR_DMOD(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_DMOD_SHIFT)) & DMA_ATTR_DMOD_MASK)
#define DMA_ATTR_SSIZE_MASK                      (0x700U)
#define DMA_ATTR_SSIZE_SHIFT                     (8U)
/*! SSIZE - Source data transfer size
 *  0b000..8-bit
 *  0b001..16-bit
 *  0b010..32-bit
 *  0b011..Reserved
 *  0b100..16-byte
 *  0b101..32-byte
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define DMA_ATTR_SSIZE(x)                        (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_SSIZE_SHIFT)) & DMA_ATTR_SSIZE_MASK)
#define DMA_ATTR_SMOD_MASK                       (0xF800U)
#define DMA_ATTR_SMOD_SHIFT                      (11U)
/*! SMOD - Source Address Modulo
 *  0b00000..Source address modulo feature is disabled
 *  0b00001-0b11111..Value defines address range used to set up circular data queue
 */
#define DMA_ATTR_SMOD(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_SMOD_SHIFT)) & DMA_ATTR_SMOD_MASK)
/*! @} */

/* The count of DMA_ATTR */
#define DMA_ATTR_COUNT                           (4U)

/*! @name NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Mapping Disabled) */
/*! @{ */
#define DMA_NBYTES_MLNO_NBYTES_MASK              (0xFFFFFFFFU)
#define DMA_NBYTES_MLNO_NBYTES_SHIFT             (0U)
/*! NBYTES - Minor Byte Transfer Count
 */
#define DMA_NBYTES_MLNO_NBYTES(x)                (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLNO_NBYTES_SHIFT)) & DMA_NBYTES_MLNO_NBYTES_MASK)
/*! @} */

/* The count of DMA_NBYTES_MLNO */
#define DMA_NBYTES_MLNO_COUNT                    (4U)

/*! @name NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
/*! @{ */
#define DMA_NBYTES_MLOFFNO_NBYTES_MASK           (0x3FFFFFFFU)
#define DMA_NBYTES_MLOFFNO_NBYTES_SHIFT          (0U)
/*! NBYTES - Minor Byte Transfer Count
 */
#define DMA_NBYTES_MLOFFNO_NBYTES(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_NBYTES_MLOFFNO_NBYTES_MASK)
#define DMA_NBYTES_MLOFFNO_DMLOE_MASK            (0x40000000U)
#define DMA_NBYTES_MLOFFNO_DMLOE_SHIFT           (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..The minor loop offset is not applied to the DADDR
 *  0b1..The minor loop offset is applied to the DADDR
 */
#define DMA_NBYTES_MLOFFNO_DMLOE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFNO_DMLOE_SHIFT)) & DMA_NBYTES_MLOFFNO_DMLOE_MASK)
#define DMA_NBYTES_MLOFFNO_SMLOE_MASK            (0x80000000U)
#define DMA_NBYTES_MLOFFNO_SMLOE_SHIFT           (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..The minor loop offset is not applied to the SADDR
 *  0b1..The minor loop offset is applied to the SADDR
 */
#define DMA_NBYTES_MLOFFNO_SMLOE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFNO_SMLOE_SHIFT)) & DMA_NBYTES_MLOFFNO_SMLOE_MASK)
/*! @} */

/* The count of DMA_NBYTES_MLOFFNO */
#define DMA_NBYTES_MLOFFNO_COUNT                 (4U)

/*! @name NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
/*! @{ */
#define DMA_NBYTES_MLOFFYES_NBYTES_MASK          (0x3FFU)
#define DMA_NBYTES_MLOFFYES_NBYTES_SHIFT         (0U)
/*! NBYTES - Minor Byte Transfer Count
 */
#define DMA_NBYTES_MLOFFYES_NBYTES(x)            (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_NBYTES_MLOFFYES_NBYTES_MASK)
#define DMA_NBYTES_MLOFFYES_MLOFF_MASK           (0x3FFFFC00U)
#define DMA_NBYTES_MLOFFYES_MLOFF_SHIFT          (10U)
/*! MLOFF - If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the
 *    source or destination address to form the next-state value after the minor loop completes.
 */
#define DMA_NBYTES_MLOFFYES_MLOFF(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_NBYTES_MLOFFYES_MLOFF_MASK)
#define DMA_NBYTES_MLOFFYES_DMLOE_MASK           (0x40000000U)
#define DMA_NBYTES_MLOFFYES_DMLOE_SHIFT          (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..The minor loop offset is not applied to the DADDR
 *  0b1..The minor loop offset is applied to the DADDR
 */
#define DMA_NBYTES_MLOFFYES_DMLOE(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_DMLOE_SHIFT)) & DMA_NBYTES_MLOFFYES_DMLOE_MASK)
#define DMA_NBYTES_MLOFFYES_SMLOE_MASK           (0x80000000U)
#define DMA_NBYTES_MLOFFYES_SMLOE_SHIFT          (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..The minor loop offset is not applied to the SADDR
 *  0b1..The minor loop offset is applied to the SADDR
 */
#define DMA_NBYTES_MLOFFYES_SMLOE(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_SMLOE_SHIFT)) & DMA_NBYTES_MLOFFYES_SMLOE_MASK)
/*! @} */

/* The count of DMA_NBYTES_MLOFFYES */
#define DMA_NBYTES_MLOFFYES_COUNT                (4U)

/*! @name SLAST - TCD Last Source Address Adjustment */
/*! @{ */
#define DMA_SLAST_SLAST_MASK                     (0xFFFFFFFFU)
#define DMA_SLAST_SLAST_SHIFT                    (0U)
/*! SLAST - Last Source Address Adjustment
 */
#define DMA_SLAST_SLAST(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_SLAST_SLAST_SHIFT)) & DMA_SLAST_SLAST_MASK)
/*! @} */

/* The count of DMA_SLAST */
#define DMA_SLAST_COUNT                          (4U)

/*! @name DADDR - TCD Destination Address */
/*! @{ */
#define DMA_DADDR_DADDR_MASK                     (0xFFFFFFFFU)
#define DMA_DADDR_DADDR_SHIFT                    (0U)
/*! DADDR - Destination Address
 */
#define DMA_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_DADDR_DADDR_SHIFT)) & DMA_DADDR_DADDR_MASK)
/*! @} */

/* The count of DMA_DADDR */
#define DMA_DADDR_COUNT                          (4U)

/*! @name DOFF - TCD Signed Destination Address Offset */
/*! @{ */
#define DMA_DOFF_DOFF_MASK                       (0xFFFFU)
#define DMA_DOFF_DOFF_SHIFT                      (0U)
/*! DOFF - Destination Address Signed Offset
 */
#define DMA_DOFF_DOFF(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_DOFF_DOFF_SHIFT)) & DMA_DOFF_DOFF_MASK)
/*! @} */

/* The count of DMA_DOFF */
#define DMA_DOFF_COUNT                           (4U)

/*! @name CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
/*! @{ */
#define DMA_CITER_ELINKNO_CITER_MASK             (0x7FFFU)
#define DMA_CITER_ELINKNO_CITER_SHIFT            (0U)
/*! CITER - Current Major Iteration Count
 */
#define DMA_CITER_ELINKNO_CITER(x)               (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKNO_CITER_SHIFT)) & DMA_CITER_ELINKNO_CITER_MASK)
#define DMA_CITER_ELINKNO_ELINK_MASK             (0x8000U)
#define DMA_CITER_ELINKNO_ELINK_SHIFT            (15U)
/*! ELINK - Enable channel-to-channel linking on minor-loop complete
 *  0b0..Channel-to-channel linking is disabled
 *  0b1..Channel-to-channel linking is enabled
 */
#define DMA_CITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKNO_ELINK_SHIFT)) & DMA_CITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_CITER_ELINKNO */
#define DMA_CITER_ELINKNO_COUNT                  (4U)

/*! @name CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
/*! @{ */
#define DMA_CITER_ELINKYES_CITER_MASK            (0x1FFU)
#define DMA_CITER_ELINKYES_CITER_SHIFT           (0U)
/*! CITER - Current Major Iteration Count
 */
#define DMA_CITER_ELINKYES_CITER(x)              (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKYES_CITER_SHIFT)) & DMA_CITER_ELINKYES_CITER_MASK)
#define DMA_CITER_ELINKYES_LINKCH_MASK           (0x600U)
#define DMA_CITER_ELINKYES_LINKCH_SHIFT          (9U)
/*! LINKCH - Minor Loop Link Channel Number
 */
#define DMA_CITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_CITER_ELINKYES_LINKCH_MASK)
#define DMA_CITER_ELINKYES_ELINK_MASK            (0x8000U)
#define DMA_CITER_ELINKYES_ELINK_SHIFT           (15U)
/*! ELINK - Enable channel-to-channel linking on minor-loop complete
 *  0b0..Channel-to-channel linking is disabled
 *  0b1..Channel-to-channel linking is enabled
 */
#define DMA_CITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKYES_ELINK_SHIFT)) & DMA_CITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_CITER_ELINKYES */
#define DMA_CITER_ELINKYES_COUNT                 (4U)

/*! @name DLAST_SGA - TCD Last Destination Address Adjustment/Scatter Gather Address */
/*! @{ */
#define DMA_DLAST_SGA_DLASTSGA_MASK              (0xFFFFFFFFU)
#define DMA_DLAST_SGA_DLASTSGA_SHIFT             (0U)
/*! DLASTSGA - Destination last address adjustment, or next memory address transfer control descriptor for channel (scatter/gather)
 */
#define DMA_DLAST_SGA_DLASTSGA(x)                (((uint32_t)(((uint32_t)(x)) << DMA_DLAST_SGA_DLASTSGA_SHIFT)) & DMA_DLAST_SGA_DLASTSGA_MASK)
/*! @} */

/* The count of DMA_DLAST_SGA */
#define DMA_DLAST_SGA_COUNT                      (4U)

/*! @name CSR - TCD Control and Status */
/*! @{ */
#define DMA_CSR_START_MASK                       (0x1U)
#define DMA_CSR_START_SHIFT                      (0U)
/*! START - Channel Start
 *  0b0..Channel is not explicitly started
 *  0b1..Channel is explicitly started via a software initiated service request
 */
#define DMA_CSR_START(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_CSR_START_SHIFT)) & DMA_CSR_START_MASK)
#define DMA_CSR_INTMAJOR_MASK                    (0x2U)
#define DMA_CSR_INTMAJOR_SHIFT                   (1U)
/*! INTMAJOR - Enable an interrupt when major iteration count completes.
 *  0b0..End of major loop interrupt is disabled
 *  0b1..End of major loop interrupt is enabled
 */
#define DMA_CSR_INTMAJOR(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_CSR_INTMAJOR_SHIFT)) & DMA_CSR_INTMAJOR_MASK)
#define DMA_CSR_INTHALF_MASK                     (0x4U)
#define DMA_CSR_INTHALF_SHIFT                    (2U)
/*! INTHALF - Enable an interrupt when major counter is half complete.
 *  0b0..Half-point interrupt is disabled
 *  0b1..Half-point interrupt is enabled
 */
#define DMA_CSR_INTHALF(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_CSR_INTHALF_SHIFT)) & DMA_CSR_INTHALF_MASK)
#define DMA_CSR_DREQ_MASK                        (0x8U)
#define DMA_CSR_DREQ_SHIFT                       (3U)
/*! DREQ - Disable Request
 *  0b0..The channel's ERQ field is not affected
 *  0b1..The channel's ERQ field is cleared when the major loop is complete
 */
#define DMA_CSR_DREQ(x)                          (((uint16_t)(((uint16_t)(x)) << DMA_CSR_DREQ_SHIFT)) & DMA_CSR_DREQ_MASK)
#define DMA_CSR_ESG_MASK                         (0x10U)
#define DMA_CSR_ESG_SHIFT                        (4U)
/*! ESG - Enable Scatter/Gather Processing
 *  0b0..The current channel's TCD is normal format
 *  0b1..The current channel's TCD specifies a scatter gather format
 */
#define DMA_CSR_ESG(x)                           (((uint16_t)(((uint16_t)(x)) << DMA_CSR_ESG_SHIFT)) & DMA_CSR_ESG_MASK)
#define DMA_CSR_MAJORELINK_MASK                  (0x20U)
#define DMA_CSR_MAJORELINK_SHIFT                 (5U)
/*! MAJORELINK - Enable channel-to-channel linking on major loop complete
 *  0b1..Channel-to-channel linking is disabled
 *  0b1..Channel-to-channel linking is enabled
 */
#define DMA_CSR_MAJORELINK(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_CSR_MAJORELINK_SHIFT)) & DMA_CSR_MAJORELINK_MASK)
#define DMA_CSR_ACTIVE_MASK                      (0x40U)
#define DMA_CSR_ACTIVE_SHIFT                     (6U)
/*! ACTIVE - Channel Active
 */
#define DMA_CSR_ACTIVE(x)                        (((uint16_t)(((uint16_t)(x)) << DMA_CSR_ACTIVE_SHIFT)) & DMA_CSR_ACTIVE_MASK)
#define DMA_CSR_DONE_MASK                        (0x80U)
#define DMA_CSR_DONE_SHIFT                       (7U)
/*! DONE - Channel Done
 */
#define DMA_CSR_DONE(x)                          (((uint16_t)(((uint16_t)(x)) << DMA_CSR_DONE_SHIFT)) & DMA_CSR_DONE_MASK)
#define DMA_CSR_MAJORLINKCH_MASK                 (0x300U)
#define DMA_CSR_MAJORLINKCH_SHIFT                (8U)
/*! MAJORLINKCH - Major Loop Link Channel Number
 */
#define DMA_CSR_MAJORLINKCH(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_CSR_MAJORLINKCH_SHIFT)) & DMA_CSR_MAJORLINKCH_MASK)
#define DMA_CSR_BWC_MASK                         (0xC000U)
#define DMA_CSR_BWC_SHIFT                        (14U)
/*! BWC - Bandwidth Control
 *  0b00..No eDMA engine stalls
 *  0b01..Reserved
 *  0b10..eDMA engine stalls for 4 cycles after each R/W
 *  0b11..eDMA engine stalls for 8 cycles after each R/W
 */
#define DMA_CSR_BWC(x)                           (((uint16_t)(((uint16_t)(x)) << DMA_CSR_BWC_SHIFT)) & DMA_CSR_BWC_MASK)
/*! @} */

/* The count of DMA_CSR */
#define DMA_CSR_COUNT                            (4U)

/*! @name BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
/*! @{ */
#define DMA_BITER_ELINKNO_BITER_MASK             (0x7FFFU)
#define DMA_BITER_ELINKNO_BITER_SHIFT            (0U)
/*! BITER - Starting Major Iteration Count
 */
#define DMA_BITER_ELINKNO_BITER(x)               (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKNO_BITER_SHIFT)) & DMA_BITER_ELINKNO_BITER_MASK)
#define DMA_BITER_ELINKNO_ELINK_MASK             (0x8000U)
#define DMA_BITER_ELINKNO_ELINK_SHIFT            (15U)
/*! ELINK - Enables channel-to-channel linking on minor loop complete
 *  0b0..Channel-to-channel linking is disabled
 *  0b1..Channel-to-channel linking is enabled
 */
#define DMA_BITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKNO_ELINK_SHIFT)) & DMA_BITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_BITER_ELINKNO */
#define DMA_BITER_ELINKNO_COUNT                  (4U)

/*! @name BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
/*! @{ */
#define DMA_BITER_ELINKYES_BITER_MASK            (0x1FFU)
#define DMA_BITER_ELINKYES_BITER_SHIFT           (0U)
/*! BITER - Starting major iteration count
 */
#define DMA_BITER_ELINKYES_BITER(x)              (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKYES_BITER_SHIFT)) & DMA_BITER_ELINKYES_BITER_MASK)
#define DMA_BITER_ELINKYES_LINKCH_MASK           (0x600U)
#define DMA_BITER_ELINKYES_LINKCH_SHIFT          (9U)
/*! LINKCH - Link Channel Number
 */
#define DMA_BITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_BITER_ELINKYES_LINKCH_MASK)
#define DMA_BITER_ELINKYES_ELINK_MASK            (0x8000U)
#define DMA_BITER_ELINKYES_ELINK_SHIFT           (15U)
/*! ELINK - Enables channel-to-channel linking on minor loop complete
 *  0b0..Channel-to-channel linking is disabled
 *  0b1..Channel-to-channel linking is enabled
 */
#define DMA_BITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKYES_ELINK_SHIFT)) & DMA_BITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_BITER_ELINKYES */
#define DMA_BITER_ELINKYES_COUNT                 (4U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA0 base address */
#define DMA0_BASE                                (0x40008000u)
/** Peripheral DMA0 base pointer */
#define DMA0                                     ((DMA_Type *)DMA0_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA0_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0 }
/** Interrupt vectors for the DMA peripheral type */
#define DMA_CHN_IRQS                             { { DMA0_IRQn, DMA1_IRQn, DMA2_IRQn, DMA3_IRQn } }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMAMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Peripheral_Access_Layer DMAMUX Peripheral Access Layer
 * @{
 */

/** DMAMUX - Register Layout Typedef */
typedef struct {
  __IO uint8_t CHCFG[4];                           /**< Channel Configuration register, array offset: 0x0, array step: 0x1 */
} DMAMUX_Type;

/* ----------------------------------------------------------------------------
   -- DMAMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Masks DMAMUX Register Masks
 * @{
 */

/*! @name CHCFG - Channel Configuration register */
/*! @{ */
#define DMAMUX_CHCFG_SOURCE_MASK                 (0x3FU)
#define DMAMUX_CHCFG_SOURCE_SHIFT                (0U)
/*! SOURCE - DMA Channel Source (Slot)
 */
#define DMAMUX_CHCFG_SOURCE(x)                   (((uint8_t)(((uint8_t)(x)) << DMAMUX_CHCFG_SOURCE_SHIFT)) & DMAMUX_CHCFG_SOURCE_MASK)
#define DMAMUX_CHCFG_TRIG_MASK                   (0x40U)
#define DMAMUX_CHCFG_TRIG_SHIFT                  (6U)
/*! TRIG - DMA Channel Trigger Enable
 *  0b0..Triggering is disabled. If triggering is disabled and ENBL is set, the DMA Channel will simply route the
 *       specified source to the DMA channel. (Normal mode)
 *  0b1..Triggering is enabled. If triggering is enabled and ENBL is set, the DMAMUX is in Periodic Trigger mode.
 */
#define DMAMUX_CHCFG_TRIG(x)                     (((uint8_t)(((uint8_t)(x)) << DMAMUX_CHCFG_TRIG_SHIFT)) & DMAMUX_CHCFG_TRIG_MASK)
#define DMAMUX_CHCFG_ENBL_MASK                   (0x80U)
#define DMAMUX_CHCFG_ENBL_SHIFT                  (7U)
/*! ENBL - DMA Channel Enable
 *  0b0..DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has
 *       separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
 *  0b1..DMA channel is enabled
 */
#define DMAMUX_CHCFG_ENBL(x)                     (((uint8_t)(((uint8_t)(x)) << DMAMUX_CHCFG_ENBL_SHIFT)) & DMAMUX_CHCFG_ENBL_MASK)
/*! @} */

/* The count of DMAMUX_CHCFG */
#define DMAMUX_CHCFG_COUNT                       (4U)


/*!
 * @}
 */ /* end of group DMAMUX_Register_Masks */


/* DMAMUX - Peripheral instance base addresses */
/** Peripheral DMAMUX0 base address */
#define DMAMUX0_BASE                             (0x40021000u)
/** Peripheral DMAMUX0 base pointer */
#define DMAMUX0                                  ((DMAMUX_Type *)DMAMUX0_BASE)
/** Array initializer of DMAMUX peripheral base addresses */
#define DMAMUX_BASE_ADDRS                        { DMAMUX0_BASE }
/** Array initializer of DMAMUX peripheral base pointers */
#define DMAMUX_BASE_PTRS                         { DMAMUX0 }

/*!
 * @}
 */ /* end of group DMAMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DSB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DSB_Peripheral_Access_Layer DSB Peripheral Access Layer
 * @{
 */

/** DSB - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSR;                               /**< Control Register, offset: 0x0 */
  __IO uint32_t INT;                               /**< Interrupt Request Status Register, offset: 0x4 */
  __IO uint32_t WMC;                               /**< Watermark Configuration Register, offset: 0x8 */
  __I  uint32_t RDATA;                             /**< FIFO Read Data Register, offset: 0xC */
  __IO uint32_t DADDR;                             /**< DMA Destination Address Register, offset: 0x10 */
  __IO uint32_t XCR;                               /**< DMA Transfer Count Register, offset: 0x14 */
} DSB_Type;

/* ----------------------------------------------------------------------------
   -- DSB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DSB_Register_Masks DSB Register Masks
 * @{
 */

/*! @name CSR - Control Register */
/*! @{ */
#define DSB_CSR_SFTRST_MASK                      (0x1U)
#define DSB_CSR_SFTRST_SHIFT                     (0U)
/*! SFTRST - Soft Reset
 *  0b0..No operation.
 *  0b1..Reset the data stream buffer.
 */
#define DSB_CSR_SFTRST(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_SFTRST_SHIFT)) & DSB_CSR_SFTRST_MASK)
#define DSB_CSR_DSB_EN_MASK                      (0x2U)
#define DSB_CSR_DSB_EN_SHIFT                     (1U)
/*! DSB_EN - Data Stream Buffer Enable
 *  0b0..Buffer is disabled
 *  0b1..Buffer is enabled.
 */
#define DSB_CSR_DSB_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_DSB_EN_SHIFT)) & DSB_CSR_DSB_EN_MASK)
#define DSB_CSR_DMA_EN_MASK                      (0x4U)
#define DSB_CSR_DMA_EN_SHIFT                     (2U)
/*! DMA_EN - DMA Transfer Enable
 *  0b0..DMA transfers are disabled
 *  0b1..DMA transfers are enabled.
 */
#define DSB_CSR_DMA_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_DMA_EN_SHIFT)) & DSB_CSR_DMA_EN_MASK)
#define DSB_CSR_INT_EN_MASK                      (0x8U)
#define DSB_CSR_INT_EN_SHIFT                     (3U)
/*! INT_EN - Interrupt Request Enable
 *  0b0..Interrupt requests on data ready or DMA done are disabled
 *  0b1..Interrupt requests on data ready or DMA done are enabled. When the DMA is enabled (CSR[DMA_EN]=1), INT_EN
 *       enables interrupt requests when the packet transfer is complete (INT[DONE]=1). Otherwise, INT_EN enables
 *       interrupt requests when data is ready (INT[DRDY]=1).
 */
#define DSB_CSR_INT_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_INT_EN_SHIFT)) & DSB_CSR_INT_EN_MASK)
#define DSB_CSR_ERR_EN_MASK                      (0x10U)
#define DSB_CSR_ERR_EN_SHIFT                     (4U)
/*! ERR_EN - Error Interrupt Request Enable
 *  0b0..Error interrupt requests on overflow, underrun, or bus error are disabled
 *  0b1..Error interrupt requests on overflow, underrun, or bus error are enabled.
 */
#define DSB_CSR_ERR_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_ERR_EN_SHIFT)) & DSB_CSR_ERR_EN_MASK)
/*! @} */

/*! @name INT - Interrupt Request Status Register */
/*! @{ */
#define DSB_INT_DRDY_MASK                        (0x1U)
#define DSB_INT_DRDY_SHIFT                       (0U)
/*! DRDY - Data Ready
 *  0b0..No data to read (watermark has not been reached)
 *  0b1..Data is ready to read (watermark has been reached)
 */
#define DSB_INT_DRDY(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_DRDY_SHIFT)) & DSB_INT_DRDY_MASK)
#define DSB_INT_OVRF_MASK                        (0x2U)
#define DSB_INT_OVRF_SHIFT                       (1U)
/*! OVRF - Overflow Error
 *  0b0..No overflow error
 *  0b1..The last recorded error is a buffer overflow
 */
#define DSB_INT_OVRF(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_OVRF_SHIFT)) & DSB_INT_OVRF_MASK)
#define DSB_INT_UNDR_MASK                        (0x4U)
#define DSB_INT_UNDR_SHIFT                       (2U)
/*! UNDR - Underrun Error
 *  0b0..No underrun error
 *  0b1..The last recorded error is an underrun on a read
 */
#define DSB_INT_UNDR(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_UNDR_SHIFT)) & DSB_INT_UNDR_MASK)
#define DSB_INT_DBE_MASK                         (0x8U)
#define DSB_INT_DBE_SHIFT                        (3U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..The last recorded error is bus error on a write
 */
#define DSB_INT_DBE(x)                           (((uint32_t)(((uint32_t)(x)) << DSB_INT_DBE_SHIFT)) & DSB_INT_DBE_MASK)
#define DSB_INT_DONE_MASK                        (0x10U)
#define DSB_INT_DONE_SHIFT                       (4U)
/*! DONE - DMA Packet Transfer Complete
 *  0b0..Packet transfer not done; CCNT less than TCNT
 *  0b1..Packet transfer is done; TCNT 32-bit words transferred
 */
#define DSB_INT_DONE(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_DONE_SHIFT)) & DSB_INT_DONE_MASK)
/*! @} */

/*! @name WMC - Watermark Configuration Register */
/*! @{ */
#define DSB_WMC_WMRK_MASK                        (0xFU)
#define DSB_WMC_WMRK_SHIFT                       (0U)
/*! WMRK - Watermark
 */
#define DSB_WMC_WMRK(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_WMC_WMRK_SHIFT)) & DSB_WMC_WMRK_MASK)
#define DSB_WMC_CNT_MASK                         (0x1F0000U)
#define DSB_WMC_CNT_SHIFT                        (16U)
/*! CNT - FIFO Count
 */
#define DSB_WMC_CNT(x)                           (((uint32_t)(((uint32_t)(x)) << DSB_WMC_CNT_SHIFT)) & DSB_WMC_CNT_MASK)
#define DSB_WMC_SIZE_MASK                        (0x1F000000U)
#define DSB_WMC_SIZE_SHIFT                       (24U)
/*! SIZE - FIFO size
 */
#define DSB_WMC_SIZE(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_WMC_SIZE_SHIFT)) & DSB_WMC_SIZE_MASK)
/*! @} */

/*! @name RDATA - FIFO Read Data Register */
/*! @{ */
#define DSB_RDATA_DATA_MASK                      (0xFFFFFFFFU)
#define DSB_RDATA_DATA_SHIFT                     (0U)
/*! DATA - FIFO Data
 */
#define DSB_RDATA_DATA(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_RDATA_DATA_SHIFT)) & DSB_RDATA_DATA_MASK)
/*! @} */

/*! @name DADDR - DMA Destination Address Register */
/*! @{ */
#define DSB_DADDR_DADDR_MASK                     (0xFFFFFFFFU)
#define DSB_DADDR_DADDR_SHIFT                    (0U)
/*! DADDR - Destination Address
 */
#define DSB_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DSB_DADDR_DADDR_SHIFT)) & DSB_DADDR_DADDR_MASK)
/*! @} */

/*! @name XCR - DMA Transfer Count Register */
/*! @{ */
#define DSB_XCR_TCNT_MASK                        (0xFFFFU)
#define DSB_XCR_TCNT_SHIFT                       (0U)
/*! TCNT - Total Transfer Count
 */
#define DSB_XCR_TCNT(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_XCR_TCNT_SHIFT)) & DSB_XCR_TCNT_MASK)
#define DSB_XCR_CCNT_MASK                        (0xFFFF0000U)
#define DSB_XCR_CCNT_SHIFT                       (16U)
/*! CCNT - Current Transfer Count
 */
#define DSB_XCR_CCNT(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_XCR_CCNT_SHIFT)) & DSB_XCR_CCNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DSB_Register_Masks */


/* DSB - Peripheral instance base addresses */
/** Peripheral DSB base address */
#define DSB_BASE                                 (0x4005B000u)
/** Peripheral DSB base pointer */
#define DSB                                      ((DSB_Type *)DSB_BASE)
/** Array initializer of DSB peripheral base addresses */
#define DSB_BASE_ADDRS                           { DSB_BASE }
/** Array initializer of DSB peripheral base pointers */
#define DSB_BASE_PTRS                            { DSB }

/*!
 * @}
 */ /* end of group DSB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FGPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Peripheral_Access_Layer FGPIO Peripheral Access Layer
 * @{
 */

/** FGPIO - Register Layout Typedef */
typedef struct {
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
} FGPIO_Type;

/* ----------------------------------------------------------------------------
   -- FGPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Masks FGPIO Register Masks
 * @{
 */

/*! @name PDOR - Port Data Output Register */
/*! @{ */
#define FGPIO_PDOR_PDO_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDOR_PDO_SHIFT                     (0U)
/*! PDO - Port Data Output
 *  0b00000000000000000000000000000000..Logic level 0 is driven on pin, provided pin is configured for general-purpose output.
 *  0b00000000000000000000000000000001..Logic level 1 is driven on pin, provided pin is configured for general-purpose output.
 */
#define FGPIO_PDOR_PDO(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDOR_PDO_SHIFT)) & FGPIO_PDOR_PDO_MASK)
/*! @} */

/*! @name PSOR - Port Set Output Register */
/*! @{ */
#define FGPIO_PSOR_PTSO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PSOR_PTSO_SHIFT                    (0U)
/*! PTSO - Port Set Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is set to logic 1.
 */
#define FGPIO_PSOR_PTSO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PSOR_PTSO_SHIFT)) & FGPIO_PSOR_PTSO_MASK)
/*! @} */

/*! @name PCOR - Port Clear Output Register */
/*! @{ */
#define FGPIO_PCOR_PTCO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PCOR_PTCO_SHIFT                    (0U)
/*! PTCO - Port Clear Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is cleared to logic 0.
 */
#define FGPIO_PCOR_PTCO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PCOR_PTCO_SHIFT)) & FGPIO_PCOR_PTCO_MASK)
/*! @} */

/*! @name PTOR - Port Toggle Output Register */
/*! @{ */
#define FGPIO_PTOR_PTTO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PTOR_PTTO_SHIFT                    (0U)
/*! PTTO - Port Toggle Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is set to the inverse of its existing logic state.
 */
#define FGPIO_PTOR_PTTO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PTOR_PTTO_SHIFT)) & FGPIO_PTOR_PTTO_MASK)
/*! @} */

/*! @name PDIR - Port Data Input Register */
/*! @{ */
#define FGPIO_PDIR_PDI_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDIR_PDI_SHIFT                     (0U)
/*! PDI - Port Data Input
 *  0b00000000000000000000000000000000..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b00000000000000000000000000000001..Pin logic level is logic 1.
 */
#define FGPIO_PDIR_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDIR_PDI_SHIFT)) & FGPIO_PDIR_PDI_MASK)
/*! @} */

/*! @name PDDR - Port Data Direction Register */
/*! @{ */
#define FGPIO_PDDR_PDD_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDDR_PDD_SHIFT                     (0U)
/*! PDD - Port Data Direction
 *  0b00000000000000000000000000000000..Pin is configured as general-purpose input, for the GPIO function.
 *  0b00000000000000000000000000000001..Pin is configured as general-purpose output, for the GPIO function.
 */
#define FGPIO_PDDR_PDD(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDDR_PDD_SHIFT)) & FGPIO_PDDR_PDD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FGPIO_Register_Masks */


/* FGPIO - Peripheral instance base addresses */
/** Peripheral FGPIOA base address */
#define FGPIOA_BASE                              (0xF8000000u)
/** Peripheral FGPIOA base pointer */
#define FGPIOA                                   ((FGPIO_Type *)FGPIOA_BASE)
/** Peripheral FGPIOB base address */
#define FGPIOB_BASE                              (0xF8000040u)
/** Peripheral FGPIOB base pointer */
#define FGPIOB                                   ((FGPIO_Type *)FGPIOB_BASE)
/** Peripheral FGPIOC base address */
#define FGPIOC_BASE                              (0xF8000080u)
/** Peripheral FGPIOC base pointer */
#define FGPIOC                                   ((FGPIO_Type *)FGPIOC_BASE)
/** Array initializer of FGPIO peripheral base addresses */
#define FGPIO_BASE_ADDRS                         { FGPIOA_BASE, FGPIOB_BASE, FGPIOC_BASE }
/** Array initializer of FGPIO peripheral base pointers */
#define FGPIO_BASE_PTRS                          { FGPIOA, FGPIOB, FGPIOC }

/*!
 * @}
 */ /* end of group FGPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FTFE Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Peripheral_Access_Layer FTFE Peripheral Access Layer
 * @{
 */

/** FTFE - Register Layout Typedef */
typedef struct {
  __IO uint8_t FSTAT;                              /**< Flash Status Register, offset: 0x0 */
  __IO uint8_t FCNFG;                              /**< Flash Configuration Register, offset: 0x1 */
  __I  uint8_t FSEC;                               /**< Flash Security Register, offset: 0x2 */
  __I  uint8_t FOPT;                               /**< Flash Option Register, offset: 0x3 */
  __IO uint8_t FCCOB3;                             /**< Flash Common Command Object Registers, offset: 0x4 */
  __IO uint8_t FCCOB2;                             /**< Flash Common Command Object Registers, offset: 0x5 */
  __IO uint8_t FCCOB1;                             /**< Flash Common Command Object Registers, offset: 0x6 */
  __IO uint8_t FCCOB0;                             /**< Flash Common Command Object Registers, offset: 0x7 */
  __IO uint8_t FCCOB7;                             /**< Flash Common Command Object Registers, offset: 0x8 */
  __IO uint8_t FCCOB6;                             /**< Flash Common Command Object Registers, offset: 0x9 */
  __IO uint8_t FCCOB5;                             /**< Flash Common Command Object Registers, offset: 0xA */
  __IO uint8_t FCCOB4;                             /**< Flash Common Command Object Registers, offset: 0xB */
  __IO uint8_t FCCOBB;                             /**< Flash Common Command Object Registers, offset: 0xC */
  __IO uint8_t FCCOBA;                             /**< Flash Common Command Object Registers, offset: 0xD */
  __IO uint8_t FCCOB9;                             /**< Flash Common Command Object Registers, offset: 0xE */
  __IO uint8_t FCCOB8;                             /**< Flash Common Command Object Registers, offset: 0xF */
  __IO uint8_t FPROT3;                             /**< Program Flash Protection Registers, offset: 0x10 */
  __IO uint8_t FPROT2;                             /**< Program Flash Protection Registers, offset: 0x11 */
  __IO uint8_t FPROT1;                             /**< Program Flash Protection Registers, offset: 0x12 */
  __IO uint8_t FPROT0;                             /**< Program Flash Protection Registers, offset: 0x13 */
       uint8_t RESERVED_0[2];
  __IO uint8_t FEPROT;                             /**< EEPROM Protection Register, offset: 0x16 */
  __IO uint8_t FDPROT;                             /**< Data Flash Protection Register, offset: 0x17 */
       uint8_t RESERVED_1[22];
  __IO uint8_t FERSTAT;                            /**< Flash Error Status Register, offset: 0x2E */
  __IO uint8_t FERCNFG;                            /**< Flash Error Configuration Register, offset: 0x2F */
} FTFE_Type;

/* ----------------------------------------------------------------------------
   -- FTFE Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFE_Register_Masks FTFE Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */
#define FTFE_FSTAT_MGSTAT0_MASK                  (0x1U)
#define FTFE_FSTAT_MGSTAT0_SHIFT                 (0U)
/*! MGSTAT0 - Memory Controller Command Completion Status Flag
 */
#define FTFE_FSTAT_MGSTAT0(x)                    (((uint8_t)(((uint8_t)(x)) << FTFE_FSTAT_MGSTAT0_SHIFT)) & FTFE_FSTAT_MGSTAT0_MASK)
#define FTFE_FSTAT_FPVIOL_MASK                   (0x10U)
#define FTFE_FSTAT_FPVIOL_SHIFT                  (4U)
/*! FPVIOL - Flash Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FTFE_FSTAT_FPVIOL(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FSTAT_FPVIOL_SHIFT)) & FTFE_FSTAT_FPVIOL_MASK)
#define FTFE_FSTAT_ACCERR_MASK                   (0x20U)
#define FTFE_FSTAT_ACCERR_SHIFT                  (5U)
/*! ACCERR - Flash Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FTFE_FSTAT_ACCERR(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FSTAT_ACCERR_SHIFT)) & FTFE_FSTAT_ACCERR_MASK)
#define FTFE_FSTAT_RDCOLERR_MASK                 (0x40U)
#define FTFE_FSTAT_RDCOLERR_SHIFT                (6U)
/*! RDCOLERR - FTFE Read Collision Error Flag
 *  0b0..No collision error detected
 *  0b1..Collision error detected
 */
#define FTFE_FSTAT_RDCOLERR(x)                   (((uint8_t)(((uint8_t)(x)) << FTFE_FSTAT_RDCOLERR_SHIFT)) & FTFE_FSTAT_RDCOLERR_MASK)
#define FTFE_FSTAT_CCIF_MASK                     (0x80U)
#define FTFE_FSTAT_CCIF_SHIFT                    (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..FTFE command or EEPROM file system operation in progress
 *  0b1..FTFE command or EEPROM file system operation has completed
 */
#define FTFE_FSTAT_CCIF(x)                       (((uint8_t)(((uint8_t)(x)) << FTFE_FSTAT_CCIF_SHIFT)) & FTFE_FSTAT_CCIF_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */
#define FTFE_FCNFG_EEERDY_MASK                   (0x1U)
#define FTFE_FCNFG_EEERDY_SHIFT                  (0U)
/*! EEERDY
 *  0b0..For devices with FlexNVM: FlexRAM is not available for EEPROM operation For devices without FlexNVM: See
 *       RAMRDY for availability of programming acceleration RAM
 *  0b1..For devices with FlexNVM: FlexRAM is available for EEPROM operations where: reads from the FlexRAM return
 *       data previously written to the FlexRAM in EEPROM mode and writes launch an EEPROM operation to store the
 *       written data in the FlexRAM and EEPROM backup For devices without FlexNVM: Reserved
 */
#define FTFE_FCNFG_EEERDY(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_EEERDY_SHIFT)) & FTFE_FCNFG_EEERDY_MASK)
#define FTFE_FCNFG_RAMRDY_MASK                   (0x2U)
#define FTFE_FCNFG_RAMRDY_SHIFT                  (1U)
/*! RAMRDY - RAM Ready
 *  0b0..For devices with FlexNVM: FlexRAM is not available for traditional RAM access For devices without
 *       FlexNVM: Programming acceleration RAM is not available
 *  0b1..For devices with FlexNVM: FlexRAM is available as traditional RAM only; writes to the FlexRAM do not
 *       trigger EEPROM operations For devices without FlexNVM: Programming acceleration RAM is available
 */
#define FTFE_FCNFG_RAMRDY(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_RAMRDY_SHIFT)) & FTFE_FCNFG_RAMRDY_MASK)
#define FTFE_FCNFG_PFLSH_MASK                    (0x4U)
#define FTFE_FCNFG_PFLSH_SHIFT                   (2U)
/*! PFLSH - FTFE configuration
 *  0b0..For devices with FlexNVM: FTFE configuration supports one program flash block and one FlexNVM block For
 *       devices with program flash only: Reserved
 *  0b1..For devices with FlexNVM: Reserved For devices with program flash only: FTFE configuration supports two program flash blocks
 */
#define FTFE_FCNFG_PFLSH(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_PFLSH_SHIFT)) & FTFE_FCNFG_PFLSH_MASK)
#define FTFE_FCNFG_SWAP_MASK                     (0x8U)
#define FTFE_FCNFG_SWAP_SHIFT                    (3U)
/*! SWAP - Swap
 *  0b0..For devices with FlexNVM: Program flash 0 block is located at relative address 0x0000 For devices with
 *       program flash only: Program flash 0 block is located at relative address 0x0000
 *  0b1..For devices with program flash only: Program flash 1 block is located at relative address 0x0000
 */
#define FTFE_FCNFG_SWAP(x)                       (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_SWAP_SHIFT)) & FTFE_FCNFG_SWAP_MASK)
#define FTFE_FCNFG_ERSSUSP_MASK                  (0x10U)
#define FTFE_FCNFG_ERSSUSP_SHIFT                 (4U)
/*! ERSSUSP - Erase Suspend
 *  0b0..No suspend requested
 *  0b1..Suspend the current Erase Flash Sector command execution
 */
#define FTFE_FCNFG_ERSSUSP(x)                    (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_ERSSUSP_SHIFT)) & FTFE_FCNFG_ERSSUSP_MASK)
#define FTFE_FCNFG_ERSAREQ_MASK                  (0x20U)
#define FTFE_FCNFG_ERSAREQ_SHIFT                 (5U)
/*! ERSAREQ - Erase All Request
 *  0b0..No request or request complete
 *  0b1..Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the
 *       Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to
 *       the unsecure state
 */
#define FTFE_FCNFG_ERSAREQ(x)                    (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_ERSAREQ_SHIFT)) & FTFE_FCNFG_ERSAREQ_MASK)
#define FTFE_FCNFG_RDCOLLIE_MASK                 (0x40U)
#define FTFE_FCNFG_RDCOLLIE_SHIFT                (6U)
/*! RDCOLLIE - Read Collision Error Interrupt Enable
 *  0b0..Read collision error interrupt disabled
 *  0b1..Read collision error interrupt enabled. An interrupt request is generated whenever an FTFE read collision
 *       error is detected (see the description of FSTAT[RDCOLERR]).
 */
#define FTFE_FCNFG_RDCOLLIE(x)                   (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_RDCOLLIE_SHIFT)) & FTFE_FCNFG_RDCOLLIE_MASK)
#define FTFE_FCNFG_CCIE_MASK                     (0x80U)
#define FTFE_FCNFG_CCIE_SHIFT                    (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
 */
#define FTFE_FCNFG_CCIE(x)                       (((uint8_t)(((uint8_t)(x)) << FTFE_FCNFG_CCIE_SHIFT)) & FTFE_FCNFG_CCIE_MASK)
/*! @} */

/*! @name FSEC - Flash Security Register */
/*! @{ */
#define FTFE_FSEC_SEC_MASK                       (0x3U)
#define FTFE_FSEC_SEC_SHIFT                      (0U)
/*! SEC - Flash Security
 *  0b00..MCU security status is secure
 *  0b01..MCU security status is secure
 *  0b10..MCU security status is unsecure (The standard shipping condition of the FTFE is unsecure.)
 *  0b11..MCU security status is secure
 */
#define FTFE_FSEC_SEC(x)                         (((uint8_t)(((uint8_t)(x)) << FTFE_FSEC_SEC_SHIFT)) & FTFE_FSEC_SEC_MASK)
#define FTFE_FSEC_FSLACC_MASK                    (0xCU)
#define FTFE_FSEC_FSLACC_SHIFT                   (2U)
/*! FSLACC - Factory Security Level Access Code
 *  0b00..Factory access granted
 *  0b01..Factory access denied
 *  0b10..Factory access denied
 *  0b11..Factory access granted
 */
#define FTFE_FSEC_FSLACC(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FSEC_FSLACC_SHIFT)) & FTFE_FSEC_FSLACC_MASK)
#define FTFE_FSEC_MEEN_MASK                      (0x30U)
#define FTFE_FSEC_MEEN_SHIFT                     (4U)
/*! MEEN - Mass Erase Enable Bits
 *  0b00..Mass erase is enabled
 *  0b01..Mass erase is enabled
 *  0b10..Mass erase is disabled
 *  0b11..Mass erase is enabled
 */
#define FTFE_FSEC_MEEN(x)                        (((uint8_t)(((uint8_t)(x)) << FTFE_FSEC_MEEN_SHIFT)) & FTFE_FSEC_MEEN_MASK)
#define FTFE_FSEC_KEYEN_MASK                     (0xC0U)
#define FTFE_FSEC_KEYEN_SHIFT                    (6U)
/*! KEYEN - Backdoor Key Security Enable
 *  0b00..Backdoor key access disabled
 *  0b01..Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
 *  0b10..Backdoor key access enabled
 *  0b11..Backdoor key access disabled
 */
#define FTFE_FSEC_KEYEN(x)                       (((uint8_t)(((uint8_t)(x)) << FTFE_FSEC_KEYEN_SHIFT)) & FTFE_FSEC_KEYEN_MASK)
/*! @} */

/*! @name FOPT - Flash Option Register */
/*! @{ */
#define FTFE_FOPT_OPT_MASK                       (0xFFU)
#define FTFE_FOPT_OPT_SHIFT                      (0U)
/*! OPT - Nonvolatile Option
 */
#define FTFE_FOPT_OPT(x)                         (((uint8_t)(((uint8_t)(x)) << FTFE_FOPT_OPT_SHIFT)) & FTFE_FOPT_OPT_MASK)
/*! @} */

/*! @name FCCOB3 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB3_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB3_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB3_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB3_CCOBn_SHIFT)) & FTFE_FCCOB3_CCOBn_MASK)
/*! @} */

/*! @name FCCOB2 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB2_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB2_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB2_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB2_CCOBn_SHIFT)) & FTFE_FCCOB2_CCOBn_MASK)
/*! @} */

/*! @name FCCOB1 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB1_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB1_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB1_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB1_CCOBn_SHIFT)) & FTFE_FCCOB1_CCOBn_MASK)
/*! @} */

/*! @name FCCOB0 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB0_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB0_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB0_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB0_CCOBn_SHIFT)) & FTFE_FCCOB0_CCOBn_MASK)
/*! @} */

/*! @name FCCOB7 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB7_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB7_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB7_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB7_CCOBn_SHIFT)) & FTFE_FCCOB7_CCOBn_MASK)
/*! @} */

/*! @name FCCOB6 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB6_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB6_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB6_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB6_CCOBn_SHIFT)) & FTFE_FCCOB6_CCOBn_MASK)
/*! @} */

/*! @name FCCOB5 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB5_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB5_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB5_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB5_CCOBn_SHIFT)) & FTFE_FCCOB5_CCOBn_MASK)
/*! @} */

/*! @name FCCOB4 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB4_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB4_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB4_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB4_CCOBn_SHIFT)) & FTFE_FCCOB4_CCOBn_MASK)
/*! @} */

/*! @name FCCOBB - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOBB_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOBB_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOBB_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOBB_CCOBn_SHIFT)) & FTFE_FCCOBB_CCOBn_MASK)
/*! @} */

/*! @name FCCOBA - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOBA_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOBA_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOBA_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOBA_CCOBn_SHIFT)) & FTFE_FCCOBA_CCOBn_MASK)
/*! @} */

/*! @name FCCOB9 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB9_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB9_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB9_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB9_CCOBn_SHIFT)) & FTFE_FCCOB9_CCOBn_MASK)
/*! @} */

/*! @name FCCOB8 - Flash Common Command Object Registers */
/*! @{ */
#define FTFE_FCCOB8_CCOBn_MASK                   (0xFFU)
#define FTFE_FCCOB8_CCOBn_SHIFT                  (0U)
#define FTFE_FCCOB8_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FCCOB8_CCOBn_SHIFT)) & FTFE_FCCOB8_CCOBn_MASK)
/*! @} */

/*! @name FPROT3 - Program Flash Protection Registers */
/*! @{ */
#define FTFE_FPROT3_PROT_MASK                    (0xFFU)
#define FTFE_FPROT3_PROT_SHIFT                   (0U)
/*! PROT - Program Flash Region Protect
 *  0b00000000..Program flash region is protected.
 *  0b00000001..Program flash region is not protected
 */
#define FTFE_FPROT3_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FPROT3_PROT_SHIFT)) & FTFE_FPROT3_PROT_MASK)
/*! @} */

/*! @name FPROT2 - Program Flash Protection Registers */
/*! @{ */
#define FTFE_FPROT2_PROT_MASK                    (0xFFU)
#define FTFE_FPROT2_PROT_SHIFT                   (0U)
/*! PROT - Program Flash Region Protect
 *  0b00000000..Program flash region is protected.
 *  0b00000001..Program flash region is not protected
 */
#define FTFE_FPROT2_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FPROT2_PROT_SHIFT)) & FTFE_FPROT2_PROT_MASK)
/*! @} */

/*! @name FPROT1 - Program Flash Protection Registers */
/*! @{ */
#define FTFE_FPROT1_PROT_MASK                    (0xFFU)
#define FTFE_FPROT1_PROT_SHIFT                   (0U)
/*! PROT - Program Flash Region Protect
 *  0b00000000..Program flash region is protected.
 *  0b00000001..Program flash region is not protected
 */
#define FTFE_FPROT1_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FPROT1_PROT_SHIFT)) & FTFE_FPROT1_PROT_MASK)
/*! @} */

/*! @name FPROT0 - Program Flash Protection Registers */
/*! @{ */
#define FTFE_FPROT0_PROT_MASK                    (0xFFU)
#define FTFE_FPROT0_PROT_SHIFT                   (0U)
/*! PROT - Program Flash Region Protect
 *  0b00000000..Program flash region is protected.
 *  0b00000001..Program flash region is not protected
 */
#define FTFE_FPROT0_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFE_FPROT0_PROT_SHIFT)) & FTFE_FPROT0_PROT_MASK)
/*! @} */

/*! @name FEPROT - EEPROM Protection Register */
/*! @{ */
#define FTFE_FEPROT_EPROT_MASK                   (0xFFU)
#define FTFE_FEPROT_EPROT_SHIFT                  (0U)
/*! EPROT - EEPROM Region Protect
 *  0b00000000..For devices with program flash only: Reserved For devices with FlexNVM: EEPROM region is protected
 *  0b00000001..For devices with program flash only: Reserved For devices with FlexNVM: EEPROM region is not protected
 */
#define FTFE_FEPROT_EPROT(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FEPROT_EPROT_SHIFT)) & FTFE_FEPROT_EPROT_MASK)
/*! @} */

/*! @name FDPROT - Data Flash Protection Register */
/*! @{ */
#define FTFE_FDPROT_DPROT_MASK                   (0xFFU)
#define FTFE_FDPROT_DPROT_SHIFT                  (0U)
/*! DPROT - Data Flash Region Protect
 *  0b00000000..Data Flash region is protected
 *  0b00000001..Data Flash region is not protected
 */
#define FTFE_FDPROT_DPROT(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FDPROT_DPROT_SHIFT)) & FTFE_FDPROT_DPROT_MASK)
/*! @} */

/*! @name FERSTAT - Flash Error Status Register */
/*! @{ */
#define FTFE_FERSTAT_DFDIF_MASK                  (0x2U)
#define FTFE_FERSTAT_DFDIF_SHIFT                 (1U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access from the platform flash controller
 *  0b1..Double bit fault detected (or FERCNFG[FDFD] is set) during a valid flash read access from the platform flash controller
 */
#define FTFE_FERSTAT_DFDIF(x)                    (((uint8_t)(((uint8_t)(x)) << FTFE_FERSTAT_DFDIF_SHIFT)) & FTFE_FERSTAT_DFDIF_MASK)
/*! @} */

/*! @name FERCNFG - Flash Error Configuration Register */
/*! @{ */
#define FTFE_FERCNFG_DFDIE_MASK                  (0x2U)
#define FTFE_FERCNFG_DFDIE_SHIFT                 (1U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled. An interrupt request is generated whenever the FERSTAT[DFDIF] flag is set.
 */
#define FTFE_FERCNFG_DFDIE(x)                    (((uint8_t)(((uint8_t)(x)) << FTFE_FERCNFG_DFDIE_SHIFT)) & FTFE_FERCNFG_DFDIE_MASK)
#define FTFE_FERCNFG_FDFD_MASK                   (0x20U)
#define FTFE_FERCNFG_FDFD_SHIFT                  (5U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FERSTAT[DFDIF] sets only if a double bit fault is detected during read access from the platform flash controller
 *  0b1..FERSTAT[DFDIF] sets during any valid flash read access from the platform flash controller. An interrupt
 *       request is generated if the DFDIE bit is set.
 */
#define FTFE_FERCNFG_FDFD(x)                     (((uint8_t)(((uint8_t)(x)) << FTFE_FERCNFG_FDFD_SHIFT)) & FTFE_FERCNFG_FDFD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FTFE_Register_Masks */


/* FTFE - Peripheral instance base addresses */
/** Peripheral FTFE base address */
#define FTFE_BASE                                (0x40020000u)
/** Peripheral FTFE base pointer */
#define FTFE                                     ((FTFE_Type *)FTFE_BASE)
/** Array initializer of FTFE peripheral base addresses */
#define FTFE_BASE_ADDRS                          { FTFE_BASE }
/** Array initializer of FTFE peripheral base pointers */
#define FTFE_BASE_PTRS                           { FTFE }
/** Interrupt vectors for the FTFE peripheral type */
#define FTFE_COMMAND_COMPLETE_IRQS               { FTFE_IRQn }

/*!
 * @}
 */ /* end of group FTFE_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GENFSK Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Peripheral_Access_Layer GENFSK Peripheral Access Layer
 * @{
 */

/** GENFSK - Register Layout Typedef */
typedef struct {
  __IO uint32_t IRQ_CTRL;                          /**< IRQ CONTROL, offset: 0x0 */
  __IO uint32_t EVENT_TMR;                         /**< EVENT TIMER, offset: 0x4 */
  __IO uint32_t T1_CMP;                            /**< T1 COMPARE, offset: 0x8 */
  __IO uint32_t T2_CMP;                            /**< T2 COMPARE, offset: 0xC */
  __I  uint32_t TIMESTAMP;                         /**< TIMESTAMP, offset: 0x10 */
  __IO uint32_t XCVR_CTRL;                         /**< TRANSCEIVER CONTROL, offset: 0x14 */
  __I  uint32_t XCVR_STS;                          /**< TRANSCEIVER STATUS, offset: 0x18 */
  __IO uint32_t XCVR_CFG;                          /**< TRANSCEIVER CONFIGURATION, offset: 0x1C */
  __IO uint32_t CHANNEL_NUM0;                      /**< CHANNEL NUMBER 0, offset: 0x20 */
  __IO uint32_t TX_POWER;                          /**< TRANSMIT POWER, offset: 0x24 */
  __IO uint32_t NTW_ADR_CTRL;                      /**< NETWORK ADDRESS CONTROL, offset: 0x28 */
  __IO uint32_t NTW_ADR_0;                         /**< NETWORK ADDRESS 0, offset: 0x2C */
  __IO uint32_t NTW_ADR_1;                         /**< NETWORK ADDRESS 1, offset: 0x30 */
  __IO uint32_t NTW_ADR_2;                         /**< NETWORK ADDRESS 2, offset: 0x34 */
  __IO uint32_t NTW_ADR_3;                         /**< NETWORK ADDRESS 3, offset: 0x38 */
  __IO uint32_t RX_WATERMARK;                      /**< RECEIVE WATERMARK, offset: 0x3C */
  __IO uint32_t DSM_CTRL;                          /**< DSM CONTROL, offset: 0x40 */
  __I  uint32_t PART_ID;                           /**< PART ID, offset: 0x44 */
  __IO uint32_t SLOT_PRELOAD;                      /**< SLOT PRELOAD, offset: 0x48 */
  __IO uint32_t SLOT_TIME;                         /**< SLOT TIME, offset: 0x4C */
  __IO uint32_t TURNAROUND_TIME;                   /**< TURNAROUND TIME, offset: 0x50 */
  __IO uint32_t ACKDELAY;                          /**< ACK DELAY, offset: 0x54 */
  __IO uint32_t RXDELAY;                           /**< RX DELAY, offset: 0x58 */
  __IO uint32_t TXDELAY;                           /**< TX DELAY, offset: 0x5C */
  __IO uint32_t PACKET_CFG;                        /**< PACKET CONFIGURATION, offset: 0x60 */
  __IO uint32_t H0_CFG;                            /**< H0 CONFIGURATION, offset: 0x64 */
  __IO uint32_t H1_CFG;                            /**< H1 CONFIGURATION, offset: 0x68 */
  __IO uint32_t CRC_CFG;                           /**< CRC CONFIGURATION, offset: 0x6C */
  __IO uint32_t LENGTH_ADJ;                        /**< LENGTH ADJUSTMENT, offset: 0x70 */
       uint8_t RESERVED_0[16];
  __IO uint32_t LENGTH_MAX;                        /**< MAXIMUM LENGTH, offset: 0x84 */
       uint8_t RESERVED_1[8];
  __IO uint32_t ENH_FEATURE;                       /**< ENHANCED FEATURES, offset: 0x90 */
  __IO uint32_t RX_FRAME_FILTER;                   /**< RECEIVE FRAME FILTER, offset: 0x94 */
  __IO uint32_t FILTERFAIL_CODE;                   /**< FILTER FAIL CODE, offset: 0x98 */
  __IO uint32_t LENIENCY_LSB;                      /**< LENIENCY LSB, offset: 0x9C */
  __IO uint32_t LENIENCY_MSB;                      /**< LENIENCY MSB, offset: 0xA0 */
  __IO uint32_t DUAL_PAN_CTRL;                     /**< DUAL PAN CONTROL, offset: 0xA4 */
  union {                                          /* offset: 0xA8 */
    __IO uint32_t GTM_PDU;                           /**< GTM MODE PDU, offset: 0xA8 */
    __IO uint32_t MACSHORTADDRS1;                    /**< MAC SHORT ADDRESS FOR PAN1, offset: 0xA8 */
  };
  union {                                          /* offset: 0xAC */
    __IO uint32_t GTM_CFG;                           /**< GTM MODE CONFIGURATION, offset: 0xAC */
    __IO uint32_t MACLONGADDRS1_LSB;                 /**< MAC LONG ADDRESS 1 LSB, offset: 0xAC */
  };
  union {                                          /* offset: 0xB0 */
    __IO uint32_t GTM_IPD;                           /**< GTM MODE INTER-PACKET DURATION, offset: 0xB0 */
    __IO uint32_t MACLONGADDRS1_MSB;                 /**< MAC LONG ADDRESS 1 MSB, offset: 0xB0 */
  };
  __IO uint32_t CHANNEL_NUM1;                      /**< CHANNEL NUMBER 1, offset: 0xB4 */
  __IO uint32_t MACSHORTADDRS0;                    /**< MAC SHORT ADDRESS 0, offset: 0xB8 */
  union {                                          /* offset: 0xBC */
    __IO uint32_t GTM_FIRST_SFD2WD;                  /**< GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN, offset: 0xBC */
    __IO uint32_t MACLONGADDRS0_LSB;                 /**< MAC LONG ADDRESS 0 LSB, offset: 0xBC */
  };
  union {                                          /* offset: 0xC0 */
    __IO uint32_t GTM_RX_RECYCLE_TIME;               /**< GTM MODE RX RECYCLE TIME, offset: 0xC0 */
    __IO uint32_t MACLONGADDRS0_MSB;                 /**< MAC LONG ADDRESS 0 MSB, offset: 0xC0 */
  };
  __IO uint32_t CCA_LQI_CTRL;                      /**< CCA AND LQI CONTROL, offset: 0xC4 */
  __I  uint32_t WARMUP_TIME;                       /**< TX/RX WARMUP TIME, offset: 0xC8 */
  __IO uint32_t RXEN_DLY;                          /**< RX_EN Delay Time, offset: 0xCC */
       uint8_t RESERVED_2[4];
  __IO uint32_t SAM_CTRL;                          /**< SAM CONTROL, offset: 0xD4 */
  __IO uint32_t SAM_TABLE;                         /**< SOURCE ADDRESS MANAGEMENT TABLE, offset: 0xD8 */
  __I  uint32_t SAM_MATCH;                         /**< SOURCE ADDRESS MANAGEMENT MATCH, offset: 0xDC */
  __I  uint32_t SAM_FREE_IDX;                      /**< SAM FREE INDEX, offset: 0xE0 */
  __IO uint32_t MISC1;                             /**< MISCELLANEOUS(1), offset: 0xE4 */
  __I  uint32_t SEQ_STS;                           /**< SEQUENCE STATUS, offset: 0xE8 */
  __IO uint32_t PHR_MISC;                          /**< PHR MISCELLANEOUS, offset: 0xEC */
  __IO uint32_t GTM_CTRL;                          /**< GTM CONTROL, offset: 0xF0 */
  __I  uint32_t GTM_BAD_CNT;                       /**< GTM BAD PACKET COUNTER, offset: 0xF4 */
  __I  uint32_t GTM_GOOD_CNT;                      /**< GTM GOOD PACKET COUNTER, offset: 0xF8 */
  __I  uint32_t GTM_PKT_CNT;                       /**< GTM PACKET COUNTER, offset: 0xFC */
} GENFSK_Type;

/* ----------------------------------------------------------------------------
   -- GENFSK Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Register_Masks GENFSK Register Masks
 * @{
 */

/*! @name IRQ_CTRL - IRQ CONTROL */
/*! @{ */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK         (0x1U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_SHIFT        (0U)
/*! SEQ_END_IRQ - Sequence End Interrupt
 *  0b0..Sequence End Interrupt is not asserted.
 *  0b1..Sequence End Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_SEQ_END_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK)
#define GENFSK_IRQ_CTRL_TX_IRQ_MASK              (0x2U)
#define GENFSK_IRQ_CTRL_TX_IRQ_SHIFT             (1U)
/*! TX_IRQ - TX Interrupt
 *  0b0..TX Interrupt is not asserted.
 *  0b1..TX Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_TX_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TX_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_TX_IRQ_MASK)
#define GENFSK_IRQ_CTRL_RX_IRQ_MASK              (0x4U)
#define GENFSK_IRQ_CTRL_RX_IRQ_SHIFT             (2U)
/*! RX_IRQ - RX Interrupt
 *  0b0..RX Interrupt is not asserted.
 *  0b1..RX Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_RX_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_RX_IRQ_MASK)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK         (0x8U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_SHIFT        (3U)
/*! NTW_ADR_IRQ - Network Address Match Interrupt
 *  0b0..Network Address Match Interrupt is not asserted.
 *  0b1..Network Address Match Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_NTW_ADR_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK)
#define GENFSK_IRQ_CTRL_T1_IRQ_MASK              (0x10U)
#define GENFSK_IRQ_CTRL_T1_IRQ_SHIFT             (4U)
/*! T1_IRQ - Timer1 (T1) Compare Interrupt
 *  0b0..Timer1 (T1) Compare Interrupt is not asserted.
 *  0b1..Timer1 (T1) Compare Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_T1_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T1_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_T1_IRQ_MASK)
#define GENFSK_IRQ_CTRL_T2_IRQ_MASK              (0x20U)
#define GENFSK_IRQ_CTRL_T2_IRQ_SHIFT             (5U)
/*! T2_IRQ - Timer2 (T2) Compare Interrupt
 *  0b0..Timer2 (T2) Compare Interrupt is not asserted.
 *  0b1..Timer2 (T2) Compare Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_T2_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T2_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_T2_IRQ_MASK)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK      (0x40U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT     (6U)
/*! PLL_UNLOCK_IRQ - PLL Unlock Interrupt
 *  0b0..PLL Unlock Interrupt is not asserted.
 *  0b1..PLL Unlock Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_MASK            (0x80U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_SHIFT           (7U)
/*! WAKE_IRQ - Wake Interrrupt
 *  0b0..Wake Interrupt is not asserted.
 *  0b1..Wake Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_WAKE_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_WAKE_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_WAKE_IRQ_MASK)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK    (0x100U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT   (8U)
/*! RX_WATERMARK_IRQ - RX Watermark Interrupt
 *  0b0..RX Watermark Interrupt is not asserted.
 *  0b1..RX Watermark Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK)
#define GENFSK_IRQ_CTRL_TSM_IRQ_MASK             (0x200U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_SHIFT            (9U)
/*! TSM_IRQ - TSM Interrupt
 *  0b0..TSM0_IRQ and TSM1_IRQ are both clear.
 *  0b1..Indicates TSM0_IRQ or TSM1_IRQ is set in XCVR_STATUS.
 */
#define GENFSK_IRQ_CTRL_TSM_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TSM_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_TSM_IRQ_MASK)
#define GENFSK_IRQ_CTRL_CRC_VALID_MASK           (0x400U)
#define GENFSK_IRQ_CTRL_CRC_VALID_SHIFT          (10U)
/*! CRC_VALID - CRC Valid
 */
#define GENFSK_IRQ_CTRL_CRC_VALID(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CRC_VALID_SHIFT)) & GENFSK_IRQ_CTRL_CRC_VALID_MASK)
#define GENFSK_IRQ_CTRL_ACK_IRQ_MASK             (0x800U)
#define GENFSK_IRQ_CTRL_ACK_IRQ_SHIFT            (11U)
/*! ACK_IRQ - Auto ACK Interrupt
 *  0b0..Auto ACK Interrupt is not asserted.
 *  0b1..Auto ACK Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_ACK_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_ACK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_ACK_IRQ_MASK)
#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_MASK        (0x1000U)
#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_SHIFT       (12U)
/*! PHRFFAIL_IRQ - Received Frame PHR Fail Interrupt
 *  0b0..Received frame PHR Fail Interrupt is not asserted.
 *  0b1..Received frame PHR Fail Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_MASK)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_MASK      (0x2000U)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_SHIFT     (13U)
/*! FILTERFAIL_IRQ - Received Frame Filter Fail Interrupt
 *  0b0..A Filter Fail Interrupt has not occurred.
 *  0b1..A Filter Fail Interrupt has occurred.
 */
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_MASK)
#define GENFSK_IRQ_CTRL_CCA_IRQ_MASK             (0x4000U)
#define GENFSK_IRQ_CTRL_CCA_IRQ_SHIFT            (14U)
/*! CCA_IRQ - CCA Interrupt
 *  0b0..A CCA Interrupt has not occurred
 *  0b1..A CCA Interrupt has occurred
 */
#define GENFSK_IRQ_CTRL_CCA_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CCA_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_CCA_IRQ_MASK)
#define GENFSK_IRQ_CTRL_MS_IRQ_MASK              (0x8000U)
#define GENFSK_IRQ_CTRL_MS_IRQ_SHIFT             (15U)
/*! MS_IRQ - Mode Switch Interrupt
 *  0b0..A Mode Switch frame is not received
 *  0b1..A Mode Switch frame is received
 */
#define GENFSK_IRQ_CTRL_MS_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_MS_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_MS_IRQ_MASK)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK      (0x10000U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT     (16U)
/*! SEQ_END_IRQ_EN - SEQ_END_IRQ Enable
 *  0b0..Sequence End Interrupt is not enabled.
 *  0b1..Sequence End Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK           (0x20000U)
#define GENFSK_IRQ_CTRL_TX_IRQ_EN_SHIFT          (17U)
/*! TX_IRQ_EN - TX_IRQ Enable
 *  0b0..TX Interrupt is not enabled.
 *  0b1..TX Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_TX_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TX_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK           (0x40000U)
#define GENFSK_IRQ_CTRL_RX_IRQ_EN_SHIFT          (18U)
/*! RX_IRQ_EN - RX_IRQ Enable
 *  0b0..RX Interrupt is not enabled.
 *  0b1..RX Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_RX_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK      (0x80000U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT     (19U)
/*! NTW_ADR_IRQ_EN - NTW_ADR_IRQ Enable
 *  0b0..Network Address Match Interrupt is not enabled.
 *  0b1..Network Address Match Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK           (0x100000U)
#define GENFSK_IRQ_CTRL_T1_IRQ_EN_SHIFT          (20U)
/*! T1_IRQ_EN - T1_IRQ Enable
 *  0b0..Timer1 (T1) Compare Interrupt is not enabled.
 *  0b1..Timer1 (T1) Compare Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_T1_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T1_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK           (0x200000U)
#define GENFSK_IRQ_CTRL_T2_IRQ_EN_SHIFT          (21U)
/*! T2_IRQ_EN - T2_IRQ Enable
 *  0b0..Timer1 (T2) Compare Interrupt is not enabled.
 *  0b1..Timer1 (T2) Compare Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_T2_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T2_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK   (0x400000U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT  (22U)
/*! PLL_UNLOCK_IRQ_EN - PLL_UNLOCK_IRQ Enable
 *  0b0..PLL Unlock Interrupt is not enabled.
 *  0b1..PLL Unlock Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK         (0x800000U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_SHIFT        (23U)
/*! WAKE_IRQ_EN - WAKE_IRQ Enable
 *  0b0..Wake Interrupt is not enabled.
 *  0b1..Wake Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_WAKE_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK (0x1000000U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT (24U)
/*! RX_WATERMARK_IRQ_EN - RX_WATERMARK_IRQ Enable
 *  0b0..RX Watermark Interrupt is not enabled.
 *  0b1..RX Watermark Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_MASK          (0x2000000U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_SHIFT         (25U)
/*! TSM_IRQ_EN - TSM_IRQ Enable
 *  0b0..TSM Interrupt is not enabled.
 *  0b1..TSM Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TSM_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_TSM_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_MASK  (0x4000000U)
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_SHIFT (26U)
/*! GENERIC_FSK_IRQ_EN - GENERIC_FSK_IRQ Master Enable
 *  0b0..All GENERIC_FSK Interrupts are disabled.
 *  0b1..All GENERIC_FSK Interrupts can be enabled.
 */
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_ACK_IRQ_EN_MASK          (0x8000000U)
#define GENFSK_IRQ_CTRL_ACK_IRQ_EN_SHIFT         (27U)
/*! ACK_IRQ_EN - ACK_IRQ Enable
 *  0b0..Auto ACK Interrupt is not enabled.
 *  0b1..Auto ACK Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_ACK_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_ACK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_ACK_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_MASK      (0x10000000U)
#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_SHIFT     (28U)
/*! PHRFAIL_IRQ_EN - PHRFAIL_IRQ Enable
 *  0b0..PHRFAIL Interrupt is not enabled.
 *  0b1..PHRFAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_MASK   (0x20000000U)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_SHIFT  (29U)
/*! FILTERFAIL_IRQ_EN - FILTERFAIL_IRQ Enable
 *  0b0..FILTERFAIL Interrupt is not enabled.
 *  0b1..FILTERFAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_CCA_IRQ_EN_MASK          (0x40000000U)
#define GENFSK_IRQ_CTRL_CCA_IRQ_EN_SHIFT         (30U)
/*! CCA_IRQ_EN - CCA_IRQ Enable
 *  0b0..CCA Interrupt is not enabled.
 *  0b1..CCA Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_CCA_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CCA_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_CCA_IRQ_EN_MASK)
#define GENFSK_IRQ_CTRL_MS_IRQ_EN_MASK           (0x80000000U)
#define GENFSK_IRQ_CTRL_MS_IRQ_EN_SHIFT          (31U)
/*! MS_IRQ_EN - MS_IRQ Enable
 *  0b0..MS Interrupt is not enabled.
 *  0b1..MS Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_MS_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_MS_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_MS_IRQ_EN_MASK)
/*! @} */

/*! @name EVENT_TMR - EVENT TIMER */
/*! @{ */
#define GENFSK_EVENT_TMR_EVENT_TMR_MASK          (0xFFFFFFU)
#define GENFSK_EVENT_TMR_EVENT_TMR_SHIFT         (0U)
/*! EVENT_TMR - Event Timer
 */
#define GENFSK_EVENT_TMR_EVENT_TMR(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_EVENT_TMR_SHIFT)) & GENFSK_EVENT_TMR_EVENT_TMR_MASK)
#define GENFSK_EVENT_TMR_EVENT_TMR_LD_MASK       (0x1000000U)
#define GENFSK_EVENT_TMR_EVENT_TMR_LD_SHIFT      (24U)
/*! EVENT_TMR_LD - Event Timer Load
 */
#define GENFSK_EVENT_TMR_EVENT_TMR_LD(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_EVENT_TMR_LD_SHIFT)) & GENFSK_EVENT_TMR_EVENT_TMR_LD_MASK)
#define GENFSK_EVENT_TMR_EVENT_TMR_ADD_MASK      (0x2000000U)
#define GENFSK_EVENT_TMR_EVENT_TMR_ADD_SHIFT     (25U)
/*! EVENT_TMR_ADD - Event Timer Add
 */
#define GENFSK_EVENT_TMR_EVENT_TMR_ADD(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_EVENT_TMR_ADD_SHIFT)) & GENFSK_EVENT_TMR_EVENT_TMR_ADD_MASK)
/*! @} */

/*! @name T1_CMP - T1 COMPARE */
/*! @{ */
#define GENFSK_T1_CMP_T1_CMP_MASK                (0xFFFFFFU)
#define GENFSK_T1_CMP_T1_CMP_SHIFT               (0U)
/*! T1_CMP - Timer1 (T1) Compare Value
 */
#define GENFSK_T1_CMP_T1_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T1_CMP_T1_CMP_SHIFT)) & GENFSK_T1_CMP_T1_CMP_MASK)
#define GENFSK_T1_CMP_T1_CMP_EN_MASK             (0x1000000U)
#define GENFSK_T1_CMP_T1_CMP_EN_SHIFT            (24U)
/*! T1_CMP_EN - Timer1 (T1) Compare Enable
 */
#define GENFSK_T1_CMP_T1_CMP_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_T1_CMP_T1_CMP_EN_SHIFT)) & GENFSK_T1_CMP_T1_CMP_EN_MASK)
/*! @} */

/*! @name T2_CMP - T2 COMPARE */
/*! @{ */
#define GENFSK_T2_CMP_T2_CMP_MASK                (0xFFFFFFU)
#define GENFSK_T2_CMP_T2_CMP_SHIFT               (0U)
/*! T2_CMP - Timer2 (T2) Compare Value
 */
#define GENFSK_T2_CMP_T2_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T2_CMP_T2_CMP_SHIFT)) & GENFSK_T2_CMP_T2_CMP_MASK)
#define GENFSK_T2_CMP_T2_CMP_EN_MASK             (0x1000000U)
#define GENFSK_T2_CMP_T2_CMP_EN_SHIFT            (24U)
/*! T2_CMP_EN - Timer2 (T2) Compare Enable
 */
#define GENFSK_T2_CMP_T2_CMP_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_T2_CMP_T2_CMP_EN_SHIFT)) & GENFSK_T2_CMP_T2_CMP_EN_MASK)
/*! @} */

/*! @name TIMESTAMP - TIMESTAMP */
/*! @{ */
#define GENFSK_TIMESTAMP_TIMESTAMP_MASK          (0xFFFFFFU)
#define GENFSK_TIMESTAMP_TIMESTAMP_SHIFT         (0U)
/*! TIMESTAMP - Received Packet Timestamp
 */
#define GENFSK_TIMESTAMP_TIMESTAMP(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_TIMESTAMP_TIMESTAMP_SHIFT)) & GENFSK_TIMESTAMP_TIMESTAMP_MASK)
/*! @} */

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
/*! @{ */
#define GENFSK_XCVR_CTRL_SEQCMD_MASK             (0x1FU)
#define GENFSK_XCVR_CTRL_SEQCMD_SHIFT            (0U)
/*! SEQCMD - Sequence Commands, also named as "XCVSEQ(Transceiver Sequence)"
 *  0b00000..Same as command ABORT
 *  0b00001..TX Start Now
 *  0b00010..TX Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b00011..TX Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b00100..TX Cancel -- Cancels pending TX events but do not abort a TX-in-progress
 *  0b00101..RX Start Now
 *  0b00110..RX Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b00111..RX Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01000..RX Stop @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b01001..RX Stop @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01010..RX Cancel -- Cancels pending RX events but do not abort a RX-in-progress
 *  0b01011..Abort All - Cancels all pending events and abort any sequence-in-progress
 *  0b01100..TR Start Now
 *  0b01101..TR Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b01110..TR Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01111..TR Cancel -- Cancels pending TR events but do not abort a TR-in-progress
 *  0b10000..CCA Start Now
 *  0b10001..CCA Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b10010..CCA Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b10011..CCA Cancel -- Cancels pending CCA events but do not abort a CCA-in-progress
 */
#define GENFSK_XCVR_CTRL_SEQCMD(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_SEQCMD_SHIFT)) & GENFSK_XCVR_CTRL_SEQCMD_MASK)
#define GENFSK_XCVR_CTRL_LENGTH_EXT_MASK         (0x7FF00U)
#define GENFSK_XCVR_CTRL_LENGTH_EXT_SHIFT        (8U)
/*! LENGTH_EXT - Extracted Length Field
 */
#define GENFSK_XCVR_CTRL_LENGTH_EXT(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_LENGTH_EXT_SHIFT)) & GENFSK_XCVR_CTRL_LENGTH_EXT_MASK)
#define GENFSK_XCVR_CTRL_CMDDEC_CS_MASK          (0x1F000000U)
#define GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT         (24U)
/*! CMDDEC_CS - Command Decode
 */
#define GENFSK_XCVR_CTRL_CMDDEC_CS(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT)) & GENFSK_XCVR_CTRL_CMDDEC_CS_MASK)
#define GENFSK_XCVR_CTRL_XCVR_BUSY_MASK          (0x80000000U)
#define GENFSK_XCVR_CTRL_XCVR_BUSY_SHIFT         (31U)
/*! XCVR_BUSY - Transceiver Busy
 *  0b0..IDLE
 *  0b1..BUSY
 */
#define GENFSK_XCVR_CTRL_XCVR_BUSY(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_XCVR_BUSY_SHIFT)) & GENFSK_XCVR_CTRL_XCVR_BUSY_MASK)
/*! @} */

/*! @name XCVR_STS - TRANSCEIVER STATUS */
/*! @{ */
#define GENFSK_XCVR_STS_LQI_MASK                 (0xFFU)
#define GENFSK_XCVR_STS_LQI_SHIFT                (0U)
/*! LQI - Link Quality Indicator
 */
#define GENFSK_XCVR_STS_LQI(x)                   (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_LQI_SHIFT)) & GENFSK_XCVR_STS_LQI_MASK)
#define GENFSK_XCVR_STS_LQI_VALID_MASK           (0x8000U)
#define GENFSK_XCVR_STS_LQI_VALID_SHIFT          (15U)
/*! LQI_VALID - LQI Valid Indicator
 *  0b0..LQI is not yet valid for RX packet.
 *  0b1..LQI is valid for RX packet.
 */
#define GENFSK_XCVR_STS_LQI_VALID(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_LQI_VALID_SHIFT)) & GENFSK_XCVR_STS_LQI_VALID_MASK)
#define GENFSK_XCVR_STS_RSSI_MASK                (0xFF0000U)
#define GENFSK_XCVR_STS_RSSI_SHIFT               (16U)
/*! RSSI - RSSI Value
 */
#define GENFSK_XCVR_STS_RSSI(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_RSSI_SHIFT)) & GENFSK_XCVR_STS_RSSI_MASK)
/*! @} */

/*! @name XCVR_CFG - TRANSCEIVER CONFIGURATION */
/*! @{ */
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_MASK       (0x1U)
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_SHIFT      (0U)
/*! TX_WHITEN_DIS - TX Whitening Disable
 */
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_TX_WHITEN_DIS_SHIFT)) & GENFSK_XCVR_CFG_TX_WHITEN_DIS_MASK)
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_MASK     (0x2U)
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT    (1U)
/*! RX_DEWHITEN_DIS - RX De-Whitening Disable
 */
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT)) & GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_MASK)
#define GENFSK_XCVR_CFG_SW_CRC_EN_MASK           (0x4U)
#define GENFSK_XCVR_CFG_SW_CRC_EN_SHIFT          (2U)
/*! SW_CRC_EN - Software CRC Enable
 */
#define GENFSK_XCVR_CFG_SW_CRC_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_SW_CRC_EN_SHIFT)) & GENFSK_XCVR_CFG_SW_CRC_EN_MASK)
#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_MASK (0x8U)
#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_SHIFT (3U)
/*! STOP_POSTPONE_ON_AA - Postpone Stop Command Timeout On Access Address Match Enable
 *  0b0..STOP Abort will occur on RX_STOP_T1 or RX_STOP_T1 Event Timer match, regardless of NTW_ADR_MCH
 *  0b1..STOP Abort will be deferred on RX_STOP_T1 or RX_STOP_T1 Event Timer match, if NTW_ADR_MCH is asserted;
 *       otherwise the RX_STOP Abort will occur immediately
 */
#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_SHIFT)) & GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_MASK)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK         (0x1FF0U)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT        (4U)
/*! PREAMBLE_SZ - Preamble Size
 */
#define GENFSK_XCVR_CFG_PREAMBLE_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT)) & GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK)
#define GENFSK_XCVR_CFG_GEN_PREAMBLE_MASK        (0xFF0000U)
#define GENFSK_XCVR_CFG_GEN_PREAMBLE_SHIFT       (16U)
/*! GEN_PREAMBLE - Preamble pattern
 */
#define GENFSK_XCVR_CFG_GEN_PREAMBLE(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_GEN_PREAMBLE_SHIFT)) & GENFSK_XCVR_CFG_GEN_PREAMBLE_MASK)
#define GENFSK_XCVR_CFG_PREAMBLE_SEL_MASK        (0x7000000U)
#define GENFSK_XCVR_CFG_PREAMBLE_SEL_SHIFT       (24U)
/*! PREAMBLE_SEL - Preamble Select
 *  0b000..The controller hardware selects the preamble pattern based on the first transmitted bit of Network
 *         Address, such that the last bit of preamble is the opposite polarity from the first bit of Network Address,
 *         forcing a bit transition at this boundary.
 *  0b001..Preamble is programmed by register GEN_PREAMBLE[7:0]
 *  0b010..Preamble is 0b01
 *  0b011..Preamble is 0b10
 */
#define GENFSK_XCVR_CFG_PREAMBLE_SEL(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_PREAMBLE_SEL_SHIFT)) & GENFSK_XCVR_CFG_PREAMBLE_SEL_MASK)
/*! @} */

/*! @name CHANNEL_NUM0 - CHANNEL NUMBER 0 */
/*! @{ */
#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_MASK    (0x7FU)
#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_SHIFT   (0U)
/*! CHANNEL_NUM0 - Channel Number for PAN0
 */
#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_SHIFT)) & GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_MASK)
/*! @} */

/*! @name TX_POWER - TRANSMIT POWER */
/*! @{ */
#define GENFSK_TX_POWER_TX_POWER_MASK            (0x3FU)
#define GENFSK_TX_POWER_TX_POWER_SHIFT           (0U)
/*! TX_POWER - Transmit Power
 */
#define GENFSK_TX_POWER_TX_POWER(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_TX_POWER_TX_POWER_SHIFT)) & GENFSK_TX_POWER_TX_POWER_MASK)
/*! @} */

/*! @name NTW_ADR_CTRL - NETWORK ADDRESS CONTROL */
/*! @{ */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK      (0xFU)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT     (0U)
/*! NTW_ADR_EN - Network Address Enable
 *  0b0001..Enable Network Address 0 for correlation
 *  0b0010..Enable Network Address 1 for correlation
 *  0b0100..Enable Network Address 2 for correlation
 *  0b1000..Enable Network Address 3 for correlation
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK     (0xF0U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT    (4U)
/*! NTW_ADR_MCH - Network Address Match
 *  0b0001..Network Address 0 has matched
 *  0b0010..Network Address 1 has matched
 *  0b0100..Network Address 2 has matched
 *  0b1000..Network Address 3 has matched
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_MASK      (0x300U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_SHIFT     (8U)
/*! NTW_ADR_SZ - Network Address Size
 *  0b00..Network Address 0/1/2/3 requires a 8-bit correlation
 *  0b01..Network Address 0/1/2/3 requires a 16-bit correlation
 *  0b10..Network Address 0/1/2/3 requires a 24-bit correlation
 *  0b11..Network Address 0/1/2/3 requires a 32-bit correlation
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_MASK     (0x70000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_SHIFT    (16U)
/*! NTW_ADR_THR - Network Address Threshold
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_MASK)
/*! @} */

/*! @name NTW_ADR_0 - NETWORK ADDRESS 0 */
/*! @{ */
#define GENFSK_NTW_ADR_0_NTW_ADR_0_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT         (0U)
/*! NTW_ADR_0 - Network Address 0
 */
#define GENFSK_NTW_ADR_0_NTW_ADR_0(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT)) & GENFSK_NTW_ADR_0_NTW_ADR_0_MASK)
/*! @} */

/*! @name NTW_ADR_1 - NETWORK ADDRESS 1 */
/*! @{ */
#define GENFSK_NTW_ADR_1_NTW_ADR_1_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT         (0U)
/*! NTW_ADR_1 - Network Address 1
 */
#define GENFSK_NTW_ADR_1_NTW_ADR_1(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT)) & GENFSK_NTW_ADR_1_NTW_ADR_1_MASK)
/*! @} */

/*! @name NTW_ADR_2 - NETWORK ADDRESS 2 */
/*! @{ */
#define GENFSK_NTW_ADR_2_NTW_ADR_2_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT         (0U)
/*! NTW_ADR_2 - Network Address 2
 */
#define GENFSK_NTW_ADR_2_NTW_ADR_2(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT)) & GENFSK_NTW_ADR_2_NTW_ADR_2_MASK)
/*! @} */

/*! @name NTW_ADR_3 - NETWORK ADDRESS 3 */
/*! @{ */
#define GENFSK_NTW_ADR_3_NTW_ADR_3_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT         (0U)
/*! NTW_ADR_3 - Network Address 2
 */
#define GENFSK_NTW_ADR_3_NTW_ADR_3(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT)) & GENFSK_NTW_ADR_3_NTW_ADR_3_MASK)
/*! @} */

/*! @name RX_WATERMARK - RECEIVE WATERMARK */
/*! @{ */
#define GENFSK_RX_WATERMARK_RX_WATERMARK_MASK    (0x1FFFU)
#define GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT   (0U)
/*! RX_WATERMARK - Receive Watermark
 */
#define GENFSK_RX_WATERMARK_RX_WATERMARK(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT)) & GENFSK_RX_WATERMARK_RX_WATERMARK_MASK)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK    (0x1FFF0000U)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT   (16U)
/*! BYTE_COUNTER - Byte Counter
 */
#define GENFSK_RX_WATERMARK_BYTE_COUNTER(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT)) & GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK)
/*! @} */

/*! @name DSM_CTRL - DSM CONTROL */
/*! @{ */
#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_MASK   (0x1U)
#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_SHIFT  (0U)
/*! GEN_SLEEP_REQUEST - GENERIC_FSK Deep Sleep Mode Request
 */
#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_SHIFT)) & GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_MASK)
/*! @} */

/*! @name PART_ID - PART ID */
/*! @{ */
#define GENFSK_PART_ID_PART_ID_MASK              (0xFFU)
#define GENFSK_PART_ID_PART_ID_SHIFT             (0U)
/*! PART_ID - Part ID
 */
#define GENFSK_PART_ID_PART_ID(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_PART_ID_PART_ID_SHIFT)) & GENFSK_PART_ID_PART_ID_MASK)
/*! @} */

/*! @name SLOT_PRELOAD - SLOT PRELOAD */
/*! @{ */
#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_MASK    (0xFFFFU)
#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_SHIFT   (0U)
/*! SLOT_PRELOAD - Slotted Mode Preload
 */
#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_SHIFT)) & GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_MASK)
/*! @} */

/*! @name SLOT_TIME - SLOT TIME */
/*! @{ */
#define GENFSK_SLOT_TIME_SLOT_TIME_MASK          (0xFFFFU)
#define GENFSK_SLOT_TIME_SLOT_TIME_SHIFT         (0U)
/*! SLOT_TIME - Duration of the Backoff Slot
 */
#define GENFSK_SLOT_TIME_SLOT_TIME(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SLOT_TIME_SLOT_TIME_SHIFT)) & GENFSK_SLOT_TIME_SLOT_TIME_MASK)
/*! @} */

/*! @name TURNAROUND_TIME - TURNAROUND TIME */
/*! @{ */
#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_MASK (0xFFFFU)
#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_SHIFT (0U)
/*! TURNAROUND_TIME - RX-to-TX or TX-to-RX turnaround time
 */
#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_SHIFT)) & GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_MASK)
/*! @} */

/*! @name ACKDELAY - ACK DELAY */
/*! @{ */
#define GENFSK_ACKDELAY_ACKDELAY_MASK            (0x3FFU)
#define GENFSK_ACKDELAY_ACKDELAY_SHIFT           (0U)
/*! ACKDELAY - ACK Delay
 */
#define GENFSK_ACKDELAY_ACKDELAY(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_ACKDELAY_ACKDELAY_SHIFT)) & GENFSK_ACKDELAY_ACKDELAY_MASK)
/*! @} */

/*! @name RXDELAY - RX DELAY */
/*! @{ */
#define GENFSK_RXDELAY_RXDELAY_MASK              (0x3FFU)
#define GENFSK_RXDELAY_RXDELAY_SHIFT             (0U)
/*! RXDELAY - RX Delay
 */
#define GENFSK_RXDELAY_RXDELAY(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_RXDELAY_RXDELAY_SHIFT)) & GENFSK_RXDELAY_RXDELAY_MASK)
/*! @} */

/*! @name TXDELAY - TX DELAY */
/*! @{ */
#define GENFSK_TXDELAY_TXDELAY_MASK              (0x3FFU)
#define GENFSK_TXDELAY_TXDELAY_SHIFT             (0U)
/*! TXDELAY - TX Delay
 */
#define GENFSK_TXDELAY_TXDELAY(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_TXDELAY_TXDELAY_SHIFT)) & GENFSK_TXDELAY_TXDELAY_MASK)
/*! @} */

/*! @name PACKET_CFG - PACKET CONFIGURATION */
/*! @{ */
#define GENFSK_PACKET_CFG_LENGTH_SZ_MASK         (0x1FU)
#define GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT        (0U)
/*! LENGTH_SZ - LENGTH Size
 */
#define GENFSK_PACKET_CFG_LENGTH_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_SZ_MASK)
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_MASK    (0x20U)
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_SHIFT   (5U)
/*! LENGTH_BIT_ORD - LENGTH Bit Order
 *  0b0..LS Bit First
 *  0b1..MS Bit First
 */
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_BIT_ORD_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_BIT_ORD_MASK)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK      (0xC0U)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT     (6U)
/*! SYNC_ADDR_SZ - Sync Address Size
 */
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT)) & GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK)
#define GENFSK_PACKET_CFG_H0_SZ_MASK             (0x1F0000U)
#define GENFSK_PACKET_CFG_H0_SZ_SHIFT            (16U)
/*! H0_SZ - H0 Size
 */
#define GENFSK_PACKET_CFG_H0_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H0_SZ_SHIFT)) & GENFSK_PACKET_CFG_H0_SZ_MASK)
#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_MASK   (0x400000U)
#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_SHIFT  (22U)
/*! AA_PLAYBACK_CNT - AA PLAYBACK COUNT
 *  0b0..AA is not through CRC and not playback to Link layer.
 *  0b1..AA is through CRC and palyback to Link Layer.
 */
#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_SHIFT)) & GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_MASK)
#define GENFSK_PACKET_CFG_LL_FETCH_AA_MASK       (0x800000U)
#define GENFSK_PACKET_CFG_LL_FETCH_AA_SHIFT      (23U)
/*! LL_FETCH_AA - Link layer fetches AA from PHY
 *  0b0..Link layer does not fetch AA from PHY
 *  0b1..Link layer fetches AA from PHY when AA_PLAYBACK_CNT is 0
 */
#define GENFSK_PACKET_CFG_LL_FETCH_AA(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LL_FETCH_AA_SHIFT)) & GENFSK_PACKET_CFG_LL_FETCH_AA_MASK)
#define GENFSK_PACKET_CFG_H1_SZ_MASK             (0x1F000000U)
#define GENFSK_PACKET_CFG_H1_SZ_SHIFT            (24U)
/*! H1_SZ - H1 Size
 */
#define GENFSK_PACKET_CFG_H1_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H1_SZ_SHIFT)) & GENFSK_PACKET_CFG_H1_SZ_MASK)
#define GENFSK_PACKET_CFG_H1_FAIL_MASK           (0x20000000U)
#define GENFSK_PACKET_CFG_H1_FAIL_SHIFT          (29U)
/*! H1_FAIL - H1 Violated Status Bit
 */
#define GENFSK_PACKET_CFG_H1_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H1_FAIL_SHIFT)) & GENFSK_PACKET_CFG_H1_FAIL_MASK)
#define GENFSK_PACKET_CFG_H0_FAIL_MASK           (0x40000000U)
#define GENFSK_PACKET_CFG_H0_FAIL_SHIFT          (30U)
/*! H0_FAIL - H0 Violated Status Bit
 */
#define GENFSK_PACKET_CFG_H0_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H0_FAIL_SHIFT)) & GENFSK_PACKET_CFG_H0_FAIL_MASK)
#define GENFSK_PACKET_CFG_LENGTH_FAIL_MASK       (0x80000000U)
#define GENFSK_PACKET_CFG_LENGTH_FAIL_SHIFT      (31U)
/*! LENGTH_FAIL - Maximum Length Violated Status Bit
 */
#define GENFSK_PACKET_CFG_LENGTH_FAIL(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_FAIL_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_FAIL_MASK)
/*! @} */

/*! @name H0_CFG - H0 CONFIGURATION */
/*! @{ */
#define GENFSK_H0_CFG_H0_MATCH_MASK              (0xFFFFU)
#define GENFSK_H0_CFG_H0_MATCH_SHIFT             (0U)
/*! H0_MATCH - H0 Match Register
 */
#define GENFSK_H0_CFG_H0_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MATCH_SHIFT)) & GENFSK_H0_CFG_H0_MATCH_MASK)
#define GENFSK_H0_CFG_H0_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H0_CFG_H0_MASK_SHIFT              (16U)
/*! H0_MASK - H0 Mask Register
 */
#define GENFSK_H0_CFG_H0_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MASK_SHIFT)) & GENFSK_H0_CFG_H0_MASK_MASK)
/*! @} */

/*! @name H1_CFG - H1 CONFIGURATION */
/*! @{ */
#define GENFSK_H1_CFG_H1_MATCH_MASK              (0xFFFFU)
#define GENFSK_H1_CFG_H1_MATCH_SHIFT             (0U)
/*! H1_MATCH - H1 Match Register
 */
#define GENFSK_H1_CFG_H1_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MATCH_SHIFT)) & GENFSK_H1_CFG_H1_MATCH_MASK)
#define GENFSK_H1_CFG_H1_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H1_CFG_H1_MASK_SHIFT              (16U)
/*! H1_MASK - H1 Mask Register
 */
#define GENFSK_H1_CFG_H1_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MASK_SHIFT)) & GENFSK_H1_CFG_H1_MASK_MASK)
/*! @} */

/*! @name CRC_CFG - CRC CONFIGURATION */
/*! @{ */
#define GENFSK_CRC_CFG_CRC_IGNORE_MASK           (0x1000000U)
#define GENFSK_CRC_CFG_CRC_IGNORE_SHIFT          (24U)
/*! CRC_IGNORE - CRC Ignore
 *  0b0..RX_IRQ will not be asserted for a received packet which fails CRC verification.
 *  0b1..RX_IRQ will be asserted even for a received packet which fails CRC verification.
 */
#define GENFSK_CRC_CFG_CRC_IGNORE(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_IGNORE_SHIFT)) & GENFSK_CRC_CFG_CRC_IGNORE_MASK)
#define GENFSK_CRC_CFG_CRC_VALID_MASK            (0x10000000U)
#define GENFSK_CRC_CFG_CRC_VALID_SHIFT           (28U)
/*! CRC_VALID - CRC Valid
 *  0b0..CRC of RX packet is not valid.
 *  0b1..CRC of RX packet is valid.
 */
#define GENFSK_CRC_CFG_CRC_VALID(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_VALID_SHIFT)) & GENFSK_CRC_CFG_CRC_VALID_MASK)
/*! @} */

/*! @name LENGTH_ADJ - LENGTH ADJUSTMENT */
/*! @{ */
#define GENFSK_LENGTH_ADJ_LENGTH_ADJ_MASK        (0x7FFU)
#define GENFSK_LENGTH_ADJ_LENGTH_ADJ_SHIFT       (0U)
/*! LENGTH_ADJ - Length Adjustment
 */
#define GENFSK_LENGTH_ADJ_LENGTH_ADJ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_ADJ_LENGTH_ADJ_SHIFT)) & GENFSK_LENGTH_ADJ_LENGTH_ADJ_MASK)
/*! @} */

/*! @name LENGTH_MAX - MAXIMUM LENGTH */
/*! @{ */
#define GENFSK_LENGTH_MAX_LENGTH_MAX_MASK        (0x7F0000U)
#define GENFSK_LENGTH_MAX_LENGTH_MAX_SHIFT       (16U)
/*! LENGTH_MAX - Maximum Length for Received Packets
 */
#define GENFSK_LENGTH_MAX_LENGTH_MAX(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_MAX_LENGTH_MAX_SHIFT)) & GENFSK_LENGTH_MAX_LENGTH_MAX_MASK)
#define GENFSK_LENGTH_MAX_REC_BAD_PKT_MASK       (0x800000U)
#define GENFSK_LENGTH_MAX_REC_BAD_PKT_SHIFT      (23U)
/*! REC_BAD_PKT - Receive Bad Packets
 *  0b0..packets which fail H0, H1, or LENGTH_MAX result in an automatic recycle after the header is received and parsed
 *  0b1..packets which fail H0, H1, or LENGTH_MAX are received in their entirety
 */
#define GENFSK_LENGTH_MAX_REC_BAD_PKT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_MAX_REC_BAD_PKT_SHIFT)) & GENFSK_LENGTH_MAX_REC_BAD_PKT_MASK)
/*! @} */

/*! @name ENH_FEATURE - ENHANCED FEATURES */
/*! @{ */
#define GENFSK_ENH_FEATURE_GENLL_MODE_MASK       (0xFU)
#define GENFSK_ENH_FEATURE_GENLL_MODE_SHIFT      (0U)
/*! GENLL_MODE - Linklayer Mode Select
 *  0b0000..GLL Mode
 *  0b0001..PAN Mode
 *  0b0010..FAN Mode
 *  0b0011..Hybrid Dual PAN Mode
 *  0b0100..Reserved
 *  0b0101..Reserved
 *  0b0110..FCP Mode
 *  0b0111..Reserved
 *  0b1000..Reserved
 *  0b1001..Bluetooth LE Uncoded Mode
 *  0b1010..Bluetooth LE LR Mode
 *  0b1011..Bluetooth LE Concurrent Mode (RX configuration only; TX uses either Bluetooth LE UNCODED or Bluetooth LE LR configuration)
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..GTM Mode
 */
#define GENFSK_ENH_FEATURE_GENLL_MODE(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_GENLL_MODE_SHIFT)) & GENFSK_ENH_FEATURE_GENLL_MODE_MASK)
#define GENFSK_ENH_FEATURE_SEL_RXIRQ_MASK        (0x20U)
#define GENFSK_ENH_FEATURE_SEL_RXIRQ_SHIFT       (5U)
/*! SEL_RXIRQ - Select the RX IRQ assert time
 *  0b0..RX_IRQ is asserted at the end of RX_PKT state.
 *  0b1..RX_IRQ is asserted at the end of RXEN_DLY state. This to be used for delaying RX_IRQ to accept TERM2 bits
 *       in Bluetooth LE-LR and CTE bits as needed.
 */
#define GENFSK_ENH_FEATURE_SEL_RXIRQ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SEL_RXIRQ_SHIFT)) & GENFSK_ENH_FEATURE_SEL_RXIRQ_MASK)
#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_MASK (0x40U)
#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_SHIFT (6U)
/*! DATARATE_CONFIG_SEL - Select the data rate configuration bank
 *  0b0..Select the data rate as per configuration bank 0
 *  0b1..Select the data rate as per configuration bank 1
 */
#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_SHIFT)) & GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_MASK)
#define GENFSK_ENH_FEATURE_STAY_IN_RX_MASK       (0x80U)
#define GENFSK_ENH_FEATURE_STAY_IN_RX_SHIFT      (7U)
/*! STAY_IN_RX - Stay in receive
 *  0b0..Linklayer will warmdown after an RX_IRQ
 *  0b1..Linklayer will recycle and stay in receive even after an RX_IRQ.
 */
#define GENFSK_ENH_FEATURE_STAY_IN_RX(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_STAY_IN_RX_SHIFT)) & GENFSK_ENH_FEATURE_STAY_IN_RX_MASK)
#define GENFSK_ENH_FEATURE_PHR_TYPE_MASK         (0x700U)
#define GENFSK_ENH_FEATURE_PHR_TYPE_SHIFT        (8U)
/*! PHR_TYPE - PHR Type
 *  0b000..The packet type is GFSK
 *  0b001..The packet type is MSK
 *  0b010..The packet type is SUN FSK
 *  0b011..The packet type is LECIM FSK
 */
#define GENFSK_ENH_FEATURE_PHR_TYPE(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_PHR_TYPE_SHIFT)) & GENFSK_ENH_FEATURE_PHR_TYPE_MASK)
#define GENFSK_ENH_FEATURE_SW_BUILD_ACK_MASK     (0x800U)
#define GENFSK_ENH_FEATURE_SW_BUILD_ACK_SHIFT    (11U)
/*! SW_BUILD_ACK - Software builds the ACK packet in RAM
 *  0b0..Hardware builds part of or the whole of the auto ACK frame
 *  0b1..Software builds the whole auto ACK frame in RAM.
 */
#define GENFSK_ENH_FEATURE_SW_BUILD_ACK(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SW_BUILD_ACK_SHIFT)) & GENFSK_ENH_FEATURE_SW_BUILD_ACK_MASK)
#define GENFSK_ENH_FEATURE_ACKBUF_SEL_MASK       (0x1000U)
#define GENFSK_ENH_FEATURE_ACKBUF_SEL_SHIFT      (12U)
/*! ACKBUF_SEL - ACK frame is in 64-byte dedicated RAM or TX buffer RAM
 *  0b0..ACK frame is in 64-byte dedicated RAM
 *  0b1..ACK frame is in TX buffer RAM
 */
#define GENFSK_ENH_FEATURE_ACKBUF_SEL(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_ACKBUF_SEL_SHIFT)) & GENFSK_ENH_FEATURE_ACKBUF_SEL_MASK)
#define GENFSK_ENH_FEATURE_AUTOACK_MASK          (0x2000U)
#define GENFSK_ENH_FEATURE_AUTOACK_SHIFT         (13U)
/*! AUTOACK - Auto Acknowledge Enable
 *  0b0..sequence manager will not follow a receive frame with a Tx Ack frame, under any conditions; the
 *       autosequence will terminate after the receive frame.
 *  0b1..sequence manager will follow a receive frame with an automatic hardware-generated Tx Ack frame, assuming other necessary conditions are met.
 */
#define GENFSK_ENH_FEATURE_AUTOACK(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_AUTOACK_SHIFT)) & GENFSK_ENH_FEATURE_AUTOACK_MASK)
#define GENFSK_ENH_FEATURE_RXACKRQD_MASK         (0x4000U)
#define GENFSK_ENH_FEATURE_RXACKRQD_SHIFT        (14U)
/*! RXACKRQD - Receive Acknowledge Frame required
 *  0b0..An ordinary receive frame (any type of frame) follows the transmit frame.
 *  0b1..A receive Ack frame is expected to follow the transmit frame (non-Ack frames are rejected).
 */
#define GENFSK_ENH_FEATURE_RXACKRQD(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_RXACKRQD_SHIFT)) & GENFSK_ENH_FEATURE_RXACKRQD_MASK)
#define GENFSK_ENH_FEATURE_SLOTTED_MASK          (0x8000U)
#define GENFSK_ENH_FEATURE_SLOTTED_SHIFT         (15U)
/*! SLOTTED - Slotted Mode
 */
#define GENFSK_ENH_FEATURE_SLOTTED(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SLOTTED_SHIFT)) & GENFSK_ENH_FEATURE_SLOTTED_MASK)
#define GENFSK_ENH_FEATURE_LENGTH_ACK_MASK       (0x7FF0000U)
#define GENFSK_ENH_FEATURE_LENGTH_ACK_SHIFT      (16U)
/*! LENGTH_ACK - Length of the ACK frame(or part of the ACK frame) in RAM
 */
#define GENFSK_ENH_FEATURE_LENGTH_ACK(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_LENGTH_ACK_SHIFT)) & GENFSK_ENH_FEATURE_LENGTH_ACK_MASK)
#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_MASK  (0x80000000U)
#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_SHIFT (31U)
/*! BLE_V5P1_CTE_EN - Bluetooth LE version 5.1 CTE feature enable
 *  0b0..Do not support Bluetooth LE version 5.1 CTE feature.
 *  0b1..Support Bluetooth LE version 5.1 CTE feature, which means the link layer hardware can parse the CTE field
 *       length and extend the RX_EN signal accordingly.
 */
#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_SHIFT)) & GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_MASK)
/*! @} */

/*! @name RX_FRAME_FILTER - RECEIVE FRAME FILTER */
/*! @{ */
#define GENFSK_RX_FRAME_FILTER_BEACON_FT_MASK    (0x1U)
#define GENFSK_RX_FRAME_FILTER_BEACON_FT_SHIFT   (0U)
/*! BEACON_FT - Beacon Frame Type Enable
 *  0b0..reject all Beacon frames
 *  0b1..Beacon frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_BEACON_FT(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_BEACON_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_BEACON_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_DATA_FT_MASK      (0x2U)
#define GENFSK_RX_FRAME_FILTER_DATA_FT_SHIFT     (1U)
/*! DATA_FT - Data Frame Type Enable
 *  0b0..reject all Beacon frames
 *  0b1..Data frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_DATA_FT(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_DATA_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_DATA_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_ACK_FT_MASK       (0x4U)
#define GENFSK_RX_FRAME_FILTER_ACK_FT_SHIFT      (2U)
/*! ACK_FT - Ack Frame Type Enable
 *  0b0..reject all Acknowledge frames
 *  0b1..Acknowledge frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_ACK_FT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_ACK_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_ACK_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_CMD_FT_MASK       (0x8U)
#define GENFSK_RX_FRAME_FILTER_CMD_FT_SHIFT      (3U)
/*! CMD_FT - MAC Command Frame Type Enable
 *  0b0..reject all MAC Command frames
 *  0b1..MAC Command frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_CMD_FT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_CMD_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_CMD_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_LLDN_FT_MASK      (0x10U)
#define GENFSK_RX_FRAME_FILTER_LLDN_FT_SHIFT     (4U)
/*! LLDN_FT - LLDN Frame Type Enable
 *  0b0..reject all LLDN frames
 *  0b1..LLDN frame type enabled (Frame Type 4).
 */
#define GENFSK_RX_FRAME_FILTER_LLDN_FT(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_LLDN_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_LLDN_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_MASK (0x20U)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_SHIFT (5U)
/*! MULTIPURPOSE_FT - Multipurpose Frame Type Enable
 *  0b0..reject all Multipurpose frames
 *  0b1..Multipurpose frame type enabled (Frame Type 5).
 */
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_MASK  (0x40U)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_SHIFT (6U)
/*! FRAGMENT_FT - Fragment Frame Type Enable
 *  0b0..reject all Fragment frames
 *  0b1..Fragment frame type enabled (Frame Type 6).
 */
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT_MASK  (0x80U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT_SHIFT (7U)
/*! EXTENDED_FT - Extended Frame Type Enable
 *  0b0..reject all Extended frames
 *  0b1..Extended frame type enabled (Frame Type 7).
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_NS_FT_MASK        (0x100U)
#define GENFSK_RX_FRAME_FILTER_NS_FT_SHIFT       (8U)
/*! NS_FT - "Not Specified" Frame Type Enable
 *  0b0..reject all "Not Specified" frames
 *  0b1..Not-specified (reserved) frame type enabled. Applies to Frame Type 6. No packet filtering is performed,
 *       except for frame length checking (FrameLength>=5 and FrameLength<=127). No AUTOACK is transmitted for this
 *       Frame Type
 */
#define GENFSK_RX_FRAME_FILTER_NS_FT(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_NS_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_NS_FT_MASK)
#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_MASK (0x1E00U)
#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_SHIFT (9U)
/*! FRM_VER_FILTER - Frame Version selector.
 */
#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_MASK)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_MASK (0x8000U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_SHIFT (15U)
/*! EXTENDED_FCS_CHK - Verify FCS on Frame Type Extended
 *  0b0..Packet Processor will not check FCS for Frame Type EXTENDED (default)
 *  0b1..Packet Processor will check FCS at end-of-packet based on packet length derived from PHR, for Frame Type EXTENDED
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_MASK)
#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_MASK (0x10000U)
#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_SHIFT (16U)
/*! FV2_BEACON_RECD - Frame Version 2 Beacon Packet Received
 *  0b0..The last packet received was not Frame Type Beacon with Frame Version 2
 *  0b1..The last packet received was Frame Type Beacon with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_MASK (0x20000U)
#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_SHIFT (17U)
/*! FV2_DATA_RECD - Frame Version 2 Data Packet Received
 *  0b0..The last packet received was not Frame Type Data with Frame Version 2
 *  0b1..The last packet received was Frame Type Data with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_MASK (0x40000U)
#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_SHIFT (18U)
/*! FV2_ACK_RECD - Frame Version 2 Acknowledge Packet Received
 *  0b0..The last packet received was not Frame Type Ack with Frame Version 2
 *  0b1..The last packet received was Frame Type Ack with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_MASK (0x80000U)
#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_SHIFT (19U)
/*! FV2_CMD_RECD - Frame Version 2 MAC Command Packet Received
 *  0b0..The last packet received was not Frame Type MAC Command with Frame Version 2
 *  0b1..The last packet received was Frame Type MAC Command with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_LLDN_RECD_MASK    (0x100000U)
#define GENFSK_RX_FRAME_FILTER_LLDN_RECD_SHIFT   (20U)
/*! LLDN_RECD - LLDN Packet Received
 *  0b0..The last packet received was not Frame Type LLDN
 *  0b1..The last packet received was Frame Type LLDN, and LLDN_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_LLDN_RECD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_LLDN_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_LLDN_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_MASK (0x200000U)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_SHIFT (21U)
/*! MULTIPURPOSE_RECD - Multipurpose Packet Received
 *  0b0..last packet received was not Frame Type MULTIPURPOSE
 *  0b1..The last packet received was Frame Type MULTIPURPOSE, and MULTIPURPOSE_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_MASK (0x400000U)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_SHIFT (22U)
/*! FRAGMENT_RECD - Fragment Packet Received
 *  0b0..last packet received was not Frame Type FRAGMENT
 *  0b1..The last packet received was Frame Type FRAGMENT, and FRAGMENT_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_MASK (0x800000U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_SHIFT (23U)
/*! EXTENDED_RECD - Extended Packet Received
 *  0b0..The last packet received was not Frame Type EXTENDED
 *  0b1..The last packet received was Frame Type EXTENDED, and EXTENDED_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_MASK)
#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL_MASK    (0x10000000U)
#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL_SHIFT   (28U)
/*! RXCYC_SEL - Rx Recycle Time Select
 *  0b0..Recycle when fail happens.
 *  0b1..Recycle when Rx done and fail happens.
 */
#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_RXCYC_SEL_SHIFT)) & GENFSK_RX_FRAME_FILTER_RXCYC_SEL_MASK)
#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_MASK (0x20000000U)
#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_SHIFT (29U)
/*! FILTER_FAIL_IGNORE - Filter Fail Ignore
 *  0b0..RX_IRQ will not be asserted when filter fail.
 *  0b1..RX_IRQ will be asserted when filter fail.
 */
#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_SHIFT)) & GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_MASK)
#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS_MASK  (0x40000000U)
#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS_SHIFT (30U)
/*! PROMISCUOUS - Promiscuous Mode Enable
 *  0b0..normal mode
 *  0b1..all packet filtering except frame length checking (FrameLength>=5) is bypassed.
 */
#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_PROMISCUOUS_SHIFT)) & GENFSK_RX_FRAME_FILTER_PROMISCUOUS_MASK)
#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_MASK (0x80000000U)
#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_SHIFT (31U)
/*! ENH_PKT_STATUS - Enhanced Packet Status
 *  0b0..The last packet received was not 2015-compliant
 *  0b1..The last packet received was 2015-compliant (RX_FRAME_FILTER register should be queried for additional status bits)
 */
#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_SHIFT)) & GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_MASK)
/*! @} */

/*! @name FILTERFAIL_CODE - FILTER FAIL CODE */
/*! @{ */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_MASK (0x3FFU)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_SHIFT (0U)
/*! FILTERFAIL_CODE_PAN - Filter Fail Code When in PAN Mode
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_MASK)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_MASK (0x30000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_SHIFT (16U)
/*! FILTERFAIL_CODE_FAN - Filter Fail Code When in FAN Mode
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_MASK)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_MASK (0x40000000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_SHIFT (30U)
/*! FILTERFAIL_PAN_SEL - PAN Selector for Filter Fail Code
 *  0b0..FILTERFAIL_CODE_PAN/FILTERFAIL_CODE_FAN will report the FILTERFAIL status of PAN0
 *  0b1..FILTERFAIL_CODE_PAN/FILTERFAIL_CODE_FAN will report the FILTERFAIL status of PAN1
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_MASK)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_MASK (0x80000000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_SHIFT (31U)
/*! FILTERFAIL_FLAG_SEL - Consolidated Filter Fail Flag
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_MASK)
/*! @} */

/*! @name LENIENCY_LSB - LENIENCY LSB */
/*! @{ */
#define GENFSK_LENIENCY_LSB_LENIENCY_LSB_MASK    (0xFFFFFFFFU)
#define GENFSK_LENIENCY_LSB_LENIENCY_LSB_SHIFT   (0U)
/*! LENIENCY_LSB - Leniency LSB Register
 */
#define GENFSK_LENIENCY_LSB_LENIENCY_LSB(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_LENIENCY_LSB_LENIENCY_LSB_SHIFT)) & GENFSK_LENIENCY_LSB_LENIENCY_LSB_MASK)
/*! @} */

/*! @name LENIENCY_MSB - LENIENCY MSB */
/*! @{ */
#define GENFSK_LENIENCY_MSB_LENIENCY_MSB_MASK    (0x1FFFU)
#define GENFSK_LENIENCY_MSB_LENIENCY_MSB_SHIFT   (0U)
/*! LENIENCY_MSB - Leniency MSB Register
 */
#define GENFSK_LENIENCY_MSB_LENIENCY_MSB(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_LENIENCY_MSB_LENIENCY_MSB_SHIFT)) & GENFSK_LENIENCY_MSB_LENIENCY_MSB_MASK)
/*! @} */

/*! @name DUAL_PAN_CTRL - DUAL PAN CONTROL */
/*! @{ */
#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_MASK (0x1U)
#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_SHIFT (0U)
/*! ACTIVE_NETWORK - Active Network Selector
 *  0b0..Select PAN0
 *  0b1..Select PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_SHIFT)) & GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_MASK)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_MASK  (0x2U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_SHIFT (1U)
/*! DUAL_PAN_AUTO - Activates automatic Dual PAN operating mode
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_MASK)
#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_MASK (0x4U)
#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_SHIFT (2U)
/*! CURRENT_NETWORK - Indicates which PAN is currently selected by hardware
 *  0b0..PAN0 is selected
 *  0b1..PAN1 is selected
 */
#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_SHIFT)) & GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_MASK)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_MASK (0xFF00U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_SHIFT (8U)
/*! DUAL_PAN_DWELL - Dual PAN Channel Frequency Dwell Time
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_MASK)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_MASK (0x3F0000U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_SHIFT (16U)
/*! DUAL_PAN_REMAIN - Time Remaining before next PAN switch in auto Dual PAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_MASK)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0_MASK      (0x1000000U)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0_SHIFT     (24U)
/*! MODE_PAN0 - PAN0 Mode Select
 *  0b0..PAN0 is in PAN mode
 *  0b1..PAN0 is in FAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_MODE_PAN0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_MODE_PAN0_MASK)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1_MASK      (0x2000000U)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1_SHIFT     (25U)
/*! MODE_PAN1 - PAN1 Mode Select
 *  0b0..PAN1 is in PAN mode
 *  0b1..PAN1 is in FAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_MODE_PAN1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_MODE_PAN1_MASK)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_MASK (0x4000000U)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_SHIFT (26U)
/*! DP_CHAN_OVRD_EN - Dual PAN Channel Override Enable
 */
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_MASK)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_MASK (0x8000000U)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_SHIFT (27U)
/*! DP_CHAN_OVRD_SEL - Dual PAN Channel Override Selector
 */
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_MASK)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_MASK    (0x10000000U)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_SHIFT   (28U)
/*! PANCORDNTR0 - Device is a PAN Coordinator on PAN0
 */
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_MASK)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_MASK    (0x20000000U)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_SHIFT   (29U)
/*! PANCORDNTR1 - Device is a PAN Coordinator on PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_MASK)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_MASK   (0x40000000U)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_SHIFT  (30U)
/*! RECD_ON_PAN0 - Last Packet was Received on PAN0
 */
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_MASK)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_MASK   (0x80000000U)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_SHIFT  (31U)
/*! RECD_ON_PAN1 - Last Packet was Received on PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_MASK)
/*! @} */

/*! @name GTM_PDU - GTM MODE PDU */
/*! @{ */
#define GENFSK_GTM_PDU_GTM_PDU_MASK              (0xFFFFFFFFU)
#define GENFSK_GTM_PDU_GTM_PDU_SHIFT             (0U)
/*! GTM_PDU - GTM MODE PDU
 */
#define GENFSK_GTM_PDU_GTM_PDU(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_PDU_GTM_PDU_SHIFT)) & GENFSK_GTM_PDU_GTM_PDU_MASK)
/*! @} */

/*! @name MACSHORTADDRS1 - MAC SHORT ADDRESS FOR PAN1 */
/*! @{ */
#define GENFSK_MACSHORTADDRS1_MACPANID1_MASK     (0xFFFFU)
#define GENFSK_MACSHORTADDRS1_MACPANID1_SHIFT    (0U)
/*! MACPANID1 - MAC PAN ID for PAN1
 */
#define GENFSK_MACSHORTADDRS1_MACPANID1(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS1_MACPANID1_SHIFT)) & GENFSK_MACSHORTADDRS1_MACPANID1_MASK)
#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_MASK (0xFFFF0000U)
#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_SHIFT (16U)
/*! MACSHORTADDRS1 - MAC SHORT ADDRESS for PAN1
 */
#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_SHIFT)) & GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_MASK)
/*! @} */

/*! @name GTM_CFG - GTM MODE CONFIGURATION */
/*! @{ */
#define GENFSK_GTM_CFG_GTM_PKT_NUM_MASK          (0xFFFU)
#define GENFSK_GTM_CFG_GTM_PKT_NUM_SHIFT         (0U)
/*! GTM_PKT_NUM - GTM MODE PACKET NUMBER
 */
#define GENFSK_GTM_CFG_GTM_PKT_NUM(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PKT_NUM_SHIFT)) & GENFSK_GTM_CFG_GTM_PKT_NUM_MASK)
#define GENFSK_GTM_CFG_GTM_PDU_TYPE_MASK         (0xF000000U)
#define GENFSK_GTM_CFG_GTM_PDU_TYPE_SHIFT        (24U)
/*! GTM_PDU_TYPE - GTM MODE PDU TYPE SELECTION
 *  0b0000..PRBS9 Sequence
 *  0b0001..Programmable 8-bit Pattern (from register GTM_PDU[7:0], reused from MACSHORTADDRS1[7:0])
 *  0b0010..PRBS-13 Sequence
 *  0b0011..PRBS-15 Sequence
 *  0b0100..Programmable 32-bit Pattern (from register GTM_PDU[31:0], reused from {MACSHORTADDRS1,MACPANID1})
 *  0b0101..Programmable packet from Packet RAM (in this case, PKT_LEN is ignored)
 */
#define GENFSK_GTM_CFG_GTM_PDU_TYPE(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PDU_TYPE_SHIFT)) & GENFSK_GTM_CFG_GTM_PDU_TYPE_MASK)
#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_MASK    (0x40000000U)
#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_SHIFT   (30U)
/*! GTM_IPD_CHECK_DIS - GTM MODE INTER-PACKET DURATION CHECK DISABLE
 */
#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_SHIFT)) & GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_MASK)
#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_MASK (0x80000000U)
#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_SHIFT (31U)
/*! GTM_PKT_COUNT_CHECK_DIS - GTM MODE PACKET NUMBER CHECK DISABLE
 */
#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_SHIFT)) & GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_MASK)
/*! @} */

/*! @name MACLONGADDRS1_LSB - MAC LONG ADDRESS 1 LSB */
/*! @{ */
#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_SHIFT (0U)
/*! MACLONGADDRS1_LSB - MAC LONG ADDRESS for PAN1 LSB
 */
#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_SHIFT)) & GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_MASK)
/*! @} */

/*! @name GTM_IPD - GTM MODE INTER-PACKET DURATION */
/*! @{ */
#define GENFSK_GTM_IPD_GTM_IPD_MASK              (0xFFFFFU)
#define GENFSK_GTM_IPD_GTM_IPD_SHIFT             (0U)
/*! GTM_IPD - GTM MODE INTER-PACKET DURATION
 */
#define GENFSK_GTM_IPD_GTM_IPD(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_IPD_GTM_IPD_SHIFT)) & GENFSK_GTM_IPD_GTM_IPD_MASK)
/*! @} */

/*! @name MACLONGADDRS1_MSB - MAC LONG ADDRESS 1 MSB */
/*! @{ */
#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_SHIFT (0U)
/*! MACLONGADDRS1_MSB - MAC LONG ADDRESS for PAN1 MSB
 */
#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_SHIFT)) & GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_MASK)
/*! @} */

/*! @name CHANNEL_NUM1 - CHANNEL NUMBER 1 */
/*! @{ */
#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_MASK    (0x7FU)
#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_SHIFT   (0U)
/*! CHANNEL_NUM1 - Channel Number for PAN1
 */
#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_SHIFT)) & GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_MASK)
/*! @} */

/*! @name MACSHORTADDRS0 - MAC SHORT ADDRESS 0 */
/*! @{ */
#define GENFSK_MACSHORTADDRS0_MACPANID0_MASK     (0xFFFFU)
#define GENFSK_MACSHORTADDRS0_MACPANID0_SHIFT    (0U)
/*! MACPANID0 - MAC PAN ID for PAN0
 */
#define GENFSK_MACSHORTADDRS0_MACPANID0(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS0_MACPANID0_SHIFT)) & GENFSK_MACSHORTADDRS0_MACPANID0_MASK)
#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_MASK (0xFFFF0000U)
#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_SHIFT (16U)
/*! MACSHORTADDRS0 - MAC SHORT ADDRESS FOR PAN0
 */
#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_SHIFT)) & GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_MASK)
/*! @} */

/*! @name GTM_FIRST_SFD2WD - GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN */
/*! @{ */
#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_MASK (0xFFFFFU)
#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_SHIFT (0U)
/*! GTM_FIRST_SFD2WD - GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN
 */
#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_SHIFT)) & GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_MASK)
/*! @} */

/*! @name MACLONGADDRS0_LSB - MAC LONG ADDRESS 0 LSB */
/*! @{ */
#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_SHIFT (0U)
/*! MACLONGADDRS0_LSB - MAC LONG ADDRESS for PAN0 LSB
 */
#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_SHIFT)) & GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_MASK)
/*! @} */

/*! @name GTM_RX_RECYCLE_TIME - GTM MODE RX RECYCLE TIME */
/*! @{ */
#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_MASK (0xFFFFFU)
#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_SHIFT (0U)
/*! GTM_RX_RECYCLE_TIME - GTM MODE RX RECYCLE TIME
 */
#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_SHIFT)) & GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_MASK)
/*! @} */

/*! @name MACLONGADDRS0_MSB - MAC LONG ADDRESS 0 MSB */
/*! @{ */
#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_SHIFT (0U)
/*! MACLONGADDRS0_MSB - MAC LONG ADDRESS for PAN0 MSB
 */
#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_SHIFT)) & GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_MASK)
/*! @} */

/*! @name CCA_LQI_CTRL - CCA AND LQI CONTROL */
/*! @{ */
#define GENFSK_CCA_LQI_CTRL_CCABFRTX_MASK        (0x1U)
#define GENFSK_CCA_LQI_CTRL_CCABFRTX_SHIFT       (0U)
/*! CCABFRTX - CCA Before TX
 *  0b0..no CCA required, transmit operation begins immediately.
 *  0b1..at least one CCA measurement is required prior to the transmit operation (see also SLOTTED).
 */
#define GENFSK_CCA_LQI_CTRL_CCABFRTX(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCABFRTX_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCABFRTX_MASK)
#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_MASK    (0x2U)
#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_SHIFT   (1U)
/*! SIMUL_CCA_RX - Simultaneous CCA and Receive Enable
 *  0b0..Packets can't be received during CCA measurement
 *  0b1..Packet reception is enabled during CCA measurement if preamble and SFD are detected
 */
#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_SHIFT)) & GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_MASK)
#define GENFSK_CCA_LQI_CTRL_CCA_MASK             (0x80U)
#define GENFSK_CCA_LQI_CTRL_CCA_SHIFT            (7U)
/*! CCA - CCA Status
 *  0b0..IDLE
 *  0b1..BUSY
 */
#define GENFSK_CCA_LQI_CTRL_CCA(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA_MASK)
#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH_MASK     (0xFF00U)
#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH_SHIFT    (8U)
/*! CCA1_THRESH - CCA Mode 1 Threshold
 */
#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA1_THRESH_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA1_THRESH_MASK)
#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_MASK     (0xFF0000U)
#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_SHIFT    (16U)
/*! CCA1_ED_FNL - Final Result for CCA Mode 1 and Energy Detect
 */
#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_MASK)
/*! @} */

/*! @name WARMUP_TIME - TX/RX WARMUP TIME */
/*! @{ */
#define GENFSK_WARMUP_TIME_RX_WARMUP_MASK        (0xFFU)
#define GENFSK_WARMUP_TIME_RX_WARMUP_SHIFT       (0U)
/*! RX_WARMUP - Receive Warmup Time
 */
#define GENFSK_WARMUP_TIME_RX_WARMUP(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_WARMUP_TIME_RX_WARMUP_SHIFT)) & GENFSK_WARMUP_TIME_RX_WARMUP_MASK)
#define GENFSK_WARMUP_TIME_TX_WARMUP_MASK        (0xFF0000U)
#define GENFSK_WARMUP_TIME_TX_WARMUP_SHIFT       (16U)
/*! TX_WARMUP - Transmit Warmup Time
 */
#define GENFSK_WARMUP_TIME_TX_WARMUP(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_WARMUP_TIME_TX_WARMUP_SHIFT)) & GENFSK_WARMUP_TIME_TX_WARMUP_MASK)
/*! @} */

/*! @name RXEN_DLY - RX_EN Delay Time */
/*! @{ */
#define GENFSK_RXEN_DLY_RXEN_DLY_MASK            (0x3FFU)
#define GENFSK_RXEN_DLY_RXEN_DLY_SHIFT           (0U)
#define GENFSK_RXEN_DLY_RXEN_DLY(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_RXEN_DLY_RXEN_DLY_SHIFT)) & GENFSK_RXEN_DLY_RXEN_DLY_MASK)
#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_MASK   (0x80000000U)
#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_SHIFT  (31U)
/*! RXEN_DLY_OVERRIDE
 *  0b0..For Bluetooth LE case, RX_EN signal will delay to de-assert accroding to the length of TERM2 or CTE(when
 *       BLE_V5P1_CTE_EN is enabled) field parsed by hardware
 *  0b1..For all receive case, RX_EN signal will delay to de-assert accroding to register RXEN_DLY[9:0].
 */
#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_SHIFT)) & GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_MASK)
/*! @} */

/*! @name SAM_CTRL - SAM CONTROL */
/*! @{ */
#define GENFSK_SAM_CTRL_SAP0_EN_MASK             (0x1U)
#define GENFSK_SAM_CTRL_SAP0_EN_SHIFT            (0U)
/*! SAP0_EN - Enables SAP0 Partition of the SAM Table
 *  0b0..Disables SAP0 Partition
 *  0b1..Enables SAP0 Partition
 */
#define GENFSK_SAM_CTRL_SAP0_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP0_EN_SHIFT)) & GENFSK_SAM_CTRL_SAP0_EN_MASK)
#define GENFSK_SAM_CTRL_SAA0_EN_MASK             (0x2U)
#define GENFSK_SAM_CTRL_SAA0_EN_SHIFT            (1U)
/*! SAA0_EN - Enables SAA0 Partition of the SAM Table
 *  0b0..Disables SAA0 Partition
 *  0b1..Enables SAA0 Partition
 */
#define GENFSK_SAM_CTRL_SAA0_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA0_EN_SHIFT)) & GENFSK_SAM_CTRL_SAA0_EN_MASK)
#define GENFSK_SAM_CTRL_SAP1_EN_MASK             (0x4U)
#define GENFSK_SAM_CTRL_SAP1_EN_SHIFT            (2U)
/*! SAP1_EN - Enables SAP1 Partition of the SAM Table
 *  0b0..Disables SAP1 Partition
 *  0b1..Enables SAP1 Partition
 */
#define GENFSK_SAM_CTRL_SAP1_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP1_EN_SHIFT)) & GENFSK_SAM_CTRL_SAP1_EN_MASK)
#define GENFSK_SAM_CTRL_SAA1_EN_MASK             (0x8U)
#define GENFSK_SAM_CTRL_SAA1_EN_SHIFT            (3U)
/*! SAA1_EN - Enables SAA1 Partition of the SAM Table
 *  0b0..Disables SAA1 Partition
 *  0b1..Enables SAA1 Partition
 */
#define GENFSK_SAM_CTRL_SAA1_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA1_EN_SHIFT)) & GENFSK_SAM_CTRL_SAA1_EN_MASK)
#define GENFSK_SAM_CTRL_SAA0_START_MASK          (0xFF00U)
#define GENFSK_SAM_CTRL_SAA0_START_SHIFT         (8U)
/*! SAA0_START - First Index of SAA0 partition
 */
#define GENFSK_SAM_CTRL_SAA0_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA0_START_SHIFT)) & GENFSK_SAM_CTRL_SAA0_START_MASK)
#define GENFSK_SAM_CTRL_SAP1_START_MASK          (0xFF0000U)
#define GENFSK_SAM_CTRL_SAP1_START_SHIFT         (16U)
/*! SAP1_START - First Index of SAP1 partition
 */
#define GENFSK_SAM_CTRL_SAP1_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP1_START_SHIFT)) & GENFSK_SAM_CTRL_SAP1_START_MASK)
#define GENFSK_SAM_CTRL_SAA1_START_MASK          (0xFF000000U)
#define GENFSK_SAM_CTRL_SAA1_START_SHIFT         (24U)
/*! SAA1_START - First Index of SAA1 partition
 */
#define GENFSK_SAM_CTRL_SAA1_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA1_START_SHIFT)) & GENFSK_SAM_CTRL_SAA1_START_MASK)
/*! @} */

/*! @name SAM_TABLE - SOURCE ADDRESS MANAGEMENT TABLE */
/*! @{ */
#define GENFSK_SAM_TABLE_SAM_INDEX_MASK          (0x7FU)
#define GENFSK_SAM_TABLE_SAM_INDEX_SHIFT         (0U)
/*! SAM_INDEX - Contains the SAM table index to be enabled or invalidated
 */
#define GENFSK_SAM_TABLE_SAM_INDEX(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_MASK)
#define GENFSK_SAM_TABLE_SAM_INDEX_WR_MASK       (0x80U)
#define GENFSK_SAM_TABLE_SAM_INDEX_WR_SHIFT      (7U)
/*! SAM_INDEX_WR - Enables SAM Table Contents to be updated
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_WR(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_WR_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_WR_MASK)
#define GENFSK_SAM_TABLE_SAM_CHECKSUM_MASK       (0xFFFF00U)
#define GENFSK_SAM_TABLE_SAM_CHECKSUM_SHIFT      (8U)
/*! SAM_CHECKSUM - Software-computed source address checksum, to be installed into a table index
 */
#define GENFSK_SAM_TABLE_SAM_CHECKSUM(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_CHECKSUM_SHIFT)) & GENFSK_SAM_TABLE_SAM_CHECKSUM_MASK)
#define GENFSK_SAM_TABLE_SAM_INDEX_INV_MASK      (0x1000000U)
#define GENFSK_SAM_TABLE_SAM_INDEX_INV_SHIFT     (24U)
/*! SAM_INDEX_INV - Invalidate the SAM table index selected by SAM_INDEX
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_INV(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_INV_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_INV_MASK)
#define GENFSK_SAM_TABLE_SAM_INDEX_EN_MASK       (0x2000000U)
#define GENFSK_SAM_TABLE_SAM_INDEX_EN_SHIFT      (25U)
/*! SAM_INDEX_EN - Enable the SAM table index selected by SAM_INDEX
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_EN(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_EN_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_EN_MASK)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_MASK        (0x4000000U)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_SHIFT       (26U)
/*! ACK_FRM_PND - State of AutoTxAck FramePending field when SAM Accelleration is Disabled
 */
#define GENFSK_SAM_TABLE_ACK_FRM_PND(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_ACK_FRM_PND_SHIFT)) & GENFSK_SAM_TABLE_ACK_FRM_PND_MASK)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_MASK   (0x8000000U)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_SHIFT  (27U)
/*! ACK_FRM_PND_CTRL - Manual Control for AutoTxAck FramePending field
 *  0b0..the FramePending field of the Frame Control Field of the next automatic TX acknowledge packet is determined by hardware
 *  0b1..the FramePending field of the Frame Control Field of the next automatic TX acknowledge packet tracks ACK_FRM_PEND
 */
#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_SHIFT)) & GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_MASK)
#define GENFSK_SAM_TABLE_FIND_FREE_IDX_MASK      (0x10000000U)
#define GENFSK_SAM_TABLE_FIND_FREE_IDX_SHIFT     (28U)
/*! FIND_FREE_IDX - Find First Free Index
 */
#define GENFSK_SAM_TABLE_FIND_FREE_IDX(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_FIND_FREE_IDX_SHIFT)) & GENFSK_SAM_TABLE_FIND_FREE_IDX_MASK)
#define GENFSK_SAM_TABLE_INVALIDATE_ALL_MASK     (0x20000000U)
#define GENFSK_SAM_TABLE_INVALIDATE_ALL_SHIFT    (29U)
/*! INVALIDATE_ALL - Invalidate Entire SAM Table
 */
#define GENFSK_SAM_TABLE_INVALIDATE_ALL(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_INVALIDATE_ALL_SHIFT)) & GENFSK_SAM_TABLE_INVALIDATE_ALL_MASK)
#define GENFSK_SAM_TABLE_SRCADDR_MASK            (0x40000000U)
#define GENFSK_SAM_TABLE_SRCADDR_SHIFT           (30U)
/*! SRCADDR - Source Address Match Status
 */
#define GENFSK_SAM_TABLE_SRCADDR(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SRCADDR_SHIFT)) & GENFSK_SAM_TABLE_SRCADDR_MASK)
#define GENFSK_SAM_TABLE_SAM_BUSY_MASK           (0x80000000U)
#define GENFSK_SAM_TABLE_SAM_BUSY_SHIFT          (31U)
/*! SAM_BUSY - SAM Table Update Status Bit
 */
#define GENFSK_SAM_TABLE_SAM_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_BUSY_SHIFT)) & GENFSK_SAM_TABLE_SAM_BUSY_MASK)
/*! @} */

/*! @name SAM_MATCH - SOURCE ADDRESS MANAGEMENT MATCH */
/*! @{ */
#define GENFSK_SAM_MATCH_SAP0_MATCH_MASK         (0x7FU)
#define GENFSK_SAM_MATCH_SAP0_MATCH_SHIFT        (0U)
/*! SAP0_MATCH - Index in the SAP0 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAP0_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP0_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAP0_MATCH_MASK)
#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_MASK  (0x80U)
#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_SHIFT (7U)
/*! SAP0_ADDR_PRESENT - A Checksum Match is Present in the SAP0 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_SHIFT)) & GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_MASK)
#define GENFSK_SAM_MATCH_SAA0_MATCH_MASK         (0x7F00U)
#define GENFSK_SAM_MATCH_SAA0_MATCH_SHIFT        (8U)
/*! SAA0_MATCH - Index in the SAA0 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAA0_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA0_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAA0_MATCH_MASK)
#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_MASK   (0x8000U)
#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_SHIFT  (15U)
/*! SAA0_ADDR_ABSENT - A Checksum Match is Absent in the SAA0 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_SHIFT)) & GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_MASK)
#define GENFSK_SAM_MATCH_SAP1_MATCH_MASK         (0x7F0000U)
#define GENFSK_SAM_MATCH_SAP1_MATCH_SHIFT        (16U)
/*! SAP1_MATCH - Index in the SAP1 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAP1_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP1_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAP1_MATCH_MASK)
#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_MASK  (0x800000U)
#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_SHIFT (23U)
/*! SAP1_ADDR_PRESENT - A Checksum Match is Present in the SAP1 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_SHIFT)) & GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_MASK)
#define GENFSK_SAM_MATCH_SAA1_MATCH_MASK         (0x7F000000U)
#define GENFSK_SAM_MATCH_SAA1_MATCH_SHIFT        (24U)
/*! SAA1_MATCH - Index in the SAA1 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAA1_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA1_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAA1_MATCH_MASK)
#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_MASK   (0x80000000U)
#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_SHIFT  (31U)
/*! SAA1_ADDR_ABSENT - A Checksum Match is Absent in the SAP1 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_SHIFT)) & GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_MASK)
/*! @} */

/*! @name SAM_FREE_IDX - SAM FREE INDEX */
/*! @{ */
#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_MASK (0xFFU)
#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_SHIFT (0U)
/*! SAP0_1ST_FREE_IDX - First non-enabled (invalid) index in the SAP0 partition
 */
#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_MASK)
#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_MASK (0xFF00U)
#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_SHIFT (8U)
/*! SAA0_1ST_FREE_IDX - First non-enabled (invalid) index in the SAA0 partition
 */
#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_MASK)
#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_MASK (0xFF0000U)
#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_SHIFT (16U)
/*! SAP1_1ST_FREE_IDX - First non-enabled (invalid) index in the SAP1 partition
 */
#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_MASK)
#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_MASK (0xFF000000U)
#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_SHIFT (24U)
/*! SAA1_1ST_FREE_IDX - First non-enabled (invalid) index in the SAA1 partition
 */
#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_MASK)
/*! @} */

/*! @name MISC1 - MISCELLANEOUS(1) */
/*! @{ */
#define GENFSK_MISC1_SRC_ADDR_CHECKSUM_MASK      (0xFFFFU)
#define GENFSK_MISC1_SRC_ADDR_CHECKSUM_SHIFT     (0U)
/*! SRC_ADDR_CHECKSUM - Hardware-computed received source address checksum
 */
#define GENFSK_MISC1_SRC_ADDR_CHECKSUM(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_SRC_ADDR_CHECKSUM_SHIFT)) & GENFSK_MISC1_SRC_ADDR_CHECKSUM_MASK)
#define GENFSK_MISC1_SW_ABORTED_MASK             (0x10000U)
#define GENFSK_MISC1_SW_ABORTED_SHIFT            (16U)
/*! SW_ABORTED - Autosequence has terminated due to a Software abort.
 */
#define GENFSK_MISC1_SW_ABORTED(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_SW_ABORTED_SHIFT)) & GENFSK_MISC1_SW_ABORTED_MASK)
#define GENFSK_MISC1_PLL_ABORTED_MASK            (0x20000U)
#define GENFSK_MISC1_PLL_ABORTED_SHIFT           (17U)
/*! PLL_ABORTED - Autosequence has terminated due to an PLL unlock event.
 */
#define GENFSK_MISC1_PLL_ABORTED(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_PLL_ABORTED_SHIFT)) & GENFSK_MISC1_PLL_ABORTED_MASK)
#define GENFSK_MISC1_FAST_TX_WU_OVRD_MASK        (0x10000000U)
#define GENFSK_MISC1_FAST_TX_WU_OVRD_SHIFT       (28U)
/*! FAST_TX_WU_OVRD - FAST_TX_WU override
 *  0b0..If TSM enables Fast Warmup Capability, LL will request it when TX in RT or (CCA+TX)
 *  0b1..If TSM enables Fast Warmup Capability, LL will request it at every TX. User should insure channel is not changed since last sequence.
 */
#define GENFSK_MISC1_FAST_TX_WU_OVRD(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_FAST_TX_WU_OVRD_SHIFT)) & GENFSK_MISC1_FAST_TX_WU_OVRD_MASK)
#define GENFSK_MISC1_FAST_RX_WU_OVRD_MASK        (0x20000000U)
#define GENFSK_MISC1_FAST_RX_WU_OVRD_SHIFT       (29U)
/*! FAST_RX_WU_OVRD - FAST_RX_WU override
 *  0b0..If TSM enables Fast Warmup Capability, LL will request it when RX in TR
 *  0b1..If TSM enables Fast Warmup Capability, LL will request it at every RX. User should insure channel is not changed since last sequence.
 */
#define GENFSK_MISC1_FAST_RX_WU_OVRD(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_FAST_RX_WU_OVRD_SHIFT)) & GENFSK_MISC1_FAST_RX_WU_OVRD_MASK)
#define GENFSK_MISC1_PI_MASK                     (0x40000000U)
#define GENFSK_MISC1_PI_SHIFT                    (30U)
/*! PI - Poll Indication
 *  0b0..the received packet was not a data request
 *  0b1..the received packet was a data request, regardless of whether a Source Address table match occurred, or
 *       whether Source Address Management is enabled or not
 */
#define GENFSK_MISC1_PI(x)                       (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_PI_SHIFT)) & GENFSK_MISC1_PI_MASK)
#define GENFSK_MISC1_RX_FRM_PEND_MASK            (0x80000000U)
#define GENFSK_MISC1_RX_FRM_PEND_SHIFT           (31U)
/*! RX_FRM_PEND - RX Frame Pending
 */
#define GENFSK_MISC1_RX_FRM_PEND(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_RX_FRM_PEND_SHIFT)) & GENFSK_MISC1_RX_FRM_PEND_MASK)
/*! @} */

/*! @name SEQ_STS - SEQUENCE STATUS */
/*! @{ */
#define GENFSK_SEQ_STS_TX_START_T1_PEND_MASK     (0x1U)
#define GENFSK_SEQ_STS_TX_START_T1_PEND_SHIFT    (0U)
/*! TX_START_T1_PEND - TX T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_TX_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_TX_START_T1_PEND_MASK)
#define GENFSK_SEQ_STS_TX_START_T2_PEND_MASK     (0x2U)
#define GENFSK_SEQ_STS_TX_START_T2_PEND_SHIFT    (1U)
/*! TX_START_T2_PEND - TX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_TX_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_TX_START_T2_PEND_MASK)
#define GENFSK_SEQ_STS_TX_IN_WARMUP_MASK         (0x4U)
#define GENFSK_SEQ_STS_TX_IN_WARMUP_SHIFT        (2U)
/*! TX_IN_WARMUP - TX Warmup Status
 */
#define GENFSK_SEQ_STS_TX_IN_WARMUP(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_WARMUP_SHIFT)) & GENFSK_SEQ_STS_TX_IN_WARMUP_MASK)
#define GENFSK_SEQ_STS_TX_IN_PROGRESS_MASK       (0x8U)
#define GENFSK_SEQ_STS_TX_IN_PROGRESS_SHIFT      (3U)
/*! TX_IN_PROGRESS - TX in Progress Status
 */
#define GENFSK_SEQ_STS_TX_IN_PROGRESS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_PROGRESS_SHIFT)) & GENFSK_SEQ_STS_TX_IN_PROGRESS_MASK)
#define GENFSK_SEQ_STS_TX_IN_WARMDN_MASK         (0x10U)
#define GENFSK_SEQ_STS_TX_IN_WARMDN_SHIFT        (4U)
/*! TX_IN_WARMDN - TX Warmdown Status
 */
#define GENFSK_SEQ_STS_TX_IN_WARMDN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_WARMDN_SHIFT)) & GENFSK_SEQ_STS_TX_IN_WARMDN_MASK)
#define GENFSK_SEQ_STS_RX_START_T1_PEND_MASK     (0x20U)
#define GENFSK_SEQ_STS_RX_START_T1_PEND_SHIFT    (5U)
/*! RX_START_T1_PEND - RX T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_START_T1_PEND_MASK)
#define GENFSK_SEQ_STS_RX_START_T2_PEND_MASK     (0x40U)
#define GENFSK_SEQ_STS_RX_START_T2_PEND_SHIFT    (6U)
/*! RX_START_T2_PEND - RX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_START_T2_PEND_MASK)
#define GENFSK_SEQ_STS_RX_STOP_T1_PEND_MASK      (0x80U)
#define GENFSK_SEQ_STS_RX_STOP_T1_PEND_SHIFT     (7U)
/*! RX_STOP_T1_PEND - RX T1 Stop Pending Status
 */
#define GENFSK_SEQ_STS_RX_STOP_T1_PEND(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_STOP_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_STOP_T1_PEND_MASK)
#define GENFSK_SEQ_STS_RX_STOP_T2_PEND_MASK      (0x100U)
#define GENFSK_SEQ_STS_RX_STOP_T2_PEND_SHIFT     (8U)
/*! RX_STOP_T2_PEND - RX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_STOP_T2_PEND(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_STOP_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_STOP_T2_PEND_MASK)
#define GENFSK_SEQ_STS_RX_IN_WARMUP_MASK         (0x200U)
#define GENFSK_SEQ_STS_RX_IN_WARMUP_SHIFT        (9U)
/*! RX_IN_WARMUP - RX Warmup Status
 */
#define GENFSK_SEQ_STS_RX_IN_WARMUP(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_WARMUP_SHIFT)) & GENFSK_SEQ_STS_RX_IN_WARMUP_MASK)
#define GENFSK_SEQ_STS_RX_IN_SEARCH_MASK         (0x400U)
#define GENFSK_SEQ_STS_RX_IN_SEARCH_SHIFT        (10U)
/*! RX_IN_SEARCH - RX Search Status
 */
#define GENFSK_SEQ_STS_RX_IN_SEARCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_SEARCH_SHIFT)) & GENFSK_SEQ_STS_RX_IN_SEARCH_MASK)
#define GENFSK_SEQ_STS_RX_IN_PROGRESS_MASK       (0x800U)
#define GENFSK_SEQ_STS_RX_IN_PROGRESS_SHIFT      (11U)
/*! RX_IN_PROGRESS - RX in Progress Status
 */
#define GENFSK_SEQ_STS_RX_IN_PROGRESS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_PROGRESS_SHIFT)) & GENFSK_SEQ_STS_RX_IN_PROGRESS_MASK)
#define GENFSK_SEQ_STS_RX_IN_WARMDN_MASK         (0x1000U)
#define GENFSK_SEQ_STS_RX_IN_WARMDN_SHIFT        (12U)
/*! RX_IN_WARMDN - RX Warmdown Status
 */
#define GENFSK_SEQ_STS_RX_IN_WARMDN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_WARMDN_SHIFT)) & GENFSK_SEQ_STS_RX_IN_WARMDN_MASK)
#define GENFSK_SEQ_STS_TR_START_T1_PEND_MASK     (0x2000U)
#define GENFSK_SEQ_STS_TR_START_T1_PEND_SHIFT    (13U)
/*! TR_START_T1_PEND - TR T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_TR_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TR_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_TR_START_T1_PEND_MASK)
#define GENFSK_SEQ_STS_TR_START_T2_PEND_MASK     (0x4000U)
#define GENFSK_SEQ_STS_TR_START_T2_PEND_SHIFT    (14U)
/*! TR_START_T2_PEND - TR T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_TR_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TR_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_TR_START_T2_PEND_MASK)
#define GENFSK_SEQ_STS_CCA_START_T1_PEND_MASK    (0x8000U)
#define GENFSK_SEQ_STS_CCA_START_T1_PEND_SHIFT   (15U)
/*! CCA_START_T1_PEND - CCA T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_CCA_START_T1_PEND(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_CCA_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_CCA_START_T1_PEND_MASK)
#define GENFSK_SEQ_STS_CCA_START_T2_PEND_MASK    (0x10000U)
#define GENFSK_SEQ_STS_CCA_START_T2_PEND_SHIFT   (16U)
/*! CCA_START_T2_PEND - CCA T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_CCA_START_T2_PEND(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_CCA_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_CCA_START_T2_PEND_MASK)
#define GENFSK_SEQ_STS_SEQ_T_STATUS_MASK         (0x1F000000U)
#define GENFSK_SEQ_STS_SEQ_T_STATUS_SHIFT        (24U)
/*! SEQ_T_STATUS - Status of the just-completed or ongoing Sequence T or Sequence TR
 */
#define GENFSK_SEQ_STS_SEQ_T_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_SEQ_T_STATUS_SHIFT)) & GENFSK_SEQ_STS_SEQ_T_STATUS_MASK)
/*! @} */

/*! @name PHR_MISC - PHR MISCELLANEOUS */
/*! @{ */
#define GENFSK_PHR_MISC_SUNFSK_MS_MASK           (0x1U)
#define GENFSK_PHR_MISC_SUNFSK_MS_SHIFT          (0U)
/*! SUNFSK_MS - Mode Switch Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_MS(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_MS_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_MS_MASK)
#define GENFSK_PHR_MISC_SUNFSK_MSP_MASK          (0x6U)
#define GENFSK_PHR_MISC_SUNFSK_MSP_SHIFT         (1U)
/*! SUNFSK_MSP - Mode Switch Parameter Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_MSP(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_MSP_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_MSP_MASK)
#define GENFSK_PHR_MISC_SUNFSK_FEC_MASK          (0x8U)
#define GENFSK_PHR_MISC_SUNFSK_FEC_SHIFT         (3U)
/*! SUNFSK_FEC - New Mode FEC Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_FEC(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_FEC_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_FEC_MASK)
#define GENFSK_PHR_MISC_SUNFSK_NM_MASK           (0x7F0U)
#define GENFSK_PHR_MISC_SUNFSK_NM_SHIFT          (4U)
/*! SUNFSK_NM - New Mode Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_NM(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_NM_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_NM_MASK)
#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE_MASK     (0x1000000U)
#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE_SHIFT    (24U)
/*! PHR_FAIL_IGNORE - Ignore PHR Fail
 */
#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_PHR_FAIL_IGNORE_SHIFT)) & GENFSK_PHR_MISC_PHR_FAIL_IGNORE_MASK)
/*! @} */

/*! @name GTM_CTRL - GTM CONTROL */
/*! @{ */
#define GENFSK_GTM_CTRL_GTM_IN_RX_MASK           (0x1U)
#define GENFSK_GTM_CTRL_GTM_IN_RX_SHIFT          (0U)
/*! GTM_IN_RX - Enable GTM Receive Mode
 *  0b0..GTM receive mode is not enabled.
 *  0b1..GTM receive mode is enabled.
 */
#define GENFSK_GTM_CTRL_GTM_IN_RX(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CTRL_GTM_IN_RX_SHIFT)) & GENFSK_GTM_CTRL_GTM_IN_RX_MASK)
#define GENFSK_GTM_CTRL_GTM_IN_TX_MASK           (0x2U)
#define GENFSK_GTM_CTRL_GTM_IN_TX_SHIFT          (1U)
/*! GTM_IN_TX - Enable GTM Transmit Mode
 *  0b0..GTM transmit mode is not enabled.
 *  0b1..GTM transmit mode is enabled.
 */
#define GENFSK_GTM_CTRL_GTM_IN_TX(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CTRL_GTM_IN_TX_SHIFT)) & GENFSK_GTM_CTRL_GTM_IN_TX_MASK)
/*! @} */

/*! @name GTM_BAD_CNT - GTM BAD PACKET COUNTER */
/*! @{ */
#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_MASK (0xFFFU)
#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_SHIFT (0U)
/*! GTM_BAD_PKT_COUNT - GTM Bad Packet Counter
 */
#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_SHIFT)) & GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_MASK)
/*! @} */

/*! @name GTM_GOOD_CNT - GTM GOOD PACKET COUNTER */
/*! @{ */
#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_MASK (0xFFFU)
#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_SHIFT (0U)
/*! GTM_GOOD_PKT_COUNT - GTM Good Packet Counter
 */
#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_SHIFT)) & GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_MASK)
/*! @} */

/*! @name GTM_PKT_CNT - GTM PACKET COUNTER */
/*! @{ */
#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_MASK    (0x1FFFU)
#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_SHIFT   (0U)
/*! GTM_PKT_COUNT - GTM Packet Counter
 */
#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_SHIFT)) & GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group GENFSK_Register_Masks */


/* GENFSK - Peripheral instance base addresses */
/** Peripheral GENFSK base address */
#define GENFSK_BASE                              (0x40082000u)
/** Peripheral GENFSK base pointer */
#define GENFSK                                   ((GENFSK_Type *)GENFSK_BASE)
/** Array initializer of GENFSK peripheral base addresses */
#define GENFSK_BASE_ADDRS                        { GENFSK_BASE }
/** Array initializer of GENFSK peripheral base pointers */
#define GENFSK_BASE_PTRS                         { GENFSK }

/*!
 * @}
 */ /* end of group GENFSK_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name PDOR - Port Data Output Register */
/*! @{ */
#define GPIO_PDOR_PDO_MASK                       (0xFFFFFFFFU)
#define GPIO_PDOR_PDO_SHIFT                      (0U)
/*! PDO - Port Data Output
 *  0b00000000000000000000000000000000..Logic level 0 is driven on pin, provided pin is configured for general-purpose output.
 *  0b00000000000000000000000000000001..Logic level 1 is driven on pin, provided pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO_SHIFT)) & GPIO_PDOR_PDO_MASK)
/*! @} */

/*! @name PSOR - Port Set Output Register */
/*! @{ */
#define GPIO_PSOR_PTSO_MASK                      (0xFFFFFFFFU)
#define GPIO_PSOR_PTSO_SHIFT                     (0U)
/*! PTSO - Port Set Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is set to logic 1.
 */
#define GPIO_PSOR_PTSO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO_SHIFT)) & GPIO_PSOR_PTSO_MASK)
/*! @} */

/*! @name PCOR - Port Clear Output Register */
/*! @{ */
#define GPIO_PCOR_PTCO_MASK                      (0xFFFFFFFFU)
#define GPIO_PCOR_PTCO_SHIFT                     (0U)
/*! PTCO - Port Clear Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO_SHIFT)) & GPIO_PCOR_PTCO_MASK)
/*! @} */

/*! @name PTOR - Port Toggle Output Register */
/*! @{ */
#define GPIO_PTOR_PTTO_MASK                      (0xFFFFFFFFU)
#define GPIO_PTOR_PTTO_SHIFT                     (0U)
/*! PTTO - Port Toggle Output
 *  0b00000000000000000000000000000000..Corresponding bit in PDORn does not change.
 *  0b00000000000000000000000000000001..Corresponding bit in PDORn is set to the inverse of its existing logic state.
 */
#define GPIO_PTOR_PTTO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO_SHIFT)) & GPIO_PTOR_PTTO_MASK)
/*! @} */

/*! @name PDIR - Port Data Input Register */
/*! @{ */
#define GPIO_PDIR_PDI_MASK                       (0xFFFFFFFFU)
#define GPIO_PDIR_PDI_SHIFT                      (0U)
/*! PDI - Port Data Input
 *  0b00000000000000000000000000000000..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b00000000000000000000000000000001..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI_SHIFT)) & GPIO_PDIR_PDI_MASK)
/*! @} */

/*! @name PDDR - Port Data Direction Register */
/*! @{ */
#define GPIO_PDDR_PDD_MASK                       (0xFFFFFFFFU)
#define GPIO_PDDR_PDD_SHIFT                      (0U)
/*! PDD - Port Data Direction
 *  0b00000000000000000000000000000000..Pin is configured as general-purpose input, for the GPIO function.
 *  0b00000000000000000000000000000001..Pin is configured as general-purpose output, for the GPIO function.
 */
#define GPIO_PDDR_PDD(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD_SHIFT)) & GPIO_PDDR_PDD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIOA base address */
#define GPIOA_BASE                               (0x400FF000u)
/** Peripheral GPIOA base pointer */
#define GPIOA                                    ((GPIO_Type *)GPIOA_BASE)
/** Peripheral GPIOB base address */
#define GPIOB_BASE                               (0x400FF040u)
/** Peripheral GPIOB base pointer */
#define GPIOB                                    ((GPIO_Type *)GPIOB_BASE)
/** Peripheral GPIOC base address */
#define GPIOC_BASE                               (0x400FF080u)
/** Peripheral GPIOC base pointer */
#define GPIOC                                    ((GPIO_Type *)GPIOC_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIOA_BASE, GPIOB_BASE, GPIOC_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIOA, GPIOB, GPIOC }

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
  __IO uint8_t A1;                                 /**< I2C Address Register 1, offset: 0x0 */
  __IO uint8_t F;                                  /**< I2C Frequency Divider register, offset: 0x1 */
  __IO uint8_t C1;                                 /**< I2C Control Register 1, offset: 0x2 */
  __IO uint8_t S;                                  /**< I2C Status register, offset: 0x3 */
  __IO uint8_t D;                                  /**< I2C Data I/O register, offset: 0x4 */
  __IO uint8_t C2;                                 /**< I2C Control Register 2, offset: 0x5 */
  __IO uint8_t FLT;                                /**< I2C Programmable Input Glitch Filter Register, offset: 0x6 */
  __IO uint8_t RA;                                 /**< I2C Range Address register, offset: 0x7 */
  __IO uint8_t SMB;                                /**< I2C SMBus Control and Status register, offset: 0x8 */
  __IO uint8_t A2;                                 /**< I2C Address Register 2, offset: 0x9 */
  __IO uint8_t SLTH;                               /**< I2C SCL Low Timeout Register High, offset: 0xA */
  __IO uint8_t SLTL;                               /**< I2C SCL Low Timeout Register Low, offset: 0xB */
  __IO uint8_t S2;                                 /**< I2C Status register 2, offset: 0xC */
} I2C_Type;

/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name A1 - I2C Address Register 1 */
/*! @{ */
#define I2C_A1_AD_MASK                           (0xFEU)
#define I2C_A1_AD_SHIFT                          (1U)
/*! AD - Address
 */
#define I2C_A1_AD(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_A1_AD_SHIFT)) & I2C_A1_AD_MASK)
/*! @} */

/*! @name F - I2C Frequency Divider register */
/*! @{ */
#define I2C_F_ICR_MASK                           (0x3FU)
#define I2C_F_ICR_SHIFT                          (0U)
/*! ICR - ClockRate
 */
#define I2C_F_ICR(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_F_ICR_SHIFT)) & I2C_F_ICR_MASK)
#define I2C_F_MULT_MASK                          (0xC0U)
#define I2C_F_MULT_SHIFT                         (6U)
/*! MULT - Multiplier Factor
 *  0b00..mul = 1
 *  0b01..mul = 2
 *  0b10..mul = 4
 *  0b11..Reserved
 */
#define I2C_F_MULT(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_F_MULT_SHIFT)) & I2C_F_MULT_MASK)
/*! @} */

/*! @name C1 - I2C Control Register 1 */
/*! @{ */
#define I2C_C1_DMAEN_MASK                        (0x1U)
#define I2C_C1_DMAEN_SHIFT                       (0U)
/*! DMAEN - DMA Enable
 *  0b0..All DMA signalling disabled.
 *  0b1..DMA transfer is enabled. While SMB[FACK] = 0, the following conditions trigger the DMA request: a data
 *       byte is received, and either address or data is transmitted. (ACK/NACK is automatic) the first byte received
 *       matches the A1 register or is a general call address. If any address matching occurs, S[IAAS] and S[TCF]
 *       are set. If the direction of transfer is known from master to slave, then it is not required to check
 *       S[SRW]. With this assumption, DMA can also be used in this case. In other cases, if the master reads data from
 *       the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be
 *       used. When FACK = 1, an address or a data byte is transmitted.
 */
#define I2C_C1_DMAEN(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_C1_DMAEN_SHIFT)) & I2C_C1_DMAEN_MASK)
#define I2C_C1_WUEN_MASK                         (0x2U)
#define I2C_C1_WUEN_SHIFT                        (1U)
/*! WUEN - Wakeup Enable
 *  0b0..Normal operation. No interrupt generated when address matching in low power mode.
 *  0b1..Enables the wakeup function in low power mode.
 */
#define I2C_C1_WUEN(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C1_WUEN_SHIFT)) & I2C_C1_WUEN_MASK)
#define I2C_C1_RSTA_MASK                         (0x4U)
#define I2C_C1_RSTA_SHIFT                        (2U)
/*! RSTA - Repeat START
 */
#define I2C_C1_RSTA(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C1_RSTA_SHIFT)) & I2C_C1_RSTA_MASK)
#define I2C_C1_TXAK_MASK                         (0x8U)
#define I2C_C1_TXAK_SHIFT                        (3U)
/*! TXAK - Transmit Acknowledge Enable
 *  0b0..An acknowledge signal is sent to the bus on the following receiving byte (if FACK is cleared) or the
 *       current receiving byte (if FACK is set).
 *  0b1..No acknowledge signal is sent to the bus on the following receiving data byte (if FACK is cleared) or the
 *       current receiving data byte (if FACK is set).
 */
#define I2C_C1_TXAK(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C1_TXAK_SHIFT)) & I2C_C1_TXAK_MASK)
#define I2C_C1_TX_MASK                           (0x10U)
#define I2C_C1_TX_SHIFT                          (4U)
/*! TX - Transmit Mode Select
 *  0b0..Receive
 *  0b1..Transmit
 */
#define I2C_C1_TX(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_C1_TX_SHIFT)) & I2C_C1_TX_MASK)
#define I2C_C1_MST_MASK                          (0x20U)
#define I2C_C1_MST_SHIFT                         (5U)
/*! MST - Master Mode Select
 *  0b0..Slave mode
 *  0b1..Master mode
 */
#define I2C_C1_MST(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_C1_MST_SHIFT)) & I2C_C1_MST_MASK)
#define I2C_C1_IICIE_MASK                        (0x40U)
#define I2C_C1_IICIE_SHIFT                       (6U)
/*! IICIE - I2C Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define I2C_C1_IICIE(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_C1_IICIE_SHIFT)) & I2C_C1_IICIE_MASK)
#define I2C_C1_IICEN_MASK                        (0x80U)
#define I2C_C1_IICEN_SHIFT                       (7U)
/*! IICEN - I2C Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define I2C_C1_IICEN(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_C1_IICEN_SHIFT)) & I2C_C1_IICEN_MASK)
/*! @} */

/*! @name S - I2C Status register */
/*! @{ */
#define I2C_S_RXAK_MASK                          (0x1U)
#define I2C_S_RXAK_SHIFT                         (0U)
/*! RXAK - Receive Acknowledge
 *  0b0..Acknowledge signal was received after the completion of one byte of data transmission on the bus
 *  0b1..No acknowledge signal detected
 */
#define I2C_S_RXAK(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_S_RXAK_SHIFT)) & I2C_S_RXAK_MASK)
#define I2C_S_IICIF_MASK                         (0x2U)
#define I2C_S_IICIF_SHIFT                        (1U)
/*! IICIF - Interrupt Flag
 *  0b0..No interrupt pending
 *  0b1..Interrupt pending
 */
#define I2C_S_IICIF(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_S_IICIF_SHIFT)) & I2C_S_IICIF_MASK)
#define I2C_S_SRW_MASK                           (0x4U)
#define I2C_S_SRW_SHIFT                          (2U)
/*! SRW - Slave Read/Write
 *  0b0..Slave receive, master writing to slave
 *  0b1..Slave transmit, master reading from slave
 */
#define I2C_S_SRW(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_S_SRW_SHIFT)) & I2C_S_SRW_MASK)
#define I2C_S_RAM_MASK                           (0x8U)
#define I2C_S_RAM_SHIFT                          (3U)
/*! RAM - Range Address Match
 *  0b0..Not addressed
 *  0b1..Addressed as a slave
 */
#define I2C_S_RAM(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_S_RAM_SHIFT)) & I2C_S_RAM_MASK)
#define I2C_S_ARBL_MASK                          (0x10U)
#define I2C_S_ARBL_SHIFT                         (4U)
/*! ARBL - Arbitration Lost
 *  0b0..Standard bus operation.
 *  0b1..Loss of arbitration.
 */
#define I2C_S_ARBL(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_S_ARBL_SHIFT)) & I2C_S_ARBL_MASK)
#define I2C_S_BUSY_MASK                          (0x20U)
#define I2C_S_BUSY_SHIFT                         (5U)
/*! BUSY - Bus Busy
 *  0b0..Bus is idle
 *  0b1..Bus is busy
 */
#define I2C_S_BUSY(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_S_BUSY_SHIFT)) & I2C_S_BUSY_MASK)
#define I2C_S_IAAS_MASK                          (0x40U)
#define I2C_S_IAAS_SHIFT                         (6U)
/*! IAAS - Addressed As A Slave
 *  0b0..Not addressed
 *  0b1..Addressed as a slave
 */
#define I2C_S_IAAS(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_S_IAAS_SHIFT)) & I2C_S_IAAS_MASK)
#define I2C_S_TCF_MASK                           (0x80U)
#define I2C_S_TCF_SHIFT                          (7U)
/*! TCF - Transfer Complete Flag
 *  0b0..Transfer in progress
 *  0b1..Transfer complete
 */
#define I2C_S_TCF(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_S_TCF_SHIFT)) & I2C_S_TCF_MASK)
/*! @} */

/*! @name D - I2C Data I/O register */
/*! @{ */
#define I2C_D_DATA_MASK                          (0xFFU)
#define I2C_D_DATA_SHIFT                         (0U)
/*! DATA - Data
 */
#define I2C_D_DATA(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_D_DATA_SHIFT)) & I2C_D_DATA_MASK)
/*! @} */

/*! @name C2 - I2C Control Register 2 */
/*! @{ */
#define I2C_C2_AD_MASK                           (0x7U)
#define I2C_C2_AD_SHIFT                          (0U)
/*! AD - Slave Address
 */
#define I2C_C2_AD(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_C2_AD_SHIFT)) & I2C_C2_AD_MASK)
#define I2C_C2_RMEN_MASK                         (0x8U)
#define I2C_C2_RMEN_SHIFT                        (3U)
/*! RMEN - Range Address Matching Enable
 *  0b0..Range mode disabled. No address matching occurs for an address within the range of values of the A1 and RA registers.
 *  0b1..Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.
 */
#define I2C_C2_RMEN(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C2_RMEN_SHIFT)) & I2C_C2_RMEN_MASK)
#define I2C_C2_SBRC_MASK                         (0x10U)
#define I2C_C2_SBRC_SHIFT                        (4U)
/*! SBRC - Slave Baud Rate Control
 *  0b0..The slave baud rate follows the master baud rate and clock stretching may occur
 *  0b1..Slave baud rate is independent of the master baud rate
 */
#define I2C_C2_SBRC(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C2_SBRC_SHIFT)) & I2C_C2_SBRC_MASK)
#define I2C_C2_HDRS_MASK                         (0x20U)
#define I2C_C2_HDRS_SHIFT                        (5U)
/*! HDRS - High Drive Select
 *  0b0..Normal drive mode
 *  0b1..High drive mode
 */
#define I2C_C2_HDRS(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_C2_HDRS_SHIFT)) & I2C_C2_HDRS_MASK)
#define I2C_C2_ADEXT_MASK                        (0x40U)
#define I2C_C2_ADEXT_SHIFT                       (6U)
/*! ADEXT - Address Extension
 *  0b0..7-bit address scheme
 *  0b1..10-bit address scheme
 */
#define I2C_C2_ADEXT(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_C2_ADEXT_SHIFT)) & I2C_C2_ADEXT_MASK)
#define I2C_C2_GCAEN_MASK                        (0x80U)
#define I2C_C2_GCAEN_SHIFT                       (7U)
/*! GCAEN - General Call Address Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define I2C_C2_GCAEN(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_C2_GCAEN_SHIFT)) & I2C_C2_GCAEN_MASK)
/*! @} */

/*! @name FLT - I2C Programmable Input Glitch Filter Register */
/*! @{ */
#define I2C_FLT_FLT_MASK                         (0xFU)
#define I2C_FLT_FLT_SHIFT                        (0U)
/*! FLT - I2C Programmable Filter Factor
 *  0b0000..No filter/bypass
 */
#define I2C_FLT_FLT(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_FLT_FLT_SHIFT)) & I2C_FLT_FLT_MASK)
#define I2C_FLT_STARTF_MASK                      (0x10U)
#define I2C_FLT_STARTF_SHIFT                     (4U)
/*! STARTF - I2C Bus Start Detect Flag
 *  0b0..No start happens on I2C bus
 *  0b1..Start detected on I2C bus
 */
#define I2C_FLT_STARTF(x)                        (((uint8_t)(((uint8_t)(x)) << I2C_FLT_STARTF_SHIFT)) & I2C_FLT_STARTF_MASK)
#define I2C_FLT_SSIE_MASK                        (0x20U)
#define I2C_FLT_SSIE_SHIFT                       (5U)
/*! SSIE - I2C Bus Stop or Start Interrupt Enable
 *  0b0..Stop or start detection interrupt is disabled
 *  0b1..Stop or start detection interrupt is enabled
 */
#define I2C_FLT_SSIE(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_FLT_SSIE_SHIFT)) & I2C_FLT_SSIE_MASK)
#define I2C_FLT_STOPF_MASK                       (0x40U)
#define I2C_FLT_STOPF_SHIFT                      (6U)
/*! STOPF - I2C Bus Stop Detect Flag
 *  0b0..No stop happens on I2C bus
 *  0b1..Stop detected on I2C bus
 */
#define I2C_FLT_STOPF(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_FLT_STOPF_SHIFT)) & I2C_FLT_STOPF_MASK)
#define I2C_FLT_SHEN_MASK                        (0x80U)
#define I2C_FLT_SHEN_SHIFT                       (7U)
/*! SHEN - Stop Hold Enable
 *  0b0..Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
 *  0b1..Stop holdoff is enabled.
 */
#define I2C_FLT_SHEN(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_FLT_SHEN_SHIFT)) & I2C_FLT_SHEN_MASK)
/*! @} */

/*! @name RA - I2C Range Address register */
/*! @{ */
#define I2C_RA_RAD_MASK                          (0xFEU)
#define I2C_RA_RAD_SHIFT                         (1U)
/*! RAD - Range Slave Address
 */
#define I2C_RA_RAD(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_RA_RAD_SHIFT)) & I2C_RA_RAD_MASK)
/*! @} */

/*! @name SMB - I2C SMBus Control and Status register */
/*! @{ */
#define I2C_SMB_SHTF2IE_MASK                     (0x1U)
#define I2C_SMB_SHTF2IE_SHIFT                    (0U)
/*! SHTF2IE - SHTF2 Interrupt Enable
 *  0b0..SHTF2 interrupt is disabled
 *  0b1..SHTF2 interrupt is enabled
 */
#define I2C_SMB_SHTF2IE(x)                       (((uint8_t)(((uint8_t)(x)) << I2C_SMB_SHTF2IE_SHIFT)) & I2C_SMB_SHTF2IE_MASK)
#define I2C_SMB_SHTF2_MASK                       (0x2U)
#define I2C_SMB_SHTF2_SHIFT                      (1U)
/*! SHTF2 - SCL High Timeout Flag 2
 *  0b0..No SCL high and SDA low timeout occurs
 *  0b1..SCL high and SDA low timeout occurs
 */
#define I2C_SMB_SHTF2(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SMB_SHTF2_SHIFT)) & I2C_SMB_SHTF2_MASK)
#define I2C_SMB_SHTF1_MASK                       (0x4U)
#define I2C_SMB_SHTF1_SHIFT                      (2U)
/*! SHTF1 - SCL High Timeout Flag 1
 *  0b0..No SCL high and SDA high timeout occurs
 *  0b1..SCL high and SDA high timeout occurs
 */
#define I2C_SMB_SHTF1(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SMB_SHTF1_SHIFT)) & I2C_SMB_SHTF1_MASK)
#define I2C_SMB_SLTF_MASK                        (0x8U)
#define I2C_SMB_SLTF_SHIFT                       (3U)
/*! SLTF - SCL Low Timeout Flag
 *  0b0..No low timeout occurs
 *  0b1..Low timeout occurs
 */
#define I2C_SMB_SLTF(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_SMB_SLTF_SHIFT)) & I2C_SMB_SLTF_MASK)
#define I2C_SMB_TCKSEL_MASK                      (0x10U)
#define I2C_SMB_TCKSEL_SHIFT                     (4U)
/*! TCKSEL - Timeout Counter Clock Select
 *  0b0..Timeout counter counts at the frequency of the I2C module clock / 64
 *  0b1..Timeout counter counts at the frequency of the I2C module clock
 */
#define I2C_SMB_TCKSEL(x)                        (((uint8_t)(((uint8_t)(x)) << I2C_SMB_TCKSEL_SHIFT)) & I2C_SMB_TCKSEL_MASK)
#define I2C_SMB_SIICAEN_MASK                     (0x20U)
#define I2C_SMB_SIICAEN_SHIFT                    (5U)
/*! SIICAEN - Second I2C Address Enable
 *  0b0..I2C address register 2 matching is disabled
 *  0b1..I2C address register 2 matching is enabled
 */
#define I2C_SMB_SIICAEN(x)                       (((uint8_t)(((uint8_t)(x)) << I2C_SMB_SIICAEN_SHIFT)) & I2C_SMB_SIICAEN_MASK)
#define I2C_SMB_ALERTEN_MASK                     (0x40U)
#define I2C_SMB_ALERTEN_SHIFT                    (6U)
/*! ALERTEN - SMBus Alert Response Address Enable
 *  0b0..SMBus alert response address matching is disabled
 *  0b1..SMBus alert response address matching is enabled
 */
#define I2C_SMB_ALERTEN(x)                       (((uint8_t)(((uint8_t)(x)) << I2C_SMB_ALERTEN_SHIFT)) & I2C_SMB_ALERTEN_MASK)
#define I2C_SMB_FACK_MASK                        (0x80U)
#define I2C_SMB_FACK_SHIFT                       (7U)
/*! FACK - Fast NACK/ACK Enable
 *  0b0..An ACK or NACK is sent on the following receiving data byte
 *  0b1..Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data
 *       byte generates a NACK. Enable I2C_S2[DFEN] in the master receive mode.
 */
#define I2C_SMB_FACK(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_SMB_FACK_SHIFT)) & I2C_SMB_FACK_MASK)
/*! @} */

/*! @name A2 - I2C Address Register 2 */
/*! @{ */
#define I2C_A2_SAD_MASK                          (0xFEU)
#define I2C_A2_SAD_SHIFT                         (1U)
/*! SAD - SMBus Address
 */
#define I2C_A2_SAD(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_A2_SAD_SHIFT)) & I2C_A2_SAD_MASK)
/*! @} */

/*! @name SLTH - I2C SCL Low Timeout Register High */
/*! @{ */
#define I2C_SLTH_SSLT_MASK                       (0xFFU)
#define I2C_SLTH_SSLT_SHIFT                      (0U)
/*! SSLT - SSLT[15:8]
 */
#define I2C_SLTH_SSLT(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SLTH_SSLT_SHIFT)) & I2C_SLTH_SSLT_MASK)
/*! @} */

/*! @name SLTL - I2C SCL Low Timeout Register Low */
/*! @{ */
#define I2C_SLTL_SSLT_MASK                       (0xFFU)
#define I2C_SLTL_SSLT_SHIFT                      (0U)
/*! SSLT - SSLT[7:0]
 */
#define I2C_SLTL_SSLT(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SLTL_SSLT_SHIFT)) & I2C_SLTL_SSLT_MASK)
/*! @} */

/*! @name S2 - I2C Status register 2 */
/*! @{ */
#define I2C_S2_EMPTY_MASK                        (0x1U)
#define I2C_S2_EMPTY_SHIFT                       (0U)
/*! EMPTY - Empty flag
 *  0b0..Tx or Rx buffer is not empty and cannot be written to, that is new data cannot be loaded into the buffer.
 *  0b1..Tx or Rx buffer is empty and can be written to, that is new data can be loaded into the buffer.
 */
#define I2C_S2_EMPTY(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_S2_EMPTY_SHIFT)) & I2C_S2_EMPTY_MASK)
#define I2C_S2_ERROR_MASK                        (0x2U)
#define I2C_S2_ERROR_SHIFT                       (1U)
/*! ERROR - Error flag
 *  0b0..The buffer is not full and all write/read operations have no errors.
 *  0b1..There are 3 or more write/read errors during the data transfer phase (when the Empty flag is not set and the buffer is busy).
 */
#define I2C_S2_ERROR(x)                          (((uint8_t)(((uint8_t)(x)) << I2C_S2_ERROR_SHIFT)) & I2C_S2_ERROR_MASK)
#define I2C_S2_DFEN_MASK                         (0x4U)
#define I2C_S2_DFEN_SHIFT                        (2U)
/*! DFEN - Double Buffer Enable
 *  0b0..Disables the double buffer mode; clock stretch is enabled.
 *  0b1..Enables the double buffer mode; clock stretch is disabled. In the slave mode, the I2C will not hold bus between data transfers.
 */
#define I2C_S2_DFEN(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_S2_DFEN_SHIFT)) & I2C_S2_DFEN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40066000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40067000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1 }
/** Interrupt vectors for the I2C peripheral type */
#define I2C_IRQS                                 { I2C0_IRQn, I2C1_IRQn }

/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LLWU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Peripheral_Access_Layer LLWU Peripheral Access Layer
 * @{
 */

/** LLWU - Register Layout Typedef */
typedef struct {
  __IO uint8_t PE1;                                /**< LLWU Pin Enable 1 register, offset: 0x0 */
  __IO uint8_t PE2;                                /**< LLWU Pin Enable 2 register, offset: 0x1 */
  __IO uint8_t PE3;                                /**< LLWU Pin Enable 3 register, offset: 0x2 */
  __IO uint8_t PE4;                                /**< LLWU Pin Enable 4 register, offset: 0x3 */
  __IO uint8_t ME;                                 /**< LLWU Module Enable register, offset: 0x4 */
  __IO uint8_t F1;                                 /**< LLWU Flag 1 register, offset: 0x5 */
  __IO uint8_t F2;                                 /**< LLWU Flag 2 register, offset: 0x6 */
  __I  uint8_t F3;                                 /**< LLWU Flag 3 register, offset: 0x7 */
  __IO uint8_t FILT1;                              /**< LLWU Pin Filter 1 register, offset: 0x8 */
  __IO uint8_t FILT2;                              /**< LLWU Pin Filter 2 register, offset: 0x9 */
} LLWU_Type;

/* ----------------------------------------------------------------------------
   -- LLWU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Masks LLWU Register Masks
 * @{
 */

/*! @name PE1 - LLWU Pin Enable 1 register */
/*! @{ */
#define LLWU_PE1_WUPE0_MASK                      (0x3U)
#define LLWU_PE1_WUPE0_SHIFT                     (0U)
/*! WUPE0 - Wakeup Pin Enable For LLWU_P0
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE1_WUPE0(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE0_SHIFT)) & LLWU_PE1_WUPE0_MASK)
#define LLWU_PE1_WUPE1_MASK                      (0xCU)
#define LLWU_PE1_WUPE1_SHIFT                     (2U)
/*! WUPE1 - Wakeup Pin Enable For LLWU_P1
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE1_WUPE1(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE1_SHIFT)) & LLWU_PE1_WUPE1_MASK)
#define LLWU_PE1_WUPE2_MASK                      (0x30U)
#define LLWU_PE1_WUPE2_SHIFT                     (4U)
/*! WUPE2 - Wakeup Pin Enable For LLWU_P2
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE1_WUPE2(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE2_SHIFT)) & LLWU_PE1_WUPE2_MASK)
#define LLWU_PE1_WUPE3_MASK                      (0xC0U)
#define LLWU_PE1_WUPE3_SHIFT                     (6U)
/*! WUPE3 - Wakeup Pin Enable For LLWU_P3
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE1_WUPE3(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE3_SHIFT)) & LLWU_PE1_WUPE3_MASK)
/*! @} */

/*! @name PE2 - LLWU Pin Enable 2 register */
/*! @{ */
#define LLWU_PE2_WUPE4_MASK                      (0x3U)
#define LLWU_PE2_WUPE4_SHIFT                     (0U)
/*! WUPE4 - Wakeup Pin Enable For LLWU_P4
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE2_WUPE4(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE4_SHIFT)) & LLWU_PE2_WUPE4_MASK)
#define LLWU_PE2_WUPE5_MASK                      (0xCU)
#define LLWU_PE2_WUPE5_SHIFT                     (2U)
/*! WUPE5 - Wakeup Pin Enable For LLWU_P5
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE2_WUPE5(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE5_SHIFT)) & LLWU_PE2_WUPE5_MASK)
#define LLWU_PE2_WUPE6_MASK                      (0x30U)
#define LLWU_PE2_WUPE6_SHIFT                     (4U)
/*! WUPE6 - Wakeup Pin Enable For LLWU_P6
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE2_WUPE6(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE6_SHIFT)) & LLWU_PE2_WUPE6_MASK)
#define LLWU_PE2_WUPE7_MASK                      (0xC0U)
#define LLWU_PE2_WUPE7_SHIFT                     (6U)
/*! WUPE7 - Wakeup Pin Enable For LLWU_P7
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE2_WUPE7(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE7_SHIFT)) & LLWU_PE2_WUPE7_MASK)
/*! @} */

/*! @name PE3 - LLWU Pin Enable 3 register */
/*! @{ */
#define LLWU_PE3_WUPE8_MASK                      (0x3U)
#define LLWU_PE3_WUPE8_SHIFT                     (0U)
/*! WUPE8 - Wakeup Pin Enable For LLWU_P8
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE3_WUPE8(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE8_SHIFT)) & LLWU_PE3_WUPE8_MASK)
#define LLWU_PE3_WUPE9_MASK                      (0xCU)
#define LLWU_PE3_WUPE9_SHIFT                     (2U)
/*! WUPE9 - Wakeup Pin Enable For LLWU_P9
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE3_WUPE9(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE9_SHIFT)) & LLWU_PE3_WUPE9_MASK)
#define LLWU_PE3_WUPE10_MASK                     (0x30U)
#define LLWU_PE3_WUPE10_SHIFT                    (4U)
/*! WUPE10 - Wakeup Pin Enable For LLWU_P10
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE3_WUPE10(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE10_SHIFT)) & LLWU_PE3_WUPE10_MASK)
#define LLWU_PE3_WUPE11_MASK                     (0xC0U)
#define LLWU_PE3_WUPE11_SHIFT                    (6U)
/*! WUPE11 - Wakeup Pin Enable For LLWU_P11
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE3_WUPE11(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE11_SHIFT)) & LLWU_PE3_WUPE11_MASK)
/*! @} */

/*! @name PE4 - LLWU Pin Enable 4 register */
/*! @{ */
#define LLWU_PE4_WUPE12_MASK                     (0x3U)
#define LLWU_PE4_WUPE12_SHIFT                    (0U)
/*! WUPE12 - Wakeup Pin Enable For LLWU_P12
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE4_WUPE12(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE12_SHIFT)) & LLWU_PE4_WUPE12_MASK)
#define LLWU_PE4_WUPE13_MASK                     (0xCU)
#define LLWU_PE4_WUPE13_SHIFT                    (2U)
/*! WUPE13 - Wakeup Pin Enable For LLWU_P13
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE4_WUPE13(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE13_SHIFT)) & LLWU_PE4_WUPE13_MASK)
#define LLWU_PE4_WUPE14_MASK                     (0x30U)
#define LLWU_PE4_WUPE14_SHIFT                    (4U)
/*! WUPE14 - Wakeup Pin Enable For LLWU_P14
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE4_WUPE14(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE14_SHIFT)) & LLWU_PE4_WUPE14_MASK)
#define LLWU_PE4_WUPE15_MASK                     (0xC0U)
#define LLWU_PE4_WUPE15_SHIFT                    (6U)
/*! WUPE15 - Wakeup Pin Enable For LLWU_P15
 *  0b00..External input pin disabled as wakeup input
 *  0b01..External input pin enabled with rising edge detection
 *  0b10..External input pin enabled with falling edge detection
 *  0b11..External input pin enabled with any change detection
 */
#define LLWU_PE4_WUPE15(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE15_SHIFT)) & LLWU_PE4_WUPE15_MASK)
/*! @} */

/*! @name ME - LLWU Module Enable register */
/*! @{ */
#define LLWU_ME_WUME0_MASK                       (0x1U)
#define LLWU_ME_WUME0_SHIFT                      (0U)
/*! WUME0 - Wakeup Module Enable For Module 0
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME0(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME0_SHIFT)) & LLWU_ME_WUME0_MASK)
#define LLWU_ME_WUME1_MASK                       (0x2U)
#define LLWU_ME_WUME1_SHIFT                      (1U)
/*! WUME1 - Wakeup Module Enable for Module 1
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME1(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME1_SHIFT)) & LLWU_ME_WUME1_MASK)
#define LLWU_ME_WUME2_MASK                       (0x4U)
#define LLWU_ME_WUME2_SHIFT                      (2U)
/*! WUME2 - Wakeup Module Enable For Module 2
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME2(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME2_SHIFT)) & LLWU_ME_WUME2_MASK)
#define LLWU_ME_WUME3_MASK                       (0x8U)
#define LLWU_ME_WUME3_SHIFT                      (3U)
/*! WUME3 - Wakeup Module Enable For Module 3
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME3(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME3_SHIFT)) & LLWU_ME_WUME3_MASK)
#define LLWU_ME_WUME4_MASK                       (0x10U)
#define LLWU_ME_WUME4_SHIFT                      (4U)
/*! WUME4 - Wakeup Module Enable For Module 4
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME4(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME4_SHIFT)) & LLWU_ME_WUME4_MASK)
#define LLWU_ME_WUME5_MASK                       (0x20U)
#define LLWU_ME_WUME5_SHIFT                      (5U)
/*! WUME5 - Wakeup Module Enable For Module 5
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME5(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME5_SHIFT)) & LLWU_ME_WUME5_MASK)
#define LLWU_ME_WUME6_MASK                       (0x40U)
#define LLWU_ME_WUME6_SHIFT                      (6U)
/*! WUME6 - Wakeup Module Enable For Module 6
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME6(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME6_SHIFT)) & LLWU_ME_WUME6_MASK)
#define LLWU_ME_WUME7_MASK                       (0x80U)
#define LLWU_ME_WUME7_SHIFT                      (7U)
/*! WUME7 - Wakeup Module Enable For Module 7
 *  0b0..Internal module flag not used as wakeup source
 *  0b1..Internal module flag used as wakeup source
 */
#define LLWU_ME_WUME7(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_ME_WUME7_SHIFT)) & LLWU_ME_WUME7_MASK)
/*! @} */

/*! @name F1 - LLWU Flag 1 register */
/*! @{ */
#define LLWU_F1_WUF0_MASK                        (0x1U)
#define LLWU_F1_WUF0_SHIFT                       (0U)
/*! WUF0 - Wakeup Flag For LLWU_P0
 *  0b0..LLWU_P0 input was not a wakeup source
 *  0b1..LLWU_P0 input was a wakeup source
 */
#define LLWU_F1_WUF0(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF0_SHIFT)) & LLWU_F1_WUF0_MASK)
#define LLWU_F1_WUF1_MASK                        (0x2U)
#define LLWU_F1_WUF1_SHIFT                       (1U)
/*! WUF1 - Wakeup Flag For LLWU_P1
 *  0b0..LLWU_P1 input was not a wakeup source
 *  0b1..LLWU_P1 input was a wakeup source
 */
#define LLWU_F1_WUF1(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF1_SHIFT)) & LLWU_F1_WUF1_MASK)
#define LLWU_F1_WUF2_MASK                        (0x4U)
#define LLWU_F1_WUF2_SHIFT                       (2U)
/*! WUF2 - Wakeup Flag For LLWU_P2
 *  0b0..LLWU_P2 input was not a wakeup source
 *  0b1..LLWU_P2 input was a wakeup source
 */
#define LLWU_F1_WUF2(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF2_SHIFT)) & LLWU_F1_WUF2_MASK)
#define LLWU_F1_WUF3_MASK                        (0x8U)
#define LLWU_F1_WUF3_SHIFT                       (3U)
/*! WUF3 - Wakeup Flag For LLWU_P3
 *  0b0..LLWU_P3 input was not a wake-up source
 *  0b1..LLWU_P3 input was a wake-up source
 */
#define LLWU_F1_WUF3(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF3_SHIFT)) & LLWU_F1_WUF3_MASK)
#define LLWU_F1_WUF4_MASK                        (0x10U)
#define LLWU_F1_WUF4_SHIFT                       (4U)
/*! WUF4 - Wakeup Flag For LLWU_P4
 *  0b0..LLWU_P4 input was not a wakeup source
 *  0b1..LLWU_P4 input was a wakeup source
 */
#define LLWU_F1_WUF4(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF4_SHIFT)) & LLWU_F1_WUF4_MASK)
#define LLWU_F1_WUF5_MASK                        (0x20U)
#define LLWU_F1_WUF5_SHIFT                       (5U)
/*! WUF5 - Wakeup Flag For LLWU_P5
 *  0b0..LLWU_P5 input was not a wakeup source
 *  0b1..LLWU_P5 input was a wakeup source
 */
#define LLWU_F1_WUF5(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF5_SHIFT)) & LLWU_F1_WUF5_MASK)
#define LLWU_F1_WUF6_MASK                        (0x40U)
#define LLWU_F1_WUF6_SHIFT                       (6U)
/*! WUF6 - Wakeup Flag For LLWU_P6
 *  0b0..LLWU_P6 input was not a wakeup source
 *  0b1..LLWU_P6 input was a wakeup source
 */
#define LLWU_F1_WUF6(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF6_SHIFT)) & LLWU_F1_WUF6_MASK)
#define LLWU_F1_WUF7_MASK                        (0x80U)
#define LLWU_F1_WUF7_SHIFT                       (7U)
/*! WUF7 - Wakeup Flag For LLWU_P7
 *  0b0..LLWU_P7 input was not a wakeup source
 *  0b1..LLWU_P7 input was a wakeup source
 */
#define LLWU_F1_WUF7(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F1_WUF7_SHIFT)) & LLWU_F1_WUF7_MASK)
/*! @} */

/*! @name F2 - LLWU Flag 2 register */
/*! @{ */
#define LLWU_F2_WUF8_MASK                        (0x1U)
#define LLWU_F2_WUF8_SHIFT                       (0U)
/*! WUF8 - Wakeup Flag For LLWU_P8
 *  0b0..LLWU_P8 input was not a wakeup source
 *  0b1..LLWU_P8 input was a wakeup source
 */
#define LLWU_F2_WUF8(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF8_SHIFT)) & LLWU_F2_WUF8_MASK)
#define LLWU_F2_WUF9_MASK                        (0x2U)
#define LLWU_F2_WUF9_SHIFT                       (1U)
/*! WUF9 - Wakeup Flag For LLWU_P9
 *  0b0..LLWU_P9 input was not a wakeup source
 *  0b1..LLWU_P9 input was a wakeup source
 */
#define LLWU_F2_WUF9(x)                          (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF9_SHIFT)) & LLWU_F2_WUF9_MASK)
#define LLWU_F2_WUF10_MASK                       (0x4U)
#define LLWU_F2_WUF10_SHIFT                      (2U)
/*! WUF10 - Wakeup Flag For LLWU_P10
 *  0b0..LLWU_P10 input was not a wakeup source
 *  0b1..LLWU_P10 input was a wakeup source
 */
#define LLWU_F2_WUF10(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF10_SHIFT)) & LLWU_F2_WUF10_MASK)
#define LLWU_F2_WUF11_MASK                       (0x8U)
#define LLWU_F2_WUF11_SHIFT                      (3U)
/*! WUF11 - Wakeup Flag For LLWU_P11
 *  0b0..LLWU_P11 input was not a wakeup source
 *  0b1..LLWU_P11 input was a wakeup source
 */
#define LLWU_F2_WUF11(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF11_SHIFT)) & LLWU_F2_WUF11_MASK)
#define LLWU_F2_WUF12_MASK                       (0x10U)
#define LLWU_F2_WUF12_SHIFT                      (4U)
/*! WUF12 - Wakeup Flag For LLWU_P12
 *  0b0..LLWU_P12 input was not a wakeup source
 *  0b1..LLWU_P12 input was a wakeup source
 */
#define LLWU_F2_WUF12(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF12_SHIFT)) & LLWU_F2_WUF12_MASK)
#define LLWU_F2_WUF13_MASK                       (0x20U)
#define LLWU_F2_WUF13_SHIFT                      (5U)
/*! WUF13 - Wakeup Flag For LLWU_P13
 *  0b0..LLWU_P13 input was not a wakeup source
 *  0b1..LLWU_P13 input was a wakeup source
 */
#define LLWU_F2_WUF13(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF13_SHIFT)) & LLWU_F2_WUF13_MASK)
#define LLWU_F2_WUF14_MASK                       (0x40U)
#define LLWU_F2_WUF14_SHIFT                      (6U)
/*! WUF14 - Wakeup Flag For LLWU_P14
 *  0b0..LLWU_P14 input was not a wakeup source
 *  0b1..LLWU_P14 input was a wakeup source
 */
#define LLWU_F2_WUF14(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF14_SHIFT)) & LLWU_F2_WUF14_MASK)
#define LLWU_F2_WUF15_MASK                       (0x80U)
#define LLWU_F2_WUF15_SHIFT                      (7U)
/*! WUF15 - Wakeup Flag For LLWU_P15
 *  0b0..LLWU_P15 input was not a wakeup source
 *  0b1..LLWU_P15 input was a wakeup source
 */
#define LLWU_F2_WUF15(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F2_WUF15_SHIFT)) & LLWU_F2_WUF15_MASK)
/*! @} */

/*! @name F3 - LLWU Flag 3 register */
/*! @{ */
#define LLWU_F3_MWUF0_MASK                       (0x1U)
#define LLWU_F3_MWUF0_SHIFT                      (0U)
/*! MWUF0 - Wakeup flag For module 0
 *  0b0..Module 0 input was not a wakeup source
 *  0b1..Module 0 input was a wakeup source
 */
#define LLWU_F3_MWUF0(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF0_SHIFT)) & LLWU_F3_MWUF0_MASK)
#define LLWU_F3_MWUF1_MASK                       (0x2U)
#define LLWU_F3_MWUF1_SHIFT                      (1U)
/*! MWUF1 - Wakeup flag For module 1
 *  0b0..Module 1 input was not a wakeup source
 *  0b1..Module 1 input was a wakeup source
 */
#define LLWU_F3_MWUF1(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF1_SHIFT)) & LLWU_F3_MWUF1_MASK)
#define LLWU_F3_MWUF2_MASK                       (0x4U)
#define LLWU_F3_MWUF2_SHIFT                      (2U)
/*! MWUF2 - Wakeup flag For module 2
 *  0b0..Module 2 input was not a wakeup source
 *  0b1..Module 2 input was a wakeup source
 */
#define LLWU_F3_MWUF2(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF2_SHIFT)) & LLWU_F3_MWUF2_MASK)
#define LLWU_F3_MWUF3_MASK                       (0x8U)
#define LLWU_F3_MWUF3_SHIFT                      (3U)
/*! MWUF3 - Wakeup flag For module 3
 *  0b0..Module 3 input was not a wakeup source
 *  0b1..Module 3 input was a wakeup source
 */
#define LLWU_F3_MWUF3(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF3_SHIFT)) & LLWU_F3_MWUF3_MASK)
#define LLWU_F3_MWUF4_MASK                       (0x10U)
#define LLWU_F3_MWUF4_SHIFT                      (4U)
/*! MWUF4 - Wakeup flag For module 4
 *  0b0..Module 4 input was not a wakeup source
 *  0b1..Module 4 input was a wakeup source
 */
#define LLWU_F3_MWUF4(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF4_SHIFT)) & LLWU_F3_MWUF4_MASK)
#define LLWU_F3_MWUF5_MASK                       (0x20U)
#define LLWU_F3_MWUF5_SHIFT                      (5U)
/*! MWUF5 - Wakeup flag For module 5
 *  0b0..Module 5 input was not a wakeup source
 *  0b1..Module 5 input was a wakeup source
 */
#define LLWU_F3_MWUF5(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF5_SHIFT)) & LLWU_F3_MWUF5_MASK)
#define LLWU_F3_MWUF6_MASK                       (0x40U)
#define LLWU_F3_MWUF6_SHIFT                      (6U)
/*! MWUF6 - Wakeup flag For module 6
 *  0b0..Module 6 input was not a wakeup source
 *  0b1..Module 6 input was a wakeup source
 */
#define LLWU_F3_MWUF6(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF6_SHIFT)) & LLWU_F3_MWUF6_MASK)
#define LLWU_F3_MWUF7_MASK                       (0x80U)
#define LLWU_F3_MWUF7_SHIFT                      (7U)
/*! MWUF7 - Wakeup flag For module 7
 *  0b0..Module 7 input was not a wakeup source
 *  0b1..Module 7 input was a wakeup source
 */
#define LLWU_F3_MWUF7(x)                         (((uint8_t)(((uint8_t)(x)) << LLWU_F3_MWUF7_SHIFT)) & LLWU_F3_MWUF7_MASK)
/*! @} */

/*! @name FILT1 - LLWU Pin Filter 1 register */
/*! @{ */
#define LLWU_FILT1_FILTSEL_MASK                  (0xFU)
#define LLWU_FILT1_FILTSEL_SHIFT                 (0U)
/*! FILTSEL - Filter Pin Select
 *  0b0000..Select LLWU_P0 for filter
 *  0b1111..Select LLWU_P15 for filter
 */
#define LLWU_FILT1_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << LLWU_FILT1_FILTSEL_SHIFT)) & LLWU_FILT1_FILTSEL_MASK)
#define LLWU_FILT1_FILTE_MASK                    (0x60U)
#define LLWU_FILT1_FILTE_SHIFT                   (5U)
/*! FILTE - Digital Filter On External Pin
 *  0b00..Filter disabled
 *  0b01..Filter posedge detect enabled
 *  0b10..Filter negedge detect enabled
 *  0b11..Filter any edge detect enabled
 */
#define LLWU_FILT1_FILTE(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT1_FILTE_SHIFT)) & LLWU_FILT1_FILTE_MASK)
#define LLWU_FILT1_FILTF_MASK                    (0x80U)
#define LLWU_FILT1_FILTF_SHIFT                   (7U)
/*! FILTF - Filter Detect Flag
 *  0b0..Pin Filter 1 was not a wakeup source
 *  0b1..Pin Filter 1 was a wakeup source
 */
#define LLWU_FILT1_FILTF(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT1_FILTF_SHIFT)) & LLWU_FILT1_FILTF_MASK)
/*! @} */

/*! @name FILT2 - LLWU Pin Filter 2 register */
/*! @{ */
#define LLWU_FILT2_FILTSEL_MASK                  (0xFU)
#define LLWU_FILT2_FILTSEL_SHIFT                 (0U)
/*! FILTSEL - Filter Pin Select
 *  0b0000..Select LLWU_P0 for filter
 *  0b1111..Select LLWU_P15 for filter
 */
#define LLWU_FILT2_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << LLWU_FILT2_FILTSEL_SHIFT)) & LLWU_FILT2_FILTSEL_MASK)
#define LLWU_FILT2_FILTE_MASK                    (0x60U)
#define LLWU_FILT2_FILTE_SHIFT                   (5U)
/*! FILTE - Digital Filter On External Pin
 *  0b00..Filter disabled
 *  0b01..Filter posedge detect enabled
 *  0b10..Filter negedge detect enabled
 *  0b11..Filter any edge detect enabled
 */
#define LLWU_FILT2_FILTE(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT2_FILTE_SHIFT)) & LLWU_FILT2_FILTE_MASK)
#define LLWU_FILT2_FILTF_MASK                    (0x80U)
#define LLWU_FILT2_FILTF_SHIFT                   (7U)
/*! FILTF - Filter Detect Flag
 *  0b0..Pin Filter 2 was not a wakeup source
 *  0b1..Pin Filter 2 was a wakeup source
 */
#define LLWU_FILT2_FILTF(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT2_FILTF_SHIFT)) & LLWU_FILT2_FILTF_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group LLWU_Register_Masks */


/* LLWU - Peripheral instance base addresses */
/** Peripheral LLWU base address */
#define LLWU_BASE                                (0x4007C000u)
/** Peripheral LLWU base pointer */
#define LLWU                                     ((LLWU_Type *)LLWU_BASE)
/** Array initializer of LLWU peripheral base addresses */
#define LLWU_BASE_ADDRS                          { LLWU_BASE }
/** Array initializer of LLWU peripheral base pointers */
#define LLWU_BASE_PTRS                           { LLWU }
/** Interrupt vectors for the LLWU peripheral type */
#define LLWU_IRQS                                { LLWU_IRQn }

/*!
 * @}
 */ /* end of group LLWU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LPTMR Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Peripheral_Access_Layer LPTMR Peripheral Access Layer
 * @{
 */

/** LPTMR - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSR;                               /**< Low Power Timer Control Status Register, offset: 0x0 */
  __IO uint32_t PSR;                               /**< Low Power Timer Prescale Register, offset: 0x4 */
  __IO uint32_t CMR;                               /**< Low Power Timer Compare Register, offset: 0x8 */
  __IO uint32_t CNR;                               /**< Low Power Timer Counter Register, offset: 0xC */
} LPTMR_Type;

/* ----------------------------------------------------------------------------
   -- LPTMR Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Masks LPTMR Register Masks
 * @{
 */

/*! @name CSR - Low Power Timer Control Status Register */
/*! @{ */
#define LPTMR_CSR_TEN_MASK                       (0x1U)
#define LPTMR_CSR_TEN_SHIFT                      (0U)
/*! TEN - Timer Enable
 *  0b0..LPTMR is disabled and internal logic is reset.
 *  0b1..LPTMR is enabled.
 */
#define LPTMR_CSR_TEN(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TEN_SHIFT)) & LPTMR_CSR_TEN_MASK)
#define LPTMR_CSR_TMS_MASK                       (0x2U)
#define LPTMR_CSR_TMS_SHIFT                      (1U)
/*! TMS - Timer Mode Select
 *  0b0..Time Counter mode.
 *  0b1..Pulse Counter mode.
 */
#define LPTMR_CSR_TMS(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TMS_SHIFT)) & LPTMR_CSR_TMS_MASK)
#define LPTMR_CSR_TFC_MASK                       (0x4U)
#define LPTMR_CSR_TFC_SHIFT                      (2U)
/*! TFC - Timer Free-Running Counter
 *  0b0..CNR is reset whenever TCF is set.
 *  0b1..CNR is reset on overflow.
 */
#define LPTMR_CSR_TFC(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TFC_SHIFT)) & LPTMR_CSR_TFC_MASK)
#define LPTMR_CSR_TPP_MASK                       (0x8U)
#define LPTMR_CSR_TPP_SHIFT                      (3U)
/*! TPP - Timer Pin Polarity
 *  0b0..Pulse Counter input source is active-high, and the CNR will increment on the rising-edge.
 *  0b1..Pulse Counter input source is active-low, and the CNR will increment on the falling-edge.
 */
#define LPTMR_CSR_TPP(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TPP_SHIFT)) & LPTMR_CSR_TPP_MASK)
#define LPTMR_CSR_TPS_MASK                       (0x30U)
#define LPTMR_CSR_TPS_SHIFT                      (4U)
/*! TPS - Timer Pin Select
 *  0b00..Pulse counter input 0 is selected.
 *  0b01..Pulse counter input 1 is selected.
 *  0b10..Pulse counter input 2 is selected.
 *  0b11..Pulse counter input 3 is selected.
 */
#define LPTMR_CSR_TPS(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TPS_SHIFT)) & LPTMR_CSR_TPS_MASK)
#define LPTMR_CSR_TIE_MASK                       (0x40U)
#define LPTMR_CSR_TIE_SHIFT                      (6U)
/*! TIE - Timer Interrupt Enable
 *  0b0..Timer interrupt disabled.
 *  0b1..Timer interrupt enabled.
 */
#define LPTMR_CSR_TIE(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TIE_SHIFT)) & LPTMR_CSR_TIE_MASK)
#define LPTMR_CSR_TCF_MASK                       (0x80U)
#define LPTMR_CSR_TCF_SHIFT                      (7U)
/*! TCF - Timer Compare Flag
 *  0b0..The value of CNR is not equal to CMR and increments.
 *  0b1..The value of CNR is equal to CMR and increments.
 */
#define LPTMR_CSR_TCF(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TCF_SHIFT)) & LPTMR_CSR_TCF_MASK)
/*! @} */

/*! @name PSR - Low Power Timer Prescale Register */
/*! @{ */
#define LPTMR_PSR_PCS_MASK                       (0x3U)
#define LPTMR_PSR_PCS_SHIFT                      (0U)
/*! PCS - Prescaler Clock Select
 *  0b00..Prescaler/glitch filter clock 0 selected.
 *  0b01..Prescaler/glitch filter clock 1 selected.
 *  0b10..Prescaler/glitch filter clock 2 selected.
 *  0b11..Prescaler/glitch filter clock 3 selected.
 */
#define LPTMR_PSR_PCS(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_PSR_PCS_SHIFT)) & LPTMR_PSR_PCS_MASK)
#define LPTMR_PSR_PBYP_MASK                      (0x4U)
#define LPTMR_PSR_PBYP_SHIFT                     (2U)
/*! PBYP - Prescaler Bypass
 *  0b0..Prescaler/glitch filter is enabled.
 *  0b1..Prescaler/glitch filter is bypassed.
 */
#define LPTMR_PSR_PBYP(x)                        (((uint32_t)(((uint32_t)(x)) << LPTMR_PSR_PBYP_SHIFT)) & LPTMR_PSR_PBYP_MASK)
#define LPTMR_PSR_PRESCALE_MASK                  (0x78U)
#define LPTMR_PSR_PRESCALE_SHIFT                 (3U)
/*! PRESCALE - Prescale Value
 *  0b0000..Prescaler divides the prescaler clock by 2; glitch filter does not support this configuration.
 *  0b0001..Prescaler divides the prescaler clock by 4; glitch filter recognizes change on input pin after 2 rising clock edges.
 *  0b0010..Prescaler divides the prescaler clock by 8; glitch filter recognizes change on input pin after 4 rising clock edges.
 *  0b0011..Prescaler divides the prescaler clock by 16; glitch filter recognizes change on input pin after 8 rising clock edges.
 *  0b0100..Prescaler divides the prescaler clock by 32; glitch filter recognizes change on input pin after 16 rising clock edges.
 *  0b0101..Prescaler divides the prescaler clock by 64; glitch filter recognizes change on input pin after 32 rising clock edges.
 *  0b0110..Prescaler divides the prescaler clock by 128; glitch filter recognizes change on input pin after 64 rising clock edges.
 *  0b0111..Prescaler divides the prescaler clock by 256; glitch filter recognizes change on input pin after 128 rising clock edges.
 *  0b1000..Prescaler divides the prescaler clock by 512; glitch filter recognizes change on input pin after 256 rising clock edges.
 *  0b1001..Prescaler divides the prescaler clock by 1024; glitch filter recognizes change on input pin after 512 rising clock edges.
 *  0b1010..Prescaler divides the prescaler clock by 2048; glitch filter recognizes change on input pin after 1024 rising clock edges.
 *  0b1011..Prescaler divides the prescaler clock by 4096; glitch filter recognizes change on input pin after 2048 rising clock edges.
 *  0b1100..Prescaler divides the prescaler clock by 8192; glitch filter recognizes change on input pin after 4096 rising clock edges.
 *  0b1101..Prescaler divides the prescaler clock by 16,384; glitch filter recognizes change on input pin after 8192 rising clock edges.
 *  0b1110..Prescaler divides the prescaler clock by 32,768; glitch filter recognizes change on input pin after 16,384 rising clock edges.
 *  0b1111..Prescaler divides the prescaler clock by 65,536; glitch filter recognizes change on input pin after 32,768 rising clock edges.
 */
#define LPTMR_PSR_PRESCALE(x)                    (((uint32_t)(((uint32_t)(x)) << LPTMR_PSR_PRESCALE_SHIFT)) & LPTMR_PSR_PRESCALE_MASK)
/*! @} */

/*! @name CMR - Low Power Timer Compare Register */
/*! @{ */
#define LPTMR_CMR_COMPARE_MASK                   (0xFFFFU)
#define LPTMR_CMR_COMPARE_SHIFT                  (0U)
/*! COMPARE - Compare Value
 */
#define LPTMR_CMR_COMPARE(x)                     (((uint32_t)(((uint32_t)(x)) << LPTMR_CMR_COMPARE_SHIFT)) & LPTMR_CMR_COMPARE_MASK)
/*! @} */

/*! @name CNR - Low Power Timer Counter Register */
/*! @{ */
#define LPTMR_CNR_COUNTER_MASK                   (0xFFFFU)
#define LPTMR_CNR_COUNTER_SHIFT                  (0U)
/*! COUNTER - Counter Value
 */
#define LPTMR_CNR_COUNTER(x)                     (((uint32_t)(((uint32_t)(x)) << LPTMR_CNR_COUNTER_SHIFT)) & LPTMR_CNR_COUNTER_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group LPTMR_Register_Masks */


/* LPTMR - Peripheral instance base addresses */
/** Peripheral LPTMR0 base address */
#define LPTMR0_BASE                              (0x40040000u)
/** Peripheral LPTMR0 base pointer */
#define LPTMR0                                   ((LPTMR_Type *)LPTMR0_BASE)
/** Array initializer of LPTMR peripheral base addresses */
#define LPTMR_BASE_ADDRS                         { LPTMR0_BASE }
/** Array initializer of LPTMR peripheral base pointers */
#define LPTMR_BASE_PTRS                          { LPTMR0 }
/** Interrupt vectors for the LPTMR peripheral type */
#define LPTMR_IRQS                               { LPTMR0_IRQn }

/*!
 * @}
 */ /* end of group LPTMR_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LPUART Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Peripheral_Access_Layer LPUART Peripheral Access Layer
 * @{
 */

/** LPUART - Register Layout Typedef */
typedef struct {
  __IO uint32_t BAUD;                              /**< LPUART Baud Rate Register, offset: 0x0 */
  __IO uint32_t STAT;                              /**< LPUART Status Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< LPUART Control Register, offset: 0x8 */
  __IO uint32_t DATA;                              /**< LPUART Data Register, offset: 0xC */
  __IO uint32_t MATCH;                             /**< LPUART Match Address Register, offset: 0x10 */
  __IO uint32_t MODIR;                             /**< LPUART Modem IrDA Register, offset: 0x14 */
  __IO uint32_t FIFO;                              /**< LPUART FIFO Register, offset: 0x18 */
  __IO uint32_t WATER;                             /**< LPUART Watermark Register, offset: 0x1C */
} LPUART_Type;

/* ----------------------------------------------------------------------------
   -- LPUART Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Masks LPUART Register Masks
 * @{
 */

/*! @name BAUD - LPUART Baud Rate Register */
/*! @{ */
#define LPUART_BAUD_SBR_MASK                     (0x1FFFU)
#define LPUART_BAUD_SBR_SHIFT                    (0U)
/*! SBR - Baud Rate Modulo Divisor.
 */
#define LPUART_BAUD_SBR(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_SBR_SHIFT)) & LPUART_BAUD_SBR_MASK)
#define LPUART_BAUD_SBNS_MASK                    (0x2000U)
#define LPUART_BAUD_SBNS_SHIFT                   (13U)
/*! SBNS - Stop Bit Number Select
 *  0b0..One stop bit.
 *  0b1..Two stop bits.
 */
#define LPUART_BAUD_SBNS(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_SBNS_SHIFT)) & LPUART_BAUD_SBNS_MASK)
#define LPUART_BAUD_RXEDGIE_MASK                 (0x4000U)
#define LPUART_BAUD_RXEDGIE_SHIFT                (14U)
/*! RXEDGIE - RX Input Active Edge Interrupt Enable
 *  0b0..Hardware interrupts from LPUART_STAT[RXEDGIF] disabled (use polling).
 *  0b1..Hardware interrupt requested when LPUART_STAT[RXEDGIF] flag is 1.
 */
#define LPUART_BAUD_RXEDGIE(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_RXEDGIE_SHIFT)) & LPUART_BAUD_RXEDGIE_MASK)
#define LPUART_BAUD_LBKDIE_MASK                  (0x8000U)
#define LPUART_BAUD_LBKDIE_SHIFT                 (15U)
/*! LBKDIE - LIN Break Detect Interrupt Enable
 *  0b0..Hardware interrupts from LPUART_STAT[LBKDIF] disabled (use polling).
 *  0b1..Hardware interrupt requested when LPUART_STAT[LBKDIF] flag is 1.
 */
#define LPUART_BAUD_LBKDIE(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_LBKDIE_SHIFT)) & LPUART_BAUD_LBKDIE_MASK)
#define LPUART_BAUD_RESYNCDIS_MASK               (0x10000U)
#define LPUART_BAUD_RESYNCDIS_SHIFT              (16U)
/*! RESYNCDIS - Resynchronization Disable
 *  0b0..Resynchronization during received data word is supported
 *  0b1..Resynchronization during received data word is disabled
 */
#define LPUART_BAUD_RESYNCDIS(x)                 (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_RESYNCDIS_SHIFT)) & LPUART_BAUD_RESYNCDIS_MASK)
#define LPUART_BAUD_BOTHEDGE_MASK                (0x20000U)
#define LPUART_BAUD_BOTHEDGE_SHIFT               (17U)
/*! BOTHEDGE - Both Edge Sampling
 *  0b0..Receiver samples input data using the rising edge of the baud rate clock.
 *  0b1..Receiver samples input data using the rising and falling edge of the baud rate clock.
 */
#define LPUART_BAUD_BOTHEDGE(x)                  (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_BOTHEDGE_SHIFT)) & LPUART_BAUD_BOTHEDGE_MASK)
#define LPUART_BAUD_MATCFG_MASK                  (0xC0000U)
#define LPUART_BAUD_MATCFG_SHIFT                 (18U)
/*! MATCFG - Match Configuration
 *  0b00..Address Match Wakeup
 *  0b01..Idle Match Wakeup
 *  0b10..Match On and Match Off
 *  0b11..Enables RWU on Data Match and Match On/Off for transmitter CTS input
 */
#define LPUART_BAUD_MATCFG(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_MATCFG_SHIFT)) & LPUART_BAUD_MATCFG_MASK)
#define LPUART_BAUD_RDMAE_MASK                   (0x200000U)
#define LPUART_BAUD_RDMAE_SHIFT                  (21U)
/*! RDMAE - Receiver Full DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define LPUART_BAUD_RDMAE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_RDMAE_SHIFT)) & LPUART_BAUD_RDMAE_MASK)
#define LPUART_BAUD_TDMAE_MASK                   (0x800000U)
#define LPUART_BAUD_TDMAE_SHIFT                  (23U)
/*! TDMAE - Transmitter DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define LPUART_BAUD_TDMAE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_TDMAE_SHIFT)) & LPUART_BAUD_TDMAE_MASK)
#define LPUART_BAUD_OSR_MASK                     (0x1F000000U)
#define LPUART_BAUD_OSR_SHIFT                    (24U)
/*! OSR - Oversampling Ratio
 */
#define LPUART_BAUD_OSR(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_OSR_SHIFT)) & LPUART_BAUD_OSR_MASK)
#define LPUART_BAUD_M10_MASK                     (0x20000000U)
#define LPUART_BAUD_M10_SHIFT                    (29U)
/*! M10 - 10-bit Mode select
 *  0b0..Receiver and transmitter use 8-bit or 9-bit data characters.
 *  0b1..Receiver and transmitter use 10-bit data characters.
 */
#define LPUART_BAUD_M10(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_M10_SHIFT)) & LPUART_BAUD_M10_MASK)
#define LPUART_BAUD_MAEN2_MASK                   (0x40000000U)
#define LPUART_BAUD_MAEN2_SHIFT                  (30U)
/*! MAEN2 - Match Address Mode Enable 2
 *  0b0..Normal operation.
 *  0b1..Enables automatic address matching or data matching mode for MATCH[MA2].
 */
#define LPUART_BAUD_MAEN2(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_MAEN2_SHIFT)) & LPUART_BAUD_MAEN2_MASK)
#define LPUART_BAUD_MAEN1_MASK                   (0x80000000U)
#define LPUART_BAUD_MAEN1_SHIFT                  (31U)
/*! MAEN1 - Match Address Mode Enable 1
 *  0b0..Normal operation.
 *  0b1..Enables automatic address matching or data matching mode for MATCH[MA1].
 */
#define LPUART_BAUD_MAEN1(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_MAEN1_SHIFT)) & LPUART_BAUD_MAEN1_MASK)
/*! @} */

/*! @name STAT - LPUART Status Register */
/*! @{ */
#define LPUART_STAT_MA2F_MASK                    (0x4000U)
#define LPUART_STAT_MA2F_SHIFT                   (14U)
/*! MA2F - Match 2 Flag
 *  0b0..Received data is not equal to MA2
 *  0b1..Received data is equal to MA2
 */
#define LPUART_STAT_MA2F(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_MA2F_SHIFT)) & LPUART_STAT_MA2F_MASK)
#define LPUART_STAT_MA1F_MASK                    (0x8000U)
#define LPUART_STAT_MA1F_SHIFT                   (15U)
/*! MA1F - Match 1 Flag
 *  0b0..Received data is not equal to MA1
 *  0b1..Received data is equal to MA1
 */
#define LPUART_STAT_MA1F(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_MA1F_SHIFT)) & LPUART_STAT_MA1F_MASK)
#define LPUART_STAT_PF_MASK                      (0x10000U)
#define LPUART_STAT_PF_SHIFT                     (16U)
/*! PF - Parity Error Flag
 *  0b0..No parity error.
 *  0b1..Parity error.
 */
#define LPUART_STAT_PF(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_PF_SHIFT)) & LPUART_STAT_PF_MASK)
#define LPUART_STAT_FE_MASK                      (0x20000U)
#define LPUART_STAT_FE_SHIFT                     (17U)
/*! FE - Framing Error Flag
 *  0b0..No framing error detected. This does not guarantee the framing is correct.
 *  0b1..Framing error.
 */
#define LPUART_STAT_FE(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_FE_SHIFT)) & LPUART_STAT_FE_MASK)
#define LPUART_STAT_NF_MASK                      (0x40000U)
#define LPUART_STAT_NF_SHIFT                     (18U)
/*! NF - Noise Flag
 *  0b0..No noise detected.
 *  0b1..Noise detected in the received character in LPUART_DATA.
 */
#define LPUART_STAT_NF(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_NF_SHIFT)) & LPUART_STAT_NF_MASK)
#define LPUART_STAT_OR_MASK                      (0x80000U)
#define LPUART_STAT_OR_SHIFT                     (19U)
/*! OR - Receiver Overrun Flag
 *  0b0..No overrun.
 *  0b1..Receive overrun (new LPUART data lost).
 */
#define LPUART_STAT_OR(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_OR_SHIFT)) & LPUART_STAT_OR_MASK)
#define LPUART_STAT_IDLE_MASK                    (0x100000U)
#define LPUART_STAT_IDLE_SHIFT                   (20U)
/*! IDLE - Idle Line Flag
 *  0b0..No idle line detected.
 *  0b1..Idle line was detected.
 */
#define LPUART_STAT_IDLE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_IDLE_SHIFT)) & LPUART_STAT_IDLE_MASK)
#define LPUART_STAT_RDRF_MASK                    (0x200000U)
#define LPUART_STAT_RDRF_SHIFT                   (21U)
/*! RDRF - Receive Data Register Full Flag
 *  0b0..Receive data buffer empty.
 *  0b1..Receive data buffer full.
 */
#define LPUART_STAT_RDRF(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_RDRF_SHIFT)) & LPUART_STAT_RDRF_MASK)
#define LPUART_STAT_TC_MASK                      (0x400000U)
#define LPUART_STAT_TC_SHIFT                     (22U)
/*! TC - Transmission Complete Flag
 *  0b0..Transmitter active (sending data, a preamble, or a break).
 *  0b1..Transmitter idle (transmission activity complete).
 */
#define LPUART_STAT_TC(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_TC_SHIFT)) & LPUART_STAT_TC_MASK)
#define LPUART_STAT_TDRE_MASK                    (0x800000U)
#define LPUART_STAT_TDRE_SHIFT                   (23U)
/*! TDRE - Transmit Data Register Empty Flag
 *  0b0..Transmit data buffer full.
 *  0b1..Transmit data buffer empty.
 */
#define LPUART_STAT_TDRE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_TDRE_SHIFT)) & LPUART_STAT_TDRE_MASK)
#define LPUART_STAT_RAF_MASK                     (0x1000000U)
#define LPUART_STAT_RAF_SHIFT                    (24U)
/*! RAF - Receiver Active Flag
 *  0b0..LPUART receiver idle waiting for a start bit.
 *  0b1..LPUART receiver active (LPUART_RX input not idle).
 */
#define LPUART_STAT_RAF(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_RAF_SHIFT)) & LPUART_STAT_RAF_MASK)
#define LPUART_STAT_LBKDE_MASK                   (0x2000000U)
#define LPUART_STAT_LBKDE_SHIFT                  (25U)
/*! LBKDE - LIN Break Detection Enable
 *  0b0..Break character is detected at length 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M =
 *       0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 *  0b1..Break character is detected at length of 11 bit times (if M = 0, SBNS = 0) or 12 (if M = 1, SBNS = 0 or M
 *       = 0, SBNS = 1) or 14 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 15 (if M10 = 1, SNBS = 1).
 */
#define LPUART_STAT_LBKDE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_LBKDE_SHIFT)) & LPUART_STAT_LBKDE_MASK)
#define LPUART_STAT_BRK13_MASK                   (0x4000000U)
#define LPUART_STAT_BRK13_SHIFT                  (26U)
/*! BRK13 - Break Character Generation Length
 *  0b0..Break character is transmitted with length of 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0
 *       or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 *  0b1..Break character is transmitted with length of 13 bit times (if M = 0, SBNS = 0) or 14 (if M = 1, SBNS = 0
 *       or M = 0, SBNS = 1) or 15 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 16 (if M10 = 1, SNBS = 1).
 */
#define LPUART_STAT_BRK13(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_BRK13_SHIFT)) & LPUART_STAT_BRK13_MASK)
#define LPUART_STAT_RWUID_MASK                   (0x8000000U)
#define LPUART_STAT_RWUID_SHIFT                  (27U)
/*! RWUID - Receive Wake Up Idle Detect
 *  0b0..During receive standby state (RWU = 1), the IDLE bit does not get set upon detection of an idle
 *       character. During address match wakeup, the IDLE bit does not get set when an address does not match.
 *  0b1..During receive standby state (RWU = 1), the IDLE bit gets set upon detection of an idle character. During
 *       address match wakeup, the IDLE bit does get set when an address does not match.
 */
#define LPUART_STAT_RWUID(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_RWUID_SHIFT)) & LPUART_STAT_RWUID_MASK)
#define LPUART_STAT_RXINV_MASK                   (0x10000000U)
#define LPUART_STAT_RXINV_SHIFT                  (28U)
/*! RXINV - Receive Data Inversion
 *  0b0..Receive data not inverted.
 *  0b1..Receive data inverted.
 */
#define LPUART_STAT_RXINV(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_RXINV_SHIFT)) & LPUART_STAT_RXINV_MASK)
#define LPUART_STAT_MSBF_MASK                    (0x20000000U)
#define LPUART_STAT_MSBF_SHIFT                   (29U)
/*! MSBF - MSB First
 *  0b0..LSB (bit0) is the first bit that is transmitted following the start bit. Further, the first bit received
 *       after the start bit is identified as bit0.
 *  0b1..MSB (bit9, bit8, bit7 or bit6) is the first bit that is transmitted following the start bit depending on
 *       the setting of CTRL[M], CTRL[PE] and BAUD[M10]. Further, the first bit received after the start bit is
 *       identified as bit9, bit8, bit7 or bit6 depending on the setting of CTRL[M] and CTRL[PE].
 */
#define LPUART_STAT_MSBF(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_MSBF_SHIFT)) & LPUART_STAT_MSBF_MASK)
#define LPUART_STAT_RXEDGIF_MASK                 (0x40000000U)
#define LPUART_STAT_RXEDGIF_SHIFT                (30U)
/*! RXEDGIF - LPUART_RX Pin Active Edge Interrupt Flag
 *  0b0..No active edge on the receive pin has occurred.
 *  0b1..An active edge on the receive pin has occurred.
 */
#define LPUART_STAT_RXEDGIF(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_RXEDGIF_SHIFT)) & LPUART_STAT_RXEDGIF_MASK)
#define LPUART_STAT_LBKDIF_MASK                  (0x80000000U)
#define LPUART_STAT_LBKDIF_SHIFT                 (31U)
/*! LBKDIF - LIN Break Detect Interrupt Flag
 *  0b0..No LIN break character has been detected.
 *  0b1..LIN break character has been detected.
 */
#define LPUART_STAT_LBKDIF(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_STAT_LBKDIF_SHIFT)) & LPUART_STAT_LBKDIF_MASK)
/*! @} */

/*! @name CTRL - LPUART Control Register */
/*! @{ */
#define LPUART_CTRL_PT_MASK                      (0x1U)
#define LPUART_CTRL_PT_SHIFT                     (0U)
/*! PT - Parity Type
 *  0b0..Even parity.
 *  0b1..Odd parity.
 */
#define LPUART_CTRL_PT(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_PT_SHIFT)) & LPUART_CTRL_PT_MASK)
#define LPUART_CTRL_PE_MASK                      (0x2U)
#define LPUART_CTRL_PE_SHIFT                     (1U)
/*! PE - Parity Enable
 *  0b0..No hardware parity generation or checking.
 *  0b1..Parity enabled.
 */
#define LPUART_CTRL_PE(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_PE_SHIFT)) & LPUART_CTRL_PE_MASK)
#define LPUART_CTRL_ILT_MASK                     (0x4U)
#define LPUART_CTRL_ILT_SHIFT                    (2U)
/*! ILT - Idle Line Type Select
 *  0b0..Idle character bit count starts after start bit.
 *  0b1..Idle character bit count starts after stop bit.
 */
#define LPUART_CTRL_ILT(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_ILT_SHIFT)) & LPUART_CTRL_ILT_MASK)
#define LPUART_CTRL_WAKE_MASK                    (0x8U)
#define LPUART_CTRL_WAKE_SHIFT                   (3U)
/*! WAKE - Receiver Wakeup Method Select
 *  0b0..Configures RWU for idle-line wakeup.
 *  0b1..Configures RWU with address-mark wakeup.
 */
#define LPUART_CTRL_WAKE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_WAKE_SHIFT)) & LPUART_CTRL_WAKE_MASK)
#define LPUART_CTRL_M_MASK                       (0x10U)
#define LPUART_CTRL_M_SHIFT                      (4U)
/*! M - 9-Bit or 8-Bit Mode Select
 *  0b0..Receiver and transmitter use 8-bit data characters.
 *  0b1..Receiver and transmitter use 9-bit data characters.
 */
#define LPUART_CTRL_M(x)                         (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_M_SHIFT)) & LPUART_CTRL_M_MASK)
#define LPUART_CTRL_RSRC_MASK                    (0x20U)
#define LPUART_CTRL_RSRC_SHIFT                   (5U)
/*! RSRC - Receiver Source Select
 *  0b0..Provided LOOPS is set, RSRC is cleared, selects internal loop back mode and the LPUART does not use the LPUART_RX pin.
 *  0b1..Single-wire LPUART mode where the LPUART_TX pin is connected to the transmitter output and receiver input.
 */
#define LPUART_CTRL_RSRC(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_RSRC_SHIFT)) & LPUART_CTRL_RSRC_MASK)
#define LPUART_CTRL_DOZEEN_MASK                  (0x40U)
#define LPUART_CTRL_DOZEEN_SHIFT                 (6U)
/*! DOZEEN - Doze Enable
 *  0b0..LPUART is enabled in Doze mode.
 *  0b1..LPUART is disabled in Doze mode.
 */
#define LPUART_CTRL_DOZEEN(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_DOZEEN_SHIFT)) & LPUART_CTRL_DOZEEN_MASK)
#define LPUART_CTRL_LOOPS_MASK                   (0x80U)
#define LPUART_CTRL_LOOPS_SHIFT                  (7U)
/*! LOOPS - Loop Mode Select
 *  0b0..Normal operation - LPUART_RX and LPUART_TX use separate pins.
 *  0b1..Loop mode or single-wire mode where transmitter outputs are internally connected to receiver input (see RSRC bit).
 */
#define LPUART_CTRL_LOOPS(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_LOOPS_SHIFT)) & LPUART_CTRL_LOOPS_MASK)
#define LPUART_CTRL_IDLECFG_MASK                 (0x700U)
#define LPUART_CTRL_IDLECFG_SHIFT                (8U)
/*! IDLECFG - Idle Configuration
 *  0b000..1 idle character
 *  0b001..2 idle characters
 *  0b010..4 idle characters
 *  0b011..8 idle characters
 *  0b100..16 idle characters
 *  0b101..32 idle characters
 *  0b110..64 idle characters
 *  0b111..128 idle characters
 */
#define LPUART_CTRL_IDLECFG(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_IDLECFG_SHIFT)) & LPUART_CTRL_IDLECFG_MASK)
#define LPUART_CTRL_MA2IE_MASK                   (0x4000U)
#define LPUART_CTRL_MA2IE_SHIFT                  (14U)
/*! MA2IE - Match 2 Interrupt Enable
 *  0b0..MA2F interrupt disabled
 *  0b1..MA2F interrupt enabled
 */
#define LPUART_CTRL_MA2IE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_MA2IE_SHIFT)) & LPUART_CTRL_MA2IE_MASK)
#define LPUART_CTRL_MA1IE_MASK                   (0x8000U)
#define LPUART_CTRL_MA1IE_SHIFT                  (15U)
/*! MA1IE - Match 1 Interrupt Enable
 *  0b0..MA1F interrupt disabled
 *  0b1..MA1F interrupt enabled
 */
#define LPUART_CTRL_MA1IE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_MA1IE_SHIFT)) & LPUART_CTRL_MA1IE_MASK)
#define LPUART_CTRL_SBK_MASK                     (0x10000U)
#define LPUART_CTRL_SBK_SHIFT                    (16U)
/*! SBK - Send Break
 *  0b0..Normal transmitter operation.
 *  0b1..Queue break character(s) to be sent.
 */
#define LPUART_CTRL_SBK(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_SBK_SHIFT)) & LPUART_CTRL_SBK_MASK)
#define LPUART_CTRL_RWU_MASK                     (0x20000U)
#define LPUART_CTRL_RWU_SHIFT                    (17U)
/*! RWU - Receiver Wakeup Control
 *  0b0..Normal receiver operation.
 *  0b1..LPUART receiver in standby waiting for wakeup condition.
 */
#define LPUART_CTRL_RWU(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_RWU_SHIFT)) & LPUART_CTRL_RWU_MASK)
#define LPUART_CTRL_RE_MASK                      (0x40000U)
#define LPUART_CTRL_RE_SHIFT                     (18U)
/*! RE - Receiver Enable
 *  0b0..Receiver disabled.
 *  0b1..Receiver enabled.
 */
#define LPUART_CTRL_RE(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_RE_SHIFT)) & LPUART_CTRL_RE_MASK)
#define LPUART_CTRL_TE_MASK                      (0x80000U)
#define LPUART_CTRL_TE_SHIFT                     (19U)
/*! TE - Transmitter Enable
 *  0b0..Transmitter disabled.
 *  0b1..Transmitter enabled.
 */
#define LPUART_CTRL_TE(x)                        (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_TE_SHIFT)) & LPUART_CTRL_TE_MASK)
#define LPUART_CTRL_ILIE_MASK                    (0x100000U)
#define LPUART_CTRL_ILIE_SHIFT                   (20U)
/*! ILIE - Idle Line Interrupt Enable
 *  0b0..Hardware interrupts from IDLE disabled; use polling.
 *  0b1..Hardware interrupt requested when IDLE flag is 1.
 */
#define LPUART_CTRL_ILIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_ILIE_SHIFT)) & LPUART_CTRL_ILIE_MASK)
#define LPUART_CTRL_RIE_MASK                     (0x200000U)
#define LPUART_CTRL_RIE_SHIFT                    (21U)
/*! RIE - Receiver Interrupt Enable
 *  0b0..Hardware interrupts from RDRF disabled; use polling.
 *  0b1..Hardware interrupt requested when RDRF flag is 1.
 */
#define LPUART_CTRL_RIE(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_RIE_SHIFT)) & LPUART_CTRL_RIE_MASK)
#define LPUART_CTRL_TCIE_MASK                    (0x400000U)
#define LPUART_CTRL_TCIE_SHIFT                   (22U)
/*! TCIE - Transmission Complete Interrupt Enable for
 *  0b0..Hardware interrupts from TC disabled; use polling.
 *  0b1..Hardware interrupt requested when TC flag is 1.
 */
#define LPUART_CTRL_TCIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_TCIE_SHIFT)) & LPUART_CTRL_TCIE_MASK)
#define LPUART_CTRL_TIE_MASK                     (0x800000U)
#define LPUART_CTRL_TIE_SHIFT                    (23U)
/*! TIE - Transmit Interrupt Enable
 *  0b0..Hardware interrupts from TDRE disabled; use polling.
 *  0b1..Hardware interrupt requested when TDRE flag is 1.
 */
#define LPUART_CTRL_TIE(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_TIE_SHIFT)) & LPUART_CTRL_TIE_MASK)
#define LPUART_CTRL_PEIE_MASK                    (0x1000000U)
#define LPUART_CTRL_PEIE_SHIFT                   (24U)
/*! PEIE - Parity Error Interrupt Enable
 *  0b0..PF interrupts disabled; use polling).
 *  0b1..Hardware interrupt requested when PF is set.
 */
#define LPUART_CTRL_PEIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_PEIE_SHIFT)) & LPUART_CTRL_PEIE_MASK)
#define LPUART_CTRL_FEIE_MASK                    (0x2000000U)
#define LPUART_CTRL_FEIE_SHIFT                   (25U)
/*! FEIE - Framing Error Interrupt Enable
 *  0b0..FE interrupts disabled; use polling.
 *  0b1..Hardware interrupt requested when FE is set.
 */
#define LPUART_CTRL_FEIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_FEIE_SHIFT)) & LPUART_CTRL_FEIE_MASK)
#define LPUART_CTRL_NEIE_MASK                    (0x4000000U)
#define LPUART_CTRL_NEIE_SHIFT                   (26U)
/*! NEIE - Noise Error Interrupt Enable
 *  0b0..NF interrupts disabled; use polling.
 *  0b1..Hardware interrupt requested when NF is set.
 */
#define LPUART_CTRL_NEIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_NEIE_SHIFT)) & LPUART_CTRL_NEIE_MASK)
#define LPUART_CTRL_ORIE_MASK                    (0x8000000U)
#define LPUART_CTRL_ORIE_SHIFT                   (27U)
/*! ORIE - Overrun Interrupt Enable
 *  0b0..OR interrupts disabled; use polling.
 *  0b1..Hardware interrupt requested when OR is set.
 */
#define LPUART_CTRL_ORIE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_ORIE_SHIFT)) & LPUART_CTRL_ORIE_MASK)
#define LPUART_CTRL_TXINV_MASK                   (0x10000000U)
#define LPUART_CTRL_TXINV_SHIFT                  (28U)
/*! TXINV - Transmit Data Inversion
 *  0b0..Transmit data not inverted.
 *  0b1..Transmit data inverted.
 */
#define LPUART_CTRL_TXINV(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_TXINV_SHIFT)) & LPUART_CTRL_TXINV_MASK)
#define LPUART_CTRL_TXDIR_MASK                   (0x20000000U)
#define LPUART_CTRL_TXDIR_SHIFT                  (29U)
/*! TXDIR - LPUART_TX Pin Direction in Single-Wire Mode
 *  0b0..LPUART_TX pin is an input in single-wire mode.
 *  0b1..LPUART_TX pin is an output in single-wire mode.
 */
#define LPUART_CTRL_TXDIR(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_TXDIR_SHIFT)) & LPUART_CTRL_TXDIR_MASK)
#define LPUART_CTRL_R9T8_MASK                    (0x40000000U)
#define LPUART_CTRL_R9T8_SHIFT                   (30U)
/*! R9T8 - Receive Bit 9 / Transmit Bit 8
 */
#define LPUART_CTRL_R9T8(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_R9T8_SHIFT)) & LPUART_CTRL_R9T8_MASK)
#define LPUART_CTRL_R8T9_MASK                    (0x80000000U)
#define LPUART_CTRL_R8T9_SHIFT                   (31U)
/*! R8T9 - Receive Bit 8 / Transmit Bit 9
 */
#define LPUART_CTRL_R8T9(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_R8T9_SHIFT)) & LPUART_CTRL_R8T9_MASK)
/*! @} */

/*! @name DATA - LPUART Data Register */
/*! @{ */
#define LPUART_DATA_R0T0_MASK                    (0x1U)
#define LPUART_DATA_R0T0_SHIFT                   (0U)
#define LPUART_DATA_R0T0(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R0T0_SHIFT)) & LPUART_DATA_R0T0_MASK)
#define LPUART_DATA_R1T1_MASK                    (0x2U)
#define LPUART_DATA_R1T1_SHIFT                   (1U)
#define LPUART_DATA_R1T1(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R1T1_SHIFT)) & LPUART_DATA_R1T1_MASK)
#define LPUART_DATA_R2T2_MASK                    (0x4U)
#define LPUART_DATA_R2T2_SHIFT                   (2U)
#define LPUART_DATA_R2T2(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R2T2_SHIFT)) & LPUART_DATA_R2T2_MASK)
#define LPUART_DATA_R3T3_MASK                    (0x8U)
#define LPUART_DATA_R3T3_SHIFT                   (3U)
#define LPUART_DATA_R3T3(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R3T3_SHIFT)) & LPUART_DATA_R3T3_MASK)
#define LPUART_DATA_R4T4_MASK                    (0x10U)
#define LPUART_DATA_R4T4_SHIFT                   (4U)
#define LPUART_DATA_R4T4(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R4T4_SHIFT)) & LPUART_DATA_R4T4_MASK)
#define LPUART_DATA_R5T5_MASK                    (0x20U)
#define LPUART_DATA_R5T5_SHIFT                   (5U)
#define LPUART_DATA_R5T5(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R5T5_SHIFT)) & LPUART_DATA_R5T5_MASK)
#define LPUART_DATA_R6T6_MASK                    (0x40U)
#define LPUART_DATA_R6T6_SHIFT                   (6U)
#define LPUART_DATA_R6T6(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R6T6_SHIFT)) & LPUART_DATA_R6T6_MASK)
#define LPUART_DATA_R7T7_MASK                    (0x80U)
#define LPUART_DATA_R7T7_SHIFT                   (7U)
#define LPUART_DATA_R7T7(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R7T7_SHIFT)) & LPUART_DATA_R7T7_MASK)
#define LPUART_DATA_R8T8_MASK                    (0x100U)
#define LPUART_DATA_R8T8_SHIFT                   (8U)
#define LPUART_DATA_R8T8(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R8T8_SHIFT)) & LPUART_DATA_R8T8_MASK)
#define LPUART_DATA_R9T9_MASK                    (0x200U)
#define LPUART_DATA_R9T9_SHIFT                   (9U)
#define LPUART_DATA_R9T9(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_R9T9_SHIFT)) & LPUART_DATA_R9T9_MASK)
#define LPUART_DATA_IDLINE_MASK                  (0x800U)
#define LPUART_DATA_IDLINE_SHIFT                 (11U)
/*! IDLINE - Idle Line
 *  0b0..Receiver was not idle before receiving this character.
 *  0b1..Receiver was idle before receiving this character.
 */
#define LPUART_DATA_IDLINE(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_IDLINE_SHIFT)) & LPUART_DATA_IDLINE_MASK)
#define LPUART_DATA_RXEMPT_MASK                  (0x1000U)
#define LPUART_DATA_RXEMPT_SHIFT                 (12U)
/*! RXEMPT - Receive Buffer Empty
 *  0b0..Receive buffer contains valid data.
 *  0b1..Receive buffer is empty, data returned on read is not valid.
 */
#define LPUART_DATA_RXEMPT(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_RXEMPT_SHIFT)) & LPUART_DATA_RXEMPT_MASK)
#define LPUART_DATA_FRETSC_MASK                  (0x2000U)
#define LPUART_DATA_FRETSC_SHIFT                 (13U)
/*! FRETSC - Frame Error / Transmit Special Character
 *  0b0..The dataword was received without a frame error on read, transmit a normal character on write.
 *  0b1..The dataword was received with a frame error, transmit an idle or break character on transmit.
 */
#define LPUART_DATA_FRETSC(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_FRETSC_SHIFT)) & LPUART_DATA_FRETSC_MASK)
#define LPUART_DATA_PARITYE_MASK                 (0x4000U)
#define LPUART_DATA_PARITYE_SHIFT                (14U)
/*! PARITYE
 *  0b0..The dataword was received without a parity error.
 *  0b1..The dataword was received with a parity error.
 */
#define LPUART_DATA_PARITYE(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_PARITYE_SHIFT)) & LPUART_DATA_PARITYE_MASK)
#define LPUART_DATA_NOISY_MASK                   (0x8000U)
#define LPUART_DATA_NOISY_SHIFT                  (15U)
/*! NOISY
 *  0b0..The dataword was received without noise.
 *  0b1..The data was received with noise.
 */
#define LPUART_DATA_NOISY(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_DATA_NOISY_SHIFT)) & LPUART_DATA_NOISY_MASK)
/*! @} */

/*! @name MATCH - LPUART Match Address Register */
/*! @{ */
#define LPUART_MATCH_MA1_MASK                    (0x3FFU)
#define LPUART_MATCH_MA1_SHIFT                   (0U)
/*! MA1 - Match Address 1
 */
#define LPUART_MATCH_MA1(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_MATCH_MA1_SHIFT)) & LPUART_MATCH_MA1_MASK)
#define LPUART_MATCH_MA2_MASK                    (0x3FF0000U)
#define LPUART_MATCH_MA2_SHIFT                   (16U)
/*! MA2 - Match Address 2
 */
#define LPUART_MATCH_MA2(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_MATCH_MA2_SHIFT)) & LPUART_MATCH_MA2_MASK)
/*! @} */

/*! @name MODIR - LPUART Modem IrDA Register */
/*! @{ */
#define LPUART_MODIR_TXCTSE_MASK                 (0x1U)
#define LPUART_MODIR_TXCTSE_SHIFT                (0U)
/*! TXCTSE - Transmitter clear-to-send enable
 *  0b0..CTS has no effect on the transmitter.
 *  0b1..Enables clear-to-send operation. The transmitter checks the state of CTS each time it is ready to send a
 *       character. If CTS is asserted, the character is sent. If CTS is deasserted, the signal TXD remains in the
 *       mark state and transmission is delayed until CTS is asserted. Changes in CTS as a character is being sent
 *       do not affect its transmission.
 */
#define LPUART_MODIR_TXCTSE(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TXCTSE_SHIFT)) & LPUART_MODIR_TXCTSE_MASK)
#define LPUART_MODIR_TXRTSE_MASK                 (0x2U)
#define LPUART_MODIR_TXRTSE_SHIFT                (1U)
/*! TXRTSE - Transmitter request-to-send enable
 *  0b0..The transmitter has no effect on RTS.
 *  0b1..When a character is placed into an empty transmitter data buffer , RTS asserts one bit time before the
 *       start bit is transmitted. RTS deasserts one bit time after all characters in the transmitter data buffer and
 *       shift register are completely sent, including the last stop bit.
 */
#define LPUART_MODIR_TXRTSE(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TXRTSE_SHIFT)) & LPUART_MODIR_TXRTSE_MASK)
#define LPUART_MODIR_TXRTSPOL_MASK               (0x4U)
#define LPUART_MODIR_TXRTSPOL_SHIFT              (2U)
/*! TXRTSPOL - Transmitter request-to-send polarity
 *  0b0..Transmitter RTS is active low.
 *  0b1..Transmitter RTS is active high.
 */
#define LPUART_MODIR_TXRTSPOL(x)                 (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TXRTSPOL_SHIFT)) & LPUART_MODIR_TXRTSPOL_MASK)
#define LPUART_MODIR_RXRTSE_MASK                 (0x8U)
#define LPUART_MODIR_RXRTSE_SHIFT                (3U)
/*! RXRTSE - Receiver request-to-send enable
 *  0b0..The receiver has no effect on RTS.
 *  0b1..RTS assertion is configured by the RTSWATER field
 */
#define LPUART_MODIR_RXRTSE(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_RXRTSE_SHIFT)) & LPUART_MODIR_RXRTSE_MASK)
#define LPUART_MODIR_TXCTSC_MASK                 (0x10U)
#define LPUART_MODIR_TXCTSC_SHIFT                (4U)
/*! TXCTSC - Transmit CTS Configuration
 *  0b0..CTS input is sampled at the start of each character.
 *  0b1..CTS input is sampled when the transmitter is idle.
 */
#define LPUART_MODIR_TXCTSC(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TXCTSC_SHIFT)) & LPUART_MODIR_TXCTSC_MASK)
#define LPUART_MODIR_TXCTSSRC_MASK               (0x20U)
#define LPUART_MODIR_TXCTSSRC_SHIFT              (5U)
/*! TXCTSSRC - Transmit CTS Source
 *  0b0..CTS input is the LPUART_CTS pin.
 *  0b1..CTS input is the inverted Receiver Match result.
 */
#define LPUART_MODIR_TXCTSSRC(x)                 (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TXCTSSRC_SHIFT)) & LPUART_MODIR_TXCTSSRC_MASK)
#define LPUART_MODIR_RTSWATER_MASK               (0xFF00U)
#define LPUART_MODIR_RTSWATER_SHIFT              (8U)
/*! RTSWATER - Receive RTS Configuration
 *  0b00000000..RTS asserts when the receiver FIFO is full or receiving a character that causes the FIFO to become full.
 *  0b00000001..RTS asserts when the receive FIFO is less than or equal to the RXWATER configuration and negates
 *              when the receive FIFO is greater than the RXWATER configuration.
 */
#define LPUART_MODIR_RTSWATER(x)                 (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_RTSWATER_SHIFT)) & LPUART_MODIR_RTSWATER_MASK)
#define LPUART_MODIR_TNP_MASK                    (0x30000U)
#define LPUART_MODIR_TNP_SHIFT                   (16U)
/*! TNP - Transmitter narrow pulse
 *  0b00..1/OSR.
 *  0b01..2/OSR.
 *  0b10..3/OSR.
 *  0b11..4/OSR.
 */
#define LPUART_MODIR_TNP(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_TNP_SHIFT)) & LPUART_MODIR_TNP_MASK)
#define LPUART_MODIR_IREN_MASK                   (0x40000U)
#define LPUART_MODIR_IREN_SHIFT                  (18U)
/*! IREN - Infrared enable
 *  0b0..IR disabled.
 *  0b1..IR enabled.
 */
#define LPUART_MODIR_IREN(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_MODIR_IREN_SHIFT)) & LPUART_MODIR_IREN_MASK)
/*! @} */

/*! @name FIFO - LPUART FIFO Register */
/*! @{ */
#define LPUART_FIFO_RXFIFOSIZE_MASK              (0x7U)
#define LPUART_FIFO_RXFIFOSIZE_SHIFT             (0U)
/*! RXFIFOSIZE - Receive FIFO. Buffer Depth
 *  0b010..Receive FIFO/Buffer depth = 8 datawords.
 */
#define LPUART_FIFO_RXFIFOSIZE(x)                (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXFIFOSIZE_SHIFT)) & LPUART_FIFO_RXFIFOSIZE_MASK)
#define LPUART_FIFO_RXFE_MASK                    (0x8U)
#define LPUART_FIFO_RXFE_SHIFT                   (3U)
/*! RXFE - Receive FIFO Enable
 *  0b0..Receive FIFO is not enabled. Buffer is depth 1. (Legacy support)
 *  0b1..Receive FIFO is enabled. Buffer is depth indicted by RXFIFOSIZE.
 */
#define LPUART_FIFO_RXFE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXFE_SHIFT)) & LPUART_FIFO_RXFE_MASK)
#define LPUART_FIFO_TXFIFOSIZE_MASK              (0x70U)
#define LPUART_FIFO_TXFIFOSIZE_SHIFT             (4U)
/*! TXFIFOSIZE - Transmit FIFO. Buffer Depth
 *  0b010..Transmit FIFO/Buffer depth = 8 datawords.
 */
#define LPUART_FIFO_TXFIFOSIZE(x)                (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXFIFOSIZE_SHIFT)) & LPUART_FIFO_TXFIFOSIZE_MASK)
#define LPUART_FIFO_TXFE_MASK                    (0x80U)
#define LPUART_FIFO_TXFE_SHIFT                   (7U)
/*! TXFE - Transmit FIFO Enable
 *  0b0..Transmit FIFO is not enabled. Buffer is depth 1. (Legacy support).
 *  0b1..Transmit FIFO is enabled. Buffer is depth indicated by TXFIFOSIZE.
 */
#define LPUART_FIFO_TXFE(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXFE_SHIFT)) & LPUART_FIFO_TXFE_MASK)
#define LPUART_FIFO_RXUFE_MASK                   (0x100U)
#define LPUART_FIFO_RXUFE_SHIFT                  (8U)
/*! RXUFE - Receive FIFO Underflow Interrupt Enable
 *  0b0..RXUF flag does not generate an interrupt to the host.
 *  0b1..RXUF flag generates an interrupt to the host.
 */
#define LPUART_FIFO_RXUFE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXUFE_SHIFT)) & LPUART_FIFO_RXUFE_MASK)
#define LPUART_FIFO_TXOFE_MASK                   (0x200U)
#define LPUART_FIFO_TXOFE_SHIFT                  (9U)
/*! TXOFE - Transmit FIFO Overflow Interrupt Enable
 *  0b0..TXOF flag does not generate an interrupt to the host.
 *  0b1..TXOF flag generates an interrupt to the host.
 */
#define LPUART_FIFO_TXOFE(x)                     (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXOFE_SHIFT)) & LPUART_FIFO_TXOFE_MASK)
#define LPUART_FIFO_RXIDEN_MASK                  (0x1C00U)
#define LPUART_FIFO_RXIDEN_SHIFT                 (10U)
/*! RXIDEN - Receiver Idle Empty Enable
 *  0b000..Disable RDRF assertion due to partially filled FIFO when receiver is idle.
 *  0b001..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 1 character.
 *  0b010..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 2 characters.
 *  0b011..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 4 characters.
 *  0b100..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 8 characters.
 *  0b101..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 16 characters.
 *  0b110..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 32 characters.
 *  0b111..Enable RDRF assertion due to partially filled FIFO when receiver is idle for 64 characters.
 */
#define LPUART_FIFO_RXIDEN(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXIDEN_SHIFT)) & LPUART_FIFO_RXIDEN_MASK)
#define LPUART_FIFO_RXFLUSH_MASK                 (0x4000U)
#define LPUART_FIFO_RXFLUSH_SHIFT                (14U)
/*! RXFLUSH - Receive FIFO/Buffer Flush
 *  0b0..No flush operation occurs.
 *  0b1..All data in the receive FIFO/buffer is cleared out.
 */
#define LPUART_FIFO_RXFLUSH(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXFLUSH_SHIFT)) & LPUART_FIFO_RXFLUSH_MASK)
#define LPUART_FIFO_TXFLUSH_MASK                 (0x8000U)
#define LPUART_FIFO_TXFLUSH_SHIFT                (15U)
/*! TXFLUSH - Transmit FIFO/Buffer Flush
 *  0b0..No flush operation occurs.
 *  0b1..All data in the transmit FIFO/Buffer is cleared out.
 */
#define LPUART_FIFO_TXFLUSH(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXFLUSH_SHIFT)) & LPUART_FIFO_TXFLUSH_MASK)
#define LPUART_FIFO_RXUF_MASK                    (0x10000U)
#define LPUART_FIFO_RXUF_SHIFT                   (16U)
/*! RXUF - Receiver Buffer Underflow Flag
 *  0b0..No receive buffer underflow has occurred since the last time the flag was cleared.
 *  0b1..At least one receive buffer underflow has occurred since the last time the flag was cleared.
 */
#define LPUART_FIFO_RXUF(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXUF_SHIFT)) & LPUART_FIFO_RXUF_MASK)
#define LPUART_FIFO_TXOF_MASK                    (0x20000U)
#define LPUART_FIFO_TXOF_SHIFT                   (17U)
/*! TXOF - Transmitter Buffer Overflow Flag
 *  0b0..No transmit buffer overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one transmit buffer overflow has occurred since the last time the flag was cleared.
 */
#define LPUART_FIFO_TXOF(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXOF_SHIFT)) & LPUART_FIFO_TXOF_MASK)
#define LPUART_FIFO_RXEMPT_MASK                  (0x400000U)
#define LPUART_FIFO_RXEMPT_SHIFT                 (22U)
/*! RXEMPT - Receive Buffer/FIFO Empty
 *  0b0..Receive buffer is not empty.
 *  0b1..Receive buffer is empty.
 */
#define LPUART_FIFO_RXEMPT(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_RXEMPT_SHIFT)) & LPUART_FIFO_RXEMPT_MASK)
#define LPUART_FIFO_TXEMPT_MASK                  (0x800000U)
#define LPUART_FIFO_TXEMPT_SHIFT                 (23U)
/*! TXEMPT - Transmit Buffer/FIFO Empty
 *  0b0..Transmit buffer is not empty.
 *  0b1..Transmit buffer is empty.
 */
#define LPUART_FIFO_TXEMPT(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_FIFO_TXEMPT_SHIFT)) & LPUART_FIFO_TXEMPT_MASK)
/*! @} */

/*! @name WATER - LPUART Watermark Register */
/*! @{ */
#define LPUART_WATER_TXWATER_MASK                (0xFFU)
#define LPUART_WATER_TXWATER_SHIFT               (0U)
/*! TXWATER - Transmit Watermark
 */
#define LPUART_WATER_TXWATER(x)                  (((uint32_t)(((uint32_t)(x)) << LPUART_WATER_TXWATER_SHIFT)) & LPUART_WATER_TXWATER_MASK)
#define LPUART_WATER_TXCOUNT_MASK                (0xFF00U)
#define LPUART_WATER_TXCOUNT_SHIFT               (8U)
/*! TXCOUNT - Transmit Counter
 */
#define LPUART_WATER_TXCOUNT(x)                  (((uint32_t)(((uint32_t)(x)) << LPUART_WATER_TXCOUNT_SHIFT)) & LPUART_WATER_TXCOUNT_MASK)
#define LPUART_WATER_RXWATER_MASK                (0xFF0000U)
#define LPUART_WATER_RXWATER_SHIFT               (16U)
/*! RXWATER - Receive Watermark
 */
#define LPUART_WATER_RXWATER(x)                  (((uint32_t)(((uint32_t)(x)) << LPUART_WATER_RXWATER_SHIFT)) & LPUART_WATER_RXWATER_MASK)
#define LPUART_WATER_RXCOUNT_MASK                (0xFF000000U)
#define LPUART_WATER_RXCOUNT_SHIFT               (24U)
/*! RXCOUNT - Receive Counter
 */
#define LPUART_WATER_RXCOUNT(x)                  (((uint32_t)(((uint32_t)(x)) << LPUART_WATER_RXCOUNT_SHIFT)) & LPUART_WATER_RXCOUNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group LPUART_Register_Masks */


/* LPUART - Peripheral instance base addresses */
/** Peripheral LPUART0 base address */
#define LPUART0_BASE                             (0x40054000u)
/** Peripheral LPUART0 base pointer */
#define LPUART0                                  ((LPUART_Type *)LPUART0_BASE)
/** Peripheral LPUART1 base address */
#define LPUART1_BASE                             (0x40055000u)
/** Peripheral LPUART1 base pointer */
#define LPUART1                                  ((LPUART_Type *)LPUART1_BASE)
/** Array initializer of LPUART peripheral base addresses */
#define LPUART_BASE_ADDRS                        { LPUART0_BASE, LPUART1_BASE }
/** Array initializer of LPUART peripheral base pointers */
#define LPUART_BASE_PTRS                         { LPUART0, LPUART1 }
/** Interrupt vectors for the LPUART peripheral type */
#define LPUART_RX_TX_IRQS                        { LPUART0_LPUART1_IRQn, LPUART0_LPUART1_IRQn }
#define LPUART_ERR_IRQS                          { LPUART0_LPUART1_IRQn, LPUART0_LPUART1_IRQn }

/*!
 * @}
 */ /* end of group LPUART_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Peripheral_Access_Layer LTC Peripheral Access Layer
 * @{
 */

/** LTC - Register Layout Typedef */
typedef struct {
  __IO uint32_t MD;                                /**< Mode Register, offset: 0x0 */
       uint8_t RESERVED_0[4];
  __O  uint32_t KS;                                /**< Key Size Register, offset: 0x8 */
       uint8_t RESERVED_1[4];
  __IO uint32_t DS;                                /**< Data Size Register, offset: 0x10 */
       uint8_t RESERVED_2[4];
  __IO uint32_t ICVS;                              /**< ICV Size Register, offset: 0x18 */
       uint8_t RESERVED_3[20];
  __O  uint32_t COM;                               /**< Command Register, offset: 0x30 */
  __IO uint32_t CTL;                               /**< Control Register, offset: 0x34 */
       uint8_t RESERVED_4[8];
  __O  uint32_t CW;                                /**< Clear Written Register, offset: 0x40 */
       uint8_t RESERVED_5[4];
  __IO uint32_t STA;                               /**< Status Register, offset: 0x48 */
  __I  uint32_t ESTA;                              /**< Error Status Register, offset: 0x4C */
       uint8_t RESERVED_6[8];
  __IO uint32_t AADSZ;                             /**< AAD Size Register, offset: 0x58 */
       uint8_t RESERVED_7[164];
  __IO uint32_t CTX[14];                           /**< Context Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_8[200];
  __IO uint32_t KEY[4];                            /**< Key Registers, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_9[736];
  __I  uint32_t VID1;                              /**< Version ID Register, offset: 0x4F0 */
  __I  uint32_t VID2;                              /**< Version ID 2 Register, offset: 0x4F4 */
  __I  uint32_t CHAVID;                            /**< CHA Version ID Register, offset: 0x4F8 */
       uint8_t RESERVED_10[708];
  __I  uint32_t FIFOSTA;                           /**< FIFO Status Register, offset: 0x7C0 */
       uint8_t RESERVED_11[28];
  __O  uint32_t IFIFO;                             /**< Input Data FIFO, offset: 0x7E0 */
       uint8_t RESERVED_12[12];
  __I  uint32_t OFIFO;                             /**< Output Data FIFO, offset: 0x7F0 */
} LTC_Type;

/* ----------------------------------------------------------------------------
   -- LTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Masks LTC Register Masks
 * @{
 */

/*! @name MD - Mode Register */
/*! @{ */
#define LTC_MD_ENC_MASK                          (0x1U)
#define LTC_MD_ENC_SHIFT                         (0U)
/*! ENC - Encrypt/Decrypt.
 *  0b0..Decrypt.
 *  0b1..Encrypt.
 */
#define LTC_MD_ENC(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_MD_ENC_SHIFT)) & LTC_MD_ENC_MASK)
#define LTC_MD_ICV_TEST_MASK                     (0x2U)
#define LTC_MD_ICV_TEST_SHIFT                    (1U)
/*! ICV_TEST - ICV Checking / Test AES fault detection.
 */
#define LTC_MD_ICV_TEST(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_MD_ICV_TEST_SHIFT)) & LTC_MD_ICV_TEST_MASK)
#define LTC_MD_AS_MASK                           (0xCU)
#define LTC_MD_AS_SHIFT                          (2U)
/*! AS - Algorithm State
 *  0b00..Update
 *  0b01..Initialize
 *  0b10..Finalize
 *  0b11..Initialize/Finalize
 */
#define LTC_MD_AS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_MD_AS_SHIFT)) & LTC_MD_AS_MASK)
#define LTC_MD_AAI_MASK                          (0x1FF0U)
#define LTC_MD_AAI_SHIFT                         (4U)
/*! AAI - Additional Algorithm information
 */
#define LTC_MD_AAI(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_MD_AAI_SHIFT)) & LTC_MD_AAI_MASK)
#define LTC_MD_ALG_MASK                          (0xFF0000U)
#define LTC_MD_ALG_SHIFT                         (16U)
/*! ALG - Algorithm
 *  0b00010000..AES
 */
#define LTC_MD_ALG(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_MD_ALG_SHIFT)) & LTC_MD_ALG_MASK)
/*! @} */

/*! @name KS - Key Size Register */
/*! @{ */
#define LTC_KS_KS_MASK                           (0x1FU)
#define LTC_KS_KS_SHIFT                          (0U)
/*! KS - Key Size
 */
#define LTC_KS_KS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_KS_KS_SHIFT)) & LTC_KS_KS_MASK)
/*! @} */

/*! @name DS - Data Size Register */
/*! @{ */
#define LTC_DS_DS_MASK                           (0xFFFU)
#define LTC_DS_DS_SHIFT                          (0U)
/*! DS - Data Size
 */
#define LTC_DS_DS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_DS_DS_SHIFT)) & LTC_DS_DS_MASK)
/*! @} */

/*! @name ICVS - ICV Size Register */
/*! @{ */
#define LTC_ICVS_ICVS_MASK                       (0x1FU)
#define LTC_ICVS_ICVS_SHIFT                      (0U)
/*! ICVS - ICV Size, in Bytes
 */
#define LTC_ICVS_ICVS(x)                         (((uint32_t)(((uint32_t)(x)) << LTC_ICVS_ICVS_SHIFT)) & LTC_ICVS_ICVS_MASK)
/*! @} */

/*! @name COM - Command Register */
/*! @{ */
#define LTC_COM_ALL_MASK                         (0x1U)
#define LTC_COM_ALL_SHIFT                        (0U)
/*! ALL - Reset All Internal Logic
 *  0b0..Do Not Reset
 *  0b1..Reset all CHAs in use by this CCB.
 */
#define LTC_COM_ALL(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_COM_ALL_SHIFT)) & LTC_COM_ALL_MASK)
#define LTC_COM_AES_MASK                         (0x2U)
#define LTC_COM_AES_SHIFT                        (1U)
/*! AES - Reset AESA
 *  0b0..Do Not Reset
 *  0b1..Reset AES Accelerator
 */
#define LTC_COM_AES(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_COM_AES_SHIFT)) & LTC_COM_AES_MASK)
/*! @} */

/*! @name CTL - Control Register */
/*! @{ */
#define LTC_CTL_IM_MASK                          (0x1U)
#define LTC_CTL_IM_SHIFT                         (0U)
/*! IM - Interrupt Mask
 *  0b0..Interrupt not masked.
 *  0b1..Interrupt masked
 */
#define LTC_CTL_IM(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CTL_IM_SHIFT)) & LTC_CTL_IM_MASK)
#define LTC_CTL_IFE_MASK                         (0x100U)
#define LTC_CTL_IFE_SHIFT                        (8U)
/*! IFE - Input FIFO DMA Enable
 *  0b0..DMA Request and Done signals disabled for the Input FIFO.
 *  0b1..DMA Request and Done signals enabled for the Input FIFO.
 */
#define LTC_CTL_IFE(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_IFE_SHIFT)) & LTC_CTL_IFE_MASK)
#define LTC_CTL_IFR_MASK                         (0x200U)
#define LTC_CTL_IFR_SHIFT                        (9U)
/*! IFR - Input FIFO DMA Request Size
 *  0b0..DMA request size is 1 entry.
 *  0b1..DMA request size is 4 entries.
 */
#define LTC_CTL_IFR(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_IFR_SHIFT)) & LTC_CTL_IFR_MASK)
#define LTC_CTL_OFE_MASK                         (0x1000U)
#define LTC_CTL_OFE_SHIFT                        (12U)
/*! OFE - Output FIFO DMA Enable
 *  0b0..DMA Request and Done signals disabled for the Output FIFO.
 *  0b1..DMA Request and Done signals enabled for the Output FIFO.
 */
#define LTC_CTL_OFE(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_OFE_SHIFT)) & LTC_CTL_OFE_MASK)
#define LTC_CTL_OFR_MASK                         (0x2000U)
#define LTC_CTL_OFR_SHIFT                        (13U)
/*! OFR - Output FIFO DMA Request Size
 *  0b0..DMA request size is 1 entry.
 *  0b1..DMA request size is 4 entries.
 */
#define LTC_CTL_OFR(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_OFR_SHIFT)) & LTC_CTL_OFR_MASK)
#define LTC_CTL_IFS_MASK                         (0x10000U)
#define LTC_CTL_IFS_SHIFT                        (16U)
/*! IFS - Input FIFO Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_IFS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_IFS_SHIFT)) & LTC_CTL_IFS_MASK)
#define LTC_CTL_OFS_MASK                         (0x20000U)
#define LTC_CTL_OFS_SHIFT                        (17U)
/*! OFS - Output FIFO Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_OFS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_OFS_SHIFT)) & LTC_CTL_OFS_MASK)
#define LTC_CTL_KIS_MASK                         (0x100000U)
#define LTC_CTL_KIS_SHIFT                        (20U)
/*! KIS - Key Register Input Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_KIS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_KIS_SHIFT)) & LTC_CTL_KIS_MASK)
#define LTC_CTL_KOS_MASK                         (0x200000U)
#define LTC_CTL_KOS_SHIFT                        (21U)
/*! KOS - Key Register Output Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_KOS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_KOS_SHIFT)) & LTC_CTL_KOS_MASK)
#define LTC_CTL_CIS_MASK                         (0x400000U)
#define LTC_CTL_CIS_SHIFT                        (22U)
/*! CIS - Context Register Input Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_CIS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_CIS_SHIFT)) & LTC_CTL_CIS_MASK)
#define LTC_CTL_COS_MASK                         (0x800000U)
#define LTC_CTL_COS_SHIFT                        (23U)
/*! COS - Context Register Output Byte Swap
 *  0b0..Do Not Byte Swap Data.
 *  0b1..Byte Swap Data.
 */
#define LTC_CTL_COS(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_COS_SHIFT)) & LTC_CTL_COS_MASK)
#define LTC_CTL_KAL_MASK                         (0x80000000U)
#define LTC_CTL_KAL_SHIFT                        (31U)
/*! KAL - Key Register Access Lock
 *  0b0..Key Register is readable.
 *  0b1..Key Register is not readable.
 */
#define LTC_CTL_KAL(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTL_KAL_SHIFT)) & LTC_CTL_KAL_MASK)
/*! @} */

/*! @name CW - Clear Written Register */
/*! @{ */
#define LTC_CW_CM_MASK                           (0x1U)
#define LTC_CW_CM_SHIFT                          (0U)
/*! CM - Clear the Mode Register
 */
#define LTC_CW_CM(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_CW_CM_SHIFT)) & LTC_CW_CM_MASK)
#define LTC_CW_CDS_MASK                          (0x4U)
#define LTC_CW_CDS_SHIFT                         (2U)
/*! CDS - Clear the Data Size Register
 */
#define LTC_CW_CDS(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CW_CDS_SHIFT)) & LTC_CW_CDS_MASK)
#define LTC_CW_CICV_MASK                         (0x8U)
#define LTC_CW_CICV_SHIFT                        (3U)
/*! CICV - Clear the ICV Size Register
 */
#define LTC_CW_CICV(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CW_CICV_SHIFT)) & LTC_CW_CICV_MASK)
#define LTC_CW_CCR_MASK                          (0x20U)
#define LTC_CW_CCR_SHIFT                         (5U)
/*! CCR - Clear the Context Register
 */
#define LTC_CW_CCR(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CW_CCR_SHIFT)) & LTC_CW_CCR_MASK)
#define LTC_CW_CKR_MASK                          (0x40U)
#define LTC_CW_CKR_SHIFT                         (6U)
/*! CKR - Clear the Key Register
 */
#define LTC_CW_CKR(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CW_CKR_SHIFT)) & LTC_CW_CKR_MASK)
#define LTC_CW_COF_MASK                          (0x40000000U)
#define LTC_CW_COF_SHIFT                         (30U)
/*! COF - Clear Output FIFO
 */
#define LTC_CW_COF(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CW_COF_SHIFT)) & LTC_CW_COF_MASK)
#define LTC_CW_CIF_MASK                          (0x80000000U)
#define LTC_CW_CIF_SHIFT                         (31U)
/*! CIF - Clear Input FIFO
 */
#define LTC_CW_CIF(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_CW_CIF_SHIFT)) & LTC_CW_CIF_MASK)
/*! @} */

/*! @name STA - Status Register */
/*! @{ */
#define LTC_STA_AB_MASK                          (0x2U)
#define LTC_STA_AB_SHIFT                         (1U)
/*! AB - AESA Busy
 *  0b0..AESA Idle
 *  0b1..AESA Busy.
 */
#define LTC_STA_AB(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_STA_AB_SHIFT)) & LTC_STA_AB_MASK)
#define LTC_STA_DI_MASK                          (0x10000U)
#define LTC_STA_DI_SHIFT                         (16U)
/*! DI - Done Interrupt
 */
#define LTC_STA_DI(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_STA_DI_SHIFT)) & LTC_STA_DI_MASK)
#define LTC_STA_EI_MASK                          (0x100000U)
#define LTC_STA_EI_SHIFT                         (20U)
/*! EI - Error Interrupt
 *  0b0..Not Error.
 *  0b1..Error Interrupt.
 */
#define LTC_STA_EI(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_STA_EI_SHIFT)) & LTC_STA_EI_MASK)
/*! @} */

/*! @name ESTA - Error Status Register */
/*! @{ */
#define LTC_ESTA_ERRID1_MASK                     (0xFU)
#define LTC_ESTA_ERRID1_SHIFT                    (0U)
/*! ERRID1 - Error ID 1
 *  0b0001..Mode Error
 *  0b0010..Data Size Error
 *  0b0011..Key Size Error
 *  0b0110..Data Arrived out of Sequence Error
 *  0b1010..ICV Check Failed
 *  0b1011..Internal Hardware Failure
 *  0b1100..CCM AAD Size Error (either 1. AAD flag in B0 =1 and no AAD type provided, 2. AAD flag in B0 = 0 and
 *          AAD povided, or 3. AAD flag in B0 =1 and not enough AAD provided - expecting more based on AAD size.)
 *  0b1111..Invalid Crypto Engine Selected
 */
#define LTC_ESTA_ERRID1(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_ESTA_ERRID1_SHIFT)) & LTC_ESTA_ERRID1_MASK)
#define LTC_ESTA_CL1_MASK                        (0xF00U)
#define LTC_ESTA_CL1_SHIFT                       (8U)
/*! CL1 - algorithms
 *  0b0000..General Error
 *  0b0001..AES
 */
#define LTC_ESTA_CL1(x)                          (((uint32_t)(((uint32_t)(x)) << LTC_ESTA_CL1_SHIFT)) & LTC_ESTA_CL1_MASK)
/*! @} */

/*! @name AADSZ - AAD Size Register */
/*! @{ */
#define LTC_AADSZ_AADSZ_MASK                     (0xFU)
#define LTC_AADSZ_AADSZ_SHIFT                    (0U)
/*! AADSZ - AAD size in Bytes, mod 16
 */
#define LTC_AADSZ_AADSZ(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_AADSZ_AADSZ_SHIFT)) & LTC_AADSZ_AADSZ_MASK)
#define LTC_AADSZ_AL_MASK                        (0x80000000U)
#define LTC_AADSZ_AL_SHIFT                       (31U)
/*! AL - AAD Last
 */
#define LTC_AADSZ_AL(x)                          (((uint32_t)(((uint32_t)(x)) << LTC_AADSZ_AL_SHIFT)) & LTC_AADSZ_AL_MASK)
/*! @} */

/*! @name CTX - Context Register */
/*! @{ */
#define LTC_CTX_CTX_MASK                         (0xFFFFFFFFU)
#define LTC_CTX_CTX_SHIFT                        (0U)
/*! CTX - CTX
 */
#define LTC_CTX_CTX(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTX_CTX_SHIFT)) & LTC_CTX_CTX_MASK)
/*! @} */

/* The count of LTC_CTX */
#define LTC_CTX_COUNT                            (14U)

/*! @name KEY - Key Registers */
/*! @{ */
#define LTC_KEY_KEY_MASK                         (0xFFFFFFFFU)
#define LTC_KEY_KEY_SHIFT                        (0U)
/*! KEY - KEY
 */
#define LTC_KEY_KEY(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_KEY_KEY_SHIFT)) & LTC_KEY_KEY_MASK)
/*! @} */

/* The count of LTC_KEY */
#define LTC_KEY_COUNT                            (4U)

/*! @name VID1 - Version ID Register */
/*! @{ */
#define LTC_VID1_MIN_REV_MASK                    (0xFFU)
#define LTC_VID1_MIN_REV_SHIFT                   (0U)
/*! MIN_REV - Minor revision number.
 */
#define LTC_VID1_MIN_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID1_MIN_REV_SHIFT)) & LTC_VID1_MIN_REV_MASK)
#define LTC_VID1_MAJ_REV_MASK                    (0xFF00U)
#define LTC_VID1_MAJ_REV_SHIFT                   (8U)
/*! MAJ_REV - Major revision number.
 */
#define LTC_VID1_MAJ_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID1_MAJ_REV_SHIFT)) & LTC_VID1_MAJ_REV_MASK)
#define LTC_VID1_IP_ID_MASK                      (0xFFFF0000U)
#define LTC_VID1_IP_ID_SHIFT                     (16U)
#define LTC_VID1_IP_ID(x)                        (((uint32_t)(((uint32_t)(x)) << LTC_VID1_IP_ID_SHIFT)) & LTC_VID1_IP_ID_MASK)
/*! @} */

/*! @name VID2 - Version ID 2 Register */
/*! @{ */
#define LTC_VID2_ECO_REV_MASK                    (0xFFU)
#define LTC_VID2_ECO_REV_SHIFT                   (0U)
/*! ECO_REV - ECO revision number.
 */
#define LTC_VID2_ECO_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID2_ECO_REV_SHIFT)) & LTC_VID2_ECO_REV_MASK)
#define LTC_VID2_ARCH_ERA_MASK                   (0xFF00U)
#define LTC_VID2_ARCH_ERA_SHIFT                  (8U)
/*! ARCH_ERA - Architectural ERA.
 */
#define LTC_VID2_ARCH_ERA(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_VID2_ARCH_ERA_SHIFT)) & LTC_VID2_ARCH_ERA_MASK)
/*! @} */

/*! @name CHAVID - CHA Version ID Register */
/*! @{ */
#define LTC_CHAVID_AESREV_MASK                   (0xFU)
#define LTC_CHAVID_AESREV_SHIFT                  (0U)
/*! AESREV - AES Revision Number
 */
#define LTC_CHAVID_AESREV(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_CHAVID_AESREV_SHIFT)) & LTC_CHAVID_AESREV_MASK)
#define LTC_CHAVID_AESVID_MASK                   (0xF0U)
#define LTC_CHAVID_AESVID_SHIFT                  (4U)
/*! AESVID - AES Version ID
 */
#define LTC_CHAVID_AESVID(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_CHAVID_AESVID_SHIFT)) & LTC_CHAVID_AESVID_MASK)
/*! @} */

/*! @name FIFOSTA - FIFO Status Register */
/*! @{ */
#define LTC_FIFOSTA_IFL_MASK                     (0x7FU)
#define LTC_FIFOSTA_IFL_SHIFT                    (0U)
/*! IFL - Input FIFO Level
 */
#define LTC_FIFOSTA_IFL(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_IFL_SHIFT)) & LTC_FIFOSTA_IFL_MASK)
#define LTC_FIFOSTA_IFF_MASK                     (0x8000U)
#define LTC_FIFOSTA_IFF_SHIFT                    (15U)
/*! IFF - Input FIFO Full
 */
#define LTC_FIFOSTA_IFF(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_IFF_SHIFT)) & LTC_FIFOSTA_IFF_MASK)
#define LTC_FIFOSTA_OFL_MASK                     (0x7F0000U)
#define LTC_FIFOSTA_OFL_SHIFT                    (16U)
/*! OFL - Output FIFO Level
 */
#define LTC_FIFOSTA_OFL(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_OFL_SHIFT)) & LTC_FIFOSTA_OFL_MASK)
#define LTC_FIFOSTA_OFF_MASK                     (0x80000000U)
#define LTC_FIFOSTA_OFF_SHIFT                    (31U)
/*! OFF - Output FIFO Full
 */
#define LTC_FIFOSTA_OFF(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_OFF_SHIFT)) & LTC_FIFOSTA_OFF_MASK)
/*! @} */

/*! @name IFIFO - Input Data FIFO */
/*! @{ */
#define LTC_IFIFO_IFIFO_MASK                     (0xFFFFFFFFU)
#define LTC_IFIFO_IFIFO_SHIFT                    (0U)
/*! IFIFO - IFIFO
 */
#define LTC_IFIFO_IFIFO(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_IFIFO_IFIFO_SHIFT)) & LTC_IFIFO_IFIFO_MASK)
/*! @} */

/*! @name OFIFO - Output Data FIFO */
/*! @{ */
#define LTC_OFIFO_OFIFO_MASK                     (0xFFFFFFFFU)
#define LTC_OFIFO_OFIFO_SHIFT                    (0U)
/*! OFIFO - Output FIFO
 */
#define LTC_OFIFO_OFIFO(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_OFIFO_OFIFO_SHIFT)) & LTC_OFIFO_OFIFO_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group LTC_Register_Masks */


/* LTC - Peripheral instance base addresses */
/** Peripheral LTC0 base address */
#define LTC0_BASE                                (0x40058000u)
/** Peripheral LTC0 base pointer */
#define LTC0                                     ((LTC_Type *)LTC0_BASE)
/** Array initializer of LTC peripheral base addresses */
#define LTC_BASE_ADDRS                           { LTC0_BASE }
/** Array initializer of LTC peripheral base pointers */
#define LTC_BASE_PTRS                            { LTC0 }
/** Interrupt vectors for the LTC peripheral type */
#define LTC_IRQS                                 { LTC0_IRQn }

/*!
 * @}
 */ /* end of group LTC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Peripheral_Access_Layer MCG Peripheral Access Layer
 * @{
 */

/** MCG - Register Layout Typedef */
typedef struct {
  __IO uint8_t C1;                                 /**< MCG Control 1 Register, offset: 0x0 */
  __IO uint8_t C2;                                 /**< MCG Control 2 Register, offset: 0x1 */
  __IO uint8_t C3;                                 /**< MCG Control 3 Register, offset: 0x2 */
  __IO uint8_t C4;                                 /**< MCG Control 4 Register, offset: 0x3 */
       uint8_t C5;                                 /**< MCG Control 5 Register, offset: 0x4 */
  __IO uint8_t C6;                                 /**< MCG Control 6 Register, offset: 0x5 */
  __I  uint8_t S;                                  /**< MCG Status Register, offset: 0x6 */
       uint8_t RESERVED_0[1];
  __IO uint8_t SC;                                 /**< MCG Status and Control Register, offset: 0x8 */
       uint8_t RESERVED_1[1];
  __IO uint8_t ATCVH;                              /**< MCG Auto Trim Compare Value High Register, offset: 0xA */
  __IO uint8_t ATCVL;                              /**< MCG Auto Trim Compare Value Low Register, offset: 0xB */
  __IO uint8_t C7;                                 /**< MCG Control 7 Register, offset: 0xC */
  __IO uint8_t C8;                                 /**< MCG Control 8 Register, offset: 0xD */
} MCG_Type;

/* ----------------------------------------------------------------------------
   -- MCG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Masks MCG Register Masks
 * @{
 */

/*! @name C1 - MCG Control 1 Register */
/*! @{ */
#define MCG_C1_IREFSTEN_MASK                     (0x1U)
#define MCG_C1_IREFSTEN_SHIFT                    (0U)
/*! IREFSTEN - Internal Reference Stop Enable
 *  0b0..Internal reference clock is disabled in Stop mode.
 *  0b1..Internal reference clock is enabled in Stop mode if IRCLKEN is set or if MCG is in FEI, FBI, or BLPI modes before entering Stop mode.
 */
#define MCG_C1_IREFSTEN(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_C1_IREFSTEN_SHIFT)) & MCG_C1_IREFSTEN_MASK)
#define MCG_C1_IRCLKEN_MASK                      (0x2U)
#define MCG_C1_IRCLKEN_SHIFT                     (1U)
/*! IRCLKEN - Internal Reference Clock Enable
 *  0b0..MCGIRCLK inactive.
 *  0b1..MCGIRCLK active.
 */
#define MCG_C1_IRCLKEN(x)                        (((uint8_t)(((uint8_t)(x)) << MCG_C1_IRCLKEN_SHIFT)) & MCG_C1_IRCLKEN_MASK)
#define MCG_C1_IREFS_MASK                        (0x4U)
#define MCG_C1_IREFS_SHIFT                       (2U)
/*! IREFS - Internal Reference Select
 *  0b0..External reference clock is selected.
 *  0b1..The slow internal reference clock is selected.
 */
#define MCG_C1_IREFS(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C1_IREFS_SHIFT)) & MCG_C1_IREFS_MASK)
#define MCG_C1_FRDIV_MASK                        (0x38U)
#define MCG_C1_FRDIV_SHIFT                       (3U)
/*! FRDIV - FLL External Reference Divider
 *  0b000..If RANGE = 0 or OSCSEL=1 , Divide Factor is 1; for all other RANGE values, Divide Factor is 32.
 *  0b001..If RANGE = 0 or OSCSEL=1 , Divide Factor is 2; for all other RANGE values, Divide Factor is 64.
 *  0b010..If RANGE = 0 or OSCSEL=1 , Divide Factor is 4; for all other RANGE values, Divide Factor is 128.
 *  0b011..If RANGE = 0 or OSCSEL=1 , Divide Factor is 8; for all other RANGE values, Divide Factor is 256.
 *  0b100..If RANGE = 0 or OSCSEL=1 , Divide Factor is 16; for all other RANGE values, Divide Factor is 512.
 *  0b101..If RANGE = 0 or OSCSEL=1 , Divide Factor is 32; for all other RANGE values, Divide Factor is 1024.
 *  0b110..If RANGE = 0 or OSCSEL=1 , Divide Factor is 64; for all other RANGE values, Divide Factor is 1280 .
 *  0b111..If RANGE = 0 or OSCSEL=1 , Divide Factor is 128; for all other RANGE values, Divide Factor is 1536 .
 */
#define MCG_C1_FRDIV(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C1_FRDIV_SHIFT)) & MCG_C1_FRDIV_MASK)
#define MCG_C1_CLKS_MASK                         (0xC0U)
#define MCG_C1_CLKS_SHIFT                        (6U)
/*! CLKS - Clock Source Select
 *  0b00..Encoding 0 - Output of FLL is selected.
 *  0b01..Encoding 1 - Internal reference clock is selected.
 *  0b10..Encoding 2 - External reference clock is selected.
 *  0b11..Encoding 3 - Reserved.
 */
#define MCG_C1_CLKS(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_C1_CLKS_SHIFT)) & MCG_C1_CLKS_MASK)
/*! @} */

/*! @name C2 - MCG Control 2 Register */
/*! @{ */
#define MCG_C2_IRCS_MASK                         (0x1U)
#define MCG_C2_IRCS_SHIFT                        (0U)
/*! IRCS - Internal Reference Clock Select
 *  0b0..Slow internal reference clock selected.
 *  0b1..Fast internal reference clock selected.
 */
#define MCG_C2_IRCS(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_C2_IRCS_SHIFT)) & MCG_C2_IRCS_MASK)
#define MCG_C2_LP_MASK                           (0x2U)
#define MCG_C2_LP_SHIFT                          (1U)
/*! LP - Low Power Select
 *  0b0..FLL is not disabled in bypass modes.
 *  0b1..FLL is disabled in bypass modes (lower power)
 */
#define MCG_C2_LP(x)                             (((uint8_t)(((uint8_t)(x)) << MCG_C2_LP_SHIFT)) & MCG_C2_LP_MASK)
#define MCG_C2_EREFS_MASK                        (0x4U)
#define MCG_C2_EREFS_SHIFT                       (2U)
/*! EREFS - External Reference Select
 *  0b0..External reference clock requested.
 *  0b1..Oscillator requested.
 */
#define MCG_C2_EREFS(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C2_EREFS_SHIFT)) & MCG_C2_EREFS_MASK)
#define MCG_C2_HGO_MASK                          (0x8U)
#define MCG_C2_HGO_SHIFT                         (3U)
/*! HGO - High Gain Oscillator Select
 *  0b0..Configure crystal oscillator for low-power operation.
 *  0b1..Configure crystal oscillator for high-gain operation.
 */
#define MCG_C2_HGO(x)                            (((uint8_t)(((uint8_t)(x)) << MCG_C2_HGO_SHIFT)) & MCG_C2_HGO_MASK)
#define MCG_C2_RANGE_MASK                        (0x30U)
#define MCG_C2_RANGE_SHIFT                       (4U)
/*! RANGE - Frequency Range Select
 *  0b00..Encoding 0 - Low frequency range selected for the crystal oscillator .
 *  0b01..Encoding 1 - High frequency range selected for the crystal oscillator .
 *  0b1x..Encoding 2 - Very high frequency range selected for the crystal oscillator .
 */
#define MCG_C2_RANGE(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C2_RANGE_SHIFT)) & MCG_C2_RANGE_MASK)
#define MCG_C2_FCFTRIM_MASK                      (0x40U)
#define MCG_C2_FCFTRIM_SHIFT                     (6U)
/*! FCFTRIM - Fast Internal Reference Clock Fine Trim
 */
#define MCG_C2_FCFTRIM(x)                        (((uint8_t)(((uint8_t)(x)) << MCG_C2_FCFTRIM_SHIFT)) & MCG_C2_FCFTRIM_MASK)
#define MCG_C2_LOCRE0_MASK                       (0x80U)
#define MCG_C2_LOCRE0_SHIFT                      (7U)
/*! LOCRE0 - Loss of Clock Reset Enable
 *  0b0..Interrupt request is generated on a loss of OSC0 external reference clock.
 *  0b1..Generate a reset request on a loss of OSC0 external reference clock.
 */
#define MCG_C2_LOCRE0(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C2_LOCRE0_SHIFT)) & MCG_C2_LOCRE0_MASK)
/*! @} */

/*! @name C3 - MCG Control 3 Register */
/*! @{ */
#define MCG_C3_SCTRIM_MASK                       (0xFFU)
#define MCG_C3_SCTRIM_SHIFT                      (0U)
/*! SCTRIM - Slow Internal Reference Clock Trim Setting
 */
#define MCG_C3_SCTRIM(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C3_SCTRIM_SHIFT)) & MCG_C3_SCTRIM_MASK)
/*! @} */

/*! @name C4 - MCG Control 4 Register */
/*! @{ */
#define MCG_C4_SCFTRIM_MASK                      (0x1U)
#define MCG_C4_SCFTRIM_SHIFT                     (0U)
/*! SCFTRIM - Slow Internal Reference Clock Fine Trim
 */
#define MCG_C4_SCFTRIM(x)                        (((uint8_t)(((uint8_t)(x)) << MCG_C4_SCFTRIM_SHIFT)) & MCG_C4_SCFTRIM_MASK)
#define MCG_C4_FCTRIM_MASK                       (0x1EU)
#define MCG_C4_FCTRIM_SHIFT                      (1U)
/*! FCTRIM - Fast Internal Reference Clock Trim Setting
 */
#define MCG_C4_FCTRIM(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C4_FCTRIM_SHIFT)) & MCG_C4_FCTRIM_MASK)
#define MCG_C4_DRST_DRS_MASK                     (0x60U)
#define MCG_C4_DRST_DRS_SHIFT                    (5U)
/*! DRST_DRS - DCO Range Select
 *  0b00..Encoding 0 - Low range (reset default).
 *  0b01..Encoding 1 - Mid range.
 *  0b10..Encoding 2 - Mid-high range.
 *  0b11..Encoding 3 - High range.
 */
#define MCG_C4_DRST_DRS(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_C4_DRST_DRS_SHIFT)) & MCG_C4_DRST_DRS_MASK)
#define MCG_C4_DMX32_MASK                        (0x80U)
#define MCG_C4_DMX32_SHIFT                       (7U)
/*! DMX32 - DCO Maximum Frequency with 32.768 kHz Reference
 *  0b0..DCO has a default range of 25%.
 *  0b1..DCO is fine-tuned for maximum frequency with 32.768 kHz reference.
 */
#define MCG_C4_DMX32(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C4_DMX32_SHIFT)) & MCG_C4_DMX32_MASK)
/*! @} */

/*! @name C6 - MCG Control 6 Register */
/*! @{ */
#define MCG_C6_CME0_MASK                         (0x20U)
#define MCG_C6_CME0_SHIFT                        (5U)
/*! CME0 - Clock Monitor Enable
 *  0b0..External clock monitor is disabled.
 *  0b1..Generate an interrupt or a reset request (see MCG_C2[LOCRE0]) on loss of external clock.
 */
#define MCG_C6_CME0(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_C6_CME0_SHIFT)) & MCG_C6_CME0_MASK)
/*! @} */

/*! @name S - MCG Status Register */
/*! @{ */
#define MCG_S_IRCST_MASK                         (0x1U)
#define MCG_S_IRCST_SHIFT                        (0U)
/*! IRCST - Internal Reference Clock Status
 *  0b0..Source of internal reference clock is the slow clock (32 kHz IRC).
 *  0b1..Source of internal reference clock is the fast clock (4 MHz IRC).
 */
#define MCG_S_IRCST(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_S_IRCST_SHIFT)) & MCG_S_IRCST_MASK)
#define MCG_S_OSCINIT0_MASK                      (0x2U)
#define MCG_S_OSCINIT0_SHIFT                     (1U)
/*! OSCINIT0 - OSC Initialization
 */
#define MCG_S_OSCINIT0(x)                        (((uint8_t)(((uint8_t)(x)) << MCG_S_OSCINIT0_SHIFT)) & MCG_S_OSCINIT0_MASK)
#define MCG_S_CLKST_MASK                         (0xCU)
#define MCG_S_CLKST_SHIFT                        (2U)
/*! CLKST - Clock Mode Status
 *  0b00..Encoding 0 - Output of the FLL is selected (reset default).
 *  0b01..Encoding 1 - Internal reference clock is selected.
 *  0b10..Encoding 2 - External reference clock is selected.
 *  0b11..Reserved.
 */
#define MCG_S_CLKST(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_S_CLKST_SHIFT)) & MCG_S_CLKST_MASK)
#define MCG_S_IREFST_MASK                        (0x10U)
#define MCG_S_IREFST_SHIFT                       (4U)
/*! IREFST - Internal Reference Status
 *  0b0..Source of FLL reference clock is the external reference clock.
 *  0b1..Source of FLL reference clock is the internal reference clock.
 */
#define MCG_S_IREFST(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_S_IREFST_SHIFT)) & MCG_S_IREFST_MASK)
/*! @} */

/*! @name SC - MCG Status and Control Register */
/*! @{ */
#define MCG_SC_LOCS0_MASK                        (0x1U)
#define MCG_SC_LOCS0_SHIFT                       (0U)
/*! LOCS0 - OSC0 Loss of Clock Status
 *  0b0..Loss of OSC0 has not occurred.
 *  0b1..Loss of OSC0 has occurred.
 */
#define MCG_SC_LOCS0(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_SC_LOCS0_SHIFT)) & MCG_SC_LOCS0_MASK)
#define MCG_SC_FCRDIV_MASK                       (0xEU)
#define MCG_SC_FCRDIV_SHIFT                      (1U)
/*! FCRDIV - Fast Clock Internal Reference Divider
 *  0b000..Divide Factor is 1
 *  0b001..Divide Factor is 2.
 *  0b010..Divide Factor is 4.
 *  0b011..Divide Factor is 8.
 *  0b100..Divide Factor is 16
 *  0b101..Divide Factor is 32
 *  0b110..Divide Factor is 64
 *  0b111..Divide Factor is 128.
 */
#define MCG_SC_FCRDIV(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_SC_FCRDIV_SHIFT)) & MCG_SC_FCRDIV_MASK)
#define MCG_SC_FLTPRSRV_MASK                     (0x10U)
#define MCG_SC_FLTPRSRV_SHIFT                    (4U)
/*! FLTPRSRV - FLL Filter Preserve Enable
 *  0b0..FLL filter and FLL frequency will reset on changes to currect clock mode.
 *  0b1..Fll filter and FLL frequency retain their previous values during new clock mode change.
 */
#define MCG_SC_FLTPRSRV(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_SC_FLTPRSRV_SHIFT)) & MCG_SC_FLTPRSRV_MASK)
#define MCG_SC_ATMF_MASK                         (0x20U)
#define MCG_SC_ATMF_SHIFT                        (5U)
/*! ATMF - Automatic Trim Machine Fail Flag
 *  0b0..Automatic Trim Machine completed normally.
 *  0b1..Automatic Trim Machine failed.
 */
#define MCG_SC_ATMF(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_SC_ATMF_SHIFT)) & MCG_SC_ATMF_MASK)
#define MCG_SC_ATMS_MASK                         (0x40U)
#define MCG_SC_ATMS_SHIFT                        (6U)
/*! ATMS - Automatic Trim Machine Select
 *  0b0..32 kHz Internal Reference Clock selected.
 *  0b1..4 MHz Internal Reference Clock selected.
 */
#define MCG_SC_ATMS(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_SC_ATMS_SHIFT)) & MCG_SC_ATMS_MASK)
#define MCG_SC_ATME_MASK                         (0x80U)
#define MCG_SC_ATME_SHIFT                        (7U)
/*! ATME - Automatic Trim Machine Enable
 *  0b0..Auto Trim Machine disabled.
 *  0b1..Auto Trim Machine enabled.
 */
#define MCG_SC_ATME(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_SC_ATME_SHIFT)) & MCG_SC_ATME_MASK)
/*! @} */

/*! @name ATCVH - MCG Auto Trim Compare Value High Register */
/*! @{ */
#define MCG_ATCVH_ATCVH_MASK                     (0xFFU)
#define MCG_ATCVH_ATCVH_SHIFT                    (0U)
/*! ATCVH - ATM Compare Value High
 */
#define MCG_ATCVH_ATCVH(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_ATCVH_ATCVH_SHIFT)) & MCG_ATCVH_ATCVH_MASK)
/*! @} */

/*! @name ATCVL - MCG Auto Trim Compare Value Low Register */
/*! @{ */
#define MCG_ATCVL_ATCVL_MASK                     (0xFFU)
#define MCG_ATCVL_ATCVL_SHIFT                    (0U)
/*! ATCVL - ATM Compare Value Low
 */
#define MCG_ATCVL_ATCVL(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_ATCVL_ATCVL_SHIFT)) & MCG_ATCVL_ATCVL_MASK)
/*! @} */

/*! @name C7 - MCG Control 7 Register */
/*! @{ */
#define MCG_C7_OSCSEL_MASK                       (0x1U)
#define MCG_C7_OSCSEL_SHIFT                      (0U)
/*! OSCSEL - MCG OSC Clock Select
 *  0b0..Selects Oscillator (OSCCLK).
 *  0b1..Selects 32 kHz RTC Oscillator.
 */
#define MCG_C7_OSCSEL(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C7_OSCSEL_SHIFT)) & MCG_C7_OSCSEL_MASK)
/*! @} */

/*! @name C8 - MCG Control 8 Register */
/*! @{ */
#define MCG_C8_LOCS1_MASK                        (0x1U)
#define MCG_C8_LOCS1_SHIFT                       (0U)
/*! LOCS1 - RTC Loss of Clock Status
 *  0b0..Loss of RTC has not occur.
 *  0b1..Loss of RTC has occur
 */
#define MCG_C8_LOCS1(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C8_LOCS1_SHIFT)) & MCG_C8_LOCS1_MASK)
#define MCG_C8_CME1_MASK                         (0x20U)
#define MCG_C8_CME1_SHIFT                        (5U)
/*! CME1 - Clock Monitor Enable1
 *  0b0..External clock monitor is disabled for RTC clock.
 *  0b1..External clock monitor is enabled for RTC clock.
 */
#define MCG_C8_CME1(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_C8_CME1_SHIFT)) & MCG_C8_CME1_MASK)
#define MCG_C8_LOCRE1_MASK                       (0x80U)
#define MCG_C8_LOCRE1_SHIFT                      (7U)
/*! LOCRE1 - Loss of Clock Reset Enable
 *  0b0..Interrupt request is generated on a loss of RTC external reference clock.
 *  0b1..Generate a reset request on a loss of RTC external reference clock
 */
#define MCG_C8_LOCRE1(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C8_LOCRE1_SHIFT)) & MCG_C8_LOCRE1_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group MCG_Register_Masks */


/* MCG - Peripheral instance base addresses */
/** Peripheral MCG base address */
#define MCG_BASE                                 (0x40064000u)
/** Peripheral MCG base pointer */
#define MCG                                      ((MCG_Type *)MCG_BASE)
/** Array initializer of MCG peripheral base addresses */
#define MCG_BASE_ADDRS                           { MCG_BASE }
/** Array initializer of MCG peripheral base pointers */
#define MCG_BASE_PTRS                            { MCG }
/** Interrupt vectors for the MCG peripheral type */
#define MCG_IRQS                                 { MCG_IRQn }

/*!
 * @}
 */ /* end of group MCG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Peripheral_Access_Layer MCM Peripheral Access Layer
 * @{
 */

/** MCM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __I  uint16_t PLASC;                             /**< Crossbar Switch (AXBS) Slave Configuration, offset: 0x8 */
  __I  uint16_t PLAMC;                             /**< Crossbar Switch (AXBS) Master Configuration, offset: 0xA */
  __IO uint32_t PLACR;                             /**< Platform Control Register, offset: 0xC */
       uint8_t RESERVED_1[48];
  __IO uint32_t CPO;                               /**< Compute Operation Control Register, offset: 0x40 */
} MCM_Type;

/* ----------------------------------------------------------------------------
   -- MCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Masks MCM Register Masks
 * @{
 */

/*! @name PLASC - Crossbar Switch (AXBS) Slave Configuration */
/*! @{ */
#define MCM_PLASC_ASC_MASK                       (0xFFU)
#define MCM_PLASC_ASC_SHIFT                      (0U)
/*! ASC - Each bit in the ASC field indicates whether there is a corresponding connection to the
 *    crossbar switch's slave input port.
 *  0b00000000..A bus slave connection to AXBS input port n is absent.
 *  0b00000001..A bus slave connection to AXBS input port n is present.
 */
#define MCM_PLASC_ASC(x)                         (((uint16_t)(((uint16_t)(x)) << MCM_PLASC_ASC_SHIFT)) & MCM_PLASC_ASC_MASK)
/*! @} */

/*! @name PLAMC - Crossbar Switch (AXBS) Master Configuration */
/*! @{ */
#define MCM_PLAMC_AMC_MASK                       (0xFFU)
#define MCM_PLAMC_AMC_SHIFT                      (0U)
/*! AMC - Each bit in the AMC field indicates whether there is a corresponding connection to the AXBS master input port.
 *  0b00000000..A bus master connection to AXBS input port n is absent
 *  0b00000001..A bus master connection to AXBS input port n is present
 */
#define MCM_PLAMC_AMC(x)                         (((uint16_t)(((uint16_t)(x)) << MCM_PLAMC_AMC_SHIFT)) & MCM_PLAMC_AMC_MASK)
/*! @} */

/*! @name PLACR - Platform Control Register */
/*! @{ */
#define MCM_PLACR_ARB_MASK                       (0x200U)
#define MCM_PLACR_ARB_SHIFT                      (9U)
/*! ARB - Arbitration select
 *  0b0..Fixed-priority arbitration for the crossbar masters
 *  0b1..Round-robin arbitration for the crossbar masters
 */
#define MCM_PLACR_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_ARB_SHIFT)) & MCM_PLACR_ARB_MASK)
#define MCM_PLACR_CFCC_MASK                      (0x400U)
#define MCM_PLACR_CFCC_SHIFT                     (10U)
/*! CFCC - Clear Flash Controller Cache
 */
#define MCM_PLACR_CFCC(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_CFCC_SHIFT)) & MCM_PLACR_CFCC_MASK)
#define MCM_PLACR_DFCDA_MASK                     (0x800U)
#define MCM_PLACR_DFCDA_SHIFT                    (11U)
/*! DFCDA - Disable Flash Controller Data Caching
 *  0b0..Enable flash controller data caching
 *  0b1..Disable flash controller data caching.
 */
#define MCM_PLACR_DFCDA(x)                       (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_DFCDA_SHIFT)) & MCM_PLACR_DFCDA_MASK)
#define MCM_PLACR_DFCIC_MASK                     (0x1000U)
#define MCM_PLACR_DFCIC_SHIFT                    (12U)
/*! DFCIC - Disable Flash Controller Instruction Caching
 *  0b0..Enable flash controller instruction caching.
 *  0b1..Disable flash controller instruction caching.
 */
#define MCM_PLACR_DFCIC(x)                       (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_DFCIC_SHIFT)) & MCM_PLACR_DFCIC_MASK)
#define MCM_PLACR_DFCC_MASK                      (0x2000U)
#define MCM_PLACR_DFCC_SHIFT                     (13U)
/*! DFCC - Disable Flash Controller Cache
 *  0b0..Enable flash controller cache.
 *  0b1..Disable flash controller cache.
 */
#define MCM_PLACR_DFCC(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_DFCC_SHIFT)) & MCM_PLACR_DFCC_MASK)
#define MCM_PLACR_EFDS_MASK                      (0x4000U)
#define MCM_PLACR_EFDS_SHIFT                     (14U)
/*! EFDS - Enable Flash Data Speculation
 *  0b0..Disable flash data speculation.
 *  0b1..Enable flash data speculation.
 */
#define MCM_PLACR_EFDS(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_EFDS_SHIFT)) & MCM_PLACR_EFDS_MASK)
#define MCM_PLACR_DFCS_MASK                      (0x8000U)
#define MCM_PLACR_DFCS_SHIFT                     (15U)
/*! DFCS - Disable Flash Controller Speculation
 *  0b0..Enable flash controller speculation.
 *  0b1..Disable flash controller speculation.
 */
#define MCM_PLACR_DFCS(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_DFCS_SHIFT)) & MCM_PLACR_DFCS_MASK)
#define MCM_PLACR_ESFC_MASK                      (0x10000U)
#define MCM_PLACR_ESFC_SHIFT                     (16U)
/*! ESFC - Enable Stalling Flash Controller
 *  0b0..Disable stalling flash controller when flash is busy.
 *  0b1..Enable stalling flash controller when flash is busy.
 */
#define MCM_PLACR_ESFC(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_PLACR_ESFC_SHIFT)) & MCM_PLACR_ESFC_MASK)
/*! @} */

/*! @name CPO - Compute Operation Control Register */
/*! @{ */
#define MCM_CPO_CPOREQ_MASK                      (0x1U)
#define MCM_CPO_CPOREQ_SHIFT                     (0U)
/*! CPOREQ - Compute Operation Request
 *  0b0..Request is cleared.
 *  0b1..Request Compute Operation.
 */
#define MCM_CPO_CPOREQ(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_CPO_CPOREQ_SHIFT)) & MCM_CPO_CPOREQ_MASK)
#define MCM_CPO_CPOACK_MASK                      (0x2U)
#define MCM_CPO_CPOACK_SHIFT                     (1U)
/*! CPOACK - Compute Operation Acknowledge
 *  0b0..Compute operation entry has not completed or compute operation exit has completed.
 *  0b1..Compute operation entry has completed or compute operation exit has not completed.
 */
#define MCM_CPO_CPOACK(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_CPO_CPOACK_SHIFT)) & MCM_CPO_CPOACK_MASK)
#define MCM_CPO_CPOWOI_MASK                      (0x4U)
#define MCM_CPO_CPOWOI_SHIFT                     (2U)
/*! CPOWOI - Compute Operation Wake-up on Interrupt
 *  0b0..No effect.
 *  0b1..When set, the CPOREQ is cleared on any interrupt or exception vector fetch.
 */
#define MCM_CPO_CPOWOI(x)                        (((uint32_t)(((uint32_t)(x)) << MCM_CPO_CPOWOI_SHIFT)) & MCM_CPO_CPOWOI_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group MCM_Register_Masks */


/* MCM - Peripheral instance base addresses */
/** Peripheral MCM base address */
#define MCM_BASE                                 (0xF0003000u)
/** Peripheral MCM base pointer */
#define MCM                                      ((MCM_Type *)MCM_BASE)
/** Array initializer of MCM peripheral base addresses */
#define MCM_BASE_ADDRS                           { MCM_BASE }
/** Array initializer of MCM peripheral base pointers */
#define MCM_BASE_PTRS                            { MCM }

/*!
 * @}
 */ /* end of group MCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MTB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Peripheral_Access_Layer MTB Peripheral Access Layer
 * @{
 */

/** MTB - Register Layout Typedef */
typedef struct {
  __IO uint32_t POSITION;                          /**< MTB Position Register, offset: 0x0 */
  __IO uint32_t MASTER;                            /**< MTB Master Register, offset: 0x4 */
  __IO uint32_t FLOW;                              /**< MTB Flow Register, offset: 0x8 */
  __I  uint32_t BASE;                              /**< MTB Base Register, offset: 0xC */
       uint8_t RESERVED_0[3824];
  __I  uint32_t MODECTRL;                          /**< Integration Mode Control Register, offset: 0xF00 */
       uint8_t RESERVED_1[156];
  __I  uint32_t TAGSET;                            /**< Claim TAG Set Register, offset: 0xFA0 */
  __I  uint32_t TAGCLEAR;                          /**< Claim TAG Clear Register, offset: 0xFA4 */
       uint8_t RESERVED_2[8];
  __I  uint32_t LOCKACCESS;                        /**< Lock Access Register, offset: 0xFB0 */
  __I  uint32_t LOCKSTAT;                          /**< Lock Status Register, offset: 0xFB4 */
  __I  uint32_t AUTHSTAT;                          /**< Authentication Status Register, offset: 0xFB8 */
  __I  uint32_t DEVICEARCH;                        /**< Device Architecture Register, offset: 0xFBC */
       uint8_t RESERVED_3[8];
  __I  uint32_t DEVICECFG;                         /**< Device Configuration Register, offset: 0xFC8 */
  __I  uint32_t DEVICETYPID;                       /**< Device Type Identifier Register, offset: 0xFCC */
  __I  uint32_t PERIPHID4;                         /**< Peripheral ID Register, offset: 0xFD0 */
  __I  uint32_t PERIPHID5;                         /**< Peripheral ID Register, offset: 0xFD4 */
  __I  uint32_t PERIPHID6;                         /**< Peripheral ID Register, offset: 0xFD8 */
  __I  uint32_t PERIPHID7;                         /**< Peripheral ID Register, offset: 0xFDC */
  __I  uint32_t PERIPHID0;                         /**< Peripheral ID Register, offset: 0xFE0 */
  __I  uint32_t PERIPHID1;                         /**< Peripheral ID Register, offset: 0xFE4 */
  __I  uint32_t PERIPHID2;                         /**< Peripheral ID Register, offset: 0xFE8 */
  __I  uint32_t PERIPHID3;                         /**< Peripheral ID Register, offset: 0xFEC */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} MTB_Type;

/* ----------------------------------------------------------------------------
   -- MTB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Masks MTB Register Masks
 * @{
 */

/*! @name POSITION - MTB Position Register */
/*! @{ */
#define MTB_POSITION_WRAP_MASK                   (0x4U)
#define MTB_POSITION_WRAP_SHIFT                  (2U)
/*! WRAP - WRAP
 */
#define MTB_POSITION_WRAP(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_POSITION_WRAP_SHIFT)) & MTB_POSITION_WRAP_MASK)
#define MTB_POSITION_POINTER_MASK                (0xFFFFFFF8U)
#define MTB_POSITION_POINTER_SHIFT               (3U)
/*! POINTER - Trace Packet Address Pointer[28:0]
 */
#define MTB_POSITION_POINTER(x)                  (((uint32_t)(((uint32_t)(x)) << MTB_POSITION_POINTER_SHIFT)) & MTB_POSITION_POINTER_MASK)
/*! @} */

/*! @name MASTER - MTB Master Register */
/*! @{ */
#define MTB_MASTER_MASK_MASK                     (0x1FU)
#define MTB_MASTER_MASK_SHIFT                    (0U)
/*! MASK - Mask
 */
#define MTB_MASTER_MASK(x)                       (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_MASK_SHIFT)) & MTB_MASTER_MASK_MASK)
#define MTB_MASTER_TSTARTEN_MASK                 (0x20U)
#define MTB_MASTER_TSTARTEN_SHIFT                (5U)
/*! TSTARTEN - Trace Start Input Enable
 */
#define MTB_MASTER_TSTARTEN(x)                   (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_TSTARTEN_SHIFT)) & MTB_MASTER_TSTARTEN_MASK)
#define MTB_MASTER_TSTOPEN_MASK                  (0x40U)
#define MTB_MASTER_TSTOPEN_SHIFT                 (6U)
/*! TSTOPEN - Trace Stop Input Enable
 */
#define MTB_MASTER_TSTOPEN(x)                    (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_TSTOPEN_SHIFT)) & MTB_MASTER_TSTOPEN_MASK)
#define MTB_MASTER_SFRWPRIV_MASK                 (0x80U)
#define MTB_MASTER_SFRWPRIV_SHIFT                (7U)
/*! SFRWPRIV - Special Function Register Write Privilege
 */
#define MTB_MASTER_SFRWPRIV(x)                   (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_SFRWPRIV_SHIFT)) & MTB_MASTER_SFRWPRIV_MASK)
#define MTB_MASTER_RAMPRIV_MASK                  (0x100U)
#define MTB_MASTER_RAMPRIV_SHIFT                 (8U)
/*! RAMPRIV - RAM Privilege
 */
#define MTB_MASTER_RAMPRIV(x)                    (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_RAMPRIV_SHIFT)) & MTB_MASTER_RAMPRIV_MASK)
#define MTB_MASTER_HALTREQ_MASK                  (0x200U)
#define MTB_MASTER_HALTREQ_SHIFT                 (9U)
/*! HALTREQ - Halt Request
 */
#define MTB_MASTER_HALTREQ(x)                    (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_HALTREQ_SHIFT)) & MTB_MASTER_HALTREQ_MASK)
#define MTB_MASTER_EN_MASK                       (0x80000000U)
#define MTB_MASTER_EN_SHIFT                      (31U)
/*! EN - Main Trace Enable
 */
#define MTB_MASTER_EN(x)                         (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_EN_SHIFT)) & MTB_MASTER_EN_MASK)
/*! @} */

/*! @name FLOW - MTB Flow Register */
/*! @{ */
#define MTB_FLOW_AUTOSTOP_MASK                   (0x1U)
#define MTB_FLOW_AUTOSTOP_SHIFT                  (0U)
/*! AUTOSTOP - AUTOSTOP
 */
#define MTB_FLOW_AUTOSTOP(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_FLOW_AUTOSTOP_SHIFT)) & MTB_FLOW_AUTOSTOP_MASK)
#define MTB_FLOW_AUTOHALT_MASK                   (0x2U)
#define MTB_FLOW_AUTOHALT_SHIFT                  (1U)
/*! AUTOHALT - AUTOHALT
 */
#define MTB_FLOW_AUTOHALT(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_FLOW_AUTOHALT_SHIFT)) & MTB_FLOW_AUTOHALT_MASK)
#define MTB_FLOW_WATERMARK_MASK                  (0xFFFFFFF8U)
#define MTB_FLOW_WATERMARK_SHIFT                 (3U)
/*! WATERMARK - WATERMARK[28:0]
 */
#define MTB_FLOW_WATERMARK(x)                    (((uint32_t)(((uint32_t)(x)) << MTB_FLOW_WATERMARK_SHIFT)) & MTB_FLOW_WATERMARK_MASK)
/*! @} */

/*! @name BASE - MTB Base Register */
/*! @{ */
#define MTB_BASE_BASEADDR_MASK                   (0xFFFFFFFFU)
#define MTB_BASE_BASEADDR_SHIFT                  (0U)
/*! BASEADDR - BASEADDR
 */
#define MTB_BASE_BASEADDR(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_BASE_BASEADDR_SHIFT)) & MTB_BASE_BASEADDR_MASK)
/*! @} */

/*! @name MODECTRL - Integration Mode Control Register */
/*! @{ */
#define MTB_MODECTRL_MODECTRL_MASK               (0xFFFFFFFFU)
#define MTB_MODECTRL_MODECTRL_SHIFT              (0U)
/*! MODECTRL - MODECTRL
 */
#define MTB_MODECTRL_MODECTRL(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_MODECTRL_MODECTRL_SHIFT)) & MTB_MODECTRL_MODECTRL_MASK)
/*! @} */

/*! @name TAGSET - Claim TAG Set Register */
/*! @{ */
#define MTB_TAGSET_TAGSET_MASK                   (0xFFFFFFFFU)
#define MTB_TAGSET_TAGSET_SHIFT                  (0U)
/*! TAGSET - TAGSET
 */
#define MTB_TAGSET_TAGSET(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_TAGSET_TAGSET_SHIFT)) & MTB_TAGSET_TAGSET_MASK)
/*! @} */

/*! @name TAGCLEAR - Claim TAG Clear Register */
/*! @{ */
#define MTB_TAGCLEAR_TAGCLEAR_MASK               (0xFFFFFFFFU)
#define MTB_TAGCLEAR_TAGCLEAR_SHIFT              (0U)
/*! TAGCLEAR - TAGCLEAR
 */
#define MTB_TAGCLEAR_TAGCLEAR(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_TAGCLEAR_TAGCLEAR_SHIFT)) & MTB_TAGCLEAR_TAGCLEAR_MASK)
/*! @} */

/*! @name LOCKACCESS - Lock Access Register */
/*! @{ */
#define MTB_LOCKACCESS_LOCKACCESS_MASK           (0xFFFFFFFFU)
#define MTB_LOCKACCESS_LOCKACCESS_SHIFT          (0U)
#define MTB_LOCKACCESS_LOCKACCESS(x)             (((uint32_t)(((uint32_t)(x)) << MTB_LOCKACCESS_LOCKACCESS_SHIFT)) & MTB_LOCKACCESS_LOCKACCESS_MASK)
/*! @} */

/*! @name LOCKSTAT - Lock Status Register */
/*! @{ */
#define MTB_LOCKSTAT_LOCKSTAT_MASK               (0xFFFFFFFFU)
#define MTB_LOCKSTAT_LOCKSTAT_SHIFT              (0U)
/*! LOCKSTAT - LOCKSTAT
 */
#define MTB_LOCKSTAT_LOCKSTAT(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_LOCKSTAT_LOCKSTAT_SHIFT)) & MTB_LOCKSTAT_LOCKSTAT_MASK)
/*! @} */

/*! @name AUTHSTAT - Authentication Status Register */
/*! @{ */
#define MTB_AUTHSTAT_BIT0_MASK                   (0x1U)
#define MTB_AUTHSTAT_BIT0_SHIFT                  (0U)
#define MTB_AUTHSTAT_BIT0(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_AUTHSTAT_BIT0_SHIFT)) & MTB_AUTHSTAT_BIT0_MASK)
#define MTB_AUTHSTAT_BIT2_MASK                   (0x4U)
#define MTB_AUTHSTAT_BIT2_SHIFT                  (2U)
/*! BIT2 - BIT2
 */
#define MTB_AUTHSTAT_BIT2(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_AUTHSTAT_BIT2_SHIFT)) & MTB_AUTHSTAT_BIT2_MASK)
/*! @} */

/*! @name DEVICEARCH - Device Architecture Register */
/*! @{ */
#define MTB_DEVICEARCH_DEVICEARCH_MASK           (0xFFFFFFFFU)
#define MTB_DEVICEARCH_DEVICEARCH_SHIFT          (0U)
/*! DEVICEARCH - DEVICEARCH
 */
#define MTB_DEVICEARCH_DEVICEARCH(x)             (((uint32_t)(((uint32_t)(x)) << MTB_DEVICEARCH_DEVICEARCH_SHIFT)) & MTB_DEVICEARCH_DEVICEARCH_MASK)
/*! @} */

/*! @name DEVICECFG - Device Configuration Register */
/*! @{ */
#define MTB_DEVICECFG_DEVICECFG_MASK             (0xFFFFFFFFU)
#define MTB_DEVICECFG_DEVICECFG_SHIFT            (0U)
/*! DEVICECFG - DEVICECFG
 */
#define MTB_DEVICECFG_DEVICECFG(x)               (((uint32_t)(((uint32_t)(x)) << MTB_DEVICECFG_DEVICECFG_SHIFT)) & MTB_DEVICECFG_DEVICECFG_MASK)
/*! @} */

/*! @name DEVICETYPID - Device Type Identifier Register */
/*! @{ */
#define MTB_DEVICETYPID_DEVICETYPID_MASK         (0xFFFFFFFFU)
#define MTB_DEVICETYPID_DEVICETYPID_SHIFT        (0U)
/*! DEVICETYPID - DEVICETYPID
 */
#define MTB_DEVICETYPID_DEVICETYPID(x)           (((uint32_t)(((uint32_t)(x)) << MTB_DEVICETYPID_DEVICETYPID_SHIFT)) & MTB_DEVICETYPID_DEVICETYPID_MASK)
/*! @} */

/*! @name PERIPHID4 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID4_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID4_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID4_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID4_PERIPHID_SHIFT)) & MTB_PERIPHID4_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID5 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID5_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID5_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID5_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID5_PERIPHID_SHIFT)) & MTB_PERIPHID5_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID6 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID6_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID6_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID6_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID6_PERIPHID_SHIFT)) & MTB_PERIPHID6_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID7 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID7_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID7_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID7_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID7_PERIPHID_SHIFT)) & MTB_PERIPHID7_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID0 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID0_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID0_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID0_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID0_PERIPHID_SHIFT)) & MTB_PERIPHID0_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID1 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID1_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID1_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID1_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID1_PERIPHID_SHIFT)) & MTB_PERIPHID1_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID2 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID2_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID2_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID2_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID2_PERIPHID_SHIFT)) & MTB_PERIPHID2_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID3 - Peripheral ID Register */
/*! @{ */
#define MTB_PERIPHID3_PERIPHID_MASK              (0xFFFFFFFFU)
#define MTB_PERIPHID3_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define MTB_PERIPHID3_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID3_PERIPHID_SHIFT)) & MTB_PERIPHID3_PERIPHID_MASK)
/*! @} */

/*! @name COMPID - Component ID Register */
/*! @{ */
#define MTB_COMPID_COMPID_MASK                   (0xFFFFFFFFU)
#define MTB_COMPID_COMPID_SHIFT                  (0U)
/*! COMPID - Component ID
 */
#define MTB_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_COMPID_COMPID_SHIFT)) & MTB_COMPID_COMPID_MASK)
/*! @} */

/* The count of MTB_COMPID */
#define MTB_COMPID_COUNT                         (4U)


/*!
 * @}
 */ /* end of group MTB_Register_Masks */


/* MTB - Peripheral instance base addresses */
/** Peripheral MTB base address */
#define MTB_BASE                                 (0xF0000000u)
/** Peripheral MTB base pointer */
#define MTB                                      ((MTB_Type *)MTB_BASE)
/** Array initializer of MTB peripheral base addresses */
#define MTB_BASE_ADDRS                           { MTB_BASE }
/** Array initializer of MTB peripheral base pointers */
#define MTB_BASE_PTRS                            { MTB }

/*!
 * @}
 */ /* end of group MTB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MTBDWT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Peripheral_Access_Layer MTBDWT Peripheral Access Layer
 * @{
 */

/** MTBDWT - Register Layout Typedef */
typedef struct {
  __I  uint32_t CTRL;                              /**< MTB DWT Control Register, offset: 0x0 */
       uint8_t RESERVED_0[28];
  struct {                                         /* offset: 0x20, array step: 0x10 */
    __IO uint32_t COMP;                              /**< MTB_DWT Comparator Register, array offset: 0x20, array step: 0x10 */
    __IO uint32_t MASK;                              /**< MTB_DWT Comparator Mask Register, array offset: 0x24, array step: 0x10 */
    __IO uint32_t FCT;                               /**< MTB_DWT Comparator Function Register 0..MTB_DWT Comparator Function Register 1, array offset: 0x28, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } COMPARATOR[2];
       uint8_t RESERVED_1[448];
  __IO uint32_t TBCTRL;                            /**< MTB_DWT Trace Buffer Control Register, offset: 0x200 */
       uint8_t RESERVED_2[3524];
  __I  uint32_t DEVICECFG;                         /**< Device Configuration Register, offset: 0xFC8 */
  __I  uint32_t DEVICETYPID;                       /**< Device Type Identifier Register, offset: 0xFCC */
  __I  uint32_t PERIPHID4;                         /**< Peripheral ID Register, offset: 0xFD0 */
  __I  uint32_t PERIPHID5;                         /**< Peripheral ID Register, offset: 0xFD4 */
  __I  uint32_t PERIPHID6;                         /**< Peripheral ID Register, offset: 0xFD8 */
  __I  uint32_t PERIPHID7;                         /**< Peripheral ID Register, offset: 0xFDC */
  __I  uint32_t PERIPHID0;                         /**< Peripheral ID Register, offset: 0xFE0 */
  __I  uint32_t PERIPHID1;                         /**< Peripheral ID Register, offset: 0xFE4 */
  __I  uint32_t PERIPHID2;                         /**< Peripheral ID Register, offset: 0xFE8 */
  __I  uint32_t PERIPHID3;                         /**< Peripheral ID Register, offset: 0xFEC */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} MTBDWT_Type;

/* ----------------------------------------------------------------------------
   -- MTBDWT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Masks MTBDWT Register Masks
 * @{
 */

/*! @name CTRL - MTB DWT Control Register */
/*! @{ */
#define MTBDWT_CTRL_DWTCFGCTRL_MASK              (0xFFFFFFFU)
#define MTBDWT_CTRL_DWTCFGCTRL_SHIFT             (0U)
/*! DWTCFGCTRL - DWT configuration controls
 */
#define MTBDWT_CTRL_DWTCFGCTRL(x)                (((uint32_t)(((uint32_t)(x)) << MTBDWT_CTRL_DWTCFGCTRL_SHIFT)) & MTBDWT_CTRL_DWTCFGCTRL_MASK)
#define MTBDWT_CTRL_NUMCMP_MASK                  (0xF0000000U)
#define MTBDWT_CTRL_NUMCMP_SHIFT                 (28U)
/*! NUMCMP - Number of comparators
 */
#define MTBDWT_CTRL_NUMCMP(x)                    (((uint32_t)(((uint32_t)(x)) << MTBDWT_CTRL_NUMCMP_SHIFT)) & MTBDWT_CTRL_NUMCMP_MASK)
/*! @} */

/*! @name COMP - MTB_DWT Comparator Register */
/*! @{ */
#define MTBDWT_COMP_COMP_MASK                    (0xFFFFFFFFU)
#define MTBDWT_COMP_COMP_SHIFT                   (0U)
/*! COMP - Reference value for comparison
 */
#define MTBDWT_COMP_COMP(x)                      (((uint32_t)(((uint32_t)(x)) << MTBDWT_COMP_COMP_SHIFT)) & MTBDWT_COMP_COMP_MASK)
/*! @} */

/* The count of MTBDWT_COMP */
#define MTBDWT_COMP_COUNT                        (2U)

/*! @name MASK - MTB_DWT Comparator Mask Register */
/*! @{ */
#define MTBDWT_MASK_MASK_MASK                    (0x1FU)
#define MTBDWT_MASK_MASK_SHIFT                   (0U)
/*! MASK - MASK
 */
#define MTBDWT_MASK_MASK(x)                      (((uint32_t)(((uint32_t)(x)) << MTBDWT_MASK_MASK_SHIFT)) & MTBDWT_MASK_MASK_MASK)
/*! @} */

/* The count of MTBDWT_MASK */
#define MTBDWT_MASK_COUNT                        (2U)

/*! @name FCT - MTB_DWT Comparator Function Register 0..MTB_DWT Comparator Function Register 1 */
/*! @{ */
#define MTBDWT_FCT_FUNCTION_MASK                 (0xFU)
#define MTBDWT_FCT_FUNCTION_SHIFT                (0U)
/*! FUNCTION - Function
 *  0b0000..Disabled.
 *  0b0100..Instruction fetch.
 *  0b0101..Data operand read.
 *  0b0110..Data operand write.
 *  0b0111..Data operand (read + write).
 */
#define MTBDWT_FCT_FUNCTION(x)                   (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_FUNCTION_SHIFT)) & MTBDWT_FCT_FUNCTION_MASK)
#define MTBDWT_FCT_DATAVMATCH_MASK               (0x100U)
#define MTBDWT_FCT_DATAVMATCH_SHIFT              (8U)
/*! DATAVMATCH - Data Value Match
 *  0b0..Perform address comparison.
 *  0b1..Perform data value comparison.
 */
#define MTBDWT_FCT_DATAVMATCH(x)                 (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_DATAVMATCH_SHIFT)) & MTBDWT_FCT_DATAVMATCH_MASK)
#define MTBDWT_FCT_DATAVSIZE_MASK                (0xC00U)
#define MTBDWT_FCT_DATAVSIZE_SHIFT               (10U)
/*! DATAVSIZE - Data Value Size
 *  0b00..Byte.
 *  0b01..Halfword.
 *  0b10..Word.
 *  0b11..Reserved. Any attempts to use this value results in UNPREDICTABLE behavior.
 */
#define MTBDWT_FCT_DATAVSIZE(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_DATAVSIZE_SHIFT)) & MTBDWT_FCT_DATAVSIZE_MASK)
#define MTBDWT_FCT_DATAVADDR0_MASK               (0xF000U)
#define MTBDWT_FCT_DATAVADDR0_SHIFT              (12U)
/*! DATAVADDR0 - Data Value Address 0
 */
#define MTBDWT_FCT_DATAVADDR0(x)                 (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_DATAVADDR0_SHIFT)) & MTBDWT_FCT_DATAVADDR0_MASK)
#define MTBDWT_FCT_MATCHED_MASK                  (0x1000000U)
#define MTBDWT_FCT_MATCHED_SHIFT                 (24U)
/*! MATCHED - Comparator match
 *  0b0..No match.
 *  0b1..Match occurred.
 */
#define MTBDWT_FCT_MATCHED(x)                    (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_MATCHED_SHIFT)) & MTBDWT_FCT_MATCHED_MASK)
/*! @} */

/* The count of MTBDWT_FCT */
#define MTBDWT_FCT_COUNT                         (2U)

/*! @name TBCTRL - MTB_DWT Trace Buffer Control Register */
/*! @{ */
#define MTBDWT_TBCTRL_ACOMP0_MASK                (0x1U)
#define MTBDWT_TBCTRL_ACOMP0_SHIFT               (0U)
/*! ACOMP0 - Action based on Comparator 0 match
 *  0b0..Trigger TSTOP based on the assertion of MTBDWT_FCT0[MATCHED].
 *  0b1..Trigger TSTART based on the assertion of MTBDWT_FCT0[MATCHED].
 */
#define MTBDWT_TBCTRL_ACOMP0(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_TBCTRL_ACOMP0_SHIFT)) & MTBDWT_TBCTRL_ACOMP0_MASK)
#define MTBDWT_TBCTRL_ACOMP1_MASK                (0x2U)
#define MTBDWT_TBCTRL_ACOMP1_SHIFT               (1U)
/*! ACOMP1 - Action based on Comparator 1 match
 *  0b0..Trigger TSTOP based on the assertion of MTBDWT_FCT1[MATCHED].
 *  0b1..Trigger TSTART based on the assertion of MTBDWT_FCT1[MATCHED].
 */
#define MTBDWT_TBCTRL_ACOMP1(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_TBCTRL_ACOMP1_SHIFT)) & MTBDWT_TBCTRL_ACOMP1_MASK)
#define MTBDWT_TBCTRL_NUMCOMP_MASK               (0xF0000000U)
#define MTBDWT_TBCTRL_NUMCOMP_SHIFT              (28U)
/*! NUMCOMP - Number of Comparators
 */
#define MTBDWT_TBCTRL_NUMCOMP(x)                 (((uint32_t)(((uint32_t)(x)) << MTBDWT_TBCTRL_NUMCOMP_SHIFT)) & MTBDWT_TBCTRL_NUMCOMP_MASK)
/*! @} */

/*! @name DEVICECFG - Device Configuration Register */
/*! @{ */
#define MTBDWT_DEVICECFG_DEVICECFG_MASK          (0xFFFFFFFFU)
#define MTBDWT_DEVICECFG_DEVICECFG_SHIFT         (0U)
/*! DEVICECFG - DEVICECFG
 */
#define MTBDWT_DEVICECFG_DEVICECFG(x)            (((uint32_t)(((uint32_t)(x)) << MTBDWT_DEVICECFG_DEVICECFG_SHIFT)) & MTBDWT_DEVICECFG_DEVICECFG_MASK)
/*! @} */

/*! @name DEVICETYPID - Device Type Identifier Register */
/*! @{ */
#define MTBDWT_DEVICETYPID_DEVICETYPID_MASK      (0xFFFFFFFFU)
#define MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT     (0U)
/*! DEVICETYPID - DEVICETYPID
 */
#define MTBDWT_DEVICETYPID_DEVICETYPID(x)        (((uint32_t)(((uint32_t)(x)) << MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT)) & MTBDWT_DEVICETYPID_DEVICETYPID_MASK)
/*! @} */

/*! @name PERIPHID4 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID4_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID4_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID4_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID4_PERIPHID_SHIFT)) & MTBDWT_PERIPHID4_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID5 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID5_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID5_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID5_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID5_PERIPHID_SHIFT)) & MTBDWT_PERIPHID5_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID6 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID6_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID6_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID6_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID6_PERIPHID_SHIFT)) & MTBDWT_PERIPHID6_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID7 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID7_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID7_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID7_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID7_PERIPHID_SHIFT)) & MTBDWT_PERIPHID7_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID0 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID0_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID0_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID0_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID0_PERIPHID_SHIFT)) & MTBDWT_PERIPHID0_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID1 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID1_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID1_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID1_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID1_PERIPHID_SHIFT)) & MTBDWT_PERIPHID1_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID2 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID2_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID2_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID2_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID2_PERIPHID_SHIFT)) & MTBDWT_PERIPHID2_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID3 - Peripheral ID Register */
/*! @{ */
#define MTBDWT_PERIPHID3_PERIPHID_MASK           (0xFFFFFFFFU)
#define MTBDWT_PERIPHID3_PERIPHID_SHIFT          (0U)
/*! PERIPHID - PERIPHID
 */
#define MTBDWT_PERIPHID3_PERIPHID(x)             (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID3_PERIPHID_SHIFT)) & MTBDWT_PERIPHID3_PERIPHID_MASK)
/*! @} */

/*! @name COMPID - Component ID Register */
/*! @{ */
#define MTBDWT_COMPID_COMPID_MASK                (0xFFFFFFFFU)
#define MTBDWT_COMPID_COMPID_SHIFT               (0U)
/*! COMPID - Component ID
 */
#define MTBDWT_COMPID_COMPID(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_COMPID_COMPID_SHIFT)) & MTBDWT_COMPID_COMPID_MASK)
/*! @} */

/* The count of MTBDWT_COMPID */
#define MTBDWT_COMPID_COUNT                      (4U)


/*!
 * @}
 */ /* end of group MTBDWT_Register_Masks */


/* MTBDWT - Peripheral instance base addresses */
/** Peripheral MTBDWT base address */
#define MTBDWT_BASE                              (0xF0001000u)
/** Peripheral MTBDWT base pointer */
#define MTBDWT                                   ((MTBDWT_Type *)MTBDWT_BASE)
/** Array initializer of MTBDWT peripheral base addresses */
#define MTBDWT_BASE_ADDRS                        { MTBDWT_BASE }
/** Array initializer of MTBDWT peripheral base pointers */
#define MTBDWT_BASE_PTRS                         { MTBDWT }

/*!
 * @}
 */ /* end of group MTBDWT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- NV Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Peripheral_Access_Layer NV Peripheral Access Layer
 * @{
 */

/** NV - Register Layout Typedef */
typedef struct {
  __I  uint8_t BACKKEY3;                           /**< Backdoor Comparison Key 3., offset: 0x0 */
  __I  uint8_t BACKKEY2;                           /**< Backdoor Comparison Key 2., offset: 0x1 */
  __I  uint8_t BACKKEY1;                           /**< Backdoor Comparison Key 1., offset: 0x2 */
  __I  uint8_t BACKKEY0;                           /**< Backdoor Comparison Key 0., offset: 0x3 */
  __I  uint8_t BACKKEY7;                           /**< Backdoor Comparison Key 7., offset: 0x4 */
  __I  uint8_t BACKKEY6;                           /**< Backdoor Comparison Key 6., offset: 0x5 */
  __I  uint8_t BACKKEY5;                           /**< Backdoor Comparison Key 5., offset: 0x6 */
  __I  uint8_t BACKKEY4;                           /**< Backdoor Comparison Key 4., offset: 0x7 */
  __I  uint8_t FPROT3;                             /**< Non-volatile P-Flash Protection 1 - Low Register, offset: 0x8 */
  __I  uint8_t FPROT2;                             /**< Non-volatile P-Flash Protection 1 - High Register, offset: 0x9 */
  __I  uint8_t FPROT1;                             /**< Non-volatile P-Flash Protection 0 - Low Register, offset: 0xA */
  __I  uint8_t FPROT0;                             /**< Non-volatile P-Flash Protection 0 - High Register, offset: 0xB */
  __I  uint8_t FSEC;                               /**< Non-volatile Flash Security Register, offset: 0xC */
  __I  uint8_t FOPT;                               /**< Non-volatile Flash Option Register, offset: 0xD */
  __I  uint8_t FEPROT;                             /**< Non-volatile EERAM Protection Register, offset: 0xE */
  __I  uint8_t FDPROT;                             /**< Non-volatile D-Flash Protection Register, offset: 0xF */
} NV_Type;

/* ----------------------------------------------------------------------------
   -- NV Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Masks NV Register Masks
 * @{
 */

/*! @name BACKKEY3 - Backdoor Comparison Key 3. */
/*! @{ */
#define NV_BACKKEY3_KEY_MASK                     (0xFFU)
#define NV_BACKKEY3_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY3_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY3_KEY_SHIFT)) & NV_BACKKEY3_KEY_MASK)
/*! @} */

/*! @name BACKKEY2 - Backdoor Comparison Key 2. */
/*! @{ */
#define NV_BACKKEY2_KEY_MASK                     (0xFFU)
#define NV_BACKKEY2_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY2_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY2_KEY_SHIFT)) & NV_BACKKEY2_KEY_MASK)
/*! @} */

/*! @name BACKKEY1 - Backdoor Comparison Key 1. */
/*! @{ */
#define NV_BACKKEY1_KEY_MASK                     (0xFFU)
#define NV_BACKKEY1_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY1_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY1_KEY_SHIFT)) & NV_BACKKEY1_KEY_MASK)
/*! @} */

/*! @name BACKKEY0 - Backdoor Comparison Key 0. */
/*! @{ */
#define NV_BACKKEY0_KEY_MASK                     (0xFFU)
#define NV_BACKKEY0_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY0_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY0_KEY_SHIFT)) & NV_BACKKEY0_KEY_MASK)
/*! @} */

/*! @name BACKKEY7 - Backdoor Comparison Key 7. */
/*! @{ */
#define NV_BACKKEY7_KEY_MASK                     (0xFFU)
#define NV_BACKKEY7_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY7_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY7_KEY_SHIFT)) & NV_BACKKEY7_KEY_MASK)
/*! @} */

/*! @name BACKKEY6 - Backdoor Comparison Key 6. */
/*! @{ */
#define NV_BACKKEY6_KEY_MASK                     (0xFFU)
#define NV_BACKKEY6_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY6_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY6_KEY_SHIFT)) & NV_BACKKEY6_KEY_MASK)
/*! @} */

/*! @name BACKKEY5 - Backdoor Comparison Key 5. */
/*! @{ */
#define NV_BACKKEY5_KEY_MASK                     (0xFFU)
#define NV_BACKKEY5_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY5_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY5_KEY_SHIFT)) & NV_BACKKEY5_KEY_MASK)
/*! @} */

/*! @name BACKKEY4 - Backdoor Comparison Key 4. */
/*! @{ */
#define NV_BACKKEY4_KEY_MASK                     (0xFFU)
#define NV_BACKKEY4_KEY_SHIFT                    (0U)
/*! KEY - Backdoor Comparison Key.
 */
#define NV_BACKKEY4_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY4_KEY_SHIFT)) & NV_BACKKEY4_KEY_MASK)
/*! @} */

/*! @name FPROT3 - Non-volatile P-Flash Protection 1 - Low Register */
/*! @{ */
#define NV_FPROT3_PROT_MASK                      (0xFFU)
#define NV_FPROT3_PROT_SHIFT                     (0U)
/*! PROT - P-Flash Region Protect
 */
#define NV_FPROT3_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT3_PROT_SHIFT)) & NV_FPROT3_PROT_MASK)
/*! @} */

/*! @name FPROT2 - Non-volatile P-Flash Protection 1 - High Register */
/*! @{ */
#define NV_FPROT2_PROT_MASK                      (0xFFU)
#define NV_FPROT2_PROT_SHIFT                     (0U)
/*! PROT - P-Flash Region Protect
 */
#define NV_FPROT2_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT2_PROT_SHIFT)) & NV_FPROT2_PROT_MASK)
/*! @} */

/*! @name FPROT1 - Non-volatile P-Flash Protection 0 - Low Register */
/*! @{ */
#define NV_FPROT1_PROT_MASK                      (0xFFU)
#define NV_FPROT1_PROT_SHIFT                     (0U)
/*! PROT - P-Flash Region Protect
 */
#define NV_FPROT1_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT1_PROT_SHIFT)) & NV_FPROT1_PROT_MASK)
/*! @} */

/*! @name FPROT0 - Non-volatile P-Flash Protection 0 - High Register */
/*! @{ */
#define NV_FPROT0_PROT_MASK                      (0xFFU)
#define NV_FPROT0_PROT_SHIFT                     (0U)
/*! PROT - P-Flash Region Protect
 */
#define NV_FPROT0_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT0_PROT_SHIFT)) & NV_FPROT0_PROT_MASK)
/*! @} */

/*! @name FSEC - Non-volatile Flash Security Register */
/*! @{ */
#define NV_FSEC_SEC_MASK                         (0x3U)
#define NV_FSEC_SEC_SHIFT                        (0U)
/*! SEC - Flash Security
 *  0b10..MCU security status is unsecure
 *  0b11..MCU security status is secure
 */
#define NV_FSEC_SEC(x)                           (((uint8_t)(((uint8_t)(x)) << NV_FSEC_SEC_SHIFT)) & NV_FSEC_SEC_MASK)
#define NV_FSEC_FSLACC_MASK                      (0xCU)
#define NV_FSEC_FSLACC_SHIFT                     (2U)
/*! FSLACC - Freescale Failure Analysis Access Code
 *  0b10..Freescale factory access denied
 *  0b11..Freescale factory access granted
 */
#define NV_FSEC_FSLACC(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FSEC_FSLACC_SHIFT)) & NV_FSEC_FSLACC_MASK)
#define NV_FSEC_MEEN_MASK                        (0x30U)
#define NV_FSEC_MEEN_SHIFT                       (4U)
/*! MEEN
 *  0b10..Mass erase is disabled
 *  0b11..Mass erase is enabled
 */
#define NV_FSEC_MEEN(x)                          (((uint8_t)(((uint8_t)(x)) << NV_FSEC_MEEN_SHIFT)) & NV_FSEC_MEEN_MASK)
#define NV_FSEC_KEYEN_MASK                       (0xC0U)
#define NV_FSEC_KEYEN_SHIFT                      (6U)
/*! KEYEN - Backdoor Key Security Enable
 *  0b10..Backdoor key access enabled
 *  0b11..Backdoor key access disabled
 */
#define NV_FSEC_KEYEN(x)                         (((uint8_t)(((uint8_t)(x)) << NV_FSEC_KEYEN_SHIFT)) & NV_FSEC_KEYEN_MASK)
/*! @} */

/*! @name FOPT - Non-volatile Flash Option Register */
/*! @{ */
#define NV_FOPT_LPBOOT0_MASK                     (0x1U)
#define NV_FOPT_LPBOOT0_SHIFT                    (0U)
/*! LPBOOT0
 *  0b0..Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT1=0 or 0x1 (divide by 2) when LPBOOT1=1.
 *  0b1..Core and system clock divider (OUTDIV1) is 0x3 (divide by 4) when LPBOOT1=0 or 0x0 (divide by 1) when LPBOOT1=1.
 */
#define NV_FOPT_LPBOOT0(x)                       (((uint8_t)(((uint8_t)(x)) << NV_FOPT_LPBOOT0_SHIFT)) & NV_FOPT_LPBOOT0_MASK)
#define NV_FOPT_NMI_DIS_MASK                     (0x4U)
#define NV_FOPT_NMI_DIS_SHIFT                    (2U)
/*! NMI_DIS
 *  0b0..NMI interrupts are always blocked
 *  0b1..NMI_b pin/interrupts reset default to enabled
 */
#define NV_FOPT_NMI_DIS(x)                       (((uint8_t)(((uint8_t)(x)) << NV_FOPT_NMI_DIS_SHIFT)) & NV_FOPT_NMI_DIS_MASK)
#define NV_FOPT_RESET_PIN_CFG_MASK               (0x8U)
#define NV_FOPT_RESET_PIN_CFG_SHIFT              (3U)
/*! RESET_PIN_CFG
 *  0b0..RESET pin is disabled following a POR and cannot be enabled as reset function
 *  0b1..RESET_b pin is dedicated
 */
#define NV_FOPT_RESET_PIN_CFG(x)                 (((uint8_t)(((uint8_t)(x)) << NV_FOPT_RESET_PIN_CFG_SHIFT)) & NV_FOPT_RESET_PIN_CFG_MASK)
#define NV_FOPT_LPBOOT1_MASK                     (0x10U)
#define NV_FOPT_LPBOOT1_SHIFT                    (4U)
/*! LPBOOT1
 *  0b0..Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT0=0 or 0x3 (divide by 4) when LPBOOT0=1.
 *  0b1..Core and system clock divider (OUTDIV1) is 0x1 (divide by 2) when LPBOOT0=0 or 0x0 (divide by 1) when LPBOOT0=1.
 */
#define NV_FOPT_LPBOOT1(x)                       (((uint8_t)(((uint8_t)(x)) << NV_FOPT_LPBOOT1_SHIFT)) & NV_FOPT_LPBOOT1_MASK)
/*! @} */

/*! @name FEPROT - Non-volatile EERAM Protection Register */
/*! @{ */
#define NV_FEPROT_EPROT_MASK                     (0xFFU)
#define NV_FEPROT_EPROT_SHIFT                    (0U)
#define NV_FEPROT_EPROT(x)                       (((uint8_t)(((uint8_t)(x)) << NV_FEPROT_EPROT_SHIFT)) & NV_FEPROT_EPROT_MASK)
/*! @} */

/*! @name FDPROT - Non-volatile D-Flash Protection Register */
/*! @{ */
#define NV_FDPROT_DPROT_MASK                     (0xFFU)
#define NV_FDPROT_DPROT_SHIFT                    (0U)
/*! DPROT - D-Flash Region Protect
 */
#define NV_FDPROT_DPROT(x)                       (((uint8_t)(((uint8_t)(x)) << NV_FDPROT_DPROT_SHIFT)) & NV_FDPROT_DPROT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group NV_Register_Masks */


/* NV - Peripheral instance base addresses */
/** Peripheral FTFE_FlashConfig base address */
#define FTFE_FlashConfig_BASE                    (0x400u)
/** Peripheral FTFE_FlashConfig base pointer */
#define FTFE_FlashConfig                         ((NV_Type *)FTFE_FlashConfig_BASE)
/** Array initializer of NV peripheral base addresses */
#define NV_BASE_ADDRS                            { FTFE_FlashConfig_BASE }
/** Array initializer of NV peripheral base pointers */
#define NV_BASE_PTRS                             { FTFE_FlashConfig }

/*!
 * @}
 */ /* end of group NV_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PFLEXNVM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PFLEXNVM_Peripheral_Access_Layer PFLEXNVM Peripheral Access Layer
 * @{
 */

/** PFLEXNVM - Register Layout Typedef */
typedef struct {
  __IO uint32_t PFAPR;                             /**< Flash Access Protection Register, offset: 0x0 */
  __IO uint32_t PFB0CR;                            /**< Flash Bank 0 Control Register, offset: 0x4 */
  __IO uint32_t RESERVED_PFB1CR;                   /**< Reserved Flash Bank 1 Control Register, offset: 0x8 */
       uint8_t RESERVED_0[372];
  __IO uint32_t TAGVDW0S[4];                       /**< Cache Tag Storage, array offset: 0x180, array step: 0x4 */
  __IO uint32_t TAGVDW1S[4];                       /**< Cache Tag Storage, array offset: 0x190, array step: 0x4 */
  __IO uint32_t TAGVDW2S[4];                       /**< Cache Tag Storage, array offset: 0x1A0, array step: 0x4 */
  __IO uint32_t TAGVDW3S[4];                       /**< Cache Tag Storage, array offset: 0x1B0, array step: 0x4 */
       uint8_t RESERVED_1[320];
  __IO uint32_t DATAW0S0U;                         /**< Cache Data Storage (upper word), offset: 0x300 */
  __IO uint32_t DATAW0S0L;                         /**< Cache Data Storage (lower word), offset: 0x304 */
  __IO uint32_t DATAW0S1U;                         /**< Cache Data Storage (upper word), offset: 0x308 */
  __IO uint32_t DATAW0S1L;                         /**< Cache Data Storage (lower word), offset: 0x30C */
  __IO uint32_t DATAW0S2U;                         /**< Cache Data Storage (upper word), offset: 0x310 */
  __IO uint32_t DATAW0S2L;                         /**< Cache Data Storage (lower word), offset: 0x314 */
  __IO uint32_t DATAW0S3U;                         /**< Cache Data Storage (upper word), offset: 0x318 */
  __IO uint32_t DATAW0S3L;                         /**< Cache Data Storage (lower word), offset: 0x31C */
  __IO uint32_t DATAW1S0U;                         /**< Cache Data Storage (upper word), offset: 0x320 */
  __IO uint32_t DATAW1S0L;                         /**< Cache Data Storage (lower word), offset: 0x324 */
  __IO uint32_t DATAW1S1U;                         /**< Cache Data Storage (upper word), offset: 0x328 */
  __IO uint32_t DATAW1S1L;                         /**< Cache Data Storage (lower word), offset: 0x32C */
  __IO uint32_t DATAW1S2U;                         /**< Cache Data Storage (upper word), offset: 0x330 */
  __IO uint32_t DATAW1S2L;                         /**< Cache Data Storage (lower word), offset: 0x334 */
  __IO uint32_t DATAW1S3U;                         /**< Cache Data Storage (upper word), offset: 0x338 */
  __IO uint32_t DATAW1S3L;                         /**< Cache Data Storage (lower word), offset: 0x33C */
  __IO uint32_t DATAW2S0U;                         /**< Cache Data Storage (upper word), offset: 0x340 */
  __IO uint32_t DATAW2S0L;                         /**< Cache Data Storage (lower word), offset: 0x344 */
  __IO uint32_t DATAW2S1U;                         /**< Cache Data Storage (upper word), offset: 0x348 */
  __IO uint32_t DATAW2S1L;                         /**< Cache Data Storage (lower word), offset: 0x34C */
  __IO uint32_t DATAW2S2U;                         /**< Cache Data Storage (upper word), offset: 0x350 */
  __IO uint32_t DATAW2S2L;                         /**< Cache Data Storage (lower word), offset: 0x354 */
  __IO uint32_t DATAW2S3U;                         /**< Cache Data Storage (upper word), offset: 0x358 */
  __IO uint32_t DATAW2S3L;                         /**< Cache Data Storage (lower word), offset: 0x35C */
  __IO uint32_t DATAW3S0U;                         /**< Cache Data Storage (upper word), offset: 0x360 */
  __IO uint32_t DATAW3S0L;                         /**< Cache Data Storage (lower word), offset: 0x364 */
  __IO uint32_t DATAW3S1U;                         /**< Cache Data Storage (upper word), offset: 0x368 */
  __IO uint32_t DATAW3S1L;                         /**< Cache Data Storage (lower word), offset: 0x36C */
  __IO uint32_t DATAW3S2U;                         /**< Cache Data Storage (upper word), offset: 0x370 */
  __IO uint32_t DATAW3S2L;                         /**< Cache Data Storage (lower word), offset: 0x374 */
  __IO uint32_t DATAW3S3U;                         /**< Cache Data Storage (upper word), offset: 0x378 */
  __IO uint32_t DATAW3S3L;                         /**< Cache Data Storage (lower word), offset: 0x37C */
} PFLEXNVM_Type;

/* ----------------------------------------------------------------------------
   -- PFLEXNVM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PFLEXNVM_Register_Masks PFLEXNVM Register Masks
 * @{
 */

/*! @name PFAPR - Flash Access Protection Register */
/*! @{ */
#define PFLEXNVM_PFAPR_M0AP_MASK                 (0x3U)
#define PFLEXNVM_PFAPR_M0AP_SHIFT                (0U)
/*! M0AP - Master 0 Access Protection
 *  0b00..No access may be performed by this master
 *  0b01..Only read accesses may be performed by this master
 *  0b10..Only write accesses may be performed by this master
 *  0b11..Both read and write accesses may be performed by this master
 */
#define PFLEXNVM_PFAPR_M0AP(x)                   (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M0AP_SHIFT)) & PFLEXNVM_PFAPR_M0AP_MASK)
#define PFLEXNVM_PFAPR_M1AP_MASK                 (0xCU)
#define PFLEXNVM_PFAPR_M1AP_SHIFT                (2U)
/*! M1AP - Master 1 Access Protection
 *  0b00..No access may be performed by this master
 *  0b01..Only read accesses may be performed by this master
 *  0b10..Only write accesses may be performed by this master
 *  0b11..Both read and write accesses may be performed by this master
 */
#define PFLEXNVM_PFAPR_M1AP(x)                   (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M1AP_SHIFT)) & PFLEXNVM_PFAPR_M1AP_MASK)
#define PFLEXNVM_PFAPR_M2AP_MASK                 (0x30U)
#define PFLEXNVM_PFAPR_M2AP_SHIFT                (4U)
/*! M2AP - Master 2 Access Protection
 *  0b00..No access may be performed by this master
 *  0b01..Only read accesses may be performed by this master
 *  0b10..Only write accesses may be performed by this master
 *  0b11..Both read and write accesses may be performed by this master
 */
#define PFLEXNVM_PFAPR_M2AP(x)                   (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M2AP_SHIFT)) & PFLEXNVM_PFAPR_M2AP_MASK)
#define PFLEXNVM_PFAPR_M0PFD_MASK                (0x10000U)
#define PFLEXNVM_PFAPR_M0PFD_SHIFT               (16U)
/*! M0PFD - Master 0 Prefetch Disable
 *  0b0..Prefetching for this master is enabled.
 *  0b1..Prefetching for this master is disabled.
 */
#define PFLEXNVM_PFAPR_M0PFD(x)                  (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M0PFD_SHIFT)) & PFLEXNVM_PFAPR_M0PFD_MASK)
#define PFLEXNVM_PFAPR_M1PFD_MASK                (0x20000U)
#define PFLEXNVM_PFAPR_M1PFD_SHIFT               (17U)
/*! M1PFD - Master 1 Prefetch Disable
 *  0b0..Prefetching for this master is enabled.
 *  0b1..Prefetching for this master is disabled.
 */
#define PFLEXNVM_PFAPR_M1PFD(x)                  (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M1PFD_SHIFT)) & PFLEXNVM_PFAPR_M1PFD_MASK)
#define PFLEXNVM_PFAPR_M2PFD_MASK                (0x40000U)
#define PFLEXNVM_PFAPR_M2PFD_SHIFT               (18U)
/*! M2PFD - Master 2 Prefetch Disable
 *  0b0..Prefetching for this master is enabled.
 *  0b1..Prefetching for this master is disabled.
 */
#define PFLEXNVM_PFAPR_M2PFD(x)                  (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFAPR_M2PFD_SHIFT)) & PFLEXNVM_PFAPR_M2PFD_MASK)
/*! @} */

/*! @name PFB0CR - Flash Bank 0 Control Register */
/*! @{ */
#define PFLEXNVM_PFB0CR_B0SEBE_MASK              (0x1U)
#define PFLEXNVM_PFB0CR_B0SEBE_SHIFT             (0U)
/*! B0SEBE - Bank 0 Single Entry Buffer Enable
 *  0b0..Single entry buffer is disabled.
 *  0b1..Single entry buffer is enabled.
 */
#define PFLEXNVM_PFB0CR_B0SEBE(x)                (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0SEBE_SHIFT)) & PFLEXNVM_PFB0CR_B0SEBE_MASK)
#define PFLEXNVM_PFB0CR_B0IPE_MASK               (0x2U)
#define PFLEXNVM_PFB0CR_B0IPE_SHIFT              (1U)
/*! B0IPE - Bank 0 Instruction Prefetch Enable
 *  0b0..Do not prefetch in response to instruction fetches.
 *  0b1..Enable prefetches in response to instruction fetches.
 */
#define PFLEXNVM_PFB0CR_B0IPE(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0IPE_SHIFT)) & PFLEXNVM_PFB0CR_B0IPE_MASK)
#define PFLEXNVM_PFB0CR_B0DPE_MASK               (0x4U)
#define PFLEXNVM_PFB0CR_B0DPE_SHIFT              (2U)
/*! B0DPE - Bank 0 Data Prefetch Enable
 *  0b0..Do not prefetch in response to data references.
 *  0b1..Enable prefetches in response to data references.
 */
#define PFLEXNVM_PFB0CR_B0DPE(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0DPE_SHIFT)) & PFLEXNVM_PFB0CR_B0DPE_MASK)
#define PFLEXNVM_PFB0CR_B0ICE_MASK               (0x8U)
#define PFLEXNVM_PFB0CR_B0ICE_SHIFT              (3U)
/*! B0ICE - Bank 0 Instruction Cache Enable
 *  0b0..Do not cache instruction fetches.
 *  0b1..Cache instruction fetches.
 */
#define PFLEXNVM_PFB0CR_B0ICE(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0ICE_SHIFT)) & PFLEXNVM_PFB0CR_B0ICE_MASK)
#define PFLEXNVM_PFB0CR_B0DCE_MASK               (0x10U)
#define PFLEXNVM_PFB0CR_B0DCE_SHIFT              (4U)
/*! B0DCE - Bank 0 Data Cache Enable
 *  0b0..Do not cache data references.
 *  0b1..Cache data references.
 */
#define PFLEXNVM_PFB0CR_B0DCE(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0DCE_SHIFT)) & PFLEXNVM_PFB0CR_B0DCE_MASK)
#define PFLEXNVM_PFB0CR_CRC_MASK                 (0xE0U)
#define PFLEXNVM_PFB0CR_CRC_SHIFT                (5U)
/*! CRC - Cache Replacement Control
 *  0b000..LRU replacement algorithm per set across all four ways
 *  0b001..Reserved
 *  0b010..Independent LRU with ways [0-1] for ifetches, [2-3] for data
 *  0b011..Independent LRU with ways [0-2] for ifetches, [3] for data
 *  0b1xx..Reserved
 */
#define PFLEXNVM_PFB0CR_CRC(x)                   (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_CRC_SHIFT)) & PFLEXNVM_PFB0CR_CRC_MASK)
#define PFLEXNVM_PFB0CR_B0MW_MASK                (0x60000U)
#define PFLEXNVM_PFB0CR_B0MW_SHIFT               (17U)
/*! B0MW - Bank 0 Memory Width
 *  0b00..32 bits
 *  0b01..64 bits
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define PFLEXNVM_PFB0CR_B0MW(x)                  (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0MW_SHIFT)) & PFLEXNVM_PFB0CR_B0MW_MASK)
#define PFLEXNVM_PFB0CR_S_B_INV_MASK             (0x80000U)
#define PFLEXNVM_PFB0CR_S_B_INV_SHIFT            (19U)
/*! S_B_INV - Invalidate Prefetch Speculation Buffer
 *  0b0..Speculation buffer and single entry buffer are not affected.
 *  0b1..Invalidate (clear) speculation buffer and single entry buffer.
 */
#define PFLEXNVM_PFB0CR_S_B_INV(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_S_B_INV_SHIFT)) & PFLEXNVM_PFB0CR_S_B_INV_MASK)
#define PFLEXNVM_PFB0CR_CINV_WAY_MASK            (0xF00000U)
#define PFLEXNVM_PFB0CR_CINV_WAY_SHIFT           (20U)
/*! CINV_WAY - Cache Invalidate Way x
 *  0b0000..No cache way invalidation for the corresponding cache
 *  0b0001..Invalidate cache way for the corresponding cache: clear the tag, data, and vld bits of ways selected
 */
#define PFLEXNVM_PFB0CR_CINV_WAY(x)              (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_CINV_WAY_SHIFT)) & PFLEXNVM_PFB0CR_CINV_WAY_MASK)
#define PFLEXNVM_PFB0CR_CLCK_WAY_MASK            (0xF000000U)
#define PFLEXNVM_PFB0CR_CLCK_WAY_SHIFT           (24U)
/*! CLCK_WAY - Cache Lock Way x
 *  0b0000..Cache way is unlocked and may be displaced
 *  0b0001..Cache way is locked and its contents are not displaced
 */
#define PFLEXNVM_PFB0CR_CLCK_WAY(x)              (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_CLCK_WAY_SHIFT)) & PFLEXNVM_PFB0CR_CLCK_WAY_MASK)
#define PFLEXNVM_PFB0CR_B0RWSC_MASK              (0xF0000000U)
#define PFLEXNVM_PFB0CR_B0RWSC_SHIFT             (28U)
/*! B0RWSC - Bank 0 Read Wait State Control
 */
#define PFLEXNVM_PFB0CR_B0RWSC(x)                (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_PFB0CR_B0RWSC_SHIFT)) & PFLEXNVM_PFB0CR_B0RWSC_MASK)
/*! @} */

/*! @name RESERVED_PFB1CR - Reserved Flash Bank 1 Control Register */
/*! @{ */
#define PFLEXNVM_RESERVED_PFB1CR_B1SEBE_MASK     (0x1U)
#define PFLEXNVM_RESERVED_PFB1CR_B1SEBE_SHIFT    (0U)
/*! B1SEBE - Bank 1 Single Entry Buffer Enable
 *  0b0..Single entry buffer is disabled.
 *  0b1..Single entry buffer is enabled.
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1SEBE(x)       (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1SEBE_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1SEBE_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1IPE_MASK      (0x2U)
#define PFLEXNVM_RESERVED_PFB1CR_B1IPE_SHIFT     (1U)
/*! B1IPE - Bank 1 Instruction Prefetch Enable
 *  0b0..Do not prefetch in response to instruction fetches.
 *  0b1..Enable prefetches in response to instruction fetches.
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1IPE(x)        (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1IPE_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1IPE_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1DPE_MASK      (0x4U)
#define PFLEXNVM_RESERVED_PFB1CR_B1DPE_SHIFT     (2U)
/*! B1DPE - Bank 1 Data Prefetch Enable
 *  0b0..Do not prefetch in response to data references.
 *  0b1..Enable prefetches in response to data references.
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1DPE(x)        (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1DPE_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1DPE_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1ICE_MASK      (0x8U)
#define PFLEXNVM_RESERVED_PFB1CR_B1ICE_SHIFT     (3U)
/*! B1ICE - Bank 1 Instruction Cache Enable
 *  0b0..Do not cache instruction fetches.
 *  0b1..Cache instruction fetches.
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1ICE(x)        (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1ICE_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1ICE_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1DCE_MASK      (0x10U)
#define PFLEXNVM_RESERVED_PFB1CR_B1DCE_SHIFT     (4U)
/*! B1DCE - Bank 1 Data Cache Enable
 *  0b0..Do not cache data references.
 *  0b1..Cache data references.
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1DCE(x)        (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1DCE_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1DCE_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1MW_MASK       (0x60000U)
#define PFLEXNVM_RESERVED_PFB1CR_B1MW_SHIFT      (17U)
/*! B1MW - Bank 1 Memory Width
 *  0b00..32 bits
 *  0b01..64 bits
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1MW(x)         (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1MW_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1MW_MASK)
#define PFLEXNVM_RESERVED_PFB1CR_B1RWSC_MASK     (0xF0000000U)
#define PFLEXNVM_RESERVED_PFB1CR_B1RWSC_SHIFT    (28U)
/*! B1RWSC - Bank 1 Read Wait State Control
 */
#define PFLEXNVM_RESERVED_PFB1CR_B1RWSC(x)       (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_RESERVED_PFB1CR_B1RWSC_SHIFT)) & PFLEXNVM_RESERVED_PFB1CR_B1RWSC_MASK)
/*! @} */

/*! @name TAGVDW0S - Cache Tag Storage */
/*! @{ */
#define PFLEXNVM_TAGVDW0S_valid_MASK             (0x1U)
#define PFLEXNVM_TAGVDW0S_valid_SHIFT            (0U)
/*! valid - 1-bit valid for cache entry
 */
#define PFLEXNVM_TAGVDW0S_valid(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW0S_valid_SHIFT)) & PFLEXNVM_TAGVDW0S_valid_MASK)
#define PFLEXNVM_TAGVDW0S_tag_MASK               (0x7FFC0U)
#define PFLEXNVM_TAGVDW0S_tag_SHIFT              (6U)
/*! tag - 13-bit tag for cache entry
 */
#define PFLEXNVM_TAGVDW0S_tag(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW0S_tag_SHIFT)) & PFLEXNVM_TAGVDW0S_tag_MASK)
/*! @} */

/* The count of PFLEXNVM_TAGVDW0S */
#define PFLEXNVM_TAGVDW0S_COUNT                  (4U)

/*! @name TAGVDW1S - Cache Tag Storage */
/*! @{ */
#define PFLEXNVM_TAGVDW1S_valid_MASK             (0x1U)
#define PFLEXNVM_TAGVDW1S_valid_SHIFT            (0U)
/*! valid - 1-bit valid for cache entry
 */
#define PFLEXNVM_TAGVDW1S_valid(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW1S_valid_SHIFT)) & PFLEXNVM_TAGVDW1S_valid_MASK)
#define PFLEXNVM_TAGVDW1S_tag_MASK               (0x7FFC0U)
#define PFLEXNVM_TAGVDW1S_tag_SHIFT              (6U)
/*! tag - 13-bit tag for cache entry
 */
#define PFLEXNVM_TAGVDW1S_tag(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW1S_tag_SHIFT)) & PFLEXNVM_TAGVDW1S_tag_MASK)
/*! @} */

/* The count of PFLEXNVM_TAGVDW1S */
#define PFLEXNVM_TAGVDW1S_COUNT                  (4U)

/*! @name TAGVDW2S - Cache Tag Storage */
/*! @{ */
#define PFLEXNVM_TAGVDW2S_valid_MASK             (0x1U)
#define PFLEXNVM_TAGVDW2S_valid_SHIFT            (0U)
/*! valid - 1-bit valid for cache entry
 */
#define PFLEXNVM_TAGVDW2S_valid(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW2S_valid_SHIFT)) & PFLEXNVM_TAGVDW2S_valid_MASK)
#define PFLEXNVM_TAGVDW2S_tag_MASK               (0x7FFC0U)
#define PFLEXNVM_TAGVDW2S_tag_SHIFT              (6U)
/*! tag - 13-bit tag for cache entry
 */
#define PFLEXNVM_TAGVDW2S_tag(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW2S_tag_SHIFT)) & PFLEXNVM_TAGVDW2S_tag_MASK)
/*! @} */

/* The count of PFLEXNVM_TAGVDW2S */
#define PFLEXNVM_TAGVDW2S_COUNT                  (4U)

/*! @name TAGVDW3S - Cache Tag Storage */
/*! @{ */
#define PFLEXNVM_TAGVDW3S_valid_MASK             (0x1U)
#define PFLEXNVM_TAGVDW3S_valid_SHIFT            (0U)
/*! valid - 1-bit valid for cache entry
 */
#define PFLEXNVM_TAGVDW3S_valid(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW3S_valid_SHIFT)) & PFLEXNVM_TAGVDW3S_valid_MASK)
#define PFLEXNVM_TAGVDW3S_tag_MASK               (0x7FFC0U)
#define PFLEXNVM_TAGVDW3S_tag_SHIFT              (6U)
/*! tag - 13-bit tag for cache entry
 */
#define PFLEXNVM_TAGVDW3S_tag(x)                 (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_TAGVDW3S_tag_SHIFT)) & PFLEXNVM_TAGVDW3S_tag_MASK)
/*! @} */

/* The count of PFLEXNVM_TAGVDW3S */
#define PFLEXNVM_TAGVDW3S_COUNT                  (4U)

/*! @name DATAW0S0U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW0S0U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S0U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW0S0U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S0U_data_SHIFT)) & PFLEXNVM_DATAW0S0U_data_MASK)
/*! @} */

/*! @name DATAW0S0L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW0S0L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S0L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW0S0L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S0L_data_SHIFT)) & PFLEXNVM_DATAW0S0L_data_MASK)
/*! @} */

/*! @name DATAW0S1U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW0S1U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S1U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW0S1U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S1U_data_SHIFT)) & PFLEXNVM_DATAW0S1U_data_MASK)
/*! @} */

/*! @name DATAW0S1L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW0S1L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S1L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW0S1L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S1L_data_SHIFT)) & PFLEXNVM_DATAW0S1L_data_MASK)
/*! @} */

/*! @name DATAW0S2U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW0S2U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S2U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW0S2U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S2U_data_SHIFT)) & PFLEXNVM_DATAW0S2U_data_MASK)
/*! @} */

/*! @name DATAW0S2L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW0S2L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S2L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW0S2L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S2L_data_SHIFT)) & PFLEXNVM_DATAW0S2L_data_MASK)
/*! @} */

/*! @name DATAW0S3U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW0S3U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S3U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW0S3U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S3U_data_SHIFT)) & PFLEXNVM_DATAW0S3U_data_MASK)
/*! @} */

/*! @name DATAW0S3L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW0S3L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW0S3L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW0S3L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW0S3L_data_SHIFT)) & PFLEXNVM_DATAW0S3L_data_MASK)
/*! @} */

/*! @name DATAW1S0U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW1S0U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S0U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW1S0U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S0U_data_SHIFT)) & PFLEXNVM_DATAW1S0U_data_MASK)
/*! @} */

/*! @name DATAW1S0L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW1S0L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S0L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW1S0L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S0L_data_SHIFT)) & PFLEXNVM_DATAW1S0L_data_MASK)
/*! @} */

/*! @name DATAW1S1U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW1S1U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S1U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW1S1U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S1U_data_SHIFT)) & PFLEXNVM_DATAW1S1U_data_MASK)
/*! @} */

/*! @name DATAW1S1L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW1S1L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S1L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW1S1L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S1L_data_SHIFT)) & PFLEXNVM_DATAW1S1L_data_MASK)
/*! @} */

/*! @name DATAW1S2U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW1S2U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S2U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW1S2U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S2U_data_SHIFT)) & PFLEXNVM_DATAW1S2U_data_MASK)
/*! @} */

/*! @name DATAW1S2L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW1S2L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S2L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW1S2L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S2L_data_SHIFT)) & PFLEXNVM_DATAW1S2L_data_MASK)
/*! @} */

/*! @name DATAW1S3U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW1S3U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S3U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW1S3U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S3U_data_SHIFT)) & PFLEXNVM_DATAW1S3U_data_MASK)
/*! @} */

/*! @name DATAW1S3L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW1S3L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW1S3L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW1S3L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW1S3L_data_SHIFT)) & PFLEXNVM_DATAW1S3L_data_MASK)
/*! @} */

/*! @name DATAW2S0U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW2S0U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S0U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW2S0U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S0U_data_SHIFT)) & PFLEXNVM_DATAW2S0U_data_MASK)
/*! @} */

/*! @name DATAW2S0L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW2S0L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S0L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW2S0L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S0L_data_SHIFT)) & PFLEXNVM_DATAW2S0L_data_MASK)
/*! @} */

/*! @name DATAW2S1U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW2S1U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S1U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW2S1U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S1U_data_SHIFT)) & PFLEXNVM_DATAW2S1U_data_MASK)
/*! @} */

/*! @name DATAW2S1L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW2S1L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S1L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW2S1L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S1L_data_SHIFT)) & PFLEXNVM_DATAW2S1L_data_MASK)
/*! @} */

/*! @name DATAW2S2U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW2S2U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S2U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW2S2U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S2U_data_SHIFT)) & PFLEXNVM_DATAW2S2U_data_MASK)
/*! @} */

/*! @name DATAW2S2L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW2S2L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S2L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW2S2L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S2L_data_SHIFT)) & PFLEXNVM_DATAW2S2L_data_MASK)
/*! @} */

/*! @name DATAW2S3U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW2S3U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S3U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW2S3U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S3U_data_SHIFT)) & PFLEXNVM_DATAW2S3U_data_MASK)
/*! @} */

/*! @name DATAW2S3L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW2S3L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW2S3L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW2S3L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW2S3L_data_SHIFT)) & PFLEXNVM_DATAW2S3L_data_MASK)
/*! @} */

/*! @name DATAW3S0U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW3S0U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S0U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW3S0U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S0U_data_SHIFT)) & PFLEXNVM_DATAW3S0U_data_MASK)
/*! @} */

/*! @name DATAW3S0L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW3S0L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S0L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW3S0L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S0L_data_SHIFT)) & PFLEXNVM_DATAW3S0L_data_MASK)
/*! @} */

/*! @name DATAW3S1U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW3S1U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S1U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW3S1U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S1U_data_SHIFT)) & PFLEXNVM_DATAW3S1U_data_MASK)
/*! @} */

/*! @name DATAW3S1L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW3S1L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S1L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW3S1L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S1L_data_SHIFT)) & PFLEXNVM_DATAW3S1L_data_MASK)
/*! @} */

/*! @name DATAW3S2U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW3S2U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S2U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW3S2U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S2U_data_SHIFT)) & PFLEXNVM_DATAW3S2U_data_MASK)
/*! @} */

/*! @name DATAW3S2L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW3S2L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S2L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW3S2L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S2L_data_SHIFT)) & PFLEXNVM_DATAW3S2L_data_MASK)
/*! @} */

/*! @name DATAW3S3U - Cache Data Storage (upper word) */
/*! @{ */
#define PFLEXNVM_DATAW3S3U_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S3U_data_SHIFT            (0U)
/*! data - Bits [63:32] of data entry
 */
#define PFLEXNVM_DATAW3S3U_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S3U_data_SHIFT)) & PFLEXNVM_DATAW3S3U_data_MASK)
/*! @} */

/*! @name DATAW3S3L - Cache Data Storage (lower word) */
/*! @{ */
#define PFLEXNVM_DATAW3S3L_data_MASK             (0xFFFFFFFFU)
#define PFLEXNVM_DATAW3S3L_data_SHIFT            (0U)
/*! data - Bits [31:0] of data entry
 */
#define PFLEXNVM_DATAW3S3L_data(x)               (((uint32_t)(((uint32_t)(x)) << PFLEXNVM_DATAW3S3L_data_SHIFT)) & PFLEXNVM_DATAW3S3L_data_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PFLEXNVM_Register_Masks */


/* PFLEXNVM - Peripheral instance base addresses */
/** Peripheral PFLEXNVM base address */
#define PFLEXNVM_BASE                            (0x4001F000u)
/** Peripheral PFLEXNVM base pointer */
#define PFLEXNVM                                 ((PFLEXNVM_Type *)PFLEXNVM_BASE)
/** Array initializer of PFLEXNVM peripheral base addresses */
#define PFLEXNVM_BASE_ADDRS                      { PFLEXNVM_BASE }
/** Array initializer of PFLEXNVM peripheral base pointers */
#define PFLEXNVM_BASE_PTRS                       { PFLEXNVM }

/*!
 * @}
 */ /* end of group PFLEXNVM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PIT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Peripheral_Access_Layer PIT Peripheral Access Layer
 * @{
 */

/** PIT - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< PIT Module Control Register, offset: 0x0 */
       uint8_t RESERVED_0[220];
  __I  uint32_t LTMR64H;                           /**< PIT Upper Lifetime Timer Register, offset: 0xE0 */
  __I  uint32_t LTMR64L;                           /**< PIT Lower Lifetime Timer Register, offset: 0xE4 */
       uint8_t RESERVED_1[24];
  struct {                                         /* offset: 0x100, array step: 0x10 */
    __IO uint32_t LDVAL;                             /**< Timer Load Value Register, array offset: 0x100, array step: 0x10 */
    __I  uint32_t CVAL;                              /**< Current Timer Value Register, array offset: 0x104, array step: 0x10 */
    __IO uint32_t TCTRL;                             /**< Timer Control Register, array offset: 0x108, array step: 0x10 */
    __IO uint32_t TFLG;                              /**< Timer Flag Register, array offset: 0x10C, array step: 0x10 */
  } CHANNEL[2];
} PIT_Type;

/* ----------------------------------------------------------------------------
   -- PIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Masks PIT Register Masks
 * @{
 */

/*! @name MCR - PIT Module Control Register */
/*! @{ */
#define PIT_MCR_FRZ_MASK                         (0x1U)
#define PIT_MCR_FRZ_SHIFT                        (0U)
/*! FRZ - Freeze
 *  0b0..Timers continue to run in Debug mode.
 *  0b1..Timers are stopped in Debug mode.
 */
#define PIT_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << PIT_MCR_FRZ_SHIFT)) & PIT_MCR_FRZ_MASK)
#define PIT_MCR_MDIS_MASK                        (0x2U)
#define PIT_MCR_MDIS_SHIFT                       (1U)
/*! MDIS - Module Disable for PIT
 *  0b0..Clock for standard PIT timers is enabled.
 *  0b1..Clock for standard PIT timers is disabled.
 */
#define PIT_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << PIT_MCR_MDIS_SHIFT)) & PIT_MCR_MDIS_MASK)
/*! @} */

/*! @name LTMR64H - PIT Upper Lifetime Timer Register */
/*! @{ */
#define PIT_LTMR64H_LTH_MASK                     (0xFFFFFFFFU)
#define PIT_LTMR64H_LTH_SHIFT                    (0U)
/*! LTH - Life Timer value
 */
#define PIT_LTMR64H_LTH(x)                       (((uint32_t)(((uint32_t)(x)) << PIT_LTMR64H_LTH_SHIFT)) & PIT_LTMR64H_LTH_MASK)
/*! @} */

/*! @name LTMR64L - PIT Lower Lifetime Timer Register */
/*! @{ */
#define PIT_LTMR64L_LTL_MASK                     (0xFFFFFFFFU)
#define PIT_LTMR64L_LTL_SHIFT                    (0U)
/*! LTL - Life Timer value
 */
#define PIT_LTMR64L_LTL(x)                       (((uint32_t)(((uint32_t)(x)) << PIT_LTMR64L_LTL_SHIFT)) & PIT_LTMR64L_LTL_MASK)
/*! @} */

/*! @name LDVAL - Timer Load Value Register */
/*! @{ */
#define PIT_LDVAL_TSV_MASK                       (0xFFFFFFFFU)
#define PIT_LDVAL_TSV_SHIFT                      (0U)
/*! TSV - Timer Start Value
 */
#define PIT_LDVAL_TSV(x)                         (((uint32_t)(((uint32_t)(x)) << PIT_LDVAL_TSV_SHIFT)) & PIT_LDVAL_TSV_MASK)
/*! @} */

/* The count of PIT_LDVAL */
#define PIT_LDVAL_COUNT                          (2U)

/*! @name CVAL - Current Timer Value Register */
/*! @{ */
#define PIT_CVAL_TVL_MASK                        (0xFFFFFFFFU)
#define PIT_CVAL_TVL_SHIFT                       (0U)
/*! TVL - Current Timer Value
 */
#define PIT_CVAL_TVL(x)                          (((uint32_t)(((uint32_t)(x)) << PIT_CVAL_TVL_SHIFT)) & PIT_CVAL_TVL_MASK)
/*! @} */

/* The count of PIT_CVAL */
#define PIT_CVAL_COUNT                           (2U)

/*! @name TCTRL - Timer Control Register */
/*! @{ */
#define PIT_TCTRL_TEN_MASK                       (0x1U)
#define PIT_TCTRL_TEN_SHIFT                      (0U)
/*! TEN - Timer Enable
 *  0b0..Timer n is disabled.
 *  0b1..Timer n is enabled.
 */
#define PIT_TCTRL_TEN(x)                         (((uint32_t)(((uint32_t)(x)) << PIT_TCTRL_TEN_SHIFT)) & PIT_TCTRL_TEN_MASK)
#define PIT_TCTRL_TIE_MASK                       (0x2U)
#define PIT_TCTRL_TIE_SHIFT                      (1U)
/*! TIE - Timer Interrupt Enable
 *  0b0..Interrupt requests from Timer n are disabled.
 *  0b1..Interrupt is requested whenever TIF is set.
 */
#define PIT_TCTRL_TIE(x)                         (((uint32_t)(((uint32_t)(x)) << PIT_TCTRL_TIE_SHIFT)) & PIT_TCTRL_TIE_MASK)
#define PIT_TCTRL_CHN_MASK                       (0x4U)
#define PIT_TCTRL_CHN_SHIFT                      (2U)
/*! CHN - Chain Mode
 *  0b0..Timer is not chained.
 *  0b1..Timer is chained to a previous timer. For example, for channel 2, if this field is set, Timer 2 is chained to Timer 1.
 */
#define PIT_TCTRL_CHN(x)                         (((uint32_t)(((uint32_t)(x)) << PIT_TCTRL_CHN_SHIFT)) & PIT_TCTRL_CHN_MASK)
/*! @} */

/* The count of PIT_TCTRL */
#define PIT_TCTRL_COUNT                          (2U)

/*! @name TFLG - Timer Flag Register */
/*! @{ */
#define PIT_TFLG_TIF_MASK                        (0x1U)
#define PIT_TFLG_TIF_SHIFT                       (0U)
/*! TIF - Timer Interrupt Flag
 *  0b0..Timeout has not yet occurred.
 *  0b1..Timeout has occurred.
 */
#define PIT_TFLG_TIF(x)                          (((uint32_t)(((uint32_t)(x)) << PIT_TFLG_TIF_SHIFT)) & PIT_TFLG_TIF_MASK)
/*! @} */

/* The count of PIT_TFLG */
#define PIT_TFLG_COUNT                           (2U)


/*!
 * @}
 */ /* end of group PIT_Register_Masks */


/* PIT - Peripheral instance base addresses */
/** Peripheral PIT base address */
#define PIT_BASE                                 (0x40037000u)
/** Peripheral PIT base pointer */
#define PIT                                      ((PIT_Type *)PIT_BASE)
/** Array initializer of PIT peripheral base addresses */
#define PIT_BASE_ADDRS                           { PIT_BASE }
/** Array initializer of PIT peripheral base pointers */
#define PIT_BASE_PTRS                            { PIT }
/** Interrupt vectors for the PIT peripheral type */
#define PIT_IRQS                                 { { PIT_IRQn, PIT_IRQn } }

/*!
 * @}
 */ /* end of group PIT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Peripheral_Access_Layer PMC Peripheral Access Layer
 * @{
 */

/** PMC - Register Layout Typedef */
typedef struct {
  __IO uint8_t LVDSC1;                             /**< Low Voltage Detect Status And Control 1 register, offset: 0x0 */
  __IO uint8_t LVDSC2;                             /**< Low Voltage Detect Status And Control 2 register, offset: 0x1 */
  __IO uint8_t REGSC;                              /**< Regulator Status And Control register, offset: 0x2 */
} PMC_Type;

/* ----------------------------------------------------------------------------
   -- PMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Masks PMC Register Masks
 * @{
 */

/*! @name LVDSC1 - Low Voltage Detect Status And Control 1 register */
/*! @{ */
#define PMC_LVDSC1_LVDV_MASK                     (0x3U)
#define PMC_LVDSC1_LVDV_SHIFT                    (0U)
/*! LVDV - Low-Voltage Detect Voltage Select
 *  0b00..Low trip point selected (V LVD = V LVDL )
 *  0b01..High trip point selected (V LVD = V LVDH )
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define PMC_LVDSC1_LVDV(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDV_SHIFT)) & PMC_LVDSC1_LVDV_MASK)
#define PMC_LVDSC1_LVDRE_MASK                    (0x10U)
#define PMC_LVDSC1_LVDRE_SHIFT                   (4U)
/*! LVDRE - Low-Voltage Detect Reset Enable
 *  0b0..LVDF does not generate hardware resets
 *  0b1..Force an MCU reset when LVDF = 1
 */
#define PMC_LVDSC1_LVDRE(x)                      (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDRE_SHIFT)) & PMC_LVDSC1_LVDRE_MASK)
#define PMC_LVDSC1_LVDIE_MASK                    (0x20U)
#define PMC_LVDSC1_LVDIE_SHIFT                   (5U)
/*! LVDIE - Low-Voltage Detect Interrupt Enable
 *  0b0..Hardware interrupt disabled (use polling)
 *  0b1..Request a hardware interrupt when LVDF = 1
 */
#define PMC_LVDSC1_LVDIE(x)                      (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDIE_SHIFT)) & PMC_LVDSC1_LVDIE_MASK)
#define PMC_LVDSC1_LVDACK_MASK                   (0x40U)
#define PMC_LVDSC1_LVDACK_SHIFT                  (6U)
/*! LVDACK - Low-Voltage Detect Acknowledge
 */
#define PMC_LVDSC1_LVDACK(x)                     (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDACK_SHIFT)) & PMC_LVDSC1_LVDACK_MASK)
#define PMC_LVDSC1_LVDF_MASK                     (0x80U)
#define PMC_LVDSC1_LVDF_SHIFT                    (7U)
/*! LVDF - Low-Voltage Detect Flag
 *  0b0..Low-voltage event not detected
 *  0b1..Low-voltage event detected
 */
#define PMC_LVDSC1_LVDF(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDF_SHIFT)) & PMC_LVDSC1_LVDF_MASK)
/*! @} */

/*! @name LVDSC2 - Low Voltage Detect Status And Control 2 register */
/*! @{ */
#define PMC_LVDSC2_LVWV_MASK                     (0x3U)
#define PMC_LVDSC2_LVWV_SHIFT                    (0U)
/*! LVWV - Low-Voltage Warning Voltage Select
 *  0b00..Low trip point selected (VLVW = VLVW1)
 *  0b01..Mid 1 trip point selected (VLVW = VLVW2)
 *  0b10..Mid 2 trip point selected (VLVW = VLVW3)
 *  0b11..High trip point selected (VLVW = VLVW4)
 */
#define PMC_LVDSC2_LVWV(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC2_LVWV_SHIFT)) & PMC_LVDSC2_LVWV_MASK)
#define PMC_LVDSC2_LVWIE_MASK                    (0x20U)
#define PMC_LVDSC2_LVWIE_SHIFT                   (5U)
/*! LVWIE - Low-Voltage Warning Interrupt Enable
 *  0b0..Hardware interrupt disabled (use polling)
 *  0b1..Request a hardware interrupt when LVWF = 1
 */
#define PMC_LVDSC2_LVWIE(x)                      (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC2_LVWIE_SHIFT)) & PMC_LVDSC2_LVWIE_MASK)
#define PMC_LVDSC2_LVWACK_MASK                   (0x40U)
#define PMC_LVDSC2_LVWACK_SHIFT                  (6U)
/*! LVWACK - Low-Voltage Warning Acknowledge
 */
#define PMC_LVDSC2_LVWACK(x)                     (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC2_LVWACK_SHIFT)) & PMC_LVDSC2_LVWACK_MASK)
#define PMC_LVDSC2_LVWF_MASK                     (0x80U)
#define PMC_LVDSC2_LVWF_SHIFT                    (7U)
/*! LVWF - Low-Voltage Warning Flag
 *  0b0..Low-voltage warning event not detected
 *  0b1..Low-voltage warning event detected
 */
#define PMC_LVDSC2_LVWF(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC2_LVWF_SHIFT)) & PMC_LVDSC2_LVWF_MASK)
/*! @} */

/*! @name REGSC - Regulator Status And Control register */
/*! @{ */
#define PMC_REGSC_BGBE_MASK                      (0x1U)
#define PMC_REGSC_BGBE_SHIFT                     (0U)
/*! BGBE - Bandgap Buffer Enable
 *  0b0..Bandgap buffer not enabled
 *  0b1..Bandgap buffer enabled
 */
#define PMC_REGSC_BGBE(x)                        (((uint8_t)(((uint8_t)(x)) << PMC_REGSC_BGBE_SHIFT)) & PMC_REGSC_BGBE_MASK)
#define PMC_REGSC_REGONS_MASK                    (0x4U)
#define PMC_REGSC_REGONS_SHIFT                   (2U)
/*! REGONS - Regulator In Run Regulation Status
 *  0b0..Regulator is in stop regulation or in transition to/from it
 *  0b1..Regulator is in run regulation
 */
#define PMC_REGSC_REGONS(x)                      (((uint8_t)(((uint8_t)(x)) << PMC_REGSC_REGONS_SHIFT)) & PMC_REGSC_REGONS_MASK)
#define PMC_REGSC_ACKISO_MASK                    (0x8U)
#define PMC_REGSC_ACKISO_SHIFT                   (3U)
/*! ACKISO - Acknowledge Isolation
 *  0b0..Peripherals and I/O pads are in normal run state.
 *  0b1..Certain peripherals and I/O pads are in an isolated and latched state.
 */
#define PMC_REGSC_ACKISO(x)                      (((uint8_t)(((uint8_t)(x)) << PMC_REGSC_ACKISO_SHIFT)) & PMC_REGSC_ACKISO_MASK)
#define PMC_REGSC_BGEN_MASK                      (0x10U)
#define PMC_REGSC_BGEN_SHIFT                     (4U)
/*! BGEN - Bandgap Enable In VLPx Operation
 *  0b0..Bandgap voltage reference is disabled in VLPx , LLS , and VLLSx modes.
 *  0b1..Bandgap voltage reference is enabled in VLPx , LLS , and VLLSx modes.
 */
#define PMC_REGSC_BGEN(x)                        (((uint8_t)(((uint8_t)(x)) << PMC_REGSC_BGEN_SHIFT)) & PMC_REGSC_BGEN_MASK)
#define PMC_REGSC_VLPO_MASK                      (0x40U)
#define PMC_REGSC_VLPO_SHIFT                     (6U)
/*! VLPO - VLPx Option
 *  0b0..Operating frequencies and MCG clocking modes are restricted during VLPx modes as listed in the Power Management chapter.
 *  0b1..If BGEN is also set, operating frequencies and MCG clocking modes are unrestricted during VLPx modes.
 *       Note that flash access frequency is still restricted however.
 */
#define PMC_REGSC_VLPO(x)                        (((uint8_t)(((uint8_t)(x)) << PMC_REGSC_VLPO_SHIFT)) & PMC_REGSC_VLPO_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PMC_Register_Masks */


/* PMC - Peripheral instance base addresses */
/** Peripheral PMC base address */
#define PMC_BASE                                 (0x4007D000u)
/** Peripheral PMC base pointer */
#define PMC                                      ((PMC_Type *)PMC_BASE)
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS                           { PMC_BASE }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS                            { PMC }
/** Interrupt vectors for the PMC peripheral type */
#define PMC_IRQS                                 { LVD_LVW_DCDC_IRQn }

/*!
 * @}
 */ /* end of group PMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PORT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Peripheral_Access_Layer PORT Peripheral Access Layer
 * @{
 */

/** PORT - Register Layout Typedef */
typedef struct {
  __IO uint32_t PCR[32];                           /**< Pin Control Register 0..Pin Control Register 31, array offset: 0x0, array step: 0x4 */
  __O  uint32_t GPCLR;                             /**< Global Pin Control Low Register, offset: 0x80 */
  __O  uint32_t GPCHR;                             /**< Global Pin Control High Register, offset: 0x84 */
  __O  uint32_t GICLR;                             /**< Global Interrupt Control Low Register, offset: 0x88 */
  __O  uint32_t GICHR;                             /**< Global Interrupt Control High Register, offset: 0x8C */
       uint8_t RESERVED_0[16];
  __IO uint32_t ISFR;                              /**< Interrupt Status Flag Register, offset: 0xA0 */
} PORT_Type;

/* ----------------------------------------------------------------------------
   -- PORT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Masks PORT Register Masks
 * @{
 */

/*! @name PCR - Pin Control Register 0..Pin Control Register 31 */
/*! @{ */
#define PORT_PCR_PS_MASK                         (0x1U)
#define PORT_PCR_PS_SHIFT                        (0U)
/*! PS - Pull Select
 *  0b0..Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
 *  0b1..Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
 */
#define PORT_PCR_PS(x)                           (((uint32_t)(((uint32_t)(x)) << PORT_PCR_PS_SHIFT)) & PORT_PCR_PS_MASK)
#define PORT_PCR_PE_MASK                         (0x2U)
#define PORT_PCR_PE_SHIFT                        (1U)
/*! PE - Pull Enable
 *  0b0..Internal pull resistor is not enabled on the corresponding pin.
 *  0b1..Internal pull resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
 */
#define PORT_PCR_PE(x)                           (((uint32_t)(((uint32_t)(x)) << PORT_PCR_PE_SHIFT)) & PORT_PCR_PE_MASK)
#define PORT_PCR_SRE_MASK                        (0x4U)
#define PORT_PCR_SRE_SHIFT                       (2U)
/*! SRE - Slew Rate Enable
 *  0b0..Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
 *  0b1..Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
 */
#define PORT_PCR_SRE(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_SRE_SHIFT)) & PORT_PCR_SRE_MASK)
#define PORT_PCR_PFE_MASK                        (0x10U)
#define PORT_PCR_PFE_SHIFT                       (4U)
/*! PFE - Passive Filter Enable
 *  0b0..Passive input filter is disabled on the corresponding pin.
 *  0b1..Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input.
 *       Refer to the device data sheet for filter characteristics.
 */
#define PORT_PCR_PFE(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_PFE_SHIFT)) & PORT_PCR_PFE_MASK)
#define PORT_PCR_DSE_MASK                        (0x40U)
#define PORT_PCR_DSE_SHIFT                       (6U)
/*! DSE - Drive Strength Enable
 *  0b0..Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
 *  0b1..High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
 */
#define PORT_PCR_DSE(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_DSE_SHIFT)) & PORT_PCR_DSE_MASK)
#define PORT_PCR_MUX_MASK                        (0xF00U)
#define PORT_PCR_MUX_SHIFT                       (8U)
/*! MUX - Pin Mux Control
 *  0b0000..Pin disabled (Alternative 0) (analog).
 *  0b0001..Alternative 1 (GPIO).
 *  0b0010..Alternative 2 (chip-specific).
 *  0b0011..Alternative 3 (chip-specific).
 *  0b0100..Alternative 4 (chip-specific).
 *  0b0101..Alternative 5 (chip-specific).
 *  0b0110..Alternative 6 (chip-specific).
 *  0b0111..Alternative 7 (chip-specific).
 *  0b1000..Alternative 8 (chip-specific).
 *  0b1001..Alternative 9 (chip-specific).
 *  0b1010..Alternative 10 (chip-specific).
 *  0b1011..Alternative 11 (chip-specific).
 *  0b1100..Alternative 12 (chip-specific).
 *  0b1101..Alternative 13 (chip-specific).
 *  0b1110..Alternative 14 (chip-specific).
 *  0b1111..Alternative 15 (chip-specific).
 */
#define PORT_PCR_MUX(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_MUX_SHIFT)) & PORT_PCR_MUX_MASK)
#define PORT_PCR_IRQC_MASK                       (0xF0000U)
#define PORT_PCR_IRQC_SHIFT                      (16U)
/*! IRQC - Interrupt Configuration
 *  0b0000..Interrupt Status Flag (ISF) is disabled.
 *  0b0001..ISF flag and DMA request on rising edge.
 *  0b0010..ISF flag and DMA request on falling edge.
 *  0b0011..ISF flag and DMA request on either edge.
 *  0b0100..Reserved.
 *  0b0101..Flag sets on rising edge.
 *  0b0110..Flag sets on falling edge.
 *  0b0111..Flag sets on either edge.
 *  0b1000..ISF flag and Interrupt when logic 0.
 *  0b1001..ISF flag and Interrupt on rising-edge.
 *  0b1010..ISF flag and Interrupt on falling-edge.
 *  0b1011..ISF flag and Interrupt on either edge.
 *  0b1100..ISF flag and Interrupt when logic 1.
 *  0b1101..Enable active high trigger output, flag is disabled. [The trigger output goes to the trigger mux,
 *          which allows pins to trigger other peripherals (configurable polarity; 1 pin per port; if multiple pins are
 *          configured, then they are ORed together to create the trigger)]
 *  0b1110..Enable active low trigger output, flag is disabled.
 *  0b1111..Reserved.
 */
#define PORT_PCR_IRQC(x)                         (((uint32_t)(((uint32_t)(x)) << PORT_PCR_IRQC_SHIFT)) & PORT_PCR_IRQC_MASK)
#define PORT_PCR_ISF_MASK                        (0x1000000U)
#define PORT_PCR_ISF_SHIFT                       (24U)
/*! ISF - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected.
 *  0b1..Configured interrupt is detected. If the pin is configured to generate a DMA request, then the
 *       corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the
 *       flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive
 *       interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
 */
#define PORT_PCR_ISF(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_ISF_SHIFT)) & PORT_PCR_ISF_MASK)
/*! @} */

/* The count of PORT_PCR */
#define PORT_PCR_COUNT                           (32U)

/*! @name GPCLR - Global Pin Control Low Register */
/*! @{ */
#define PORT_GPCLR_GPWD_MASK                     (0xFFFFU)
#define PORT_GPCLR_GPWD_SHIFT                    (0U)
/*! GPWD - Global Pin Write Data
 */
#define PORT_GPCLR_GPWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCLR_GPWD_SHIFT)) & PORT_GPCLR_GPWD_MASK)
#define PORT_GPCLR_GPWE_MASK                     (0xFFFF0000U)
#define PORT_GPCLR_GPWE_SHIFT                    (16U)
/*! GPWE - Global Pin Write Enable
 */
#define PORT_GPCLR_GPWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCLR_GPWE_SHIFT)) & PORT_GPCLR_GPWE_MASK)
/*! @} */

/*! @name GPCHR - Global Pin Control High Register */
/*! @{ */
#define PORT_GPCHR_GPWD_MASK                     (0xFFFFU)
#define PORT_GPCHR_GPWD_SHIFT                    (0U)
/*! GPWD - Global Pin Write Data
 */
#define PORT_GPCHR_GPWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCHR_GPWD_SHIFT)) & PORT_GPCHR_GPWD_MASK)
#define PORT_GPCHR_GPWE_MASK                     (0xFFFF0000U)
#define PORT_GPCHR_GPWE_SHIFT                    (16U)
/*! GPWE - Global Pin Write Enable
 */
#define PORT_GPCHR_GPWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCHR_GPWE_SHIFT)) & PORT_GPCHR_GPWE_MASK)
/*! @} */

/*! @name GICLR - Global Interrupt Control Low Register */
/*! @{ */
#define PORT_GICLR_GIWE_MASK                     (0xFFFFU)
#define PORT_GICLR_GIWE_SHIFT                    (0U)
/*! GIWE - Global Interrupt Write Enable
 */
#define PORT_GICLR_GIWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GICLR_GIWE_SHIFT)) & PORT_GICLR_GIWE_MASK)
#define PORT_GICLR_GIWD_MASK                     (0xFFFF0000U)
#define PORT_GICLR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data
 */
#define PORT_GICLR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GICLR_GIWD_SHIFT)) & PORT_GICLR_GIWD_MASK)
/*! @} */

/*! @name GICHR - Global Interrupt Control High Register */
/*! @{ */
#define PORT_GICHR_GIWE_MASK                     (0xFFFFU)
#define PORT_GICHR_GIWE_SHIFT                    (0U)
/*! GIWE - Global Interrupt Write Enable
 */
#define PORT_GICHR_GIWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GICHR_GIWE_SHIFT)) & PORT_GICHR_GIWE_MASK)
#define PORT_GICHR_GIWD_MASK                     (0xFFFF0000U)
#define PORT_GICHR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data
 */
#define PORT_GICHR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GICHR_GIWD_SHIFT)) & PORT_GICHR_GIWD_MASK)
/*! @} */

/*! @name ISFR - Interrupt Status Flag Register */
/*! @{ */
#define PORT_ISFR_ISF_MASK                       (0xFFFFFFFFU)
#define PORT_ISFR_ISF_SHIFT                      (0U)
/*! ISF - Interrupt Status Flag
 */
#define PORT_ISFR_ISF(x)                         (((uint32_t)(((uint32_t)(x)) << PORT_ISFR_ISF_SHIFT)) & PORT_ISFR_ISF_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PORT_Register_Masks */


/* PORT - Peripheral instance base addresses */
/** Peripheral PORTA base address */
#define PORTA_BASE                               (0x40049000u)
/** Peripheral PORTA base pointer */
#define PORTA                                    ((PORT_Type *)PORTA_BASE)
/** Peripheral PORTB base address */
#define PORTB_BASE                               (0x4004A000u)
/** Peripheral PORTB base pointer */
#define PORTB                                    ((PORT_Type *)PORTB_BASE)
/** Peripheral PORTC base address */
#define PORTC_BASE                               (0x4004B000u)
/** Peripheral PORTC base pointer */
#define PORTC                                    ((PORT_Type *)PORTC_BASE)
/** Array initializer of PORT peripheral base addresses */
#define PORT_BASE_ADDRS                          { PORTA_BASE, PORTB_BASE, PORTC_BASE }
/** Array initializer of PORT peripheral base pointers */
#define PORT_BASE_PTRS                           { PORTA, PORTB, PORTC }
/** Interrupt vectors for the PORT peripheral type */
#define PORT_IRQS                                { PORTA_IRQn, PORTB_PORTC_IRQn, PORTB_PORTC_IRQn }

/*!
 * @}
 */ /* end of group PORT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RADIO_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RADIO_CTRL_Peripheral_Access_Layer RADIO_CTRL Peripheral Access Layer
 * @{
 */

/** RADIO_CTRL - Register Layout Typedef */
typedef struct {
  __I  uint32_t LL_STATUS;                         /**< Radio LL STATUS, offset: 0x0 */
  __IO uint32_t LL_CTRL;                           /**< Radio control register, offset: 0x4 */
  __IO uint32_t PACKET_RAM_CTRL;                   /**< PACKET_RAM_CTRL register, offset: 0x8 */
  __IO uint32_t RF_CTRL_OVRD;                      /**< Radio Control Override Register, offset: 0xC */
} RADIO_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- RADIO_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RADIO_CTRL_Register_Masks RADIO_CTRL Register Masks
 * @{
 */

/*! @name LL_STATUS - Radio LL STATUS */
/*! @{ */
#define RADIO_CTRL_LL_STATUS_LL_PRESENT_MASK     (0x3FU)
#define RADIO_CTRL_LL_STATUS_LL_PRESENT_SHIFT    (0U)
/*! LL_PRESENT - Link Layer (LL) present status
 */
#define RADIO_CTRL_LL_STATUS_LL_PRESENT(x)       (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_LL_STATUS_LL_PRESENT_SHIFT)) & RADIO_CTRL_LL_STATUS_LL_PRESENT_MASK)
/*! @} */

/*! @name LL_CTRL - Radio control register */
/*! @{ */
#define RADIO_CTRL_LL_CTRL_ACTIVE_LL_MASK        (0x3U)
#define RADIO_CTRL_LL_CTRL_ACTIVE_LL_SHIFT       (0U)
/*! ACTIVE_LL - Link layer select register
 *  0b00..Bluetooth LE LL is selected
 *  0b01..Reserved
 *  0b10..GENERIC LL is selected
 *  0b11..Disabled (default)
 */
#define RADIO_CTRL_LL_CTRL_ACTIVE_LL(x)          (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_LL_CTRL_ACTIVE_LL_SHIFT)) & RADIO_CTRL_LL_CTRL_ACTIVE_LL_MASK)
/*! @} */

/*! @name PACKET_RAM_CTRL - PACKET_RAM_CTRL register */
/*! @{ */
#define RADIO_CTRL_PACKET_RAM_CTRL_PB_PROTECT_MASK (0x1U)
#define RADIO_CTRL_PACKET_RAM_CTRL_PB_PROTECT_SHIFT (0U)
/*! PB_PROTECT - PB_PROTECT
 *  0b0..Incoming receive data can overwrite the existing contents of the RX section of the Packet Buffer.
 *  0b1..Incoming receive data is been blocked from overwriting the existing contents of the RX section of the Packet Buffer.
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_PB_PROTECT(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_PB_PROTECT_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_PB_PROTECT_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_RAM_IPS_WAIT_DISABLE_MASK (0x2U)
#define RADIO_CTRL_PACKET_RAM_CTRL_RAM_IPS_WAIT_DISABLE_SHIFT (1U)
/*! RAM_IPS_WAIT_DISABLE - RAM_IPS_WAIT_DISABLE
 *  0b0..ips_xfr_wait is asserted when LL is accessing packet RAM
 *  0b1..ips_xfr_wait is not asserted when LL is accessing packet RAM
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_RAM_IPS_WAIT_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_RAM_IPS_WAIT_DISABLE_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_RAM_IPS_WAIT_DISABLE_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_EN_MASK (0x10U)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_EN_SHIFT (4U)
/*! RX_RAM_CLK_ON_OVRD_EN - Override control for RX_RAM Clock Gate Enable
 *  0b0..Normal operation.
 *  0b1..Use the state of RX_RAM_CLK_ON_OVRD_EN to override the RAM Clock Gate Enable.
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_EN_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_EN_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_MASK (0x20U)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_SHIFT (5U)
/*! RX_RAM_CLK_ON_OVRD - Override value for RX_RAM Clock Gate Enable
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CLK_ON_OVRD_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_EN_MASK (0x40U)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_EN_SHIFT (6U)
/*! RX_RAM_CE_ON_OVRD_EN - Override control for RX RAM CE
 *  0b0..Normal operation.
 *  0b1..Use the state of RX_RAM_CE_ON_OVRD to override the RX RAM CE.
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_EN_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_EN_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_MASK (0x80U)
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_SHIFT (7U)
/*! RX_RAM_CE_ON_OVRD - Override value for RAM CE
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_RX_RAM_CE_ON_OVRD_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_EN_MASK (0x100U)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_EN_SHIFT (8U)
/*! TX_RAM_CLK_ON_OVRD_EN - Override control for TX_RAM1 Clock Gate Enable
 *  0b0..Normal operation.
 *  0b1..Use the state of TX_RAM1_CLK_ON_OVRD_EN to override the TX RAM1 Clock Gate Enable.
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_EN_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_EN_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_MASK (0x200U)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_SHIFT (9U)
/*! TX_RAM_CLK_ON_OVRD - Override value for RAM Clock Gate Enable
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CLK_ON_OVRD_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_EN_MASK (0x400U)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_EN_SHIFT (10U)
/*! TX_RAM_CE_ON_OVRD_EN - Override control for RAM CE
 *  0b0..Normal operation.
 *  0b1..Use the state of TX_RAM_CE_ON_OVRD_EN to override the RAM CE.
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_EN_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_EN_MASK)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_MASK (0x800U)
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_SHIFT (11U)
/*! TX_RAM_CE_ON_OVRD - Override value for RAM CE (Chip Enable)
 */
#define RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_SHIFT)) & RADIO_CTRL_PACKET_RAM_CTRL_TX_RAM_CE_ON_OVRD_MASK)
/*! @} */

/*! @name RF_CTRL_OVRD - Radio Control Override Register */
/*! @{ */
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_EN_MASK (0x1U)
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_EN_SHIFT (0U)
/*! RBME_MODE_OVRD_EN - RBME Mode Override Enable
 *  0b0..RBME Mode Override Disable
 *  0b1..RBME Mode Override Enable
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_EN_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_EN_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_MASK (0xEU)
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_SHIFT (1U)
/*! RBME_MODE_OVRD - RBME Mode Override
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RBME_MODE_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_EN_MASK (0x10U)
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_EN_SHIFT (4U)
/*! RX_CON_EN_OVRD_EN - rx_con_en Override Enable
 *  0b0..rx_con_en Override Disable
 *  0b1..rx_con_en Override Enable
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_EN_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_EN_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_MASK (0x20U)
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_SHIFT (5U)
/*! RX_CON_EN_OVRD - rx_con_en Override
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RX_CON_EN_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_EN_MASK (0x40U)
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_EN_SHIFT (6U)
/*! BLE_LR_EN_OVRD_EN - ble_lr_en Override Enable
 *  0b0..ble_lr_en Override Disable
 *  0b1..ble_lr_en Override Enable
 */
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_EN_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_EN_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_MASK (0x80U)
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_SHIFT (7U)
/*! BLE_LR_EN_OVRD - ble_lr_en Override
 */
#define RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_BLE_LR_EN_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_EN_MASK (0x100U)
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_EN_SHIFT (8U)
/*! RIF_SEL_2MBPS_OVRD_EN - rif_sel_2mbps Override Enable
 *  0b0..rif_sel_2mbps Override Disable
 *  0b1..rif_sel_2mbps Override Enable
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_EN_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_EN_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_MASK (0x200U)
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_SHIFT (9U)
/*! RIF_SEL_2MBPS_OVRD - rif_sel_2mbps Override
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RIF_SEL_2MBPS_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_CLK_EN_OVRD_MASK (0x10000U)
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_CLK_EN_OVRD_SHIFT (16U)
/*! RBME_CLK_EN_OVRD - RBME Clock Enable Override
 *  0b0..RBME clock force on is disabled.
 *  0b1..RBME clock force on is enabled.
 */
#define RADIO_CTRL_RF_CTRL_OVRD_RBME_CLK_EN_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_RBME_CLK_EN_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_RBME_CLK_EN_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_BTLL_CLK_EN_OVRD_MASK (0x20000U)
#define RADIO_CTRL_RF_CTRL_OVRD_BTLL_CLK_EN_OVRD_SHIFT (17U)
/*! BTLL_CLK_EN_OVRD - BTLL Clock Enable Override
 *  0b0..BTLL clock force on is disabled.
 *  0b1..BTLL clock force on is enabled.
 */
#define RADIO_CTRL_RF_CTRL_OVRD_BTLL_CLK_EN_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_BTLL_CLK_EN_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_BTLL_CLK_EN_OVRD_MASK)
#define RADIO_CTRL_RF_CTRL_OVRD_GENLL_CLK_EN_OVRD_MASK (0x40000U)
#define RADIO_CTRL_RF_CTRL_OVRD_GENLL_CLK_EN_OVRD_SHIFT (18U)
/*! GENLL_CLK_EN_OVRD - GENLL Clock Enable Override
 *  0b0..GENLL clock force on is disabled.
 *  0b1..GENLL clock force on is enabled.
 */
#define RADIO_CTRL_RF_CTRL_OVRD_GENLL_CLK_EN_OVRD(x) (((uint32_t)(((uint32_t)(x)) << RADIO_CTRL_RF_CTRL_OVRD_GENLL_CLK_EN_OVRD_SHIFT)) & RADIO_CTRL_RF_CTRL_OVRD_GENLL_CLK_EN_OVRD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RADIO_CTRL_Register_Masks */


/* RADIO_CTRL - Peripheral instance base addresses */
/** Peripheral RADIO_CTRL base address */
#define RADIO_CTRL_BASE                          (0x40086000u)
/** Peripheral RADIO_CTRL base pointer */
#define RADIO_CTRL                               ((RADIO_CTRL_Type *)RADIO_CTRL_BASE)
/** Array initializer of RADIO_CTRL peripheral base addresses */
#define RADIO_CTRL_BASE_ADDRS                    { RADIO_CTRL_BASE }
/** Array initializer of RADIO_CTRL peripheral base pointers */
#define RADIO_CTRL_BASE_PTRS                     { RADIO_CTRL }

/*!
 * @}
 */ /* end of group RADIO_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RBME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RBME_Peripheral_Access_Layer RBME Peripheral Access Layer
 * @{
 */

/** RBME - Register Layout Typedef */
typedef struct {
  __IO uint32_t CRCW_CFG;                          /**< CRC/WHITENER CONFIG REGISTER, offset: 0x0 */
  __I  uint32_t CRC_EC_MASK;                       /**< CRC ERROR CORRECTION MASK, offset: 0x4 */
  __I  uint32_t CRC_RES_OUT;                       /**< CRC RESULT, offset: 0x8 */
  __IO uint32_t CRCW_CFG2;                         /**< CRC/WHITENER CONFIG 2 REGISTER, offset: 0xC */
  __IO uint32_t CRCW_CFG3;                         /**< CRC CONFIGURATION, offset: 0x10 */
  __IO uint32_t CRC_INIT;                          /**< CRC INITIALIZATION, offset: 0x14 */
  __IO uint32_t CRC_POLY;                          /**< CRC POLYNOMIAL, offset: 0x18 */
  __IO uint32_t CRC_XOR_OUT;                       /**< CRC XOR OUT, offset: 0x1C */
  __IO uint32_t WHITEN_CFG;                        /**< WHITENER CONFIGURATION, offset: 0x20 */
  __IO uint32_t WHITEN_POLY;                       /**< WHITENER POLYNOMIAL, offset: 0x24 */
  __IO uint32_t WHITEN_SZ_THR;                     /**< WHITENER SIZE THRESHOLD, offset: 0x28 */
  __IO uint32_t FEC_CFG1;                          /**< FEC CONFIG REGISTER 1, offset: 0x2C */
  __IO uint32_t RBME_RST;                          /**< RBME SOFT RESET REGISTER, offset: 0x30 */
  __IO uint32_t FEC_CFG2;                          /**< FEC CONFIG REGISTER 2, offset: 0x34 */
  __IO uint32_t FLUSH_CFG;                         /**< FEC FLUSH CONFIG REGISTER, offset: 0x38 */
  __IO uint32_t SPREAD_CFG;                        /**< SPREADER CONFIG REGISTER, offset: 0x3C */
  __IO uint32_t WHT_CFG;                           /**< WHITEN CONFIG REGISTER, offset: 0x40 */
  __IO uint32_t PKT_SZ;                            /**< PACKET SIZE REGISTER, offset: 0x44 */
  __IO uint32_t CRC_PHR_SZ;                        /**< LENGTH OF PHR CONFIG REGISTER, offset: 0x48 */
  __IO uint32_t FCP_CFG;                           /**< FCP SUPPORT CONFIG REGISTER, offset: 0x4C */
  __IO uint32_t FRAME_OVER_SZ;                     /**< FRAME OVERRIDE SIZE REGISTER, offset: 0x50 */
  __IO uint32_t FEC_BSZ_OV_B4SP;                   /**< OVERRIDE OF FEC BLOCK SIZE REGISTER, offset: 0x54 */
  __IO uint32_t LEG0_CFG;                          /**< LEG0 CONFIG REGISTER, offset: 0x58 */
  __IO uint32_t NPAYL_OVER_SZ;                     /**< OVERRIDE PAYLOAD LENGTH REGISTER, offset: 0x5C */
  __IO uint32_t DATALL_CFG;                        /**< DATA TO LINK LAYER CONFIG REGISTER, offset: 0x60 */
  __IO uint32_t RAM_S_ADDR;                        /**< PACKET RAM SOURCE ADDRESS, offset: 0x64 */
  __IO uint32_t RAM_D_ADDR;                        /**< PACKET RAM DESTINATION ADDRESS, offset: 0x68 */
  __IO uint32_t RAM_IF_CFG;                        /**< PACKET RAM INTERFACE CONFIG REGISTER, offset: 0x6C */
} RBME_Type;

/* ----------------------------------------------------------------------------
   -- RBME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RBME_Register_Masks RBME Register Masks
 * @{
 */

/*! @name CRCW_CFG - CRC/WHITENER CONFIG REGISTER */
/*! @{ */
#define RBME_CRCW_CFG_CRCW_EN_MASK               (0x1U)
#define RBME_CRCW_CFG_CRCW_EN_SHIFT              (0U)
/*! CRCW_EN - CRC calculation enable
 */
#define RBME_CRCW_CFG_CRCW_EN(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRCW_EN_SHIFT)) & RBME_CRCW_CFG_CRCW_EN_MASK)
#define RBME_CRCW_CFG_CRCW_EC_EN_MASK            (0x2U)
#define RBME_CRCW_CFG_CRCW_EC_EN_SHIFT           (1U)
/*! CRCW_EC_EN - CRC Error Correction Enable
 */
#define RBME_CRCW_CFG_CRCW_EC_EN(x)              (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRCW_EC_EN_SHIFT)) & RBME_CRCW_CFG_CRCW_EC_EN_MASK)
#define RBME_CRCW_CFG_CRC_ZERO_MASK              (0x4U)
#define RBME_CRCW_CFG_CRC_ZERO_SHIFT             (2U)
/*! CRC_ZERO - CRC zero
 */
#define RBME_CRCW_CFG_CRC_ZERO(x)                (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_ZERO_SHIFT)) & RBME_CRCW_CFG_CRC_ZERO_MASK)
#define RBME_CRCW_CFG_CRC_EARLY_FAIL_MASK        (0x8U)
#define RBME_CRCW_CFG_CRC_EARLY_FAIL_SHIFT       (3U)
/*! CRC_EARLY_FAIL - CRC error correction fail
 */
#define RBME_CRCW_CFG_CRC_EARLY_FAIL(x)          (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_EARLY_FAIL_SHIFT)) & RBME_CRCW_CFG_CRC_EARLY_FAIL_MASK)
#define RBME_CRCW_CFG_CRC_RES_OUT_VLD_MASK       (0x10U)
#define RBME_CRCW_CFG_CRC_RES_OUT_VLD_SHIFT      (4U)
/*! CRC_RES_OUT_VLD - CRC result output valid
 */
#define RBME_CRCW_CFG_CRC_RES_OUT_VLD(x)         (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_RES_OUT_VLD_SHIFT)) & RBME_CRCW_CFG_CRC_RES_OUT_VLD_MASK)
#define RBME_CRCW_CFG_CRC_EC_OFFSET_MASK         (0x7FF0000U)
#define RBME_CRCW_CFG_CRC_EC_OFFSET_SHIFT        (16U)
/*! CRC_EC_OFFSET - CRC error correction offset
 */
#define RBME_CRCW_CFG_CRC_EC_OFFSET(x)           (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_EC_OFFSET_SHIFT)) & RBME_CRCW_CFG_CRC_EC_OFFSET_MASK)
#define RBME_CRCW_CFG_CRC_EC_DONE_MASK           (0x10000000U)
#define RBME_CRCW_CFG_CRC_EC_DONE_SHIFT          (28U)
/*! CRC_EC_DONE - CRC error correction done
 */
#define RBME_CRCW_CFG_CRC_EC_DONE(x)             (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_EC_DONE_SHIFT)) & RBME_CRCW_CFG_CRC_EC_DONE_MASK)
#define RBME_CRCW_CFG_CRC_EC_FAIL_MASK           (0x20000000U)
#define RBME_CRCW_CFG_CRC_EC_FAIL_SHIFT          (29U)
/*! CRC_EC_FAIL - CRC error correction fail
 */
#define RBME_CRCW_CFG_CRC_EC_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG_CRC_EC_FAIL_SHIFT)) & RBME_CRCW_CFG_CRC_EC_FAIL_MASK)
/*! @} */

/*! @name CRC_EC_MASK - CRC ERROR CORRECTION MASK */
/*! @{ */
#define RBME_CRC_EC_MASK_CRC_EC_MASK_MASK        (0xFFFFFFFFU)
#define RBME_CRC_EC_MASK_CRC_EC_MASK_SHIFT       (0U)
/*! CRC_EC_MASK - CRC error correction mask
 */
#define RBME_CRC_EC_MASK_CRC_EC_MASK(x)          (((uint32_t)(((uint32_t)(x)) << RBME_CRC_EC_MASK_CRC_EC_MASK_SHIFT)) & RBME_CRC_EC_MASK_CRC_EC_MASK_MASK)
/*! @} */

/*! @name CRC_RES_OUT - CRC RESULT */
/*! @{ */
#define RBME_CRC_RES_OUT_CRC_RES_OUT_MASK        (0xFFFFFFFFU)
#define RBME_CRC_RES_OUT_CRC_RES_OUT_SHIFT       (0U)
/*! CRC_RES_OUT - CRC result output
 */
#define RBME_CRC_RES_OUT_CRC_RES_OUT(x)          (((uint32_t)(((uint32_t)(x)) << RBME_CRC_RES_OUT_CRC_RES_OUT_SHIFT)) & RBME_CRC_RES_OUT_CRC_RES_OUT_MASK)
/*! @} */

/*! @name CRCW_CFG2 - CRC/WHITENER CONFIG 2 REGISTER */
/*! @{ */
#define RBME_CRCW_CFG2_CRC_EC_SPKT_BYTES_MASK    (0xFFU)
#define RBME_CRCW_CFG2_CRC_EC_SPKT_BYTES_SHIFT   (0U)
/*! CRC_EC_SPKT_BYTES - Error Correction Short Packet Bytes
 */
#define RBME_CRCW_CFG2_CRC_EC_SPKT_BYTES(x)      (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG2_CRC_EC_SPKT_BYTES_SHIFT)) & RBME_CRCW_CFG2_CRC_EC_SPKT_BYTES_MASK)
#define RBME_CRCW_CFG2_CRC_EC_SPKT_WND_MASK      (0xF00U)
#define RBME_CRCW_CFG2_CRC_EC_SPKT_WND_SHIFT     (8U)
/*! CRC_EC_SPKT_WND - Error correction short packet burst error window
 */
#define RBME_CRCW_CFG2_CRC_EC_SPKT_WND(x)        (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG2_CRC_EC_SPKT_WND_SHIFT)) & RBME_CRCW_CFG2_CRC_EC_SPKT_WND_MASK)
#define RBME_CRCW_CFG2_CRC_EC_LPKT_WND_MASK      (0xF000U)
#define RBME_CRCW_CFG2_CRC_EC_LPKT_WND_SHIFT     (12U)
/*! CRC_EC_LPKT_WND - Error correction long packet burst error window
 */
#define RBME_CRCW_CFG2_CRC_EC_LPKT_WND(x)        (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG2_CRC_EC_LPKT_WND_SHIFT)) & RBME_CRCW_CFG2_CRC_EC_LPKT_WND_MASK)
/*! @} */

/*! @name CRCW_CFG3 - CRC CONFIGURATION */
/*! @{ */
#define RBME_CRCW_CFG3_CRC_SZ_MASK               (0x7U)
#define RBME_CRCW_CFG3_CRC_SZ_SHIFT              (0U)
/*! CRC_SZ - CRC Size (in octets)
 */
#define RBME_CRCW_CFG3_CRC_SZ(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG3_CRC_SZ_SHIFT)) & RBME_CRCW_CFG3_CRC_SZ_MASK)
#define RBME_CRCW_CFG3_CRC_START_BYTE_MASK       (0xF00U)
#define RBME_CRCW_CFG3_CRC_START_BYTE_SHIFT      (8U)
/*! CRC_START_BYTE - Configure CRC Start Point
 */
#define RBME_CRCW_CFG3_CRC_START_BYTE(x)         (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG3_CRC_START_BYTE_SHIFT)) & RBME_CRCW_CFG3_CRC_START_BYTE_MASK)
#define RBME_CRCW_CFG3_CRC_REF_IN_MASK           (0x10000U)
#define RBME_CRCW_CFG3_CRC_REF_IN_SHIFT          (16U)
/*! CRC_REF_IN - CRC Reflect In
 *  0b0..Does not manipulate input data stream
 *  0b1..reflect each byte in the input stream bitwise
 */
#define RBME_CRCW_CFG3_CRC_REF_IN(x)             (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG3_CRC_REF_IN_SHIFT)) & RBME_CRCW_CFG3_CRC_REF_IN_MASK)
#define RBME_CRCW_CFG3_CRC_REF_OUT_MASK          (0x20000U)
#define RBME_CRCW_CFG3_CRC_REF_OUT_SHIFT         (17U)
/*! CRC_REF_OUT - CRC Reflect Out
 *  0b0..Does not manipulate CRC result
 *  0b1..CRC result is to be reflected bitwise (operated on entire word)
 */
#define RBME_CRCW_CFG3_CRC_REF_OUT(x)            (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG3_CRC_REF_OUT_SHIFT)) & RBME_CRCW_CFG3_CRC_REF_OUT_MASK)
#define RBME_CRCW_CFG3_CRC_BYTE_ORD_MASK         (0x40000U)
#define RBME_CRCW_CFG3_CRC_BYTE_ORD_SHIFT        (18U)
/*! CRC_BYTE_ORD - CRC Byte Order
 *  0b0..LS Byte First
 *  0b1..MS Byte First
 */
#define RBME_CRCW_CFG3_CRC_BYTE_ORD(x)           (((uint32_t)(((uint32_t)(x)) << RBME_CRCW_CFG3_CRC_BYTE_ORD_SHIFT)) & RBME_CRCW_CFG3_CRC_BYTE_ORD_MASK)
/*! @} */

/*! @name CRC_INIT - CRC INITIALIZATION */
/*! @{ */
#define RBME_CRC_INIT_CRC_SEED_MASK              (0xFFFFFFFFU)
#define RBME_CRC_INIT_CRC_SEED_SHIFT             (0U)
/*! CRC_SEED - CRC Seed Value
 */
#define RBME_CRC_INIT_CRC_SEED(x)                (((uint32_t)(((uint32_t)(x)) << RBME_CRC_INIT_CRC_SEED_SHIFT)) & RBME_CRC_INIT_CRC_SEED_MASK)
/*! @} */

/*! @name CRC_POLY - CRC POLYNOMIAL */
/*! @{ */
#define RBME_CRC_POLY_CRC_POLY_MASK              (0xFFFFFFFFU)
#define RBME_CRC_POLY_CRC_POLY_SHIFT             (0U)
/*! CRC_POLY - CRC Polynomial.
 */
#define RBME_CRC_POLY_CRC_POLY(x)                (((uint32_t)(((uint32_t)(x)) << RBME_CRC_POLY_CRC_POLY_SHIFT)) & RBME_CRC_POLY_CRC_POLY_MASK)
/*! @} */

/*! @name CRC_XOR_OUT - CRC XOR OUT */
/*! @{ */
#define RBME_CRC_XOR_OUT_CRC_XOR_OUT_MASK        (0xFFFFFFFFU)
#define RBME_CRC_XOR_OUT_CRC_XOR_OUT_SHIFT       (0U)
/*! CRC_XOR_OUT - CRC XOR OUT Register
 */
#define RBME_CRC_XOR_OUT_CRC_XOR_OUT(x)          (((uint32_t)(((uint32_t)(x)) << RBME_CRC_XOR_OUT_CRC_XOR_OUT_SHIFT)) & RBME_CRC_XOR_OUT_CRC_XOR_OUT_MASK)
/*! @} */

/*! @name WHITEN_CFG - WHITENER CONFIGURATION */
/*! @{ */
#define RBME_WHITEN_CFG_WHITEN_START_MASK        (0x3U)
#define RBME_WHITEN_CFG_WHITEN_START_SHIFT       (0U)
/*! WHITEN_START - Configure Whitener Start Point
 *  0b00..no whitening
 *  0b01..start whitening at start-of-H0
 *  0b10..start whitening at start-of-H1 but only if LENGTH > WHITEN_SZ_THR
 *  0b11..start whitening at start-of-payload but only if LENGTH > WHITEN_SZ_THR
 */
#define RBME_WHITEN_CFG_WHITEN_START(x)          (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_START_SHIFT)) & RBME_WHITEN_CFG_WHITEN_START_MASK)
#define RBME_WHITEN_CFG_WHITEN_END_MASK          (0x4U)
#define RBME_WHITEN_CFG_WHITEN_END_SHIFT         (2U)
/*! WHITEN_END - Configure end-of-whitening
 *  0b0..end whiten at end-of-payload
 *  0b1..end whiten at end-of-crc
 */
#define RBME_WHITEN_CFG_WHITEN_END(x)            (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_END_SHIFT)) & RBME_WHITEN_CFG_WHITEN_END_MASK)
#define RBME_WHITEN_CFG_WHITEN_B4_CRC_MASK       (0x8U)
#define RBME_WHITEN_CFG_WHITEN_B4_CRC_SHIFT      (3U)
/*! WHITEN_B4_CRC - Congifure for Whitening-before-CRC
 *  0b0..CRC before whiten/de-whiten
 *  0b1..Whiten/de-whiten before CRC
 */
#define RBME_WHITEN_CFG_WHITEN_B4_CRC(x)         (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_B4_CRC_SHIFT)) & RBME_WHITEN_CFG_WHITEN_B4_CRC_MASK)
#define RBME_WHITEN_CFG_WHITEN_POLY_TYPE_MASK    (0x10U)
#define RBME_WHITEN_CFG_WHITEN_POLY_TYPE_SHIFT   (4U)
/*! WHITEN_POLY_TYPE - Whiten Polynomial Type
 */
#define RBME_WHITEN_CFG_WHITEN_POLY_TYPE(x)      (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_POLY_TYPE_SHIFT)) & RBME_WHITEN_CFG_WHITEN_POLY_TYPE_MASK)
#define RBME_WHITEN_CFG_WHITEN_REF_IN_MASK       (0x20U)
#define RBME_WHITEN_CFG_WHITEN_REF_IN_SHIFT      (5U)
/*! WHITEN_REF_IN - Whiten Reflect Input
 */
#define RBME_WHITEN_CFG_WHITEN_REF_IN(x)         (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_REF_IN_SHIFT)) & RBME_WHITEN_CFG_WHITEN_REF_IN_MASK)
#define RBME_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_MASK (0x40U)
#define RBME_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_SHIFT (6U)
/*! WHITEN_PAYLOAD_REINIT - Configure for Whitener re-initialization
 *  0b0..Does not re-initialize Whitener LFSR at start-of-payload
 *  0b1..Re-initialize Whitener LFSR at start-of-payload
 */
#define RBME_WHITEN_CFG_WHITEN_PAYLOAD_REINIT(x) (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_SHIFT)) & RBME_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_MASK)
#define RBME_WHITEN_CFG_WHITEN_SIZE_MASK         (0xF00U)
#define RBME_WHITEN_CFG_WHITEN_SIZE_SHIFT        (8U)
/*! WHITEN_SIZE - Length of Whitener LFSR
 */
#define RBME_WHITEN_CFG_WHITEN_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_SIZE_SHIFT)) & RBME_WHITEN_CFG_WHITEN_SIZE_MASK)
#define RBME_WHITEN_CFG_WHITEN_INIT_MASK         (0x1FF0000U)
#define RBME_WHITEN_CFG_WHITEN_INIT_SHIFT        (16U)
/*! WHITEN_INIT - Initialization value for whitening/de-whitening
 */
#define RBME_WHITEN_CFG_WHITEN_INIT(x)           (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_CFG_WHITEN_INIT_SHIFT)) & RBME_WHITEN_CFG_WHITEN_INIT_MASK)
/*! @} */

/*! @name WHITEN_POLY - WHITENER POLYNOMIAL */
/*! @{ */
#define RBME_WHITEN_POLY_WHITEN_POLY_MASK        (0x1FFU)
#define RBME_WHITEN_POLY_WHITEN_POLY_SHIFT       (0U)
/*! WHITEN_POLY - Whitener Polynomial
 */
#define RBME_WHITEN_POLY_WHITEN_POLY(x)          (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_POLY_WHITEN_POLY_SHIFT)) & RBME_WHITEN_POLY_WHITEN_POLY_MASK)
/*! @} */

/*! @name WHITEN_SZ_THR - WHITENER SIZE THRESHOLD */
/*! @{ */
#define RBME_WHITEN_SZ_THR_WHITEN_SZ_THR_MASK    (0xFFFU)
#define RBME_WHITEN_SZ_THR_WHITEN_SZ_THR_SHIFT   (0U)
/*! WHITEN_SZ_THR - Whitener Size Threshold
 */
#define RBME_WHITEN_SZ_THR_WHITEN_SZ_THR(x)      (((uint32_t)(((uint32_t)(x)) << RBME_WHITEN_SZ_THR_WHITEN_SZ_THR_SHIFT)) & RBME_WHITEN_SZ_THR_WHITEN_SZ_THR_MASK)
/*! @} */

/*! @name FEC_CFG1 - FEC CONFIG REGISTER 1 */
/*! @{ */
#define RBME_FEC_CFG1_FEC_EN_MASK                (0x1U)
#define RBME_FEC_CFG1_FEC_EN_SHIFT               (0U)
/*! FEC_EN - FEC enable
 *  0b0..Disable FEC encoder and decoder
 *  0b1..Enable FEC encoder and decoder
 */
#define RBME_FEC_CFG1_FEC_EN(x)                  (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG1_FEC_EN_SHIFT)) & RBME_FEC_CFG1_FEC_EN_MASK)
#define RBME_FEC_CFG1_FEC_SWAP_MASK              (0x2U)
#define RBME_FEC_CFG1_FEC_SWAP_SHIFT             (1U)
/*! FEC_SWAP - Choose 802.15.4 swap mode of FEC operation
 *  0b0..Disable Swap operation for FEC
 *  0b1..Swap for 802.15.4 and LEG0
 */
#define RBME_FEC_CFG1_FEC_SWAP(x)                (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG1_FEC_SWAP_SHIFT)) & RBME_FEC_CFG1_FEC_SWAP_MASK)
#define RBME_FEC_CFG1_FECOV_EN_MASK              (0x4U)
#define RBME_FEC_CFG1_FECOV_EN_SHIFT             (2U)
/*! FECOV_EN - Enable dynamic overide of FEC
 *  0b1..The override of FEC is only used in 802.15.4, dynamically depending on the SFD pattern received
 *  0b0..Disable FEC override
 */
#define RBME_FEC_CFG1_FECOV_EN(x)                (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG1_FECOV_EN_SHIFT)) & RBME_FEC_CFG1_FECOV_EN_MASK)
#define RBME_FEC_CFG1_INTV_EN_MASK               (0x10U)
#define RBME_FEC_CFG1_INTV_EN_SHIFT              (4U)
/*! INTV_EN - Enable interleaver reigster
 *  0b1..Enable interleaver for 15.4 and LEG0
 *  0b0..Disable interleaver for 802.15.4 and LEG0
 */
#define RBME_FEC_CFG1_INTV_EN(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG1_INTV_EN_SHIFT)) & RBME_FEC_CFG1_INTV_EN_MASK)
#define RBME_FEC_CFG1_NTERM_MASK                 (0x700U)
#define RBME_FEC_CFG1_NTERM_SHIFT                (8U)
/*! NTERM - Number of term bits
 */
#define RBME_FEC_CFG1_NTERM(x)                   (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG1_NTERM_SHIFT)) & RBME_FEC_CFG1_NTERM_MASK)
/*! @} */

/*! @name RBME_RST - RBME SOFT RESET REGISTER */
/*! @{ */
#define RBME_RBME_RST_RBME_RST_MASK              (0x1U)
#define RBME_RBME_RST_RBME_RST_SHIFT             (0U)
/*! RBME_RST - RBME reset signal
 *  0b0..Disable soft reset
 *  0b1..Enable soft reset. When this bit is write to 1, the soft reset to RBME happens immediately. Then all
 *       internal registers and functions will be reset.
 */
#define RBME_RBME_RST_RBME_RST(x)                (((uint32_t)(((uint32_t)(x)) << RBME_RBME_RST_RBME_RST_SHIFT)) & RBME_RBME_RST_RBME_RST_MASK)
/*! @} */

/*! @name FEC_CFG2 - FEC CONFIG REGISTER 2 */
/*! @{ */
#define RBME_FEC_CFG2_TB_LENGTH_MASK             (0x1FU)
#define RBME_FEC_CFG2_TB_LENGTH_SHIFT            (0U)
/*! TB_LENGTH - Trace-back length
 */
#define RBME_FEC_CFG2_TB_LENGTH(x)               (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG2_TB_LENGTH_SHIFT)) & RBME_FEC_CFG2_TB_LENGTH_MASK)
#define RBME_FEC_CFG2_SAT_VL_MASK                (0xFF00U)
#define RBME_FEC_CFG2_SAT_VL_SHIFT               (8U)
/*! SAT_VL - Saturation value for PM
 */
#define RBME_FEC_CFG2_SAT_VL(x)                  (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG2_SAT_VL_SHIFT)) & RBME_FEC_CFG2_SAT_VL_MASK)
#define RBME_FEC_CFG2_LARGE_VL_MASK              (0x7F0000U)
#define RBME_FEC_CFG2_LARGE_VL_SHIFT             (16U)
/*! LARGE_VL - Large value used at startup phase, assigned to the initial PMs.
 */
#define RBME_FEC_CFG2_LARGE_VL(x)                (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG2_LARGE_VL_SHIFT)) & RBME_FEC_CFG2_LARGE_VL_MASK)
#define RBME_FEC_CFG2_SDIDX_MASK                 (0x7000000U)
#define RBME_FEC_CFG2_SDIDX_SHIFT                (24U)
/*! SDIDX - Index of startup state. PM(startStIdx)=0
 */
#define RBME_FEC_CFG2_SDIDX(x)                   (((uint32_t)(((uint32_t)(x)) << RBME_FEC_CFG2_SDIDX_SHIFT)) & RBME_FEC_CFG2_SDIDX_MASK)
/*! @} */

/*! @name FLUSH_CFG - FEC FLUSH CONFIG REGISTER */
/*! @{ */
#define RBME_FLUSH_CFG_FLUSH_CFG_MASK            (0x1U)
#define RBME_FLUSH_CFG_FLUSH_CFG_SHIFT           (0U)
/*! FLUSH_CFG - FLUSH CLOCK CONFIG BIT
 *  0b0..32M flush clock
 *  0b1..26M flush clock
 */
#define RBME_FLUSH_CFG_FLUSH_CFG(x)              (((uint32_t)(((uint32_t)(x)) << RBME_FLUSH_CFG_FLUSH_CFG_SHIFT)) & RBME_FLUSH_CFG_FLUSH_CFG_MASK)
/*! @} */

/*! @name SPREAD_CFG - SPREADER CONFIG REGISTER */
/*! @{ */
#define RBME_SPREAD_CFG_SP_EN_MASK               (0x1U)
#define RBME_SPREAD_CFG_SP_EN_SHIFT              (0U)
/*! SP_EN - Spreader Enable bit
 *  0b0..Disable spreader
 *  0b1..Enable spreader
 */
#define RBME_SPREAD_CFG_SP_EN(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_SPREAD_CFG_SP_EN_SHIFT)) & RBME_SPREAD_CFG_SP_EN_MASK)
#define RBME_SPREAD_CFG_SPOV_EN_MASK             (0x2U)
#define RBME_SPREAD_CFG_SPOV_EN_SHIFT            (1U)
/*! SPOV_EN - Spreader Override Enable
 *  0b0..Does not allow active override of the spreading enable
 *  0b1..Allows active override of the spreading enable
 */
#define RBME_SPREAD_CFG_SPOV_EN(x)               (((uint32_t)(((uint32_t)(x)) << RBME_SPREAD_CFG_SPOV_EN_SHIFT)) & RBME_SPREAD_CFG_SPOV_EN_MASK)
#define RBME_SPREAD_CFG_CI_TX_MASK               (0x4U)
#define RBME_SPREAD_CFG_CI_TX_SHIFT              (2U)
/*! CI_TX - Bluetooth LE
 *  0b0..FEC Block 2 coded using S=8
 *  0b1..FEC Block 2 coded using S=2
 */
#define RBME_SPREAD_CFG_CI_TX(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_SPREAD_CFG_CI_TX_SHIFT)) & RBME_SPREAD_CFG_CI_TX_MASK)
#define RBME_SPREAD_CFG_SP_FACTOR_MASK           (0xF00U)
#define RBME_SPREAD_CFG_SP_FACTOR_SHIFT          (8U)
/*! SP_FACTOR - Spreading Factor
 */
#define RBME_SPREAD_CFG_SP_FACTOR(x)             (((uint32_t)(((uint32_t)(x)) << RBME_SPREAD_CFG_SP_FACTOR_SHIFT)) & RBME_SPREAD_CFG_SP_FACTOR_MASK)
#define RBME_SPREAD_CFG_SP_SEQ_MASK              (0xFFFF0000U)
#define RBME_SPREAD_CFG_SP_SEQ_SHIFT             (16U)
/*! SP_SEQ - Spreading Bit Sequence
 */
#define RBME_SPREAD_CFG_SP_SEQ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_SPREAD_CFG_SP_SEQ_SHIFT)) & RBME_SPREAD_CFG_SP_SEQ_MASK)
/*! @} */

/*! @name WHT_CFG - WHITEN CONFIG REGISTER */
/*! @{ */
#define RBME_WHT_CFG_W1_EN_MASK                  (0x1U)
#define RBME_WHT_CFG_W1_EN_SHIFT                 (0U)
/*! W1_EN - Enable first whitener
 */
#define RBME_WHT_CFG_W1_EN(x)                    (((uint32_t)(((uint32_t)(x)) << RBME_WHT_CFG_W1_EN_SHIFT)) & RBME_WHT_CFG_W1_EN_MASK)
#define RBME_WHT_CFG_WFIRST_MASK                 (0x4U)
#define RBME_WHT_CFG_WFIRST_SHIFT                (2U)
/*! WFIRST - Whitens before CRC
 */
#define RBME_WHT_CFG_WFIRST(x)                   (((uint32_t)(((uint32_t)(x)) << RBME_WHT_CFG_WFIRST_SHIFT)) & RBME_WHT_CFG_WFIRST_MASK)
#define RBME_WHT_CFG_WTOV_EN_MASK                (0x8U)
#define RBME_WHT_CFG_WTOV_EN_SHIFT               (3U)
/*! WTOV_EN - Allows overwrite of the whitening
 */
#define RBME_WHT_CFG_WTOV_EN(x)                  (((uint32_t)(((uint32_t)(x)) << RBME_WHT_CFG_WTOV_EN_SHIFT)) & RBME_WHT_CFG_WTOV_EN_MASK)
#define RBME_WHT_CFG_WT_OUT_SEL_MASK             (0xF000U)
#define RBME_WHT_CFG_WT_OUT_SEL_SHIFT            (12U)
/*! WT_OUT_SEL - Selected Output
 */
#define RBME_WHT_CFG_WT_OUT_SEL(x)               (((uint32_t)(((uint32_t)(x)) << RBME_WHT_CFG_WT_OUT_SEL_SHIFT)) & RBME_WHT_CFG_WT_OUT_SEL_MASK)
#define RBME_WHT_CFG_WT_TPOGY_MASK               (0x3000000U)
#define RBME_WHT_CFG_WT_TPOGY_SHIFT              (24U)
/*! WT_TPOGY - Whiten 1 Polynomial Type
 */
#define RBME_WHT_CFG_WT_TPOGY(x)                 (((uint32_t)(((uint32_t)(x)) << RBME_WHT_CFG_WT_TPOGY_SHIFT)) & RBME_WHT_CFG_WT_TPOGY_MASK)
/*! @} */

/*! @name PKT_SZ - PACKET SIZE REGISTER */
/*! @{ */
#define RBME_PKT_SZ_MAX_PKT_SZ_MASK              (0xFFFFU)
#define RBME_PKT_SZ_MAX_PKT_SZ_SHIFT             (0U)
/*! MAX_PKT_SZ - Maximum Packet Size In Bits
 */
#define RBME_PKT_SZ_MAX_PKT_SZ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_PKT_SZ_MAX_PKT_SZ_SHIFT)) & RBME_PKT_SZ_MAX_PKT_SZ_MASK)
#define RBME_PKT_SZ_DEF_PKT_SZ_MASK              (0xFFFF0000U)
#define RBME_PKT_SZ_DEF_PKT_SZ_SHIFT             (16U)
/*! DEF_PKT_SZ - Default Packet Size
 */
#define RBME_PKT_SZ_DEF_PKT_SZ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_PKT_SZ_DEF_PKT_SZ_SHIFT)) & RBME_PKT_SZ_DEF_PKT_SZ_MASK)
/*! @} */

/*! @name CRC_PHR_SZ - LENGTH OF PHR CONFIG REGISTER */
/*! @{ */
#define RBME_CRC_PHR_SZ_PHR_SZ_MASK              (0x7U)
#define RBME_CRC_PHR_SZ_PHR_SZ_SHIFT             (0U)
/*! PHR_SZ - PHR Size Config
 */
#define RBME_CRC_PHR_SZ_PHR_SZ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_CRC_PHR_SZ_PHR_SZ_SHIFT)) & RBME_CRC_PHR_SZ_PHR_SZ_MASK)
/*! @} */

/*! @name FCP_CFG - FCP SUPPORT CONFIG REGISTER */
/*! @{ */
#define RBME_FCP_CFG_FCP_SUPPORT_MASK            (0x1U)
#define RBME_FCP_CFG_FCP_SUPPORT_SHIFT           (0U)
/*! FCP_SUPPORT - FCP Suppport
 *  0b0..Disable FCP support
 *  0b1..Enable FCP support
 */
#define RBME_FCP_CFG_FCP_SUPPORT(x)              (((uint32_t)(((uint32_t)(x)) << RBME_FCP_CFG_FCP_SUPPORT_SHIFT)) & RBME_FCP_CFG_FCP_SUPPORT_MASK)
/*! @} */

/*! @name FRAME_OVER_SZ - FRAME OVERRIDE SIZE REGISTER */
/*! @{ */
#define RBME_FRAME_OVER_SZ_STD_FRM_OV_EN_MASK    (0x1U)
#define RBME_FRAME_OVER_SZ_STD_FRM_OV_EN_SHIFT   (0U)
/*! STD_FRM_OV_EN - Overrides actvie STD frame length from link layer enable bit
 *  0b0..Disable override actvie STD frame length from link layer
 *  0b1..Enable override actvie STD frame length from link layer
 */
#define RBME_FRAME_OVER_SZ_STD_FRM_OV_EN(x)      (((uint32_t)(((uint32_t)(x)) << RBME_FRAME_OVER_SZ_STD_FRM_OV_EN_SHIFT)) & RBME_FRAME_OVER_SZ_STD_FRM_OV_EN_MASK)
#define RBME_FRAME_OVER_SZ_STD_FRM_OV_MASK       (0x7FF0000U)
#define RBME_FRAME_OVER_SZ_STD_FRM_OV_SHIFT      (16U)
/*! STD_FRM_OV - Value to overide the STD frame length (bits)
 */
#define RBME_FRAME_OVER_SZ_STD_FRM_OV(x)         (((uint32_t)(((uint32_t)(x)) << RBME_FRAME_OVER_SZ_STD_FRM_OV_SHIFT)) & RBME_FRAME_OVER_SZ_STD_FRM_OV_MASK)
/*! @} */

/*! @name FEC_BSZ_OV_B4SP - OVERRIDE OF FEC BLOCK SIZE REGISTER */
/*! @{ */
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_B4SP_EN_MASK (0x1U)
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_B4SP_EN_SHIFT (0U)
/*! FEC_BSZ_OV_B4SP_EN - Override of the FEC block size for data
 *  0b0..Disable Override actvie STD frame length from link layer
 *  0b1..Enable Override actvie STD frame length from link layer
 */
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_B4SP_EN(x) (((uint32_t)(((uint32_t)(x)) << RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_B4SP_EN_SHIFT)) & RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_B4SP_EN_MASK)
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_MASK     (0xFFFF0000U)
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_SHIFT    (16U)
/*! FEC_BSZ_OV - Value of the override in bits. It is for test purpose.
 */
#define RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV(x)       (((uint32_t)(((uint32_t)(x)) << RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_SHIFT)) & RBME_FEC_BSZ_OV_B4SP_FEC_BSZ_OV_MASK)
/*! @} */

/*! @name LEG0_CFG - LEG0 CONFIG REGISTER */
/*! @{ */
#define RBME_LEG0_CFG_LEG0_INV_EN_MASK           (0x1U)
#define RBME_LEG0_CFG_LEG0_INV_EN_SHIFT          (0U)
/*! LEG0_INV_EN - Whiten invert enable bit
 *  0b0..Disable whiten invert for LEG0
 *  0b1..Enable whiten invert for LEG0
 */
#define RBME_LEG0_CFG_LEG0_INV_EN(x)             (((uint32_t)(((uint32_t)(x)) << RBME_LEG0_CFG_LEG0_INV_EN_SHIFT)) & RBME_LEG0_CFG_LEG0_INV_EN_MASK)
#define RBME_LEG0_CFG_LEG0_SUP_MASK              (0x2U)
#define RBME_LEG0_CFG_LEG0_SUP_SHIFT             (1U)
/*! LEG0_SUP - LEG0 support register
 *  0b0..Disable LEG0 support
 *  0b1..Enable LEG0 support
 */
#define RBME_LEG0_CFG_LEG0_SUP(x)                (((uint32_t)(((uint32_t)(x)) << RBME_LEG0_CFG_LEG0_SUP_SHIFT)) & RBME_LEG0_CFG_LEG0_SUP_MASK)
#define RBME_LEG0_CFG_LEG0_XOR_BYTE_MASK         (0xFF00U)
#define RBME_LEG0_CFG_LEG0_XOR_BYTE_SHIFT        (8U)
/*! LEG0_XOR_BYTE - LEG0 whitening masking byte
 */
#define RBME_LEG0_CFG_LEG0_XOR_BYTE(x)           (((uint32_t)(((uint32_t)(x)) << RBME_LEG0_CFG_LEG0_XOR_BYTE_SHIFT)) & RBME_LEG0_CFG_LEG0_XOR_BYTE_MASK)
#define RBME_LEG0_CFG_LEG0_XOR_RP_BYTE_MASK      (0xFF0000U)
#define RBME_LEG0_CFG_LEG0_XOR_RP_BYTE_SHIFT     (16U)
/*! LEG0_XOR_RP_BYTE - LEG0 repeat bytes masking
 */
#define RBME_LEG0_CFG_LEG0_XOR_RP_BYTE(x)        (((uint32_t)(((uint32_t)(x)) << RBME_LEG0_CFG_LEG0_XOR_RP_BYTE_SHIFT)) & RBME_LEG0_CFG_LEG0_XOR_RP_BYTE_MASK)
#define RBME_LEG0_CFG_LEG0_XOR_FST_BYTE_MASK     (0xFF000000U)
#define RBME_LEG0_CFG_LEG0_XOR_FST_BYTE_SHIFT    (24U)
/*! LEG0_XOR_FST_BYTE - FEC first byte masking
 */
#define RBME_LEG0_CFG_LEG0_XOR_FST_BYTE(x)       (((uint32_t)(((uint32_t)(x)) << RBME_LEG0_CFG_LEG0_XOR_FST_BYTE_SHIFT)) & RBME_LEG0_CFG_LEG0_XOR_FST_BYTE_MASK)
/*! @} */

/*! @name NPAYL_OVER_SZ - OVERRIDE PAYLOAD LENGTH REGISTER */
/*! @{ */
#define RBME_NPAYL_OVER_SZ_NPAYL_OV_EN_MASK      (0x1U)
#define RBME_NPAYL_OVER_SZ_NPAYL_OV_EN_SHIFT     (0U)
/*! NPAYL_OV_EN - Override the internal payload length computation
 *  0b0..Disable override the internal payload length
 *  0b1..Enable override the internal payload length
 */
#define RBME_NPAYL_OVER_SZ_NPAYL_OV_EN(x)        (((uint32_t)(((uint32_t)(x)) << RBME_NPAYL_OVER_SZ_NPAYL_OV_EN_SHIFT)) & RBME_NPAYL_OVER_SZ_NPAYL_OV_EN_MASK)
#define RBME_NPAYL_OVER_SZ_FT_FEC_FLUSH_MASK     (0x1F00U)
#define RBME_NPAYL_OVER_SZ_FT_FEC_FLUSH_SHIFT    (8U)
/*! FT_FEC_FLUSH - Value to overide the payload length (bits)
 */
#define RBME_NPAYL_OVER_SZ_FT_FEC_FLUSH(x)       (((uint32_t)(((uint32_t)(x)) << RBME_NPAYL_OVER_SZ_FT_FEC_FLUSH_SHIFT)) & RBME_NPAYL_OVER_SZ_FT_FEC_FLUSH_MASK)
#define RBME_NPAYL_OVER_SZ_NPAYL_OV_MASK         (0x7FF0000U)
#define RBME_NPAYL_OVER_SZ_NPAYL_OV_SHIFT        (16U)
#define RBME_NPAYL_OVER_SZ_NPAYL_OV(x)           (((uint32_t)(((uint32_t)(x)) << RBME_NPAYL_OVER_SZ_NPAYL_OV_SHIFT)) & RBME_NPAYL_OVER_SZ_NPAYL_OV_MASK)
/*! @} */

/*! @name DATALL_CFG - DATA TO LINK LAYER CONFIG REGISTER */
/*! @{ */
#define RBME_DATALL_CFG_DELAY_EN_MASK            (0x1U)
#define RBME_DATALL_CFG_DELAY_EN_SHIFT           (0U)
/*! DELAY_EN - Data to link layer delay enable bit
 *  0b0..Disable delay in 32M
 *  0b1..Enable delay in 26M
 */
#define RBME_DATALL_CFG_DELAY_EN(x)              (((uint32_t)(((uint32_t)(x)) << RBME_DATALL_CFG_DELAY_EN_SHIFT)) & RBME_DATALL_CFG_DELAY_EN_MASK)
/*! @} */

/*! @name RAM_S_ADDR - PACKET RAM SOURCE ADDRESS */
/*! @{ */
#define RBME_RAM_S_ADDR_RAM_S_ADDR_MASK          (0x3FFFU)
#define RBME_RAM_S_ADDR_RAM_S_ADDR_SHIFT         (0U)
/*! RAM_S_ADDR - Packet RAM source address. This address is ram physical address.
 */
#define RBME_RAM_S_ADDR_RAM_S_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << RBME_RAM_S_ADDR_RAM_S_ADDR_SHIFT)) & RBME_RAM_S_ADDR_RAM_S_ADDR_MASK)
/*! @} */

/*! @name RAM_D_ADDR - PACKET RAM DESTINATION ADDRESS */
/*! @{ */
#define RBME_RAM_D_ADDR_RAM_D_ADDR_MASK          (0x3FFFU)
#define RBME_RAM_D_ADDR_RAM_D_ADDR_SHIFT         (0U)
/*! RAM_D_ADDR - Packet RAM destination address, this address is ram physical address.
 */
#define RBME_RAM_D_ADDR_RAM_D_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << RBME_RAM_D_ADDR_RAM_D_ADDR_SHIFT)) & RBME_RAM_D_ADDR_RAM_D_ADDR_MASK)
/*! @} */

/*! @name RAM_IF_CFG - PACKET RAM INTERFACE CONFIG REGISTER */
/*! @{ */
#define RBME_RAM_IF_CFG_RAM_IF_TX_EN_MASK        (0x1U)
#define RBME_RAM_IF_CFG_RAM_IF_TX_EN_SHIFT       (0U)
/*! RAM_IF_TX_EN - RAM interface TX enable bit
 *  0b0..Disable RAM interface TX
 *  0b1..Enable RAM interface TX
 */
#define RBME_RAM_IF_CFG_RAM_IF_TX_EN(x)          (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_RAM_IF_TX_EN_SHIFT)) & RBME_RAM_IF_CFG_RAM_IF_TX_EN_MASK)
#define RBME_RAM_IF_CFG_RAM_IF_RX_EN_MASK        (0x2U)
#define RBME_RAM_IF_CFG_RAM_IF_RX_EN_SHIFT       (1U)
/*! RAM_IF_RX_EN - RAM interface RX enable
 *  0b0..Disable RAM interface RX
 *  0b1..Enable RAM interface RX
 */
#define RBME_RAM_IF_CFG_RAM_IF_RX_EN(x)          (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_RAM_IF_RX_EN_SHIFT)) & RBME_RAM_IF_CFG_RAM_IF_RX_EN_MASK)
#define RBME_RAM_IF_CFG_RAM_IF_IE_MASK           (0x10U)
#define RBME_RAM_IF_CFG_RAM_IF_IE_SHIFT          (4U)
/*! RAM_IF_IE - RAM interface interrupt enable bit
 *  0b0..Disable RAM interface interrupt
 *  0b1..Enable RAM interface interrupt
 */
#define RBME_RAM_IF_CFG_RAM_IF_IE(x)             (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_RAM_IF_IE_SHIFT)) & RBME_RAM_IF_CFG_RAM_IF_IE_MASK)
#define RBME_RAM_IF_CFG_RAM_IF_IC_MASK           (0x20U)
#define RBME_RAM_IF_CFG_RAM_IF_IC_SHIFT          (5U)
/*! RAM_IF_IC - RAM interface interrupt clear
 *  0b0..To do nothing to RAM interface interrupt
 *  0b1..To clear RAM interface interrupt
 */
#define RBME_RAM_IF_CFG_RAM_IF_IC(x)             (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_RAM_IF_IC_SHIFT)) & RBME_RAM_IF_CFG_RAM_IF_IC_MASK)
#define RBME_RAM_IF_CFG_H2S_EN_MASK              (0x40U)
#define RBME_RAM_IF_CFG_H2S_EN_SHIFT             (6U)
/*! H2S_EN - Hard bit convert to soft bit enable
 *  0b0..Disable hard bit to soft bits coversion
 *  0b1..Enable hard bit to soft bits coversion
 */
#define RBME_RAM_IF_CFG_H2S_EN(x)                (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_H2S_EN_SHIFT)) & RBME_RAM_IF_CFG_H2S_EN_MASK)
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_RD_MASK      (0x100U)
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_RD_SHIFT     (8U)
/*! SOFT_HD_SEL_RD - Soft and hard bit selection of write operation
 *  0b0..Hard bit selection of write operation
 *  0b1..Soft bit selection of write operation
 */
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_RD(x)        (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_SOFT_HD_SEL_RD_SHIFT)) & RBME_RAM_IF_CFG_SOFT_HD_SEL_RD_MASK)
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_WR_MASK      (0x200U)
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_WR_SHIFT     (9U)
/*! SOFT_HD_SEL_WR - Soft and hard bit selection of read operation
 *  0b0..Hard bit selection of read operation
 *  0b1..Soft bit selection of read operation
 */
#define RBME_RAM_IF_CFG_SOFT_HD_SEL_WR(x)        (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_SOFT_HD_SEL_WR_SHIFT)) & RBME_RAM_IF_CFG_SOFT_HD_SEL_WR_MASK)
#define RBME_RAM_IF_CFG_WR_IRQ_MASK              (0x400U)
#define RBME_RAM_IF_CFG_WR_IRQ_SHIFT             (10U)
/*! WR_IRQ - Write to RAM complete flag
 *  0b0..Writing to RAM not complete
 *  0b1..Writing to RAM complete
 */
#define RBME_RAM_IF_CFG_WR_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_WR_IRQ_SHIFT)) & RBME_RAM_IF_CFG_WR_IRQ_MASK)
#define RBME_RAM_IF_CFG_RD_IRQ_MASK              (0x800U)
#define RBME_RAM_IF_CFG_RD_IRQ_SHIFT             (11U)
/*! RD_IRQ - Read to RAM complete flag
 *  0b0..Reading to RAM not complete
 *  0b1..Reading to RAM complete
 */
#define RBME_RAM_IF_CFG_RD_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << RBME_RAM_IF_CFG_RD_IRQ_SHIFT)) & RBME_RAM_IF_CFG_RD_IRQ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RBME_Register_Masks */


/* RBME - Peripheral instance base addresses */
/** Peripheral RBME base address */
#define RBME_BASE                                (0x40086200u)
/** Peripheral RBME base pointer */
#define RBME                                     ((RBME_Type *)RBME_BASE)
/** Array initializer of RBME peripheral base addresses */
#define RBME_BASE_ADDRS                          { RBME_BASE }
/** Array initializer of RBME peripheral base pointers */
#define RBME_BASE_PTRS                           { RBME }

/*!
 * @}
 */ /* end of group RBME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Peripheral_Access_Layer RCM Peripheral Access Layer
 * @{
 */

/** RCM - Register Layout Typedef */
typedef struct {
  __I  uint8_t SRS0;                               /**< System Reset Status Register 0, offset: 0x0 */
  __I  uint8_t SRS1;                               /**< System Reset Status Register 1, offset: 0x1 */
       uint8_t RESERVED_0[2];
  __IO uint8_t RPFC;                               /**< Reset Pin Filter Control register, offset: 0x4 */
  __IO uint8_t RPFW;                               /**< Reset Pin Filter Width register, offset: 0x5 */
} RCM_Type;

/* ----------------------------------------------------------------------------
   -- RCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Masks RCM Register Masks
 * @{
 */

/*! @name SRS0 - System Reset Status Register 0 */
/*! @{ */
#define RCM_SRS0_WAKEUP_MASK                     (0x1U)
#define RCM_SRS0_WAKEUP_SHIFT                    (0U)
/*! WAKEUP - Low Leakage Wakeup Reset
 *  0b0..Reset not caused by LLWU module wakeup source
 *  0b1..Reset caused by LLWU module wakeup source
 */
#define RCM_SRS0_WAKEUP(x)                       (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_WAKEUP_SHIFT)) & RCM_SRS0_WAKEUP_MASK)
#define RCM_SRS0_LVD_MASK                        (0x2U)
#define RCM_SRS0_LVD_SHIFT                       (1U)
/*! LVD - Low-Voltage Detect Reset
 *  0b0..Reset not caused by LVD trip or POR
 *  0b1..Reset caused by LVD trip or POR
 */
#define RCM_SRS0_LVD(x)                          (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_LVD_SHIFT)) & RCM_SRS0_LVD_MASK)
#define RCM_SRS0_LOC_MASK                        (0x4U)
#define RCM_SRS0_LOC_SHIFT                       (2U)
/*! LOC - Loss-of-Clock Reset
 *  0b0..Reset not caused by a loss of external clock.
 *  0b1..Reset caused by a loss of external clock.
 */
#define RCM_SRS0_LOC(x)                          (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_LOC_SHIFT)) & RCM_SRS0_LOC_MASK)
#define RCM_SRS0_WDOG_MASK                       (0x20U)
#define RCM_SRS0_WDOG_SHIFT                      (5U)
/*! WDOG - Watchdog
 *  0b0..Reset not caused by watchdog timeout
 *  0b1..Reset caused by watchdog timeout
 */
#define RCM_SRS0_WDOG(x)                         (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_WDOG_SHIFT)) & RCM_SRS0_WDOG_MASK)
#define RCM_SRS0_PIN_MASK                        (0x40U)
#define RCM_SRS0_PIN_SHIFT                       (6U)
/*! PIN - External Reset Pin
 *  0b0..Reset not caused by external reset pin
 *  0b1..Reset caused by external reset pin
 */
#define RCM_SRS0_PIN(x)                          (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_PIN_SHIFT)) & RCM_SRS0_PIN_MASK)
#define RCM_SRS0_POR_MASK                        (0x80U)
#define RCM_SRS0_POR_SHIFT                       (7U)
/*! POR - Power-On Reset
 *  0b0..Reset not caused by POR
 *  0b1..Reset caused by POR
 */
#define RCM_SRS0_POR(x)                          (((uint8_t)(((uint8_t)(x)) << RCM_SRS0_POR_SHIFT)) & RCM_SRS0_POR_MASK)
/*! @} */

/*! @name SRS1 - System Reset Status Register 1 */
/*! @{ */
#define RCM_SRS1_LOCKUP_MASK                     (0x2U)
#define RCM_SRS1_LOCKUP_SHIFT                    (1U)
/*! LOCKUP - Core Lockup
 *  0b0..Reset not caused by core LOCKUP event
 *  0b1..Reset caused by core LOCKUP event
 */
#define RCM_SRS1_LOCKUP(x)                       (((uint8_t)(((uint8_t)(x)) << RCM_SRS1_LOCKUP_SHIFT)) & RCM_SRS1_LOCKUP_MASK)
#define RCM_SRS1_SW_MASK                         (0x4U)
#define RCM_SRS1_SW_SHIFT                        (2U)
/*! SW - Software
 *  0b0..Reset not caused by software setting of SYSRESETREQ bit
 *  0b1..Reset caused by software setting of SYSRESETREQ bit
 */
#define RCM_SRS1_SW(x)                           (((uint8_t)(((uint8_t)(x)) << RCM_SRS1_SW_SHIFT)) & RCM_SRS1_SW_MASK)
#define RCM_SRS1_MDM_AP_MASK                     (0x8U)
#define RCM_SRS1_MDM_AP_SHIFT                    (3U)
/*! MDM_AP - MDM-AP System Reset Request
 *  0b0..Reset not caused by host debugger system setting of the System Reset Request bit
 *  0b1..Reset caused by host debugger system setting of the System Reset Request bit
 */
#define RCM_SRS1_MDM_AP(x)                       (((uint8_t)(((uint8_t)(x)) << RCM_SRS1_MDM_AP_SHIFT)) & RCM_SRS1_MDM_AP_MASK)
#define RCM_SRS1_SACKERR_MASK                    (0x20U)
#define RCM_SRS1_SACKERR_SHIFT                   (5U)
/*! SACKERR - Stop Mode Acknowledge Error Reset
 *  0b0..Reset not caused by peripheral failure to acknowledge attempt to enter stop mode
 *  0b1..Reset caused by peripheral failure to acknowledge attempt to enter stop mode
 */
#define RCM_SRS1_SACKERR(x)                      (((uint8_t)(((uint8_t)(x)) << RCM_SRS1_SACKERR_SHIFT)) & RCM_SRS1_SACKERR_MASK)
/*! @} */

/*! @name RPFC - Reset Pin Filter Control register */
/*! @{ */
#define RCM_RPFC_RSTFLTSRW_MASK                  (0x3U)
#define RCM_RPFC_RSTFLTSRW_SHIFT                 (0U)
/*! RSTFLTSRW - Reset Pin Filter Select in Run and Wait Modes
 *  0b00..All filtering disabled
 *  0b01..Bus clock filter enabled for normal operation
 *  0b10..LPO clock filter enabled for normal operation
 *  0b11..Reserved
 */
#define RCM_RPFC_RSTFLTSRW(x)                    (((uint8_t)(((uint8_t)(x)) << RCM_RPFC_RSTFLTSRW_SHIFT)) & RCM_RPFC_RSTFLTSRW_MASK)
#define RCM_RPFC_RSTFLTSS_MASK                   (0x4U)
#define RCM_RPFC_RSTFLTSS_SHIFT                  (2U)
/*! RSTFLTSS - Reset Pin Filter Select in Stop Mode
 *  0b0..All filtering disabled
 *  0b1..LPO clock filter enabled
 */
#define RCM_RPFC_RSTFLTSS(x)                     (((uint8_t)(((uint8_t)(x)) << RCM_RPFC_RSTFLTSS_SHIFT)) & RCM_RPFC_RSTFLTSS_MASK)
/*! @} */

/*! @name RPFW - Reset Pin Filter Width register */
/*! @{ */
#define RCM_RPFW_RSTFLTSEL_MASK                  (0x1FU)
#define RCM_RPFW_RSTFLTSEL_SHIFT                 (0U)
/*! RSTFLTSEL - Reset Pin Filter Bus Clock Select
 *  0b00000..Bus clock filter count is 1
 *  0b00001..Bus clock filter count is 2
 *  0b00010..Bus clock filter count is 3
 *  0b00011..Bus clock filter count is 4
 *  0b00100..Bus clock filter count is 5
 *  0b00101..Bus clock filter count is 6
 *  0b00110..Bus clock filter count is 7
 *  0b00111..Bus clock filter count is 8
 *  0b01000..Bus clock filter count is 9
 *  0b01001..Bus clock filter count is 10
 *  0b01010..Bus clock filter count is 11
 *  0b01011..Bus clock filter count is 12
 *  0b01100..Bus clock filter count is 13
 *  0b01101..Bus clock filter count is 14
 *  0b01110..Bus clock filter count is 15
 *  0b01111..Bus clock filter count is 16
 *  0b10000..Bus clock filter count is 17
 *  0b10001..Bus clock filter count is 18
 *  0b10010..Bus clock filter count is 19
 *  0b10011..Bus clock filter count is 20
 *  0b10100..Bus clock filter count is 21
 *  0b10101..Bus clock filter count is 22
 *  0b10110..Bus clock filter count is 23
 *  0b10111..Bus clock filter count is 24
 *  0b11000..Bus clock filter count is 25
 *  0b11001..Bus clock filter count is 26
 *  0b11010..Bus clock filter count is 27
 *  0b11011..Bus clock filter count is 28
 *  0b11100..Bus clock filter count is 29
 *  0b11101..Bus clock filter count is 30
 *  0b11110..Bus clock filter count is 31
 *  0b11111..Bus clock filter count is 32
 */
#define RCM_RPFW_RSTFLTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << RCM_RPFW_RSTFLTSEL_SHIFT)) & RCM_RPFW_RSTFLTSEL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RCM_Register_Masks */


/* RCM - Peripheral instance base addresses */
/** Peripheral RCM base address */
#define RCM_BASE                                 (0x4007F000u)
/** Peripheral RCM base pointer */
#define RCM                                      ((RCM_Type *)RCM_BASE)
/** Array initializer of RCM peripheral base addresses */
#define RCM_BASE_ADDRS                           { RCM_BASE }
/** Array initializer of RCM peripheral base pointers */
#define RCM_BASE_PTRS                            { RCM }

/*!
 * @}
 */ /* end of group RCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RFSYS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Peripheral_Access_Layer RFSYS Peripheral Access Layer
 * @{
 */

/** RFSYS - Register Layout Typedef */
typedef struct {
  __IO uint32_t REG[8];                            /**< Register file register, array offset: 0x0, array step: 0x4 */
} RFSYS_Type;

/* ----------------------------------------------------------------------------
   -- RFSYS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Register_Masks RFSYS Register Masks
 * @{
 */

/*! @name REG - Register file register */
/*! @{ */
#define RFSYS_REG_LL_MASK                        (0xFFU)
#define RFSYS_REG_LL_SHIFT                       (0U)
#define RFSYS_REG_LL(x)                          (((uint32_t)(((uint32_t)(x)) << RFSYS_REG_LL_SHIFT)) & RFSYS_REG_LL_MASK)
#define RFSYS_REG_LH_MASK                        (0xFF00U)
#define RFSYS_REG_LH_SHIFT                       (8U)
#define RFSYS_REG_LH(x)                          (((uint32_t)(((uint32_t)(x)) << RFSYS_REG_LH_SHIFT)) & RFSYS_REG_LH_MASK)
#define RFSYS_REG_HL_MASK                        (0xFF0000U)
#define RFSYS_REG_HL_SHIFT                       (16U)
#define RFSYS_REG_HL(x)                          (((uint32_t)(((uint32_t)(x)) << RFSYS_REG_HL_SHIFT)) & RFSYS_REG_HL_MASK)
#define RFSYS_REG_HH_MASK                        (0xFF000000U)
#define RFSYS_REG_HH_SHIFT                       (24U)
#define RFSYS_REG_HH(x)                          (((uint32_t)(((uint32_t)(x)) << RFSYS_REG_HH_SHIFT)) & RFSYS_REG_HH_MASK)
/*! @} */

/* The count of RFSYS_REG */
#define RFSYS_REG_COUNT                          (8U)


/*!
 * @}
 */ /* end of group RFSYS_Register_Masks */


/* RFSYS - Peripheral instance base addresses */
/** Peripheral RFSYS base address */
#define RFSYS_BASE                               (0x40041000u)
/** Peripheral RFSYS base pointer */
#define RFSYS                                    ((RFSYS_Type *)RFSYS_BASE)
/** Array initializer of RFSYS peripheral base addresses */
#define RFSYS_BASE_ADDRS                         { RFSYS_BASE }
/** Array initializer of RFSYS peripheral base pointers */
#define RFSYS_BASE_PTRS                          { RFSYS }

/*!
 * @}
 */ /* end of group RFSYS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ROM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Peripheral_Access_Layer ROM Peripheral Access Layer
 * @{
 */

/** ROM - Register Layout Typedef */
typedef struct {
  __I  uint32_t ENTRY[3];                          /**< Entry, array offset: 0x0, array step: 0x4 */
  __I  uint32_t TABLEMARK;                         /**< End of Table Marker Register, offset: 0xC */
       uint8_t RESERVED_0[4028];
  __I  uint32_t SYSACCESS;                         /**< System Access Register, offset: 0xFCC */
  __I  uint32_t PERIPHID4;                         /**< Peripheral ID Register, offset: 0xFD0 */
  __I  uint32_t PERIPHID5;                         /**< Peripheral ID Register, offset: 0xFD4 */
  __I  uint32_t PERIPHID6;                         /**< Peripheral ID Register, offset: 0xFD8 */
  __I  uint32_t PERIPHID7;                         /**< Peripheral ID Register, offset: 0xFDC */
  __I  uint32_t PERIPHID0;                         /**< Peripheral ID Register, offset: 0xFE0 */
  __I  uint32_t PERIPHID1;                         /**< Peripheral ID Register, offset: 0xFE4 */
  __I  uint32_t PERIPHID2;                         /**< Peripheral ID Register, offset: 0xFE8 */
  __I  uint32_t PERIPHID3;                         /**< Peripheral ID Register, offset: 0xFEC */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} ROM_Type;

/* ----------------------------------------------------------------------------
   -- ROM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Masks ROM Register Masks
 * @{
 */

/*! @name ENTRY - Entry */
/*! @{ */
#define ROM_ENTRY_ENTRY_MASK                     (0xFFFFFFFFU)
#define ROM_ENTRY_ENTRY_SHIFT                    (0U)
/*! ENTRY - ENTRY
 */
#define ROM_ENTRY_ENTRY(x)                       (((uint32_t)(((uint32_t)(x)) << ROM_ENTRY_ENTRY_SHIFT)) & ROM_ENTRY_ENTRY_MASK)
/*! @} */

/* The count of ROM_ENTRY */
#define ROM_ENTRY_COUNT                          (3U)

/*! @name TABLEMARK - End of Table Marker Register */
/*! @{ */
#define ROM_TABLEMARK_MARK_MASK                  (0xFFFFFFFFU)
#define ROM_TABLEMARK_MARK_SHIFT                 (0U)
/*! MARK - MARK
 */
#define ROM_TABLEMARK_MARK(x)                    (((uint32_t)(((uint32_t)(x)) << ROM_TABLEMARK_MARK_SHIFT)) & ROM_TABLEMARK_MARK_MASK)
/*! @} */

/*! @name SYSACCESS - System Access Register */
/*! @{ */
#define ROM_SYSACCESS_SYSACCESS_MASK             (0xFFFFFFFFU)
#define ROM_SYSACCESS_SYSACCESS_SHIFT            (0U)
/*! SYSACCESS - SYSACCESS
 */
#define ROM_SYSACCESS_SYSACCESS(x)               (((uint32_t)(((uint32_t)(x)) << ROM_SYSACCESS_SYSACCESS_SHIFT)) & ROM_SYSACCESS_SYSACCESS_MASK)
/*! @} */

/*! @name PERIPHID4 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID4_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID4_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID4_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID4_PERIPHID_SHIFT)) & ROM_PERIPHID4_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID5 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID5_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID5_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID5_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID5_PERIPHID_SHIFT)) & ROM_PERIPHID5_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID6 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID6_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID6_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID6_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID6_PERIPHID_SHIFT)) & ROM_PERIPHID6_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID7 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID7_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID7_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID7_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID7_PERIPHID_SHIFT)) & ROM_PERIPHID7_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID0 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID0_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID0_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID0_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID0_PERIPHID_SHIFT)) & ROM_PERIPHID0_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID1 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID1_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID1_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID1_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID1_PERIPHID_SHIFT)) & ROM_PERIPHID1_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID2 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID2_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID2_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID2_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID2_PERIPHID_SHIFT)) & ROM_PERIPHID2_PERIPHID_MASK)
/*! @} */

/*! @name PERIPHID3 - Peripheral ID Register */
/*! @{ */
#define ROM_PERIPHID3_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID3_PERIPHID_SHIFT             (0U)
/*! PERIPHID - PERIPHID
 */
#define ROM_PERIPHID3_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID3_PERIPHID_SHIFT)) & ROM_PERIPHID3_PERIPHID_MASK)
/*! @} */

/*! @name COMPID - Component ID Register */
/*! @{ */
#define ROM_COMPID_COMPID_MASK                   (0xFFFFFFFFU)
#define ROM_COMPID_COMPID_SHIFT                  (0U)
/*! COMPID - Component ID
 */
#define ROM_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x)) << ROM_COMPID_COMPID_SHIFT)) & ROM_COMPID_COMPID_MASK)
/*! @} */

/* The count of ROM_COMPID */
#define ROM_COMPID_COUNT                         (4U)


/*!
 * @}
 */ /* end of group ROM_Register_Masks */


/* ROM - Peripheral instance base addresses */
/** Peripheral ROM base address */
#define ROM_BASE                                 (0xF0002000u)
/** Peripheral ROM base pointer */
#define ROM                                      ((ROM_Type *)ROM_BASE)
/** Array initializer of ROM peripheral base addresses */
#define ROM_BASE_ADDRS                           { ROM_BASE }
/** Array initializer of ROM peripheral base pointers */
#define ROM_BASE_PTRS                            { ROM }

/*!
 * @}
 */ /* end of group ROM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RSIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Peripheral_Access_Layer RSIM Peripheral Access Layer
 * @{
 */

/** RSIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Radio System Control, offset: 0x0 */
  __IO uint32_t DSM_WAKEUP;                        /**< Deep Sleep Wake-up Sequence, offset: 0x4 */
  __I  uint32_t MAC_MSB;                           /**< Radio MAC Address, offset: 0x8 */
  __I  uint32_t MAC_LSB;                           /**< Radio MAC Address, offset: 0xC */
  __IO uint32_t MISC;                              /**< Radio Miscellaneous, offset: 0x10 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SW_CONFIG;                         /**< Radio Software Configuration, offset: 0x18 */
       uint8_t RESERVED_1[228];
  __I  uint32_t DSM_TIMER;                         /**< Deep Sleep Timer, offset: 0x100 */
  __IO uint32_t DSM_CONTROL;                       /**< Deep Sleep Timer Control, offset: 0x104 */
  __IO uint32_t DSM_OSC_OFFSET;                    /**< Deep Sleep Wake-up Time Offset, offset: 0x108 */
       uint8_t RESERVED_2[16];
  __IO uint32_t GEN_SLEEP;                         /**< Generic FSK Link Layer Sleep Time, offset: 0x11C */
  __IO uint32_t GEN_WAKE;                          /**< Generic FSK Link Layer Wake Time, offset: 0x120 */
  __IO uint32_t RF_OSC_CTRL;                       /**< Radio Oscillator Control, offset: 0x124 */
  __IO uint32_t ANA_TEST;                          /**< Radio Analog Test Registers, offset: 0x128 */
  __IO uint32_t ANA_TRIM;                          /**< Radio Analog Trim Registers, offset: 0x12C */
} RSIM_Type;

/* ----------------------------------------------------------------------------
   -- RSIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Register_Masks RSIM Register Masks
 * @{
 */

/*! @name CONTROL - Radio System Control */
/*! @{ */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_EN_MASK      (0x1U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_EN_SHIFT     (0U)
/*! BLE_RF_OSC_REQ_EN - Bluetooth LE Ref Osc (Sysclk) Request Enable
 */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLE_RF_OSC_REQ_EN_SHIFT)) & RSIM_CONTROL_BLE_RF_OSC_REQ_EN_MASK)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_MASK    (0x2U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_SHIFT   (1U)
/*! BLE_RF_OSC_REQ_STAT - Bluetooth LE Ref Osc (Sysclk) Request Status
 */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_STAT(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_SHIFT)) & RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_MASK)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_MASK  (0x10U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_SHIFT (4U)
/*! BLE_RF_OSC_REQ_INT_EN - Bluetooth LE Ref Osc (Sysclk) Request Interrupt Enable
 */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_SHIFT)) & RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_MASK)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_MASK     (0x20U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_SHIFT    (5U)
/*! BLE_RF_OSC_REQ_INT - Bluetooth LE Ref Osc (Sysclk) Request Interrupt Flag
 */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT(x)       (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLE_RF_OSC_REQ_INT_SHIFT)) & RSIM_CONTROL_BLE_RF_OSC_REQ_INT_MASK)
#define RSIM_CONTROL_RF_OSC_EN_MASK              (0xF00U)
#define RSIM_CONTROL_RF_OSC_EN_SHIFT             (8U)
/*! RF_OSC_EN - RF Ref Osc Enable Select
 *  0b0000..RF Ref Osc is controlled by the SoC, external pin, or a link layer
 *  0b0001..RF Ref Osc on in Run/Wait
 *  0b0011..RF Ref Osc on in Stop
 *  0b0111..RF Ref Osc on in VLPR/VLPW
 *  0b1111..RF Ref Osc on in VLPS
 */
#define RSIM_CONTROL_RF_OSC_EN(x)                (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RF_OSC_EN_SHIFT)) & RSIM_CONTROL_RF_OSC_EN_MASK)
#define RSIM_CONTROL_TXRAMPO_MASK                (0x40000U)
#define RSIM_CONTROL_TXRAMPO_SHIFT               (18U)
/*! TXRAMPO - Radio TX RAM Power Option
 *  0b0..TX RAM not powered in VLLS2
 *  0b1..TX RAM powered in VLLS2
 */
#define RSIM_CONTROL_TXRAMPO(x)                  (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_TXRAMPO_SHIFT)) & RSIM_CONTROL_TXRAMPO_MASK)
#define RSIM_CONTROL_RXRAMPO_MASK                (0x80000U)
#define RSIM_CONTROL_RXRAMPO_SHIFT               (19U)
/*! RXRAMPO - Radio RX RAM Power Option
 *  0b0..RX RAM not powered in VLLS2
 *  0b1..RX RAM powered in VLLS2
 */
#define RSIM_CONTROL_RXRAMPO(x)                  (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RXRAMPO_SHIFT)) & RSIM_CONTROL_RXRAMPO_MASK)
#define RSIM_CONTROL_RSIM_DSM_EXIT_MASK          (0x100000U)
#define RSIM_CONTROL_RSIM_DSM_EXIT_SHIFT         (20U)
/*! RSIM_DSM_EXIT - Bluetooth LE Force Deep Sleep Mode Exit
 */
#define RSIM_CONTROL_RSIM_DSM_EXIT(x)            (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RSIM_DSM_EXIT_SHIFT)) & RSIM_CONTROL_RSIM_DSM_EXIT_MASK)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_MASK  (0x400000U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_SHIFT (22U)
/*! RSIM_STOP_ACK_OVRD_EN - Stop Acknowledge Override Enable
 */
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_SHIFT)) & RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_MASK)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_MASK     (0x800000U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_SHIFT    (23U)
/*! RSIM_STOP_ACK_OVRD - Stop Acknowledge Override
 */
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD(x)       (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RSIM_STOP_ACK_OVRD_SHIFT)) & RSIM_CONTROL_RSIM_STOP_ACK_OVRD_MASK)
#define RSIM_CONTROL_RF_OSC_READY_MASK           (0x1000000U)
#define RSIM_CONTROL_RF_OSC_READY_SHIFT          (24U)
/*! RF_OSC_READY - RF Ref Osc Ready
 */
#define RSIM_CONTROL_RF_OSC_READY(x)             (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RF_OSC_READY_SHIFT)) & RSIM_CONTROL_RF_OSC_READY_MASK)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_EN_MASK   (0x2000000U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_EN_SHIFT  (25U)
/*! RF_OSC_READY_OVRD_EN - RF Ref Osc Ready Override Enable
 */
#define RSIM_CONTROL_RF_OSC_READY_OVRD_EN(x)     (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RF_OSC_READY_OVRD_EN_SHIFT)) & RSIM_CONTROL_RF_OSC_READY_OVRD_EN_MASK)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_MASK      (0x4000000U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_SHIFT     (26U)
/*! RF_OSC_READY_OVRD - RF Ref Osc Ready Override
 */
#define RSIM_CONTROL_RF_OSC_READY_OVRD(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RF_OSC_READY_OVRD_SHIFT)) & RSIM_CONTROL_RF_OSC_READY_OVRD_MASK)
#define RSIM_CONTROL_BLOCK_SOC_RESETS_MASK       (0x10000000U)
#define RSIM_CONTROL_BLOCK_SOC_RESETS_SHIFT      (28U)
/*! BLOCK_SOC_RESETS - Block SoC Resets of the Radio
 */
#define RSIM_CONTROL_BLOCK_SOC_RESETS(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLOCK_SOC_RESETS_SHIFT)) & RSIM_CONTROL_BLOCK_SOC_RESETS_MASK)
#define RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_MASK    (0x20000000U)
#define RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_SHIFT   (29U)
/*! BLOCK_RADIO_OUTPUTS - Block Radio Outputs
 */
#define RSIM_CONTROL_BLOCK_RADIO_OUTPUTS(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_SHIFT)) & RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_MASK)
#define RSIM_CONTROL_RADIO_RESET_BIT_MASK        (0x80000000U)
#define RSIM_CONTROL_RADIO_RESET_BIT_SHIFT       (31U)
/*! RADIO_RESET_BIT - Software Reset for the Radio
 */
#define RSIM_CONTROL_RADIO_RESET_BIT(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RADIO_RESET_BIT_SHIFT)) & RSIM_CONTROL_RADIO_RESET_BIT_MASK)
/*! @} */

/*! @name DSM_WAKEUP - Deep Sleep Wake-up Sequence */
/*! @{ */
#define RSIM_DSM_WAKEUP_FINE_DELAY_MASK          (0x3FU)
#define RSIM_DSM_WAKEUP_FINE_DELAY_SHIFT         (0U)
/*! FINE_DELAY - Deep Sleep Wake-up Fine Delay Time
 */
#define RSIM_DSM_WAKEUP_FINE_DELAY(x)            (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_WAKEUP_FINE_DELAY_SHIFT)) & RSIM_DSM_WAKEUP_FINE_DELAY_MASK)
#define RSIM_DSM_WAKEUP_COARSE_DELAY_MASK        (0xF0000U)
#define RSIM_DSM_WAKEUP_COARSE_DELAY_SHIFT       (16U)
/*! COARSE_DELAY - Deep Sleep Wake-up Coarse Delay Time
 */
#define RSIM_DSM_WAKEUP_COARSE_DELAY(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_WAKEUP_COARSE_DELAY_SHIFT)) & RSIM_DSM_WAKEUP_COARSE_DELAY_MASK)
#define RSIM_DSM_WAKEUP_ACTIVE_WARNING_MASK      (0x3F000000U)
#define RSIM_DSM_WAKEUP_ACTIVE_WARNING_SHIFT     (24U)
/*! ACTIVE_WARNING - Deep Sleep Wake-up RF Active Warning Time
 */
#define RSIM_DSM_WAKEUP_ACTIVE_WARNING(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_WAKEUP_ACTIVE_WARNING_SHIFT)) & RSIM_DSM_WAKEUP_ACTIVE_WARNING_MASK)
/*! @} */

/*! @name MAC_MSB - Radio MAC Address */
/*! @{ */
#define RSIM_MAC_MSB_MAC_ADDR_MSB_MASK           (0xFFU)
#define RSIM_MAC_MSB_MAC_ADDR_MSB_SHIFT          (0U)
/*! MAC_ADDR_MSB - Radio MAC Address MSB
 */
#define RSIM_MAC_MSB_MAC_ADDR_MSB(x)             (((uint32_t)(((uint32_t)(x)) << RSIM_MAC_MSB_MAC_ADDR_MSB_SHIFT)) & RSIM_MAC_MSB_MAC_ADDR_MSB_MASK)
/*! @} */

/*! @name MAC_LSB - Radio MAC Address */
/*! @{ */
#define RSIM_MAC_LSB_MAC_ADDR_LSB_MASK           (0xFFFFFFFFU)
#define RSIM_MAC_LSB_MAC_ADDR_LSB_SHIFT          (0U)
/*! MAC_ADDR_LSB - Radio MAC Address LSB
 */
#define RSIM_MAC_LSB_MAC_ADDR_LSB(x)             (((uint32_t)(((uint32_t)(x)) << RSIM_MAC_LSB_MAC_ADDR_LSB_SHIFT)) & RSIM_MAC_LSB_MAC_ADDR_LSB_MASK)
/*! @} */

/*! @name MISC - Radio Miscellaneous */
/*! @{ */
#define RSIM_MISC_RADIO_VERSION_MASK             (0xFF000000U)
#define RSIM_MISC_RADIO_VERSION_SHIFT            (24U)
/*! RADIO_VERSION - Radio Version ID number
 */
#define RSIM_MISC_RADIO_VERSION(x)               (((uint32_t)(((uint32_t)(x)) << RSIM_MISC_RADIO_VERSION_SHIFT)) & RSIM_MISC_RADIO_VERSION_MASK)
/*! @} */

/*! @name SW_CONFIG - Radio Software Configuration */
/*! @{ */
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_POR_RESET_MASK (0x1U)
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_POR_RESET_SHIFT (0U)
/*! RADIO_CONFIGURED_POR_RESET - Radio Configuration Bit, cleared by Radio power-on reset
 */
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_POR_RESET(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_CONFIGURED_POR_RESET_SHIFT)) & RSIM_SW_CONFIG_RADIO_CONFIGURED_POR_RESET_MASK)
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_SYS_RESET_MASK (0x2U)
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_SYS_RESET_SHIFT (1U)
/*! RADIO_CONFIGURED_SYS_RESET - Radio Configuration Bit, cleared by Radio System Reset
 */
#define RSIM_SW_CONFIG_RADIO_CONFIGURED_SYS_RESET(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_CONFIGURED_SYS_RESET_SHIFT)) & RSIM_SW_CONFIG_RADIO_CONFIGURED_SYS_RESET_MASK)
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_MASK  (0x10U)
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_SHIFT (4U)
/*! RSIM_RF_ACTIVE_OVRD - RF Active Internal Override
 */
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_SHIFT)) & RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_MASK)
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_EN_MASK (0x20U)
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_EN_SHIFT (5U)
/*! RSIM_RF_ACTIVE_OVRD_EN - RF Active Internal Override Enable
 */
#define RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_EN_SHIFT)) & RSIM_SW_CONFIG_RSIM_RF_ACTIVE_OVRD_EN_MASK)
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD_MASK       (0x40U)
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD_SHIFT      (6U)
/*! RF_OSC_EN_OVRD - Radio Osc Enable Override
 */
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RF_OSC_EN_OVRD_SHIFT)) & RSIM_SW_CONFIG_RF_OSC_EN_OVRD_MASK)
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD_EN_MASK    (0x80U)
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD_EN_SHIFT   (7U)
/*! RF_OSC_EN_OVRD_EN - Radio Osc Enable Override Enable
 */
#define RSIM_SW_CONFIG_RF_OSC_EN_OVRD_EN(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RF_OSC_EN_OVRD_EN_SHIFT)) & RSIM_SW_CONFIG_RF_OSC_EN_OVRD_EN_MASK)
#define RSIM_SW_CONFIG_IPP_IBE_RF_NOT_ALLOWED_MASK (0x100U)
#define RSIM_SW_CONFIG_IPP_IBE_RF_NOT_ALLOWED_SHIFT (8U)
/*! IPP_IBE_RF_NOT_ALLOWED - IPP_IBE_RF_NOT_ALLOWED
 */
#define RSIM_SW_CONFIG_IPP_IBE_RF_NOT_ALLOWED(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_IBE_RF_NOT_ALLOWED_SHIFT)) & RSIM_SW_CONFIG_IPP_IBE_RF_NOT_ALLOWED_MASK)
#define RSIM_SW_CONFIG_IPP_IBE_RF_EXT_OSC_EN_MASK (0x200U)
#define RSIM_SW_CONFIG_IPP_IBE_RF_EXT_OSC_EN_SHIFT (9U)
/*! IPP_IBE_RF_EXT_OSC_EN - IPP_IBE_RF_EXT_OSC_EN
 */
#define RSIM_SW_CONFIG_IPP_IBE_RF_EXT_OSC_EN(x)  (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_IBE_RF_EXT_OSC_EN_SHIFT)) & RSIM_SW_CONFIG_IPP_IBE_RF_EXT_OSC_EN_MASK)
#define RSIM_SW_CONFIG_IPP_OBE_RF_OSC_EN_MASK    (0x800U)
#define RSIM_SW_CONFIG_IPP_OBE_RF_OSC_EN_SHIFT   (11U)
/*! IPP_OBE_RF_OSC_EN - IPP_OBE_RF_OSC_EN
 */
#define RSIM_SW_CONFIG_IPP_OBE_RF_OSC_EN(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_OBE_RF_OSC_EN_SHIFT)) & RSIM_SW_CONFIG_IPP_OBE_RF_OSC_EN_MASK)
#define RSIM_SW_CONFIG_RADIO_RF_NOT_ALLOWED_SEL_MASK (0x1000U)
#define RSIM_SW_CONFIG_RADIO_RF_NOT_ALLOWED_SEL_SHIFT (12U)
/*! RADIO_RF_NOT_ALLOWED_SEL - Radio RF_NOT_ALLOWED Select
 *  0b0..PTB2
 *  0b1..PTC5
 */
#define RSIM_SW_CONFIG_RADIO_RF_NOT_ALLOWED_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_RF_NOT_ALLOWED_SEL_SHIFT)) & RSIM_SW_CONFIG_RADIO_RF_NOT_ALLOWED_SEL_MASK)
#define RSIM_SW_CONFIG_RADIO_BLE_EARLY_WARNING_SEL_MASK (0x4000U)
#define RSIM_SW_CONFIG_RADIO_BLE_EARLY_WARNING_SEL_SHIFT (14U)
/*! RADIO_BLE_EARLY_WARNING_SEL - Radio BLE_EARLY_WARNING Select
 *  0b0..PTC19
 *  0b1..PTC1
 */
#define RSIM_SW_CONFIG_RADIO_BLE_EARLY_WARNING_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_BLE_EARLY_WARNING_SEL_SHIFT)) & RSIM_SW_CONFIG_RADIO_BLE_EARLY_WARNING_SEL_MASK)
#define RSIM_SW_CONFIG_IPP_OBE_BLE_EARLY_WARNING_MASK (0x8000U)
#define RSIM_SW_CONFIG_IPP_OBE_BLE_EARLY_WARNING_SHIFT (15U)
/*! IPP_OBE_BLE_EARLY_WARNING - IPP_OBE_BLE_EARLY_WARNING
 */
#define RSIM_SW_CONFIG_IPP_OBE_BLE_EARLY_WARNING(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_OBE_BLE_EARLY_WARNING_SHIFT)) & RSIM_SW_CONFIG_IPP_OBE_BLE_EARLY_WARNING_MASK)
#define RSIM_SW_CONFIG_WIFI_COEXIST_1_MASK       (0x10000U)
#define RSIM_SW_CONFIG_WIFI_COEXIST_1_SHIFT      (16U)
/*! WIFI_COEXIST_1 - RF_ACTIVE Source
 */
#define RSIM_SW_CONFIG_WIFI_COEXIST_1(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_WIFI_COEXIST_1_SHIFT)) & RSIM_SW_CONFIG_WIFI_COEXIST_1_MASK)
#define RSIM_SW_CONFIG_WIFI_COEXIST_2_MASK       (0x20000U)
#define RSIM_SW_CONFIG_WIFI_COEXIST_2_SHIFT      (17U)
/*! WIFI_COEXIST_2 - RF_STATUS Source
 */
#define RSIM_SW_CONFIG_WIFI_COEXIST_2(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_WIFI_COEXIST_2_SHIFT)) & RSIM_SW_CONFIG_WIFI_COEXIST_2_MASK)
#define RSIM_SW_CONFIG_WIFI_COEXIST_3_MASK       (0x40000U)
#define RSIM_SW_CONFIG_WIFI_COEXIST_3_SHIFT      (18U)
/*! WIFI_COEXIST_3 - RF_EARLY_WARNING Source
 */
#define RSIM_SW_CONFIG_WIFI_COEXIST_3(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_WIFI_COEXIST_3_SHIFT)) & RSIM_SW_CONFIG_WIFI_COEXIST_3_MASK)
#define RSIM_SW_CONFIG_RF_ACTIVE_ENDS_WITH_TSM_MASK (0x100000U)
#define RSIM_SW_CONFIG_RF_ACTIVE_ENDS_WITH_TSM_SHIFT (20U)
/*! RF_ACTIVE_ENDS_WITH_TSM - RF_ACTIVE clearing mechanism
 */
#define RSIM_SW_CONFIG_RF_ACTIVE_ENDS_WITH_TSM(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RF_ACTIVE_ENDS_WITH_TSM_SHIFT)) & RSIM_SW_CONFIG_RF_ACTIVE_ENDS_WITH_TSM_MASK)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_ENDS_WITH_TSM_MASK (0x200000U)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_ENDS_WITH_TSM_SHIFT (21U)
/*! SW_RF_ACTIVE_ENDS_WITH_TSM - Software RF_ACTIVE clearing mechanism
 */
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_ENDS_WITH_TSM(x) (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_SW_RF_ACTIVE_ENDS_WITH_TSM_SHIFT)) & RSIM_SW_CONFIG_SW_RF_ACTIVE_ENDS_WITH_TSM_MASK)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_BIT_MASK     (0x400000U)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_BIT_SHIFT    (22U)
/*! SW_RF_ACTIVE_BIT - Software RF_ACTIVE Control Bit
 */
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_BIT(x)       (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_SW_RF_ACTIVE_BIT_SHIFT)) & RSIM_SW_CONFIG_SW_RF_ACTIVE_BIT_MASK)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_EN_MASK      (0x800000U)
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_EN_SHIFT     (23U)
/*! SW_RF_ACTIVE_EN - Software RF_ACTIVE Control Enable
 */
#define RSIM_SW_CONFIG_SW_RF_ACTIVE_EN(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_SW_RF_ACTIVE_EN_SHIFT)) & RSIM_SW_CONFIG_SW_RF_ACTIVE_EN_MASK)
#define RSIM_SW_CONFIG_IPP_OBE_RF_PRIORITY_MASK  (0x1000000U)
#define RSIM_SW_CONFIG_IPP_OBE_RF_PRIORITY_SHIFT (24U)
/*! IPP_OBE_RF_PRIORITY - IPP_OBE_RF_PRIORITY
 */
#define RSIM_SW_CONFIG_IPP_OBE_RF_PRIORITY(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_OBE_RF_PRIORITY_SHIFT)) & RSIM_SW_CONFIG_IPP_OBE_RF_PRIORITY_MASK)
#define RSIM_SW_CONFIG_IPP_OBE_RF_STATUS_MASK    (0x2000000U)
#define RSIM_SW_CONFIG_IPP_OBE_RF_STATUS_SHIFT   (25U)
/*! IPP_OBE_RF_STATUS - IPP_OBE_RF_STATUS
 */
#define RSIM_SW_CONFIG_IPP_OBE_RF_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_OBE_RF_STATUS_SHIFT)) & RSIM_SW_CONFIG_IPP_OBE_RF_STATUS_MASK)
#define RSIM_SW_CONFIG_IPP_OBE_RF_ACTIVE_MASK    (0x4000000U)
#define RSIM_SW_CONFIG_IPP_OBE_RF_ACTIVE_SHIFT   (26U)
/*! IPP_OBE_RF_ACTIVE - IPP_OBE_RF_ACTIVE
 */
#define RSIM_SW_CONFIG_IPP_OBE_RF_ACTIVE(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_IPP_OBE_RF_ACTIVE_SHIFT)) & RSIM_SW_CONFIG_IPP_OBE_RF_ACTIVE_MASK)
#define RSIM_SW_CONFIG_RADIO_RF_PRIORITY_SEL_MASK (0x8000000U)
#define RSIM_SW_CONFIG_RADIO_RF_PRIORITY_SEL_SHIFT (27U)
/*! RADIO_RF_PRIORITY_SEL - Radio RF_PRIORITY Select
 *  0b0..PTB1
 *  0b1..PTC5
 */
#define RSIM_SW_CONFIG_RADIO_RF_PRIORITY_SEL(x)  (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_RF_PRIORITY_SEL_SHIFT)) & RSIM_SW_CONFIG_RADIO_RF_PRIORITY_SEL_MASK)
#define RSIM_SW_CONFIG_RADIO_RF_STATUS_SEL_MASK  (0x10000000U)
#define RSIM_SW_CONFIG_RADIO_RF_STATUS_SEL_SHIFT (28U)
/*! RADIO_RF_STATUS_SEL - Radio RF_STATUS Select
 *  0b0..PTC16
 *  0b1..PTA1
 */
#define RSIM_SW_CONFIG_RADIO_RF_STATUS_SEL(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_RF_STATUS_SEL_SHIFT)) & RSIM_SW_CONFIG_RADIO_RF_STATUS_SEL_MASK)
#define RSIM_SW_CONFIG_RADIO_RF_ACTIVE_SEL_MASK  (0x60000000U)
#define RSIM_SW_CONFIG_RADIO_RF_ACTIVE_SEL_SHIFT (29U)
/*! RADIO_RF_ACTIVE_SEL - Radio RF_ACTIVE Select
 *  0b00..PTC4
 *  0b01..PTB3
 *  0b10..PTA0
 */
#define RSIM_SW_CONFIG_RADIO_RF_ACTIVE_SEL(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_RADIO_RF_ACTIVE_SEL_SHIFT)) & RSIM_SW_CONFIG_RADIO_RF_ACTIVE_SEL_MASK)
#define RSIM_SW_CONFIG_BLOCK_EXT_OSC_PWR_REQ_MASK (0x80000000U)
#define RSIM_SW_CONFIG_BLOCK_EXT_OSC_PWR_REQ_SHIFT (31U)
/*! BLOCK_EXT_OSC_PWR_REQ - Block External Requests for RF Ref OSC from starting a Radio Power Wake-up Sequence
 */
#define RSIM_SW_CONFIG_BLOCK_EXT_OSC_PWR_REQ(x)  (((uint32_t)(((uint32_t)(x)) << RSIM_SW_CONFIG_BLOCK_EXT_OSC_PWR_REQ_SHIFT)) & RSIM_SW_CONFIG_BLOCK_EXT_OSC_PWR_REQ_MASK)
/*! @} */

/*! @name DSM_TIMER - Deep Sleep Timer */
/*! @{ */
#define RSIM_DSM_TIMER_DSM_TIMER_MASK            (0xFFFFFFU)
#define RSIM_DSM_TIMER_DSM_TIMER_SHIFT           (0U)
/*! DSM_TIMER - Deep Sleep Mode Timer
 */
#define RSIM_DSM_TIMER_DSM_TIMER(x)              (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_TIMER_DSM_TIMER_SHIFT)) & RSIM_DSM_TIMER_DSM_TIMER_MASK)
/*! @} */

/*! @name DSM_CONTROL - Deep Sleep Timer Control */
/*! @{ */
#define RSIM_DSM_CONTROL_DSM_GEN_READY_MASK      (0x100U)
#define RSIM_DSM_CONTROL_DSM_GEN_READY_SHIFT     (8U)
/*! DSM_GEN_READY - Generic FSK Ready for Deep Sleep Mode
 */
#define RSIM_DSM_CONTROL_DSM_GEN_READY(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_DSM_GEN_READY_SHIFT)) & RSIM_DSM_CONTROL_DSM_GEN_READY_MASK)
#define RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_MASK (0x200U)
#define RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_SHIFT (9U)
/*! GEN_DEEP_SLEEP_STATUS - Generic FSK Link Layer Deep Sleep Mode Status
 */
#define RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS(x) (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_SHIFT)) & RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_MASK)
#define RSIM_DSM_CONTROL_DSM_GEN_FINISHED_MASK   (0x400U)
#define RSIM_DSM_CONTROL_DSM_GEN_FINISHED_SHIFT  (10U)
/*! DSM_GEN_FINISHED - Generic FSK Deep Sleep Time Finished
 */
#define RSIM_DSM_CONTROL_DSM_GEN_FINISHED(x)     (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_DSM_GEN_FINISHED_SHIFT)) & RSIM_DSM_CONTROL_DSM_GEN_FINISHED_MASK)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_MASK (0x800U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_SHIFT (11U)
/*! GEN_SYSCLK_REQUEST_EN - Enable Generic FSK Link Layer to Request RF Ref OSC
 */
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_SHIFT)) & RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_MASK)
#define RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_MASK  (0x1000U)
#define RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_SHIFT (12U)
/*! GEN_SLEEP_REQUEST - Generic FSK Link Layer Deep Sleep Requested
 */
#define RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_SHIFT)) & RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_MASK)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_MASK     (0x2000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_SHIFT    (13U)
/*! GEN_SYSCLK_REQ - Generic FSK Link Layer RF Ref OSC Request Status
 */
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ(x)       (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_SHIFT)) & RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_MASK)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_MASK (0x4000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_SHIFT (14U)
/*! GEN_SYSCLK_INTERRUPT_EN - Generic FSK Link Layer RF Ref OSC Request Interrupt Enable
 */
#define RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_SHIFT)) & RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_MASK)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_MASK (0x8000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_SHIFT (15U)
/*! GEN_SYSCLK_REQ_INT - Interrupt Flag from an Generic FSK Link Layer RF Ref OSC Request
 */
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT(x)   (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_SHIFT)) & RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_MASK)
#define RSIM_DSM_CONTROL_GEN_FSM_STATE_MASK      (0x1F0000U)
#define RSIM_DSM_CONTROL_GEN_FSM_STATE_SHIFT     (16U)
/*! GEN_FSM_STATE - GEN Deep Sleep State Machine State
 */
#define RSIM_DSM_CONTROL_GEN_FSM_STATE(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_GEN_FSM_STATE_SHIFT)) & RSIM_DSM_CONTROL_GEN_FSM_STATE_MASK)
#define RSIM_DSM_CONTROL_DSM_TIMER_CLR_MASK      (0x8000000U)
#define RSIM_DSM_CONTROL_DSM_TIMER_CLR_SHIFT     (27U)
/*! DSM_TIMER_CLR - Deep Sleep Mode Timer Clear
 */
#define RSIM_DSM_CONTROL_DSM_TIMER_CLR(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_DSM_TIMER_CLR_SHIFT)) & RSIM_DSM_CONTROL_DSM_TIMER_CLR_MASK)
#define RSIM_DSM_CONTROL_DSM_TIMER_EN_MASK       (0x80000000U)
#define RSIM_DSM_CONTROL_DSM_TIMER_EN_SHIFT      (31U)
/*! DSM_TIMER_EN - Deep Sleep Mode Timer Enable
 */
#define RSIM_DSM_CONTROL_DSM_TIMER_EN(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_CONTROL_DSM_TIMER_EN_SHIFT)) & RSIM_DSM_CONTROL_DSM_TIMER_EN_MASK)
/*! @} */

/*! @name DSM_OSC_OFFSET - Deep Sleep Wake-up Time Offset */
/*! @{ */
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_MASK (0x3FFU)
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_SHIFT (0U)
/*! DSM_OSC_STABILIZE_TIME - Deep Sleep Wake-up RF Ref OSC Stabilize Time
 */
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME(x) (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_SHIFT)) & RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_MASK)
/*! @} */

/*! @name GEN_SLEEP - Generic FSK Link Layer Sleep Time */
/*! @{ */
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME_MASK       (0xFFFFFFU)
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME_SHIFT      (0U)
/*! GEN_SLEEP_TIME - Generic FSK Link Layer Sleep Time
 */
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_GEN_SLEEP_GEN_SLEEP_TIME_SHIFT)) & RSIM_GEN_SLEEP_GEN_SLEEP_TIME_MASK)
/*! @} */

/*! @name GEN_WAKE - Generic FSK Link Layer Wake Time */
/*! @{ */
#define RSIM_GEN_WAKE_GEN_WAKE_TIME_MASK         (0xFFFFFFU)
#define RSIM_GEN_WAKE_GEN_WAKE_TIME_SHIFT        (0U)
/*! GEN_WAKE_TIME - Generic FSK Link Layer Wake Time
 */
#define RSIM_GEN_WAKE_GEN_WAKE_TIME(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_GEN_WAKE_GEN_WAKE_TIME_SHIFT)) & RSIM_GEN_WAKE_GEN_WAKE_TIME_MASK)
/*! @} */

/*! @name RF_OSC_CTRL - Radio Oscillator Control */
/*! @{ */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_MASK (0x3U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_SHIFT (0U)
/*! BB_XTAL_ALC_COUNT_SEL - rmap_bb_xtal_alc_count_sel_hv[1:0]
 *  0b00..2048 (64 us @ 32 MHz)
 *  0b01..4096 (128 us @ 32 MHz)
 *  0b10..8192 (256 us @ 32 MHz)
 *  0b11..16384 (512 us @ 32 MHz)
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_MASK     (0x4U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_SHIFT    (2U)
/*! BB_XTAL_ALC_ON - rmap_bb_xtal_alc_on_hv
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON(x)       (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_MASK)
#define RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_MASK   (0x8U)
#define RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_SHIFT  (3U)
/*! RF_OSC_BYPASS_EN - RF Ref Osc Bypass Enable
 */
#define RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN(x)     (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_SHIFT)) & RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_MASK  (0x1F0U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_SHIFT (4U)
/*! BB_XTAL_COMP_BIAS - rmap_bb_xtal_comp_bias_hv[4:0]
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_MASK (0x200U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_SHIFT (9U)
/*! BB_XTAL_DC_COUP_MODE_EN - rmap_bb_xtal_dc_coup_mode_en_hv
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_MASK    (0x400U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_SHIFT   (10U)
/*! BB_XTAL_DIAGSEL - rmap_bb_xtal_diagsel_hv
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_MASK (0x800U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_SHIFT (11U)
/*! BB_XTAL_DIG_CLK_ON - rmap_bb_xtal_dig_clk_on_hv
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON(x)   (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM_MASK         (0x1F000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM_SHIFT        (12U)
/*! BB_XTAL_GM - rmap_bb_xtal_gm_hv[4:0]
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_GM_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_GM_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_MASK    (0x20000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_SHIFT   (17U)
/*! BB_XTAL_ON_OVRD - rmap_bb_xtal_on_ovrd_hv
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_MASK (0x40000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_SHIFT (18U)
/*! BB_XTAL_ON_OVRD_ON - rmap_bb_xtal_on_ovrd_on_hv
 *  0b0..rfctrl_bb_xtal_on_hv is asserted
 *  0b1..rfctrl_bb_xtal_on_ovrd_hv is asserted
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON(x)   (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_MASK (0x300000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_SHIFT (20U)
/*! BB_XTAL_READY_COUNT_SEL - rmap_bb_xtal_ready_count_sel_hv[1:0]
 *  0b00..1024 counts (32 us @ 32 MHz)
 *  0b01..2048 (64 us @ 32 MHz)
 *  0b10..4096 (128 us @ 32 MHz)
 *  0b11..8192 (256 us @ 32 MHz)
 */
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_MASK)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_MASK (0x8000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_SHIFT (27U)
/*! RADIO_EXT_OSC_RF_EN_SEL - Radio External Request for RF Ref OSC Select
 *  0b0..PTC6
 *  0b1..PTB0
 */
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_SHIFT)) & RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_MASK)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_MASK (0x10000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_SHIFT (28U)
/*! RADIO_EXT_OSC_OVRD - Radio External Request for RF Ref OSC Override
 */
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD(x)   (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_SHIFT)) & RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_MASK)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_MASK (0x20000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_SHIFT (29U)
/*! RADIO_EXT_OSC_OVRD_EN - Radio External Request for RF Ref OSC Override Enable
 */
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_SHIFT)) & RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_MASK)
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_MASK (0x40000000U)
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_SHIFT (30U)
/*! RF_NOT_ALLOWED_OVRD - RF Not Allowed Override
 */
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD(x)  (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_SHIFT)) & RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_MASK)
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_EN_MASK (0x80000000U)
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_EN_SHIFT (31U)
/*! RF_NOT_ALLOWED_OVRD_EN - RF Not Allowed Override Enable
 */
#define RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_EN_SHIFT)) & RSIM_RF_OSC_CTRL_RF_NOT_ALLOWED_OVRD_EN_MASK)
/*! @} */

/*! @name ANA_TEST - Radio Analog Test Registers */
/*! @{ */
#define RSIM_ANA_TEST_XTAL_OUT_BUF_EN_MASK       (0x10U)
#define RSIM_ANA_TEST_XTAL_OUT_BUF_EN_SHIFT      (4U)
/*! XTAL_OUT_BUF_EN - XTAL Output Buffer Enable
 */
#define RSIM_ANA_TEST_XTAL_OUT_BUF_EN(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TEST_XTAL_OUT_BUF_EN_SHIFT)) & RSIM_ANA_TEST_XTAL_OUT_BUF_EN_MASK)
/*! @} */

/*! @name ANA_TRIM - Radio Analog Trim Registers */
/*! @{ */
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE_MASK       (0x3U)
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE_SHIFT      (0U)
/*! BB_LDO_LS_SPARE - rmap_bb_ldo_ls_spare_hv[1:0]
 */
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_LS_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_LS_SPARE_MASK)
#define RSIM_ANA_TRIM_BG_1V_TRIM_OVRD_MASK       (0x4U)
#define RSIM_ANA_TRIM_BG_1V_TRIM_OVRD_SHIFT      (2U)
/*! BG_1V_TRIM_OVRD - Bandgap 1V Trim Override
 */
#define RSIM_ANA_TRIM_BG_1V_TRIM_OVRD(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BG_1V_TRIM_OVRD_SHIFT)) & RSIM_ANA_TRIM_BG_1V_TRIM_OVRD_MASK)
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM_MASK        (0x38U)
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM_SHIFT       (3U)
/*! BB_LDO_LS_TRIM - rmap_bb_ldo_ls_trim_hv[2:0]
 *  0b000..1.20 V (Default)
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_LS_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_LS_TRIM_MASK)
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE_MASK       (0xC0U)
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE_SHIFT      (6U)
/*! BB_LDO_XO_SPARE - rmap_bb_ldo_xo_spare_hv[1:0]
 */
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_XO_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_XO_SPARE_MASK)
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM_MASK        (0x700U)
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM_SHIFT       (8U)
/*! BB_LDO_XO_TRIM - rmap_bb_ldo_xo_trim_hv[2:0]
 *  0b000..1.20 V (Default)
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_XO_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_XO_TRIM_MASK)
#define RSIM_ANA_TRIM_BB_XTAL_SPARE_MASK         (0xF800U)
#define RSIM_ANA_TRIM_BB_XTAL_SPARE_SHIFT        (11U)
/*! BB_XTAL_SPARE - rmap_bb_xtal_spare_hv[4:0]
 */
#define RSIM_ANA_TRIM_BB_XTAL_SPARE(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_XTAL_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_XTAL_SPARE_MASK)
#define RSIM_ANA_TRIM_BB_XTAL_TRIM_MASK          (0xFF0000U)
#define RSIM_ANA_TRIM_BB_XTAL_TRIM_SHIFT         (16U)
/*! BB_XTAL_TRIM - rmap_bb_xtal_trim_hv[7:0]
 */
#define RSIM_ANA_TRIM_BB_XTAL_TRIM(x)            (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_XTAL_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_XTAL_TRIM_MASK)
#define RSIM_ANA_TRIM_BG_1V_TRIM_MASK            (0xF000000U)
#define RSIM_ANA_TRIM_BG_1V_TRIM_SHIFT           (24U)
/*! BG_1V_TRIM - rmap_bg_1v_trim_hv[3:0]
 *  0b0000..954.14 mV
 *  0b0001..959.26 mV
 *  0b0010..964.38 mV
 *  0b0011..969.5 mV
 *  0b0100..974.6 mV
 *  0b0101..979.7 mV
 *  0b0110..984.8 mV
 *  0b0111..989.9 mV
 *  0b1000..995 mV (Default)
 *  0b1001..1 V
 *  0b1010..1.005 V
 *  0b1011..1.01 V
 *  0b1100..1.015 V
 *  0b1101..1.02 V
 *  0b1110..1.025 V
 *  0b1111..1.031 V
 */
#define RSIM_ANA_TRIM_BG_1V_TRIM(x)              (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BG_1V_TRIM_SHIFT)) & RSIM_ANA_TRIM_BG_1V_TRIM_MASK)
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_MASK      (0xF0000000U)
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_SHIFT     (28U)
/*! BG_IBIAS_5U_TRIM - rmap_bg_ibias_5u_trim_hv[3:0]
 *  0b0000..3.55 uA
 *  0b0001..3.73 uA
 *  0b0010..4.04 uA
 *  0b0011..4.22 uA
 *  0b0100..4.39 uA
 *  0b0101..4.57 uA
 *  0b0110..4.89 uA
 *  0b0111..5.06 (Default)
 *  0b1000..5.23 uA
 *  0b1001..5.41 uA
 *  0b1010..5.72 uA
 *  0b1011..5.9 uA
 *  0b1100..6.07 uA
 *  0b1101..6.25 uA
 *  0b1110..6.56 uA
 *  0b1111..6.74 uA
 */
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_SHIFT)) & RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RSIM_Register_Masks */


/* RSIM - Peripheral instance base addresses */
/** Peripheral RSIM base address */
#define RSIM_BASE                                (0x40059000u)
/** Peripheral RSIM base pointer */
#define RSIM                                     ((RSIM_Type *)RSIM_BASE)
/** Array initializer of RSIM peripheral base addresses */
#define RSIM_BASE_ADDRS                          { RSIM_BASE }
/** Array initializer of RSIM peripheral base pointers */
#define RSIM_BASE_PTRS                           { RSIM }

/*!
 * @}
 */ /* end of group RSIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Peripheral_Access_Layer RTC Peripheral Access Layer
 * @{
 */

/** RTC - Register Layout Typedef */
typedef struct {
  __IO uint32_t TSR;                               /**< RTC Time Seconds Register, offset: 0x0 */
  __IO uint32_t TPR;                               /**< RTC Time Prescaler Register, offset: 0x4 */
  __IO uint32_t TAR;                               /**< RTC Time Alarm Register, offset: 0x8 */
  __IO uint32_t TCR;                               /**< RTC Time Compensation Register, offset: 0xC */
  __IO uint32_t CR;                                /**< RTC Control Register, offset: 0x10 */
  __IO uint32_t SR;                                /**< RTC Status Register, offset: 0x14 */
  __IO uint32_t LR;                                /**< RTC Lock Register, offset: 0x18 */
  __IO uint32_t IER;                               /**< RTC Interrupt Enable Register, offset: 0x1C */
} RTC_Type;

/* ----------------------------------------------------------------------------
   -- RTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Masks RTC Register Masks
 * @{
 */

/*! @name TSR - RTC Time Seconds Register */
/*! @{ */
#define RTC_TSR_TSR_MASK                         (0xFFFFFFFFU)
#define RTC_TSR_TSR_SHIFT                        (0U)
/*! TSR - Time Seconds Register
 */
#define RTC_TSR_TSR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TSR_TSR_SHIFT)) & RTC_TSR_TSR_MASK)
/*! @} */

/*! @name TPR - RTC Time Prescaler Register */
/*! @{ */
#define RTC_TPR_TPR_MASK                         (0xFFFFU)
#define RTC_TPR_TPR_SHIFT                        (0U)
/*! TPR - Time Prescaler Register
 */
#define RTC_TPR_TPR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TPR_TPR_SHIFT)) & RTC_TPR_TPR_MASK)
/*! @} */

/*! @name TAR - RTC Time Alarm Register */
/*! @{ */
#define RTC_TAR_TAR_MASK                         (0xFFFFFFFFU)
#define RTC_TAR_TAR_SHIFT                        (0U)
/*! TAR - Time Alarm Register
 */
#define RTC_TAR_TAR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TAR_TAR_SHIFT)) & RTC_TAR_TAR_MASK)
/*! @} */

/*! @name TCR - RTC Time Compensation Register */
/*! @{ */
#define RTC_TCR_TCR_MASK                         (0xFFU)
#define RTC_TCR_TCR_SHIFT                        (0U)
/*! TCR - Time Compensation Register
 *  0b10000000..Time Prescaler Register overflows every 32896 clock cycles.
 *  0b11111111..Time Prescaler Register overflows every 32769 clock cycles.
 *  0b00000000..Time Prescaler Register overflows every 32768 clock cycles.
 *  0b00000001..Time Prescaler Register overflows every 32767 clock cycles.
 *  0b01111111..Time Prescaler Register overflows every 32641 clock cycles.
 */
#define RTC_TCR_TCR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_TCR_SHIFT)) & RTC_TCR_TCR_MASK)
#define RTC_TCR_CIR_MASK                         (0xFF00U)
#define RTC_TCR_CIR_SHIFT                        (8U)
/*! CIR - Compensation Interval Register
 */
#define RTC_TCR_CIR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_CIR_SHIFT)) & RTC_TCR_CIR_MASK)
#define RTC_TCR_TCV_MASK                         (0xFF0000U)
#define RTC_TCR_TCV_SHIFT                        (16U)
/*! TCV - Time Compensation Value
 */
#define RTC_TCR_TCV(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_TCV_SHIFT)) & RTC_TCR_TCV_MASK)
#define RTC_TCR_CIC_MASK                         (0xFF000000U)
#define RTC_TCR_CIC_SHIFT                        (24U)
/*! CIC - Compensation Interval Counter
 */
#define RTC_TCR_CIC(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_CIC_SHIFT)) & RTC_TCR_CIC_MASK)
/*! @} */

/*! @name CR - RTC Control Register */
/*! @{ */
#define RTC_CR_SWR_MASK                          (0x1U)
#define RTC_CR_SWR_SHIFT                         (0U)
/*! SWR - Software Reset
 *  0b0..No effect.
 *  0b1..Resets all RTC registers except for the SWR bit . The SWR bit is cleared by POR and by software explicitly clearing it.
 */
#define RTC_CR_SWR(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_CR_SWR_SHIFT)) & RTC_CR_SWR_MASK)
#define RTC_CR_WPE_MASK                          (0x2U)
#define RTC_CR_WPE_SHIFT                         (1U)
/*! WPE - Wakeup Pin Enable
 *  0b0..Wakeup pin is disabled.
 *  0b1..Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt asserts or the wakeup pin is turned on.
 */
#define RTC_CR_WPE(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_CR_WPE_SHIFT)) & RTC_CR_WPE_MASK)
#define RTC_CR_SUP_MASK                          (0x4U)
#define RTC_CR_SUP_SHIFT                         (2U)
/*! SUP - Supervisor Access
 *  0b0..Non-supervisor mode write accesses are not supported and generate a bus error.
 *  0b1..Non-supervisor mode write accesses are supported.
 */
#define RTC_CR_SUP(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_CR_SUP_SHIFT)) & RTC_CR_SUP_MASK)
#define RTC_CR_UM_MASK                           (0x8U)
#define RTC_CR_UM_SHIFT                          (3U)
/*! UM - Update Mode
 *  0b0..Registers cannot be written when locked.
 *  0b1..Registers can be written when locked under limited conditions.
 */
#define RTC_CR_UM(x)                             (((uint32_t)(((uint32_t)(x)) << RTC_CR_UM_SHIFT)) & RTC_CR_UM_MASK)
#define RTC_CR_WPS_MASK                          (0x10U)
#define RTC_CR_WPS_SHIFT                         (4U)
/*! WPS - Wakeup Pin Select
 *  0b0..Wakeup pin asserts (active low, open drain) if the RTC interrupt asserts or the wakeup pin is turned on.
 *  0b1..Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin is turned on and the 32kHz clock is output to other peripherals.
 */
#define RTC_CR_WPS(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_CR_WPS_SHIFT)) & RTC_CR_WPS_MASK)
#define RTC_CR_OSCE_MASK                         (0x100U)
#define RTC_CR_OSCE_SHIFT                        (8U)
/*! OSCE - Oscillator Enable
 *  0b0..32.768 kHz oscillator is disabled.
 *  0b1..32.768 kHz oscillator is enabled. After setting this bit, wait the oscillator startup time before
 *       enabling the time counter to allow the 32.768 kHz clock time to stabilize.
 */
#define RTC_CR_OSCE(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_CR_OSCE_SHIFT)) & RTC_CR_OSCE_MASK)
#define RTC_CR_SC16P_MASK                        (0x400U)
#define RTC_CR_SC16P_SHIFT                       (10U)
/*! SC16P - Oscillator 16pF Load Configure
 *  0b0..Disable the load.
 *  0b1..Enable the additional load.
 */
#define RTC_CR_SC16P(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_CR_SC16P_SHIFT)) & RTC_CR_SC16P_MASK)
#define RTC_CR_SC8P_MASK                         (0x800U)
#define RTC_CR_SC8P_SHIFT                        (11U)
/*! SC8P - Oscillator 8pF Load Configure
 *  0b0..Disable the load.
 *  0b1..Enable the additional load.
 */
#define RTC_CR_SC8P(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_CR_SC8P_SHIFT)) & RTC_CR_SC8P_MASK)
#define RTC_CR_SC4P_MASK                         (0x1000U)
#define RTC_CR_SC4P_SHIFT                        (12U)
/*! SC4P - Oscillator 4pF Load Configure
 *  0b0..Disable the load.
 *  0b1..Enable the additional load.
 */
#define RTC_CR_SC4P(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_CR_SC4P_SHIFT)) & RTC_CR_SC4P_MASK)
#define RTC_CR_SC2P_MASK                         (0x2000U)
#define RTC_CR_SC2P_SHIFT                        (13U)
/*! SC2P - Oscillator 2pF Load Configure
 *  0b0..Disable the load.
 *  0b1..Enable the additional load.
 */
#define RTC_CR_SC2P(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_CR_SC2P_SHIFT)) & RTC_CR_SC2P_MASK)
/*! @} */

/*! @name SR - RTC Status Register */
/*! @{ */
#define RTC_SR_TIF_MASK                          (0x1U)
#define RTC_SR_TIF_SHIFT                         (0U)
/*! TIF - Time Invalid Flag
 *  0b0..Time is valid.
 *  0b1..Time is invalid and time counter is read as zero.
 */
#define RTC_SR_TIF(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_SR_TIF_SHIFT)) & RTC_SR_TIF_MASK)
#define RTC_SR_TOF_MASK                          (0x2U)
#define RTC_SR_TOF_SHIFT                         (1U)
/*! TOF - Time Overflow Flag
 *  0b0..Time overflow has not occurred.
 *  0b1..Time overflow has occurred and time counter is read as zero.
 */
#define RTC_SR_TOF(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_SR_TOF_SHIFT)) & RTC_SR_TOF_MASK)
#define RTC_SR_TAF_MASK                          (0x4U)
#define RTC_SR_TAF_SHIFT                         (2U)
/*! TAF - Time Alarm Flag
 *  0b0..Time alarm has not occurred.
 *  0b1..Time alarm has occurred.
 */
#define RTC_SR_TAF(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_SR_TAF_SHIFT)) & RTC_SR_TAF_MASK)
#define RTC_SR_TCE_MASK                          (0x10U)
#define RTC_SR_TCE_SHIFT                         (4U)
/*! TCE - Time Counter Enable
 *  0b0..Time counter is disabled.
 *  0b1..Time counter is enabled.
 */
#define RTC_SR_TCE(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_SR_TCE_SHIFT)) & RTC_SR_TCE_MASK)
/*! @} */

/*! @name LR - RTC Lock Register */
/*! @{ */
#define RTC_LR_TCL_MASK                          (0x8U)
#define RTC_LR_TCL_SHIFT                         (3U)
/*! TCL - Time Compensation Lock
 *  0b0..Time Compensation Register is locked and writes are ignored.
 *  0b1..Time Compensation Register is not locked and writes complete as normal.
 */
#define RTC_LR_TCL(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_LR_TCL_SHIFT)) & RTC_LR_TCL_MASK)
#define RTC_LR_CRL_MASK                          (0x10U)
#define RTC_LR_CRL_SHIFT                         (4U)
/*! CRL - Control Register Lock
 *  0b0..Control Register is locked and writes are ignored.
 *  0b1..Control Register is not locked and writes complete as normal.
 */
#define RTC_LR_CRL(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_LR_CRL_SHIFT)) & RTC_LR_CRL_MASK)
#define RTC_LR_SRL_MASK                          (0x20U)
#define RTC_LR_SRL_SHIFT                         (5U)
/*! SRL - Status Register Lock
 *  0b0..Status Register is locked and writes are ignored.
 *  0b1..Status Register is not locked and writes complete as normal.
 */
#define RTC_LR_SRL(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_LR_SRL_SHIFT)) & RTC_LR_SRL_MASK)
#define RTC_LR_LRL_MASK                          (0x40U)
#define RTC_LR_LRL_SHIFT                         (6U)
/*! LRL - Lock Register Lock
 *  0b0..Lock Register is locked and writes are ignored.
 *  0b1..Lock Register is not locked and writes complete as normal.
 */
#define RTC_LR_LRL(x)                            (((uint32_t)(((uint32_t)(x)) << RTC_LR_LRL_SHIFT)) & RTC_LR_LRL_MASK)
/*! @} */

/*! @name IER - RTC Interrupt Enable Register */
/*! @{ */
#define RTC_IER_TIIE_MASK                        (0x1U)
#define RTC_IER_TIIE_SHIFT                       (0U)
/*! TIIE - Time Invalid Interrupt Enable
 *  0b0..Time invalid flag does not generate an interrupt.
 *  0b1..Time invalid flag does generate an interrupt.
 */
#define RTC_IER_TIIE(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_IER_TIIE_SHIFT)) & RTC_IER_TIIE_MASK)
#define RTC_IER_TOIE_MASK                        (0x2U)
#define RTC_IER_TOIE_SHIFT                       (1U)
/*! TOIE - Time Overflow Interrupt Enable
 *  0b0..Time overflow flag does not generate an interrupt.
 *  0b1..Time overflow flag does generate an interrupt.
 */
#define RTC_IER_TOIE(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_IER_TOIE_SHIFT)) & RTC_IER_TOIE_MASK)
#define RTC_IER_TAIE_MASK                        (0x4U)
#define RTC_IER_TAIE_SHIFT                       (2U)
/*! TAIE - Time Alarm Interrupt Enable
 *  0b0..Time alarm flag does not generate an interrupt.
 *  0b1..Time alarm flag does generate an interrupt.
 */
#define RTC_IER_TAIE(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_IER_TAIE_SHIFT)) & RTC_IER_TAIE_MASK)
#define RTC_IER_TSIE_MASK                        (0x10U)
#define RTC_IER_TSIE_SHIFT                       (4U)
/*! TSIE - Time Seconds Interrupt Enable
 *  0b0..Seconds interrupt is disabled.
 *  0b1..Seconds interrupt is enabled.
 */
#define RTC_IER_TSIE(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_IER_TSIE_SHIFT)) & RTC_IER_TSIE_MASK)
#define RTC_IER_WPON_MASK                        (0x80U)
#define RTC_IER_WPON_SHIFT                       (7U)
/*! WPON - Wakeup Pin On
 *  0b0..No effect.
 *  0b1..If the wakeup pin is enabled, then the wakeup pin will assert.
 */
#define RTC_IER_WPON(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_IER_WPON_SHIFT)) & RTC_IER_WPON_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RTC_Register_Masks */


/* RTC - Peripheral instance base addresses */
/** Peripheral RTC base address */
#define RTC_BASE                                 (0x4003D000u)
/** Peripheral RTC base pointer */
#define RTC                                      ((RTC_Type *)RTC_BASE)
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS                           { RTC_BASE }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS                            { RTC }
/** Interrupt vectors for the RTC peripheral type */
#define RTC_IRQS                                 { RTC_IRQn }
#define RTC_SECONDS_IRQS                         { RTC_Seconds_IRQn }

/*!
 * @}
 */ /* end of group RTC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RX_PACKET_RAM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RX_PACKET_RAM_Peripheral_Access_Layer RX_PACKET_RAM Peripheral Access Layer
 * @{
 */

/** RX_PACKET_RAM - Register Layout Typedef */
typedef struct {
  __IO uint32_t PACKET_RAM[1888];                  /**< Shared Packet RAM for multiple Link Layer usage., array offset: 0x0, array step: 0x4 */
} RX_PACKET_RAM_Type;

/* ----------------------------------------------------------------------------
   -- RX_PACKET_RAM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RX_PACKET_RAM_Register_Masks RX_PACKET_RAM Register Masks
 * @{
 */

/*! @name PACKET_RAM - Shared Packet RAM for multiple Link Layer usage. */
/*! @{ */
#define RX_PACKET_RAM_PACKET_RAM_RAM_MASK        (0xFFFFFFFFU)
#define RX_PACKET_RAM_PACKET_RAM_RAM_SHIFT       (0U)
/*! RAM - One entry in the packet RAM
 */
#define RX_PACKET_RAM_PACKET_RAM_RAM(x)          (((uint32_t)(((uint32_t)(x)) << RX_PACKET_RAM_PACKET_RAM_RAM_SHIFT)) & RX_PACKET_RAM_PACKET_RAM_RAM_MASK)
/*! @} */

/* The count of RX_PACKET_RAM_PACKET_RAM */
#define RX_PACKET_RAM_PACKET_RAM_COUNT           (1888U)


/*!
 * @}
 */ /* end of group RX_PACKET_RAM_Register_Masks */


/* RX_PACKET_RAM - Peripheral instance base addresses */
/** Peripheral RX_PACKET_RAM base address */
#define RX_PACKET_RAM_BASE                       (0x4008B000u)
/** Peripheral RX_PACKET_RAM base pointer */
#define RX_PACKET_RAM                            ((RX_PACKET_RAM_Type *)RX_PACKET_RAM_BASE)
/** Array initializer of RX_PACKET_RAM peripheral base addresses */
#define RX_PACKET_RAM_BASE_ADDRS                 { RX_PACKET_RAM_BASE }
/** Array initializer of RX_PACKET_RAM peripheral base pointers */
#define RX_PACKET_RAM_BASE_PTRS                  { RX_PACKET_RAM }

/*!
 * @}
 */ /* end of group RX_PACKET_RAM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Peripheral_Access_Layer SIM Peripheral Access Layer
 * @{
 */

/** SIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t SOPT1;                             /**< System Options Register 1, offset: 0x0 */
       uint8_t RESERVED_0[4096];
  __IO uint32_t SOPT2;                             /**< System Options Register 2, offset: 0x1004 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SOPT4;                             /**< System Options Register 4, offset: 0x100C */
  __IO uint32_t SOPT5;                             /**< System Options Register 5, offset: 0x1010 */
       uint8_t RESERVED_2[4];
  __IO uint32_t SOPT7;                             /**< System Options Register 7, offset: 0x1018 */
       uint8_t RESERVED_3[8];
  __I  uint32_t SDID;                              /**< System Device Identification Register, offset: 0x1024 */
       uint8_t RESERVED_4[4];
  __O  uint32_t PMSRC;                             /**< Peripheral Module Soft Reset Control Register(SIM_PMSRC), offset: 0x102C */
       uint8_t RESERVED_5[4];
  __IO uint32_t SCGC4;                             /**< System Clock Gating Control Register 4, offset: 0x1034 */
  __IO uint32_t SCGC5;                             /**< System Clock Gating Control Register 5, offset: 0x1038 */
  __IO uint32_t SCGC6;                             /**< System Clock Gating Control Register 6, offset: 0x103C */
  __IO uint32_t SCGC7;                             /**< System Clock Gating Control Register 7, offset: 0x1040 */
  __IO uint32_t CLKDIV1;                           /**< System Clock Divider Register 1, offset: 0x1044 */
       uint8_t RESERVED_6[4];
  __IO uint32_t FCFG1;                             /**< Flash Configuration Register 1, offset: 0x104C */
  __I  uint32_t FCFG2;                             /**< Flash Configuration Register 2, offset: 0x1050 */
       uint8_t RESERVED_7[4];
  __I  uint32_t UIDMH;                             /**< Unique Identification Register Mid-High, offset: 0x1058 */
  __I  uint32_t UIDML;                             /**< Unique Identification Register Mid Low, offset: 0x105C */
  __I  uint32_t UIDL;                              /**< Unique Identification Register Low, offset: 0x1060 */
       uint8_t RESERVED_8[156];
  __IO uint32_t COPC;                              /**< COP Control Register, offset: 0x1100 */
  __O  uint32_t SRVCOP;                            /**< Service COP, offset: 0x1104 */
} SIM_Type;

/* ----------------------------------------------------------------------------
   -- SIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Masks SIM Register Masks
 * @{
 */

/*! @name SOPT1 - System Options Register 1 */
/*! @{ */
#define SIM_SOPT1_OSC32KOUT_MASK                 (0x30000U)
#define SIM_SOPT1_OSC32KOUT_SHIFT                (16U)
/*! OSC32KOUT - 32K oscillator clock output
 *  0b00..ERCLK32K is not output.
 *  0b01..ERCLK32K is output on PTB3.
 *  0b10..Reserved.
 *  0b11..Reserved.
 */
#define SIM_SOPT1_OSC32KOUT(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT1_OSC32KOUT_SHIFT)) & SIM_SOPT1_OSC32KOUT_MASK)
#define SIM_SOPT1_OSC32KSEL_MASK                 (0xC0000U)
#define SIM_SOPT1_OSC32KSEL_SHIFT                (18U)
/*! OSC32KSEL - 32K Oscillator Clock Select
 *  0b00..32kHz oscillator (OSC32KCLK)
 *  0b01..Reserved
 *  0b10..RTC_CLKIN
 *  0b11..LPO 1kHz
 */
#define SIM_SOPT1_OSC32KSEL(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT1_OSC32KSEL_SHIFT)) & SIM_SOPT1_OSC32KSEL_MASK)
#define SIM_SOPT1_SIM_MISCTL_MASK                (0x100000U)
#define SIM_SOPT1_SIM_MISCTL_SHIFT               (20U)
/*! SIM_MISCTL - This bit controls the function of BLE_RF_ACTIVE.
 *  0b0..Chip low power mode output to PAD
 *  0b1..Bluetooth LE active output to PAD
 */
#define SIM_SOPT1_SIM_MISCTL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT1_SIM_MISCTL_SHIFT)) & SIM_SOPT1_SIM_MISCTL_MASK)
/*! @} */

/*! @name SOPT2 - System Options Register 2 */
/*! @{ */
#define SIM_SOPT2_CLKOUTSEL_MASK                 (0xE0U)
#define SIM_SOPT2_CLKOUTSEL_SHIFT                (5U)
/*! CLKOUTSEL - CLKOUT select
 *  0b000..OSCERCLK DIV2
 *  0b001..OSCERCLK DIV4
 *  0b010..Bus clock
 *  0b011..LPO clock 1 kHz
 *  0b100..MCGIRCLK
 *  0b101..OSCERCLK DIV8
 *  0b110..OSCERCLK
 *  0b111..Reserved
 */
#define SIM_SOPT2_CLKOUTSEL(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_CLKOUTSEL_SHIFT)) & SIM_SOPT2_CLKOUTSEL_MASK)
#define SIM_SOPT2_TPMSRC_MASK                    (0x3800000U)
#define SIM_SOPT2_TPMSRC_SHIFT                   (23U)
/*! TPMSRC - TPM Clock Source Select
 *  0b000..Clock disabled
 *  0b001..MCGFLLCLK clock
 *  0b010..OSCERCLK clock
 *  0b011..MCGIRCLK clock
 *  0b100..LANT_SW
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define SIM_SOPT2_TPMSRC(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_TPMSRC_SHIFT)) & SIM_SOPT2_TPMSRC_MASK)
#define SIM_SOPT2_LPUART0SRC_MASK                (0xC000000U)
#define SIM_SOPT2_LPUART0SRC_SHIFT               (26U)
/*! LPUART0SRC - LPUART0 Clock Source Select
 *  0b00..Clock disabled
 *  0b01..MCGFLLCLK clock
 *  0b10..OSCERCLK clock
 *  0b11..MCGIRCLK clock
 */
#define SIM_SOPT2_LPUART0SRC(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_LPUART0SRC_SHIFT)) & SIM_SOPT2_LPUART0SRC_MASK)
#define SIM_SOPT2_LPUART1SRC_MASK                (0x30000000U)
#define SIM_SOPT2_LPUART1SRC_SHIFT               (28U)
/*! LPUART1SRC - LPUART1 Clock Source Select
 *  0b00..Clock disabled
 *  0b01..MCGFLLCLK clock
 *  0b10..OSCERCLK clock
 *  0b11..MCGIRCLK clock
 */
#define SIM_SOPT2_LPUART1SRC(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_LPUART1SRC_SHIFT)) & SIM_SOPT2_LPUART1SRC_MASK)
/*! @} */

/*! @name SOPT4 - System Options Register 4 */
/*! @{ */
#define SIM_SOPT4_TPMOFSYN_MASK                  (0x2U)
#define SIM_SOPT4_TPMOFSYN_SHIFT                 (1U)
/*! TPMOFSYN - TPMOFSYN
 *  0b0..Enable TPM1 overflow output to TPM0 and TPM2 overflow in.
 *  0b1..Disable TPM1 overflow output to TPM0 and TPM2 overflow in.
 */
#define SIM_SOPT4_TPMOFSYN(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPMOFSYN_SHIFT)) & SIM_SOPT4_TPMOFSYN_MASK)
#define SIM_SOPT4_TPM1CH0SRC_MASK                (0x40000U)
#define SIM_SOPT4_TPM1CH0SRC_SHIFT               (18U)
/*! TPM1CH0SRC - TPM1 Channel 0 Input Capture Source Select
 *  0b0..TPM1_CH0 signal
 *  0b1..CMP0 output
 */
#define SIM_SOPT4_TPM1CH0SRC(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPM1CH0SRC_SHIFT)) & SIM_SOPT4_TPM1CH0SRC_MASK)
#define SIM_SOPT4_TPM2CH0SRC_MASK                (0x300000U)
#define SIM_SOPT4_TPM2CH0SRC_SHIFT               (20U)
/*! TPM2CH0SRC - TPM2 Channel 0 Input Capture Source Select
 *  0b00..TPM2_CH0 signal
 *  0b01..CMP0 output
 *  0b10..Radio time-of-flight timestamp trigger
 *  0b11..Reserved
 */
#define SIM_SOPT4_TPM2CH0SRC(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPM2CH0SRC_SHIFT)) & SIM_SOPT4_TPM2CH0SRC_MASK)
#define SIM_SOPT4_TPM0CLKSEL_MASK                (0x1000000U)
#define SIM_SOPT4_TPM0CLKSEL_SHIFT               (24U)
/*! TPM0CLKSEL - TPM0 External Clock Pin Select
 *  0b0..TPM0 external clock driven by TPM_CLKIN0 pin.
 *  0b1..TPM0 external clock driven by TPM_CLKIN1 pin.
 */
#define SIM_SOPT4_TPM0CLKSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPM0CLKSEL_SHIFT)) & SIM_SOPT4_TPM0CLKSEL_MASK)
#define SIM_SOPT4_TPM1CLKSEL_MASK                (0x2000000U)
#define SIM_SOPT4_TPM1CLKSEL_SHIFT               (25U)
/*! TPM1CLKSEL - TPM1 External Clock Pin Select
 *  0b0..TPM1 external clock driven by TPM_CLKIN0 pin.
 *  0b1..TPM1 external clock driven by TPM_CLKIN1 pin.
 */
#define SIM_SOPT4_TPM1CLKSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPM1CLKSEL_SHIFT)) & SIM_SOPT4_TPM1CLKSEL_MASK)
#define SIM_SOPT4_TPM2CLKSEL_MASK                (0x4000000U)
#define SIM_SOPT4_TPM2CLKSEL_SHIFT               (26U)
/*! TPM2CLKSEL - TPM2 External Clock Pin Select
 *  0b0..TPM2 external clock driven by TPM_CLKIN0 pin.
 *  0b1..TPM2 external clock driven by TPM_CLKIN1 pin.
 */
#define SIM_SOPT4_TPM2CLKSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT4_TPM2CLKSEL_SHIFT)) & SIM_SOPT4_TPM2CLKSEL_MASK)
/*! @} */

/*! @name SOPT5 - System Options Register 5 */
/*! @{ */
#define SIM_SOPT5_LPUART0TXSRC_MASK              (0x3U)
#define SIM_SOPT5_LPUART0TXSRC_SHIFT             (0U)
/*! LPUART0TXSRC - LPUART0 Transmit Data Source Select
 *  0b00..LPUART0_TX pin
 *  0b01..LPUART0_TX pin modulated with TPM1 channel 0 output
 *  0b10..LPUART0_TX pin modulated with TPM2 channel 0 output
 *  0b11..Reserved
 */
#define SIM_SOPT5_LPUART0TXSRC(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART0TXSRC_SHIFT)) & SIM_SOPT5_LPUART0TXSRC_MASK)
#define SIM_SOPT5_LPUART0RXSRC_MASK              (0x4U)
#define SIM_SOPT5_LPUART0RXSRC_SHIFT             (2U)
/*! LPUART0RXSRC - LPUART0 Receive Data Source Select
 *  0b0..LPUART_RX pin
 *  0b1..CMP0 output
 */
#define SIM_SOPT5_LPUART0RXSRC(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART0RXSRC_SHIFT)) & SIM_SOPT5_LPUART0RXSRC_MASK)
#define SIM_SOPT5_LPUART1TXSRC_MASK              (0x30U)
#define SIM_SOPT5_LPUART1TXSRC_SHIFT             (4U)
/*! LPUART1TXSRC - LPUART1 Transmit Data Source Select
 *  0b00..LPUART1_TX pin
 *  0b01..LPUART1_TX pin modulated with TPM1 channel 0 output
 *  0b10..LPUART1_TX pin modulated with TPM2 channel 0 output
 *  0b11..Reserved
 */
#define SIM_SOPT5_LPUART1TXSRC(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART1TXSRC_SHIFT)) & SIM_SOPT5_LPUART1TXSRC_MASK)
#define SIM_SOPT5_LPUART1RXSRC_MASK              (0x40U)
#define SIM_SOPT5_LPUART1RXSRC_SHIFT             (6U)
/*! LPUART1RXSRC - LPUART1 Receive Data Source Select
 *  0b0..LPUART1_RX pin
 *  0b1..CMP0 output
 */
#define SIM_SOPT5_LPUART1RXSRC(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART1RXSRC_SHIFT)) & SIM_SOPT5_LPUART1RXSRC_MASK)
#define SIM_SOPT5_LPUART0ODE_MASK                (0x10000U)
#define SIM_SOPT5_LPUART0ODE_SHIFT               (16U)
/*! LPUART0ODE - LPUART0 Open Drain Enable
 *  0b0..Open drain is disabled on LPUART0.
 *  0b1..Open drain is enabled on LPUART0.
 */
#define SIM_SOPT5_LPUART0ODE(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART0ODE_SHIFT)) & SIM_SOPT5_LPUART0ODE_MASK)
#define SIM_SOPT5_LPUART1ODE_MASK                (0x20000U)
#define SIM_SOPT5_LPUART1ODE_SHIFT               (17U)
/*! LPUART1ODE - LPUART1 Open Drain Enable
 *  0b0..Open drain is disabled on LPUART1.
 *  0b1..Open drain is enabled on LPUART1
 */
#define SIM_SOPT5_LPUART1ODE(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART1ODE_SHIFT)) & SIM_SOPT5_LPUART1ODE_MASK)
/*! @} */

/*! @name SOPT7 - System Options Register 7 */
/*! @{ */
#define SIM_SOPT7_ADC0TRGSEL_MASK                (0xFU)
#define SIM_SOPT7_ADC0TRGSEL_SHIFT               (0U)
/*! ADC0TRGSEL - ADC0 Trigger Select
 *  0b0000..External trigger pin input (EXTRG_IN)
 *  0b0001..CMP0 output
 *  0b0010..Reserved
 *  0b0011..Reserved
 *  0b0100..PIT trigger 0
 *  0b0101..PIT trigger 1
 *  0b0110..Reserved
 *  0b0111..Reserved
 *  0b1000..TPM0 overflow
 *  0b1001..TPM1 overflow
 *  0b1010..TPM2 overflow
 *  0b1011..Reserved
 *  0b1100..RTC alarm interrupt and RTC seconds interrupt
 *  0b1101..RTC seconds
 *  0b1110..LPTMR0 trigger
 *  0b1111..Radio TSM
 */
#define SIM_SOPT7_ADC0TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT7_ADC0TRGSEL_SHIFT)) & SIM_SOPT7_ADC0TRGSEL_MASK)
#define SIM_SOPT7_ADC0PRETRGSEL_MASK             (0x10U)
#define SIM_SOPT7_ADC0PRETRGSEL_SHIFT            (4U)
/*! ADC0PRETRGSEL - ADC0 Pretrigger Select
 *  0b0..Pre-trigger ADHDWTSA is selected, thus ADC0 will use ADC0_SC1A configuration for the next ADC conversion
 *       and store the result in ADC0_RA register.
 *  0b1..Pre-trigger ADHDWTSB is selected, thus ADC0 will use ADC0_SC1B configuration for the next ADC conversion
 *       and store the result in ADC0_RB register.
 */
#define SIM_SOPT7_ADC0PRETRGSEL(x)               (((uint32_t)(((uint32_t)(x)) << SIM_SOPT7_ADC0PRETRGSEL_SHIFT)) & SIM_SOPT7_ADC0PRETRGSEL_MASK)
#define SIM_SOPT7_ADC0ALTTRGEN_MASK              (0x80U)
#define SIM_SOPT7_ADC0ALTTRGEN_SHIFT             (7U)
/*! ADC0ALTTRGEN - ADC0 Alternate Trigger Enable
 *  0b0..ADC ADHWT trigger comes from TPM1 channel 0 and channel1. Prior to the assertion of TPM1 channel 0, a
 *       pre-trigger pulse will be sent to ADHWTSA to initiate an ADC acquisition using ADCx_SC1A configuration and
 *       store ADC conversion in ADCx_RA Register. Prior to the assertion of TPM1 channel 1 a pre-trigger pulse will
 *       be sent to ADHWTSB to initiate an ADC acquisition using ADCx_SC1Bconfiguration and store ADC conversion in
 *       ADCx_RB Register.
 *  0b1..ADC ADHWT trigger comes from a peripheral event selected by ADC0TRGSEL bits.ADC0PRETRGSEL bit will select
 *       the optional ADHWTSA or ADHWTSB select lines for choosing the ADCx_SC1x config and ADCx_Rx result
 *       regsiter to store the ADC conversion.
 */
#define SIM_SOPT7_ADC0ALTTRGEN(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT7_ADC0ALTTRGEN_SHIFT)) & SIM_SOPT7_ADC0ALTTRGEN_MASK)
/*! @} */

/*! @name SDID - System Device Identification Register */
/*! @{ */
#define SIM_SDID_PINID_MASK                      (0xFU)
#define SIM_SDID_PINID_SHIFT                     (0U)
/*! PINID - Pin count Identification
 *  0b0000..Reserved
 *  0b0001..Reserved
 *  0b0010..Reserved
 *  0b0011..40-pin
 *  0b0100..48-pin (LGA)
 *  0b0101..48-pin (wettable flank)
 *  0b0110..Reserved
 *  0b0111..Reserved
 *  0b1000..Reserved
 *  0b1001..Reserved
 *  0b1010..Reserved
 *  0b1011..Reserved
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..Reserved
 */
#define SIM_SDID_PINID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_PINID_SHIFT)) & SIM_SDID_PINID_MASK)
#define SIM_SDID_DIEID_MASK                      (0xF80U)
#define SIM_SDID_DIEID_SHIFT                     (7U)
/*! DIEID - Device Die Number
 */
#define SIM_SDID_DIEID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_DIEID_SHIFT)) & SIM_SDID_DIEID_MASK)
#define SIM_SDID_REVID_MASK                      (0xF000U)
#define SIM_SDID_REVID_SHIFT                     (12U)
/*! REVID - Device Revision Number
 */
#define SIM_SDID_REVID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_REVID_SHIFT)) & SIM_SDID_REVID_MASK)
#define SIM_SDID_SRAMSIZE_MASK                   (0xF0000U)
#define SIM_SDID_SRAMSIZE_SHIFT                  (16U)
/*! SRAMSIZE - System SRAM Size
 *  0b0111..64 KB
 */
#define SIM_SDID_SRAMSIZE(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SRAMSIZE_SHIFT)) & SIM_SDID_SRAMSIZE_MASK)
#define SIM_SDID_SERIESID_MASK                   (0xF00000U)
#define SIM_SDID_SERIESID_SHIFT                  (20U)
/*! SERIESID - Kinetis Series ID
 *  0b0101..KW family
 */
#define SIM_SDID_SERIESID(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SERIESID_SHIFT)) & SIM_SDID_SERIESID_MASK)
#define SIM_SDID_SUBFAMID_MASK                   (0x7000000U)
#define SIM_SDID_SUBFAMID_SHIFT                  (24U)
/*! SUBFAMID - Kinetis Sub-Family ID.
 *  0b111..KWx9 Sub family
 *  0b110..KWx7 Subfamily
 *  0b101..KWx8 Subfamily
 */
#define SIM_SDID_SUBFAMID(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SUBFAMID_SHIFT)) & SIM_SDID_SUBFAMID_MASK)
#define SIM_SDID_FAMID_MASK                      (0xF0000000U)
#define SIM_SDID_FAMID_SHIFT                     (28U)
/*! FAMID - Kinetis family ID
 *  0b0011..KW3x Family (BTLE)
 */
#define SIM_SDID_FAMID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_FAMID_SHIFT)) & SIM_SDID_FAMID_MASK)
/*! @} */

/*! @name PMSRC - Peripheral Module Soft Reset Control Register(SIM_PMSRC) */
/*! @{ */
#define SIM_PMSRC_TPM0SRC_MASK                   (0x1U)
#define SIM_PMSRC_TPM0SRC_SHIFT                  (0U)
/*! TPM0SRC - TPM0 Soft Reset Control
 */
#define SIM_PMSRC_TPM0SRC(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_PMSRC_TPM0SRC_SHIFT)) & SIM_PMSRC_TPM0SRC_MASK)
#define SIM_PMSRC_TPM1SRC_MASK                   (0x2U)
#define SIM_PMSRC_TPM1SRC_SHIFT                  (1U)
/*! TPM1SRC - TPM1 Soft Reset Control
 */
#define SIM_PMSRC_TPM1SRC(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_PMSRC_TPM1SRC_SHIFT)) & SIM_PMSRC_TPM1SRC_MASK)
#define SIM_PMSRC_TPM2SRC_MASK                   (0x4U)
#define SIM_PMSRC_TPM2SRC_SHIFT                  (2U)
/*! TPM2SRC - TPM2 Soft Reset Control
 */
#define SIM_PMSRC_TPM2SRC(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_PMSRC_TPM2SRC_SHIFT)) & SIM_PMSRC_TPM2SRC_MASK)
/*! @} */

/*! @name SCGC4 - System Clock Gating Control Register 4 */
/*! @{ */
#define SIM_SCGC4_CMT_MASK                       (0x4U)
#define SIM_SCGC4_CMT_SHIFT                      (2U)
/*! CMT - CMT Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC4_CMT(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC4_CMT_SHIFT)) & SIM_SCGC4_CMT_MASK)
#define SIM_SCGC4_I2C0_MASK                      (0x40U)
#define SIM_SCGC4_I2C0_SHIFT                     (6U)
/*! I2C0 - I2C0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC4_I2C0(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC4_I2C0_SHIFT)) & SIM_SCGC4_I2C0_MASK)
#define SIM_SCGC4_I2C1_MASK                      (0x80U)
#define SIM_SCGC4_I2C1_SHIFT                     (7U)
/*! I2C1 - I2C1 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC4_I2C1(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC4_I2C1_SHIFT)) & SIM_SCGC4_I2C1_MASK)
#define SIM_SCGC4_CMP_MASK                       (0x80000U)
#define SIM_SCGC4_CMP_SHIFT                      (19U)
/*! CMP - Comparator Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC4_CMP(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC4_CMP_SHIFT)) & SIM_SCGC4_CMP_MASK)
#define SIM_SCGC4_VREF_MASK                      (0x100000U)
#define SIM_SCGC4_VREF_SHIFT                     (20U)
/*! VREF - VREF Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC4_VREF(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC4_VREF_SHIFT)) & SIM_SCGC4_VREF_MASK)
/*! @} */

/*! @name SCGC5 - System Clock Gating Control Register 5 */
/*! @{ */
#define SIM_SCGC5_LPTMR_MASK                     (0x1U)
#define SIM_SCGC5_LPTMR_SHIFT                    (0U)
/*! LPTMR - Low Power Timer Access Control
 *  0b0..Access disabled
 *  0b1..Access enabled
 */
#define SIM_SCGC5_LPTMR(x)                       (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_LPTMR_SHIFT)) & SIM_SCGC5_LPTMR_MASK)
#define SIM_SCGC5_PORTA_MASK                     (0x200U)
#define SIM_SCGC5_PORTA_SHIFT                    (9U)
/*! PORTA - Port A Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_PORTA(x)                       (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_PORTA_SHIFT)) & SIM_SCGC5_PORTA_MASK)
#define SIM_SCGC5_PORTB_MASK                     (0x400U)
#define SIM_SCGC5_PORTB_SHIFT                    (10U)
/*! PORTB - Port B Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_PORTB(x)                       (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_PORTB_SHIFT)) & SIM_SCGC5_PORTB_MASK)
#define SIM_SCGC5_PORTC_MASK                     (0x800U)
#define SIM_SCGC5_PORTC_SHIFT                    (11U)
/*! PORTC - Port C Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_PORTC(x)                       (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_PORTC_SHIFT)) & SIM_SCGC5_PORTC_MASK)
#define SIM_SCGC5_GFSK_REMAP0_MASK               (0x10000U)
#define SIM_SCGC5_GFSK_REMAP0_SHIFT              (16U)
/*! GFSK_REMAP0 - GFSK Remap0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_GFSK_REMAP0(x)                 (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_GFSK_REMAP0_SHIFT)) & SIM_SCGC5_GFSK_REMAP0_MASK)
#define SIM_SCGC5_GFSK_REMAP1_MASK               (0x20000U)
#define SIM_SCGC5_GFSK_REMAP1_SHIFT              (17U)
/*! GFSK_REMAP1 - GFSK Remap1 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_GFSK_REMAP1(x)                 (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_GFSK_REMAP1_SHIFT)) & SIM_SCGC5_GFSK_REMAP1_MASK)
#define SIM_SCGC5_GFSK_REMAP2_MASK               (0x40000U)
#define SIM_SCGC5_GFSK_REMAP2_SHIFT              (18U)
/*! GFSK_REMAP2 - GFSK Remap2 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_GFSK_REMAP2(x)                 (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_GFSK_REMAP2_SHIFT)) & SIM_SCGC5_GFSK_REMAP2_MASK)
#define SIM_SCGC5_LPUART0_MASK                   (0x100000U)
#define SIM_SCGC5_LPUART0_SHIFT                  (20U)
/*! LPUART0 - LPUART0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_LPUART0(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_LPUART0_SHIFT)) & SIM_SCGC5_LPUART0_MASK)
#define SIM_SCGC5_LPUART1_MASK                   (0x200000U)
#define SIM_SCGC5_LPUART1_SHIFT                  (21U)
/*! LPUART1 - LPUART1 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_LPUART1(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_LPUART1_SHIFT)) & SIM_SCGC5_LPUART1_MASK)
#define SIM_SCGC5_DSB_MASK                       (0x800000U)
#define SIM_SCGC5_DSB_SHIFT                      (23U)
/*! DSB - Data Stream Buffer Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_DSB(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_DSB_SHIFT)) & SIM_SCGC5_DSB_MASK)
#define SIM_SCGC5_LTC_MASK                       (0x1000000U)
#define SIM_SCGC5_LTC_SHIFT                      (24U)
/*! LTC - LTC Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_LTC(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_LTC_SHIFT)) & SIM_SCGC5_LTC_MASK)
#define SIM_SCGC5_RSIM_MASK                      (0x2000000U)
#define SIM_SCGC5_RSIM_SHIFT                     (25U)
/*! RSIM - RSIM Clock Gate Control
 */
#define SIM_SCGC5_RSIM(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_RSIM_SHIFT)) & SIM_SCGC5_RSIM_MASK)
#define SIM_SCGC5_DCDC_MASK                      (0x4000000U)
#define SIM_SCGC5_DCDC_SHIFT                     (26U)
/*! DCDC - DCDC Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_DCDC(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_DCDC_SHIFT)) & SIM_SCGC5_DCDC_MASK)
#define SIM_SCGC5_BTLL_MASK                      (0x8000000U)
#define SIM_SCGC5_BTLL_SHIFT                     (27U)
/*! BTLL - BTLL System Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_BTLL(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_BTLL_SHIFT)) & SIM_SCGC5_BTLL_MASK)
#define SIM_SCGC5_PHYDIG_MASK                    (0x10000000U)
#define SIM_SCGC5_PHYDIG_SHIFT                   (28U)
/*! PHYDIG - PHY Digital Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC5_PHYDIG(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_PHYDIG_SHIFT)) & SIM_SCGC5_PHYDIG_MASK)
#define SIM_SCGC5_GEN_FSK_MASK                   (0x80000000U)
#define SIM_SCGC5_GEN_FSK_SHIFT                  (31U)
/*! GEN_FSK - Generic FSK enabled
 *  0b0..GFSK CGC bit disabled.
 *  0b1..GFSK CGC bit enabled.
 */
#define SIM_SCGC5_GEN_FSK(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SCGC5_GEN_FSK_SHIFT)) & SIM_SCGC5_GEN_FSK_MASK)
/*! @} */

/*! @name SCGC6 - System Clock Gating Control Register 6 */
/*! @{ */
#define SIM_SCGC6_FTF_MASK                       (0x1U)
#define SIM_SCGC6_FTF_SHIFT                      (0U)
/*! FTF - Flash Memory Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_FTF(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_FTF_SHIFT)) & SIM_SCGC6_FTF_MASK)
#define SIM_SCGC6_DMAMUX_MASK                    (0x2U)
#define SIM_SCGC6_DMAMUX_SHIFT                   (1U)
/*! DMAMUX - DMA Mux Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_DMAMUX(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_DMAMUX_SHIFT)) & SIM_SCGC6_DMAMUX_MASK)
#define SIM_SCGC6_FLEXCAN0_MASK                  (0x10U)
#define SIM_SCGC6_FLEXCAN0_SHIFT                 (4U)
/*! FLEXCAN0 - FLEXCAN0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_FLEXCAN0(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_FLEXCAN0_SHIFT)) & SIM_SCGC6_FLEXCAN0_MASK)
#define SIM_SCGC6_TRNG_MASK                      (0x200U)
#define SIM_SCGC6_TRNG_SHIFT                     (9U)
/*! TRNG - TRNG Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_TRNG(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_TRNG_SHIFT)) & SIM_SCGC6_TRNG_MASK)
#define SIM_SCGC6_SPI0_MASK                      (0x1000U)
#define SIM_SCGC6_SPI0_SHIFT                     (12U)
/*! SPI0 - SPI0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_SPI0(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_SPI0_SHIFT)) & SIM_SCGC6_SPI0_MASK)
#define SIM_SCGC6_SPI1_MASK                      (0x2000U)
#define SIM_SCGC6_SPI1_SHIFT                     (13U)
/*! SPI1 - SPI1 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_SPI1(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_SPI1_SHIFT)) & SIM_SCGC6_SPI1_MASK)
#define SIM_SCGC6_PIT_MASK                       (0x800000U)
#define SIM_SCGC6_PIT_SHIFT                      (23U)
/*! PIT - PIT Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_PIT(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_PIT_SHIFT)) & SIM_SCGC6_PIT_MASK)
#define SIM_SCGC6_TPM0_MASK                      (0x1000000U)
#define SIM_SCGC6_TPM0_SHIFT                     (24U)
/*! TPM0 - TPM0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_TPM0(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_TPM0_SHIFT)) & SIM_SCGC6_TPM0_MASK)
#define SIM_SCGC6_TPM1_MASK                      (0x2000000U)
#define SIM_SCGC6_TPM1_SHIFT                     (25U)
/*! TPM1 - TPM1 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_TPM1(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_TPM1_SHIFT)) & SIM_SCGC6_TPM1_MASK)
#define SIM_SCGC6_TPM2_MASK                      (0x4000000U)
#define SIM_SCGC6_TPM2_SHIFT                     (26U)
/*! TPM2 - TPM2 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_TPM2(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_TPM2_SHIFT)) & SIM_SCGC6_TPM2_MASK)
#define SIM_SCGC6_ADC0_MASK                      (0x8000000U)
#define SIM_SCGC6_ADC0_SHIFT                     (27U)
/*! ADC0 - ADC0 Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC6_ADC0(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_ADC0_SHIFT)) & SIM_SCGC6_ADC0_MASK)
#define SIM_SCGC6_RTC_MASK                       (0x20000000U)
#define SIM_SCGC6_RTC_SHIFT                      (29U)
/*! RTC - RTC Access Control
 *  0b0..Access and interrupts disabled
 *  0b1..Access and interrupts enabled
 */
#define SIM_SCGC6_RTC(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC6_RTC_SHIFT)) & SIM_SCGC6_RTC_MASK)
/*! @} */

/*! @name SCGC7 - System Clock Gating Control Register 7 */
/*! @{ */
#define SIM_SCGC7_DMA_MASK                       (0x100U)
#define SIM_SCGC7_DMA_SHIFT                      (8U)
/*! DMA - DMA Clock Gate Control
 *  0b0..Clock disabled
 *  0b1..Clock enabled
 */
#define SIM_SCGC7_DMA(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_SCGC7_DMA_SHIFT)) & SIM_SCGC7_DMA_MASK)
/*! @} */

/*! @name CLKDIV1 - System Clock Divider Register 1 */
/*! @{ */
#define SIM_CLKDIV1_OUTDIV4_MASK                 (0x70000U)
#define SIM_CLKDIV1_OUTDIV4_SHIFT                (16U)
/*! OUTDIV4 - Clock 4 Output Divider value
 *  0b000..Divide-by-1.
 *  0b001..Divide-by-2.
 *  0b010..Divide-by-3.
 *  0b011..Divide-by-4.
 *  0b100..Divide-by-5.
 *  0b101..Divide-by-6.
 *  0b110..Divide-by-7.
 *  0b111..Divide-by-8.
 */
#define SIM_CLKDIV1_OUTDIV4(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_CLKDIV1_OUTDIV4_SHIFT)) & SIM_CLKDIV1_OUTDIV4_MASK)
#define SIM_CLKDIV1_OUTDIV1_MASK                 (0xF0000000U)
#define SIM_CLKDIV1_OUTDIV1_SHIFT                (28U)
/*! OUTDIV1 - Clock 1 Output Divider value
 *  0b0000..Divide-by-1.
 *  0b0001..Divide-by-2.
 *  0b0010..Divide-by-3.
 *  0b0011..Divide-by-4.
 *  0b0100..Divide-by-5.
 *  0b0101..Divide-by-6.
 *  0b0110..Divide-by-7.
 *  0b0111..Divide-by-8.
 *  0b1000..Divide-by-9.
 *  0b1001..Divide-by-10.
 *  0b1010..Divide-by-11.
 *  0b1011..Divide-by-12.
 *  0b1100..Divide-by-13.
 *  0b1101..Divide-by-14.
 *  0b1110..Divide-by-15.
 *  0b1111..Divide-by-16.
 */
#define SIM_CLKDIV1_OUTDIV1(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_CLKDIV1_OUTDIV1_SHIFT)) & SIM_CLKDIV1_OUTDIV1_MASK)
/*! @} */

/*! @name FCFG1 - Flash Configuration Register 1 */
/*! @{ */
#define SIM_FCFG1_FLASHDIS_MASK                  (0x1U)
#define SIM_FCFG1_FLASHDIS_SHIFT                 (0U)
/*! FLASHDIS - Flash Disable
 *  0b0..Flash is enabled.
 *  0b1..Flash is disabled.
 */
#define SIM_FCFG1_FLASHDIS(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_FLASHDIS_SHIFT)) & SIM_FCFG1_FLASHDIS_MASK)
#define SIM_FCFG1_FLASHDOZE_MASK                 (0x2U)
#define SIM_FCFG1_FLASHDOZE_SHIFT                (1U)
/*! FLASHDOZE - Flash Doze
 *  0b0..Flash remains enabled during Doze mode.
 *  0b1..Flash is disabled for the duration of Doze mode.
 */
#define SIM_FCFG1_FLASHDOZE(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_FLASHDOZE_SHIFT)) & SIM_FCFG1_FLASHDOZE_MASK)
#define SIM_FCFG1_DEPART_MASK                    (0xF00U)
#define SIM_FCFG1_DEPART_SHIFT                   (8U)
/*! DEPART - FlexNVM partition
 */
#define SIM_FCFG1_DEPART(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_DEPART_SHIFT)) & SIM_FCFG1_DEPART_MASK)
#define SIM_FCFG1_EESIZE_MASK                    (0xF0000U)
#define SIM_FCFG1_EESIZE_SHIFT                   (16U)
/*! EESIZE - EEPROM Size
 *  0b0000..Reserved
 *  0b0001..8 KB
 *  0b0010..4 KB
 *  0b0011..2 KB
 *  0b0100..1 KB
 *  0b0101..512 bytes
 *  0b0110..256 bytes
 *  0b0111..128 bytes
 *  0b1000..64 bytes
 *  0b1001..32 bytes
 *  0b1010..Reserved
 *  0b1011..Reserved
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..Reserved
 */
#define SIM_FCFG1_EESIZE(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_EESIZE_SHIFT)) & SIM_FCFG1_EESIZE_MASK)
#define SIM_FCFG1_PFSIZE_MASK                    (0xF000000U)
#define SIM_FCFG1_PFSIZE_SHIFT                   (24U)
/*! PFSIZE - Program Flash Size
 *  0b1001..256 KB of program flash memory
 *  0b1011..512 KB of program flash memory
 *  0b1111..Reserved
 */
#define SIM_FCFG1_PFSIZE(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_PFSIZE_SHIFT)) & SIM_FCFG1_PFSIZE_MASK)
#define SIM_FCFG1_NVMSIZE_MASK                   (0xF0000000U)
#define SIM_FCFG1_NVMSIZE_SHIFT                  (28U)
/*! NVMSIZE - FlexNVM Size
 *  0b0000..0 KB
 *  0b0001..Reserved
 *  0b0010..Reserved
 *  0b0011..Reserved
 *  0b0100..Reserved
 *  0b0101..Reserved
 *  0b0110..Reserved
 *  0b0111..Reserved
 *  0b1000..Reserved
 *  0b1001..256 KB, 16 KB protection region
 *  0b1010..Reserved
 *  0b1011..Reserved
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..256 KB, 16 KB protection region
 */
#define SIM_FCFG1_NVMSIZE(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_NVMSIZE_SHIFT)) & SIM_FCFG1_NVMSIZE_MASK)
/*! @} */

/*! @name FCFG2 - Flash Configuration Register 2 */
/*! @{ */
#define SIM_FCFG2_MAXADDR1_MASK                  (0x7F0000U)
#define SIM_FCFG2_MAXADDR1_SHIFT                 (16U)
#define SIM_FCFG2_MAXADDR1(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_MAXADDR1_SHIFT)) & SIM_FCFG2_MAXADDR1_MASK)
#define SIM_FCFG2_PFLSH_MASK                     (0x800000U)
#define SIM_FCFG2_PFLSH_SHIFT                    (23U)
/*! PFLSH - Program flash only
 *  0b0..Device supports FlexNVM.
 *  0b1..Program Flash only, device does not support FlexNVM.
 */
#define SIM_FCFG2_PFLSH(x)                       (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_PFLSH_SHIFT)) & SIM_FCFG2_PFLSH_MASK)
#define SIM_FCFG2_MAXADDR0_MASK                  (0x7F000000U)
#define SIM_FCFG2_MAXADDR0_SHIFT                 (24U)
/*! MAXADDR0 - Max Address block 0
 */
#define SIM_FCFG2_MAXADDR0(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_MAXADDR0_SHIFT)) & SIM_FCFG2_MAXADDR0_MASK)
#define SIM_FCFG2_SWAPPFLSH_MASK                 (0x80000000U)
#define SIM_FCFG2_SWAPPFLSH_SHIFT                (31U)
/*! SWAPPFLSH - Swap program flash
 *  0b0..Swap is not active.
 *  0b1..Swap is active.
 */
#define SIM_FCFG2_SWAPPFLSH(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_SWAPPFLSH_SHIFT)) & SIM_FCFG2_SWAPPFLSH_MASK)
/*! @} */

/*! @name UIDMH - Unique Identification Register Mid-High */
/*! @{ */
#define SIM_UIDMH_UID_MASK                       (0xFFFFU)
#define SIM_UIDMH_UID_SHIFT                      (0U)
/*! UID - Unique Identification
 */
#define SIM_UIDMH_UID(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_UIDMH_UID_SHIFT)) & SIM_UIDMH_UID_MASK)
/*! @} */

/*! @name UIDML - Unique Identification Register Mid Low */
/*! @{ */
#define SIM_UIDML_UID_MASK                       (0xFFFFFFFFU)
#define SIM_UIDML_UID_SHIFT                      (0U)
/*! UID - Unique Identification
 */
#define SIM_UIDML_UID(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_UIDML_UID_SHIFT)) & SIM_UIDML_UID_MASK)
/*! @} */

/*! @name UIDL - Unique Identification Register Low */
/*! @{ */
#define SIM_UIDL_UID_MASK                        (0xFFFFFFFFU)
#define SIM_UIDL_UID_SHIFT                       (0U)
/*! UID - Unique Identification
 */
#define SIM_UIDL_UID(x)                          (((uint32_t)(((uint32_t)(x)) << SIM_UIDL_UID_SHIFT)) & SIM_UIDL_UID_MASK)
/*! @} */

/*! @name COPC - COP Control Register */
/*! @{ */
#define SIM_COPC_COPW_MASK                       (0x1U)
#define SIM_COPC_COPW_SHIFT                      (0U)
/*! COPW - COP Windowed Mode
 *  0b0..Normal mode
 *  0b1..Windowed mode
 */
#define SIM_COPC_COPW(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPW_SHIFT)) & SIM_COPC_COPW_MASK)
#define SIM_COPC_COPCLKS_MASK                    (0x2U)
#define SIM_COPC_COPCLKS_SHIFT                   (1U)
/*! COPCLKS - COP Clock Select
 *  0b0..COP configured for short timeout
 *  0b1..COP configured for long timeout
 */
#define SIM_COPC_COPCLKS(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPCLKS_SHIFT)) & SIM_COPC_COPCLKS_MASK)
#define SIM_COPC_COPT_MASK                       (0xCU)
#define SIM_COPC_COPT_SHIFT                      (2U)
/*! COPT - COP Watchdog Timeout
 *  0b00..COP disabled
 *  0b01..COP timeout after 25 cycles for short timeout or 213 cycles for long timeout
 *  0b10..COP timeout after 28 cycles for short timeout or 216 cycles for long timeout
 *  0b11..COP timeout after 210 cycles for short timeout or 218 cycles for long timeout
 */
#define SIM_COPC_COPT(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPT_SHIFT)) & SIM_COPC_COPT_MASK)
#define SIM_COPC_COPSTPEN_MASK                   (0x10U)
#define SIM_COPC_COPSTPEN_SHIFT                  (4U)
/*! COPSTPEN - COP Stop Enable
 *  0b0..COP is disabled and the counter is reset in Stop modes
 *  0b1..COP is enabled in Stop modes
 */
#define SIM_COPC_COPSTPEN(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPSTPEN_SHIFT)) & SIM_COPC_COPSTPEN_MASK)
#define SIM_COPC_COPDBGEN_MASK                   (0x20U)
#define SIM_COPC_COPDBGEN_SHIFT                  (5U)
/*! COPDBGEN - COP Debug Enable
 *  0b0..COP is disabled and the counter is reset in Debug mode
 *  0b1..COP is enabled in Debug mode
 */
#define SIM_COPC_COPDBGEN(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPDBGEN_SHIFT)) & SIM_COPC_COPDBGEN_MASK)
#define SIM_COPC_COPCLKSEL_MASK                  (0xC0U)
#define SIM_COPC_COPCLKSEL_SHIFT                 (6U)
/*! COPCLKSEL - COP Clock Select
 *  0b00..LPO clock (1 kHz)
 *  0b01..MCGIRCLK
 *  0b10..OSCERCLK
 *  0b11..Bus clock
 */
#define SIM_COPC_COPCLKSEL(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPCLKSEL_SHIFT)) & SIM_COPC_COPCLKSEL_MASK)
/*! @} */

/*! @name SRVCOP - Service COP */
/*! @{ */
#define SIM_SRVCOP_SRVCOP_MASK                   (0xFFU)
#define SIM_SRVCOP_SRVCOP_SHIFT                  (0U)
/*! SRVCOP - Service COP Register
 */
#define SIM_SRVCOP_SRVCOP(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SRVCOP_SRVCOP_SHIFT)) & SIM_SRVCOP_SRVCOP_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SIM_Register_Masks */


/* SIM - Peripheral instance base addresses */
/** Peripheral SIM base address */
#define SIM_BASE                                 (0x40047000u)
/** Peripheral SIM base pointer */
#define SIM                                      ((SIM_Type *)SIM_BASE)
/** Array initializer of SIM peripheral base addresses */
#define SIM_BASE_ADDRS                           { SIM_BASE }
/** Array initializer of SIM peripheral base pointers */
#define SIM_BASE_PTRS                            { SIM }

/*!
 * @}
 */ /* end of group SIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Peripheral_Access_Layer SMC Peripheral Access Layer
 * @{
 */

/** SMC - Register Layout Typedef */
typedef struct {
  __IO uint8_t PMPROT;                             /**< Power Mode Protection register, offset: 0x0 */
  __IO uint8_t PMCTRL;                             /**< Power Mode Control register, offset: 0x1 */
  __IO uint8_t STOPCTRL;                           /**< Stop Control Register, offset: 0x2 */
  __I  uint8_t PMSTAT;                             /**< Power Mode Status register, offset: 0x3 */
} SMC_Type;

/* ----------------------------------------------------------------------------
   -- SMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Masks SMC Register Masks
 * @{
 */

/*! @name PMPROT - Power Mode Protection register */
/*! @{ */
#define SMC_PMPROT_AVLLS_MASK                    (0x2U)
#define SMC_PMPROT_AVLLS_SHIFT                   (1U)
/*! AVLLS - Allow Very-Low-Leakage Stop Mode
 *  0b0..Any VLLSx mode is not allowed
 *  0b1..Any VLLSx mode is allowed
 */
#define SMC_PMPROT_AVLLS(x)                      (((uint8_t)(((uint8_t)(x)) << SMC_PMPROT_AVLLS_SHIFT)) & SMC_PMPROT_AVLLS_MASK)
#define SMC_PMPROT_ALLS_MASK                     (0x8U)
#define SMC_PMPROT_ALLS_SHIFT                    (3U)
/*! ALLS - Allow Low-Leakage Stop Mode
 *  0b0..Any LLSx mode is not allowed
 *  0b1..Any LLSx mode is allowed
 */
#define SMC_PMPROT_ALLS(x)                       (((uint8_t)(((uint8_t)(x)) << SMC_PMPROT_ALLS_SHIFT)) & SMC_PMPROT_ALLS_MASK)
#define SMC_PMPROT_AVLP_MASK                     (0x20U)
#define SMC_PMPROT_AVLP_SHIFT                    (5U)
/*! AVLP - Allow Very-Low-Power Modes
 *  0b0..VLPR, VLPW, and VLPS are not allowed.
 *  0b1..VLPR, VLPW, and VLPS are allowed.
 */
#define SMC_PMPROT_AVLP(x)                       (((uint8_t)(((uint8_t)(x)) << SMC_PMPROT_AVLP_SHIFT)) & SMC_PMPROT_AVLP_MASK)
/*! @} */

/*! @name PMCTRL - Power Mode Control register */
/*! @{ */
#define SMC_PMCTRL_STOPM_MASK                    (0x7U)
#define SMC_PMCTRL_STOPM_SHIFT                   (0U)
/*! STOPM - Stop Mode Control
 *  0b000..Normal Stop (STOP)
 *  0b001..Reserved
 *  0b010..Very-Low-Power Stop (VLPS)
 *  0b011..Low-Leakage Stop (LLSx)
 *  0b100..Very-Low-Leakage Stop (VLLSx)
 *  0b101..Reserved
 *  0b110..Reseved
 *  0b111..Reserved
 */
#define SMC_PMCTRL_STOPM(x)                      (((uint8_t)(((uint8_t)(x)) << SMC_PMCTRL_STOPM_SHIFT)) & SMC_PMCTRL_STOPM_MASK)
#define SMC_PMCTRL_STOPA_MASK                    (0x8U)
#define SMC_PMCTRL_STOPA_SHIFT                   (3U)
/*! STOPA - Stop Aborted
 *  0b0..The previous stop mode entry was successful.
 *  0b1..The previous stop mode entry was aborted.
 */
#define SMC_PMCTRL_STOPA(x)                      (((uint8_t)(((uint8_t)(x)) << SMC_PMCTRL_STOPA_SHIFT)) & SMC_PMCTRL_STOPA_MASK)
#define SMC_PMCTRL_RUNM_MASK                     (0x60U)
#define SMC_PMCTRL_RUNM_SHIFT                    (5U)
/*! RUNM - Run Mode Control
 *  0b00..Normal Run mode (RUN)
 *  0b01..Reserved
 *  0b10..Very-Low-Power Run mode (VLPR)
 *  0b11..Reserved
 */
#define SMC_PMCTRL_RUNM(x)                       (((uint8_t)(((uint8_t)(x)) << SMC_PMCTRL_RUNM_SHIFT)) & SMC_PMCTRL_RUNM_MASK)
/*! @} */

/*! @name STOPCTRL - Stop Control Register */
/*! @{ */
#define SMC_STOPCTRL_LLSM_MASK                   (0x7U)
#define SMC_STOPCTRL_LLSM_SHIFT                  (0U)
/*! LLSM - LLS or VLLS Mode Control
 *  0b000..VLLS0 if PMCTRL[STOPM]=VLLSx, reserved if PMCTRL[STOPM]=LLSx
 *  0b001..VLLS1 if PMCTRL[STOPM]=VLLSx, reserved if PMCTRL[STOPM]=LLSx
 *  0b010..VLLS2 if PMCTRL[STOPM]=VLLSx, LLS2 if PMCTRL[STOPM]=LLSx
 *  0b011..VLLS3 if PMCTRL[STOPM]=VLLSx, LLS3 if PMCTRL[STOPM]=LLSx
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define SMC_STOPCTRL_LLSM(x)                     (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_LLSM_SHIFT)) & SMC_STOPCTRL_LLSM_MASK)
#define SMC_STOPCTRL_RAM2PO_MASK                 (0x10U)
#define SMC_STOPCTRL_RAM2PO_SHIFT                (4U)
/*! RAM2PO - RAM2 Power Option
 *  0b0..RAM2 not powered in LLS2/VLLS2
 *  0b1..RAM2 powered in LLS2/VLLS2
 */
#define SMC_STOPCTRL_RAM2PO(x)                   (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_RAM2PO_SHIFT)) & SMC_STOPCTRL_RAM2PO_MASK)
#define SMC_STOPCTRL_PORPO_MASK                  (0x20U)
#define SMC_STOPCTRL_PORPO_SHIFT                 (5U)
/*! PORPO - POR Power Option
 *  0b0..POR detect circuit is enabled in VLLS0
 *  0b1..POR detect circuit is disabled in VLLS0
 */
#define SMC_STOPCTRL_PORPO(x)                    (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_PORPO_SHIFT)) & SMC_STOPCTRL_PORPO_MASK)
#define SMC_STOPCTRL_PSTOPO_MASK                 (0xC0U)
#define SMC_STOPCTRL_PSTOPO_SHIFT                (6U)
/*! PSTOPO - Partial Stop Option
 *  0b00..STOP - Normal Stop mode
 *  0b01..PSTOP1 - Partial Stop with both system and bus clocks disabled
 *  0b10..PSTOP2 - Partial Stop with system clock disabled and bus clock enabled
 *  0b11..Reserved
 */
#define SMC_STOPCTRL_PSTOPO(x)                   (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_PSTOPO_SHIFT)) & SMC_STOPCTRL_PSTOPO_MASK)
/*! @} */

/*! @name PMSTAT - Power Mode Status register */
/*! @{ */
#define SMC_PMSTAT_PMSTAT_MASK                   (0xFFU)
#define SMC_PMSTAT_PMSTAT_SHIFT                  (0U)
/*! PMSTAT - Power Mode Status
 */
#define SMC_PMSTAT_PMSTAT(x)                     (((uint8_t)(((uint8_t)(x)) << SMC_PMSTAT_PMSTAT_SHIFT)) & SMC_PMSTAT_PMSTAT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SMC_Register_Masks */


/* SMC - Peripheral instance base addresses */
/** Peripheral SMC base address */
#define SMC_BASE                                 (0x4007E000u)
/** Peripheral SMC base pointer */
#define SMC                                      ((SMC_Type *)SMC_BASE)
/** Array initializer of SMC peripheral base addresses */
#define SMC_BASE_ADDRS                           { SMC_BASE }
/** Array initializer of SMC peripheral base pointers */
#define SMC_BASE_PTRS                            { SMC }

/*!
 * @}
 */ /* end of group SMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Peripheral_Access_Layer SPI Peripheral Access Layer
 * @{
 */

/** SPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
       uint8_t RESERVED_0[4];
  __IO uint32_t TCR;                               /**< Transfer Count Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    __IO uint32_t CTAR[2];                           /**< Clock and Transfer Attributes Register (In Master Mode), array offset: 0xC, array step: 0x4 */
    __IO uint32_t CTAR_SLAVE[1];                     /**< Clock and Transfer Attributes Register (In Slave Mode), array offset: 0xC, array step: 0x4 */
  };
       uint8_t RESERVED_1[24];
  __IO uint32_t SR;                                /**< Status Register, offset: 0x2C */
  __IO uint32_t RSER;                              /**< DMA/Interrupt Request Select and Enable Register, offset: 0x30 */
  union {                                          /* offset: 0x34 */
    __IO uint32_t PUSHR;                             /**< PUSH TX FIFO Register In Master Mode, offset: 0x34 */
    __IO uint32_t PUSHR_SLAVE;                       /**< PUSH TX FIFO Register In Slave Mode, offset: 0x34 */
  };
  __I  uint32_t POPR;                              /**< POP RX FIFO Register, offset: 0x38 */
  __I  uint32_t TXFR0;                             /**< Transmit FIFO Registers, offset: 0x3C */
  __I  uint32_t TXFR1;                             /**< Transmit FIFO Registers, offset: 0x40 */
  __I  uint32_t TXFR2;                             /**< Transmit FIFO Registers, offset: 0x44 */
  __I  uint32_t TXFR3;                             /**< Transmit FIFO Registers, offset: 0x48 */
       uint8_t RESERVED_2[48];
  __I  uint32_t RXFR0;                             /**< Receive FIFO Registers, offset: 0x7C */
  __I  uint32_t RXFR1;                             /**< Receive FIFO Registers, offset: 0x80 */
  __I  uint32_t RXFR2;                             /**< Receive FIFO Registers, offset: 0x84 */
  __I  uint32_t RXFR3;                             /**< Receive FIFO Registers, offset: 0x88 */
} SPI_Type;

/* ----------------------------------------------------------------------------
   -- SPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Masks SPI Register Masks
 * @{
 */

/*! @name MCR - Module Configuration Register */
/*! @{ */
#define SPI_MCR_HALT_MASK                        (0x1U)
#define SPI_MCR_HALT_SHIFT                       (0U)
/*! HALT - Halt
 *  0b0..Start transfers.
 *  0b1..Stop transfers.
 */
#define SPI_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_HALT_SHIFT)) & SPI_MCR_HALT_MASK)
#define SPI_MCR_SMPL_PT_MASK                     (0x300U)
#define SPI_MCR_SMPL_PT_SHIFT                    (8U)
/*! SMPL_PT - Sample Point
 *  0b00..0 protocol clock cycles between SCK edge and SIN sample
 *  0b01..1 protocol clock cycle between SCK edge and SIN sample
 *  0b10..2 protocol clock cycles between SCK edge and SIN sample
 *  0b11..Reserved
 */
#define SPI_MCR_SMPL_PT(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_SMPL_PT_SHIFT)) & SPI_MCR_SMPL_PT_MASK)
#define SPI_MCR_CLR_RXF_MASK                     (0x400U)
#define SPI_MCR_CLR_RXF_SHIFT                    (10U)
/*! CLR_RXF - Clear RX FIFO
 *  0b0..Do not clear the RX FIFO counter.
 *  0b1..Clear the RX FIFO counter.
 */
#define SPI_MCR_CLR_RXF(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_CLR_RXF_SHIFT)) & SPI_MCR_CLR_RXF_MASK)
#define SPI_MCR_CLR_TXF_MASK                     (0x800U)
#define SPI_MCR_CLR_TXF_SHIFT                    (11U)
/*! CLR_TXF - Clear TX FIFO
 *  0b0..Do not clear the TX FIFO counter.
 *  0b1..Clear the TX FIFO counter.
 */
#define SPI_MCR_CLR_TXF(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_CLR_TXF_SHIFT)) & SPI_MCR_CLR_TXF_MASK)
#define SPI_MCR_DIS_RXF_MASK                     (0x1000U)
#define SPI_MCR_DIS_RXF_SHIFT                    (12U)
/*! DIS_RXF - Disable Receive FIFO
 *  0b0..RX FIFO is enabled.
 *  0b1..RX FIFO is disabled.
 */
#define SPI_MCR_DIS_RXF(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_DIS_RXF_SHIFT)) & SPI_MCR_DIS_RXF_MASK)
#define SPI_MCR_DIS_TXF_MASK                     (0x2000U)
#define SPI_MCR_DIS_TXF_SHIFT                    (13U)
/*! DIS_TXF - Disable Transmit FIFO
 *  0b0..TX FIFO is enabled.
 *  0b1..TX FIFO is disabled.
 */
#define SPI_MCR_DIS_TXF(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_DIS_TXF_SHIFT)) & SPI_MCR_DIS_TXF_MASK)
#define SPI_MCR_MDIS_MASK                        (0x4000U)
#define SPI_MCR_MDIS_SHIFT                       (14U)
/*! MDIS - Module Disable
 *  0b0..Enables the module clocks.
 *  0b1..Allows external logic to disable the module clocks.
 */
#define SPI_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_MDIS_SHIFT)) & SPI_MCR_MDIS_MASK)
#define SPI_MCR_DOZE_MASK                        (0x8000U)
#define SPI_MCR_DOZE_SHIFT                       (15U)
/*! DOZE - Doze Enable
 *  0b0..Doze mode has no effect on the module.
 *  0b1..Doze mode disables the module.
 */
#define SPI_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_DOZE_SHIFT)) & SPI_MCR_DOZE_MASK)
#define SPI_MCR_PCSIS_MASK                       (0xF0000U)
#define SPI_MCR_PCSIS_SHIFT                      (16U)
/*! PCSIS - Peripheral Chip Select x Inactive State
 *  0b0000..The inactive state of PCSx is low.
 *  0b0001..The inactive state of PCSx is high.
 */
#define SPI_MCR_PCSIS(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_MCR_PCSIS_SHIFT)) & SPI_MCR_PCSIS_MASK)
#define SPI_MCR_ROOE_MASK                        (0x1000000U)
#define SPI_MCR_ROOE_SHIFT                       (24U)
/*! ROOE - Receive FIFO Overflow Overwrite Enable
 *  0b0..Incoming data is ignored.
 *  0b1..Incoming data is shifted into the shift register.
 */
#define SPI_MCR_ROOE(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_ROOE_SHIFT)) & SPI_MCR_ROOE_MASK)
#define SPI_MCR_MTFE_MASK                        (0x4000000U)
#define SPI_MCR_MTFE_SHIFT                       (26U)
/*! MTFE - Modified Transfer Format Enable
 *  0b0..Modified SPI transfer format disabled.
 *  0b1..Modified SPI transfer format enabled.
 */
#define SPI_MCR_MTFE(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_MTFE_SHIFT)) & SPI_MCR_MTFE_MASK)
#define SPI_MCR_FRZ_MASK                         (0x8000000U)
#define SPI_MCR_FRZ_SHIFT                        (27U)
/*! FRZ - Freeze
 *  0b0..Do not halt serial transfers in Debug mode.
 *  0b1..Halt serial transfers in Debug mode.
 */
#define SPI_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_MCR_FRZ_SHIFT)) & SPI_MCR_FRZ_MASK)
#define SPI_MCR_DCONF_MASK                       (0x30000000U)
#define SPI_MCR_DCONF_SHIFT                      (28U)
/*! DCONF - SPI Configuration.
 *  0b00..SPI
 *  0b01..Reserved
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define SPI_MCR_DCONF(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_MCR_DCONF_SHIFT)) & SPI_MCR_DCONF_MASK)
#define SPI_MCR_CONT_SCKE_MASK                   (0x40000000U)
#define SPI_MCR_CONT_SCKE_SHIFT                  (30U)
/*! CONT_SCKE - Continuous SCK Enable
 *  0b0..Continuous SCK disabled.
 *  0b1..Continuous SCK enabled.
 */
#define SPI_MCR_CONT_SCKE(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_MCR_CONT_SCKE_SHIFT)) & SPI_MCR_CONT_SCKE_MASK)
#define SPI_MCR_MSTR_MASK                        (0x80000000U)
#define SPI_MCR_MSTR_SHIFT                       (31U)
/*! MSTR - Master/Slave Mode Select
 *  0b0..Enables Slave mode
 *  0b1..Enables Master mode
 */
#define SPI_MCR_MSTR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_MCR_MSTR_SHIFT)) & SPI_MCR_MSTR_MASK)
/*! @} */

/*! @name TCR - Transfer Count Register */
/*! @{ */
#define SPI_TCR_SPI_TCNT_MASK                    (0xFFFF0000U)
#define SPI_TCR_SPI_TCNT_SHIFT                   (16U)
/*! SPI_TCNT - SPI Transfer Counter
 */
#define SPI_TCR_SPI_TCNT(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TCR_SPI_TCNT_SHIFT)) & SPI_TCR_SPI_TCNT_MASK)
/*! @} */

/*! @name CTAR - Clock and Transfer Attributes Register (In Master Mode) */
/*! @{ */
#define SPI_CTAR_BR_MASK                         (0xFU)
#define SPI_CTAR_BR_SHIFT                        (0U)
/*! BR - Baud Rate Scaler
 */
#define SPI_CTAR_BR(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_BR_SHIFT)) & SPI_CTAR_BR_MASK)
#define SPI_CTAR_DT_MASK                         (0xF0U)
#define SPI_CTAR_DT_SHIFT                        (4U)
/*! DT - Delay After Transfer Scaler
 */
#define SPI_CTAR_DT(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_DT_SHIFT)) & SPI_CTAR_DT_MASK)
#define SPI_CTAR_ASC_MASK                        (0xF00U)
#define SPI_CTAR_ASC_SHIFT                       (8U)
/*! ASC - After SCK Delay Scaler
 */
#define SPI_CTAR_ASC(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_ASC_SHIFT)) & SPI_CTAR_ASC_MASK)
#define SPI_CTAR_CSSCK_MASK                      (0xF000U)
#define SPI_CTAR_CSSCK_SHIFT                     (12U)
/*! CSSCK - PCS to SCK Delay Scaler
 */
#define SPI_CTAR_CSSCK(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_CSSCK_SHIFT)) & SPI_CTAR_CSSCK_MASK)
#define SPI_CTAR_PBR_MASK                        (0x30000U)
#define SPI_CTAR_PBR_SHIFT                       (16U)
/*! PBR - Baud Rate Prescaler
 *  0b00..Baud Rate Prescaler value is 2.
 *  0b01..Baud Rate Prescaler value is 3.
 *  0b10..Baud Rate Prescaler value is 5.
 *  0b11..Baud Rate Prescaler value is 7.
 */
#define SPI_CTAR_PBR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PBR_SHIFT)) & SPI_CTAR_PBR_MASK)
#define SPI_CTAR_PDT_MASK                        (0xC0000U)
#define SPI_CTAR_PDT_SHIFT                       (18U)
/*! PDT - Delay after Transfer Prescaler
 *  0b00..Delay after Transfer Prescaler value is 1.
 *  0b01..Delay after Transfer Prescaler value is 3.
 *  0b10..Delay after Transfer Prescaler value is 5.
 *  0b11..Delay after Transfer Prescaler value is 7.
 */
#define SPI_CTAR_PDT(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PDT_SHIFT)) & SPI_CTAR_PDT_MASK)
#define SPI_CTAR_PASC_MASK                       (0x300000U)
#define SPI_CTAR_PASC_SHIFT                      (20U)
/*! PASC - After SCK Delay Prescaler
 *  0b00..Delay after Transfer Prescaler value is 1.
 *  0b01..Delay after Transfer Prescaler value is 3.
 *  0b10..Delay after Transfer Prescaler value is 5.
 *  0b11..Delay after Transfer Prescaler value is 7.
 */
#define SPI_CTAR_PASC(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PASC_SHIFT)) & SPI_CTAR_PASC_MASK)
#define SPI_CTAR_PCSSCK_MASK                     (0xC00000U)
#define SPI_CTAR_PCSSCK_SHIFT                    (22U)
/*! PCSSCK - PCS to SCK Delay Prescaler
 *  0b00..PCS to SCK Prescaler value is 1.
 *  0b01..PCS to SCK Prescaler value is 3.
 *  0b10..PCS to SCK Prescaler value is 5.
 *  0b11..PCS to SCK Prescaler value is 7.
 */
#define SPI_CTAR_PCSSCK(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PCSSCK_SHIFT)) & SPI_CTAR_PCSSCK_MASK)
#define SPI_CTAR_LSBFE_MASK                      (0x1000000U)
#define SPI_CTAR_LSBFE_SHIFT                     (24U)
/*! LSBFE - LSB First
 *  0b0..Data is transferred MSB first.
 *  0b1..Data is transferred LSB first.
 */
#define SPI_CTAR_LSBFE(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_LSBFE_SHIFT)) & SPI_CTAR_LSBFE_MASK)
#define SPI_CTAR_CPHA_MASK                       (0x2000000U)
#define SPI_CTAR_CPHA_SHIFT                      (25U)
/*! CPHA - Clock Phase
 *  0b0..Data is captured on the leading edge of SCK and changed on the following edge.
 *  0b1..Data is changed on the leading edge of SCK and captured on the following edge.
 */
#define SPI_CTAR_CPHA(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_CPHA_SHIFT)) & SPI_CTAR_CPHA_MASK)
#define SPI_CTAR_CPOL_MASK                       (0x4000000U)
#define SPI_CTAR_CPOL_SHIFT                      (26U)
/*! CPOL - Clock Polarity
 *  0b0..The inactive state value of SCK is low.
 *  0b1..The inactive state value of SCK is high.
 */
#define SPI_CTAR_CPOL(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_CPOL_SHIFT)) & SPI_CTAR_CPOL_MASK)
#define SPI_CTAR_FMSZ_MASK                       (0x78000000U)
#define SPI_CTAR_FMSZ_SHIFT                      (27U)
/*! FMSZ - Frame Size
 */
#define SPI_CTAR_FMSZ(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_FMSZ_SHIFT)) & SPI_CTAR_FMSZ_MASK)
#define SPI_CTAR_DBR_MASK                        (0x80000000U)
#define SPI_CTAR_DBR_SHIFT                       (31U)
/*! DBR - Double Baud Rate
 *  0b0..The baud rate is computed normally with a 50/50 duty cycle.
 *  0b1..The baud rate is doubled with the duty cycle depending on the Baud Rate Prescaler.
 */
#define SPI_CTAR_DBR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_DBR_SHIFT)) & SPI_CTAR_DBR_MASK)
/*! @} */

/* The count of SPI_CTAR */
#define SPI_CTAR_COUNT                           (2U)

/*! @name CTAR_SLAVE - Clock and Transfer Attributes Register (In Slave Mode) */
/*! @{ */
#define SPI_CTAR_SLAVE_CPHA_MASK                 (0x2000000U)
#define SPI_CTAR_SLAVE_CPHA_SHIFT                (25U)
/*! CPHA - Clock Phase
 *  0b0..Data is captured on the leading edge of SCK and changed on the following edge.
 *  0b1..Data is changed on the leading edge of SCK and captured on the following edge.
 */
#define SPI_CTAR_SLAVE_CPHA(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_SLAVE_CPHA_SHIFT)) & SPI_CTAR_SLAVE_CPHA_MASK)
#define SPI_CTAR_SLAVE_CPOL_MASK                 (0x4000000U)
#define SPI_CTAR_SLAVE_CPOL_SHIFT                (26U)
/*! CPOL - Clock Polarity
 *  0b0..The inactive state value of SCK is low.
 *  0b1..The inactive state value of SCK is high.
 */
#define SPI_CTAR_SLAVE_CPOL(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_SLAVE_CPOL_SHIFT)) & SPI_CTAR_SLAVE_CPOL_MASK)
#define SPI_CTAR_SLAVE_FMSZ_MASK                 (0x78000000U)
#define SPI_CTAR_SLAVE_FMSZ_SHIFT                (27U)
/*! FMSZ - Frame Size
 */
#define SPI_CTAR_SLAVE_FMSZ(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_SLAVE_FMSZ_SHIFT)) & SPI_CTAR_SLAVE_FMSZ_MASK)
/*! @} */

/* The count of SPI_CTAR_SLAVE */
#define SPI_CTAR_SLAVE_COUNT                     (1U)

/*! @name SR - Status Register */
/*! @{ */
#define SPI_SR_POPNXTPTR_MASK                    (0xFU)
#define SPI_SR_POPNXTPTR_SHIFT                   (0U)
/*! POPNXTPTR - Pop Next Pointer
 */
#define SPI_SR_POPNXTPTR(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_SR_POPNXTPTR_SHIFT)) & SPI_SR_POPNXTPTR_MASK)
#define SPI_SR_RXCTR_MASK                        (0xF0U)
#define SPI_SR_RXCTR_SHIFT                       (4U)
/*! RXCTR - RX FIFO Counter
 */
#define SPI_SR_RXCTR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_SR_RXCTR_SHIFT)) & SPI_SR_RXCTR_MASK)
#define SPI_SR_TXNXTPTR_MASK                     (0xF00U)
#define SPI_SR_TXNXTPTR_SHIFT                    (8U)
/*! TXNXTPTR - Transmit Next Pointer
 */
#define SPI_SR_TXNXTPTR(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_SR_TXNXTPTR_SHIFT)) & SPI_SR_TXNXTPTR_MASK)
#define SPI_SR_TXCTR_MASK                        (0xF000U)
#define SPI_SR_TXCTR_SHIFT                       (12U)
/*! TXCTR - TX FIFO Counter
 */
#define SPI_SR_TXCTR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_SR_TXCTR_SHIFT)) & SPI_SR_TXCTR_MASK)
#define SPI_SR_RFDF_MASK                         (0x20000U)
#define SPI_SR_RFDF_SHIFT                        (17U)
/*! RFDF - Receive FIFO Drain Flag
 *  0b0..RX FIFO is empty.
 *  0b1..RX FIFO is not empty.
 */
#define SPI_SR_RFDF(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_SR_RFDF_SHIFT)) & SPI_SR_RFDF_MASK)
#define SPI_SR_RFOF_MASK                         (0x80000U)
#define SPI_SR_RFOF_SHIFT                        (19U)
/*! RFOF - Receive FIFO Overflow Flag
 *  0b0..No Rx FIFO overflow.
 *  0b1..Rx FIFO overflow has occurred.
 */
#define SPI_SR_RFOF(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_SR_RFOF_SHIFT)) & SPI_SR_RFOF_MASK)
#define SPI_SR_TFFF_MASK                         (0x2000000U)
#define SPI_SR_TFFF_SHIFT                        (25U)
/*! TFFF - Transmit FIFO Fill Flag
 *  0b0..TX FIFO is full.
 *  0b1..TX FIFO is not full.
 */
#define SPI_SR_TFFF(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_SR_TFFF_SHIFT)) & SPI_SR_TFFF_MASK)
#define SPI_SR_TFUF_MASK                         (0x8000000U)
#define SPI_SR_TFUF_SHIFT                        (27U)
/*! TFUF - Transmit FIFO Underflow Flag
 *  0b0..No TX FIFO underflow.
 *  0b1..TX FIFO underflow has occurred.
 */
#define SPI_SR_TFUF(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_SR_TFUF_SHIFT)) & SPI_SR_TFUF_MASK)
#define SPI_SR_EOQF_MASK                         (0x10000000U)
#define SPI_SR_EOQF_SHIFT                        (28U)
/*! EOQF - End of Queue Flag
 *  0b0..EOQ is not set in the executing command.
 *  0b1..EOQ is set in the executing SPI command.
 */
#define SPI_SR_EOQF(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_SR_EOQF_SHIFT)) & SPI_SR_EOQF_MASK)
#define SPI_SR_TXRXS_MASK                        (0x40000000U)
#define SPI_SR_TXRXS_SHIFT                       (30U)
/*! TXRXS - TX and RX Status
 *  0b0..Transmit and receive operations are disabled (The module is in Stopped state).
 *  0b1..Transmit and receive operations are enabled (The module is in Running state).
 */
#define SPI_SR_TXRXS(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_SR_TXRXS_SHIFT)) & SPI_SR_TXRXS_MASK)
#define SPI_SR_TCF_MASK                          (0x80000000U)
#define SPI_SR_TCF_SHIFT                         (31U)
/*! TCF - Transfer Complete Flag
 *  0b0..Transfer not complete.
 *  0b1..Transfer complete.
 */
#define SPI_SR_TCF(x)                            (((uint32_t)(((uint32_t)(x)) << SPI_SR_TCF_SHIFT)) & SPI_SR_TCF_MASK)
/*! @} */

/*! @name RSER - DMA/Interrupt Request Select and Enable Register */
/*! @{ */
#define SPI_RSER_RFDF_DIRS_MASK                  (0x10000U)
#define SPI_RSER_RFDF_DIRS_SHIFT                 (16U)
/*! RFDF_DIRS - Receive FIFO Drain DMA or Interrupt Request Select
 *  0b0..Interrupt request.
 *  0b1..DMA request.
 */
#define SPI_RSER_RFDF_DIRS(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_RSER_RFDF_DIRS_SHIFT)) & SPI_RSER_RFDF_DIRS_MASK)
#define SPI_RSER_RFDF_RE_MASK                    (0x20000U)
#define SPI_RSER_RFDF_RE_SHIFT                   (17U)
/*! RFDF_RE - Receive FIFO Drain Request Enable
 *  0b0..RFDF interrupt or DMA requests are disabled.
 *  0b1..RFDF interrupt or DMA requests are enabled.
 */
#define SPI_RSER_RFDF_RE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RSER_RFDF_RE_SHIFT)) & SPI_RSER_RFDF_RE_MASK)
#define SPI_RSER_RFOF_RE_MASK                    (0x80000U)
#define SPI_RSER_RFOF_RE_SHIFT                   (19U)
/*! RFOF_RE - Receive FIFO Overflow Request Enable
 *  0b0..RFOF interrupt requests are disabled.
 *  0b1..RFOF interrupt requests are enabled.
 */
#define SPI_RSER_RFOF_RE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RSER_RFOF_RE_SHIFT)) & SPI_RSER_RFOF_RE_MASK)
#define SPI_RSER_TFFF_DIRS_MASK                  (0x1000000U)
#define SPI_RSER_TFFF_DIRS_SHIFT                 (24U)
/*! TFFF_DIRS - Transmit FIFO Fill DMA or Interrupt Request Select
 *  0b0..TFFF flag generates interrupt requests.
 *  0b1..TFFF flag generates DMA requests.
 */
#define SPI_RSER_TFFF_DIRS(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_RSER_TFFF_DIRS_SHIFT)) & SPI_RSER_TFFF_DIRS_MASK)
#define SPI_RSER_TFFF_RE_MASK                    (0x2000000U)
#define SPI_RSER_TFFF_RE_SHIFT                   (25U)
/*! TFFF_RE - Transmit FIFO Fill Request Enable
 *  0b0..TFFF interrupts or DMA requests are disabled.
 *  0b1..TFFF interrupts or DMA requests are enabled.
 */
#define SPI_RSER_TFFF_RE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RSER_TFFF_RE_SHIFT)) & SPI_RSER_TFFF_RE_MASK)
#define SPI_RSER_TFUF_RE_MASK                    (0x8000000U)
#define SPI_RSER_TFUF_RE_SHIFT                   (27U)
/*! TFUF_RE - Transmit FIFO Underflow Request Enable
 *  0b0..TFUF interrupt requests are disabled.
 *  0b1..TFUF interrupt requests are enabled.
 */
#define SPI_RSER_TFUF_RE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RSER_TFUF_RE_SHIFT)) & SPI_RSER_TFUF_RE_MASK)
#define SPI_RSER_EOQF_RE_MASK                    (0x10000000U)
#define SPI_RSER_EOQF_RE_SHIFT                   (28U)
/*! EOQF_RE - Finished Request Enable
 *  0b0..EOQF interrupt requests are disabled.
 *  0b1..EOQF interrupt requests are enabled.
 */
#define SPI_RSER_EOQF_RE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RSER_EOQF_RE_SHIFT)) & SPI_RSER_EOQF_RE_MASK)
#define SPI_RSER_TCF_RE_MASK                     (0x80000000U)
#define SPI_RSER_TCF_RE_SHIFT                    (31U)
/*! TCF_RE - Transmission Complete Request Enable
 *  0b0..TCF interrupt requests are disabled.
 *  0b1..TCF interrupt requests are enabled.
 */
#define SPI_RSER_TCF_RE(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_RSER_TCF_RE_SHIFT)) & SPI_RSER_TCF_RE_MASK)
/*! @} */

/*! @name PUSHR - PUSH TX FIFO Register In Master Mode */
/*! @{ */
#define SPI_PUSHR_TXDATA_MASK                    (0xFFFFU)
#define SPI_PUSHR_TXDATA_SHIFT                   (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_PUSHR_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_TXDATA_SHIFT)) & SPI_PUSHR_TXDATA_MASK)
#define SPI_PUSHR_PCS_MASK                       (0xF0000U)
#define SPI_PUSHR_PCS_SHIFT                      (16U)
/*! PCS
 *  0b0000..Negate the PCS[x] signal.
 *  0b0001..Assert the PCS[x] signal.
 */
#define SPI_PUSHR_PCS(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_PCS_SHIFT)) & SPI_PUSHR_PCS_MASK)
#define SPI_PUSHR_CTCNT_MASK                     (0x4000000U)
#define SPI_PUSHR_CTCNT_SHIFT                    (26U)
/*! CTCNT - Clear Transfer Counter
 *  0b0..Do not clear the TCR[TCNT] field.
 *  0b1..Clear the TCR[TCNT] field.
 */
#define SPI_PUSHR_CTCNT(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_CTCNT_SHIFT)) & SPI_PUSHR_CTCNT_MASK)
#define SPI_PUSHR_EOQ_MASK                       (0x8000000U)
#define SPI_PUSHR_EOQ_SHIFT                      (27U)
/*! EOQ - End Of Queue
 *  0b0..The SPI data is not the last data to transfer.
 *  0b1..The SPI data is the last data to transfer.
 */
#define SPI_PUSHR_EOQ(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_EOQ_SHIFT)) & SPI_PUSHR_EOQ_MASK)
#define SPI_PUSHR_CTAS_MASK                      (0x70000000U)
#define SPI_PUSHR_CTAS_SHIFT                     (28U)
/*! CTAS - Clock and Transfer Attributes Select
 *  0b000..CTAR0
 *  0b001..CTAR1
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define SPI_PUSHR_CTAS(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_CTAS_SHIFT)) & SPI_PUSHR_CTAS_MASK)
#define SPI_PUSHR_CONT_MASK                      (0x80000000U)
#define SPI_PUSHR_CONT_SHIFT                     (31U)
/*! CONT - Continuous Peripheral Chip Select Enable
 *  0b0..Return PCSn signals to their inactive state between transfers.
 *  0b1..Keep PCSn signals asserted between transfers.
 */
#define SPI_PUSHR_CONT(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_CONT_SHIFT)) & SPI_PUSHR_CONT_MASK)
/*! @} */

/*! @name PUSHR_SLAVE - PUSH TX FIFO Register In Slave Mode */
/*! @{ */
#define SPI_PUSHR_SLAVE_TXDATA_MASK              (0xFFFFU)
#define SPI_PUSHR_SLAVE_TXDATA_SHIFT             (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_PUSHR_SLAVE_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_SLAVE_TXDATA_SHIFT)) & SPI_PUSHR_SLAVE_TXDATA_MASK)
/*! @} */

/*! @name POPR - POP RX FIFO Register */
/*! @{ */
#define SPI_POPR_RXDATA_MASK                     (0xFFFFFFFFU)
#define SPI_POPR_RXDATA_SHIFT                    (0U)
/*! RXDATA - Received Data
 */
#define SPI_POPR_RXDATA(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_POPR_RXDATA_SHIFT)) & SPI_POPR_RXDATA_MASK)
/*! @} */

/*! @name TXFR0 - Transmit FIFO Registers */
/*! @{ */
#define SPI_TXFR0_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR0_TXDATA_SHIFT                   (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_TXFR0_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR0_TXDATA_SHIFT)) & SPI_TXFR0_TXDATA_MASK)
#define SPI_TXFR0_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR0_TXCMD_TXDATA_SHIFT             (16U)
/*! TXCMD_TXDATA - Transmit Command or Transmit Data
 */
#define SPI_TXFR0_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR0_TXCMD_TXDATA_SHIFT)) & SPI_TXFR0_TXCMD_TXDATA_MASK)
/*! @} */

/*! @name TXFR1 - Transmit FIFO Registers */
/*! @{ */
#define SPI_TXFR1_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR1_TXDATA_SHIFT                   (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_TXFR1_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR1_TXDATA_SHIFT)) & SPI_TXFR1_TXDATA_MASK)
#define SPI_TXFR1_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR1_TXCMD_TXDATA_SHIFT             (16U)
/*! TXCMD_TXDATA - Transmit Command or Transmit Data
 */
#define SPI_TXFR1_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR1_TXCMD_TXDATA_SHIFT)) & SPI_TXFR1_TXCMD_TXDATA_MASK)
/*! @} */

/*! @name TXFR2 - Transmit FIFO Registers */
/*! @{ */
#define SPI_TXFR2_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR2_TXDATA_SHIFT                   (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_TXFR2_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR2_TXDATA_SHIFT)) & SPI_TXFR2_TXDATA_MASK)
#define SPI_TXFR2_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR2_TXCMD_TXDATA_SHIFT             (16U)
/*! TXCMD_TXDATA - Transmit Command or Transmit Data
 */
#define SPI_TXFR2_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR2_TXCMD_TXDATA_SHIFT)) & SPI_TXFR2_TXCMD_TXDATA_MASK)
/*! @} */

/*! @name TXFR3 - Transmit FIFO Registers */
/*! @{ */
#define SPI_TXFR3_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR3_TXDATA_SHIFT                   (0U)
/*! TXDATA - Transmit Data
 */
#define SPI_TXFR3_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR3_TXDATA_SHIFT)) & SPI_TXFR3_TXDATA_MASK)
#define SPI_TXFR3_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR3_TXCMD_TXDATA_SHIFT             (16U)
/*! TXCMD_TXDATA - Transmit Command or Transmit Data
 */
#define SPI_TXFR3_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR3_TXCMD_TXDATA_SHIFT)) & SPI_TXFR3_TXCMD_TXDATA_MASK)
/*! @} */

/*! @name RXFR0 - Receive FIFO Registers */
/*! @{ */
#define SPI_RXFR0_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR0_RXDATA_SHIFT                   (0U)
/*! RXDATA - Receive Data
 */
#define SPI_RXFR0_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR0_RXDATA_SHIFT)) & SPI_RXFR0_RXDATA_MASK)
/*! @} */

/*! @name RXFR1 - Receive FIFO Registers */
/*! @{ */
#define SPI_RXFR1_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR1_RXDATA_SHIFT                   (0U)
/*! RXDATA - Receive Data
 */
#define SPI_RXFR1_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR1_RXDATA_SHIFT)) & SPI_RXFR1_RXDATA_MASK)
/*! @} */

/*! @name RXFR2 - Receive FIFO Registers */
/*! @{ */
#define SPI_RXFR2_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR2_RXDATA_SHIFT                   (0U)
/*! RXDATA - Receive Data
 */
#define SPI_RXFR2_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR2_RXDATA_SHIFT)) & SPI_RXFR2_RXDATA_MASK)
/*! @} */

/*! @name RXFR3 - Receive FIFO Registers */
/*! @{ */
#define SPI_RXFR3_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR3_RXDATA_SHIFT                   (0U)
/*! RXDATA - Receive Data
 */
#define SPI_RXFR3_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR3_RXDATA_SHIFT)) & SPI_RXFR3_RXDATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SPI_Register_Masks */


/* SPI - Peripheral instance base addresses */
/** Peripheral SPI0 base address */
#define SPI0_BASE                                (0x4002C000u)
/** Peripheral SPI0 base pointer */
#define SPI0                                     ((SPI_Type *)SPI0_BASE)
/** Peripheral SPI1 base address */
#define SPI1_BASE                                (0x4002D000u)
/** Peripheral SPI1 base pointer */
#define SPI1                                     ((SPI_Type *)SPI1_BASE)
/** Array initializer of SPI peripheral base addresses */
#define SPI_BASE_ADDRS                           { SPI0_BASE, SPI1_BASE }
/** Array initializer of SPI peripheral base pointers */
#define SPI_BASE_PTRS                            { SPI0, SPI1 }
/** Interrupt vectors for the SPI peripheral type */
#define SPI_IRQS                                 { SPI0_IRQn, SPI1_IRQn }

/*!
 * @}
 */ /* end of group SPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TPM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Peripheral_Access_Layer TPM Peripheral Access Layer
 * @{
 */

/** TPM - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC;                                /**< Status and Control, offset: 0x0 */
  __IO uint32_t CNT;                               /**< Counter, offset: 0x4 */
  __IO uint32_t MOD;                               /**< Modulo, offset: 0x8 */
  struct {                                         /* offset: 0xC, array step: 0x8 */
    __IO uint32_t CnSC;                              /**< Channel (n) Status and Control, array offset: 0xC, array step: 0x8 */
    __IO uint32_t CnV;                               /**< Channel (n) Value, array offset: 0x10, array step: 0x8 */
  } CONTROLS[4];
       uint8_t RESERVED_0[36];
  __IO uint32_t STATUS;                            /**< Capture and Compare Status, offset: 0x50 */
       uint8_t RESERVED_1[16];
  __IO uint32_t COMBINE;                           /**< Combine Channel Register, offset: 0x64 */
       uint8_t RESERVED_2[8];
  __IO uint32_t POL;                               /**< Channel Polarity, offset: 0x70 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FILTER;                            /**< Filter Control, offset: 0x78 */
       uint8_t RESERVED_4[4];
  __IO uint32_t QDCTRL;                            /**< Quadrature Decoder Control and Status, offset: 0x80 */
  __IO uint32_t CONF;                              /**< Configuration, offset: 0x84 */
} TPM_Type;

/* ----------------------------------------------------------------------------
   -- TPM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Masks TPM Register Masks
 * @{
 */

/*! @name SC - Status and Control */
/*! @{ */
#define TPM_SC_PS_MASK                           (0x7U)
#define TPM_SC_PS_SHIFT                          (0U)
/*! PS - Prescale Factor Selection
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 4
 *  0b011..Divide by 8
 *  0b100..Divide by 16
 *  0b101..Divide by 32
 *  0b110..Divide by 64
 *  0b111..Divide by 128
 */
#define TPM_SC_PS(x)                             (((uint32_t)(((uint32_t)(x)) << TPM_SC_PS_SHIFT)) & TPM_SC_PS_MASK)
#define TPM_SC_CMOD_MASK                         (0x18U)
#define TPM_SC_CMOD_SHIFT                        (3U)
/*! CMOD - Clock Mode Selection
 *  0b00..TPM counter is disabled
 *  0b01..TPM counter increments on every TPM counter clock
 *  0b10..TPM counter increments on rising edge of TPM_EXTCLK synchronized to the TPM counter clock
 *  0b11..Reserved.
 */
#define TPM_SC_CMOD(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_SC_CMOD_SHIFT)) & TPM_SC_CMOD_MASK)
#define TPM_SC_CPWMS_MASK                        (0x20U)
#define TPM_SC_CPWMS_SHIFT                       (5U)
/*! CPWMS - Center-Aligned PWM Select
 *  0b0..TPM counter operates in up counting mode.
 *  0b1..TPM counter operates in up-down counting mode.
 */
#define TPM_SC_CPWMS(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_SC_CPWMS_SHIFT)) & TPM_SC_CPWMS_MASK)
#define TPM_SC_TOIE_MASK                         (0x40U)
#define TPM_SC_TOIE_SHIFT                        (6U)
/*! TOIE - Timer Overflow Interrupt Enable
 *  0b0..Disable TOF interrupts. Use software polling or DMA request.
 *  0b1..Enable TOF interrupts. An interrupt is generated when TOF equals one.
 */
#define TPM_SC_TOIE(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_SC_TOIE_SHIFT)) & TPM_SC_TOIE_MASK)
#define TPM_SC_TOF_MASK                          (0x80U)
#define TPM_SC_TOF_SHIFT                         (7U)
/*! TOF - Timer Overflow Flag
 *  0b0..TPM counter has not overflowed.
 *  0b1..TPM counter has overflowed.
 */
#define TPM_SC_TOF(x)                            (((uint32_t)(((uint32_t)(x)) << TPM_SC_TOF_SHIFT)) & TPM_SC_TOF_MASK)
#define TPM_SC_DMA_MASK                          (0x100U)
#define TPM_SC_DMA_SHIFT                         (8U)
/*! DMA - DMA Enable
 *  0b0..Disables DMA transfers.
 *  0b1..Enables DMA transfers.
 */
#define TPM_SC_DMA(x)                            (((uint32_t)(((uint32_t)(x)) << TPM_SC_DMA_SHIFT)) & TPM_SC_DMA_MASK)
/*! @} */

/*! @name CNT - Counter */
/*! @{ */
#define TPM_CNT_COUNT_MASK                       (0xFFFFU)
#define TPM_CNT_COUNT_SHIFT                      (0U)
/*! COUNT - Counter value
 */
#define TPM_CNT_COUNT(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CNT_COUNT_SHIFT)) & TPM_CNT_COUNT_MASK)
/*! @} */

/*! @name MOD - Modulo */
/*! @{ */
#define TPM_MOD_MOD_MASK                         (0xFFFFU)
#define TPM_MOD_MOD_SHIFT                        (0U)
/*! MOD - Modulo value
 */
#define TPM_MOD_MOD(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_MOD_MOD_SHIFT)) & TPM_MOD_MOD_MASK)
/*! @} */

/*! @name CnSC - Channel (n) Status and Control */
/*! @{ */
#define TPM_CnSC_DMA_MASK                        (0x1U)
#define TPM_CnSC_DMA_SHIFT                       (0U)
/*! DMA - DMA Enable
 *  0b0..Disable DMA transfers.
 *  0b1..Enable DMA transfers.
 */
#define TPM_CnSC_DMA(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_DMA_SHIFT)) & TPM_CnSC_DMA_MASK)
#define TPM_CnSC_ELSA_MASK                       (0x4U)
#define TPM_CnSC_ELSA_SHIFT                      (2U)
/*! ELSA - Edge or Level Select
 */
#define TPM_CnSC_ELSA(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_ELSA_SHIFT)) & TPM_CnSC_ELSA_MASK)
#define TPM_CnSC_ELSB_MASK                       (0x8U)
#define TPM_CnSC_ELSB_SHIFT                      (3U)
/*! ELSB - Edge or Level Select
 */
#define TPM_CnSC_ELSB(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_ELSB_SHIFT)) & TPM_CnSC_ELSB_MASK)
#define TPM_CnSC_MSA_MASK                        (0x10U)
#define TPM_CnSC_MSA_SHIFT                       (4U)
/*! MSA - Channel Mode Select
 */
#define TPM_CnSC_MSA(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_MSA_SHIFT)) & TPM_CnSC_MSA_MASK)
#define TPM_CnSC_MSB_MASK                        (0x20U)
#define TPM_CnSC_MSB_SHIFT                       (5U)
/*! MSB - Channel Mode Select
 */
#define TPM_CnSC_MSB(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_MSB_SHIFT)) & TPM_CnSC_MSB_MASK)
#define TPM_CnSC_CHIE_MASK                       (0x40U)
#define TPM_CnSC_CHIE_SHIFT                      (6U)
/*! CHIE - Channel Interrupt Enable
 *  0b0..Disable channel interrupts.
 *  0b1..Enable channel interrupts.
 */
#define TPM_CnSC_CHIE(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_CHIE_SHIFT)) & TPM_CnSC_CHIE_MASK)
#define TPM_CnSC_CHF_MASK                        (0x80U)
#define TPM_CnSC_CHF_SHIFT                       (7U)
/*! CHF - Channel Flag
 *  0b0..No channel event has occurred.
 *  0b1..A channel event has occurred.
 */
#define TPM_CnSC_CHF(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_CnSC_CHF_SHIFT)) & TPM_CnSC_CHF_MASK)
/*! @} */

/* The count of TPM_CnSC */
#define TPM_CnSC_COUNT                           (4U)

/*! @name CnV - Channel (n) Value */
/*! @{ */
#define TPM_CnV_VAL_MASK                         (0xFFFFU)
#define TPM_CnV_VAL_SHIFT                        (0U)
/*! VAL - Channel Value
 */
#define TPM_CnV_VAL(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_CnV_VAL_SHIFT)) & TPM_CnV_VAL_MASK)
/*! @} */

/* The count of TPM_CnV */
#define TPM_CnV_COUNT                            (4U)

/*! @name STATUS - Capture and Compare Status */
/*! @{ */
#define TPM_STATUS_CH0F_MASK                     (0x1U)
#define TPM_STATUS_CH0F_SHIFT                    (0U)
/*! CH0F - Channel 0 Flag
 *  0b0..No channel event has occurred.
 *  0b1..A channel event has occurred.
 */
#define TPM_STATUS_CH0F(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_STATUS_CH0F_SHIFT)) & TPM_STATUS_CH0F_MASK)
#define TPM_STATUS_CH1F_MASK                     (0x2U)
#define TPM_STATUS_CH1F_SHIFT                    (1U)
/*! CH1F - Channel 1 Flag
 *  0b0..No channel event has occurred.
 *  0b1..A channel event has occurred.
 */
#define TPM_STATUS_CH1F(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_STATUS_CH1F_SHIFT)) & TPM_STATUS_CH1F_MASK)
#define TPM_STATUS_CH2F_MASK                     (0x4U)
#define TPM_STATUS_CH2F_SHIFT                    (2U)
/*! CH2F - Channel 2 Flag
 *  0b0..No channel event has occurred.
 *  0b1..A channel event has occurred.
 */
#define TPM_STATUS_CH2F(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_STATUS_CH2F_SHIFT)) & TPM_STATUS_CH2F_MASK)
#define TPM_STATUS_CH3F_MASK                     (0x8U)
#define TPM_STATUS_CH3F_SHIFT                    (3U)
/*! CH3F - Channel 3 Flag
 *  0b0..No channel event has occurred.
 *  0b1..A channel event has occurred.
 */
#define TPM_STATUS_CH3F(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_STATUS_CH3F_SHIFT)) & TPM_STATUS_CH3F_MASK)
#define TPM_STATUS_TOF_MASK                      (0x100U)
#define TPM_STATUS_TOF_SHIFT                     (8U)
/*! TOF - Timer Overflow Flag
 *  0b0..TPM counter has not overflowed.
 *  0b1..TPM counter has overflowed.
 */
#define TPM_STATUS_TOF(x)                        (((uint32_t)(((uint32_t)(x)) << TPM_STATUS_TOF_SHIFT)) & TPM_STATUS_TOF_MASK)
/*! @} */

/*! @name COMBINE - Combine Channel Register */
/*! @{ */
#define TPM_COMBINE_COMBINE0_MASK                (0x1U)
#define TPM_COMBINE_COMBINE0_SHIFT               (0U)
/*! COMBINE0 - Combine Channels 0 and 1
 *  0b0..Channels 0 and 1 are independent.
 *  0b1..Channels 0 and 1 are combined.
 */
#define TPM_COMBINE_COMBINE0(x)                  (((uint32_t)(((uint32_t)(x)) << TPM_COMBINE_COMBINE0_SHIFT)) & TPM_COMBINE_COMBINE0_MASK)
#define TPM_COMBINE_COMSWAP0_MASK                (0x2U)
#define TPM_COMBINE_COMSWAP0_SHIFT               (1U)
/*! COMSWAP0 - Combine Channel 0 and 1 Swap
 *  0b0..Even channel is used for input capture and 1st compare.
 *  0b1..Odd channel is used for input capture and 1st compare.
 */
#define TPM_COMBINE_COMSWAP0(x)                  (((uint32_t)(((uint32_t)(x)) << TPM_COMBINE_COMSWAP0_SHIFT)) & TPM_COMBINE_COMSWAP0_MASK)
#define TPM_COMBINE_COMBINE1_MASK                (0x100U)
#define TPM_COMBINE_COMBINE1_SHIFT               (8U)
/*! COMBINE1 - Combine Channels 2 and 3
 *  0b0..Channels 2 and 3 are independent.
 *  0b1..Channels 2 and 3 are combined.
 */
#define TPM_COMBINE_COMBINE1(x)                  (((uint32_t)(((uint32_t)(x)) << TPM_COMBINE_COMBINE1_SHIFT)) & TPM_COMBINE_COMBINE1_MASK)
#define TPM_COMBINE_COMSWAP1_MASK                (0x200U)
#define TPM_COMBINE_COMSWAP1_SHIFT               (9U)
/*! COMSWAP1 - Combine Channels 2 and 3 Swap
 *  0b0..Even channel is used for input capture and 1st compare.
 *  0b1..Odd channel is used for input capture and 1st compare.
 */
#define TPM_COMBINE_COMSWAP1(x)                  (((uint32_t)(((uint32_t)(x)) << TPM_COMBINE_COMSWAP1_SHIFT)) & TPM_COMBINE_COMSWAP1_MASK)
/*! @} */

/*! @name POL - Channel Polarity */
/*! @{ */
#define TPM_POL_POL0_MASK                        (0x1U)
#define TPM_POL_POL0_SHIFT                       (0U)
/*! POL0 - Channel 0 Polarity
 *  0b0..The channel polarity is active high.
 *  0b1..The channel polarity is active low.
 */
#define TPM_POL_POL0(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_POL_POL0_SHIFT)) & TPM_POL_POL0_MASK)
#define TPM_POL_POL1_MASK                        (0x2U)
#define TPM_POL_POL1_SHIFT                       (1U)
/*! POL1 - Channel 1 Polarity
 *  0b0..The channel polarity is active high.
 *  0b1..The channel polarity is active low.
 */
#define TPM_POL_POL1(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_POL_POL1_SHIFT)) & TPM_POL_POL1_MASK)
#define TPM_POL_POL2_MASK                        (0x4U)
#define TPM_POL_POL2_SHIFT                       (2U)
/*! POL2 - Channel 2 Polarity
 *  0b0..The channel polarity is active high.
 *  0b1..The channel polarity is active low.
 */
#define TPM_POL_POL2(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_POL_POL2_SHIFT)) & TPM_POL_POL2_MASK)
#define TPM_POL_POL3_MASK                        (0x8U)
#define TPM_POL_POL3_SHIFT                       (3U)
/*! POL3 - Channel 3 Polarity
 *  0b0..The channel polarity is active high.
 *  0b1..The channel polarity is active low.
 */
#define TPM_POL_POL3(x)                          (((uint32_t)(((uint32_t)(x)) << TPM_POL_POL3_SHIFT)) & TPM_POL_POL3_MASK)
/*! @} */

/*! @name FILTER - Filter Control */
/*! @{ */
#define TPM_FILTER_CH0FVAL_MASK                  (0xFU)
#define TPM_FILTER_CH0FVAL_SHIFT                 (0U)
/*! CH0FVAL - Channel 0 Filter Value
 */
#define TPM_FILTER_CH0FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH0FVAL_SHIFT)) & TPM_FILTER_CH0FVAL_MASK)
#define TPM_FILTER_CH1FVAL_MASK                  (0xF0U)
#define TPM_FILTER_CH1FVAL_SHIFT                 (4U)
/*! CH1FVAL - Channel 1 Filter Value
 */
#define TPM_FILTER_CH1FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH1FVAL_SHIFT)) & TPM_FILTER_CH1FVAL_MASK)
#define TPM_FILTER_CH2FVAL_MASK                  (0xF00U)
#define TPM_FILTER_CH2FVAL_SHIFT                 (8U)
/*! CH2FVAL - Channel 2 Filter Value
 */
#define TPM_FILTER_CH2FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH2FVAL_SHIFT)) & TPM_FILTER_CH2FVAL_MASK)
#define TPM_FILTER_CH3FVAL_MASK                  (0xF000U)
#define TPM_FILTER_CH3FVAL_SHIFT                 (12U)
/*! CH3FVAL - Channel 3 Filter Value
 */
#define TPM_FILTER_CH3FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH3FVAL_SHIFT)) & TPM_FILTER_CH3FVAL_MASK)
/*! @} */

/*! @name QDCTRL - Quadrature Decoder Control and Status */
/*! @{ */
#define TPM_QDCTRL_QUADEN_MASK                   (0x1U)
#define TPM_QDCTRL_QUADEN_SHIFT                  (0U)
/*! QUADEN
 *  0b0..Quadrature decoder mode is disabled.
 *  0b1..Quadrature decoder mode is enabled.
 */
#define TPM_QDCTRL_QUADEN(x)                     (((uint32_t)(((uint32_t)(x)) << TPM_QDCTRL_QUADEN_SHIFT)) & TPM_QDCTRL_QUADEN_MASK)
#define TPM_QDCTRL_TOFDIR_MASK                   (0x2U)
#define TPM_QDCTRL_TOFDIR_SHIFT                  (1U)
/*! TOFDIR
 *  0b0..TOF bit was set on the bottom of counting. There was an FTM counter decrement and FTM counter changes
 *       from its minimum value (zero) to its maximum value (MOD register).
 *  0b1..TOF bit was set on the top of counting. There was an FTM counter increment and FTM counter changes from
 *       its maximum value (MOD register) to its minimum value (zero).
 */
#define TPM_QDCTRL_TOFDIR(x)                     (((uint32_t)(((uint32_t)(x)) << TPM_QDCTRL_TOFDIR_SHIFT)) & TPM_QDCTRL_TOFDIR_MASK)
#define TPM_QDCTRL_QUADIR_MASK                   (0x4U)
#define TPM_QDCTRL_QUADIR_SHIFT                  (2U)
/*! QUADIR - Counter Direction in Quadrature Decode Mode
 *  0b0..Counter direction is decreasing (counter decrement).
 *  0b1..Counter direction is increasing (counter increment).
 */
#define TPM_QDCTRL_QUADIR(x)                     (((uint32_t)(((uint32_t)(x)) << TPM_QDCTRL_QUADIR_SHIFT)) & TPM_QDCTRL_QUADIR_MASK)
#define TPM_QDCTRL_QUADMODE_MASK                 (0x8U)
#define TPM_QDCTRL_QUADMODE_SHIFT                (3U)
/*! QUADMODE - Quadrature Decoder Mode
 *  0b0..Phase encoding mode.
 *  0b1..Count and direction encoding mode.
 */
#define TPM_QDCTRL_QUADMODE(x)                   (((uint32_t)(((uint32_t)(x)) << TPM_QDCTRL_QUADMODE_SHIFT)) & TPM_QDCTRL_QUADMODE_MASK)
/*! @} */

/*! @name CONF - Configuration */
/*! @{ */
#define TPM_CONF_DOZEEN_MASK                     (0x20U)
#define TPM_CONF_DOZEEN_SHIFT                    (5U)
/*! DOZEEN - Doze Enable
 *  0b0..Internal TPM counter continues in Doze mode.
 *  0b1..Internal TPM counter is paused and does not increment during Doze mode. Trigger inputs and input capture events are also ignored.
 */
#define TPM_CONF_DOZEEN(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_DOZEEN_SHIFT)) & TPM_CONF_DOZEEN_MASK)
#define TPM_CONF_DBGMODE_MASK                    (0xC0U)
#define TPM_CONF_DBGMODE_SHIFT                   (6U)
/*! DBGMODE - Debug Mode
 *  0b00..TPM counter is paused and does not increment during debug mode. Trigger inputs and input capture events are also ignored.
 *  0b11..TPM counter continues in debug mode.
 */
#define TPM_CONF_DBGMODE(x)                      (((uint32_t)(((uint32_t)(x)) << TPM_CONF_DBGMODE_SHIFT)) & TPM_CONF_DBGMODE_MASK)
#define TPM_CONF_GTBSYNC_MASK                    (0x100U)
#define TPM_CONF_GTBSYNC_SHIFT                   (8U)
/*! GTBSYNC - Global Time Base Synchronization
 *  0b0..Global timebase synchronization disabled.
 *  0b1..Global timebase synchronization enabled.
 */
#define TPM_CONF_GTBSYNC(x)                      (((uint32_t)(((uint32_t)(x)) << TPM_CONF_GTBSYNC_SHIFT)) & TPM_CONF_GTBSYNC_MASK)
#define TPM_CONF_GTBEEN_MASK                     (0x200U)
#define TPM_CONF_GTBEEN_SHIFT                    (9U)
/*! GTBEEN - Global time base enable
 *  0b0..All channels use the internally generated TPM counter as their timebase
 *  0b1..All channels use an externally generated global timebase as their timebase
 */
#define TPM_CONF_GTBEEN(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_GTBEEN_SHIFT)) & TPM_CONF_GTBEEN_MASK)
#define TPM_CONF_CSOT_MASK                       (0x10000U)
#define TPM_CONF_CSOT_SHIFT                      (16U)
/*! CSOT - Counter Start on Trigger
 *  0b0..TPM counter starts to increment immediately, once it is enabled.
 *  0b1..TPM counter only starts to increment when it a rising edge on the selected input trigger is detected,
 *       after it has been enabled or after it has stopped due to overflow.
 */
#define TPM_CONF_CSOT(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CONF_CSOT_SHIFT)) & TPM_CONF_CSOT_MASK)
#define TPM_CONF_CSOO_MASK                       (0x20000U)
#define TPM_CONF_CSOO_SHIFT                      (17U)
/*! CSOO - Counter Stop On Overflow
 *  0b0..TPM counter continues incrementing or decrementing after overflow
 *  0b1..TPM counter stops incrementing or decrementing after overflow.
 */
#define TPM_CONF_CSOO(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CONF_CSOO_SHIFT)) & TPM_CONF_CSOO_MASK)
#define TPM_CONF_CROT_MASK                       (0x40000U)
#define TPM_CONF_CROT_SHIFT                      (18U)
/*! CROT - Counter Reload On Trigger
 *  0b0..Counter is not reloaded due to a rising edge on the selected input trigger
 *  0b1..Counter is reloaded when a rising edge is detected on the selected input trigger
 */
#define TPM_CONF_CROT(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CONF_CROT_SHIFT)) & TPM_CONF_CROT_MASK)
#define TPM_CONF_CPOT_MASK                       (0x80000U)
#define TPM_CONF_CPOT_SHIFT                      (19U)
/*! CPOT - Counter Pause On Trigger
 */
#define TPM_CONF_CPOT(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CONF_CPOT_SHIFT)) & TPM_CONF_CPOT_MASK)
#define TPM_CONF_TRGPOL_MASK                     (0x400000U)
#define TPM_CONF_TRGPOL_SHIFT                    (22U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Trigger is active high.
 *  0b1..Trigger is active low.
 */
#define TPM_CONF_TRGPOL(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_TRGPOL_SHIFT)) & TPM_CONF_TRGPOL_MASK)
#define TPM_CONF_TRGSRC_MASK                     (0x800000U)
#define TPM_CONF_TRGSRC_SHIFT                    (23U)
/*! TRGSRC - Trigger Source
 *  0b0..Trigger source selected by TRGSEL is external.
 *  0b1..Trigger source selected by TRGSEL is internal (channel pin input capture).
 */
#define TPM_CONF_TRGSRC(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_TRGSRC_SHIFT)) & TPM_CONF_TRGSRC_MASK)
#define TPM_CONF_TRGSEL_MASK                     (0xF000000U)
#define TPM_CONF_TRGSEL_SHIFT                    (24U)
/*! TRGSEL - Trigger Select
 *  0b0001..Channel 0 pin input capture
 *  0b0010..Channel 1 pin input capture
 *  0b0011..Channel 0 or Channel 1 pin input capture
 *  0b0100..Channel 2 pin input capture
 *  0b0101..Channel 0 or Channel 2 pin input capture
 *  0b0110..Channel 1 or Channel 2 pin input capture
 *  0b0111..Channel 0 or Channel 1 or Channel 2 pin input capture
 *  0b1000..Channel 3 pin input capture
 *  0b1001..Channel 0 or Channel 3 pin input capture
 *  0b1010..Channel 1 or Channel 3 pin input capture
 *  0b1011..Channel 0 or Channel 1 or Channel 3 pin input capture
 *  0b1100..Channel 2 or Channel 3 pin input capture
 *  0b1101..Channel 0 or Channel 2 or Channel 3 pin input capture
 *  0b1110..Channel 1 or Channel 2 or Channel 3 pin input capture
 *  0b1111..Channel 0 or Channel 1 or Channel 2 or Channel 3 pin input capture
 */
#define TPM_CONF_TRGSEL(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_TRGSEL_SHIFT)) & TPM_CONF_TRGSEL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group TPM_Register_Masks */


/* TPM - Peripheral instance base addresses */
/** Peripheral TPM0 base address */
#define TPM0_BASE                                (0x40038000u)
/** Peripheral TPM0 base pointer */
#define TPM0                                     ((TPM_Type *)TPM0_BASE)
/** Peripheral TPM1 base address */
#define TPM1_BASE                                (0x40039000u)
/** Peripheral TPM1 base pointer */
#define TPM1                                     ((TPM_Type *)TPM1_BASE)
/** Peripheral TPM2 base address */
#define TPM2_BASE                                (0x4003A000u)
/** Peripheral TPM2 base pointer */
#define TPM2                                     ((TPM_Type *)TPM2_BASE)
/** Array initializer of TPM peripheral base addresses */
#define TPM_BASE_ADDRS                           { TPM0_BASE, TPM1_BASE, TPM2_BASE }
/** Array initializer of TPM peripheral base pointers */
#define TPM_BASE_PTRS                            { TPM0, TPM1, TPM2 }
/** Interrupt vectors for the TPM peripheral type */
#define TPM_IRQS                                 { TPM0_IRQn, TPM1_IRQn, TPM2_IRQn }

/*!
 * @}
 */ /* end of group TPM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TRNG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Peripheral_Access_Layer TRNG Peripheral Access Layer
 * @{
 */

/** TRNG - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCTL;                              /**< Miscellaneous Control Register, offset: 0x0 */
  __IO uint32_t SCMISC;                            /**< Statistical Check Miscellaneous Register, offset: 0x4 */
  __IO uint32_t PKRRNG;                            /**< Poker Range Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    __IO uint32_t PKRMAX;                            /**< Poker Maximum Limit Register, offset: 0xC */
    __I  uint32_t PKRSQ;                             /**< Poker Square Calculation Result Register, offset: 0xC */
  };
  __IO uint32_t SDCTL;                             /**< Seed Control Register, offset: 0x10 */
  union {                                          /* offset: 0x14 */
    __IO uint32_t SBLIM;                             /**< Sparse Bit Limit Register, offset: 0x14 */
    __I  uint32_t TOTSAM;                            /**< Total Samples Register, offset: 0x14 */
  };
  __IO uint32_t FRQMIN;                            /**< Frequency Count Minimum Limit Register, offset: 0x18 */
  union {                                          /* offset: 0x1C */
    __I  uint32_t FRQCNT;                            /**< Frequency Count Register, offset: 0x1C */
    __IO uint32_t FRQMAX;                            /**< Frequency Count Maximum Limit Register, offset: 0x1C */
  };
  union {                                          /* offset: 0x20 */
    __I  uint32_t SCMC;                              /**< Statistical Check Monobit Count Register, offset: 0x20 */
    __IO uint32_t SCML;                              /**< Statistical Check Monobit Limit Register, offset: 0x20 */
  };
  union {                                          /* offset: 0x24 */
    __I  uint32_t SCR1C;                             /**< Statistical Check Run Length 1 Count Register, offset: 0x24 */
    __IO uint32_t SCR1L;                             /**< Statistical Check Run Length 1 Limit Register, offset: 0x24 */
  };
  union {                                          /* offset: 0x28 */
    __I  uint32_t SCR2C;                             /**< Statistical Check Run Length 2 Count Register, offset: 0x28 */
    __IO uint32_t SCR2L;                             /**< Statistical Check Run Length 2 Limit Register, offset: 0x28 */
  };
  union {                                          /* offset: 0x2C */
    __I  uint32_t SCR3C;                             /**< Statistical Check Run Length 3 Count Register, offset: 0x2C */
    __IO uint32_t SCR3L;                             /**< Statistical Check Run Length 3 Limit Register, offset: 0x2C */
  };
  union {                                          /* offset: 0x30 */
    __I  uint32_t SCR4C;                             /**< Statistical Check Run Length 4 Count Register, offset: 0x30 */
    __IO uint32_t SCR4L;                             /**< Statistical Check Run Length 4 Limit Register, offset: 0x30 */
  };
  union {                                          /* offset: 0x34 */
    __I  uint32_t SCR5C;                             /**< Statistical Check Run Length 5 Count Register, offset: 0x34 */
    __IO uint32_t SCR5L;                             /**< Statistical Check Run Length 5 Limit Register, offset: 0x34 */
  };
  union {                                          /* offset: 0x38 */
    __I  uint32_t SCR6PC;                            /**< Statistical Check Run Length 6+ Count Register, offset: 0x38 */
    __IO uint32_t SCR6PL;                            /**< Statistical Check Run Length 6+ Limit Register, offset: 0x38 */
  };
  __I  uint32_t STATUS;                            /**< Status Register, offset: 0x3C */
  __I  uint32_t ENT[16];                           /**< Entropy Read Register, array offset: 0x40, array step: 0x4 */
  __I  uint32_t PKRCNT10;                          /**< Statistical Check Poker Count 1 and 0 Register, offset: 0x80 */
  __I  uint32_t PKRCNT32;                          /**< Statistical Check Poker Count 3 and 2 Register, offset: 0x84 */
  __I  uint32_t PKRCNT54;                          /**< Statistical Check Poker Count 5 and 4 Register, offset: 0x88 */
  __I  uint32_t PKRCNT76;                          /**< Statistical Check Poker Count 7 and 6 Register, offset: 0x8C */
  __I  uint32_t PKRCNT98;                          /**< Statistical Check Poker Count 9 and 8 Register, offset: 0x90 */
  __I  uint32_t PKRCNTBA;                          /**< Statistical Check Poker Count B and A Register, offset: 0x94 */
  __I  uint32_t PKRCNTDC;                          /**< Statistical Check Poker Count D and C Register, offset: 0x98 */
  __I  uint32_t PKRCNTFE;                          /**< Statistical Check Poker Count F and E Register, offset: 0x9C */
       uint8_t RESERVED_0[16];
  __IO uint32_t SEC_CFG;                           /**< Security Configuration Register, offset: 0xB0 */
  __IO uint32_t INT_CTRL;                          /**< Interrupt Control Register, offset: 0xB4 */
  __IO uint32_t INT_MASK;                          /**< Mask Register, offset: 0xB8 */
  __I  uint32_t INT_STATUS;                        /**< Interrupt Status Register, offset: 0xBC */
       uint8_t RESERVED_1[48];
  __I  uint32_t VID1;                              /**< Version ID Register (MS), offset: 0xF0 */
  __I  uint32_t VID2;                              /**< Version ID Register (LS), offset: 0xF4 */
} TRNG_Type;

/* ----------------------------------------------------------------------------
   -- TRNG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Masks TRNG Register Masks
 * @{
 */

/*! @name MCTL - Miscellaneous Control Register */
/*! @{ */
#define TRNG_MCTL_SAMP_MODE_MASK                 (0x3U)
#define TRNG_MCTL_SAMP_MODE_SHIFT                (0U)
/*! SAMP_MODE
 *  0b00..use Von Neumann data into both Entropy shifter and Statistical Checker
 *  0b01..use raw data into both Entropy shifter and Statistical Checker
 *  0b10..use Von Neumann data into Entropy shifter. Use raw data into Statistical Checker
 *  0b11..undefined/reserved.
 */
#define TRNG_MCTL_SAMP_MODE(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_SAMP_MODE_SHIFT)) & TRNG_MCTL_SAMP_MODE_MASK)
#define TRNG_MCTL_OSC_DIV_MASK                   (0xCU)
#define TRNG_MCTL_OSC_DIV_SHIFT                  (2U)
/*! OSC_DIV
 *  0b00..use ring oscillator with no divide
 *  0b01..use ring oscillator divided-by-2
 *  0b10..use ring oscillator divided-by-4
 *  0b11..use ring oscillator divided-by-8
 */
#define TRNG_MCTL_OSC_DIV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_OSC_DIV_SHIFT)) & TRNG_MCTL_OSC_DIV_MASK)
#define TRNG_MCTL_UNUSED4_MASK                   (0x10U)
#define TRNG_MCTL_UNUSED4_SHIFT                  (4U)
#define TRNG_MCTL_UNUSED4(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_UNUSED4_SHIFT)) & TRNG_MCTL_UNUSED4_MASK)
#define TRNG_MCTL_TRNG_ACC_MASK                  (0x20U)
#define TRNG_MCTL_TRNG_ACC_SHIFT                 (5U)
#define TRNG_MCTL_TRNG_ACC(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_TRNG_ACC_SHIFT)) & TRNG_MCTL_TRNG_ACC_MASK)
#define TRNG_MCTL_RST_DEF_MASK                   (0x40U)
#define TRNG_MCTL_RST_DEF_SHIFT                  (6U)
#define TRNG_MCTL_RST_DEF(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_RST_DEF_SHIFT)) & TRNG_MCTL_RST_DEF_MASK)
#define TRNG_MCTL_FOR_SCLK_MASK                  (0x80U)
#define TRNG_MCTL_FOR_SCLK_SHIFT                 (7U)
#define TRNG_MCTL_FOR_SCLK(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_FOR_SCLK_SHIFT)) & TRNG_MCTL_FOR_SCLK_MASK)
#define TRNG_MCTL_FCT_FAIL_MASK                  (0x100U)
#define TRNG_MCTL_FCT_FAIL_SHIFT                 (8U)
#define TRNG_MCTL_FCT_FAIL(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_FCT_FAIL_SHIFT)) & TRNG_MCTL_FCT_FAIL_MASK)
#define TRNG_MCTL_FCT_VAL_MASK                   (0x200U)
#define TRNG_MCTL_FCT_VAL_SHIFT                  (9U)
#define TRNG_MCTL_FCT_VAL(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_FCT_VAL_SHIFT)) & TRNG_MCTL_FCT_VAL_MASK)
#define TRNG_MCTL_ENT_VAL_MASK                   (0x400U)
#define TRNG_MCTL_ENT_VAL_SHIFT                  (10U)
#define TRNG_MCTL_ENT_VAL(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_ENT_VAL_SHIFT)) & TRNG_MCTL_ENT_VAL_MASK)
#define TRNG_MCTL_TST_OUT_MASK                   (0x800U)
#define TRNG_MCTL_TST_OUT_SHIFT                  (11U)
#define TRNG_MCTL_TST_OUT(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_TST_OUT_SHIFT)) & TRNG_MCTL_TST_OUT_MASK)
#define TRNG_MCTL_ERR_MASK                       (0x1000U)
#define TRNG_MCTL_ERR_SHIFT                      (12U)
#define TRNG_MCTL_ERR(x)                         (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_ERR_SHIFT)) & TRNG_MCTL_ERR_MASK)
#define TRNG_MCTL_TSTOP_OK_MASK                  (0x2000U)
#define TRNG_MCTL_TSTOP_OK_SHIFT                 (13U)
#define TRNG_MCTL_TSTOP_OK(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_TSTOP_OK_SHIFT)) & TRNG_MCTL_TSTOP_OK_MASK)
#define TRNG_MCTL_PRGM_MASK                      (0x10000U)
#define TRNG_MCTL_PRGM_SHIFT                     (16U)
#define TRNG_MCTL_PRGM(x)                        (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_PRGM_SHIFT)) & TRNG_MCTL_PRGM_MASK)
/*! @} */

/*! @name SCMISC - Statistical Check Miscellaneous Register */
/*! @{ */
#define TRNG_SCMISC_LRUN_MAX_MASK                (0xFFU)
#define TRNG_SCMISC_LRUN_MAX_SHIFT               (0U)
#define TRNG_SCMISC_LRUN_MAX(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCMISC_LRUN_MAX_SHIFT)) & TRNG_SCMISC_LRUN_MAX_MASK)
#define TRNG_SCMISC_RTY_CT_MASK                  (0xF0000U)
#define TRNG_SCMISC_RTY_CT_SHIFT                 (16U)
#define TRNG_SCMISC_RTY_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCMISC_RTY_CT_SHIFT)) & TRNG_SCMISC_RTY_CT_MASK)
/*! @} */

/*! @name PKRRNG - Poker Range Register */
/*! @{ */
#define TRNG_PKRRNG_PKR_RNG_MASK                 (0xFFFFU)
#define TRNG_PKRRNG_PKR_RNG_SHIFT                (0U)
#define TRNG_PKRRNG_PKR_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_PKRRNG_PKR_RNG_SHIFT)) & TRNG_PKRRNG_PKR_RNG_MASK)
/*! @} */

/*! @name PKRMAX - Poker Maximum Limit Register */
/*! @{ */
#define TRNG_PKRMAX_PKR_MAX_MASK                 (0xFFFFFFU)
#define TRNG_PKRMAX_PKR_MAX_SHIFT                (0U)
/*! PKR_MAX - Poker Maximum Limit.
 */
#define TRNG_PKRMAX_PKR_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_PKRMAX_PKR_MAX_SHIFT)) & TRNG_PKRMAX_PKR_MAX_MASK)
/*! @} */

/*! @name PKRSQ - Poker Square Calculation Result Register */
/*! @{ */
#define TRNG_PKRSQ_PKR_SQ_MASK                   (0xFFFFFFU)
#define TRNG_PKRSQ_PKR_SQ_SHIFT                  (0U)
/*! PKR_SQ - Poker Square Calculation Result.
 */
#define TRNG_PKRSQ_PKR_SQ(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_PKRSQ_PKR_SQ_SHIFT)) & TRNG_PKRSQ_PKR_SQ_MASK)
/*! @} */

/*! @name SDCTL - Seed Control Register */
/*! @{ */
#define TRNG_SDCTL_SAMP_SIZE_MASK                (0xFFFFU)
#define TRNG_SDCTL_SAMP_SIZE_SHIFT               (0U)
#define TRNG_SDCTL_SAMP_SIZE(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SDCTL_SAMP_SIZE_SHIFT)) & TRNG_SDCTL_SAMP_SIZE_MASK)
#define TRNG_SDCTL_ENT_DLY_MASK                  (0xFFFF0000U)
#define TRNG_SDCTL_ENT_DLY_SHIFT                 (16U)
#define TRNG_SDCTL_ENT_DLY(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SDCTL_ENT_DLY_SHIFT)) & TRNG_SDCTL_ENT_DLY_MASK)
/*! @} */

/*! @name SBLIM - Sparse Bit Limit Register */
/*! @{ */
#define TRNG_SBLIM_SB_LIM_MASK                   (0x3FFU)
#define TRNG_SBLIM_SB_LIM_SHIFT                  (0U)
#define TRNG_SBLIM_SB_LIM(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_SBLIM_SB_LIM_SHIFT)) & TRNG_SBLIM_SB_LIM_MASK)
/*! @} */

/*! @name TOTSAM - Total Samples Register */
/*! @{ */
#define TRNG_TOTSAM_TOT_SAM_MASK                 (0xFFFFFU)
#define TRNG_TOTSAM_TOT_SAM_SHIFT                (0U)
#define TRNG_TOTSAM_TOT_SAM(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_TOTSAM_TOT_SAM_SHIFT)) & TRNG_TOTSAM_TOT_SAM_MASK)
/*! @} */

/*! @name FRQMIN - Frequency Count Minimum Limit Register */
/*! @{ */
#define TRNG_FRQMIN_FRQ_MIN_MASK                 (0x3FFFFFU)
#define TRNG_FRQMIN_FRQ_MIN_SHIFT                (0U)
#define TRNG_FRQMIN_FRQ_MIN(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_FRQMIN_FRQ_MIN_SHIFT)) & TRNG_FRQMIN_FRQ_MIN_MASK)
/*! @} */

/*! @name FRQCNT - Frequency Count Register */
/*! @{ */
#define TRNG_FRQCNT_FRQ_CT_MASK                  (0x3FFFFFU)
#define TRNG_FRQCNT_FRQ_CT_SHIFT                 (0U)
#define TRNG_FRQCNT_FRQ_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_FRQCNT_FRQ_CT_SHIFT)) & TRNG_FRQCNT_FRQ_CT_MASK)
/*! @} */

/*! @name FRQMAX - Frequency Count Maximum Limit Register */
/*! @{ */
#define TRNG_FRQMAX_FRQ_MAX_MASK                 (0x3FFFFFU)
#define TRNG_FRQMAX_FRQ_MAX_SHIFT                (0U)
#define TRNG_FRQMAX_FRQ_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_FRQMAX_FRQ_MAX_SHIFT)) & TRNG_FRQMAX_FRQ_MAX_MASK)
/*! @} */

/*! @name SCMC - Statistical Check Monobit Count Register */
/*! @{ */
#define TRNG_SCMC_MONO_CT_MASK                   (0xFFFFU)
#define TRNG_SCMC_MONO_CT_SHIFT                  (0U)
#define TRNG_SCMC_MONO_CT(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_SCMC_MONO_CT_SHIFT)) & TRNG_SCMC_MONO_CT_MASK)
/*! @} */

/*! @name SCML - Statistical Check Monobit Limit Register */
/*! @{ */
#define TRNG_SCML_MONO_MAX_MASK                  (0xFFFFU)
#define TRNG_SCML_MONO_MAX_SHIFT                 (0U)
#define TRNG_SCML_MONO_MAX(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCML_MONO_MAX_SHIFT)) & TRNG_SCML_MONO_MAX_MASK)
#define TRNG_SCML_MONO_RNG_MASK                  (0xFFFF0000U)
#define TRNG_SCML_MONO_RNG_SHIFT                 (16U)
#define TRNG_SCML_MONO_RNG(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCML_MONO_RNG_SHIFT)) & TRNG_SCML_MONO_RNG_MASK)
/*! @} */

/*! @name SCR1C - Statistical Check Run Length 1 Count Register */
/*! @{ */
#define TRNG_SCR1C_R1_0_CT_MASK                  (0x7FFFU)
#define TRNG_SCR1C_R1_0_CT_SHIFT                 (0U)
#define TRNG_SCR1C_R1_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1C_R1_0_CT_SHIFT)) & TRNG_SCR1C_R1_0_CT_MASK)
#define TRNG_SCR1C_R1_1_CT_MASK                  (0x7FFF0000U)
#define TRNG_SCR1C_R1_1_CT_SHIFT                 (16U)
#define TRNG_SCR1C_R1_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1C_R1_1_CT_SHIFT)) & TRNG_SCR1C_R1_1_CT_MASK)
/*! @} */

/*! @name SCR1L - Statistical Check Run Length 1 Limit Register */
/*! @{ */
#define TRNG_SCR1L_RUN1_MAX_MASK                 (0x7FFFU)
#define TRNG_SCR1L_RUN1_MAX_SHIFT                (0U)
#define TRNG_SCR1L_RUN1_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1L_RUN1_MAX_SHIFT)) & TRNG_SCR1L_RUN1_MAX_MASK)
#define TRNG_SCR1L_RUN1_RNG_MASK                 (0x7FFF0000U)
#define TRNG_SCR1L_RUN1_RNG_SHIFT                (16U)
#define TRNG_SCR1L_RUN1_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1L_RUN1_RNG_SHIFT)) & TRNG_SCR1L_RUN1_RNG_MASK)
/*! @} */

/*! @name SCR2C - Statistical Check Run Length 2 Count Register */
/*! @{ */
#define TRNG_SCR2C_R2_0_CT_MASK                  (0x3FFFU)
#define TRNG_SCR2C_R2_0_CT_SHIFT                 (0U)
#define TRNG_SCR2C_R2_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2C_R2_0_CT_SHIFT)) & TRNG_SCR2C_R2_0_CT_MASK)
#define TRNG_SCR2C_R2_1_CT_MASK                  (0x3FFF0000U)
#define TRNG_SCR2C_R2_1_CT_SHIFT                 (16U)
#define TRNG_SCR2C_R2_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2C_R2_1_CT_SHIFT)) & TRNG_SCR2C_R2_1_CT_MASK)
/*! @} */

/*! @name SCR2L - Statistical Check Run Length 2 Limit Register */
/*! @{ */
#define TRNG_SCR2L_RUN2_MAX_MASK                 (0x3FFFU)
#define TRNG_SCR2L_RUN2_MAX_SHIFT                (0U)
#define TRNG_SCR2L_RUN2_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2L_RUN2_MAX_SHIFT)) & TRNG_SCR2L_RUN2_MAX_MASK)
#define TRNG_SCR2L_RUN2_RNG_MASK                 (0x3FFF0000U)
#define TRNG_SCR2L_RUN2_RNG_SHIFT                (16U)
#define TRNG_SCR2L_RUN2_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2L_RUN2_RNG_SHIFT)) & TRNG_SCR2L_RUN2_RNG_MASK)
/*! @} */

/*! @name SCR3C - Statistical Check Run Length 3 Count Register */
/*! @{ */
#define TRNG_SCR3C_R3_0_CT_MASK                  (0x1FFFU)
#define TRNG_SCR3C_R3_0_CT_SHIFT                 (0U)
#define TRNG_SCR3C_R3_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3C_R3_0_CT_SHIFT)) & TRNG_SCR3C_R3_0_CT_MASK)
#define TRNG_SCR3C_R3_1_CT_MASK                  (0x1FFF0000U)
#define TRNG_SCR3C_R3_1_CT_SHIFT                 (16U)
#define TRNG_SCR3C_R3_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3C_R3_1_CT_SHIFT)) & TRNG_SCR3C_R3_1_CT_MASK)
/*! @} */

/*! @name SCR3L - Statistical Check Run Length 3 Limit Register */
/*! @{ */
#define TRNG_SCR3L_RUN3_MAX_MASK                 (0x1FFFU)
#define TRNG_SCR3L_RUN3_MAX_SHIFT                (0U)
#define TRNG_SCR3L_RUN3_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3L_RUN3_MAX_SHIFT)) & TRNG_SCR3L_RUN3_MAX_MASK)
#define TRNG_SCR3L_RUN3_RNG_MASK                 (0x1FFF0000U)
#define TRNG_SCR3L_RUN3_RNG_SHIFT                (16U)
#define TRNG_SCR3L_RUN3_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3L_RUN3_RNG_SHIFT)) & TRNG_SCR3L_RUN3_RNG_MASK)
/*! @} */

/*! @name SCR4C - Statistical Check Run Length 4 Count Register */
/*! @{ */
#define TRNG_SCR4C_R4_0_CT_MASK                  (0xFFFU)
#define TRNG_SCR4C_R4_0_CT_SHIFT                 (0U)
#define TRNG_SCR4C_R4_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4C_R4_0_CT_SHIFT)) & TRNG_SCR4C_R4_0_CT_MASK)
#define TRNG_SCR4C_R4_1_CT_MASK                  (0xFFF0000U)
#define TRNG_SCR4C_R4_1_CT_SHIFT                 (16U)
#define TRNG_SCR4C_R4_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4C_R4_1_CT_SHIFT)) & TRNG_SCR4C_R4_1_CT_MASK)
/*! @} */

/*! @name SCR4L - Statistical Check Run Length 4 Limit Register */
/*! @{ */
#define TRNG_SCR4L_RUN4_MAX_MASK                 (0xFFFU)
#define TRNG_SCR4L_RUN4_MAX_SHIFT                (0U)
#define TRNG_SCR4L_RUN4_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4L_RUN4_MAX_SHIFT)) & TRNG_SCR4L_RUN4_MAX_MASK)
#define TRNG_SCR4L_RUN4_RNG_MASK                 (0xFFF0000U)
#define TRNG_SCR4L_RUN4_RNG_SHIFT                (16U)
#define TRNG_SCR4L_RUN4_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4L_RUN4_RNG_SHIFT)) & TRNG_SCR4L_RUN4_RNG_MASK)
/*! @} */

/*! @name SCR5C - Statistical Check Run Length 5 Count Register */
/*! @{ */
#define TRNG_SCR5C_R5_0_CT_MASK                  (0x7FFU)
#define TRNG_SCR5C_R5_0_CT_SHIFT                 (0U)
#define TRNG_SCR5C_R5_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5C_R5_0_CT_SHIFT)) & TRNG_SCR5C_R5_0_CT_MASK)
#define TRNG_SCR5C_R5_1_CT_MASK                  (0x7FF0000U)
#define TRNG_SCR5C_R5_1_CT_SHIFT                 (16U)
#define TRNG_SCR5C_R5_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5C_R5_1_CT_SHIFT)) & TRNG_SCR5C_R5_1_CT_MASK)
/*! @} */

/*! @name SCR5L - Statistical Check Run Length 5 Limit Register */
/*! @{ */
#define TRNG_SCR5L_RUN5_MAX_MASK                 (0x7FFU)
#define TRNG_SCR5L_RUN5_MAX_SHIFT                (0U)
#define TRNG_SCR5L_RUN5_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5L_RUN5_MAX_SHIFT)) & TRNG_SCR5L_RUN5_MAX_MASK)
#define TRNG_SCR5L_RUN5_RNG_MASK                 (0x7FF0000U)
#define TRNG_SCR5L_RUN5_RNG_SHIFT                (16U)
#define TRNG_SCR5L_RUN5_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5L_RUN5_RNG_SHIFT)) & TRNG_SCR5L_RUN5_RNG_MASK)
/*! @} */

/*! @name SCR6PC - Statistical Check Run Length 6+ Count Register */
/*! @{ */
#define TRNG_SCR6PC_R6P_0_CT_MASK                (0x7FFU)
#define TRNG_SCR6PC_R6P_0_CT_SHIFT               (0U)
#define TRNG_SCR6PC_R6P_0_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PC_R6P_0_CT_SHIFT)) & TRNG_SCR6PC_R6P_0_CT_MASK)
#define TRNG_SCR6PC_R6P_1_CT_MASK                (0x7FF0000U)
#define TRNG_SCR6PC_R6P_1_CT_SHIFT               (16U)
#define TRNG_SCR6PC_R6P_1_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PC_R6P_1_CT_SHIFT)) & TRNG_SCR6PC_R6P_1_CT_MASK)
/*! @} */

/*! @name SCR6PL - Statistical Check Run Length 6+ Limit Register */
/*! @{ */
#define TRNG_SCR6PL_RUN6P_MAX_MASK               (0x7FFU)
#define TRNG_SCR6PL_RUN6P_MAX_SHIFT              (0U)
#define TRNG_SCR6PL_RUN6P_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PL_RUN6P_MAX_SHIFT)) & TRNG_SCR6PL_RUN6P_MAX_MASK)
#define TRNG_SCR6PL_RUN6P_RNG_MASK               (0x7FF0000U)
#define TRNG_SCR6PL_RUN6P_RNG_SHIFT              (16U)
#define TRNG_SCR6PL_RUN6P_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PL_RUN6P_RNG_SHIFT)) & TRNG_SCR6PL_RUN6P_RNG_MASK)
/*! @} */

/*! @name STATUS - Status Register */
/*! @{ */
#define TRNG_STATUS_TF1BR0_MASK                  (0x1U)
#define TRNG_STATUS_TF1BR0_SHIFT                 (0U)
#define TRNG_STATUS_TF1BR0(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF1BR0_SHIFT)) & TRNG_STATUS_TF1BR0_MASK)
#define TRNG_STATUS_TF1BR1_MASK                  (0x2U)
#define TRNG_STATUS_TF1BR1_SHIFT                 (1U)
#define TRNG_STATUS_TF1BR1(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF1BR1_SHIFT)) & TRNG_STATUS_TF1BR1_MASK)
#define TRNG_STATUS_TF2BR0_MASK                  (0x4U)
#define TRNG_STATUS_TF2BR0_SHIFT                 (2U)
#define TRNG_STATUS_TF2BR0(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF2BR0_SHIFT)) & TRNG_STATUS_TF2BR0_MASK)
#define TRNG_STATUS_TF2BR1_MASK                  (0x8U)
#define TRNG_STATUS_TF2BR1_SHIFT                 (3U)
#define TRNG_STATUS_TF2BR1(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF2BR1_SHIFT)) & TRNG_STATUS_TF2BR1_MASK)
#define TRNG_STATUS_TF3BR0_MASK                  (0x10U)
#define TRNG_STATUS_TF3BR0_SHIFT                 (4U)
#define TRNG_STATUS_TF3BR0(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF3BR0_SHIFT)) & TRNG_STATUS_TF3BR0_MASK)
#define TRNG_STATUS_TF3BR1_MASK                  (0x20U)
#define TRNG_STATUS_TF3BR1_SHIFT                 (5U)
#define TRNG_STATUS_TF3BR1(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF3BR1_SHIFT)) & TRNG_STATUS_TF3BR1_MASK)
#define TRNG_STATUS_TF4BR0_MASK                  (0x40U)
#define TRNG_STATUS_TF4BR0_SHIFT                 (6U)
#define TRNG_STATUS_TF4BR0(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF4BR0_SHIFT)) & TRNG_STATUS_TF4BR0_MASK)
#define TRNG_STATUS_TF4BR1_MASK                  (0x80U)
#define TRNG_STATUS_TF4BR1_SHIFT                 (7U)
#define TRNG_STATUS_TF4BR1(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF4BR1_SHIFT)) & TRNG_STATUS_TF4BR1_MASK)
#define TRNG_STATUS_TF5BR0_MASK                  (0x100U)
#define TRNG_STATUS_TF5BR0_SHIFT                 (8U)
#define TRNG_STATUS_TF5BR0(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF5BR0_SHIFT)) & TRNG_STATUS_TF5BR0_MASK)
#define TRNG_STATUS_TF5BR1_MASK                  (0x200U)
#define TRNG_STATUS_TF5BR1_SHIFT                 (9U)
#define TRNG_STATUS_TF5BR1(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF5BR1_SHIFT)) & TRNG_STATUS_TF5BR1_MASK)
#define TRNG_STATUS_TF6PBR0_MASK                 (0x400U)
#define TRNG_STATUS_TF6PBR0_SHIFT                (10U)
#define TRNG_STATUS_TF6PBR0(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF6PBR0_SHIFT)) & TRNG_STATUS_TF6PBR0_MASK)
#define TRNG_STATUS_TF6PBR1_MASK                 (0x800U)
#define TRNG_STATUS_TF6PBR1_SHIFT                (11U)
#define TRNG_STATUS_TF6PBR1(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TF6PBR1_SHIFT)) & TRNG_STATUS_TF6PBR1_MASK)
#define TRNG_STATUS_TFSB_MASK                    (0x1000U)
#define TRNG_STATUS_TFSB_SHIFT                   (12U)
#define TRNG_STATUS_TFSB(x)                      (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TFSB_SHIFT)) & TRNG_STATUS_TFSB_MASK)
#define TRNG_STATUS_TFLR_MASK                    (0x2000U)
#define TRNG_STATUS_TFLR_SHIFT                   (13U)
#define TRNG_STATUS_TFLR(x)                      (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TFLR_SHIFT)) & TRNG_STATUS_TFLR_MASK)
#define TRNG_STATUS_TFP_MASK                     (0x4000U)
#define TRNG_STATUS_TFP_SHIFT                    (14U)
#define TRNG_STATUS_TFP(x)                       (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TFP_SHIFT)) & TRNG_STATUS_TFP_MASK)
#define TRNG_STATUS_TFMB_MASK                    (0x8000U)
#define TRNG_STATUS_TFMB_SHIFT                   (15U)
#define TRNG_STATUS_TFMB(x)                      (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_TFMB_SHIFT)) & TRNG_STATUS_TFMB_MASK)
#define TRNG_STATUS_RETRY_CT_MASK                (0xF0000U)
#define TRNG_STATUS_RETRY_CT_SHIFT               (16U)
#define TRNG_STATUS_RETRY_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_RETRY_CT_SHIFT)) & TRNG_STATUS_RETRY_CT_MASK)
/*! @} */

/*! @name ENT - Entropy Read Register */
/*! @{ */
#define TRNG_ENT_ENT_MASK                        (0xFFFFFFFFU)
#define TRNG_ENT_ENT_SHIFT                       (0U)
#define TRNG_ENT_ENT(x)                          (((uint32_t)(((uint32_t)(x)) << TRNG_ENT_ENT_SHIFT)) & TRNG_ENT_ENT_MASK)
/*! @} */

/* The count of TRNG_ENT */
#define TRNG_ENT_COUNT                           (16U)

/*! @name PKRCNT10 - Statistical Check Poker Count 1 and 0 Register */
/*! @{ */
#define TRNG_PKRCNT10_PKR_0_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT10_PKR_0_CT_SHIFT             (0U)
#define TRNG_PKRCNT10_PKR_0_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT10_PKR_0_CT_SHIFT)) & TRNG_PKRCNT10_PKR_0_CT_MASK)
#define TRNG_PKRCNT10_PKR_1_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT10_PKR_1_CT_SHIFT             (16U)
#define TRNG_PKRCNT10_PKR_1_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT10_PKR_1_CT_SHIFT)) & TRNG_PKRCNT10_PKR_1_CT_MASK)
/*! @} */

/*! @name PKRCNT32 - Statistical Check Poker Count 3 and 2 Register */
/*! @{ */
#define TRNG_PKRCNT32_PKR_2_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT32_PKR_2_CT_SHIFT             (0U)
#define TRNG_PKRCNT32_PKR_2_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT32_PKR_2_CT_SHIFT)) & TRNG_PKRCNT32_PKR_2_CT_MASK)
#define TRNG_PKRCNT32_PKR_3_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT32_PKR_3_CT_SHIFT             (16U)
#define TRNG_PKRCNT32_PKR_3_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT32_PKR_3_CT_SHIFT)) & TRNG_PKRCNT32_PKR_3_CT_MASK)
/*! @} */

/*! @name PKRCNT54 - Statistical Check Poker Count 5 and 4 Register */
/*! @{ */
#define TRNG_PKRCNT54_PKR_4_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT54_PKR_4_CT_SHIFT             (0U)
#define TRNG_PKRCNT54_PKR_4_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT54_PKR_4_CT_SHIFT)) & TRNG_PKRCNT54_PKR_4_CT_MASK)
#define TRNG_PKRCNT54_PKR_5_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT54_PKR_5_CT_SHIFT             (16U)
#define TRNG_PKRCNT54_PKR_5_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT54_PKR_5_CT_SHIFT)) & TRNG_PKRCNT54_PKR_5_CT_MASK)
/*! @} */

/*! @name PKRCNT76 - Statistical Check Poker Count 7 and 6 Register */
/*! @{ */
#define TRNG_PKRCNT76_PKR_6_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT76_PKR_6_CT_SHIFT             (0U)
#define TRNG_PKRCNT76_PKR_6_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT76_PKR_6_CT_SHIFT)) & TRNG_PKRCNT76_PKR_6_CT_MASK)
#define TRNG_PKRCNT76_PKR_7_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT76_PKR_7_CT_SHIFT             (16U)
#define TRNG_PKRCNT76_PKR_7_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT76_PKR_7_CT_SHIFT)) & TRNG_PKRCNT76_PKR_7_CT_MASK)
/*! @} */

/*! @name PKRCNT98 - Statistical Check Poker Count 9 and 8 Register */
/*! @{ */
#define TRNG_PKRCNT98_PKR_8_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT98_PKR_8_CT_SHIFT             (0U)
#define TRNG_PKRCNT98_PKR_8_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT98_PKR_8_CT_SHIFT)) & TRNG_PKRCNT98_PKR_8_CT_MASK)
#define TRNG_PKRCNT98_PKR_9_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT98_PKR_9_CT_SHIFT             (16U)
#define TRNG_PKRCNT98_PKR_9_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT98_PKR_9_CT_SHIFT)) & TRNG_PKRCNT98_PKR_9_CT_MASK)
/*! @} */

/*! @name PKRCNTBA - Statistical Check Poker Count B and A Register */
/*! @{ */
#define TRNG_PKRCNTBA_PKR_A_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTBA_PKR_A_CT_SHIFT             (0U)
#define TRNG_PKRCNTBA_PKR_A_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTBA_PKR_A_CT_SHIFT)) & TRNG_PKRCNTBA_PKR_A_CT_MASK)
#define TRNG_PKRCNTBA_PKR_B_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTBA_PKR_B_CT_SHIFT             (16U)
#define TRNG_PKRCNTBA_PKR_B_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTBA_PKR_B_CT_SHIFT)) & TRNG_PKRCNTBA_PKR_B_CT_MASK)
/*! @} */

/*! @name PKRCNTDC - Statistical Check Poker Count D and C Register */
/*! @{ */
#define TRNG_PKRCNTDC_PKR_C_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTDC_PKR_C_CT_SHIFT             (0U)
#define TRNG_PKRCNTDC_PKR_C_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTDC_PKR_C_CT_SHIFT)) & TRNG_PKRCNTDC_PKR_C_CT_MASK)
#define TRNG_PKRCNTDC_PKR_D_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTDC_PKR_D_CT_SHIFT             (16U)
#define TRNG_PKRCNTDC_PKR_D_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTDC_PKR_D_CT_SHIFT)) & TRNG_PKRCNTDC_PKR_D_CT_MASK)
/*! @} */

/*! @name PKRCNTFE - Statistical Check Poker Count F and E Register */
/*! @{ */
#define TRNG_PKRCNTFE_PKR_E_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTFE_PKR_E_CT_SHIFT             (0U)
#define TRNG_PKRCNTFE_PKR_E_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTFE_PKR_E_CT_SHIFT)) & TRNG_PKRCNTFE_PKR_E_CT_MASK)
#define TRNG_PKRCNTFE_PKR_F_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTFE_PKR_F_CT_SHIFT             (16U)
#define TRNG_PKRCNTFE_PKR_F_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTFE_PKR_F_CT_SHIFT)) & TRNG_PKRCNTFE_PKR_F_CT_MASK)
/*! @} */

/*! @name SEC_CFG - Security Configuration Register */
/*! @{ */
#define TRNG_SEC_CFG_SH0_MASK                    (0x1U)
#define TRNG_SEC_CFG_SH0_SHIFT                   (0U)
/*! SH0
 *  0b0..See DRNG version.
 *  0b1..See DRNG version.
 */
#define TRNG_SEC_CFG_SH0(x)                      (((uint32_t)(((uint32_t)(x)) << TRNG_SEC_CFG_SH0_SHIFT)) & TRNG_SEC_CFG_SH0_MASK)
#define TRNG_SEC_CFG_NO_PRGM_MASK                (0x2U)
#define TRNG_SEC_CFG_NO_PRGM_SHIFT               (1U)
/*! NO_PRGM
 *  0b0..Programability of registers controlled only by the Miscellaneous Control Register's access mode bit.
 *  0b1..Overides Miscellaneous Control Register access mode and prevents TRNG register programming.
 */
#define TRNG_SEC_CFG_NO_PRGM(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SEC_CFG_NO_PRGM_SHIFT)) & TRNG_SEC_CFG_NO_PRGM_MASK)
#define TRNG_SEC_CFG_SK_VAL_MASK                 (0x4U)
#define TRNG_SEC_CFG_SK_VAL_SHIFT                (2U)
/*! SK_VAL
 *  0b0..See DRNG version.
 *  0b1..See DRNG version.
 */
#define TRNG_SEC_CFG_SK_VAL(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SEC_CFG_SK_VAL_SHIFT)) & TRNG_SEC_CFG_SK_VAL_MASK)
/*! @} */

/*! @name INT_CTRL - Interrupt Control Register */
/*! @{ */
#define TRNG_INT_CTRL_HW_ERR_MASK                (0x1U)
#define TRNG_INT_CTRL_HW_ERR_SHIFT               (0U)
/*! HW_ERR
 *  0b0..Corresponding bit of INT_STATUS cleared.
 *  0b1..Corresponding bit of INT_STATUS active.
 */
#define TRNG_INT_CTRL_HW_ERR(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_INT_CTRL_HW_ERR_SHIFT)) & TRNG_INT_CTRL_HW_ERR_MASK)
#define TRNG_INT_CTRL_ENT_VAL_MASK               (0x2U)
#define TRNG_INT_CTRL_ENT_VAL_SHIFT              (1U)
/*! ENT_VAL
 *  0b0..Same behavior as bit 0 above.
 *  0b1..Same behavior as bit 0 above.
 */
#define TRNG_INT_CTRL_ENT_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_INT_CTRL_ENT_VAL_SHIFT)) & TRNG_INT_CTRL_ENT_VAL_MASK)
#define TRNG_INT_CTRL_FRQ_CT_FAIL_MASK           (0x4U)
#define TRNG_INT_CTRL_FRQ_CT_FAIL_SHIFT          (2U)
/*! FRQ_CT_FAIL
 *  0b0..Same behavior as bit 0 above.
 *  0b1..Same behavior as bit 0 above.
 */
#define TRNG_INT_CTRL_FRQ_CT_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << TRNG_INT_CTRL_FRQ_CT_FAIL_SHIFT)) & TRNG_INT_CTRL_FRQ_CT_FAIL_MASK)
#define TRNG_INT_CTRL_UNUSED_MASK                (0xFFFFFFF8U)
#define TRNG_INT_CTRL_UNUSED_SHIFT               (3U)
#define TRNG_INT_CTRL_UNUSED(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_INT_CTRL_UNUSED_SHIFT)) & TRNG_INT_CTRL_UNUSED_MASK)
/*! @} */

/*! @name INT_MASK - Mask Register */
/*! @{ */
#define TRNG_INT_MASK_HW_ERR_MASK                (0x1U)
#define TRNG_INT_MASK_HW_ERR_SHIFT               (0U)
/*! HW_ERR
 *  0b0..Corresponding interrupt of INT_STATUS is masked.
 *  0b1..Corresponding bit of INT_STATUS is active.
 */
#define TRNG_INT_MASK_HW_ERR(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_INT_MASK_HW_ERR_SHIFT)) & TRNG_INT_MASK_HW_ERR_MASK)
#define TRNG_INT_MASK_ENT_VAL_MASK               (0x2U)
#define TRNG_INT_MASK_ENT_VAL_SHIFT              (1U)
/*! ENT_VAL
 *  0b0..Same behavior as bit 0 above.
 *  0b1..Same behavior as bit 0 above.
 */
#define TRNG_INT_MASK_ENT_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_INT_MASK_ENT_VAL_SHIFT)) & TRNG_INT_MASK_ENT_VAL_MASK)
#define TRNG_INT_MASK_FRQ_CT_FAIL_MASK           (0x4U)
#define TRNG_INT_MASK_FRQ_CT_FAIL_SHIFT          (2U)
/*! FRQ_CT_FAIL
 *  0b0..Same behavior as bit 0 above.
 *  0b1..Same behavior as bit 0 above.
 */
#define TRNG_INT_MASK_FRQ_CT_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << TRNG_INT_MASK_FRQ_CT_FAIL_SHIFT)) & TRNG_INT_MASK_FRQ_CT_FAIL_MASK)
/*! @} */

/*! @name INT_STATUS - Interrupt Status Register */
/*! @{ */
#define TRNG_INT_STATUS_HW_ERR_MASK              (0x1U)
#define TRNG_INT_STATUS_HW_ERR_SHIFT             (0U)
/*! HW_ERR
 *  0b0..no error
 *  0b1..error detected.
 */
#define TRNG_INT_STATUS_HW_ERR(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_INT_STATUS_HW_ERR_SHIFT)) & TRNG_INT_STATUS_HW_ERR_MASK)
#define TRNG_INT_STATUS_ENT_VAL_MASK             (0x2U)
#define TRNG_INT_STATUS_ENT_VAL_SHIFT            (1U)
/*! ENT_VAL
 *  0b0..Busy generation entropy. Any value read is invalid.
 *  0b1..TRNG can be stopped and entropy is valid if read.
 */
#define TRNG_INT_STATUS_ENT_VAL(x)               (((uint32_t)(((uint32_t)(x)) << TRNG_INT_STATUS_ENT_VAL_SHIFT)) & TRNG_INT_STATUS_ENT_VAL_MASK)
#define TRNG_INT_STATUS_FRQ_CT_FAIL_MASK         (0x4U)
#define TRNG_INT_STATUS_FRQ_CT_FAIL_SHIFT        (2U)
/*! FRQ_CT_FAIL
 *  0b0..No hardware nor self test frequency errors.
 *  0b1..The frequency counter has detected a failure.
 */
#define TRNG_INT_STATUS_FRQ_CT_FAIL(x)           (((uint32_t)(((uint32_t)(x)) << TRNG_INT_STATUS_FRQ_CT_FAIL_SHIFT)) & TRNG_INT_STATUS_FRQ_CT_FAIL_MASK)
/*! @} */

/*! @name VID1 - Version ID Register (MS) */
/*! @{ */
#define TRNG_VID1_MIN_REV_MASK                   (0xFFU)
#define TRNG_VID1_MIN_REV_SHIFT                  (0U)
/*! MIN_REV
 *  0b00000000..Minor revision number for TRNG.
 */
#define TRNG_VID1_MIN_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_MIN_REV_SHIFT)) & TRNG_VID1_MIN_REV_MASK)
#define TRNG_VID1_MAJ_REV_MASK                   (0xFF00U)
#define TRNG_VID1_MAJ_REV_SHIFT                  (8U)
/*! MAJ_REV
 *  0b00000001..Major revision number for TRNG.
 */
#define TRNG_VID1_MAJ_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_MAJ_REV_SHIFT)) & TRNG_VID1_MAJ_REV_MASK)
#define TRNG_VID1_IP_ID_MASK                     (0xFFFF0000U)
#define TRNG_VID1_IP_ID_SHIFT                    (16U)
/*! IP_ID
 *  0b0000000000110000..ID for TRNG.
 */
#define TRNG_VID1_IP_ID(x)                       (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_IP_ID_SHIFT)) & TRNG_VID1_IP_ID_MASK)
/*! @} */

/*! @name VID2 - Version ID Register (LS) */
/*! @{ */
#define TRNG_VID2_CONFIG_OPT_MASK                (0xFFU)
#define TRNG_VID2_CONFIG_OPT_SHIFT               (0U)
/*! CONFIG_OPT
 *  0b00000000..TRNG_CONFIG_OPT for TRNG.
 */
#define TRNG_VID2_CONFIG_OPT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_CONFIG_OPT_SHIFT)) & TRNG_VID2_CONFIG_OPT_MASK)
#define TRNG_VID2_ECO_REV_MASK                   (0xFF00U)
#define TRNG_VID2_ECO_REV_SHIFT                  (8U)
/*! ECO_REV
 *  0b00000000..TRNG_ECO_REV for TRNG.
 */
#define TRNG_VID2_ECO_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_ECO_REV_SHIFT)) & TRNG_VID2_ECO_REV_MASK)
#define TRNG_VID2_INTG_OPT_MASK                  (0xFF0000U)
#define TRNG_VID2_INTG_OPT_SHIFT                 (16U)
/*! INTG_OPT
 *  0b00000000..INTG_OPT for TRNG.
 */
#define TRNG_VID2_INTG_OPT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_INTG_OPT_SHIFT)) & TRNG_VID2_INTG_OPT_MASK)
#define TRNG_VID2_ERA_MASK                       (0xFF000000U)
#define TRNG_VID2_ERA_SHIFT                      (24U)
/*! ERA
 *  0b00000000..COMPILE_OPT for TRNG.
 */
#define TRNG_VID2_ERA(x)                         (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_ERA_SHIFT)) & TRNG_VID2_ERA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group TRNG_Register_Masks */


/* TRNG - Peripheral instance base addresses */
/** Peripheral TRNG0 base address */
#define TRNG0_BASE                               (0x40029000u)
/** Peripheral TRNG0 base pointer */
#define TRNG0                                    ((TRNG_Type *)TRNG0_BASE)
/** Array initializer of TRNG peripheral base addresses */
#define TRNG_BASE_ADDRS                          { TRNG0_BASE }
/** Array initializer of TRNG peripheral base pointers */
#define TRNG_BASE_PTRS                           { TRNG0 }
/** Interrupt vectors for the TRNG peripheral type */
#define TRNG_IRQS                                { TRNG0_IRQn }


/*!
 * @}
 */ /* end of group TRNG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TX_PACKET_RAM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TX_PACKET_RAM_Peripheral_Access_Layer TX_PACKET_RAM Peripheral Access Layer
 * @{
 */

/** TX_PACKET_RAM - Register Layout Typedef */
typedef struct {
  __IO uint32_t PACKET_RAM[2560];                  /**< Shared Packet RAM for multiple Link Layer usage., array offset: 0x0, array step: 0x4 */
} TX_PACKET_RAM_Type;

/* ----------------------------------------------------------------------------
   -- TX_PACKET_RAM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TX_PACKET_RAM_Register_Masks TX_PACKET_RAM Register Masks
 * @{
 */

/*! @name PACKET_RAM - Shared Packet RAM for multiple Link Layer usage. */
/*! @{ */
#define TX_PACKET_RAM_PACKET_RAM_RAM_MASK        (0xFFFFFFFFU)
#define TX_PACKET_RAM_PACKET_RAM_RAM_SHIFT       (0U)
/*! RAM - One entry in the packet RAM
 */
#define TX_PACKET_RAM_PACKET_RAM_RAM(x)          (((uint32_t)(((uint32_t)(x)) << TX_PACKET_RAM_PACKET_RAM_RAM_SHIFT)) & TX_PACKET_RAM_PACKET_RAM_RAM_MASK)
/*! @} */

/* The count of TX_PACKET_RAM_PACKET_RAM */
#define TX_PACKET_RAM_PACKET_RAM_COUNT           (2560U)


/*!
 * @}
 */ /* end of group TX_PACKET_RAM_Register_Masks */


/* TX_PACKET_RAM - Peripheral instance base addresses */
/** Peripheral TX_PACKET_RAM base address */
#define TX_PACKET_RAM_BASE                       (0x40088000u)
/** Peripheral TX_PACKET_RAM base pointer */
#define TX_PACKET_RAM                            ((TX_PACKET_RAM_Type *)TX_PACKET_RAM_BASE)
/** Array initializer of TX_PACKET_RAM peripheral base addresses */
#define TX_PACKET_RAM_BASE_ADDRS                 { TX_PACKET_RAM_BASE }
/** Array initializer of TX_PACKET_RAM peripheral base pointers */
#define TX_PACKET_RAM_BASE_PTRS                  { TX_PACKET_RAM }

/*!
 * @}
 */ /* end of group TX_PACKET_RAM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- VREF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Peripheral_Access_Layer VREF Peripheral Access Layer
 * @{
 */

/** VREF - Register Layout Typedef */
typedef struct {
  __IO uint8_t TRM;                                /**< VREF Trim Register, offset: 0x0 */
  __IO uint8_t SC;                                 /**< VREF Status and Control Register, offset: 0x1 */
} VREF_Type;

/* ----------------------------------------------------------------------------
   -- VREF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Register_Masks VREF Register Masks
 * @{
 */

/*! @name TRM - VREF Trim Register */
/*! @{ */
#define VREF_TRM_TRIM_MASK                       (0x3FU)
#define VREF_TRM_TRIM_SHIFT                      (0U)
/*! TRIM - Trim bits
 *  0b000000..Min
 *  0b111111..Max
 */
#define VREF_TRM_TRIM(x)                         (((uint8_t)(((uint8_t)(x)) << VREF_TRM_TRIM_SHIFT)) & VREF_TRM_TRIM_MASK)
#define VREF_TRM_CHOPEN_MASK                     (0x40U)
#define VREF_TRM_CHOPEN_SHIFT                    (6U)
/*! CHOPEN - Chop oscillator enable. When set, internal chopping operation is enabled and the
 *    internal analog offset will be minimized.
 *  0b0..Chop oscillator is disabled.
 *  0b1..Chop oscillator is enabled.
 */
#define VREF_TRM_CHOPEN(x)                       (((uint8_t)(((uint8_t)(x)) << VREF_TRM_CHOPEN_SHIFT)) & VREF_TRM_CHOPEN_MASK)
/*! @} */

/*! @name SC - VREF Status and Control Register */
/*! @{ */
#define VREF_SC_MODE_LV_MASK                     (0x3U)
#define VREF_SC_MODE_LV_SHIFT                    (0U)
/*! MODE_LV - Buffer Mode selection
 *  0b00..Bandgap on only, for stabilization and startup
 *  0b01..High power buffer mode enabled
 *  0b10..Low-power buffer mode enabled
 *  0b11..Reserved
 */
#define VREF_SC_MODE_LV(x)                       (((uint8_t)(((uint8_t)(x)) << VREF_SC_MODE_LV_SHIFT)) & VREF_SC_MODE_LV_MASK)
#define VREF_SC_VREFST_MASK                      (0x4U)
#define VREF_SC_VREFST_SHIFT                     (2U)
/*! VREFST - Internal Voltage Reference stable
 *  0b0..The module is disabled or not stable.
 *  0b1..The module is stable.
 */
#define VREF_SC_VREFST(x)                        (((uint8_t)(((uint8_t)(x)) << VREF_SC_VREFST_SHIFT)) & VREF_SC_VREFST_MASK)
#define VREF_SC_ICOMPEN_MASK                     (0x20U)
#define VREF_SC_ICOMPEN_SHIFT                    (5U)
/*! ICOMPEN - Second order curvature compensation enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define VREF_SC_ICOMPEN(x)                       (((uint8_t)(((uint8_t)(x)) << VREF_SC_ICOMPEN_SHIFT)) & VREF_SC_ICOMPEN_MASK)
#define VREF_SC_REGEN_MASK                       (0x40U)
#define VREF_SC_REGEN_SHIFT                      (6U)
/*! REGEN - Regulator enable
 *  0b0..Internal 1.75 V regulator is disabled.
 *  0b1..Internal 1.75 V regulator is enabled.
 */
#define VREF_SC_REGEN(x)                         (((uint8_t)(((uint8_t)(x)) << VREF_SC_REGEN_SHIFT)) & VREF_SC_REGEN_MASK)
#define VREF_SC_VREFEN_MASK                      (0x80U)
#define VREF_SC_VREFEN_SHIFT                     (7U)
/*! VREFEN - Internal Voltage Reference enable
 *  0b0..The module is disabled.
 *  0b1..The module is enabled.
 */
#define VREF_SC_VREFEN(x)                        (((uint8_t)(((uint8_t)(x)) << VREF_SC_VREFEN_SHIFT)) & VREF_SC_VREFEN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group VREF_Register_Masks */


/* VREF - Peripheral instance base addresses */
/** Peripheral VREF base address */
#define VREF_BASE                                (0x40074000u)
/** Peripheral VREF base pointer */
#define VREF                                     ((VREF_Type *)VREF_BASE)
/** Array initializer of VREF peripheral base addresses */
#define VREF_BASE_ADDRS                          { VREF_BASE }
/** Array initializer of VREF peripheral base pointers */
#define VREF_BASE_PTRS                           { VREF }

/*!
 * @}
 */ /* end of group VREF_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- XCVR_2P4GHZ_PHY Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_2P4GHZ_PHY_Peripheral_Access_Layer XCVR_2P4GHZ_PHY Peripheral Access Layer
 * @{
 */

/** XCVR_2P4GHZ_PHY - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSK_PD_CFG0;                       /**< PHY Uncoded Preamble Detect Config 0, offset: 0x0 */
  __IO uint32_t FSK_PD_CFG1;                       /**< PHY Uncoded Preamble Detect Config 1, offset: 0x4 */
  __IO uint32_t FSK_PD_CFG2;                       /**< PHY Uncoded Preamble Detect Config 2, offset: 0x8 */
  __IO uint32_t FSK_PD_PH[2];                      /**< , array offset: 0xC, array step: 0x4 */
  __I  uint32_t FSK_PD_RO_PH[4];                   /**< , array offset: 0x14, array step: 0x4 */
  __IO uint32_t FSK_CFG0;                          /**< PHY Uncoded Config 0, offset: 0x24 */
  __IO uint32_t FSK_CFG1;                          /**< PHY Uncoded Config 1, offset: 0x28 */
  __IO uint32_t FSK_CFG2;                          /**< PHY Uncoded Config 2, offset: 0x2C */
  __IO uint32_t FSK_CFG3;                          /**< PHY Uncoded Config 3, offset: 0x30 */
  __IO uint32_t FSK_PT;                            /**< PHY Uncoded Power Threshold Config, offset: 0x34 */
  __IO uint32_t FSK_FAD_CTRL;                      /**< PHY Uncoded FAD Control, offset: 0x38 */
  __IO uint32_t FSK_FAD_CFG;                       /**< PHY Uncoded FAD Config, offset: 0x3C */
  __I  uint32_t FSK_STAT;                          /**< PHY Uncoded Status, offset: 0x40 */
  __IO uint32_t LR_PD_CFG;                         /**< PHY Long Range Preamble Detect Config, offset: 0x44 */
  __IO uint32_t LR_PD_PH[4];                       /**< , array offset: 0x48, array step: 0x4 */
  __I  uint32_t LR_PD_RO_PH[13];                   /**< , array offset: 0x58, array step: 0x4 */
  __IO uint32_t LR_AA_CFG;                         /**< PHY Long Range AA Config, offset: 0x8C */
  __I  uint32_t LR_STAT;                           /**< PHY Long Range Status, offset: 0x90 */
  __IO uint32_t SM_CFG;                            /**< PHY State Machine Config, offset: 0x94 */
  __IO uint32_t MISC;                              /**< PHY Misc Config, offset: 0x98 */
  __I  uint32_t STAT0;                             /**< PHY Status 0, offset: 0x9C */
  __I  uint32_t STAT1;                             /**< PHY Status 1, offset: 0xA0 */
  __I  uint32_t STAT2;                             /**< PHY Status 2, offset: 0xA4 */
  __IO uint32_t PREPHY_MISC;                       /**< PHY PrePHY Misc Config, offset: 0xA8 */
  __IO uint32_t DMD_CTRL0;                         /**< PHY Demodulator Control 0, offset: 0xAC */
  __IO uint32_t DMD_CTRL1;                         /**< PHY Dmodulator Control 1, offset: 0xB0 */
  __IO uint32_t DMD_CTRL2;                         /**< PHY Demodulator Control 2, offset: 0xB4 */
  struct {                                         /* offset: 0xB8, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG0;                     /**< , array offset: 0xB8, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG1;                     /**< , array offset: 0xBC, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG2;                     /**< , array offset: 0xC0, array step: 0xC */
  } DEMOD_WAVE[8];
} XCVR_2P4GHZ_PHY_Type;

/* ----------------------------------------------------------------------------
   -- XCVR_2P4GHZ_PHY Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_2P4GHZ_PHY_Register_Masks XCVR_2P4GHZ_PHY Register Masks
 * @{
 */

/*! @name FSK_PD_CFG0 - PHY Uncoded Preamble Detect Config 0 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_MASK (0xFU)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_SHIFT (0U)
/*! PREAMBLE_T_SCALE - Scaling factor used for fractional time estimation during preamble search.
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PD_IIR_ALPHA_MASK (0xFF00U)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PD_IIR_ALPHA_SHIFT (8U)
/*! PD_IIR_ALPHA - Forgetting factor used by the complex correlations smoothing leaky integrator.
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PD_IIR_ALPHA(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PD_IIR_ALPHA_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_CFG0_PD_IIR_ALPHA_MASK)
/*! @} */

/*! @name FSK_PD_CFG1 - PHY Uncoded Preamble Detect Config 1 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_MASK (0xFFU)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_SHIFT (0U)
/*! PREAMBLE_PATTERN - 8-bit preamble pattern used in FM-domain preamble detector.
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG1_PREAMBLE_PATTERN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_MASK)
/*! @} */

/*! @name FSK_PD_CFG2 - PHY Uncoded Preamble Detect Config 2 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_MASK (0xFFU)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_SHIFT (0U)
/*! PD_THRESH_ACQ_1_3_1M - Preamble detect threshold for acq mode 1 and 3 at data rate 1Mbps
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_MASK (0xFF0000U)
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_SHIFT (16U)
/*! PD_THRESH_ACQ_1_3_2M - Preamble detect threshold for acq mode 1 and 3 at data rate 2Mbps
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_MASK)
/*! @} */

/*! @name FSK_PD_PH -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF0_MASK      (0x3FU)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF0_SHIFT     (0U)
/*! ref0 - Uncoded preamble reference waveform sample 4 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF0(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_PH_REF0_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_PH_REF0_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF1_MASK      (0x3F00U)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF1_SHIFT     (8U)
/*! ref1 - Uncoded preamble reference waveform sample 5 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF1(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_PH_REF1_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_PH_REF1_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF2_MASK      (0x3F0000U)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF2_SHIFT     (16U)
/*! ref2 - Uncoded preamble reference waveform sample 6 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF2(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_PH_REF2_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_PH_REF2_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF3_MASK      (0x3F000000U)
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF3_SHIFT     (24U)
/*! ref3 - Uncoded preamble reference waveform sample 7 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_REF3(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_PH_REF3_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_PH_REF3_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_FSK_PD_PH */
#define XCVR_2P4GHZ_PHY_FSK_PD_PH_COUNT          (2U)

/*! @name FSK_PD_RO_PH -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF0_MASK   (0x3FU)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF0_SHIFT  (0U)
/*! ref0 - Uncoded preamble reference waveform sample 28 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF0(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF0_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF0_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF1_MASK   (0x3F00U)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF1_SHIFT  (8U)
/*! ref1 - Uncoded preamble reference waveform sample 29 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF1(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF1_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF1_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF2_MASK   (0x3F0000U)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF2_SHIFT  (16U)
/*! ref2 - Uncoded preamble reference waveform sample 30 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF2(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF2_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF2_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF3_MASK   (0x3F000000U)
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF3_SHIFT  (24U)
/*! ref3 - Uncoded preamble reference waveform sample 31 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF3(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF3_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_REF3_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_FSK_PD_RO_PH */
#define XCVR_2P4GHZ_PHY_FSK_PD_RO_PH_COUNT       (4U)

/*! @name FSK_CFG0 - PHY Uncoded Config 0 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_OUT_SEL_MASK (0x2U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_OUT_SEL_SHIFT (1U)
/*! AA_OUT_SEL - Specifies which AA bits to be played-back to the LL:
 *  0b0..output the received AA bits
 *  0b1..output the programmed AA bits
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_OUT_SEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_AA_OUT_SEL_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_AA_OUT_SEL_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_FSK_BIT_INVERT_MASK (0x4U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_FSK_BIT_INVERT_SHIFT (2U)
/*! FSK_BIT_INVERT - This applies at the demodulator, so it affects both AA and the data portions of the packet.
 *  0b0..Normal demodulation
 *  0b1..Invert demodulated bits
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_FSK_BIT_INVERT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_FSK_BIT_INVERT_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_FSK_BIT_INVERT_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_HAM_CHK_LOW_PWR_MASK (0x10U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_HAM_CHK_LOW_PWR_SHIFT (4U)
/*! HAM_CHK_LOW_PWR - Indicates whether hamming-distance check is applied at signal levels below mag_thresh_high;
 *  0b0..no
 *  0b1..yes
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_HAM_CHK_LOW_PWR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_HAM_CHK_LOW_PWR_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_HAM_CHK_LOW_PWR_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK_EN_MASK     (0x20U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK_EN_SHIFT    (5U)
/*! MSK_EN - Configures PHY for MSK decoding.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK_EN(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_MSK_EN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_MSK_EN_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK2FSK_SEED_MASK (0x40U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK2FSK_SEED_SHIFT (6U)
/*! MSK2FSK_SEED - Last bit of preamble.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_MSK2FSK_SEED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_MSK2FSK_SEED_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_MSK2FSK_SEED_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_MASK (0x1F00U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_SHIFT (8U)
/*! AA_ACQ_1_2_3_THRESH_1M - For 1Mbps data rate, Correlation threshold applicable to AA detection; uses ufix5_En5 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_BLE_NTW_ADR_THR_MASK (0x700000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_BLE_NTW_ADR_THR_SHIFT (20U)
/*! BLE_NTW_ADR_THR - Maximum hamming distance from the given AA pattern that may still be accepted as a match; valid range [0,7].
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_BLE_NTW_ADR_THR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_BLE_NTW_ADR_THR_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_BLE_NTW_ADR_THR_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_MASK (0x1F000000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_SHIFT (24U)
/*! AA_ACQ_1_2_3_THRESH_2M - For 2Mbps data rate, correlation threshold applicable to AA detection; uses ufix5_En5 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_MASK)
/*! @} */

/*! @name FSK_CFG1 - PHY Uncoded Config 1 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_MASK      (0x7FFU)
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_SHIFT     (0U)
/*! OVERH - Modulation index; represented in ufix11_En7 format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_INV_MASK  (0xFF800U)
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_INV_SHIFT (11U)
/*! OVERH_INV - Reciprocal of modulation index; represented in ufix9_En7 format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_INV(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_INV_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG1_OVERH_INV_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG1_SYNCTSCALE_MASK (0xF000000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG1_SYNCTSCALE_SHIFT (24U)
/*! SYNCTSCALE - Scaling factor used for fractional time estimation during AA search; represented in ufix4_En3 format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG1_SYNCTSCALE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG1_SYNCTSCALE_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG1_SYNCTSCALE_MASK)
/*! @} */

/*! @name FSK_CFG2 - PHY Uncoded Config 2 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_1M_MASK (0xFFFU)
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_1M_SHIFT (0U)
/*! MAG_THRESH_1M - For 1Mbps data rate, the lowest signal level below which synchronization is
 *    considered unreliable and hence disallowed; uses ufix12_En24 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_1M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_1M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_1M_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_HI_1M_MASK (0xFFF0000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_HI_1M_SHIFT (16U)
/*! MAG_THRESH_HI_1M - For 1Mbps data rate, the lowest signal level above which hamming-distance is
 *    always checked during AA detection; uses ufix12_En24 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_HI_1M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_HI_1M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_THRESH_HI_1M_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_WIN_MASK    (0xF0000000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_WIN_SHIFT   (28U)
/*! MAG_WIN - Indicates the forgetting factor used in received signal level measurement;
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_WIN(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_WIN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG2_MAG_WIN_MASK)
/*! @} */

/*! @name FSK_CFG3 - PHY Uncoded Config 3 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_2M_MASK (0xFFFU)
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_2M_SHIFT (0U)
/*! MAG_THRESH_2M - For 2Mbps data rate, the lowest signal level below which synchronization is
 *    considered unreliable and hence disallowed; uses ufix12_En24 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_2M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_2M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_2M_MASK)
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_HI_2M_MASK (0xFFF0000U)
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_HI_2M_SHIFT (16U)
/*! MAG_THRESH_HI_2M - For 2Mbps data rate, the lowest signal level above which hamming-distance is
 *    always checked during AA detection; uses ufix12_En24 fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_HI_2M(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_HI_2M_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_CFG3_MAG_THRESH_HI_2M_MASK)
/*! @} */

/*! @name FSK_PT - PHY Uncoded Power Threshold Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_PT_AGC_TIMEOUT_MASK  (0xFFFFU)
#define XCVR_2P4GHZ_PHY_FSK_PT_AGC_TIMEOUT_SHIFT (0U)
/*! AGC_TIMEOUT - Time-out, applicable to special conditioning of signal power detection in the
 *    Power threshold block, after each AGC gain adjustment. It is expressed in number of samples.
 */
#define XCVR_2P4GHZ_PHY_FSK_PT_AGC_TIMEOUT(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PT_AGC_TIMEOUT_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PT_AGC_TIMEOUT_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_SIG_PRST_EN_MASK (0x10000U)
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_SIG_PRST_EN_SHIFT (16U)
/*! COND_SIG_PRST_EN - Enables special conditioning of signal detection;
 *  0b0..disable.
 *  0b1..enable.
 */
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_SIG_PRST_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PT_COND_SIG_PRST_EN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PT_COND_SIG_PRST_EN_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_AA_BUFF_EN_MASK (0x20000U)
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_AA_BUFF_EN_SHIFT (17U)
/*! COND_AA_BUFF_EN - Enables special condition for enabling AA detector buffer;
 *  0b0..disable.
 *  0b1..enable.
 */
#define XCVR_2P4GHZ_PHY_FSK_PT_COND_AA_BUFF_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PT_COND_AA_BUFF_EN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PT_COND_AA_BUFF_EN_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PT_BYPASS_WITH_RSSI_MASK (0x40000U)
#define XCVR_2P4GHZ_PHY_FSK_PT_BYPASS_WITH_RSSI_SHIFT (18U)
/*! BYPASS_WITH_RSSI - Bypass signal power measurement with RSSI measurement;
 *  0b0..no
 *  0b1..yes
 */
#define XCVR_2P4GHZ_PHY_FSK_PT_BYPASS_WITH_RSSI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PT_BYPASS_WITH_RSSI_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PT_BYPASS_WITH_RSSI_MASK)
#define XCVR_2P4GHZ_PHY_FSK_PT_POW_TH_BYPASS_MASK (0x80000U)
#define XCVR_2P4GHZ_PHY_FSK_PT_POW_TH_BYPASS_SHIFT (19U)
/*! POW_TH_BYPASS - Bypass power threshold when AGC gain are not set max;
 *  0b0..no bypass
 *  0b1..yes bypass
 */
#define XCVR_2P4GHZ_PHY_FSK_PT_POW_TH_BYPASS(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_PT_POW_TH_BYPASS_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_PT_POW_TH_BYPASS_MASK)
/*! @} */

/*! @name FSK_FAD_CTRL - PHY Uncoded FAD Control */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CTRL_FAD_EN_MASK (0x1U)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CTRL_FAD_EN_SHIFT (0U)
/*! FAD_EN - Enables FAD;
 *  0b0..disable.
 *  0b1..enable.
 */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CTRL_FAD_EN(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_FAD_CTRL_FAD_EN_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_FAD_CTRL_FAD_EN_MASK)
/*! @} */

/*! @name FSK_FAD_CFG - PHY Uncoded FAD Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_MASK (0x7FU)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_SHIFT (0U)
/*! WIN_FAD_WAIT_SYNCH - Time-window to wait for clean samples, before transitioning to AA search
 *    PHY state, if PD was found after antenna switch (refered to as T3 in the PHY state-machine
 *    section).
 */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_MASK)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_MASK (0x7F00U)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_SHIFT (8U)
/*! WIN_FAD_WAIT_PD - Time-window to wait for clean samples if PD was not found after antenna switch
 *    (refered to as T2 in the PHY state-machine section).
 */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_MASK)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_MASK (0x7F0000U)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_SHIFT (16U)
/*! WIN_FAD_SEARCH_PD - Time-window to match preamble pattern on samples coming from the previously
 *    selected antenna (refered to as T1 in the PHY state-machine section).
 */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_MASK)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_SEARCH_PD_MASK (0x7F000000U)
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_SEARCH_PD_SHIFT (24U)
/*! WIN_SEARCH_PD - Time-window to match preamble pattern on samples coming from the currently
 *    selected antenna (refered to as T0 in the PHY state-machine section).
 */
#define XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_SEARCH_PD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_SEARCH_PD_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_FAD_CFG_WIN_SEARCH_PD_MASK)
/*! @} */

/*! @name FSK_STAT - PHY Uncoded Status */
/*! @{ */
#define XCVR_2P4GHZ_PHY_FSK_STAT_EXT_TO_MODES_13_MASK (0x2U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_EXT_TO_MODES_13_SHIFT (1U)
/*! EXT_TO_MODES_13 - Reserved
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_EXT_TO_MODES_13(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_EXT_TO_MODES_13_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_EXT_TO_MODES_13_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_FOUND_MASK   (0x4U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_FOUND_SHIFT  (2U)
/*! AA_FOUND - Indicates that a uncoded AA detect is active.
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_FOUND(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_AA_FOUND_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_AA_FOUND_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_LAST_AA_BIT_MASK (0x8U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_LAST_AA_BIT_SHIFT (3U)
/*! LAST_AA_BIT - reserved
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_LAST_AA_BIT(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_LAST_AA_BIT_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_LAST_AA_BIT_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_MATCH_MASK   (0xF0U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_MATCH_SHIFT  (4U)
/*! AA_MATCH - Indicates which non-coded AA has matched. This will clear when the PHY is re-initialized.
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_AA_MATCH(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_AA_MATCH_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_AA_MATCH_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_HAMM_DIST_MASK  (0x7F00U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_HAMM_DIST_SHIFT (8U)
/*! HAMM_DIST - Indicates the hamming distance witnessed when AA match occurred.
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_HAMM_DIST(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_HAMM_DIST_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_HAMM_DIST_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_CORR_MAX_MASK   (0x1F0000U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_CORR_MAX_SHIFT  (16U)
/*! CORR_MAX - Indicates the correlation witnessed when AA match occurred
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_CORR_MAX(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_CORR_MAX_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_CORR_MAX_MASK)
#define XCVR_2P4GHZ_PHY_FSK_STAT_TOF_OFF_MASK    (0xF0000000U)
#define XCVR_2P4GHZ_PHY_FSK_STAT_TOF_OFF_SHIFT   (28U)
/*! TOF_OFF - Timing offset for use in time-of-flight calculation.
 */
#define XCVR_2P4GHZ_PHY_FSK_STAT_TOF_OFF(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_FSK_STAT_TOF_OFF_SHIFT)) & XCVR_2P4GHZ_PHY_FSK_STAT_TOF_OFF_MASK)
/*! @} */

/*! @name LR_PD_CFG - PHY Long Range Preamble Detect Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_CORR_TH_MASK   (0xFFU)
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_CORR_TH_SHIFT  (0U)
/*! CORR_TH - Correlation threshold applicable to preamble detection; uses (0,8,8) fixed-point format.
 */
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_CORR_TH(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_CFG_CORR_TH_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_CFG_CORR_TH_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_FREQ_TH_MASK   (0x1F00U)
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_FREQ_TH_SHIFT  (8U)
/*! FREQ_TH - Threshold used to compare CFO estimates in the LR preamble detector; uses ufix5_En5 format.
 */
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_FREQ_TH(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_CFG_FREQ_TH_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_CFG_FREQ_TH_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_NO_PEAKS_MASK  (0x30000U)
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_NO_PEAKS_SHIFT (16U)
/*! NO_PEAKS - Number of consecutive correlation values that have to exceed the PD correlation
 *    threshold,for the same preamble phase, to assert preamble found;
 *  0b00..2 peaks;
 *  0b01..3 peaks;
 *  0b10..4 peaks;
 *  0b11..5 peaks;
 */
#define XCVR_2P4GHZ_PHY_LR_PD_CFG_NO_PEAKS(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_CFG_NO_PEAKS_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_CFG_NO_PEAKS_MASK)
/*! @} */

/*! @name LR_PD_PH -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF0_MASK       (0x3FU)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF0_SHIFT      (0U)
/*! ref0 - Long range preamble reference waveform sample 12 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF0(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_PH_REF0_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_PH_REF0_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF1_MASK       (0x3F00U)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF1_SHIFT      (8U)
/*! ref1 - Long range preamble reference waveform sample 13 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF1(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_PH_REF1_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_PH_REF1_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF2_MASK       (0x3F0000U)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF2_SHIFT      (16U)
/*! ref2 - Long range preamble reference waveform sample 14 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF2(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_PH_REF2_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_PH_REF2_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF3_MASK       (0x3F000000U)
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF3_SHIFT      (24U)
/*! ref3 - Long range preamble reference waveform sample 15 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_REF3(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_PH_REF3_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_PH_REF3_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_LR_PD_PH */
#define XCVR_2P4GHZ_PHY_LR_PD_PH_COUNT           (4U)

/*! @name LR_PD_RO_PH -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF0_MASK    (0x3FU)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF0_SHIFT   (0U)
/*! ref0 - Long range preamble reference waveform sample 64 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF0(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF0_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF0_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF1_MASK    (0x3F00U)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF1_SHIFT   (8U)
/*! ref1 - Long range preamble reference waveform sample 65 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF1(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF1_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF1_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF2_MASK    (0x3F0000U)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF2_SHIFT   (16U)
/*! ref2 - Long range preamble reference waveform sample 66 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF2(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF2_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF2_MASK)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF3_MASK    (0x3F000000U)
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF3_SHIFT   (24U)
/*! ref3 - Long range preamble reference waveform sample 67 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF3(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF3_SHIFT)) & XCVR_2P4GHZ_PHY_LR_PD_RO_PH_REF3_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_LR_PD_RO_PH */
#define XCVR_2P4GHZ_PHY_LR_PD_RO_PH_COUNT        (13U)

/*! @name LR_AA_CFG - PHY Long Range AA Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_COR_THRESH_MASK (0xFFU)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_COR_THRESH_SHIFT (0U)
/*! AA_COR_THRESH - Threshold use to compare the correlation magnitude in the long-range AA correlator.
 */
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_COR_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_COR_THRESH_SHIFT)) & XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_COR_THRESH_MASK)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_HAM_THRESH_MASK (0x3F00U)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_HAM_THRESH_SHIFT (8U)
/*! AA_HAM_THRESH - Threshold use to compare the Hamming distance, between reference coded sequence
 *    and received coded sequence, in the long-range AA correlator.
 */
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_HAM_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_HAM_THRESH_SHIFT)) & XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_HAM_THRESH_MASK)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_ACCESS_ADDR_HAM_MASK (0x1F0000U)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_ACCESS_ADDR_HAM_SHIFT (16U)
/*! ACCESS_ADDR_HAM - Threshold use to compare the Hamming distance, between the reference AA
 *    sequence and the received Viterbi decoded AA sequence.
 */
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_ACCESS_ADDR_HAM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_AA_CFG_ACCESS_ADDR_HAM_SHIFT)) & XCVR_2P4GHZ_PHY_LR_AA_CFG_ACCESS_ADDR_HAM_MASK)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_LR_CORR_GAIN_MASK (0x3F000000U)
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_LR_CORR_GAIN_SHIFT (24U)
/*! AA_LR_CORR_GAIN - AA correlator gain. Format ufix6en3. This gain is applied to soft bits from
 *    the demodulator before they are used for address search synchronization.
 */
#define XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_LR_CORR_GAIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_LR_CORR_GAIN_SHIFT)) & XCVR_2P4GHZ_PHY_LR_AA_CFG_AA_LR_CORR_GAIN_MASK)
/*! @} */

/*! @name LR_STAT - PHY Long Range Status */
/*! @{ */
#define XCVR_2P4GHZ_PHY_LR_STAT_DECODED_HAMM_DIST_MASK (0x3FU)
#define XCVR_2P4GHZ_PHY_LR_STAT_DECODED_HAMM_DIST_SHIFT (0U)
/*! DECODED_HAMM_DIST - Hamming distance between the reference sequence and the Viterbi decoded received sequence
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_DECODED_HAMM_DIST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_DECODED_HAMM_DIST_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_DECODED_HAMM_DIST_MASK)
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_FOUND_MASK    (0x40U)
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_FOUND_SHIFT   (6U)
/*! AA_FOUND - Indicates that a AA detect is active for both LR and uncoded.
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_FOUND(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_AA_FOUND_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_AA_FOUND_MASK)
#define XCVR_2P4GHZ_PHY_LR_STAT_CI_MASK          (0x80U)
#define XCVR_2P4GHZ_PHY_LR_STAT_CI_SHIFT         (7U)
/*! CI - CI received.
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_CI(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_CI_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_CI_MASK)
#define XCVR_2P4GHZ_PHY_LR_STAT_CODED_HAMM_DIST_MASK (0x7F00U)
#define XCVR_2P4GHZ_PHY_LR_STAT_CODED_HAMM_DIST_SHIFT (8U)
/*! CODED_HAMM_DIST - Hamming distance between the coded reference sequence and the coded received sequence.
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_CODED_HAMM_DIST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_CODED_HAMM_DIST_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_CODED_HAMM_DIST_MASK)
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_CORR_MAX_MASK (0xFF0000U)
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_CORR_MAX_SHIFT (16U)
/*! AA_CORR_MAX - Indicates the AA correlation magnitude witnessed when AA match occurred
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_AA_CORR_MAX(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_AA_CORR_MAX_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_AA_CORR_MAX_MASK)
#define XCVR_2P4GHZ_PHY_LR_STAT_CMAG_MAX_MASK    (0xFF000000U)
#define XCVR_2P4GHZ_PHY_LR_STAT_CMAG_MAX_SHIFT   (24U)
/*! CMAG_MAX - Indicates the maximum preamble correlation magnitude during preamble found
 */
#define XCVR_2P4GHZ_PHY_LR_STAT_CMAG_MAX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_LR_STAT_CMAG_MAX_SHIFT)) & XCVR_2P4GHZ_PHY_LR_STAT_CMAG_MAX_MASK)
/*! @} */

/*! @name SM_CFG - PHY State Machine Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_SM_CFG_ACQ_MODE_MASK     (0x3U)
#define XCVR_2P4GHZ_PHY_SM_CFG_ACQ_MODE_SHIFT    (0U)
/*! ACQ_MODE - Acquisition mode for non-coded reception
 *  0b00..Reserved
 *  0b01..Use preamble and verify a correlation peak, the synch at the symbol rate as symbol timing is established by the preamble acquisition
 *  0b10..Use synch only (which may incorporate part of the preamble)
 *  0b11..Use mainly the sync detection: Use a low threshold on the preamble detector and launch the synch
 *        detection only if the preamble has shown a recent peak
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_ACQ_MODE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_ACQ_MODE_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_ACQ_MODE_MASK)
#define XCVR_2P4GHZ_PHY_SM_CFG_EN_PHY_SM_EXT_RST_MASK (0x4U)
#define XCVR_2P4GHZ_PHY_SM_CFG_EN_PHY_SM_EXT_RST_SHIFT (2U)
/*! EN_PHY_SM_EXT_RST - Reserved, should keep 0.
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_EN_PHY_SM_EXT_RST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_EN_PHY_SM_EXT_RST_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_EN_PHY_SM_EXT_RST_MASK)
#define XCVR_2P4GHZ_PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_MASK (0x8U)
#define XCVR_2P4GHZ_PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_SHIFT (3U)
/*! AGC_FRZ_ON_PD_FOUND_ACQ1_LR - Specfies AGC freeze condition for non-coded acq.1 and Bluetooth LE long range.
 *  0b0..AGC freeze on AA found.
 *  0b1..AGC freeze asserted on PD found.
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_MASK)
#define XCVR_2P4GHZ_PHY_SM_CFG_PH_BUFF_PTR_SYM_MASK (0x30U)
#define XCVR_2P4GHZ_PHY_SM_CFG_PH_BUFF_PTR_SYM_SHIFT (4U)
/*! PH_BUFF_PTR_SYM - Phase buffer size to demodulator, long range only.
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_PH_BUFF_PTR_SYM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_PH_BUFF_PTR_SYM_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_PH_BUFF_PTR_SYM_MASK)
#define XCVR_2P4GHZ_PHY_SM_CFG_EARLY_PD_TIMEOUT_MASK (0x3F00U)
#define XCVR_2P4GHZ_PHY_SM_CFG_EARLY_PD_TIMEOUT_SHIFT (8U)
/*! EARLY_PD_TIMEOUT - Time-out used to reset the AGC state-machine for the eventuality that an "PD
 *    found early" event occurs but it is not followed by an "PD found" event
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_EARLY_PD_TIMEOUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_EARLY_PD_TIMEOUT_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_EARLY_PD_TIMEOUT_MASK)
#define XCVR_2P4GHZ_PHY_SM_CFG_AA_TIMEOUT_UNCODED_MASK (0x3FF0000U)
#define XCVR_2P4GHZ_PHY_SM_CFG_AA_TIMEOUT_UNCODED_SHIFT (16U)
/*! AA_TIMEOUT_UNCODED - Time-out value for access address search for uncoded packets
 */
#define XCVR_2P4GHZ_PHY_SM_CFG_AA_TIMEOUT_UNCODED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_SM_CFG_AA_TIMEOUT_UNCODED_SHIFT)) & XCVR_2P4GHZ_PHY_SM_CFG_AA_TIMEOUT_UNCODED_MASK)
/*! @} */

/*! @name MISC - PHY Misc Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_MISC_RSSI_CORR_TH_MASK   (0xFFU)
#define XCVR_2P4GHZ_PHY_MISC_RSSI_CORR_TH_SHIFT  (0U)
/*! RSSI_CORR_TH - Threshold use to compare a correlation magnitude value, computed in the
 *    acquisition block, in order to determine the correlation flag value provided by the PHY to the LQI
 *    computation block. Format is ufix8_En8
 */
#define XCVR_2P4GHZ_PHY_MISC_RSSI_CORR_TH(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_RSSI_CORR_TH_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_RSSI_CORR_TH_MASK)
#define XCVR_2P4GHZ_PHY_MISC_DMA_PAGE_SEL_MASK   (0x700U)
#define XCVR_2P4GHZ_PHY_MISC_DMA_PAGE_SEL_SHIFT  (8U)
/*! DMA_PAGE_SEL - Select which DMA page is send out
 *  0b000..Select DMA PAGE 0 for M3C with cfo;
 *  0b001..Select DMA PAGE 1 for M3C with magnitude;
 *  0b010..Select DMA PAGE 2 for un-coded;
 *  0b011..Select DMA PAGE 3 for Long Range Preampble Detect;
 *  0b100..Select DMA PAGE 4 for Long Range AA Detect;
 */
#define XCVR_2P4GHZ_PHY_MISC_DMA_PAGE_SEL(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_DMA_PAGE_SEL_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_DMA_PAGE_SEL_MASK)
#define XCVR_2P4GHZ_PHY_MISC_ECO1_RSVD_MASK      (0xF800U)
#define XCVR_2P4GHZ_PHY_MISC_ECO1_RSVD_SHIFT     (11U)
/*! ECO1_RSVD - Reserved. Must be programed as reset value 0.
 */
#define XCVR_2P4GHZ_PHY_MISC_ECO1_RSVD(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_ECO1_RSVD_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_ECO1_RSVD_MASK)
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_CTRL_MASK   (0x3FF0000U)
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_CTRL_SHIFT  (16U)
/*! PHY_CLK_CTRL - Enables various clock gating features. Bits are individually decoded, so any combination is allowable.
 */
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_PHY_CLK_CTRL_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_PHY_CLK_CTRL_MASK)
#define XCVR_2P4GHZ_PHY_MISC_ECO2_RSVD_MASK      (0x3C000000U)
#define XCVR_2P4GHZ_PHY_MISC_ECO2_RSVD_SHIFT     (26U)
/*! ECO2_RSVD - Reserved
 */
#define XCVR_2P4GHZ_PHY_MISC_ECO2_RSVD(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_ECO2_RSVD_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_ECO2_RSVD_MASK)
#define XCVR_2P4GHZ_PHY_MISC_DTEST_MUX_EN_MASK   (0x40000000U)
#define XCVR_2P4GHZ_PHY_MISC_DTEST_MUX_EN_SHIFT  (30U)
/*! DTEST_MUX_EN - Reserved. Should be programed as reset value 0.
 */
#define XCVR_2P4GHZ_PHY_MISC_DTEST_MUX_EN(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_DTEST_MUX_EN_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_DTEST_MUX_EN_MASK)
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_ON_MASK     (0x80000000U)
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_ON_SHIFT    (31U)
/*! PHY_CLK_ON - Force PHY clock ON
 */
#define XCVR_2P4GHZ_PHY_MISC_PHY_CLK_ON(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_MISC_PHY_CLK_ON_SHIFT)) & XCVR_2P4GHZ_PHY_MISC_PHY_CLK_ON_MASK)
/*! @} */

/*! @name STAT0 - PHY Status 0 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_STAT0_PD_FOUND_MASK      (0x1U)
#define XCVR_2P4GHZ_PHY_STAT0_PD_FOUND_SHIFT     (0U)
/*! PD_FOUND - PD_FOUND for LR or uncoded
 */
#define XCVR_2P4GHZ_PHY_STAT0_PD_FOUND(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_PD_FOUND_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_PD_FOUND_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_LR_DET_FLAG_MASK   (0x2U)
#define XCVR_2P4GHZ_PHY_STAT0_LR_DET_FLAG_SHIFT  (1U)
/*! LR_DET_FLAG - Indicates Bluetooth LE long range was detected
 */
#define XCVR_2P4GHZ_PHY_STAT0_LR_DET_FLAG(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_LR_DET_FLAG_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_LR_DET_FLAG_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_AA_MATCHED_MASK    (0x4U)
#define XCVR_2P4GHZ_PHY_STAT0_AA_MATCHED_SHIFT   (2U)
/*! AA_MATCHED - Indicates AA was matched for LR or uncoded
 */
#define XCVR_2P4GHZ_PHY_STAT0_AA_MATCHED(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_AA_MATCHED_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_AA_MATCHED_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_AA_FOUND_ID_MASK   (0x38U)
#define XCVR_2P4GHZ_PHY_STAT0_AA_FOUND_ID_SHIFT  (3U)
/*! AA_FOUND_ID - Indicates which AA was matched for LR and uncode
 *  0b000..uncoded address 0 matched
 *  0b001..uncoded address 1 matched
 *  0b010..uncoded address 2 matched
 *  0b011..uncoded address 3 matched
 *  0b100..long range address matched
 */
#define XCVR_2P4GHZ_PHY_STAT0_AA_FOUND_ID(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_AA_FOUND_ID_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_AA_FOUND_ID_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_DATA_RATE_MASK     (0xC0U)
#define XCVR_2P4GHZ_PHY_STAT0_DATA_RATE_SHIFT    (6U)
/*! DATA_RATE - Indicates the data rate of received bit
 *  0b00..1Mbps
 *  0b01..2Mbps
 *  0b10..125kbps
 *  0b11..500kbps
 */
#define XCVR_2P4GHZ_PHY_STAT0_DATA_RATE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_DATA_RATE_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_DATA_RATE_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_FRAC_MASK          (0x3F00U)
#define XCVR_2P4GHZ_PHY_STAT0_FRAC_SHIFT         (8U)
/*! FRAC - Indicates the fractional timing estimate determined in the acquisition block. Format is
 *    sfix6_en5(sign extend from sfix3_En2).
 */
#define XCVR_2P4GHZ_PHY_STAT0_FRAC(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_FRAC_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_FRAC_MASK)
#define XCVR_2P4GHZ_PHY_STAT0_CFO_EST_MASK       (0x3FF0000U)
#define XCVR_2P4GHZ_PHY_STAT0_CFO_EST_SHIFT      (16U)
/*! CFO_EST - Indicates the currently estimated CFO. Format is sfix10_en9(sign extend form sfix8_en9)
 */
#define XCVR_2P4GHZ_PHY_STAT0_CFO_EST(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT0_CFO_EST_SHIFT)) & XCVR_2P4GHZ_PHY_STAT0_CFO_EST_MASK)
/*! @} */

/*! @name STAT1 - PHY Status 1 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_STAT1_AA_BITS_MASK       (0xFFFFFFFFU)
#define XCVR_2P4GHZ_PHY_STAT1_AA_BITS_SHIFT      (0U)
/*! AA_BITS - AA bits either received or programed
 */
#define XCVR_2P4GHZ_PHY_STAT1_AA_BITS(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT1_AA_BITS_SHIFT)) & XCVR_2P4GHZ_PHY_STAT1_AA_BITS_MASK)
/*! @} */

/*! @name STAT2 - PHY Status 2 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_ANT_SW_MASK    (0x3U)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_ANT_SW_SHIFT   (0U)
/*! CNT_ANT_SW - Count of uncoded ANT switch event when FAD was enabled.
 */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_ANT_SW(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT2_CNT_ANT_SW_SHIFT)) & XCVR_2P4GHZ_PHY_STAT2_CNT_ANT_SW_MASK)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_UNCAA_TIMEOUT_MASK (0xCU)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_UNCAA_TIMEOUT_SHIFT (2U)
/*! CNT_UNCAA_TIMEOUT - Count of uncoded AA search timeout event
 */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_UNCAA_TIMEOUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT2_CNT_UNCAA_TIMEOUT_SHIFT)) & XCVR_2P4GHZ_PHY_STAT2_CNT_UNCAA_TIMEOUT_MASK)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_LRAA_TIMEOUT_MASK (0x30U)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_LRAA_TIMEOUT_SHIFT (4U)
/*! CNT_LRAA_TIMEOUT - Count of lang range AA search timeout event
 */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_LRAA_TIMEOUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT2_CNT_LRAA_TIMEOUT_SHIFT)) & XCVR_2P4GHZ_PHY_STAT2_CNT_LRAA_TIMEOUT_MASK)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AACI_TIMEOUT_MASK (0xC0U)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AACI_TIMEOUT_SHIFT (6U)
/*! CNT_AACI_TIMEOUT - Count of long range AACI detect timeout event
 */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AACI_TIMEOUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT2_CNT_AACI_TIMEOUT_SHIFT)) & XCVR_2P4GHZ_PHY_STAT2_CNT_AACI_TIMEOUT_MASK)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AGC_RST_MASK   (0x300U)
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AGC_RST_SHIFT  (8U)
/*! CNT_AGC_RST - Count of AGC soft reset event
 */
#define XCVR_2P4GHZ_PHY_STAT2_CNT_AGC_RST(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_STAT2_CNT_AGC_RST_SHIFT)) & XCVR_2P4GHZ_PHY_STAT2_CNT_AGC_RST_MASK)
/*! @} */

/*! @name PREPHY_MISC - PHY PrePHY Misc Config */
/*! @{ */
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_LR_MASK (0x1FU)
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_LR_SHIFT (0U)
/*! BUFF_PTR_LR - Pointer to the PrePHY IQ buffer for the reception of the long-range packets.
 */
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_LR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_LR_SHIFT)) & XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_LR_MASK)
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_GFSK_MASK (0x1F00U)
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_GFSK_SHIFT (8U)
/*! BUFF_PTR_GFSK - Pointer to the PrePHY IQ buffer for the reception of the uncoded packets.
 */
#define XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_GFSK(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_GFSK_SHIFT)) & XCVR_2P4GHZ_PHY_PREPHY_MISC_BUFF_PTR_GFSK_MASK)
/*! @} */

/*! @name DMD_CTRL0 - PHY Demodulator Control 0 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TED_ACT_WIN_MASK (0x3U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TED_ACT_WIN_SHIFT (0U)
/*! TED_ACT_WIN - Active window size for the time tracking mechanism, expressed in symbols.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TED_ACT_WIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_TED_ACT_WIN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_TED_ACT_WIN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FED_ACT_WIN_MASK (0x300U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FED_ACT_WIN_SHIFT (8U)
/*! FED_ACT_WIN - Active window size for the frequency tracking mechanism, expressed in symbols.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FED_ACT_WIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_FED_ACT_WIN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_FED_ACT_WIN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SCALE_FREQ_MASK (0xF0000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SCALE_FREQ_SHIFT (16U)
/*! DREP_SCALE_FREQ - Frequency domain signal scaling factor used by the de-repeater.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SCALE_FREQ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SCALE_FREQ_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SCALE_FREQ_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_REPEAT_FACTOR_MASK (0x700000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_REPEAT_FACTOR_SHIFT (20U)
/*! REPEAT_FACTOR - Repetition factor used by the de-repeater.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_REPEAT_FACTOR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_REPEAT_FACTOR_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_REPEAT_FACTOR_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TERR_TRK_EN_MASK (0x4000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TERR_TRK_EN_SHIFT (26U)
/*! TERR_TRK_EN - Enables time tracking in the demodulator.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_TERR_TRK_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_TERR_TRK_EN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_TERR_TRK_EN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FERR_TRK_EN_MASK (0x8000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FERR_TRK_EN_SHIFT (27U)
/*! FERR_TRK_EN - Enables frequency tracking in the demodulator.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_FERR_TRK_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_FERR_TRK_EN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_FERR_TRK_EN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SINE_EN_MASK (0x10000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SINE_EN_SHIFT (28U)
/*! DREP_SINE_EN - Flag used to enable the non-linear operation in the de-repeater.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SINE_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SINE_EN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_DREP_SINE_EN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DEMOD_MOD_MASK (0x60000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DEMOD_MOD_SHIFT (29U)
/*! DEMOD_MOD - Determines the number of taps used by the demodulator correlators;
 *  0b00..use 12 taps
 *  0b01..use 4 taps
 *  0b10..use 7 taps
 *  0b11..use 13 taps
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL0_DEMOD_MOD(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL0_DEMOD_MOD_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL0_DEMOD_MOD_MASK)
/*! @} */

/*! @name DMD_CTRL1 - PHY Dmodulator Control 1 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IDLE_WIN_MASK (0x3FFU)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IDLE_WIN_SHIFT (0U)
/*! FED_IDLE_WIN - Idle window size for the frequency tracking mechanism, expressed in symbols.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IDLE_WIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IDLE_WIN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IDLE_WIN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_ERR_SCALE_MASK (0x3C00U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_ERR_SCALE_SHIFT (10U)
/*! TED_ERR_SCALE - Scaling factor used by the time tracking loop.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_ERR_SCALE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_ERR_SCALE_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_ERR_SCALE_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IMM_MEAS_EN_MASK (0x8000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IMM_MEAS_EN_SHIFT (15U)
/*! FED_IMM_MEAS_EN - Specifies whether the frequency tracking starts with an active window;
 *  0b0..start with idle window
 *  0b1..start with active window
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IMM_MEAS_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IMM_MEAS_EN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_FED_IMM_MEAS_EN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IDLE_WIN_MASK (0x3FF0000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IDLE_WIN_SHIFT (16U)
/*! TED_IDLE_WIN - Idle window size for the time tracking mechanism, expressed in symbols.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IDLE_WIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IDLE_WIN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IDLE_WIN_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TTRK_INT_RANGE_MASK (0x3C000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TTRK_INT_RANGE_SHIFT (26U)
/*! TTRK_INT_RANGE - Timing error correction interpolation range, expressed in samples. The value must equal or bigger than 1.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TTRK_INT_RANGE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_TTRK_INT_RANGE_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_TTRK_INT_RANGE_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IMM_MEAS_EN_MASK (0x80000000U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IMM_MEAS_EN_SHIFT (31U)
/*! TED_IMM_MEAS_EN - Specifies whether the time tracking starts with an active window;
 *  0b0..start with idle window
 *  0b1..start with active window
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IMM_MEAS_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IMM_MEAS_EN_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL1_TED_IMM_MEAS_EN_MASK)
/*! @} */

/*! @name DMD_CTRL2 - PHY Demodulator Control 2 */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_MASK (0xFU)
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_SHIFT (0U)
/*! WAIT_DMD_LR_ADJ - Reserved. Must be programed as reset value 1.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_MASK (0xF0U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_SHIFT (4U)
/*! WAIT_VIA_AFTER_AA_ADJ - Reserved. Must be programed as reset value 1.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_MASK)
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_MASK (0xF00U)
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_SHIFT (8U)
/*! WAIT_DMD_CLKEN_ADJ - Reserved. Must be programed as reset value 1.
 */
#define XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_MASK)
/*! @} */

/*! @name DMD_WAVE_REG0 -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL0_MASK (0x3FU)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL0_SHIFT (0U)
/*! SMPL0 - Demodulator waveform 7 sample 0 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL0(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL0_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL0_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL1_MASK (0xFC0U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL1_SHIFT (6U)
/*! SMPL1 - Demodulator waveform 7 sample 1 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL1(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL1_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL1_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL2_MASK (0x3F000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL2_SHIFT (12U)
/*! SMPL2 - Demodulator waveform 7 sample 2 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL2(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL2_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL2_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL3_MASK (0xFC0000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL3_SHIFT (18U)
/*! SMPL3 - Demodulator waveform 7 sample 3 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL3(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL3_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL3_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL4_MASK (0x3F000000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL4_SHIFT (24U)
/*! SMPL4 - Demodulator waveform 7 sample 4 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL4(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL4_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_SMPL4_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_DMD_WAVE_REG0 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG0_COUNT      (8U)

/*! @name DMD_WAVE_REG1 -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL5_MASK (0x3FU)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL5_SHIFT (0U)
/*! SMPL5 - Demodulator waveform 7 sample 5 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL5(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL5_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL5_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL6_MASK (0xFC0U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL6_SHIFT (6U)
/*! SMPL6 - Demodulator waveform 7 sample 6 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL6(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL6_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL6_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL7_MASK (0x3F000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL7_SHIFT (12U)
/*! SMPL7 - Demodulator waveform 7 sample 7 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL7(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL7_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL7_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL8_MASK (0xFC0000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL8_SHIFT (18U)
/*! SMPL8 - Demodulator waveform 7 sample 8 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL8(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL8_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL8_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL9_MASK (0x3F000000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL9_SHIFT (24U)
/*! SMPL9 - Demodulator waveform 7 sample 9 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL9(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL9_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_SMPL9_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_DMD_WAVE_REG1 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG1_COUNT      (8U)

/*! @name DMD_WAVE_REG2 -  */
/*! @{ */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL10_MASK (0x3FU)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL10_SHIFT (0U)
/*! SMPL10 - Demodulator waveform 7 sample 10 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL10(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL10_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL10_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL11_MASK (0xFC0U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL11_SHIFT (6U)
/*! SMPL11 - Demodulator waveform 7 sample 11 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL11(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL11_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL11_MASK)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL12_MASK (0x3F000U)
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL12_SHIFT (12U)
/*! SMPL12 - Demodulator waveform 7 sample 12 (sfix6en5)
 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL12(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL12_SHIFT)) & XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_SMPL12_MASK)
/*! @} */

/* The count of XCVR_2P4GHZ_PHY_DMD_WAVE_REG2 */
#define XCVR_2P4GHZ_PHY_DMD_WAVE_REG2_COUNT      (8U)


/*!
 * @}
 */ /* end of group XCVR_2P4GHZ_PHY_Register_Masks */


/* XCVR_2P4GHZ_PHY - Peripheral instance base addresses */
/** Peripheral XCVR_2P4GHZ_PHY base address */
#define XCVR_2P4GHZ_PHY_BASE                     (0x40087800u)
/** Peripheral XCVR_2P4GHZ_PHY base pointer */
#define XCVR_2P4GHZ_PHY                          ((XCVR_2P4GHZ_PHY_Type *)XCVR_2P4GHZ_PHY_BASE)
/** Array initializer of XCVR_2P4GHZ_PHY peripheral base addresses */
#define XCVR_2P4GHZ_PHY_BASE_ADDRS               { XCVR_2P4GHZ_PHY_BASE }
/** Array initializer of XCVR_2P4GHZ_PHY peripheral base pointers */
#define XCVR_2P4GHZ_PHY_BASE_PTRS                { XCVR_2P4GHZ_PHY }

/*!
 * @}
 */ /* end of group XCVR_2P4GHZ_PHY_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Peripheral_Access_Layer XCVR_ANALOG Peripheral Access Layer
 * @{
 */

/** XCVR_ANALOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t BB_LDO_1;                          /**< RF Analog Baseband LDO Control 1, offset: 0x0 */
  __IO uint32_t BB_LDO_2;                          /**< RF Analog Baseband LDO Control 2, offset: 0x4 */
  __IO uint32_t RX_ADC;                            /**< RF Analog ADC Control, offset: 0x8 */
  __IO uint32_t RX_BBA;                            /**< RF Analog BBA Control, offset: 0xC */
  __IO uint32_t RX_LNA;                            /**< RF Analog LNA Control, offset: 0x10 */
  __IO uint32_t RX_TZA;                            /**< RF Analog TZA Control, offset: 0x14 */
  __IO uint32_t RX_AUXPLL;                         /**< RF Analog Aux PLL Control, offset: 0x18 */
  __IO uint32_t SY_CTRL_1;                         /**< RF Analog Synthesizer Control 1, offset: 0x1C */
  __IO uint32_t SY_CTRL_2;                         /**< RF Analog Synthesizer Control 2, offset: 0x20 */
  __IO uint32_t TX_DAC_PA;                         /**< RF Analog TX HPM DAC and PA Control, offset: 0x24 */
} XCVR_ANALOG_Type;

/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Register_Masks XCVR_ANALOG Register Masks
 * @{
 */

/*! @name BB_LDO_1 - RF Analog Baseband LDO Control 1 */
/*! @{ */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_MASK (0x1U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_SHIFT (0U)
/*! BB_LDO_ADCDAC_BYP - rmap_bb_ldo_adcdac_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_MASK (0x2U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_SHIFT (1U)
/*! BB_LDO_ADCDAC_DIAGSEL - rmap_bb_ldo_adcdac_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_MASK (0xCU)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_SHIFT (2U)
/*! BB_LDO_ADCDAC_SPARE - rmap_bb_ldo_adcdac_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_MASK (0x70U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_SHIFT (4U)
/*! BB_LDO_ADCDAC_TRIM - rmap_bb_ldo_adcdac_trim[2:0]
 *  0b000..1.20 V ( Default )
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_MASK (0x100U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_SHIFT (8U)
/*! BB_LDO_BBA_BYP - rmap_bb_ldo_bba_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_MASK (0x200U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_SHIFT (9U)
/*! BB_LDO_BBA_DIAGSEL - rmap_bb_ldo_bba_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_MASK (0xC00U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_SHIFT (10U)
/*! BB_LDO_BBA_SPARE - rmap_bb_ldo_bba_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_MASK (0x7000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_SHIFT (12U)
/*! BB_LDO_BBA_TRIM - rmap_bb_ldo_bba_trim[2:0]
 *  0b000..1.20 V ( Default )
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_MASK (0x10000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_SHIFT (16U)
/*! BB_LDO_FDBK_BYP - rmap_bb_ldo_fdbk_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_MASK (0x20000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_SHIFT (17U)
/*! BB_LDO_FDBK_DIAGSEL - rmap_bb_ldo_fdbk_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_MASK (0xC0000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_SHIFT (18U)
/*! BB_LDO_FDBK_SPARE - rmap_bb_ldo_fdbk_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_MASK (0x700000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_SHIFT (20U)
/*! BB_LDO_FDBK_TRIM - rmap_bb_ldo_fdbk_trim[2:0]
 *  0b000..1.2/1.176 V ( Default )
 *  0b001..1.138/1.115 V
 *  0b010..1.085/1.066 V
 *  0b011..1.04/1.025 V
 *  0b100..1.28/1.25 V
 *  0b101..1.4/1.35 V
 *  0b110..1.55/1.4 V
 *  0b111..1.78/1.4 V
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_MASK  (0x1000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_SHIFT (24U)
/*! BB_LDO_HF_BYP - rmap_bb_ldo_hf_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_MASK (0x2000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_SHIFT (25U)
/*! BB_LDO_HF_DIAGSEL - rmap_bb_ldo_hf_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_MASK (0xC000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_SHIFT (26U)
/*! BB_LDO_HF_SPARE - rmap_bb_ldo_hf_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_RX_MASK (0x70000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_RX_SHIFT (28U)
/*! BB_LDO_HF_TRIM_RX - rmap_bb_ldo_hf_trim[2:0]
 *  0b000..1.20 V ( Default )
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_RX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_RX_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_RX_MASK)
/*! @} */

/*! @name BB_LDO_2 - RF Analog Baseband LDO Control 2 */
/*! @{ */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_MASK  (0x1U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_SHIFT (0U)
/*! BB_LDO_PD_BYP - rmap_bb_ldo_pd_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_MASK (0x2U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_SHIFT (1U)
/*! BB_LDO_PD_DIAGSEL - rmap_bb_ldo_pd_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_MASK (0xCU)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_SHIFT (2U)
/*! BB_LDO_PD_SPARE - rmap_bb_ldo_pd_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_MASK (0x70U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_SHIFT (4U)
/*! BB_LDO_PD_TRIM - rmap_bb_ldo_pd_trim[2:0]
 *  0b000..1.20 V ( Default )
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_MASK (0x300U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_SHIFT (8U)
/*! BB_LDO_VCO_SPARE - rmap_bb_ldo_vco_spare[1:0]
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_MASK (0x400U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_SHIFT (10U)
/*! BB_LDO_VCOLO_BYP - rmap_bb_ldo_vcolo_byp
 *  0b0..Bypass disabled.
 *  0b1..Bypass enabled
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_SHIFT (11U)
/*! BB_LDO_VCOLO_DIAGSEL - rmap_bb_ldo_vcolo_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_MASK (0x7000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_SHIFT (12U)
/*! BB_LDO_VCOLO_TRIM - rmap_bb_ldo_vcolo_trim[2:0]
 *  0b000..1.138/1.117 V ( Default )
 *  0b001..1.076/1.058 V
 *  0b010..1.027/1.012 V
 *  0b011..0.98/0.97 V
 *  0b100..1.22/1.19 V
 *  0b101..1.33/1.3 V
 *  0b110..1.5/1.4 V
 *  0b111..1.82/1.4 V
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_MASK (0x10000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_SHIFT (16U)
/*! BB_LDO_VTREF_DIAGSEL - rmap_bb_ldo_vtref_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_MASK (0x60000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_SHIFT (17U)
/*! BB_LDO_VTREF_TC - rmap_bb_ldo_vtref_tc[1:0]
 *  0b00..1.117/1.176 V
 *  0b01..1.134/1.188 V
 *  0b10..1.10/1.162 V
 *  0b11..1.09/1.152 V
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_HF_TRIM_TX_MASK (0x70000000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_HF_TRIM_TX_SHIFT (28U)
/*! BB_LDO_HF_TRIM_TX - rmap_bb_ldo_hf_trim[2:0]
 *  0b000..1.20 V ( Default )
 *  0b001..1.25 V
 *  0b010..1.28 V
 *  0b011..1.33 V
 *  0b100..1.40 V
 *  0b101..1.44 V
 *  0b110..1.50 V
 *  0b111..1.66 V
 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_HF_TRIM_TX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_HF_TRIM_TX_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_HF_TRIM_TX_MASK)
/*! @} */

/*! @name RX_ADC - RF Analog ADC Control */
/*! @{ */
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_MASK      (0xFFU)
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_SHIFT     (0U)
/*! RX_ADC_BUMP - rmap_rx_adc_bump[7:0]
 */
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_MASK    (0x300U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_SHIFT   (8U)
/*! RX_ADC_FS_SEL - rmap_rx_adc_fs_sel[1:0]
 *  0b00..52MHz (2x26MHz)
 *  0b01..64MHz (2x32MHz)
 *  0b10..+13% of 64MHz
 *  0b11..- 11% of 64MHz
 */
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_MASK (0x400U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_SHIFT (10U)
/*! RX_ADC_I_DIAGSEL - rmap_rx_adc_i_diagsel
 */
#define XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_SHIFT (11U)
/*! RX_ADC_Q_DIAGSEL - rmap_rx_adc_q_diagsel
 */
#define XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_MASK     (0xF000U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_SHIFT    (12U)
/*! RX_ADC_SPARE - rmap_rx_adc_spare[3:0]
 */
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_MASK)
/*! @} */

/*! @name RX_BBA - RF Analog BBA Control */
/*! @{ */
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_MASK    (0x7U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_SHIFT   (0U)
/*! RX_BBA_BW_SEL - rmap_rx_bba_bw_sel[2:0]
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_MASK  (0x8U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_SHIFT (3U)
/*! RX_BBA_CUR_BUMP - rmap_rx_bba_cur_bump
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_MASK  (0x10U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_SHIFT (4U)
/*! RX_BBA_DIAGSEL1 - rmap_rx_bba_diagsel1
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_MASK  (0x20U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_SHIFT (5U)
/*! RX_BBA_DIAGSEL2 - rmap_rx_bba_diagsel2
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_MASK  (0x40U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_SHIFT (6U)
/*! RX_BBA_DIAGSEL3 - rmap_rx_bba_diagsel3
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_MASK  (0x80U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_SHIFT (7U)
/*! RX_BBA_DIAGSEL4 - rmap_rx_bba_diagsel4
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_DRS_MASK (0x700U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_DRS_SHIFT (8U)
/*! RX_BBA_BW_SEL_DRS - rmap_rx_bba_bw_sel[2:0], for DataRate Switch
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_DRS(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_DRS_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_DRS_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_DRS_MASK (0x7000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_DRS_SHIFT (12U)
/*! RX_BBA2_BW_SEL_DRS - rmap_bba2_bw_sel[2:0], for DataRate Switch
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_DRS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_DRS_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_DRS_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_MASK     (0x3F0000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_SHIFT    (16U)
/*! RX_BBA_SPARE - rmap_rx_bba_spare[5:0]
 *  0b000000..600mV (Default)
 *  0b000001..675mV
 *  0b000010..450mV
 *  0b000011..525mV
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_MASK   (0x7000000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_SHIFT  (24U)
/*! RX_BBA2_BW_SEL - rmap_bba2_bw_sel[2:0]
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_MASK    (0x70000000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_SHIFT   (28U)
/*! RX_BBA2_SPARE - rmap_rx_bba2_spare[2:0]
 */
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_MASK)
/*! @} */

/*! @name RX_LNA - RF Analog LNA Control */
/*! @{ */
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_MASK      (0xFU)
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_SHIFT     (0U)
/*! RX_LNA_BUMP - rmap_rx_lna_bump[3:0]
 *  0b0000..Default
 *  0b0001..-25%
 *  0b0010..+50%
 *  0b0011..+25%
 *  0b0100..CM 480mV
 *  0b1000..CM 600mV
 *  0b1100..CM 660mV
 */
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_MASK)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_MASK (0x10U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_SHIFT (4U)
/*! RX_LNA_HG_DIAGSEL - rmap_rx_lna_hg_diagsel
 */
#define XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_MASK (0x20U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_SHIFT (5U)
/*! RX_LNA_HIZ_ENABLE - rmap_rx_lna_hiZ_enable
 */
#define XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_MASK)
#define XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_MASK (0x40U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_SHIFT (6U)
/*! RX_LNA_LG_DIAGSEL - rmap_rx_lna_lg_diagsel
 */
#define XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_MASK     (0x300U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_SHIFT    (8U)
/*! RX_LNA_SPARE - rmap_rx_lna_spare[1:0]
 */
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_MASK)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_MASK    (0xF0000U)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_SHIFT   (16U)
/*! RX_MIXER_BUMP - rmap_rx_mixer_bump[3:0]
 *  0b0000..825mV (Default)
 *  0b0001..750mV
 *  0b0010..900mV
 *  0b0011..975mV
 */
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_MASK)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_MASK   (0x100000U)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_SHIFT  (20U)
/*! RX_MIXER_SPARE - rmap_rx_mixer_spare
 */
#define XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_MASK)
/*! @} */

/*! @name RX_TZA - RF Analog TZA Control */
/*! @{ */
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_MASK    (0x7U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_SHIFT   (0U)
/*! RX_TZA_BW_SEL - rmap_rx_tza_bw_sel[2:0]
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_MASK  (0x8U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_SHIFT (3U)
/*! RX_TZA_CUR_BUMP - rmap_rx_tza_cur_bump
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_MASK (0x10U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_SHIFT (4U)
/*! RX_TZA_GAIN_BUMP - rmap_rx_tza_gain_bump
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_DRS_MASK (0x700U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_DRS_SHIFT (8U)
/*! RX_TZA_BW_SEL_DRS - rmap_rx_tza_bw_sel[2:0], for DataRate Switch
 *  0b000..1000K
 *  0b001..900K
 *  0b010..800K
 *  0b011..700K Default
 *  0b100..600K
 *  0b101..500K
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_DRS(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_DRS_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_DRS_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_MASK     (0x3F0000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_SHIFT    (16U)
/*! RX_TZA_SPARE - rmap_rx_tza_spare[5:0]
 *  0b000000..600mV (Default)
 *  0b000001..675mV
 *  0b000010..450mV
 *  0b000011..525mV
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_MASK  (0x1000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_SHIFT (24U)
/*! RX_TZA1_DIAGSEL - rmap_rx_tza1_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_MASK  (0x2000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_SHIFT (25U)
/*! RX_TZA2_DIAGSEL - rmap_rx_tza2_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_MASK  (0x4000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_SHIFT (26U)
/*! RX_TZA3_DIAGSEL - rmap_rx_tza3_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_MASK  (0x8000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_SHIFT (27U)
/*! RX_TZA4_DIAGSEL - rmap_rx_tza4_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_MASK)
/*! @} */

/*! @name RX_AUXPLL - RF Analog Aux PLL Control */
/*! @{ */
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_MASK     (0x7U)
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_SHIFT    (0U)
/*! BIAS_TRIM - rmap_rxtx_auxpll_bias_trim[2:0]
 */
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_MASK)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_MASK      (0x8U)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_SHIFT     (3U)
/*! DIAGSEL1 - rmap_rxtx_auxpll_diagsel1
 */
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL1(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_MASK)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_MASK      (0x10U)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_SHIFT     (4U)
/*! DIAGSEL2 - rmap_rxtx_auxpll_diagsel2
 */
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL2(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_MASK)
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL_MASK       (0xE0U)
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL_SHIFT      (5U)
/*! LF_CNTL - rmap_rxtx_auxpll_lf_cntl[2:0]
 */
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_LF_CNTL_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_LF_CNTL_MASK)
#define XCVR_ANALOG_RX_AUXPLL_SPARE_MASK         (0xF00U)
#define XCVR_ANALOG_RX_AUXPLL_SPARE_SHIFT        (8U)
/*! SPARE - rmap_rxtx_auxpll_spare[3:0]
 */
#define XCVR_ANALOG_RX_AUXPLL_SPARE(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_SPARE_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_SPARE_MASK)
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_MASK (0xF000U)
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_SHIFT (12U)
/*! VCO_DAC_REF_ADJUST - rmap_rxtx_auxpll_vco_dac_ref_adjust[3:0]
 */
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_MASK)
#define XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_MASK (0x10000U)
#define XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_SHIFT (16U)
/*! VTUNE_TESTMODE - rmap_rxtx_auxpll_vtune_testmode
 */
#define XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_MASK)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_MASK (0x300000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_SHIFT (20U)
/*! RXTX_BAL_BIAST - rmap_rxtx_bal_biast[1:0]
 *  0b00..0.6
 *  0b01..0.4
 *  0b10..0.9
 *  0b11..1.2
 */
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_MASK)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_MASK (0x7000000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_SHIFT (24U)
/*! RXTX_BAL_SPARE - rmap_rxtx_bal_spare[2:0]
 */
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_MASK)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_MASK (0x10000000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_SHIFT (28U)
/*! RXTX_RCCAL_DIAGSEL - rmap_rxtx_rccal_diagsel
 */
#define XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_MASK)
/*! @} */

/*! @name SY_CTRL_1 - RF Analog Synthesizer Control 1 */
/*! @{ */
#define XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_MASK (0x1U)
#define XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_SHIFT (0U)
/*! SY_DIVN_SPARE - rmap_sy_divn_spare
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_MASK (0x2U)
#define XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_SHIFT (1U)
/*! SY_FCAL_SPARE - rmap_sy_fcal_spare
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_MASK (0x30U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_SHIFT (4U)
/*! SY_LO_BUMP_RTLO_FDBK - rmap_sy_lo_bump_rtlo_fdbk[1:0]
 *  0b00..1.045 V
 *  0b01..1.084 V
 *  0b10..1.097 V
 *  0b11..1.10 V
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_MASK (0xC0U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_SHIFT (6U)
/*! SY_LO_BUMP_RTLO_RX - rmap_sy_lo_bump_rtlo_rx[1:0]
 *  0b00..1.051/1.037 V
 *  0b01..1.082/1.075 V
 *  0b10..1.092/1.088 V
 *  0b11..1.098/1.094 V
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_MASK (0x300U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_SHIFT (8U)
/*! SY_LO_BUMP_RTLO_TX - rmap_sy_lo_bump_rtlo_tx[1:0]
 *  0b00..1.071/1.065 V
 *  0b01..1.092/1.090 V
 *  0b10..1.099/1.098 V
 *  0b11..1.10/1.1 V
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_MASK (0x400U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_SHIFT (10U)
/*! SY_LO_DIAGSEL - rmap_sy_lo_diagsel
 *  0b0..Diag disable
 *  0b1..Diag enable
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_MASK   (0x7000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_SHIFT  (12U)
/*! SY_LO_SPARE - rmap_sy_lo_spare[2:0]
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_MASK (0x70000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_SHIFT (16U)
/*! SY_LPF_FILT_CTRL - rmap_sy_lpf_filt_ctrl[2:0]
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_MASK  (0x80000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_SHIFT (19U)
/*! SY_LPF_SPARE - rmap_sy_lpf_spare
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_MASK (0x100000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_SHIFT (20U)
/*! SY_PD_DIAGSEL - rmap_sy_pd_diagsel
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_MASK (0x600000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_SHIFT (21U)
/*! SY_PD_PCH_TUNE - rmap_sy_pd_pch_tune[1:0]
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_MASK (0x800000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_SHIFT (23U)
/*! SY_PD_PCH_SEL - rmap_sy_pd_pch_sel
 *  0b0..inverter based precharge
 *  0b1..resistor divider based precharge
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_MASK   (0x3000000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_SHIFT  (24U)
/*! SY_PD_SPARE - rmap_sy_pd_spare[1:0]
 *  0b00..Default ;
 *  0b01..PD output is pulled down.
 */
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_MASK)
/*! @} */

/*! @name SY_CTRL_2 - RF Analog Synthesizer Control 2 */
/*! @{ */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_MASK   (0x7U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_SHIFT  (0U)
/*! SY_VCO_BIAS - rmap_sy_vco_bias[2:0]
 *  0b000..0.97V
 *  0b001..1.033V
 *  0b010..1.06V
 *  0b011..1.07V
 *  0b100..1.08V
 *  0b101..1.085V
 *  0b110..1.090V
 *  0b111..1.095V
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_MASK (0x8U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_SHIFT (3U)
/*! SY_VCO_DIAGSEL - rmap_sy_vco_diagsel
 *  0b1..Diag enable
 *  0b0..Diag disable
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_MASK     (0x70U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_SHIFT    (4U)
/*! SY_VCO_KV - rmap_sy_vco_kv[2:0]
 *  0b000..50MHz/V
 *  0b001..60MHz/V
 *  0b010..70MHz/V
 *  0b011..80MHz/V
 *  0b100..80MHz/V
 *  0b101..80MHz/V
 *  0b110..80MHz/V
 *  0b111..80MHz/V
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_MASK    (0x700U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_SHIFT   (8U)
/*! SY_VCO_KVM - rmap_sy_vco_kvm[2:0]
 *  0b000..10MHz/V
 *  0b001..20MHz/V
 *  0b010..30MHz/V
 *  0b011..40MHz/V
 *  0b100..40MHz/V
 *  0b101..40MHz/V
 *  0b110..40MHz/V
 *  0b111..40MHz/V
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_MASK (0x1000U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_SHIFT (12U)
/*! SY_VCO_PK_DET_ON - rmap_sy_vco_pk_det_on
 *  0b1..Enable
 *  0b0..Disable
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_MASK  (0x1C000U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_SHIFT (14U)
/*! SY_VCO_SPARE - rmap_sy_vco_spare[2:0]
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_DRS_MASK (0x7000000U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_DRS_SHIFT (24U)
/*! SY_VCO_KVM_DRS - rmap_sy_vco_kvm[2:0], for DataRate Switch
 *  0b000..10MHz/V
 *  0b001..20MHz/V
 *  0b010..30MHz/V
 *  0b011..40MHz/V
 *  0b100..40MHz/V
 *  0b101..40MHz/V
 *  0b110..40MHz/V
 *  0b111..40MHz/V
 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_DRS(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_DRS_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_DRS_MASK)
/*! @} */

/*! @name TX_DAC_PA - RF Analog TX HPM DAC and PA Control */
/*! @{ */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_MASK (0x3U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_SHIFT (0U)
/*! TX_DAC_BUMP_CAP - rmap_tx_dac_bump_cap[1:0]
 *  0b00..1pF(default)
 *  0b01..1.5pF
 *  0b10..1.5pF
 *  0b11..2pF
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_MASK (0x18U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_SHIFT (3U)
/*! TX_DAC_BUMP_IDAC - rmap_tx_dac_bump_idac[1:0]
 *  0b00..250nA(default)
 *  0b01..207nA
 *  0b10..312nA
 *  0b11..415nA
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_MASK (0xC0U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_SHIFT (6U)
/*! TX_DAC_BUMP_RLOAD - rmap_tx_dac_bump_rload[1:0]
 *  0b00..3.12 kohms(default)
 *  0b01..2.34 kohms
 *  0b10..3.9 kohms
 *  0b11..4.6 kohms
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_MASK (0x200U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_SHIFT (9U)
/*! TX_DAC_DIAGSEL - rmap_tx_dac_diagsel
 *  0b0..Disable Diag
 *  0b1..Enable Diag
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_MASK (0x400U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_SHIFT (10U)
/*! TX_DAC_INVERT_CLK - rmap_tx_dac_invert_clk
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_SHIFT (11U)
/*! TX_DAC_OPAMP_DIAGSEL - rmap_tx_dac_opamp_diagsel
 *  0b0..Disable Diag
 *  0b1..Enable Diag
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_MASK  (0xE000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_SHIFT (13U)
/*! TX_DAC_SPARE - rmap_tx_dac_spare[2:0]
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_MASK (0xE0000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_SHIFT (17U)
/*! TX_PA_BUMP_VBIAS - rmap_tx_pa_bump_vbias[2:0]
 *  0b000..0.557
 *  0b001..0.651
 *  0b010..0.741
 *  0b011..0.822
 *  0b100..0.590
 *  0b101..0.683
 *  0b110..0.771
 *  0b111..0.850
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_MASK (0x200000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_SHIFT (21U)
/*! TX_PA_DIAGSEL - rmap_tx_pa_diagsel
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_MASK   (0x3800000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_SHIFT  (23U)
/*! TX_PA_SPARE - rmap_tx_pa_spare[2:0]
 */
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group XCVR_ANALOG_Register_Masks */


/* XCVR_ANALOG - Peripheral instance base addresses */
/** Peripheral XCVR_ANALOG base address */
#define XCVR_ANALOG_BASE                         (0x40087500u)
/** Peripheral XCVR_ANALOG base pointer */
#define XCVR_ANALOG                              ((XCVR_ANALOG_Type *)XCVR_ANALOG_BASE)
/** Array initializer of XCVR_ANALOG peripheral base addresses */
#define XCVR_ANALOG_BASE_ADDRS                   { XCVR_ANALOG_BASE }
/** Array initializer of XCVR_ANALOG peripheral base pointers */
#define XCVR_ANALOG_BASE_PTRS                    { XCVR_ANALOG }

/*!
 * @}
 */ /* end of group XCVR_ANALOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- XCVR_MISC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_MISC_Peripheral_Access_Layer XCVR_MISC Peripheral Access Layer
 * @{
 */

/** XCVR_MISC - Register Layout Typedef */
typedef struct {
  __IO uint32_t XCVR_CTRL;                         /**< TRANSCEIVER CONTROL, offset: 0x0 */
  __IO uint32_t XCVR_STATUS;                       /**< TRANSCEIVER STATUS, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t OVERWRITE_VER;                     /**< OVERWRITE VERSION, offset: 0xC */
  __IO uint32_t RADIO_DFT;                         /**< Radio DFT REGISTER, offset: 0x10 */
  __IO uint32_t DMA_CTRL;                          /**< DMA CONTROL, offset: 0x14 */
  __IO uint32_t DBG_RAM_CTRL;                      /**< DBG RAM CONTROL, offset: 0x18 */
  __IO uint32_t DBG_RAM_ADDR;                      /**< DBG RAM ADDRESS, offset: 0x1C */
  __I  uint32_t DBG_RAM_STOP_ADDR;                 /**< DBG RAM STOP ADDRESS, offset: 0x20 */
  __IO uint32_t FAD_CTRL;                          /**< FAD CONTROL, offset: 0x24 */
       uint8_t RESERVED_1[4];
  __IO uint32_t COEX_CTRL;                         /**< COEXISTENCE CONTROL, offset: 0x2C */
  __IO uint32_t LCL_CFG0;                          /**< LOCALIZATION CONTROL CONFIG0, offset: 0x30 */
  __IO uint32_t LCL_CFG1;                          /**< LOCALIZATION CONTROL CONFIG1, offset: 0x34 */
  __IO uint32_t LCL_TX_CFG0;                       /**< LOCALIZATION CONTROL TX CONFIG0, offset: 0x38 */
  __IO uint32_t LCL_TX_CFG1;                       /**< LOCALIZATION CONTROL TX CONFIG1, offset: 0x3C */
  __IO uint32_t LCL_RX_CFG0;                       /**< LOCALIZATION CONTROL RX CONFIG0, offset: 0x40 */
  __IO uint32_t LCL_RX_CFG1;                       /**< LOCALIZATION CONTROL RX CONFIG1, offset: 0x44 */
  __IO uint32_t LCL_PM_MSB;                        /**< LOCALIZATION CONTROL PM MSB, offset: 0x48 */
  __IO uint32_t LCL_PM_LSB;                        /**< LOCALIZATION CONTROL PM LSB, offset: 0x4C */
  __IO uint32_t IPS_FO_ADDR[8];                    /**< IPS FAST OVERWRITE ADDRESS, array offset: 0x50, array step: 0x4 */
  __IO uint32_t IPS_FO_DRS0_DATA[8];               /**< IPS FAST OVERWRITE DRS0 DATA, array offset: 0x70, array step: 0x4 */
  __IO uint32_t IPS_FO_DRS1_DATA[8];               /**< IPS FAST OVERWRITE DRS1 DATA, array offset: 0x90, array step: 0x4 */
} XCVR_MISC_Type;

/* ----------------------------------------------------------------------------
   -- XCVR_MISC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_MISC_Register_Masks XCVR_MISC Register Masks
 * @{
 */

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
/*! @{ */
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_MASK    (0x7U)
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_SHIFT   (0U)
/*! TX_DATA_RATE - Radio data rate setting
 *  0b000..2Mbps
 *  0b001..1Mbps
 *  0b010..500Kbps
 *  0b011..250Kbps
 */
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_SHIFT)) & XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_MASK)
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_DRS_MASK (0x70U)
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_DRS_SHIFT (4U)
/*! TX_DATA_RATE_DRS - Radio data rate setting, Data Rate Switch
 *  0b000..2Mbps
 *  0b001..1Mbps
 *  0b010..500Kbps
 *  0b011..250Kbps
 */
#define XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_DRS(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_DRS_SHIFT)) & XCVR_MISC_XCVR_CTRL_TX_DATA_RATE_DRS_MASK)
#define XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_MASK    (0x300U)
#define XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_SHIFT   (8U)
/*! REF_CLK_FREQ - Radio Reference Clock Frequency
 *  0b00..32 MHz
 *  0b01..26 MHz
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_SHIFT)) & XCVR_MISC_XCVR_CTRL_REF_CLK_FREQ_MASK)
#define XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_MASK (0x800U)
#define XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_SHIFT (11U)
/*! SOC_RF_OSC_CLK_GATE_EN - SOC_RF_OSC_CLK_GATE_EN
 */
#define XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_SHIFT)) & XCVR_MISC_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_MASK)
#define XCVR_MISC_XCVR_CTRL_FO_RX_EN_MASK        (0x4000U)
#define XCVR_MISC_XCVR_CTRL_FO_RX_EN_SHIFT       (14U)
/*! FO_RX_EN - Fast Overwrite RX Enable
 */
#define XCVR_MISC_XCVR_CTRL_FO_RX_EN(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_FO_RX_EN_SHIFT)) & XCVR_MISC_XCVR_CTRL_FO_RX_EN_MASK)
#define XCVR_MISC_XCVR_CTRL_FO_TX_EN_MASK        (0x8000U)
#define XCVR_MISC_XCVR_CTRL_FO_TX_EN_SHIFT       (15U)
/*! FO_TX_EN - Fast Overwrite TX Enable
 */
#define XCVR_MISC_XCVR_CTRL_FO_TX_EN(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_FO_TX_EN_SHIFT)) & XCVR_MISC_XCVR_CTRL_FO_TX_EN_MASK)
#define XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_MASK  (0x70000U)
#define XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_SHIFT (16U)
/*! RADIO0_IRQ_SEL - RADIO0_IRQ_SEL
 *  0b000..Assign Radio #0 Interrupt to Bluetooth LE
 *  0b001..Radio #0 Interrupt unassigned
 *  0b010..Radio #0 Interrupt unassigned
 *  0b011..Assign Radio #0 Interrupt to GENERIC_FSK
 *  0b100..Radio #0 Interrupt unassigned
 *  0b101..Radio #0 Interrupt unassigned
 *  0b110..Radio #0 Interrupt unassigned
 *  0b111..Radio #0 Interrupt unassigned
 */
#define XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_SHIFT)) & XCVR_MISC_XCVR_CTRL_RADIO0_IRQ_SEL_MASK)
#define XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_MASK  (0x700000U)
#define XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_SHIFT (20U)
/*! RADIO1_IRQ_SEL - RADIO1_IRQ_SEL
 *  0b000..Assign Radio #1 Interrupt to Bluetooth LE
 *  0b001..Radio #1 Interrupt unassigned
 *  0b010..Radio #1 Interrupt unassigned
 *  0b011..Assign Radio #1 Interrupt to GENERIC_FSK
 *  0b100..Radio #1 Interrupt unassigned
 *  0b101..Radio #1 Interrupt unassigned
 *  0b110..Radio #1 Interrupt unassigned
 *  0b111..Radio #1 Interrupt unassigned
 */
#define XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_SHIFT)) & XCVR_MISC_XCVR_CTRL_RADIO1_IRQ_SEL_MASK)
#define XCVR_MISC_XCVR_CTRL_TSM_LL_INHIBIT_MASK  (0xF000000U)
#define XCVR_MISC_XCVR_CTRL_TSM_LL_INHIBIT_SHIFT (24U)
/*! TSM_LL_INHIBIT - TSM Per-Link-Layer Inhibit
 */
#define XCVR_MISC_XCVR_CTRL_TSM_LL_INHIBIT(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_TSM_LL_INHIBIT_SHIFT)) & XCVR_MISC_XCVR_CTRL_TSM_LL_INHIBIT_MASK)
#define XCVR_MISC_XCVR_CTRL_TOF_RX_SEL_MASK      (0x10000000U)
#define XCVR_MISC_XCVR_CTRL_TOF_RX_SEL_SHIFT     (28U)
/*! TOF_RX_SEL - Time-of-Flight RX Select
 *  0b0..PHY: aa_fnd_to_ll
 *  0b1..Localization Control: pattern_found
 */
#define XCVR_MISC_XCVR_CTRL_TOF_RX_SEL(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_TOF_RX_SEL_SHIFT)) & XCVR_MISC_XCVR_CTRL_TOF_RX_SEL_MASK)
#define XCVR_MISC_XCVR_CTRL_TOF_TX_SEL_MASK      (0x20000000U)
#define XCVR_MISC_XCVR_CTRL_TOF_TX_SEL_SHIFT     (29U)
/*! TOF_TX_SEL - Time-of-Flight TX Select
 *  0b0..TSM: tx_dig_en
 *  0b1..TXDIG: pa_wu_complete
 */
#define XCVR_MISC_XCVR_CTRL_TOF_TX_SEL(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_TOF_TX_SEL_SHIFT)) & XCVR_MISC_XCVR_CTRL_TOF_TX_SEL_MASK)
#define XCVR_MISC_XCVR_CTRL_LL_CFG_CAPT_DIS_MASK (0x40000000U)
#define XCVR_MISC_XCVR_CTRL_LL_CFG_CAPT_DIS_SHIFT (30U)
/*! LL_CFG_CAPT_DIS - Link Layer Configuration Capture Disable
 *  0b0..Enabled. Link Layer configuration inputs are captured.
 *  0b1..Disabled: Link Layer configurations are not captured.
 */
#define XCVR_MISC_XCVR_CTRL_LL_CFG_CAPT_DIS(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_CTRL_LL_CFG_CAPT_DIS_SHIFT)) & XCVR_MISC_XCVR_CTRL_LL_CFG_CAPT_DIS_MASK)
/*! @} */

/*! @name XCVR_STATUS - TRANSCEIVER STATUS */
/*! @{ */
#define XCVR_MISC_XCVR_STATUS_TSM_COUNT_MASK     (0xFFU)
#define XCVR_MISC_XCVR_STATUS_TSM_COUNT_SHIFT    (0U)
/*! TSM_COUNT - TSM_COUNT
 */
#define XCVR_MISC_XCVR_STATUS_TSM_COUNT(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_TSM_COUNT_SHIFT)) & XCVR_MISC_XCVR_STATUS_TSM_COUNT_MASK)
#define XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_MASK (0xF00U)
#define XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_SHIFT (8U)
/*! PLL_SEQ_STATE - PLL Sequence State
 *  0b0000..PLL OFF
 *  0b0010..CTUNE
 *  0b0011..CTUNE_SETTLE
 *  0b0110..HPMCAL1
 *  0b1000..HPMCAL1_SETTLE
 *  0b1010..HPMCAL2
 *  0b1100..HPMCAL2_SETTLE
 *  0b1111..PLLREADY
 */
#define XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_SHIFT)) & XCVR_MISC_XCVR_STATUS_PLL_SEQ_STATE_MASK)
#define XCVR_MISC_XCVR_STATUS_RX_MODE_MASK       (0x1000U)
#define XCVR_MISC_XCVR_STATUS_RX_MODE_SHIFT      (12U)
/*! RX_MODE - Receive Mode
 */
#define XCVR_MISC_XCVR_STATUS_RX_MODE(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_RX_MODE_SHIFT)) & XCVR_MISC_XCVR_STATUS_RX_MODE_MASK)
#define XCVR_MISC_XCVR_STATUS_TX_MODE_MASK       (0x2000U)
#define XCVR_MISC_XCVR_STATUS_TX_MODE_SHIFT      (13U)
/*! TX_MODE - Transmit Mode
 */
#define XCVR_MISC_XCVR_STATUS_TX_MODE(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_TX_MODE_SHIFT)) & XCVR_MISC_XCVR_STATUS_TX_MODE_MASK)
#define XCVR_MISC_XCVR_STATUS_XTAL_READY_MASK    (0x40000U)
#define XCVR_MISC_XCVR_STATUS_XTAL_READY_SHIFT   (18U)
/*! XTAL_READY - RF Osciallator Xtal Ready
 *  0b0..Indicates that the RF Oscillator is disabled or has not completed its warmup.
 *  0b1..Indicates that the RF Oscillator has completed its warmup count and is ready for use.
 */
#define XCVR_MISC_XCVR_STATUS_XTAL_READY(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_XTAL_READY_SHIFT)) & XCVR_MISC_XCVR_STATUS_XTAL_READY_MASK)
#define XCVR_MISC_XCVR_STATUS_XCVR_BUSY_MASK     (0x100000U)
#define XCVR_MISC_XCVR_STATUS_XCVR_BUSY_SHIFT    (20U)
/*! XCVR_BUSY - Transceiver Busy Status Bit
 *  0b0..RF Channel in available (TSM is idle)
 *  0b1..RF Channel in use (TSM is busy)
 */
#define XCVR_MISC_XCVR_STATUS_XCVR_BUSY(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_XCVR_BUSY_SHIFT)) & XCVR_MISC_XCVR_STATUS_XCVR_BUSY_MASK)
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ0_MASK      (0x1000000U)
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ0_SHIFT     (24U)
/*! TSM_IRQ0 - TSM Interrupt #0
 *  0b0..TSM Interrupt #0 is not asserted.
 *  0b1..TSM Interrupt #0 is asserted. Write '1' to this bit to clear it.
 */
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ0(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_TSM_IRQ0_SHIFT)) & XCVR_MISC_XCVR_STATUS_TSM_IRQ0_MASK)
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ1_MASK      (0x2000000U)
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ1_SHIFT     (25U)
/*! TSM_IRQ1 - TSM Interrupt #1
 *  0b0..TSM Interrupt #1 is not asserted.
 *  0b1..TSM Interrupt #1 is asserted. Write '1' to this bit to clear it.
 */
#define XCVR_MISC_XCVR_STATUS_TSM_IRQ1(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_XCVR_STATUS_TSM_IRQ1_SHIFT)) & XCVR_MISC_XCVR_STATUS_TSM_IRQ1_MASK)
/*! @} */

/*! @name OVERWRITE_VER - OVERWRITE VERSION */
/*! @{ */
#define XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_MASK (0xFFU)
#define XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_SHIFT (0U)
/*! OVERWRITE_VER - Overwrite Version Number.
 */
#define XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_SHIFT)) & XCVR_MISC_OVERWRITE_VER_OVERWRITE_VER_MASK)
/*! @} */

/*! @name RADIO_DFT - Radio DFT REGISTER */
/*! @{ */
#define XCVR_MISC_RADIO_DFT_RADIO_DFT_MODE_MASK  (0xFU)
#define XCVR_MISC_RADIO_DFT_RADIO_DFT_MODE_SHIFT (0U)
/*! RADIO_DFT_MODE - Radio DFT modes
 *  0b0000..Normal Radio Operation, DFT not engaged.
 *  0b0001..Carrier Only
 *  0b0010..Pattern Register GFSK
 *  0b0011..LFSR
 *  0b0100..RAM Modulation
 *  0b0101..Reserved
 *  0b0110..Reserved
 *  0b0111..Reserved
 *  0b1000..Reserved
 *  0b1001..Reserved
 *  0b1010..PLL Coarse Tune BIST
 *  0b1011..PLL Frequency Synthesizer BIST
 *  0b1100..High Port DAC BIST
 *  0b1101..VCO Frequency Meter
 *  0b1110..Reserved
 *  0b1111..Reserved
 */
#define XCVR_MISC_RADIO_DFT_RADIO_DFT_MODE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_RADIO_DFT_RADIO_DFT_MODE_SHIFT)) & XCVR_MISC_RADIO_DFT_RADIO_DFT_MODE_MASK)
#define XCVR_MISC_RADIO_DFT_SOC_TEST_SEL_MASK    (0x30U)
#define XCVR_MISC_RADIO_DFT_SOC_TEST_SEL_SHIFT   (4U)
/*! SOC_TEST_SEL - Radio Clock Selector for SoC RF Clock Tests
 *  0b00..No Clock Selected
 *  0b01..PLL Sigma Delta Clock, divided by 2
 *  0b10..Auxiliary PLL Clock, divided by 2
 *  0b11..RF Ref Osc clock, divided by 2
 */
#define XCVR_MISC_RADIO_DFT_SOC_TEST_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_RADIO_DFT_SOC_TEST_SEL_SHIFT)) & XCVR_MISC_RADIO_DFT_SOC_TEST_SEL_MASK)
/*! @} */

/*! @name DMA_CTRL - DMA CONTROL */
/*! @{ */
#define XCVR_MISC_DMA_CTRL_DMA_PAGE_MASK         (0xFU)
#define XCVR_MISC_DMA_CTRL_DMA_PAGE_SHIFT        (0U)
/*! DMA_PAGE - Transceiver DMA Page Selector
 *  0b0000..DMA idle
 *  0b0001..RXDIG-IQ
 *  0b0010..RXDIG-IQ-ALT
 *  0b0011..ADC-IQ
 *  0b0100..DCEST-IQ
 *  0b0101..PHASE
 *  0b0110..RSSI-PHASE
 *  0b0111..MAG-PHASE
 *  0b1000..PHY
 *  0b1001..DETERMINISTIC
 */
#define XCVR_MISC_DMA_CTRL_DMA_PAGE(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_PAGE_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_PAGE_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_START_TRG_MASK    (0xF0U)
#define XCVR_MISC_DMA_CTRL_DMA_START_TRG_SHIFT   (4U)
/*! DMA_START_TRG - DMA Start Trigger Selector
 *  0b0000..no trigger
 *  0b0001..PHY: pd found
 *  0b0010..PHY: aa found
 *  0b0011..Reserved
 *  0b0100..Reserved
 *  0b0101..RXDIG: agc_dcoc_gain_chg
 *  0b0110..TSM: rx_dig_en
 *  0b0111..TSM: tsm_spare2_en
 *  0b1000..RBME: crc_pass
 *  0b1001..RBME: crc_vld
 *  0b1010..Localization control: dma_capt_trig
 *  0b1011..GenericLL: cte_present
 */
#define XCVR_MISC_DMA_CTRL_DMA_START_TRG(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_START_TRG_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_START_TRG_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_START_EDGE_MASK   (0x100U)
#define XCVR_MISC_DMA_CTRL_DMA_START_EDGE_SHIFT  (8U)
/*! DMA_START_EDGE - DMA Start Trigger Edge Selector
 *  0b0..Trigger fires on a rising edge of the selected trigger source
 *  0b1..Trigger fires on a falling edge of the selected trigger source
 */
#define XCVR_MISC_DMA_CTRL_DMA_START_EDGE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_START_EDGE_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_START_EDGE_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_DEC_MASK          (0xC00U)
#define XCVR_MISC_DMA_CTRL_DMA_DEC_SHIFT         (10U)
/*! DMA_DEC - DMA Decimation Rate
 *  0b00..Data is captured on every data valid
 *  0b01..Data is captured on every 2nd data valid
 *  0b10..Data is captured on everey 4th data valid
 *  0b11..Data is captured on every 8th data valid
 */
#define XCVR_MISC_DMA_CTRL_DMA_DEC(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_DEC_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_DEC_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_START_DLY_MASK    (0x7FF000U)
#define XCVR_MISC_DMA_CTRL_DMA_START_DLY_SHIFT   (12U)
/*! DMA_START_DLY - DMA Start Trigger Delay
 */
#define XCVR_MISC_DMA_CTRL_DMA_START_DLY(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_START_DLY_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_START_DLY_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_EN_MASK           (0x800000U)
#define XCVR_MISC_DMA_CTRL_DMA_EN_SHIFT          (23U)
/*! DMA_EN - DMA Enable
 */
#define XCVR_MISC_DMA_CTRL_DMA_EN(x)             (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_EN_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_EN_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_AA_TRIGGERED_MASK (0x1000000U)
#define XCVR_MISC_DMA_CTRL_DMA_AA_TRIGGERED_SHIFT (24U)
/*! DMA_AA_TRIGGERED - DMA Access Address triggered
 */
#define XCVR_MISC_DMA_CTRL_DMA_AA_TRIGGERED(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_AA_TRIGGERED_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_AA_TRIGGERED_MASK)
#define XCVR_MISC_DMA_CTRL_DMA_START_TRIGGERED_MASK (0x2000000U)
#define XCVR_MISC_DMA_CTRL_DMA_START_TRIGGERED_SHIFT (25U)
/*! DMA_START_TRIGGERED - DMA Start Trigger Occurred
 */
#define XCVR_MISC_DMA_CTRL_DMA_START_TRIGGERED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DMA_CTRL_DMA_START_TRIGGERED_SHIFT)) & XCVR_MISC_DMA_CTRL_DMA_START_TRIGGERED_MASK)
/*! @} */

/*! @name DBG_RAM_CTRL - DBG RAM CONTROL */
/*! @{ */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_PAGE_MASK     (0xFU)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_PAGE_SHIFT    (0U)
/*! DBG_PAGE - Packet RAM Debug DMA Page Selector
 *  0b0000..DMA idle
 *  0b0001..RXDIG-IQ
 *  0b0010..RXDIG-IQ-ALT
 *  0b0011..ADC-IQ
 *  0b0100..DCEST-IQ
 *  0b0101..PHASE
 *  0b0110..RSSI-PHASE
 *  0b0111..MAG-PHASE
 *  0b1000..PHY
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_PAGE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_PAGE_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_PAGE_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRG_MASK (0xF0U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRG_SHIFT (4U)
/*! DBG_START_TRG - Packet RAM Debug Start Trigger Selector
 *  0b0000..no trigger
 *  0b0001..PHY: pd found
 *  0b0010..PHY: aa found
 *  0b0011..Reserved
 *  0b0100..Reserved
 *  0b0101..RXDIG: agc_dcoc_gain_chg
 *  0b0110..TSM: rx_dig_en
 *  0b0111..TSM: tsm_spare2_en
 *  0b1000..RBME: crc_pass
 *  0b1001..RBME: crc_vld
 *  0b1010..Localization control: dma_capt_trig
 *  0b1011..GenericLL: cte_present
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRG(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRG_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRG_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_EDGE_MASK (0x100U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_EDGE_SHIFT (8U)
/*! DBG_START_EDGE - Packet RAM Debug Start Trigger Edge Selector
 *  0b0..Trigger fires on a rising edge of the selected trigger source
 *  0b1..Trigger fires on a falling edge of the selected trigger source
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_EDGE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_START_EDGE_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_START_EDGE_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_EDGE_MASK (0x200U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_EDGE_SHIFT (9U)
/*! DBG_STOP_EDGE - Packet RAM Debug Stop Trigger Edge Selector
 *  0b0..Trigger fires on a rising edge of the selected trigger source
 *  0b1..Trigger fires on a falling edge of the selected trigger source
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_EDGE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_EDGE_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_EDGE_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_DEC_MASK      (0xC00U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_DEC_SHIFT     (10U)
/*! DBG_DEC - DBG Decimation Rate
 *  0b00..Data is captured on every data valid
 *  0b01..Data is captured on every 2nd data valid
 *  0b10..Data is captured on everey 4th data valid
 *  0b11..Data is captured on every 8th data valid
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_DEC(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_DEC_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_DEC_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_DLY_MASK (0x7FF000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_DLY_SHIFT (12U)
/*! DBG_START_DLY - DBG Start Trigger Delay
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_DLY(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_START_DLY_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_START_DLY_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_EN_MASK       (0x800000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_EN_SHIFT      (23U)
/*! DBG_EN - Packet RAM Debug Mode Enable
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_EN(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_EN_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_EN_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_AA_TRIGGERED_MASK (0x1000000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_AA_TRIGGERED_SHIFT (24U)
/*! DBG_AA_TRIGGERED - Packet Ram Debug Access Address triggered
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_AA_TRIGGERED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_AA_TRIGGERED_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_AA_TRIGGERED_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRIGGERED_MASK (0x2000000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRIGGERED_SHIFT (25U)
/*! DBG_START_TRIGGERED - Packet RAM Debug Start Triggered
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRIGGERED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRIGGERED_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_START_TRIGGERED_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRIGGERED_MASK (0x4000000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRIGGERED_SHIFT (26U)
/*! DBG_STOP_TRIGGERED - Packet RAM Debug Stop Triggered
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRIGGERED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRIGGERED_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRIGGERED_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_RAM_FULL_MASK (0x8000000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_RAM_FULL_SHIFT (27U)
/*! DBG_RAM_FULL - DBG_RAM_FULL
 *  0b0..Packet RAM is not full
 *  0b1..Packet RAM is full
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_RAM_FULL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_RAM_FULL_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_RAM_FULL_MASK)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRG_MASK (0xF0000000U)
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRG_SHIFT (28U)
/*! DBG_STOP_TRG - Packet RAM Debug Stop Trigger Selector
 *  0b0000..no trigger
 *  0b0001..PHY: pd found
 *  0b0010..PHY: aa found
 *  0b0011..Reserved
 *  0b0100..Reserved
 *  0b0101..RXDIG: agc_dcoc_gain_chg
 *  0b0110..TSM: rx_dig_en
 *  0b0111..TSM: tsm_spare3_en
 *  0b1000..RBME: crc_fail
 *  0b1001..RBME: crc_vld
 *  0b1010..RBME: error
 *  0b1011..Generic header fail
 *  0b1100..PLL unlock
 *  0b1101..Bluetooth LE crc_err_count_incr
 */
#define XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRG(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRG_SHIFT)) & XCVR_MISC_DBG_RAM_CTRL_DBG_STOP_TRG_MASK)
/*! @} */

/*! @name DBG_RAM_ADDR - DBG RAM ADDRESS */
/*! @{ */
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_FIRST_MASK (0x7FFFU)
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_FIRST_SHIFT (0U)
/*! DBG_RAM_FIRST - DBG RAM First Address
 */
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_FIRST(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_FIRST_SHIFT)) & XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_FIRST_MASK)
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_LAST_MASK (0x7FFF0000U)
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_LAST_SHIFT (16U)
/*! DBG_RAM_LAST - DBG RAM Last Address
 */
#define XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_LAST(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_LAST_SHIFT)) & XCVR_MISC_DBG_RAM_ADDR_DBG_RAM_LAST_MASK)
/*! @} */

/*! @name DBG_RAM_STOP_ADDR - DBG RAM STOP ADDRESS */
/*! @{ */
#define XCVR_MISC_DBG_RAM_STOP_ADDR_DBG_RAM_STOP_MASK (0x7FFFU)
#define XCVR_MISC_DBG_RAM_STOP_ADDR_DBG_RAM_STOP_SHIFT (0U)
/*! DBG_RAM_STOP - DBG RAM Stop Address
 */
#define XCVR_MISC_DBG_RAM_STOP_ADDR_DBG_RAM_STOP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_DBG_RAM_STOP_ADDR_DBG_RAM_STOP_SHIFT)) & XCVR_MISC_DBG_RAM_STOP_ADDR_DBG_RAM_STOP_MASK)
/*! @} */

/*! @name FAD_CTRL - FAD CONTROL */
/*! @{ */
#define XCVR_MISC_FAD_CTRL_ANTX_MASK             (0x2U)
#define XCVR_MISC_FAD_CTRL_ANTX_SHIFT            (1U)
/*! ANTX - Antenna Selection State
 */
#define XCVR_MISC_FAD_CTRL_ANTX(x)               (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD_EN_MASK     (0x4U)
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD_EN_SHIFT    (2U)
/*! ANTX_OVRD_EN - Antenna State Override Enable
 */
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD_EN(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_OVRD_EN_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_OVRD_EN_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD_MASK        (0x8U)
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD_SHIFT       (3U)
/*! ANTX_OVRD - Antenna State Override Value
 */
#define XCVR_MISC_FAD_CTRL_ANTX_OVRD(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_OVRD_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_OVRD_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_EN_MASK          (0x30U)
#define XCVR_MISC_FAD_CTRL_ANTX_EN_SHIFT         (4U)
/*! ANTX_EN - FAD Antenna Controls Enable
 *  0b00..all disabled (held low)
 *  0b01..only RX/TX_SWITCH enabled
 *  0b10..only ANT_A/B enabled
 *  0b11..all enabled
 */
#define XCVR_MISC_FAD_CTRL_ANTX_EN(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_EN_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_EN_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_HZ_MASK          (0x40U)
#define XCVR_MISC_FAD_CTRL_ANTX_HZ_SHIFT         (6U)
/*! ANTX_HZ - FAD PAD Tristate Control
 *  0b0..ANT_A, ANT_B, RX_SWITCH and TX_SWITCH are actively driven outputs.
 *  0b1..Antenna controls high impedance- Set ANT_A, ANT_B, RX_SWITCH and TX_SWITCH in high impedance.
 */
#define XCVR_MISC_FAD_CTRL_ANTX_HZ(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_HZ_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_HZ_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_MASK    (0x80U)
#define XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_SHIFT   (7U)
/*! ANTX_CTRLMODE - Antenna Diversity Control Mode
 */
#define XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_CTRLMODE_MASK)
#define XCVR_MISC_FAD_CTRL_ANTX_POL_MASK         (0xF00U)
#define XCVR_MISC_FAD_CTRL_ANTX_POL_SHIFT        (8U)
/*! ANTX_POL - FAD Antenna Controls Polarity
 */
#define XCVR_MISC_FAD_CTRL_ANTX_POL(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_ANTX_POL_SHIFT)) & XCVR_MISC_FAD_CTRL_ANTX_POL_MASK)
#define XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_MASK     (0xF000U)
#define XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_SHIFT    (12U)
/*! FAD_NOT_GPIO - FAD versus GPIO Mode Selector
 */
#define XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_SHIFT)) & XCVR_MISC_FAD_CTRL_FAD_NOT_GPIO_MASK)
/*! @} */

/*! @name COEX_CTRL - COEXISTENCE CONTROL */
/*! @{ */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_EN_MASK (0xFU)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_EN_SHIFT (0U)
/*! RF_NOT_ALLOWED_EN - RF_NOT_ALLOWED PER-LINK-LAYER ENABLE
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_EN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_EN_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_EN_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_TX_MASK (0x10U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_TX_SHIFT (4U)
/*! RF_NOT_ALLOWED_NO_TX - RF_NOT_ALLOWED_NO_TX
 *  0b0..Assertion on RF_NOT_ALLOWED has no effect on TX
 *  0b1..Assertion on RF_NOT_ALLOWED can abort TX
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_TX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_TX_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_TX_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_RX_MASK (0x20U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_RX_SHIFT (5U)
/*! RF_NOT_ALLOWED_NO_RX - RF_NOT_ALLOWED_NO_RX
 *  0b0..Assertion on RF_NOT_ALLOWED has no effect on RX
 *  0b1..Assertion on RF_NOT_ALLOWED can abort RX
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_RX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_RX_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_NO_RX_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_ASSERTED_MASK (0x40U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_ASSERTED_SHIFT (6U)
/*! RF_NOT_ALLOWED_ASSERTED - RF_NOT_ALLOWED_ASSERTED
 *  0b0..Assertion on RF_NOT_ALLOWED has not occurred
 *  0b1..Assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_ASSERTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_ASSERTED_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_ASSERTED_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_TX_ABORT_MASK (0x80U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_TX_ABORT_SHIFT (7U)
/*! RF_NOT_ALLOWED_TX_ABORT - RF_NOT_ALLOWED_TX_ABORT
 *  0b0..A TX abort due to assertion on RF_NOT_ALLOWED has not occurred
 *  0b1..A TX abort due to assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_TX_ABORT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_TX_ABORT_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_TX_ABORT_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_RX_ABORT_MASK (0x100U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_RX_ABORT_SHIFT (8U)
/*! RF_NOT_ALLOWED_RX_ABORT - RF_NOT_ALLOWED_RX_ABORT
 *  0b0..A RX abort due to assertion on RF_NOT_ALLOWED has not occurred
 *  0b1..A RX abort due to assertion on RF_NOT_ALLOWED has occurred since the last time this bit was cleared
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_RX_ABORT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_RX_ABORT_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_RX_ABORT_MASK)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_MASK  (0x200U)
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_SHIFT (9U)
/*! RF_NOT_ALLOWED - RF_NOT_ALLOWED
 */
#define XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_SHIFT)) & XCVR_MISC_COEX_CTRL_RF_NOT_ALLOWED_MASK)
#define XCVR_MISC_COEX_CTRL_TSM_SPARE1_EXTEND_MASK (0xFF0000U)
#define XCVR_MISC_COEX_CTRL_TSM_SPARE1_EXTEND_SHIFT (16U)
/*! TSM_SPARE1_EXTEND - TSM_SPARE1_EX Extension Duration
 */
#define XCVR_MISC_COEX_CTRL_TSM_SPARE1_EXTEND(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_COEX_CTRL_TSM_SPARE1_EXTEND_SHIFT)) & XCVR_MISC_COEX_CTRL_TSM_SPARE1_EXTEND_MASK)
/*! @} */

/*! @name LCL_CFG0 - LOCALIZATION CONTROL CONFIG0 */
/*! @{ */
#define XCVR_MISC_LCL_CFG0_LCL_EN_MASK           (0x1U)
#define XCVR_MISC_LCL_CFG0_LCL_EN_SHIFT          (0U)
/*! LCL_EN - Localization Control Module Enable
 */
#define XCVR_MISC_LCL_CFG0_LCL_EN(x)             (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_LCL_EN_SHIFT)) & XCVR_MISC_LCL_CFG0_LCL_EN_MASK)
#define XCVR_MISC_LCL_CFG0_TX_LCL_EN_MASK        (0x2U)
#define XCVR_MISC_LCL_CFG0_TX_LCL_EN_SHIFT       (1U)
/*! TX_LCL_EN - Enable Switching in TX
 */
#define XCVR_MISC_LCL_CFG0_TX_LCL_EN(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_TX_LCL_EN_SHIFT)) & XCVR_MISC_LCL_CFG0_TX_LCL_EN_MASK)
#define XCVR_MISC_LCL_CFG0_RX_LCL_EN_MASK        (0x4U)
#define XCVR_MISC_LCL_CFG0_RX_LCL_EN_SHIFT       (2U)
/*! RX_LCL_EN - Enable Switching in RX
 */
#define XCVR_MISC_LCL_CFG0_RX_LCL_EN(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_RX_LCL_EN_SHIFT)) & XCVR_MISC_LCL_CFG0_RX_LCL_EN_MASK)
#define XCVR_MISC_LCL_CFG0_LANT_INV_MASK         (0x8U)
#define XCVR_MISC_LCL_CFG0_LANT_INV_SHIFT        (3U)
/*! LANT_INV - Invert Antenna Switch Output
 */
#define XCVR_MISC_LCL_CFG0_LANT_INV(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_LANT_INV_SHIFT)) & XCVR_MISC_LCL_CFG0_LANT_INV_MASK)
#define XCVR_MISC_LCL_CFG0_COMP_EN_MASK          (0x10U)
#define XCVR_MISC_LCL_CFG0_COMP_EN_SHIFT         (4U)
/*! COMP_EN - Pattern Matching Enable
 */
#define XCVR_MISC_LCL_CFG0_COMP_EN(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_COMP_EN_SHIFT)) & XCVR_MISC_LCL_CFG0_COMP_EN_MASK)
#define XCVR_MISC_LCL_CFG0_COMP_TX_EN_MASK       (0x20U)
#define XCVR_MISC_LCL_CFG0_COMP_TX_EN_SHIFT      (5U)
/*! COMP_TX_EN - Pattern Matching Enable in TX
 */
#define XCVR_MISC_LCL_CFG0_COMP_TX_EN(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_COMP_TX_EN_SHIFT)) & XCVR_MISC_LCL_CFG0_COMP_TX_EN_MASK)
#define XCVR_MISC_LCL_CFG0_SW_TRIG_MASK          (0x40U)
#define XCVR_MISC_LCL_CFG0_SW_TRIG_SHIFT         (6U)
/*! SW_TRIG - Software Trigger. Can be used with either RX or TX
 */
#define XCVR_MISC_LCL_CFG0_SW_TRIG(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_SW_TRIG_SHIFT)) & XCVR_MISC_LCL_CFG0_SW_TRIG_MASK)
#define XCVR_MISC_LCL_CFG0_LANT_SW_WIGGLE_MASK   (0x80U)
#define XCVR_MISC_LCL_CFG0_LANT_SW_WIGGLE_SHIFT  (7U)
/*! LANT_SW_WIGGLE - LANT_SW Wiggle
 */
#define XCVR_MISC_LCL_CFG0_LANT_SW_WIGGLE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_LANT_SW_WIGGLE_SHIFT)) & XCVR_MISC_LCL_CFG0_LANT_SW_WIGGLE_MASK)
#define XCVR_MISC_LCL_CFG0_PM_NUM_BYTES_MASK     (0x300U)
#define XCVR_MISC_LCL_CFG0_PM_NUM_BYTES_SHIFT    (8U)
/*! PM_NUM_BYTES - Number of Bytes to Match
 *  0b00..4 bytes
 *  0b01..5 bytes
 *  0b10..6 bytes
 *  0b11..8 bytes
 */
#define XCVR_MISC_LCL_CFG0_PM_NUM_BYTES(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_PM_NUM_BYTES_SHIFT)) & XCVR_MISC_LCL_CFG0_PM_NUM_BYTES_MASK)
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_TX_MASK    (0x400U)
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_TX_SHIFT   (10U)
/*! LANT_BLOCK_TX - Block LANT_SW for TX
 */
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_TX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_LANT_BLOCK_TX_SHIFT)) & XCVR_MISC_LCL_CFG0_LANT_BLOCK_TX_MASK)
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_RX_MASK    (0x800U)
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_RX_SHIFT   (11U)
/*! LANT_BLOCK_RX - Block LANT_SW for RX
 */
#define XCVR_MISC_LCL_CFG0_LANT_BLOCK_RX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_LANT_BLOCK_RX_SHIFT)) & XCVR_MISC_LCL_CFG0_LANT_BLOCK_RX_MASK)
#define XCVR_MISC_LCL_CFG0_CTE_DUR_MASK          (0x1FF0000U)
#define XCVR_MISC_LCL_CFG0_CTE_DUR_SHIFT         (16U)
/*! CTE_DUR - Total Switching Duration
 */
#define XCVR_MISC_LCL_CFG0_CTE_DUR(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG0_CTE_DUR_SHIFT)) & XCVR_MISC_LCL_CFG0_CTE_DUR_MASK)
/*! @} */

/*! @name LCL_CFG1 - LOCALIZATION CONTROL CONFIG1 */
/*! @{ */
#define XCVR_MISC_LCL_CFG1_M_ON_DELAY_MASK       (0x3FFU)
#define XCVR_MISC_LCL_CFG1_M_ON_DELAY_SHIFT      (0U)
/*! M_ON_DELAY - M on Delay
 */
#define XCVR_MISC_LCL_CFG1_M_ON_DELAY(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG1_M_ON_DELAY_SHIFT)) & XCVR_MISC_LCL_CFG1_M_ON_DELAY_MASK)
#define XCVR_MISC_LCL_CFG1_N_ON_DELAY_MASK       (0xF000U)
#define XCVR_MISC_LCL_CFG1_N_ON_DELAY_SHIFT      (12U)
/*! N_ON_DELAY - N on Delay
 */
#define XCVR_MISC_LCL_CFG1_N_ON_DELAY(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_CFG1_N_ON_DELAY_SHIFT)) & XCVR_MISC_LCL_CFG1_N_ON_DELAY_MASK)
/*! @} */

/*! @name LCL_TX_CFG0 - LOCALIZATION CONTROL TX CONFIG0 */
/*! @{ */
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY_MASK      (0x7FFU)
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY_SHIFT     (0U)
/*! TX_DELAY - Interval delay before TX switching begins.
 */
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG0_TX_DELAY_SHIFT)) & XCVR_MISC_LCL_TX_CFG0_TX_DELAY_MASK)
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY_OFF_MASK  (0x1F0000U)
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY_OFF_SHIFT (16U)
/*! TX_DELAY_OFF - Fine sample delay after TX_DELAY.
 */
#define XCVR_MISC_LCL_TX_CFG0_TX_DELAY_OFF(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG0_TX_DELAY_OFF_SHIFT)) & XCVR_MISC_LCL_TX_CFG0_TX_DELAY_OFF_MASK)
/*! @} */

/*! @name LCL_TX_CFG1 - LOCALIZATION CONTROL TX CONFIG1 */
/*! @{ */
#define XCVR_MISC_LCL_TX_CFG1_TX_SPINT_MASK      (0x1FU)
#define XCVR_MISC_LCL_TX_CFG1_TX_SPINT_SHIFT     (0U)
/*! TX_SPINT - Number of TX Samples that define the length of an Interval , where 0=1sample, 1=2sample, etc.
 */
#define XCVR_MISC_LCL_TX_CFG1_TX_SPINT(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG1_TX_SPINT_SHIFT)) & XCVR_MISC_LCL_TX_CFG1_TX_SPINT_MASK)
#define XCVR_MISC_LCL_TX_CFG1_TX_ANT_TRIG_SEL_MASK (0x700U)
#define XCVR_MISC_LCL_TX_CFG1_TX_ANT_TRIG_SEL_SHIFT (8U)
/*! TX_ANT_TRIG_SEL - Selects Trigger for TX
 *  0b000..Software Trigger
 *  0b001..Localization control: pattern found
 *  0b010..CRC Complete
 *  0b011..PA Warmup Complete
 *  0b100..RBME tx_done_pre
 */
#define XCVR_MISC_LCL_TX_CFG1_TX_ANT_TRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG1_TX_ANT_TRIG_SEL_SHIFT)) & XCVR_MISC_LCL_TX_CFG1_TX_ANT_TRIG_SEL_MASK)
#define XCVR_MISC_LCL_TX_CFG1_TX_HI_PER_MASK     (0x1F0000U)
#define XCVR_MISC_LCL_TX_CFG1_TX_HI_PER_SHIFT    (16U)
/*! TX_HI_PER - Number of intervals for antenna HIGH
 */
#define XCVR_MISC_LCL_TX_CFG1_TX_HI_PER(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG1_TX_HI_PER_SHIFT)) & XCVR_MISC_LCL_TX_CFG1_TX_HI_PER_MASK)
#define XCVR_MISC_LCL_TX_CFG1_TX_LO_PER_MASK     (0x1F000000U)
#define XCVR_MISC_LCL_TX_CFG1_TX_LO_PER_SHIFT    (24U)
/*! TX_LO_PER - Number of intervals for antenna LOW
 */
#define XCVR_MISC_LCL_TX_CFG1_TX_LO_PER(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_TX_CFG1_TX_LO_PER_SHIFT)) & XCVR_MISC_LCL_TX_CFG1_TX_LO_PER_MASK)
/*! @} */

/*! @name LCL_RX_CFG0 - LOCALIZATION CONTROL RX CONFIG0 */
/*! @{ */
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY_MASK      (0x7FFU)
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY_SHIFT     (0U)
/*! RX_DELAY - Interval delay before RX switching begins.
 */
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG0_RX_DELAY_SHIFT)) & XCVR_MISC_LCL_RX_CFG0_RX_DELAY_MASK)
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY_OFF_MASK  (0x1F0000U)
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY_OFF_SHIFT (16U)
/*! RX_DELAY_OFF - Fine sample delay after RX_DELAY.
 */
#define XCVR_MISC_LCL_RX_CFG0_RX_DELAY_OFF(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG0_RX_DELAY_OFF_SHIFT)) & XCVR_MISC_LCL_RX_CFG0_RX_DELAY_OFF_MASK)
/*! @} */

/*! @name LCL_RX_CFG1 - LOCALIZATION CONTROL RX CONFIG1 */
/*! @{ */
#define XCVR_MISC_LCL_RX_CFG1_RX_SPINT_MASK      (0x1FU)
#define XCVR_MISC_LCL_RX_CFG1_RX_SPINT_SHIFT     (0U)
/*! RX_SPINT - Number of RX Samples that define the length of an Interval , where 0=1sample, 1=2sample, etc.
 */
#define XCVR_MISC_LCL_RX_CFG1_RX_SPINT(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG1_RX_SPINT_SHIFT)) & XCVR_MISC_LCL_RX_CFG1_RX_SPINT_MASK)
#define XCVR_MISC_LCL_RX_CFG1_RX_ANT_TRIG_SEL_MASK (0x700U)
#define XCVR_MISC_LCL_RX_CFG1_RX_ANT_TRIG_SEL_SHIFT (8U)
/*! RX_ANT_TRIG_SEL - Selects Trigger for RX
 *  0b000..Software Trigger
 *  0b001..Localization control: pattern found
 *  0b010..CRC Complete
 *  0b011..CRC Pass
 *  0b100..GenericLL: cte_present
 *  0b101..PHY: aa_fnd_to_ll
 */
#define XCVR_MISC_LCL_RX_CFG1_RX_ANT_TRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG1_RX_ANT_TRIG_SEL_SHIFT)) & XCVR_MISC_LCL_RX_CFG1_RX_ANT_TRIG_SEL_MASK)
#define XCVR_MISC_LCL_RX_CFG1_RX_HI_PER_MASK     (0x1F0000U)
#define XCVR_MISC_LCL_RX_CFG1_RX_HI_PER_SHIFT    (16U)
/*! RX_HI_PER - Number of intervals for antenna HIGH
 */
#define XCVR_MISC_LCL_RX_CFG1_RX_HI_PER(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG1_RX_HI_PER_SHIFT)) & XCVR_MISC_LCL_RX_CFG1_RX_HI_PER_MASK)
#define XCVR_MISC_LCL_RX_CFG1_RX_LO_PER_MASK     (0x1F000000U)
#define XCVR_MISC_LCL_RX_CFG1_RX_LO_PER_SHIFT    (24U)
/*! RX_LO_PER - Number of intervals for antenna LOW
 */
#define XCVR_MISC_LCL_RX_CFG1_RX_LO_PER(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_RX_CFG1_RX_LO_PER_SHIFT)) & XCVR_MISC_LCL_RX_CFG1_RX_LO_PER_MASK)
/*! @} */

/*! @name LCL_PM_MSB - LOCALIZATION CONTROL PM MSB */
/*! @{ */
#define XCVR_MISC_LCL_PM_MSB_COMP_PATTERN_MSB_MASK (0xFFFFFFFFU)
#define XCVR_MISC_LCL_PM_MSB_COMP_PATTERN_MSB_SHIFT (0U)
/*! COMP_PATTERN_MSB - Upper bytes of pattern to be matched, bits 63:32
 */
#define XCVR_MISC_LCL_PM_MSB_COMP_PATTERN_MSB(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_PM_MSB_COMP_PATTERN_MSB_SHIFT)) & XCVR_MISC_LCL_PM_MSB_COMP_PATTERN_MSB_MASK)
/*! @} */

/*! @name LCL_PM_LSB - LOCALIZATION CONTROL PM LSB */
/*! @{ */
#define XCVR_MISC_LCL_PM_LSB_COMP_PATTERN_LSB_MASK (0xFFFFFFFFU)
#define XCVR_MISC_LCL_PM_LSB_COMP_PATTERN_LSB_SHIFT (0U)
/*! COMP_PATTERN_LSB - Lower bytes of pattern to be matched, bits 31:0
 */
#define XCVR_MISC_LCL_PM_LSB_COMP_PATTERN_LSB(x) (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_LCL_PM_LSB_COMP_PATTERN_LSB_SHIFT)) & XCVR_MISC_LCL_PM_LSB_COMP_PATTERN_LSB_MASK)
/*! @} */

/*! @name IPS_FO_ADDR - IPS FAST OVERWRITE ADDRESS */
/*! @{ */
#define XCVR_MISC_IPS_FO_ADDR_ADDR_MASK          (0xFFFU)
#define XCVR_MISC_IPS_FO_ADDR_ADDR_SHIFT         (0U)
/*! ADDR - IPS Address
 */
#define XCVR_MISC_IPS_FO_ADDR_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_IPS_FO_ADDR_ADDR_SHIFT)) & XCVR_MISC_IPS_FO_ADDR_ADDR_MASK)
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_RX_MASK      (0x1000U)
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_RX_SHIFT     (12U)
/*! ENTRY_RX - Enable Entry for RX
 */
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_RX(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_IPS_FO_ADDR_ENTRY_RX_SHIFT)) & XCVR_MISC_IPS_FO_ADDR_ENTRY_RX_MASK)
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_TX_MASK      (0x2000U)
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_TX_SHIFT     (13U)
/*! ENTRY_TX - Enable Entry for TX
 */
#define XCVR_MISC_IPS_FO_ADDR_ENTRY_TX(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_MISC_IPS_FO_ADDR_ENTRY_TX_SHIFT)) & XCVR_MISC_IPS_FO_ADDR_ENTRY_TX_MASK)
/*! @} */

/* The count of XCVR_MISC_IPS_FO_ADDR */
#define XCVR_MISC_IPS_FO_ADDR_COUNT              (8U)

/*! @name IPS_FO_DRS0_DATA - IPS FAST OVERWRITE DRS0 DATA */
/*! @{ */
#define XCVR_MISC_IPS_FO_DRS0_DATA_DRS0_DATA_MASK (0xFFFFFFFFU)
#define XCVR_MISC_IPS_FO_DRS0_DATA_DRS0_DATA_SHIFT (0U)
/*! DRS0_DATA - Fast Overwrite DRS0 data
 */
#define XCVR_MISC_IPS_FO_DRS0_DATA_DRS0_DATA(x)  (((uint32_t)(((uint32_